/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobMailRecipient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PersistentReportJobMailNotification {
    private long id;
    private int version = -1;
    private List recipients;
    private String subject;
    private String messageText;
    private byte resultSendType;
    private boolean skipEmptyReports;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public byte getResultSendType() {
        return this.resultSendType;
    }

    public void setResultSendType(byte resultSendType) {
        this.resultSendType = resultSendType;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List toAddresses) {
        this.recipients = toAddresses;
    }

    public void copyFrom(ReportJobMailNotification mailNotification) {
        this.copyRecipientsFrom(mailNotification);
        this.setSubject(mailNotification.getSubject());
        this.setMessageText(mailNotification.getMessageText());
        this.setResultSendType(mailNotification.getResultSendType());
        this.setSkipEmptyReports(mailNotification.isSkipEmptyReports());
    }

    protected void copyRecipientsFrom(ReportJobMailNotification mailNotification) {
        ArrayList newRecipients = new ArrayList();
        this.collectRecipients(newRecipients, mailNotification.getToAddresses(), (byte)1);
        this.collectRecipients(newRecipients, mailNotification.getCcAddresses(), (byte)2);
        this.collectRecipients(newRecipients, mailNotification.getBccAddresses(), (byte)3);
        this.setRecipients(newRecipients);
    }

    protected void collectRecipients(List recipientsList, List addresses, byte type) {
        if (addresses != null && !addresses.isEmpty()) {
            Iterator it = addresses.iterator();
            while (it.hasNext()) {
                String address = (String)it.next();
                PersistentReportJobMailRecipient recipient = new PersistentReportJobMailRecipient();
                recipient.setType(type);
                recipient.setAddress(address);
                recipientsList.add(recipient);
            }
        }
    }

    public ReportJobMailNotification toClient() {
        ReportJobMailNotification mail = new ReportJobMailNotification();
        mail.setId(this.getId());
        mail.setVersion(this.getVersion());
        this.copyAddressesTo(mail);
        mail.setSubject(this.getSubject());
        mail.setMessageText(this.getMessageText());
        mail.setResultSendType(this.getResultSendType());
        mail.setSkipEmptyReports(this.isSkipEmptyReports());
        return mail;
    }

    protected void copyAddressesTo(ReportJobMailNotification mail) {
        HashMap collectedAddresses = new HashMap();
        collectedAddresses.put(new Byte(1), new ArrayList());
        collectedAddresses.put(new Byte(3), new ArrayList());
        collectedAddresses.put(new Byte(2), new ArrayList());
        Iterator it = this.getRecipients().iterator();
        while (it.hasNext()) {
            PersistentReportJobMailRecipient recipient = (PersistentReportJobMailRecipient)it.next();
            ((List)collectedAddresses.get(new Byte(recipient.getType()))).add(recipient.getAddress());
        }
        mail.setToAddresses((List)collectedAddresses.get(new Byte(1)));
        mail.setCcAddresses((List)collectedAddresses.get(new Byte(2)));
        mail.setBccAddresses((List)collectedAddresses.get(new Byte(3)));
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }

    public boolean isSkipEmptyReports() {
        return this.skipEmptyReports;
    }

    public void setSkipEmptyReports(boolean skipEmptyReports) {
        this.skipEmptyReports = skipEmptyReports;
    }
}

