/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.CsvExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.PdfExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.XlsExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JExcelApiHyperlinkProducerFactory;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ContentResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ReportExecutionJob
implements Job {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportExecutionJob == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportExecutionJob = ReportExecutionJob.class$("com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJob")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportExecutionJob));
    public static final String REPORT_PARAMETER_SCHEDULED_TIME = "_ScheduledTime";
    public static final String REPOSITORY_FILENAME_SEQUENCE_SEPARATOR = "-";
    public static final String REPOSITORY_FILENAME_TIMESTAMP_SEQUENCE_PATTERN = "yyyyMMddHHmm";
    public static final String SCHEDULER_CONTEXT_KEY_APPLICATION_CONTEXT = "applicationContext";
    public static final String SCHEDULER_CONTEXT_KEY_JOB_PERSISTENCE_SERVICE = "jobPersistenceService";
    public static final String SCHEDULER_CONTEXT_KEY_ENGINE_SERVICE = "engineService";
    public static final String SCHEDULER_CONTEXT_KEY_VIRTUALIZER_FACTORY = "virtualizerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_REPOSITORY = "repositoryService";
    public static final String SCHEDULER_CONTEXT_KEY_MAIL_SENDER = "mailSender";
    public static final String SCHEDULER_CONTEXT_KEY_MAIL_FROM_ADDRESS = "mailFromAddress";
    public static final String SCHEDULER_CONTEXT_KEY_LOGGING_SERVICE = "loggingService";
    public static final String SCHEDULER_CONTEXT_KEY_SECURITY_CONTEXT_PROVIDER = "securityContextProvider";
    public static final String SCHEDULER_CONTEXT_KEY_HYPERLINK_PRODUCER_FACTORY = "hyperlinkProducerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_ENCODING_PROVIDER = "encodingProvider";
    public static final String SCHEDULER_CONTEXT_KEY_EXPORT_PARAMETRES_MAP = "exportParametersMap";
    public static final String JOB_DATA_KEY_DETAILS_ID = "jobDetailsID";
    public static final String JOB_DATA_KEY_USERNAME = "jobUser";
    public static final String LOGGING_COMPONENT = "reportScheduler";
    protected ApplicationContext applicationContext;
    protected String username;
    protected ReportJob jobDetails;
    protected JobExecutionContext jobContext;
    protected SchedulerContext schedulerContext;
    protected ExecutionContext executionContext;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportExecutionJob;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block11: {
            try {
                this.jobContext = context;
                this.schedulerContext = this.jobContext.getScheduler().getContext();
                this.applicationContext = (ApplicationContext)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_APPLICATION_CONTEXT);
                this.username = this.getUsername();
                SecurityContextProvider securityContextProvider = this.getSecurityContextProvider();
                securityContextProvider.setAuthenticatedUser(this.username);
                try {
                    this.executionContext = this.getExecutionContext();
                    this.jobDetails = this.getJobDetails();
                    this.initJobExecution();
                    this.executeAndSendReport();
                }
                catch (Throwable e) {
                    try {
                        this.handleException(e);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        securityContextProvider.revertAuthenticatedUser();
                    }
                }
                securityContextProvider.revertAuthenticatedUser();
            }
            catch (JobExecutionException e) {
                throw e;
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            finally {
                this.clear();
            }
        }
    }

    protected void initJobExecution() {
        this.updateExecutionContextDetails();
    }

    protected void clear() {
        this.jobContext = null;
        this.schedulerContext = null;
        this.jobDetails = null;
        this.executionContext = null;
        this.username = null;
    }

    protected String getUsername() {
        JobDataMap jobDataMap = this.jobContext.getTrigger().getJobDataMap();
        return jobDataMap.getString(JOB_DATA_KEY_USERNAME);
    }

    protected ExecutionContext getExecutionContext() {
        return new ExecutionContextImpl();
    }

    protected void updateExecutionContextDetails() {
        ((ExecutionContextImpl)this.executionContext).setLocale(this.getJobLocale());
    }

    protected Locale getJobLocale() {
        String localeCode = this.jobDetails.getOutputLocale();
        Locale locale = localeCode != null && localeCode.length() > 0 ? LocaleHelper.getInstance().getLocale(localeCode) : null;
        return locale;
    }

    protected void handleException(Throwable exc) throws JobExecutionException {
        log.error((Object)exc, exc);
        try {
            this.logException(exc);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.throwJobExecutionException(exc);
        }
        this.throwJobExecutionException(exc);
    }

    protected void throwJobExecutionException(Throwable exc) throws JobExecutionException {
        throw exc instanceof Exception ? new JobExecutionException((Exception)exc) : new JobExecutionException(exc.getMessage());
    }

    protected void logException(Throwable e) {
        LoggingService loggingService = this.getLoggingService();
        LogEvent event = loggingService.instantiateLogEvent();
        event.setComponent(LOGGING_COMPONENT);
        event.setType((byte)1);
        event.setMessageCode("log.error.report.job.failed");
        if (this.jobDetails != null) {
            event.setResourceURI(this.jobDetails.getSource().getReportUnitURI());
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (this.jobDetails != null) {
            printWriter.println("Job: " + this.jobDetails.getLabel() + " (ID: " + this.jobDetails.getId() + ")");
            printWriter.println("Report unit: " + this.jobDetails.getSource().getReportUnitURI());
        }
        printWriter.println("Quartz Job: " + this.jobContext.getJobDetail().getFullName());
        printWriter.println("Quartz Trigger: " + this.jobContext.getTrigger().getFullName());
        printWriter.println(e.getMessage());
        e.printStackTrace(printWriter);
        printWriter.flush();
        event.setText(writer.toString());
        event.setState((byte)1);
        loggingService.log(event);
    }

    protected SecurityContextProvider getSecurityContextProvider() {
        return (SecurityContextProvider)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_SECURITY_CONTEXT_PROVIDER);
    }

    protected LoggingService getLoggingService() {
        return (LoggingService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_LOGGING_SERVICE);
    }

    protected ReportJob getJobDetails() {
        ReportJobsPersistenceService persistenceService = this.getPersistenceService();
        JobDataMap jobDataMap = this.jobContext.getTrigger().getJobDataMap();
        long jobId = jobDataMap.getLong(JOB_DATA_KEY_DETAILS_ID);
        ReportJob job = persistenceService.loadJob(this.executionContext, new ReportJobIdHolder(jobId));
        return job;
    }

    protected ReportJobsPersistenceService getPersistenceService() {
        return (ReportJobsPersistenceService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_JOB_PERSISTENCE_SERVICE);
    }

    protected EngineService getEngineService() {
        EngineService engineService = (EngineService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ENGINE_SERVICE);
        return engineService;
    }

    protected VirtualizerFactory getVirtualizerFactory() {
        return (VirtualizerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_VIRTUALIZER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAndSendReport() throws JobExecutionException {
        ReportUnitResult result = null;
        try {
            result = this.executeReport();
            this.sendToDestinations(result);
        }
        finally {
            VirtualizerFactory virtualizerFactory;
            if (result != null && (virtualizerFactory = this.getVirtualizerFactory()) != null) {
                virtualizerFactory.disposeVirtualizer(result.getVirtualizer());
            }
        }
    }

    protected ReportUnitResult executeReport() {
        Map parametersMap = this.collectReportParameters();
        ReportUnitRequest request = new ReportUnitRequest(this.getReportUnitURI(), parametersMap);
        EngineService engineService = this.getEngineService();
        return (ReportUnitResult)engineService.execute(this.executionContext, (Request)request);
    }

    protected Map collectReportParameters() {
        HashMap params = new HashMap();
        Map jobParams = this.jobDetails.getSource().getParametersMap();
        if (jobParams != null) {
            params.putAll(jobParams);
        }
        this.putAdditionalParameters(params);
        return params;
    }

    protected void putAdditionalParameters(Map parametersMap) {
        VirtualizerFactory virtualizerFactory;
        if (!parametersMap.containsKey(REPORT_PARAMETER_SCHEDULED_TIME)) {
            Date scheduledFireTime = this.jobContext.getScheduledFireTime();
            parametersMap.put(REPORT_PARAMETER_SCHEDULED_TIME, scheduledFireTime);
        }
        if ((virtualizerFactory = this.getVirtualizerFactory()) != null) {
            parametersMap.put("REPORT_VIRTUALIZER", virtualizerFactory.getVirtualizer());
        }
    }

    protected void sendToDestinations(ReportUnitResult result) throws JobExecutionException {
        JasperPrint jasperPrint = result.getJasperPrint();
        String baseFilename = this.jobDetails.getBaseOutputFilename();
        if (this.jobDetails.getContentRepositoryDestination().isSequentialFilenames()) {
            Date scheduledTime = this.jobContext.getScheduledFireTime();
            SimpleDateFormat format = new SimpleDateFormat(REPOSITORY_FILENAME_TIMESTAMP_SEQUENCE_PATTERN);
            baseFilename = this.jobDetails.getBaseOutputFilename() + REPOSITORY_FILENAME_SEQUENCE_SEPARATOR + format.format(scheduledTime);
        } else {
            baseFilename = this.jobDetails.getBaseOutputFilename();
        }
        boolean sendMail = this.toSendMail(jasperPrint);
        ArrayList<ReportOutput> mailAttachments = null;
        if (sendMail) {
            boolean hasMailAttachments;
            ReportJobMailNotification mailNotification = this.jobDetails.getMailNotification();
            boolean bl = hasMailAttachments = mailNotification != null && mailNotification.getResultSendType() == 2;
            if (hasMailAttachments) {
                mailAttachments = new ArrayList<ReportOutput>();
            }
        }
        Set outputFormats = this.jobDetails.getOutputFormats();
        Iterator it = outputFormats.iterator();
        while (it.hasNext()) {
            Byte format = (Byte)it.next();
            ReportOutput output = this.getReportOutput(jasperPrint, format, baseFilename);
            this.saveToRepository(output);
            if (mailAttachments == null) continue;
            mailAttachments.add(output);
        }
        if (sendMail) {
            this.sendMailNotification(mailAttachments, this.jobDetails);
        }
    }

    protected boolean toSendMail(JasperPrint jasperPrint) {
        ReportJobMailNotification mailNotification = this.jobDetails.getMailNotification();
        return mailNotification != null && (!mailNotification.isSkipEmptyReports() || !this.isEmpty(jasperPrint));
    }

    protected boolean isEmpty(JasperPrint jasperPrint) {
        JRPrintPage page;
        List elements;
        List pages = jasperPrint.getPages();
        boolean empty = pages == null || pages.isEmpty() ? true : (pages.size() == 1 ? (elements = (page = (JRPrintPage)pages.get(0)).getElements()) == null || elements.isEmpty() : false);
        return empty;
    }

    protected ReportOutput getReportOutput(JasperPrint jasperPrint, byte format, String baseFilename) {
        ReportOutput output;
        switch (format) {
            case 1: {
                output = this.getPdfOutput(jasperPrint, baseFilename);
                break;
            }
            case 2: {
                output = this.getHtmlOutput(jasperPrint, baseFilename);
                break;
            }
            case 3: {
                output = this.getXlsOutput(jasperPrint, baseFilename);
                break;
            }
            case 4: {
                output = this.getRtfOutput(jasperPrint, baseFilename);
                break;
            }
            case 5: {
                output = this.getCsvOutput(jasperPrint, baseFilename);
                break;
            }
            default: {
                throw new JSException("jsexception.report.unknown.output.format", new Object[]{new Byte(format)});
            }
        }
        return output;
    }

    protected String getChildrenFolderName(String resourceName) {
        return this.getRepository().getChildrenFolderName(resourceName);
    }

    protected ReportOutput getPdfOutput(JasperPrint jasperPrint, String baseFilename) {
        Map localizedFontMap;
        HashMap<JRExporterParameter, Object> params = new HashMap<JRExporterParameter, Object>();
        params.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        params.put(JRExporterParameter.OUTPUT_STREAM, baos);
        PdfExportParametersBean exportParams = (PdfExportParametersBean)this.getExportParametersMap().get("pdf");
        String locale = LocaleContextHolder.getLocale().getLanguage();
        Map map = localizedFontMap = exportParams.getLocalizedFontMap().get(locale) != null ? (Map)exportParams.getLocalizedFontMap().get(locale) : (Map)exportParams.getLocalizedFontMap().get(locale.substring(0, 2));
        if (localizedFontMap != null) {
            params.put(JRExporterParameter.FONT_MAP, localizedFontMap);
        }
        this.getEngineService().exportToPdf(this.executionContext, this.getReportUnitURI(), params);
        byte[] pdfData = baos.toByteArray();
        String filename = baseFilename + ".pdf";
        return new ReportOutput(pdfData, "pdf", filename);
    }

    protected String getReportUnitURI() {
        return this.jobDetails.getSource().getReportUnitURI();
    }

    protected ReportOutput getHtmlOutput(JasperPrint jasperPrint, String baseFilename) {
        try {
            String filename = baseFilename + ".html";
            JRHtmlExporter exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bout);
            HashMap images = new HashMap();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, images);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(this.getChildrenFolderName(filename) + '/'));
            JRHyperlinkProducerFactory hyperlinkProducerFactory = this.getHyperlinkProducerFactory();
            if (hyperlinkProducerFactory != null) {
                exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)hyperlinkProducerFactory);
            }
            exporter.exportReport();
            byte[] htmlData = bout.toByteArray();
            ReportOutput htmlOutput = new ReportOutput(htmlData, "html", filename);
            Iterator it = images.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry imageEntry = it.next();
                String imageName = (String)imageEntry.getKey();
                byte[] imageData = (byte[])imageEntry.getValue();
                ReportOutput image = new ReportOutput(imageData, "html", imageName);
                htmlOutput.addChild(image);
            }
            return htmlOutput;
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected JRHyperlinkProducerFactory getHyperlinkProducerFactory() {
        JRHyperlinkProducerFactory engineService = (JRHyperlinkProducerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_HYPERLINK_PRODUCER_FACTORY);
        return engineService;
    }

    protected ReportOutput getXlsOutput(JasperPrint jasperPrint, String baseFilename) {
        try {
            JExcelApiExporter exporter = new JExcelApiExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bout);
            exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)JExcelApiHyperlinkProducerFactory.INSTANCE);
            exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
            XlsExportParametersBean exportParams = (XlsExportParametersBean)this.getExportParametersMap().get("xls");
            if (exportParams != null) {
                if (exportParams.getOnePagePerSheet() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.getOnePagePerSheet());
                if (exportParams.getDetectCellType() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.getDetectCellType());
                if (exportParams.getRemoveEmptySpaceBetweenRows() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.getRemoveEmptySpaceBetweenRows());
                if (exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)exportParams.getRemoveEmptySpaceBetweenColumns());
                if (exportParams.getWhitePageBackground() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.getWhitePageBackground());
                if (exportParams.getIgnoreGraphics() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, (Object)exportParams.getIgnoreGraphics());
                if (exportParams.getCollapseRowSpan() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)exportParams.getCollapseRowSpan());
                if (exportParams.getIgnoreCellBorder() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, (Object)exportParams.getIgnoreCellBorder());
                if (exportParams.getFontSizeFixEnabled() != null) {
                    // empty if block
                }
                exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)exportParams.getFontSizeFixEnabled());
                if (exportParams.getMaximumRowsPerSheet() != null) {
                    // empty if block
                }
                exporter.setParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)exportParams.getMaximumRowsPerSheet());
                if (exportParams.getXlsFormatPatternsMap() == null || !exportParams.getXlsFormatPatternsMap().isEmpty()) {
                    // empty if block
                }
                exporter.setParameter(JRXlsAbstractExporterParameter.FORMAT_PATTERNS_MAP, (Object)exportParams.getXlsFormatPatternsMap());
            }
            exporter.exportReport();
            byte[] xlsData = bout.toByteArray();
            String filename = baseFilename + ".xls";
            return new ReportOutput(xlsData, "xls", filename);
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected ReportOutput getRtfOutput(JasperPrint jasperPrint, String baseFilename) {
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bout);
            exporter.exportReport();
            byte[] rtfData = bout.toByteArray();
            String fileName = baseFilename + ".rtf";
            return new ReportOutput(rtfData, "rtf", fileName);
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected ReportOutput getCsvOutput(JasperPrint jasperPrint, String baseFilename) {
        try {
            JRCsvExporter exporter = new JRCsvExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bout);
            CsvExportParametersBean exportParams = (CsvExportParametersBean)this.getExportParametersMap().get("csv");
            if (exportParams != null) {
                exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)exportParams.getFieldDelimiter());
            }
            exporter.exportReport();
            byte[] csvData = bout.toByteArray();
            String fileName = baseFilename + ".csv";
            return new ReportOutput(csvData, "csv", fileName);
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected void saveToRepository(ReportOutput output) {
        String resURI;
        Resource res;
        RepositoryService repositoryService = this.getRepository();
        ReportJobRepositoryDestination repositoryDestination = this.jobDetails.getContentRepositoryDestination();
        List children = output.getChildren();
        ArrayList<ContentResourceImpl> childResources = new ArrayList<ContentResourceImpl>(children.size());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ReportOutput childOutput = (ReportOutput)it.next();
            ContentResourceImpl childRes = new ContentResourceImpl();
            childRes.setName(childOutput.getFilename());
            childRes.setLabel(childOutput.getFilename());
            childRes.setFileType(childOutput.getFileType());
            childRes.setData(childOutput.getData());
            childResources.add(childRes);
        }
        ContentResourceImpl contentRes = null;
        if (repositoryDestination.isOverwriteFiles() && (res = repositoryService.getResource(this.executionContext, resURI = repositoryDestination.getFolderURI() + "/" + output.getFilename())) != null) {
            if (!(res instanceof ContentResource)) {
                String quotedResURI = "\"" + resURI + "\"";
                throw new JSException("jsexception.report.no.content.resource", new Object[]{quotedResURI});
            }
            contentRes = (ContentResource)res;
        }
        if (contentRes == null) {
            contentRes = new ContentResourceImpl();
            contentRes.setName(output.getFilename());
            contentRes.setLabel(this.jobDetails.getBaseOutputFilename());
            contentRes.setParentFolder(repositoryDestination.getFolderURI());
        }
        contentRes.setFileType(output.getFileType());
        contentRes.setData(output.getData());
        contentRes.setResources(childResources);
        repositoryService.saveResource(null, (Resource)contentRes);
    }

    protected RepositoryService getRepository() {
        RepositoryService repositoryService = (RepositoryService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPOSITORY);
        return repositoryService;
    }

    protected void sendMailNotification(List mailAttachments, ReportJob job) throws JobExecutionException {
        ReportJobMailNotification mailNotification = job.getMailNotification();
        if (mailNotification != null) {
            JavaMailSender mailSender = this.getMailSender();
            String fromAddress = this.getFromAddress();
            try {
                MimeMessage message = mailSender.createMimeMessage();
                MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, this.getCharacterEncoding());
                messageHelper.setFrom(fromAddress);
                messageHelper.setSubject(mailNotification.getSubject());
                messageHelper.setText(mailNotification.getMessageText());
                this.addMailRecipients(mailNotification, messageHelper);
                if (mailAttachments != null) {
                    Iterator it = mailAttachments.iterator();
                    while (it.hasNext()) {
                        ReportOutput output = (ReportOutput)it.next();
                        this.attachOutput(messageHelper, output);
                    }
                }
                mailSender.send(message);
            }
            catch (MessagingException e) {
                log.error((Object)"Error while sending report job result mail", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
    }

    protected String getCharacterEncoding() {
        CharacterEncodingProvider encodingProvider = (CharacterEncodingProvider)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ENCODING_PROVIDER);
        return encodingProvider.getCharacterEncoding();
    }

    protected void addMailRecipients(ReportJobMailNotification mailNotification, MimeMessageHelper messageHelper) throws MessagingException {
        List bccAddresses;
        List ccAddresses;
        List toAddresses = mailNotification.getToAddresses();
        if (toAddresses != null && !toAddresses.isEmpty()) {
            String[] addressArray = new String[toAddresses.size()];
            toAddresses.toArray(addressArray);
            messageHelper.setTo(addressArray);
        }
        if ((ccAddresses = mailNotification.getCcAddresses()) != null && !ccAddresses.isEmpty()) {
            String[] addressArray = new String[ccAddresses.size()];
            ccAddresses.toArray(addressArray);
            messageHelper.setCc(addressArray);
        }
        if ((bccAddresses = mailNotification.getBccAddresses()) != null && !bccAddresses.isEmpty()) {
            String[] addressArray = new String[bccAddresses.size()];
            bccAddresses.toArray(addressArray);
            messageHelper.setBcc(addressArray);
        }
    }

    protected void attachOutput(MimeMessageHelper messageHelper, ReportOutput output) throws MessagingException, JobExecutionException {
        byte[] attachmentData;
        String attachmentName;
        if (output.getChildren().isEmpty()) {
            attachmentName = output.getFilename();
            attachmentData = output.getData();
        } else {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(bout);
            try {
                zipOut.putNextEntry(new ZipEntry(output.getFilename()));
                zipOut.write(output.getData());
                zipOut.closeEntry();
                Iterator it = output.getChildren().iterator();
                while (it.hasNext()) {
                    ReportOutput child = (ReportOutput)it.next();
                    String childName = this.getChildrenFolderName(output.getFilename()) + '/' + child.getFilename();
                    zipOut.putNextEntry(new ZipEntry(childName));
                    zipOut.write(child.getData());
                    zipOut.closeEntry();
                }
                zipOut.finish();
                ((FilterOutputStream)zipOut).flush();
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            attachmentData = bout.toByteArray();
            attachmentName = output.getFilename() + ".zip";
        }
        try {
            attachmentName = MimeUtility.encodeWord((String)attachmentName, (String)this.getCharacterEncoding(), null);
            messageHelper.addAttachment(attachmentName, (InputStreamSource)new ByteArrayResource(attachmentData));
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
        }
    }

    protected String getFromAddress() {
        String fromAddress = (String)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_MAIL_FROM_ADDRESS);
        return fromAddress;
    }

    protected JavaMailSender getMailSender() {
        JavaMailSender mailSender = (JavaMailSender)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_MAIL_SENDER);
        return mailSender;
    }

    protected Map getExportParametersMap() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_EXPORT_PARAMETRES_MAP);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ReportOutput {
        private final byte[] data;
        private final String fileType;
        private final String filename;
        private final List children;

        public ReportOutput(byte[] data, String fileType, String filename) {
            this.data = data;
            this.fileType = fileType;
            this.filename = filename;
            this.children = new ArrayList();
        }

        public byte[] getData() {
            return this.data;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getFileType() {
            return this.fileType;
        }

        public List getChildren() {
            return this.children;
        }

        public void addChild(ReportOutput child) {
            this.children.add(child);
        }
    }
}

