/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsScheduler;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulerListener;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.TriggerUtils;
import org.springframework.beans.factory.InitializingBean;

public class ReportJobsQuartzScheduler
implements ReportJobsScheduler,
InitializingBean {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportJobsQuartzScheduler == null ? (class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportJobsQuartzScheduler = ReportJobsQuartzScheduler.class$("com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportJobsQuartzScheduler")) : class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportJobsQuartzScheduler));
    private static final String GROUP = "ReportJobs";
    private static final String TRIGGER_LISTENER_NAME = "reportSchedulerTriggerListener";
    private static final long COEFFICIENT_MINUTE = 60000L;
    private static final long COEFFICIENT_HOUR = 3600000L;
    private static final long COEFFICIENT_DAY = 86400000L;
    private static final long COEFFICIENT_WEEK = 604800000L;
    private static final int COUNT_WEEKDAYS = 7;
    private static final int COUNT_MONTHS = 12;
    private Scheduler scheduler;
    private Class reportExecutionJobClass;
    private final Set listeners = new HashSet();
    private final SchedulerListener schedulerListener = new ReportSchedulerQuartzListener();
    private final TriggerListener triggerListener = new ReportSchedulerTriggerListener("reportSchedulerTriggerListener");
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$engine$scheduling$quartz$ReportJobsQuartzScheduler;

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Class getReportExecutionJobClass() {
        return this.reportExecutionJobClass;
    }

    public void setReportExecutionJobClass(Class reportExecutionJobClass) {
        this.reportExecutionJobClass = reportExecutionJobClass;
    }

    public void afterPropertiesSet() {
        try {
            this.getScheduler().addSchedulerListener(this.schedulerListener);
            this.getScheduler().addTriggerListener(this.triggerListener);
        }
        catch (SchedulerException e) {
            log.error((Object)"Error (de)registering Quartz listener", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public void scheduleJob(ExecutionContext context, ReportJob job) {
        JobDetail jobDetail = this.createJobDetail(job);
        Trigger trigger = this.createTrigger(job);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created job " + jobDetail.getFullName() + " and trigger " + trigger.getFullName() + " for job " + job.getId()));
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error scheduling Quartz job", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected JobDetail createJobDetail(ReportJob job) {
        String jobName = this.jobName(job.getId());
        JobDetail jobDetail = new JobDetail(jobName, GROUP, this.getReportExecutionJobClass(), false, false, false);
        return jobDetail;
    }

    public void rescheduleJob(ExecutionContext context, ReportJob job) {
        try {
            Trigger oldTrigger = this.getReportJobTrigger(job.getId());
            String jobName = this.jobName(job.getId());
            Trigger trigger = this.createTrigger(job);
            trigger.setJobName(jobName);
            trigger.setJobGroup(GROUP);
            if (oldTrigger == null) {
                this.scheduler.scheduleJob(trigger);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduled trigger " + trigger.getFullName() + " for job " + job.getId()));
                }
            } else {
                this.scheduler.rescheduleJob(oldTrigger.getName(), oldTrigger.getGroup(), trigger);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trigger " + oldTrigger.getFullName() + " rescheduled by " + trigger.getFullName() + " for job " + job.getId()));
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error rescheduling Quartz job", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected Trigger getReportJobTrigger(long jobId) throws SchedulerException {
        Trigger trigger;
        String jobName = this.jobName(jobId);
        Trigger[] triggers = this.scheduler.getTriggersOfJob(jobName, GROUP);
        if (triggers == null || triggers.length == 0) {
            trigger = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("No trigger found for job " + jobId));
            }
        } else if (triggers.length == 1) {
            trigger = triggers[0];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trigger " + trigger.getFullName() + " found for job " + jobId));
            }
        } else {
            throw new JSException("jsexception.job.has.more.than.one.trigger", new Object[]{new Long(jobId)});
        }
        return trigger;
    }

    protected String jobName(long jobId) {
        return "job_" + jobId;
    }

    protected String triggerName(ReportJobTrigger jobTrigger) {
        return "trigger_" + jobTrigger.getId() + "_" + jobTrigger.getVersion();
    }

    protected Trigger createTrigger(ReportJob reportJob) {
        Trigger trigger;
        ReportJobTrigger jobTrigger = reportJob.getTrigger();
        if (jobTrigger instanceof ReportJobSimpleTrigger) {
            trigger = this.createTrigger((ReportJobSimpleTrigger)jobTrigger);
        } else if (jobTrigger instanceof ReportJobCalendarTrigger) {
            trigger = this.createTrigger((ReportJobCalendarTrigger)jobTrigger);
        } else {
            String quotedJobTrigger = "\"" + jobTrigger.getClass().getName() + "\"";
            throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedJobTrigger});
        }
        JobDataMap jobDataMap = trigger.getJobDataMap();
        jobDataMap.put((Object)"jobDetailsID", (Object)new Long(reportJob.getId()));
        jobDataMap.put("jobUser", reportJob.getUsername());
        trigger.addTriggerListener(TRIGGER_LISTENER_NAME);
        return trigger;
    }

    protected Trigger createTrigger(ReportJobSimpleTrigger jobTrigger) {
        SimpleTrigger trigger;
        String triggerName = this.triggerName((ReportJobTrigger)jobTrigger);
        Date startDate = this.getStartDate((ReportJobTrigger)jobTrigger);
        Date endDate = this.getEndDate((ReportJobTrigger)jobTrigger);
        int repeatCount = this.repeatCount(jobTrigger);
        if (repeatCount == 0) {
            trigger = new SimpleTrigger(triggerName, GROUP, startDate);
        } else {
            int recurrenceInterval = jobTrigger.getRecurrenceInterval();
            switch (jobTrigger.getRecurrenceIntervalUnit()) {
                case 1: {
                    trigger = new SimpleTrigger(triggerName, GROUP, startDate, endDate, repeatCount, (long)recurrenceInterval * 60000L);
                    break;
                }
                case 2: {
                    trigger = new SimpleTrigger(triggerName, GROUP, startDate, endDate, repeatCount, (long)recurrenceInterval * 3600000L);
                    break;
                }
                case 3: {
                    trigger = new SimpleTrigger(triggerName, GROUP, startDate, endDate, repeatCount, (long)recurrenceInterval * 86400000L);
                    break;
                }
                case 4: {
                    trigger = new SimpleTrigger(triggerName, GROUP, startDate, endDate, repeatCount, (long)recurrenceInterval * 604800000L);
                    break;
                }
                default: {
                    throw new JSException("jsexception.job.unknown.interval.unit", new Object[]{jobTrigger.getRecurrenceIntervalUnit()});
                }
            }
        }
        trigger.setMisfireInstruction(4);
        return trigger;
    }

    protected Date getEndDate(ReportJobTrigger jobTrigger) {
        return this.translateFromTriggerTimeZone(jobTrigger, jobTrigger.getEndDate());
    }

    protected Date translateFromTriggerTimeZone(ReportJobTrigger jobTrigger, Date date) {
        TimeZone tz;
        if (date != null && (tz = this.getTriggerTimeZone(jobTrigger)) != null) {
            date = TriggerUtils.translateTime((Date)date, (TimeZone)TimeZone.getDefault(), (TimeZone)tz);
        }
        return date;
    }

    protected Date getStartDate(ReportJobTrigger jobTrigger) {
        Date startDate;
        switch (jobTrigger.getStartType()) {
            case 1: {
                startDate = new Date();
                break;
            }
            case 2: {
                startDate = this.translateFromTriggerTimeZone(jobTrigger, jobTrigger.getStartDate());
                break;
            }
            default: {
                throw new JSException("jsexception.job.unknown.start.type", new Object[]{new Byte(jobTrigger.getStartType())});
            }
        }
        return startDate;
    }

    protected int repeatCount(ReportJobSimpleTrigger jobTrigger) {
        int repeatCount;
        int recurrenceCount = jobTrigger.getOccurrenceCount();
        switch (recurrenceCount) {
            case -1: {
                repeatCount = SimpleTrigger.REPEAT_INDEFINITELY;
                break;
            }
            default: {
                repeatCount = recurrenceCount - 1;
            }
        }
        return repeatCount;
    }

    protected Trigger createTrigger(ReportJobCalendarTrigger jobTrigger) {
        String triggerName = this.triggerName((ReportJobTrigger)jobTrigger);
        Date startDate = this.getStartDate((ReportJobTrigger)jobTrigger);
        Date endDate = this.getEndDate((ReportJobTrigger)jobTrigger);
        String cronExpression = this.getCronExpression(jobTrigger);
        try {
            CronTrigger trigger = new CronTrigger(triggerName, GROUP, cronExpression);
            trigger.setStartTime(startDate);
            trigger.setEndTime(endDate);
            trigger.setMisfireInstruction(2);
            TimeZone timeZone = this.getTriggerTimeZone((ReportJobTrigger)jobTrigger);
            if (timeZone != null) {
                trigger.setTimeZone(timeZone);
            }
            return trigger;
        }
        catch (ParseException e) {
            log.error((Object)"Error creating Quartz Cron trigger", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected TimeZone getTriggerTimeZone(ReportJobTrigger jobTrigger) {
        TimeZone tz;
        String tzId = jobTrigger.getTimezone();
        if (tzId == null || tzId.length() == 0) {
            tz = null;
        } else {
            tz = TimeZone.getTimeZone(tzId);
            if (tz == null) {
                String quotedTzId = "\"" + tzId + "\"";
                throw new JSException("jsexception.unknown.timezone", new Object[]{quotedTzId});
            }
        }
        return tz;
    }

    protected String getCronExpression(ReportJobCalendarTrigger jobTrigger) {
        String monthDays;
        String weekDays;
        String minutes = jobTrigger.getMinutes();
        String hours = jobTrigger.getHours();
        switch (jobTrigger.getDaysType()) {
            case 1: {
                weekDays = "?";
                monthDays = "*";
                break;
            }
            case 2: {
                weekDays = this.enumerateCronVals(jobTrigger.getWeekDays(), 7);
                monthDays = "?";
                break;
            }
            case 3: {
                weekDays = "?";
                monthDays = jobTrigger.getMonthDays();
                break;
            }
            default: {
                throw new JSException("jsexception.job.unknown.calendar.trigger.days.type", new Object[]{new Byte(jobTrigger.getDaysType())});
            }
        }
        String months = this.enumerateCronVals(jobTrigger.getMonths(), 12);
        StringBuffer cronExpression = new StringBuffer();
        cronExpression.append("0 ");
        cronExpression.append(minutes);
        cronExpression.append(' ');
        cronExpression.append(hours);
        cronExpression.append(' ');
        cronExpression.append(monthDays);
        cronExpression.append(' ');
        cronExpression.append(months);
        cronExpression.append(' ');
        cronExpression.append(weekDays);
        return cronExpression.toString();
    }

    protected String enumerateCronVals(SortedSet vals, int totalCount) {
        if (vals == null || vals.isEmpty()) {
            throw new JSException("jsexception.no.values.to.enumerate");
        }
        if (vals.size() == totalCount) {
            return "*";
        }
        StringBuffer enumStr = new StringBuffer();
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            Byte val = (Byte)it.next();
            enumStr.append(val.byteValue());
            enumStr.append(',');
        }
        return enumStr.substring(0, enumStr.length() - 1);
    }

    public void removeScheduledJob(ExecutionContext context, long jobId) {
        try {
            String jobName = this.jobName(jobId);
            if (this.scheduler.deleteJob(jobName, GROUP)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Job " + jobName + "deleted"));
                }
            } else {
                log.info((Object)("Quartz job " + jobId + " was not found to be deleted"));
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Error deleting Quartz job " + jobId), (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public ReportJobRuntimeInformation[] getJobsRuntimeInformation(ExecutionContext context, long[] jobIds) {
        if (jobIds == null) {
            return null;
        }
        try {
            Set executingJobNames = this.getExecutingJobNames();
            ReportJobRuntimeInformation[] infos = new ReportJobRuntimeInformation[jobIds.length];
            for (int i = 0; i < jobIds.length; ++i) {
                infos[i] = this.getJobRuntimeInformation(jobIds[i], executingJobNames);
            }
            return infos;
        }
        catch (SchedulerException e) {
            log.error((Object)"Error while fetching Quartz runtime information", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected ReportJobRuntimeInformation getJobRuntimeInformation(long jobId, Set executingJobNames) throws SchedulerException {
        ReportJobRuntimeInformation info = new ReportJobRuntimeInformation();
        Trigger trigger = this.getReportJobTrigger(jobId);
        if (trigger == null) {
            info.setState((byte)0);
        } else {
            info.setPreviousFireTime(trigger.getPreviousFireTime());
            if (trigger.mayFireAgain()) {
                info.setNextFireTime(trigger.getNextFireTime());
            }
            byte state = this.getJobState(trigger, executingJobNames);
            info.setState(state);
        }
        return info;
    }

    protected byte getJobState(Trigger trigger, Set executingJobNames) throws SchedulerException {
        int state;
        int quartzState = this.scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
        switch (quartzState) {
            case 0: 
            case 4: {
                state = executingJobNames.contains(trigger.getJobName()) ? 2 : 1;
                break;
            }
            case 2: {
                state = 4;
                break;
            }
            case 1: {
                state = 3;
                break;
            }
            case 3: {
                state = 5;
                break;
            }
            default: {
                state = 0;
            }
        }
        return (byte)state;
    }

    protected Set getExecutingJobNames() throws SchedulerException {
        List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
        HashSet<String> executingJobNames = new HashSet<String>();
        Iterator iter = executingJobs.iterator();
        while (iter.hasNext()) {
            JobExecutionContext executionContext = (JobExecutionContext)iter.next();
            JobDetail jobDetail = executionContext.getJobDetail();
            if (!jobDetail.getGroup().equals(GROUP)) continue;
            executingJobNames.add(jobDetail.getName());
        }
        return executingJobNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReportSchedulerListener(ReportSchedulerListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeReportSchedulerListener(ReportSchedulerListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersOfFinalizedJob(long jobId) {
        Set set = this.listeners;
        synchronized (set) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ReportSchedulerListener listener = (ReportSchedulerListener)it.next();
                listener.reportJobFinalized(jobId);
            }
        }
    }

    protected void reportTriggerFinalized(Trigger trigger) {
        long jobId = trigger.getJobDataMap().getLong("jobDetailsID");
        this.notifyListenersOfFinalizedJob(jobId);
    }

    public void validate(ReportJob job, ValidationErrors errors) {
        Trigger quartzTrigger = this.createTrigger(job);
        Date firstFireTime = quartzTrigger.computeFirstFireTime(null);
        if (firstFireTime == null) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.trigger.no.fire", null, null, "trigger"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ReportSchedulerTriggerListener
    implements TriggerListener {
        private final String name;

        public ReportSchedulerTriggerListener(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void triggerFired(Trigger trigger, JobExecutionContext context) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger fired " + trigger.getFullName()));
            }
        }

        public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
            return false;
        }

        public void triggerMisfired(Trigger trigger) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger misfired " + trigger.getFullName()));
            }
            if (trigger.getGroup().equals(ReportJobsQuartzScheduler.GROUP) && trigger.getFireTimeAfter(new Date()) == null) {
                ReportJobsQuartzScheduler.this.reportTriggerFinalized(trigger);
            }
        }

        public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger complete " + trigger.getFullName() + " " + triggerInstructionCode));
            }
        }
    }

    protected class ReportSchedulerQuartzListener
    implements SchedulerListener {
        public void jobScheduled(Trigger trigger) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job " + trigger.getFullJobName() + " scheduled by trigger " + trigger.getFullName()));
            }
        }

        public void jobUnscheduled(String name, String group) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job unscheduled " + group + "." + name));
            }
        }

        public void triggerFinalized(Trigger trigger) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger finalized " + trigger.getFullName()));
            }
            if (trigger.getGroup().equals(ReportJobsQuartzScheduler.GROUP)) {
                ReportJobsQuartzScheduler.this.reportTriggerFinalized(trigger);
            }
        }

        public void triggersPaused(String name, String group) {
        }

        public void triggersResumed(String name, String group) {
        }

        public void jobsPaused(String name, String group) {
        }

        public void jobsResumed(String name, String group) {
        }

        public void schedulerError(String msg, SchedulerException cause) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Quartz scheduler error: " + msg), (Throwable)cause);
            }
        }

        public void schedulerShutdown() {
            if (log.isInfoEnabled()) {
                log.info((Object)"Quartz scheduler shutdown");
            }
        }
    }
}

