/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.CommandHelp;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import com.jaspersoft.jasperserver.export.util.CommandUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class BaseExportImportCommand {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$BaseExportImportCommand == null ? (class$com$jaspersoft$jasperserver$export$BaseExportImportCommand = BaseExportImportCommand.class$("com.jaspersoft.jasperserver.export.BaseExportImportCommand")) : class$com$jaspersoft$jasperserver$export$BaseExportImportCommand));
    protected static final CommandOut commandOut = CommandOut.getInstance();
    public static final String ARG_CONFIG_FILES = "configFiles";
    public static final String ARG_CONFIG_RESOURCES = "configResources";
    public static final String ARG_COMMAND_BEAN = "commandBean";
    public static final String ARG_HELP = "help";
    private final String defaultBeanName;
    private final String helpBeanName;
    protected static final SpringResourceFactory fileSystemResourceFactory = new SpringResourceFactory(){

        public Resource create(String location) {
            commandOut.debug("Loading Spring configuration file " + location);
            return new FileSystemResource(location);
        }
    };
    protected static final SpringResourceFactory classPathResourceFactory = new SpringResourceFactory(){

        public Resource create(String location) {
            commandOut.debug("Loading Spring configuration classpath resource " + location);
            return new ClassPathResource(location);
        }
    };
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$BaseExportImportCommand;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$CommandBean;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$CommandHelp;

    protected BaseExportImportCommand(String defaultBeanName, String helpBeanName) {
        this.defaultBeanName = defaultBeanName;
        this.helpBeanName = helpBeanName;
    }

    protected static void debugArgs(String[] args) {
        if (log.isDebugEnabled()) {
            for (int i = 0; i < args.length; ++i) {
                log.debug((Object)("arg #" + i + " = \"" + args[i] + "\""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(String[] args) {
        Parameters exportParameters = this.parseArgs(args);
        ConfigurableApplicationContext ctx = this.createSpringContext(exportParameters);
        try {
            if (exportParameters.hasParameter(ARG_HELP)) {
                CommandHelp helpBean = this.getHelpBean((ApplicationContext)ctx);
                helpBean.printHelp(args[0], System.out);
            } else {
                CommandBean commandBean = this.getCommandBean(exportParameters, (ApplicationContext)ctx);
                commandBean.process(exportParameters);
            }
        }
        finally {
            ctx.close();
        }
    }

    protected Parameters parseArgs(String[] args) {
        Parameters exportParameters = CommandUtils.parse(args);
        return exportParameters;
    }

    protected ConfigurableApplicationContext createSpringContext(Parameters exportParameters) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader configReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        this.registerConfig(exportParameters.getParameterValues(ARG_CONFIG_FILES), configReader, fileSystemResourceFactory);
        this.registerConfig(exportParameters.getParameterValues(ARG_CONFIG_RESOURCES), configReader, classPathResourceFactory);
        ctx.refresh();
        return ctx;
    }

    protected void registerConfig(String[] locations, XmlBeanDefinitionReader reader, SpringResourceFactory resourceFactory) {
        if (locations != null && locations.length > 0) {
            for (int i = 0; i < locations.length; ++i) {
                String location = locations[i];
                Resource resource = resourceFactory.create(location);
                reader.loadBeanDefinitions(resource);
            }
        }
    }

    protected String getConfigSeparator() {
        return System.getProperty("path.separator");
    }

    protected CommandBean getCommandBean(Parameters exportParameters, ApplicationContext ctx) {
        String beanName = this.getCommandBeanName(exportParameters);
        return (CommandBean)ctx.getBean(beanName, class$com$jaspersoft$jasperserver$export$CommandBean == null ? (class$com$jaspersoft$jasperserver$export$CommandBean = BaseExportImportCommand.class$("com.jaspersoft.jasperserver.export.CommandBean")) : class$com$jaspersoft$jasperserver$export$CommandBean);
    }

    protected CommandHelp getHelpBean(ApplicationContext ctx) {
        return (CommandHelp)ctx.getBean(this.helpBeanName, class$com$jaspersoft$jasperserver$export$CommandHelp == null ? (class$com$jaspersoft$jasperserver$export$CommandHelp = BaseExportImportCommand.class$("com.jaspersoft.jasperserver.export.CommandHelp")) : class$com$jaspersoft$jasperserver$export$CommandHelp);
    }

    protected String getCommandBeanName(Parameters exportParameters) {
        String beanName = exportParameters.getParameterValue(ARG_COMMAND_BEAN);
        if (beanName == null) {
            commandOut.debug("Using default " + this.defaultBeanName + " command bean");
            beanName = this.defaultBeanName;
        } else {
            commandOut.debug("Using " + beanName + " command bean");
        }
        return beanName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface SpringResourceFactory {
        public Resource create(String var1);
    }
}

