/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.export.CommandHelp;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;

public class CommandHelpImpl
implements CommandHelp,
InitializingBean {
    private static final Pattern LINE_SPLITTER_PATTERN = Pattern.compile("\\n", 8);
    private static final char SPACE = ' ';
    private MessageSource messageSource;
    private String startMessage;
    private String argDescriptionMessagePrefix;
    private List argumentNames;
    private String argLinePrefix;
    private String argLineSeparator;
    private int maxArgNameLength;
    private String descContPrefix;

    public void afterPropertiesSet() throws Exception {
        this.computeMaxArgNameLength();
        this.computeDescContPrefix();
    }

    protected void computeMaxArgNameLength() {
        this.maxArgNameLength = 0;
        Iterator i = this.argumentNames.iterator();
        while (i.hasNext()) {
            String argName = (String)i.next();
            if (argName.length() <= this.maxArgNameLength) continue;
            this.maxArgNameLength = argName.length();
        }
    }

    protected void computeDescContPrefix() {
        int length = this.argLinePrefix.length() + "--".length() + this.maxArgNameLength + this.argLineSeparator.length();
        char[] c = new char[length];
        Arrays.fill(c, ' ');
        this.descContPrefix = new String(c);
    }

    public void printHelp(String command, PrintStream out) {
        String header = this.messageSource.getMessage(this.startMessage, (Object[])new String[]{command}, this.getLocale());
        out.println(header);
        Iterator iter = this.argumentNames.iterator();
        while (iter.hasNext()) {
            String argName = (String)iter.next();
            String argDescription = this.messageSource.getMessage(this.getArgDescriptionMessagePrefix() + argName, null, this.getLocale());
            this.printArgumentHelp(out, argName, argDescription);
        }
        out.println();
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected void printArgumentHelp(PrintStream out, String argName, String argDescription) {
        out.print(this.argLinePrefix);
        out.print("--");
        out.print(argName);
        for (int i = argName.length(); i < this.maxArgNameLength; ++i) {
            out.print(' ');
        }
        out.print(this.argLineSeparator);
        String[] descLines = LINE_SPLITTER_PATTERN.split(argDescription, -1);
        if (descLines.length > 0) {
            out.print(descLines[0]);
            for (int i = 1; i < descLines.length; ++i) {
                out.println();
                out.print(this.descContPrefix);
                out.print(descLines[i]);
            }
        }
        out.println();
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public List getArgumentNames() {
        return this.argumentNames;
    }

    public void setArgumentNames(List argumentNames) {
        this.argumentNames = argumentNames;
    }

    public String getArgDescriptionMessagePrefix() {
        return this.argDescriptionMessagePrefix;
    }

    public void setArgDescriptionMessagePrefix(String argDescriptionMessagePrefix) {
        this.argDescriptionMessagePrefix = argDescriptionMessagePrefix;
    }

    public String getArgLinePrefix() {
        return this.argLinePrefix;
    }

    public void setArgLinePrefix(String argLinePrefix) {
        this.argLinePrefix = argLinePrefix;
    }

    public String getArgLineSeparator() {
        return this.argLineSeparator;
    }

    public void setArgLineSeparator(String argLineSeparator) {
        this.argLineSeparator = argLineSeparator;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public void setStartMessage(String startMessage) {
        this.startMessage = startMessage;
    }
}

