/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.BaseExporterImporter;
import com.jaspersoft.jasperserver.export.ExportTask;
import com.jaspersoft.jasperserver.export.Exporter;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.modules.ExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ExporterImpl
extends BaseExporterImporter
implements Exporter {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$ExporterImpl == null ? (class$com$jaspersoft$jasperserver$export$ExporterImpl = ExporterImpl.class$("com.jaspersoft.jasperserver.export.ExporterImpl")) : class$com$jaspersoft$jasperserver$export$ExporterImpl));
    private String xmlVersion;
    protected ExportTask task;
    protected ExportOutput output;
    private Element indexRootElement;
    private Map moduleIndexElements;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$ExporterImpl;

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public Element getIndexRootElement() {
        return this.indexRootElement;
    }

    protected Element getIndexModuleElement(String moduleId) {
        return (Element)this.moduleIndexElements.get(moduleId);
    }

    public ExportTask getExportTask() {
        return this.task;
    }

    public void setTask(ExportTask task) {
        this.task = task;
        this.output = task == null ? null : task.getOutput();
    }

    public ExportOutput getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performExport() {
        try {
            this.output.open();
            boolean close = true;
            try {
                this.process();
                close = false;
                this.output.close();
            }
            finally {
                if (close) {
                    this.output.close();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected void process() {
        Document indexDocument = DocumentHelper.createDocument();
        this.indexRootElement = indexDocument.addElement(this.getIndexRootElementName());
        this.invokeModules();
        this.writeIndexDocument(indexDocument);
    }

    protected void invokeModules() {
        List modules = this.getModuleRegister().getExporterModules();
        this.moduleIndexElements = new HashMap();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            ExporterModule module = (ExporterModule)it.next();
            ModuleContextImpl moduleContext = new ModuleContextImpl(module.getId());
            module.init(moduleContext);
            if (!module.toProcess()) continue;
            BaseExporterImporter.commandOut.debug("Module " + module.getId() + " processing");
            this.createModuleElement(module);
            module.process();
        }
    }

    protected void createModuleElement(ExporterModule module) {
        Element moduleElement = this.indexRootElement.addElement(this.getIndexModuleElementName());
        moduleElement.addAttribute(this.getIndexModuleIdAttributeName(), module.getId());
        this.moduleIndexElements.put(module.getId(), moduleElement);
    }

    protected void writeIndexDocument(Document indexDocument) {
        OutputStream indexOut = this.getIndexOutput();
        boolean closeIndexOut = true;
        try {
            OutputFormat format = new OutputFormat();
            format.setEncoding(this.getCharacterEncoding());
            XMLWriter writer = new XMLWriter(indexOut, format);
            writer.write(indexDocument);
            closeIndexOut = false;
            indexOut.close();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (closeIndexOut) {
                try {
                    indexOut.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing index output", (Throwable)e);
                }
            }
        }
    }

    protected OutputStream getIndexOutput() {
        try {
            return this.output.getFileOutputStream(this.getIndexFilename());
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ModuleContextImpl
    implements ExporterModuleContext {
        private final String moduleId;

        public ModuleContextImpl(String moduleId) {
            this.moduleId = moduleId;
        }

        public String getCharacterEncoding() {
            return ExporterImpl.this.getCharacterEncoding();
        }

        public ExportTask getExportTask() {
            return ExporterImpl.this.task;
        }

        public Element getModuleIndexElement() {
            return ExporterImpl.this.getIndexModuleElement(this.moduleId);
        }
    }
}

