/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.BaseExporterImporter;
import com.jaspersoft.jasperserver.export.ImportTask;
import com.jaspersoft.jasperserver.export.Importer;
import com.jaspersoft.jasperserver.export.io.ImportInput;
import com.jaspersoft.jasperserver.export.modules.ImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ImporterImpl
extends BaseExporterImporter
implements Importer {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$ImporterImpl == null ? (class$com$jaspersoft$jasperserver$export$ImporterImpl = ImporterImpl.class$("com.jaspersoft.jasperserver.export.ImporterImpl")) : class$com$jaspersoft$jasperserver$export$ImporterImpl));
    protected ImportTask task;
    protected ImportInput input;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$ImporterImpl;

    public void setTask(ImportTask task) {
        this.task = task;
        this.input = task == null ? null : task.getInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performImport() {
        try {
            this.input.open();
            boolean close = true;
            try {
                this.process();
                close = false;
                this.input.close();
            }
            finally {
                if (close) {
                    this.input.close();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected void process() {
        Document indexDocument = this.readIndexDocument();
        Element indexRoot = indexDocument.getRootElement();
        Iterator it = indexRoot.elementIterator(this.getIndexModuleElementName());
        while (it.hasNext()) {
            Element moduleElement = (Element)it.next();
            String moduleId = moduleElement.attribute(this.getIndexModuleIdAttributeName()).getValue();
            ImporterModule module = this.getModuleRegister().getImporterModule(moduleId);
            if (module == null) {
                throw new JSException("jsexception.import.module.not.found", new Object[]{moduleId});
            }
            BaseExporterImporter.commandOut.debug("Invoking module " + module);
            ModuleContextImpl moduleContext = new ModuleContextImpl(moduleElement);
            module.init(moduleContext);
            module.process();
        }
    }

    protected Document readIndexDocument() {
        InputStream indexInput = this.getIndexInput();
        boolean close = true;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding(this.getCharacterEncoding());
            Document document = reader.read(indexInput);
            close = false;
            indexInput.close();
            Document document2 = document;
            return document2;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (DocumentException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            if (close) {
                try {
                    indexInput.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected InputStream getIndexInput() {
        try {
            return this.input.getFileInputStream(this.getIndexFilename());
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ModuleContextImpl
    implements ImporterModuleContext {
        private final Element moduleElement;

        public ModuleContextImpl(Element moduleElement) {
            this.moduleElement = moduleElement;
        }

        public String getCharacterEncoding() {
            return ImporterImpl.this.getCharacterEncoding();
        }

        public ImportTask getImportTask() {
            return ImporterImpl.this.task;
        }

        public Element getModuleIndexElement() {
            return this.moduleElement;
        }
    }
}

