/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.BaseImportInput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemInput
extends BaseImportInput {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$io$FileSystemInput == null ? (class$com$jaspersoft$jasperserver$export$io$FileSystemInput = FileSystemInput.class$("com.jaspersoft.jasperserver.export.io.FileSystemInput")) : class$com$jaspersoft$jasperserver$export$io$FileSystemInput));
    private final String rootDirName;
    private final char fileSeparator;
    private File rootDir;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$io$FileSystemInput;

    public FileSystemInput(String rootDir) {
        this.rootDirName = rootDir;
        this.fileSeparator = System.getProperty("file.separator").charAt(0);
    }

    public void open() {
        this.rootDir = new File(this.rootDirName);
        if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
            throw new JSException("jsexception.import.directory.not.found", new Object[]{this.rootDirName});
        }
    }

    public void close() {
    }

    public InputStream getFileInputStream(String path) {
        try {
            File file = this.getFile(path);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            return in;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected File getFile(String path) {
        String fsPath = path.replace('/', this.fileSeparator);
        File file = new File(this.rootDir, fsPath);
        return file;
    }

    public boolean fileExists(String path) {
        File file = this.getFile(path);
        return file.exists() && file.isFile();
    }

    public boolean folderExists(String path) {
        File file = this.getFile(path);
        return file.exists() && file.isDirectory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

