/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.BaseExportOutput;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemOutput
extends BaseExportOutput {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$io$FileSystemOutput == null ? (class$com$jaspersoft$jasperserver$export$io$FileSystemOutput = FileSystemOutput.class$("com.jaspersoft.jasperserver.export.io.FileSystemOutput")) : class$com$jaspersoft$jasperserver$export$io$FileSystemOutput));
    private static final CommandOut commandOut = CommandOut.getInstance();
    private final String rootDirName;
    private final char fileSeparator;
    private File rootDir;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$io$FileSystemOutput;

    public FileSystemOutput(String rootDir) {
        this.rootDirName = rootDir;
        this.fileSeparator = System.getProperty("file.separator").charAt(0);
    }

    public String getRootDirName() {
        return this.rootDirName;
    }

    public void open() {
        this.rootDir = new File(this.getRootDirName());
        commandOut.debug("Creating directory " + this.rootDir.getAbsolutePath() + "");
        this.rootDir.mkdirs();
    }

    public void close() {
    }

    public void mkdir(String path) {
        File dir = this.getFile(path);
        dir.mkdirs();
    }

    protected File getFile(String path) {
        String filePath = path.replace('/', this.fileSeparator);
        File dir = new File(this.rootDir, filePath);
        return dir;
    }

    public OutputStream getFileOutputStream(String path) {
        try {
            File file = this.getFile(path);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            return out;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

