/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.export.io.BaseImportInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileInput
extends BaseImportInput {
    private final String zipFilename;
    private ZipFile zipFile;

    public ZipFileInput(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void open() throws IOException {
        this.zipFile = new ZipFile(new File(this.zipFilename), 1);
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public boolean fileExists(String path) {
        ZipEntry entry = this.zipFile.getEntry(path);
        return entry != null && !entry.isDirectory();
    }

    public boolean folderExists(String path) {
        ZipEntry entry = this.zipFile.getEntry(path);
        return entry != null && entry.isDirectory();
    }

    public InputStream getFileInputStream(String path) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(path);
        return this.zipFile.getInputStream(entry);
    }
}

