/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.BaseExportOutput;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipFileOutput
extends BaseExportOutput {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$io$ZipFileOutput == null ? (class$com$jaspersoft$jasperserver$export$io$ZipFileOutput = ZipFileOutput.class$("com.jaspersoft.jasperserver.export.io.ZipFileOutput")) : class$com$jaspersoft$jasperserver$export$io$ZipFileOutput));
    protected static final String ZIP_ENTRY_DIR_SUFFIX = "/";
    private final String zipFile;
    private final int level;
    private Set directories;
    protected ZipOutputStream zipOut;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$io$ZipFileOutput;

    public ZipFileOutput(String zipFile, int level) {
        this.zipFile = zipFile;
        this.level = level;
    }

    public void open() {
        try {
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(this.zipFile));
            this.zipOut = new ZipOutputStream(fileOut);
            this.zipOut.setLevel(this.level);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        this.directories = new HashSet();
    }

    public void close() throws IOException {
        this.zipOut.finish();
        this.zipOut.close();
    }

    public OutputStream getFileOutputStream(String path) throws IOException {
        ZipEntry fileEntry = new ZipEntry(path);
        this.zipOut.putNextEntry(fileEntry);
        EntryOutputStream entryOut = new EntryOutputStream();
        return entryOut;
    }

    public void mkdir(String path) throws IOException {
        if (this.directories.add(path)) {
            ZipEntry dirEntry = new ZipEntry(path + ZIP_ENTRY_DIR_SUFFIX);
            this.zipOut.putNextEntry(dirEntry);
            this.zipOut.closeEntry();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntryOutputStream
    extends OutputStream {
        protected EntryOutputStream() {
        }

        public void close() throws IOException {
            ZipFileOutput.this.zipOut.closeEntry();
        }

        public void flush() throws IOException {
            ((FilterOutputStream)ZipFileOutput.this.zipOut).flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ZipFileOutput.this.zipOut.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            ZipFileOutput.this.zipOut.write(b);
        }

        public void write(int b) throws IOException {
            ZipFileOutput.this.zipOut.write(b);
        }
    }
}

