/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.io.ExportOutputFactory;
import com.jaspersoft.jasperserver.export.io.ZipFileOutput;

public class ZipFileOutputFactory
implements ExportOutputFactory {
    private String zipFileParameter;
    private int compressionLevel = -1;

    public boolean matches(Parameters parameters) {
        return parameters.hasParameter(this.zipFileParameter);
    }

    public ExportOutput createOutput(Parameters parameters) {
        String zipFile = parameters.getParameterValue(this.getZipFileParameter());
        if (zipFile == null) {
            throw new JSException("jsexception.no.export.zip.file.specified");
        }
        return new ZipFileOutput(zipFile, this.getCompressionLevel());
    }

    public String getZipFileParameter() {
        return this.zipFileParameter;
    }

    public void setZipFileParameter(String exportFolderParameter) {
        this.zipFileParameter = exportFolderParameter;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }
}

