/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.auth;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityImportHandler;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.auth.beans.RoleBean;
import com.jaspersoft.jasperserver.export.modules.auth.beans.UserBean;
import com.jaspersoft.jasperserver.export.modules.common.ProfileAttributeBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class AuthorityImporter
extends BaseImporterModule {
    private AuthorityModuleConfiguration configuration;

    public void process() {
        this.importRoles();
        this.importUsers();
    }

    protected void importRoles() {
        String rolesDir = this.configuration.getRolesDirName();
        Iterator it = this.indexElement.elementIterator(this.configuration.getRoleIndexElementName());
        while (it.hasNext()) {
            Element roleElement = (Element)it.next();
            String roleName = roleElement.getText();
            String file = this.getRoleFile(roleName);
            RoleBean roleBean = (RoleBean)this.deserialize(rolesDir, file, this.configuration.getSerializer());
            if (this.alreadyExists(roleBean)) {
                BaseImporterModule.commandOut.warn("Role " + roleBean.getRoleName() + " already exists, skipping.");
                continue;
            }
            Role role = this.createRole(roleBean);
            this.saveRole(role);
            BaseImporterModule.commandOut.info("Created role " + role.getRoleName());
        }
    }

    protected boolean alreadyExists(RoleBean roleBean) {
        return this.configuration.getAuthorityService().getRole(this.executionContext, roleBean.getRoleName()) != null;
    }

    protected Role createRole(RoleBean roleBean) {
        Role role = this.configuration.getAuthorityService().newRole(this.executionContext);
        roleBean.copyTo(role);
        return role;
    }

    protected void saveRole(Role role) {
        this.configuration.getAuthorityService().putRole(this.executionContext, role);
    }

    protected void importUsers() {
        String usersDir = this.configuration.getUsersDirName();
        Iterator it = this.indexElement.elementIterator(this.configuration.getUserIndexElementName());
        while (it.hasNext()) {
            Element userElement = (Element)it.next();
            String username = userElement.getText();
            String file = this.getUserFile(username);
            UserBean userBean = (UserBean)this.deserialize(usersDir, file, this.configuration.getSerializer());
            if (this.alreadyExists(userBean)) {
                BaseImporterModule.commandOut.warn("User " + userBean.getUsername() + " already exists, skipping.");
                continue;
            }
            User user = this.createUser(userBean);
            this.saveUser(user);
            this.saveUserAttributes(user, userBean.getAttributes());
            BaseImporterModule.commandOut.info("Created user " + userBean.getUsername());
        }
    }

    protected boolean alreadyExists(UserBean userBean) {
        return this.configuration.getAuthorityService().getUser(this.executionContext, userBean.getUsername()) != null;
    }

    protected User createUser(UserBean userBean) {
        User user = this.configuration.getAuthorityService().newUser(this.executionContext);
        List allRoles = this.configuration.getAuthorityService().getRoles(this.executionContext, null);
        ImportHandler handler = new ImportHandler(allRoles);
        userBean.copyTo(user, handler);
        return user;
    }

    protected void saveUser(User user) {
        this.configuration.getAuthorityService().putUser(this.executionContext, user);
    }

    protected void saveUserAttributes(User user, ProfileAttributeBean[] attributes) {
        if (attributes != null && attributes.length > 0) {
            for (int i = 0; i < attributes.length; ++i) {
                ProfileAttributeBean profileAttributeBean = attributes[i];
                this.saveUserAttribute(user, profileAttributeBean);
            }
        }
    }

    protected void saveUserAttribute(User user, ProfileAttributeBean attributeBean) {
        ProfileAttributeService attributeService = this.configuration.getAttributeService();
        ProfileAttribute attribute = attributeService.newProfileAttribute(this.executionContext);
        attribute.setPrincipal((Object)user);
        attributeBean.copyTo(attribute);
        attributeService.putProfileAttribute(this.executionContext, attribute);
    }

    protected String getUserFile(String username) {
        return username + ".xml";
    }

    protected String getRoleFile(String roleName) {
        return roleName + ".xml";
    }

    public AuthorityModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AuthorityModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    protected static class ImportHandler
    implements AuthorityImportHandler {
        private final Map roles = new HashMap();

        protected ImportHandler(List roles) {
            Iterator it = roles.iterator();
            while (it.hasNext()) {
                Role role = (Role)it.next();
                this.roles.put(role.getRoleName(), role);
            }
        }

        public Role resolveRole(String rolename) {
            Role role = (Role)this.roles.get(rolename);
            return role;
        }
    }
}

