/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceDataProvider;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.repository.beans.FolderBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.RepositoryObjectPermissionBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class ResourceExporter
extends BaseExporterModule
implements ResourceExportHandler {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$modules$repository$ResourceExporter == null ? (class$com$jaspersoft$jasperserver$export$modules$repository$ResourceExporter = ResourceExporter.class$("com.jaspersoft.jasperserver.export.modules.repository.ResourceExporter")) : class$com$jaspersoft$jasperserver$export$modules$repository$ResourceExporter));
    private ResourceModuleConfiguration configuration;
    private String urisArgument;
    private String permissionsArgument;
    private String[] uris;
    private boolean exportPermissions;
    private UrisQueue urisQueue;
    private Set exportedURIs;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$modules$repository$ResourceExporter;

    public void init(ExporterModuleContext moduleContext) {
        String[] stringArray;
        super.init(moduleContext);
        this.initProcess();
        if (this.exportEverything) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/";
        } else {
            stringArray = this.getParameterValues(this.getUrisArgument());
        }
        this.uris = stringArray;
        this.exportPermissions = this.exportEverything || this.hasParameter(this.getPermissionsArgument());
    }

    protected boolean isToProcess() {
        return this.uris != null && this.uris.length > 0;
    }

    public void process() {
        this.mkdir(this.configuration.getResourcesDirName());
        for (int i = 0; i < this.uris.length; ++i) {
            this.processUri(this.uris[i], true);
        }
        while (!this.urisQueue.isEmpty()) {
            String uri = this.urisQueue.pop();
            this.processUri(uri, false);
        }
    }

    protected void initProcess() {
        this.urisQueue = new UrisQueue();
        this.exportedURIs = new HashSet();
    }

    protected void markExported(String uri) {
        this.exportedURIs.add(uri);
    }

    protected boolean alreadyExported(String uri) {
        return this.exportedURIs.contains(uri);
    }

    protected void processUri(String uri, boolean entry) {
        if (this.alreadyExported(uri)) {
            return;
        }
        Resource resource = this.configuration.getRepository().getResource(this.executionContext, uri);
        if (resource == null) {
            Folder folder = this.configuration.getRepository().getFolder(this.executionContext, uri);
            if (folder == null) {
                throw new JSException("jsexception.uri.not.found", new Object[]{uri});
            }
            if (entry) {
                this.addFolderIndexElement(uri);
            }
            this.exportFolder(folder);
        } else {
            if (entry) {
                this.addResourceIndexElement(uri);
            }
            this.exportResource(resource);
        }
    }

    protected void addFolderIndexElement(String uri) {
        Element folderElement = this.getIndexElement().addElement(this.configuration.getFolderIndexElement());
        folderElement.addText(uri);
    }

    protected void exportFolder(Folder folder) {
        String uri = folder.getURIString();
        if (this.alreadyExported(uri)) {
            return;
        }
        BaseExporterModule.commandOut.debug("Exporting repository folder " + uri);
        List subFolders = this.getSubfolders(uri);
        ResourceLookup[] resources = this.getFolderResources(uri);
        this.writeFolder(folder, subFolders, resources);
        this.markExported(uri);
        this.exportFolders(subFolders);
        this.exportResources(resources);
    }

    protected List getSubfolders(String uri) {
        List subFolders = this.configuration.getRepository().getSubFolders(this.executionContext, uri);
        return subFolders;
    }

    protected ResourceLookup[] getFolderResources(String uri) {
        FilterCriteria filter = FilterCriteria.createFilter();
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
        ResourceLookup[] resources = this.configuration.getRepository().findResource(this.executionContext, filter);
        return resources;
    }

    protected void writeFolder(Folder folder, List subFolders, ResourceLookup[] resources) {
        FolderBean bean = this.createFolderBean(folder, subFolders, resources);
        if (this.exportPermissions) {
            RepositoryObjectPermissionBean[] permissions = this.handlePermissions((InternalURI)folder);
            bean.setPermissions(permissions);
        }
        String outputFolder = this.mkdir(this.configuration.getResourcesDirName(), folder.getURIString());
        this.serialize(bean, outputFolder, this.configuration.getFolderDetailsFileName(), this.configuration.getSerializer());
    }

    protected FolderBean createFolderBean(Folder folder, List subFolders, ResourceLookup[] resources) {
        String[] resourceNames;
        String[] subFolderNames;
        FolderBean bean = new FolderBean();
        bean.copyFrom(folder);
        if (subFolders == null || subFolders.isEmpty()) {
            subFolderNames = null;
        } else {
            subFolderNames = new String[subFolders.size()];
            int c = 0;
            Iterator it = subFolders.iterator();
            while (it.hasNext()) {
                Folder subFolder = (Folder)it.next();
                subFolderNames[c] = subFolder.getName();
                ++c;
            }
        }
        bean.setSubFolders(subFolderNames);
        if (resources == null || resources.length == 0) {
            resourceNames = null;
        } else {
            resourceNames = new String[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                resourceNames[i] = resources[i].getName();
            }
        }
        bean.setResources(resourceNames);
        return bean;
    }

    protected void exportFolders(List subFolders) {
        if (subFolders != null && !subFolders.isEmpty()) {
            Iterator it = subFolders.iterator();
            while (it.hasNext()) {
                Folder subFolder = (Folder)it.next();
                this.exportFolder(subFolder);
            }
        }
    }

    protected void exportResources(ResourceLookup[] resources) {
        if (resources != null && resources.length > 0) {
            for (int i = 0; i < resources.length; ++i) {
                ResourceLookup resLookup = resources[i];
                this.exportResource(resLookup);
            }
        }
    }

    protected void addResourceIndexElement(String uri) {
        Element folderElement = this.getIndexElement().addElement(this.configuration.getResourceIndexElement());
        folderElement.addText(uri);
    }

    protected void exportResource(ResourceLookup lookup) {
        String uri = lookup.getURIString();
        if (!this.alreadyExported(uri)) {
            Resource resource = this.configuration.getRepository().getResource(this.executionContext, uri);
            this.exportResource(resource);
        }
    }

    protected void exportResource(Resource resource) {
        String uri = resource.getURIString();
        if (this.alreadyExported(uri)) {
            return;
        }
        BaseExporterModule.commandOut.info("Exporting repository resource " + uri);
        this.writeResource(resource);
        this.markExported(uri);
    }

    protected void writeResource(Resource resource) {
        ResourceBean bean = this.handleResource(resource);
        if (this.exportPermissions) {
            RepositoryObjectPermissionBean[] permissions = this.handlePermissions((InternalURI)resource);
            bean.setPermissions(permissions);
        }
        String folder = this.mkdir(this.configuration.getResourcesDirName(), bean.getFolder());
        this.serialize(bean, folder, this.getResourceFileName(resource), this.configuration.getSerializer());
    }

    public ResourceBean handleResource(Resource resource) {
        ResourceBean bean = (ResourceBean)this.configuration.getCastorBeanMappings().newObject(resource.getClass());
        bean.copyFrom(resource, this);
        return bean;
    }

    protected String getResourceFileName(Resource resource) {
        return resource.getName() + ".xml";
    }

    public ResourceReferenceBean handleReference(ResourceReference reference) {
        ResourceReferenceBean beanRef = reference == null ? null : (reference.isLocal() ? this.handleLocalResource(reference) : this.handleExternalReference(reference));
        return beanRef;
    }

    protected ResourceReferenceBean handleLocalResource(ResourceReference reference) {
        ResourceBean resourceDTO = this.handleResource(reference.getLocalResource());
        return new ResourceReferenceBean(resourceDTO);
    }

    private ResourceReferenceBean handleExternalReference(ResourceReference reference) {
        String uri = reference.getReferenceURI();
        this.queueResource(uri);
        return new ResourceReferenceBean(uri);
    }

    public void queueResource(String uri) {
        if (!this.alreadyExported(uri)) {
            this.urisQueue.push(uri);
        }
    }

    public String handleData(Resource resource, String dataProviderId) {
        ResourceDataProvider dataProvider = this.configuration.getResourceDataProvider(dataProviderId);
        InputStream dataIn = dataProvider.getData(this.exportContext, resource);
        String fileName = null;
        if (dataIn != null) {
            boolean closeInput = true;
            try {
                fileName = dataProvider.getFileName(resource);
                this.writeResourceData(resource, dataIn, fileName);
                closeInput = false;
                dataIn.close();
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (closeInput) {
                    try {
                        dataIn.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return fileName;
    }

    protected void writeResourceData(Resource resource, InputStream dataIn, String outDataFilename) {
        String folder = this.mkdir(this.configuration.getResourcesDirName(), resource.getParentFolder());
        this.writeData(dataIn, folder, outDataFilename);
    }

    protected RepositoryObjectPermissionBean[] handlePermissions(InternalURI object) {
        RepositoryObjectPermissionBean[] permissionBeans;
        List permissions = this.configuration.getPermissionService().getObjectPermissionsForObject(this.executionContext, (Object)object);
        if (permissions == null || permissions.isEmpty()) {
            permissionBeans = null;
        } else {
            BaseExporterModule.commandOut.debug("Found " + permissions.size() + " permissions for " + object.getURI());
            permissionBeans = new RepositoryObjectPermissionBean[permissions.size()];
            int c = 0;
            Iterator i = permissions.iterator();
            while (i.hasNext()) {
                RepositoryObjectPermissionBean permissionBean;
                ObjectPermission permission = (ObjectPermission)i.next();
                permissionBeans[c] = permissionBean = this.toPermissionBean(permission);
                ++c;
            }
        }
        return permissionBeans;
    }

    protected RepositoryObjectPermissionBean toPermissionBean(ObjectPermission permission) {
        RepositoryObjectPermissionBean permissionBean = new RepositoryObjectPermissionBean();
        Object permissionRecipient = permission.getPermissionRecipient();
        if (permissionRecipient instanceof Role) {
            permissionBean.setRecipientType(this.configuration.getPermissionRecipientRole());
            permissionBean.setRecipient(((Role)permissionRecipient).getRoleName());
        } else if (permissionRecipient instanceof User) {
            permissionBean.setRecipientType(this.configuration.getPermissionRecipientUser());
            permissionBean.setRecipient(((User)permissionRecipient).getUsername());
        } else {
            throw new JSException("jsexception.unknown.permission.recipient.type", new Object[]{permissionRecipient.getClass().getName()});
        }
        permissionBean.setPermissionMask(permission.getPermissionMask());
        return permissionBean;
    }

    public String getUrisArgument() {
        return this.urisArgument;
    }

    public void setUrisArgument(String urisArgument) {
        this.urisArgument = urisArgument;
    }

    public ResourceModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ResourceModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPermissionsArgument() {
        return this.permissionsArgument;
    }

    public void setPermissionsArgument(String permissionsArgument) {
        this.permissionsArgument = permissionsArgument;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class UrisQueue {
        private final LinkedList queue = new LinkedList();

        protected UrisQueue() {
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void push(String uri) {
            this.queue.addLast(uri);
        }

        public String pop() {
            return (String)this.queue.removeFirst();
        }
    }
}

