/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.StreamUtils;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.repository.beans.FolderBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.RepositoryObjectPermissionBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.beans.factory.InitializingBean;

public class ResourceImporter
extends BaseImporterModule
implements ResourceImportHandler,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter == null ? (class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter = ResourceImporter.class$("com.jaspersoft.jasperserver.export.modules.repository.ResourceImporter")) : class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter));
    private ResourceModuleConfiguration configuration;
    private String prependPathArg;
    private RepositoryService repository;
    private String prependPath;
    private Set importedURIs;
    private LinkedList folderQueue;
    private LinkedList resourceQueue;
    private Map roles;
    private Map users;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter;

    public void afterPropertiesSet() {
        this.repository = this.configuration.getRepository();
    }

    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.prependPath = this.getPrependPath();
    }

    protected String getPrependPath() {
        String path = this.getParameterValue(this.getPrependPathArg());
        if (path != null) {
            if ((path = PathUtils.normalizePath(path)).length() == 0 || path.equals("/")) {
                path = null;
            } else if (!path.startsWith("/")) {
                path = "/" + path;
            }
        }
        return path;
    }

    public void process() {
        this.initProcess();
        this.createPrependFolder();
        this.queueEntryFolders();
        this.queueEntryResources();
        while (!this.folderQueue.isEmpty() || !this.resourceQueue.isEmpty()) {
            String uri;
            if (this.folderQueue.isEmpty()) {
                uri = (String)this.resourceQueue.removeFirst();
                this.importResource(uri);
                continue;
            }
            uri = (String)this.folderQueue.removeFirst();
            this.importFolder(uri, true);
        }
    }

    protected void queueEntryFolders() {
        ArrayList<String> entryFolders = new ArrayList<String>();
        Iterator it = this.indexElement.elementIterator(this.configuration.getFolderIndexElement());
        while (it.hasNext()) {
            Element folderElement = (Element)it.next();
            entryFolders.add(folderElement.getText());
        }
        if (!entryFolders.isEmpty()) {
            Collections.sort(entryFolders);
            it = entryFolders.iterator();
            while (it.hasNext()) {
                String uri = (String)it.next();
                this.folderQueue.addLast(uri);
            }
        }
    }

    protected void queueEntryResources() {
        Iterator it = this.indexElement.elementIterator(this.configuration.getResourceIndexElement());
        while (it.hasNext()) {
            Element resourceElement = (Element)it.next();
            String uri = resourceElement.getText();
            this.resourceQueue.addLast(uri);
        }
    }

    protected void createPrependFolder() {
        if (this.prependPath != null) {
            LinkedList<String> toCreateURIs = new LinkedList<String>();
            String path = this.prependPath;
            while (this.repository.getFolder(this.executionContext, path) == null) {
                toCreateURIs.addFirst(path);
                path = PathUtils.splitPath((String)path).parentPath;
            }
            while (!toCreateURIs.isEmpty()) {
                path = (String)toCreateURIs.removeFirst();
                Folder folder = this.createFolder(path);
                BaseImporterModule.commandOut.info("Creating repository folder " + path);
                this.repository.saveFolder(this.executionContext, folder);
            }
        }
    }

    protected void initProcess() {
        this.importedURIs = new HashSet();
        this.folderQueue = new LinkedList();
        this.resourceQueue = new LinkedList();
        this.roles = new HashMap();
        this.users = new HashMap();
    }

    protected void importFolder(String uri, boolean detailsRequired) {
        if (this.importedURIs.contains(uri)) {
            return;
        }
        FolderBean folderBean = this.getFolderDetails(uri, detailsRequired);
        String importUri = this.prependedPath(uri);
        Folder folder = this.repository.getFolder(this.executionContext, importUri);
        if (folder == null) {
            this.ensureParent(uri);
            folder = folderBean == null ? this.createFolder(importUri) : this.createFolder(folderBean);
            this.repository.saveFolder(this.executionContext, folder);
            if (folderBean != null) {
                this.setPermissions((InternalURI)folder, folderBean.getPermissions(), false);
            }
            BaseImporterModule.commandOut.info("Created repository folder " + importUri);
        } else if (folderBean != null) {
            BaseImporterModule.commandOut.info("Folder " + importUri + " already exists, importing permissions only");
            this.setPermissions((InternalURI)folder, folderBean.getPermissions(), true);
        }
        this.importedURIs.add(uri);
        if (folderBean != null) {
            this.queueSubFolders(uri, folderBean);
            this.queueResources(uri, folderBean);
        }
    }

    protected void queueSubFolders(String uri, FolderBean folderBean) {
        String[] subFolders = folderBean.getSubFolders();
        if (subFolders != null) {
            for (int i = 0; i < subFolders.length; ++i) {
                String subfolderURI = this.appendPath(uri, subFolders[i]);
                this.folderQueue.addLast(subfolderURI);
            }
        }
    }

    protected void queueResources(String uri, FolderBean folderBean) {
        String[] resources = folderBean.getResources();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                String resourceUri = this.appendPath(uri, resources[i]);
                this.resourceQueue.addLast(resourceUri);
            }
        }
    }

    protected String prependedPath(String uri) {
        return PathUtils.concatPaths(this.prependPath, uri);
    }

    protected String appendPath(String uri, String name) {
        String subUri = uri.equals("/") ? "/" + name : uri + "/" + name;
        return subUri;
    }

    protected FolderBean getFolderDetails(String uri, boolean required) {
        FolderBean folderBean = null;
        String folderPath = PathUtils.concatPaths(this.configuration.getResourcesDirName(), uri);
        if (this.input.fileExists(folderPath, this.configuration.getFolderDetailsFileName())) {
            folderBean = (FolderBean)this.deserialize(folderPath, this.configuration.getFolderDetailsFileName(), this.configuration.getSerializer());
        } else if (required) {
            throw new JSException("jsexception.folder.details.not.found", new Object[]{uri});
        }
        return folderBean;
    }

    protected void ensureParent(String uri) {
        PathUtils.SplittedPath splitPath = PathUtils.splitPath(uri);
        if (splitPath != null && splitPath.parentPath != null) {
            this.importFolder(splitPath.parentPath, false);
        }
    }

    protected Folder createFolder(String uri) {
        FolderImpl folder = new FolderImpl();
        PathUtils.SplittedPath splPath = PathUtils.splitPath(uri);
        folder.setParentFolder(splPath.parentPath);
        folder.setName(splPath.name);
        folder.setLabel(splPath.name);
        return folder;
    }

    protected Folder createFolder(FolderBean folderBean) {
        FolderImpl folder = new FolderImpl();
        folderBean.copyTo((Folder)folder);
        folder.setParentFolder(this.prependedPath(folder.getParentFolder()));
        return folder;
    }

    protected String importResource(String uri) {
        String importUri = this.prependedPath(uri);
        if (!this.importedURIs.contains(uri)) {
            Resource resource = this.repository.getResource(this.executionContext, importUri);
            if (resource == null) {
                this.ensureParent(uri);
                ResourceBean bean = this.readResourceBean(uri);
                resource = this.createResource(bean);
                this.repository.saveResource(this.executionContext, resource);
                this.setPermissions((InternalURI)resource, bean.getPermissions(), false);
                BaseImporterModule.commandOut.info("Imported resource " + importUri);
            } else {
                BaseImporterModule.commandOut.warn("Resource " + importUri + " already exists, not importing");
            }
            this.importedURIs.add(uri);
        }
        return importUri;
    }

    protected Resource createResource(ResourceBean bean) {
        Class resourceItf = this.configuration.getCastorBeanMappings().getInterface(bean.getClass());
        Resource resource = this.repository.newResource(this.executionContext, resourceItf);
        bean.copyTo(resource, this);
        resource.setParentFolder(this.prependedPath(resource.getParentFolder()));
        return resource;
    }

    protected ResourceBean readResourceBean(String uri) {
        String resourceFileName = this.getResourceFileName(uri);
        ResourceBean bean = (ResourceBean)this.deserialize(this.configuration.getResourcesDirName(), resourceFileName, this.configuration.getSerializer());
        return bean;
    }

    protected String getResourceFileName(String uri) {
        return uri + ".xml";
    }

    public ResourceReference handleReference(ResourceReferenceBean beanReference) {
        ResourceReference reference;
        if (beanReference == null) {
            reference = null;
        } else if (beanReference.isLocal()) {
            ResourceBean localResBean = beanReference.getLocalResource();
            Resource localRes = this.createResource(localResBean);
            reference = new ResourceReference(localRes);
        } else {
            String referenceURI = beanReference.getExternalURI();
            this.importResource(referenceURI);
            reference = new ResourceReference(this.prependedPath(referenceURI));
        }
        return reference;
    }

    public byte[] handleData(ResourceBean resourceBean, String dataFile, String providerId) {
        String filename = PathUtils.concatPaths(resourceBean.getFolder(), dataFile);
        InputStream dataInput = this.getFileInput(this.configuration.getResourcesDirName(), filename);
        boolean closeInput = true;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamUtils.pipeData((InputStream)dataInput, (OutputStream)out);
            closeInput = false;
            dataInput.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (closeInput) {
                try {
                    dataInput.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public Resource handleResource(ResourceBean resource) {
        Resource res = this.createResource(resource);
        return res;
    }

    public String handleResource(String uri) {
        return this.importResource(uri);
    }

    protected void setPermissions(InternalURI object, RepositoryObjectPermissionBean[] permissions, boolean checkExisting) {
        if (permissions != null) {
            for (int i = 0; i < permissions.length; ++i) {
                RepositoryObjectPermissionBean permissionBean = permissions[i];
                this.setPermission(object, permissionBean, checkExisting);
            }
        }
    }

    protected void setPermission(InternalURI object, RepositoryObjectPermissionBean permissionBean, boolean checkExisting) {
        Role recipient;
        ObjectPermissionService permissionsService = this.configuration.getPermissionService();
        String recipientType = permissionBean.getRecipientType();
        if (recipientType.equals(this.configuration.getPermissionRecipientRole())) {
            recipient = this.getRole(permissionBean.getRecipient());
            if (recipient == null) {
                BaseImporterModule.commandOut.warn("Role " + permissionBean.getRecipient() + " not found, skipping permission of " + object.getURI());
            }
        } else if (recipientType.equals(this.configuration.getPermissionRecipientUser())) {
            recipient = this.getUser(permissionBean.getRecipient());
            if (recipient == null) {
                BaseImporterModule.commandOut.warn("User " + permissionBean.getRecipient() + " not found, skipping permission of " + object.getURI());
            }
        } else {
            recipient = null;
            BaseImporterModule.commandOut.warn("Unknown object permission recipient type " + recipientType + ", skipping permission of " + object.getURI());
        }
        if (recipient != null) {
            List permissions;
            boolean existing = checkExisting ? (permissions = permissionsService.getObjectPermissionsForObjectAndRecipient(this.executionContext, (Object)object, (Object)recipient)) != null && !permissions.isEmpty() : false;
            if (existing) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Permission on " + object.getURI() + " for " + permissionBean.getRecipient() + " already exists, skipping."));
                }
            } else {
                ObjectPermission permission = permissionsService.newObjectPermission(this.executionContext);
                permission.setURI(object.getURI());
                permission.setPermissionMask(permissionBean.getPermissionMask());
                permission.setPermissionRecipient((Object)recipient);
                permissionsService.putObjectPermission(this.executionContext, permission);
            }
        }
    }

    protected Role getRole(String roleName) {
        Role role;
        if (this.roles.containsKey(roleName)) {
            role = (Role)this.roles.get(roleName);
        } else {
            role = this.configuration.getAuthorityService().getRole(this.executionContext, roleName);
            this.roles.put(roleName, role);
        }
        return role;
    }

    protected User getUser(String username) {
        User user;
        if (this.users.containsKey(username)) {
            user = (User)this.users.get(username);
        } else {
            user = this.configuration.getAuthorityService().getUser(this.executionContext, username);
            this.users.put(username, user);
        }
        return user;
    }

    public ResourceModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ResourceModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPrependPathArg() {
        return this.prependPathArg;
    }

    public void setPrependPathArg(String prependPathArg) {
        this.prependPathArg = prependPathArg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

