/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContentResourceBean
extends ResourceBean {
    public static final String DATA_PROVIDER_ID = "contentResourceData";
    private String fileType;
    private ContentResourceBean[] resources;
    private String dataFile;

    protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
        ContentResource contentRes = (ContentResource)res;
        this.setFileType(contentRes.getFileType());
        this.setDataFile(exportHandler.handleData(res, DATA_PROVIDER_ID));
        this.copyResourcesFrom(contentRes, exportHandler);
    }

    protected void copyResourcesFrom(ContentResource contentRes, ResourceExportHandler exportHandler) {
        List subResources = contentRes.getResources();
        if (subResources == null || subResources.isEmpty()) {
            this.resources = null;
        } else {
            this.resources = new ContentResourceBean[subResources.size()];
            int c = 0;
            Iterator it = subResources.iterator();
            while (it.hasNext()) {
                ContentResource subResource = (ContentResource)it.next();
                this.resources[c] = (ContentResourceBean)exportHandler.handleResource((Resource)subResource);
                ++c;
            }
        }
    }

    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        ContentResource contentRes = (ContentResource)res;
        contentRes.setFileType(this.getFileType());
        if (this.dataFile != null) {
            contentRes.setData(importHandler.handleData(this, this.dataFile, DATA_PROVIDER_ID));
        }
        this.copyResourcesTo(contentRes, importHandler);
    }

    protected void copyResourcesTo(ContentResource contentRes, ResourceImportHandler importHandler) {
        ArrayList<ContentResource> subResources;
        if (this.resources == null) {
            subResources = null;
        } else {
            subResources = new ArrayList<ContentResource>(this.resources.length);
            for (int i = 0; i < this.resources.length; ++i) {
                ContentResourceBean resource = this.resources[i];
                ContentResource subResource = (ContentResource)importHandler.handleResource(resource);
                subResources.add(subResource);
            }
        }
        contentRes.setResources(subResources);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public ContentResourceBean[] getResources() {
        return this.resources;
    }

    public void setResources(ContentResourceBean[] resources) {
        this.resources = resources;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }
}

