/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportUnitJobsIndexBean;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class ReportJobsExporter
extends BaseExporterModule {
    protected SchedulingModuleConfiguration configuration;
    protected String reportJobsArg;
    protected Set exportedURIs;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit;

    protected boolean isToProcess() {
        return this.hasParameter(this.reportJobsArg);
    }

    public void process() {
        String[] stringArray;
        this.mkdir(this.configuration.getReportJobsDir());
        this.exportedURIs = new HashSet();
        if (this.exportEverything) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/";
        } else {
            stringArray = this.getParameterValues(this.reportJobsArg);
        }
        String[] reportURIs = stringArray;
        for (int i = 0; i < reportURIs.length; ++i) {
            String uri = reportURIs[i];
            this.processUri(uri);
        }
    }

    private void processUri(String uri) {
        Folder folder = this.configuration.getRepository().getFolder(this.executionContext, uri);
        if (folder == null) {
            Resource resource = this.configuration.getRepository().getResource(this.executionContext, uri);
            if (resource == null) {
                throw new JSException("jsexception.repository.uri.neither.report.nor.folder", new Object[]{uri});
            }
            this.processResource(resource);
        } else {
            this.processFolder(uri);
        }
    }

    protected void processResource(Resource resource) {
        if (!(resource instanceof ReportUnit)) {
            throw new JSException("jsexception.resource.not.report.unit", new Object[]{resource.getURIString()});
        }
        this.processReportUnit(resource.getURIString());
    }

    protected void processFolder(String uri) {
        this.processFolderResources(uri);
        List subFolders = this.configuration.getRepository().getSubFolders(this.executionContext, uri);
        if (subFolders != null && !subFolders.isEmpty()) {
            Iterator it = subFolders.iterator();
            while (it.hasNext()) {
                Folder subFolder = (Folder)it.next();
                this.processFolder(subFolder.getURIString());
            }
        }
    }

    protected void processFolderResources(String folderURI) {
        FilterCriteria filter = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit = ReportJobsExporter.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit));
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
        ResourceLookup[] reportUnits = this.configuration.getRepository().findResource(this.executionContext, filter);
        if (reportUnits != null && reportUnits.length > 0) {
            for (int i = 0; i < reportUnits.length; ++i) {
                ResourceLookup reportUnit = reportUnits[i];
                this.processReportUnit(reportUnit.getURIString());
            }
        }
    }

    protected void processReportUnit(String uri) {
        if (this.exportedURIs.contains(uri)) {
            return;
        }
        List jobs = this.configuration.getReportScheduler().getScheduledJobs(this.executionContext, uri);
        if (jobs != null && !jobs.isEmpty()) {
            this.exportJobs(uri, jobs);
            this.writeIndexReportUnitEntry(uri);
            this.exportedURIs.add(uri);
            BaseExporterModule.commandOut.info("Exported " + jobs.size() + " job(s) for the " + uri + " report unit");
        } else {
            BaseExporterModule.commandOut.debug("Report " + uri + " does not have any scheduled jobs");
        }
    }

    protected void exportJobs(String uri, List jobs) {
        String ruPath = this.mkdir(this.configuration.getReportJobsDir(), uri);
        long[] jobIds = new long[jobs.size()];
        int c = 0;
        Iterator iter = jobs.iterator();
        while (iter.hasNext()) {
            long jobId;
            ReportJobSummary jobSummary = (ReportJobSummary)iter.next();
            jobIds[c] = jobId = jobSummary.getId();
            ReportJob job = this.configuration.getReportScheduler().getScheduledJob(this.executionContext, jobId);
            this.exportJob(ruPath, job);
            ++c;
        }
        ReportUnitJobsIndexBean indexBean = new ReportUnitJobsIndexBean();
        indexBean.setJobIds(jobIds);
        this.serialize(indexBean, ruPath, this.configuration.getReportUnitIndexFilename(), this.configuration.getSerializer());
    }

    protected void exportJob(String folderPath, ReportJob job) {
        ReportJobBean jobBean = new ReportJobBean();
        jobBean.copyFrom(job);
        this.serialize(jobBean, folderPath, this.getJobFilename(job), this.configuration.getSerializer());
    }

    protected String getJobFilename(ReportJob job) {
        return job.getId() + ".xml";
    }

    protected void writeIndexReportUnitEntry(String uri) {
        Element ruElement = this.getIndexElement().addElement(this.configuration.getIndexReportUnitElement());
        ruElement.setText(uri);
    }

    public SchedulingModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SchedulingModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getReportJobsArg() {
        return this.reportJobsArg;
    }

    public void setReportJobsArg(String reportJobsArg) {
        this.reportJobsArg = reportJobsArg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

