/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportUnitJobsIndexBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class ReportJobsImporter
extends BaseImporterModule {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter == null ? (class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter = ReportJobsImporter.class$("com.jaspersoft.jasperserver.export.modules.repository.ResourceImporter")) : class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter));
    protected SchedulingModuleConfiguration configuration;
    private String prependPathArg;
    private String prependPath;
    private Map userIndicator;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$export$modules$repository$ResourceImporter;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit;

    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.prependPath = this.getPrependPath();
    }

    protected String getPrependPath() {
        String path = this.getParameterValue(this.getPrependPathArg());
        if (path != null) {
            if ((path = PathUtils.normalizePath(path)).length() == 0 || path.equals("/")) {
                path = null;
            } else if (!path.startsWith("/")) {
                path = "/" + path;
            }
        }
        return path;
    }

    public void process() {
        this.initProcess();
        Iterator i = this.indexElement.elementIterator(this.configuration.getIndexReportUnitElement());
        while (i.hasNext()) {
            Element ruElement = (Element)i.next();
            String uri = ruElement.getText();
            this.processReportUnit(uri);
        }
    }

    protected void initProcess() {
        this.userIndicator = new HashMap();
    }

    protected void processReportUnit(String uri) {
        String newUri = this.prependedPath(uri);
        if (this.checkReportUnit(newUri)) {
            String ruPath = PathUtils.concatPaths(this.configuration.getReportJobsDir(), uri);
            ReportUnitJobsIndexBean indexBean = (ReportUnitJobsIndexBean)this.deserialize(ruPath, this.configuration.getReportUnitIndexFilename(), this.configuration.getSerializer());
            long[] jobIds = indexBean.getJobIds();
            int imported = 0;
            for (int i = 0; i < jobIds.length; ++i) {
                long jobId = jobIds[i];
                String jobFilename = this.getJobFilename(jobId);
                ReportJobBean jobBean = (ReportJobBean)this.deserialize(ruPath, jobFilename, this.configuration.getSerializer());
                if (this.userExists(jobBean.getUsername())) {
                    this.importJob(newUri, jobBean);
                    ++imported;
                    continue;
                }
                BaseImporterModule.commandOut.warn("User " + jobBean.getUsername() + " does not exist, skipping job " + jobBean.getId() + " of report " + newUri);
            }
            BaseImporterModule.commandOut.info("Created " + imported + " job(s) for report " + newUri);
        } else {
            BaseImporterModule.commandOut.warn("Report unit " + newUri + " not found in repository, skipping jobs");
        }
    }

    protected boolean checkReportUnit(String uri) {
        PathUtils.SplittedPath splittedPath = PathUtils.splitPath(uri);
        FilterCriteria filter = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit = ReportJobsImporter.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit));
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)splittedPath.parentPath));
        filter.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"name", (Object)splittedPath.name));
        ResourceLookup[] lookups = this.configuration.getRepository().findResource(this.executionContext, filter);
        return lookups != null && lookups.length > 0;
    }

    protected String getJobFilename(long jobId) {
        return jobId + ".xml";
    }

    protected boolean userExists(String username) {
        Boolean indicator = (Boolean)this.userIndicator.get(username);
        if (indicator == null) {
            indicator = this.configuration.getAuthorityService().getUser(this.executionContext, username) != null;
            this.userIndicator.put(username, indicator);
        }
        return indicator;
    }

    protected void importJob(String newUri, ReportJobBean jobBean) {
        ReportJob job = new ReportJob();
        jobBean.copyTo(job);
        ReportJobSource jobSource = job.getSource();
        if (!newUri.equals(jobSource.getReportUnitURI())) {
            jobSource.setReportUnitURI(newUri);
        }
        ReportJob savedJob = this.configuration.getInternalReportScheduler().saveJob(this.executionContext, job);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created job " + savedJob.getId() + " for report " + newUri + " (old id " + jobBean.getId() + ")"));
        }
    }

    protected String prependedPath(String uri) {
        return PathUtils.concatPaths(this.prependPath, uri);
    }

    public SchedulingModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SchedulingModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPrependPathArg() {
        return this.prependPathArg;
    }

    public void setPrependPathArg(String prependPathArg) {
        this.prependPathArg = prependPathArg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

