/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling.beans;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobCalendarTriggerBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobMailNotificationBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobRepositoryDestinationBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobSimpleTriggerBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobSourceBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobTriggerBean;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ReportJobBean {
    private long id;
    private int version;
    private String username;
    private String label;
    private String description;
    private ReportJobTriggerBean trigger;
    private ReportJobSourceBean source;
    private String baseOutputFilename;
    private byte[] outputFormats;
    private String outputLocale;
    private ReportJobRepositoryDestinationBean contentRepositoryDestination;
    private ReportJobMailNotificationBean mailNotification;

    public void copyFrom(ReportJob job) {
        this.setId(job.getId());
        this.setVersion(job.getVersion());
        this.setUsername(job.getUsername());
        this.setLabel(job.getLabel());
        this.setDescription(job.getDescription());
        this.setTrigger(this.copyTriggerFrom(job));
        this.setSource(this.copySourceFrom(job));
        this.setBaseOutputFilename(job.getBaseOutputFilename());
        this.setOutputFormats(this.copyOutputFormatsFrom(job));
        this.setOutputLocale(job.getOutputLocale());
        this.setContentRepositoryDestination(this.copyRepositoryDestinationFrom(job));
        this.setMailNotification(this.copyMailNotificationFrom(job));
    }

    protected byte[] copyOutputFormatsFrom(ReportJob job) {
        byte[] formats;
        Set jobFormats = job.getOutputFormats();
        if (jobFormats == null || jobFormats.isEmpty()) {
            formats = null;
        } else {
            formats = new byte[jobFormats.size()];
            int c = 0;
            Iterator it = jobFormats.iterator();
            while (it.hasNext()) {
                Byte format = (Byte)it.next();
                formats[c] = format;
                ++c;
            }
        }
        return formats;
    }

    protected ReportJobTriggerBean copyTriggerFrom(ReportJob job) {
        ReportJobTriggerBean triggerBean;
        ReportJobTrigger jobTrigger = job.getTrigger();
        if (jobTrigger == null) {
            triggerBean = null;
        } else {
            triggerBean = this.createTriggerBean(jobTrigger);
            triggerBean.copyFrom(jobTrigger);
        }
        return triggerBean;
    }

    protected ReportJobTriggerBean createTriggerBean(ReportJobTrigger jobTrigger) {
        ReportJobTriggerBean triggerBean;
        if (jobTrigger instanceof ReportJobSimpleTrigger) {
            triggerBean = new ReportJobSimpleTriggerBean();
        } else if (jobTrigger instanceof ReportJobCalendarTrigger) {
            triggerBean = new ReportJobCalendarTriggerBean();
        } else {
            throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{jobTrigger.getClass().getName()});
        }
        return triggerBean;
    }

    protected ReportJobSourceBean copySourceFrom(ReportJob job) {
        ReportJobSourceBean srcBean;
        ReportJobSource src = job.getSource();
        if (src == null) {
            srcBean = null;
        } else {
            srcBean = new ReportJobSourceBean();
            srcBean.copyFrom(src);
        }
        return srcBean;
    }

    protected ReportJobRepositoryDestinationBean copyRepositoryDestinationFrom(ReportJob job) {
        ReportJobRepositoryDestinationBean destBean;
        ReportJobRepositoryDestination dest = job.getContentRepositoryDestination();
        if (dest == null) {
            destBean = null;
        } else {
            destBean = new ReportJobRepositoryDestinationBean();
            destBean.copyFrom(dest);
        }
        return destBean;
    }

    protected ReportJobMailNotificationBean copyMailNotificationFrom(ReportJob job) {
        ReportJobMailNotificationBean mailNotificationBean;
        ReportJobMailNotification jobMail = job.getMailNotification();
        if (jobMail == null) {
            mailNotificationBean = null;
        } else {
            mailNotificationBean = new ReportJobMailNotificationBean();
            mailNotificationBean.copyFrom(jobMail);
        }
        return mailNotificationBean;
    }

    public void copyTo(ReportJob job) {
        job.setUsername(this.getUsername());
        job.setLabel(this.getLabel());
        job.setDescription(this.getDescription());
        job.setTrigger(this.copyTriggerTo());
        job.setSource(this.copySourceTo());
        job.setBaseOutputFilename(this.getBaseOutputFilename());
        job.setOutputFormats(this.copyOutputFormatsTo());
        job.setOutputLocale(this.getOutputLocale());
        job.setContentRepositoryDestination(this.copyRepositoryDestinationTo());
        job.setMailNotification(this.copyMailNotificationTo());
    }

    protected ReportJobTrigger copyTriggerTo() {
        ReportJobTrigger jobTrigger;
        if (this.trigger == null) {
            jobTrigger = null;
        } else {
            jobTrigger = this.trigger.toJobTrigger();
            this.trigger.copyTo(jobTrigger);
        }
        return jobTrigger;
    }

    protected ReportJobSource copySourceTo() {
        ReportJobSource jobSource;
        if (this.source == null) {
            jobSource = null;
        } else {
            jobSource = new ReportJobSource();
            this.source.copyTo(jobSource);
        }
        return jobSource;
    }

    protected Set copyOutputFormatsTo() {
        HashSet<Byte> formats;
        if (this.outputFormats == null) {
            formats = null;
        } else {
            formats = new HashSet<Byte>();
            for (int i = 0; i < this.outputFormats.length; ++i) {
                formats.add(new Byte(this.outputFormats[i]));
            }
        }
        return formats;
    }

    protected ReportJobRepositoryDestination copyRepositoryDestinationTo() {
        ReportJobRepositoryDestination dest;
        if (this.contentRepositoryDestination == null) {
            dest = null;
        } else {
            dest = new ReportJobRepositoryDestination();
            this.contentRepositoryDestination.copyTo(dest);
        }
        return dest;
    }

    protected ReportJobMailNotification copyMailNotificationTo() {
        ReportJobMailNotification mail;
        if (this.mailNotification == null) {
            mail = null;
        } else {
            mail = new ReportJobMailNotification();
            this.mailNotification.copyTo(mail);
        }
        return mail;
    }

    public String getBaseOutputFilename() {
        return this.baseOutputFilename;
    }

    public void setBaseOutputFilename(String baseOutputFilename) {
        this.baseOutputFilename = baseOutputFilename;
    }

    public ReportJobRepositoryDestinationBean getContentRepositoryDestination() {
        return this.contentRepositoryDestination;
    }

    public void setContentRepositoryDestination(ReportJobRepositoryDestinationBean contentRepositoryDestination) {
        this.contentRepositoryDestination = contentRepositoryDestination;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ReportJobMailNotificationBean getMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(ReportJobMailNotificationBean mailNotification) {
        this.mailNotification = mailNotification;
    }

    public byte[] getOutputFormats() {
        return this.outputFormats;
    }

    public void setOutputFormats(byte[] outputFormats) {
        this.outputFormats = outputFormats;
    }

    public String getOutputLocale() {
        return this.outputLocale;
    }

    public void setOutputLocale(String outputLocale) {
        this.outputLocale = outputLocale;
    }

    public ReportJobSourceBean getSource() {
        return this.source;
    }

    public void setSource(ReportJobSourceBean source) {
        this.source = source;
    }

    public ReportJobTriggerBean getTrigger() {
        return this.trigger;
    }

    public void setTrigger(ReportJobTriggerBean trigger) {
        this.trigger = trigger;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

