/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.util.ExportResource;
import com.jaspersoft.jasperserver.util.ImportResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ExportImportCommand {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$util$ExportImportCommand == null ? (class$com$jaspersoft$jasperserver$util$ExportImportCommand = ExportImportCommand.class$("com.jaspersoft.jasperserver.util.ExportImportCommand")) : class$com$jaspersoft$jasperserver$util$ExportImportCommand));
    private static final String REPORT_SCHEDULING_SERVICE_BEAN_NAME = "reportSchedulingService";
    private static final String REPORT_SCHEDULING_INTERNAL_SERVICE_BEAN_NAME = "reportSchedulingInternalService";
    private static final String ENCODING_PROVIDER_BEAN_NAME = "encodingProvider";
    private RepositoryService mRepo;
    private UserAuthorityService mAuth;
    private ReportSchedulingService mReportScheduler;
    private ReportSchedulingInternalService mReportSchedulerInternal;
    private CharacterEncodingProvider encodingProvider;
    private ExecutionContext mContext;
    private Properties mJdbcProps;
    static boolean sImportOperation = false;
    static boolean sExportOperation = false;
    private boolean mProcessUri = false;
    private boolean mProcessUsers = false;
    private boolean mProcessRoles = false;
    private boolean mProcessJobReportUnits = false;
    private boolean mProcessNothing = false;
    private boolean mUseNamedOutputDir = false;
    private boolean mUseNamedOutputFile = false;
    private String mOutputDirName;
    private String mOutputFileName;
    private List mUriValuesList;
    private List mUserNamesList;
    private List mRoleNamesList;
    private List mJobReportUnitsList;
    private List mOutputFileNameList;
    private List mOutputDirNameList;
    private boolean mImportProcessPrependPath = false;
    private List mPrependPathValuesList;
    private boolean mVerbose = false;
    private boolean mDevEnv = false;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$util$ExportImportCommand;

    public static void main(String[] args) {
        System.out.println("ExportImportCommand: START");
        boolean result = true;
        ExportImportCommand command = new ExportImportCommand();
        if (args[0].equalsIgnoreCase("--export")) {
            sExportOperation = true;
            command.runExport(args);
        } else if (args[0].equalsIgnoreCase("--import")) {
            sImportOperation = true;
            result = command.runImport(args);
        } else {
            System.out.println("\nExportImportCommand: unknown main process option, option=" + args[0]);
        }
        if (result) {
            System.out.println("ExportImportCommand: Successful");
            System.exit(0);
        } else {
            System.out.println("ExportImportCommand: ERROR");
            System.exit(1);
        }
    }

    public void runExport(String[] args) {
        String uriValue = null;
        String[] userNames = null;
        String[] roleNames = null;
        String[] jobReportUnits = null;
        this.processCommandLineArgsExport(args);
        this.setParameterValues();
        this.printoutOperationValues();
        this.setUpRepositoryConnections();
        if (!this.mProcessNothing) {
            if (this.mUriValuesList != null && this.mUriValuesList.size() > 0) {
                uriValue = (String)this.mUriValuesList.get(0);
            }
            if (this.mUserNamesList != null && this.mUserNamesList.size() > 0) {
                userNames = this.mUserNamesList.toArray(new String[this.mUserNamesList.size()]);
            }
            if (this.mRoleNamesList != null && this.mRoleNamesList.size() > 0) {
                roleNames = this.mRoleNamesList.toArray(new String[this.mRoleNamesList.size()]);
            }
            if (this.mJobReportUnitsList != null && this.mJobReportUnitsList.size() > 0) {
                jobReportUnits = this.mJobReportUnitsList.toArray(new String[this.mJobReportUnitsList.size()]);
            }
            if (!this.mProcessNothing) {
                ExportResource exporter = new ExportResource(this.mRepo, this.mAuth, this.mReportScheduler, this.mContext, uriValue, this.mProcessUsers, userNames, roleNames, this.mProcessJobReportUnits, jobReportUnits, this.mOutputDirName, this.mOutputFileName, this.encodingProvider.getCharacterEncoding());
                exporter.process();
            }
        }
    }

    public boolean runImport(String[] args) {
        String prependPath = null;
        this.processCommandLineArgsImport(args);
        this.setParameterValues();
        this.printoutOperationValues();
        if (!this.mProcessNothing) {
            if (this.mPrependPathValuesList != null && this.mPrependPathValuesList.size() > 0) {
                String[] strArray = this.mPrependPathValuesList.toArray(new String[this.mPrependPathValuesList.size()]);
                prependPath = strArray[0];
            }
            this.setUpRepositoryConnections();
            ImportResource importer = new ImportResource(this.mRepo, this.mAuth, this.mReportSchedulerInternal, this.mContext, this.mOutputDirName, this.mOutputFileName, prependPath, this.encodingProvider.getCharacterEncoding());
            return importer.process();
        }
        return false;
    }

    protected void setParameterValues() {
        if (this.mUseNamedOutputDir) {
            if (this.mOutputDirNameList != null && this.mOutputDirNameList.size() > 0) {
                this.mOutputDirName = (String)this.mOutputDirNameList.get(0);
            } else {
                System.out.println("ExportImportCommand: ERROR with output dir name");
            }
        } else {
            this.mOutputDirName = "target/ji-catalog";
        }
        if (this.mUseNamedOutputFile) {
            if (this.mOutputFileNameList != null && this.mOutputFileNameList.size() > 0) {
                this.mOutputFileName = (String)this.mOutputFileNameList.get(0);
            } else {
                System.out.println("ExportImportCommand: ERROR with output file name");
            }
        } else {
            this.mOutputFileName = "ji-catalog.xml";
        }
    }

    private void processCommandLineArgsExport(String[] args) {
        this.mUriValuesList = new ArrayList();
        this.mUserNamesList = new ArrayList();
        this.mRoleNamesList = new ArrayList();
        this.mJobReportUnitsList = new ArrayList();
        this.mOutputDirNameList = new ArrayList();
        this.mOutputFileNameList = new ArrayList();
        if (args.length <= 1) {
            System.out.println("\nError: No command line options found.\n");
            this.printUsage();
            System.exit(0);
        }
        block0: for (int i = 1; i < args.length; ++i) {
            int strLen;
            int j;
            if (args[i].startsWith("--uri")) {
                if (args[i].length() == "--uri".length()) {
                    this.mProcessUri = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mUriValuesList.add(args[j]);
                            continue;
                        }
                        if (j != i) continue block0;
                        System.out.println("--uri option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--uri".length();
                if (args[i].length() <= strLen) continue;
                this.mProcessUri = true;
                this.mUriValuesList.add(args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--users")) {
                if (args[i].length() == "--users".length()) {
                    this.mProcessUsers = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mUserNamesList.add(args[j]);
                            System.out.println("username value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block0;
                        System.out.println("--users option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--users".length();
                if (args[i].length() <= strLen) continue;
                this.mProcessUsers = true;
                this.mUserNamesList.add(args[i].substring(strLen + 1));
                System.out.println("users value=" + args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--roles")) {
                if (args[i].length() == "--roles".length()) {
                    this.mProcessRoles = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mRoleNamesList.add(args[j]);
                            System.out.println("rolename value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block0;
                        System.out.println("--roles option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--roles".length();
                if (args[i].length() <= strLen) continue;
                this.mProcessRoles = true;
                this.mRoleNamesList.add(args[i].substring(strLen + 1));
                System.out.println("roles value=" + args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--scheduled-jobs")) {
                if (args[i].length() == "--scheduled-jobs".length()) {
                    this.mProcessJobReportUnits = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mJobReportUnitsList.add(args[j]);
                            System.out.println("job reportunit name value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block0;
                        System.out.println("--job-schedules option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--scheduled-jobs".length();
                if (args[i].length() <= strLen) continue;
                this.mProcessJobReportUnits = true;
                this.mJobReportUnitsList.add(args[i].substring(strLen + 1));
                System.out.println("scheduled jobs value=" + args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--export-file")) {
                if (args[i].length() == "--export-file".length()) {
                    this.mUseNamedOutputFile = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mOutputFileNameList.add(args[j]);
                            System.out.println("export filename value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block0;
                        System.out.println("--export-filename option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--export-file".length();
                if (args[i].length() <= strLen) continue;
                this.mUseNamedOutputFile = true;
                this.mOutputFileNameList.add(args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--export-path")) {
                if (args[i].length() == "--export-path".length()) {
                    this.mUseNamedOutputDir = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mOutputDirNameList.add(args[j]);
                            System.out.println("export dirname value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block0;
                        System.out.println("--export-directory option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--export-path".length();
                if (args[i].length() <= strLen) continue;
                this.mUseNamedOutputDir = true;
                this.mOutputDirNameList.add(args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].equalsIgnoreCase("--dev-env")) {
                this.mDevEnv = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--verbose")) {
                this.mVerbose = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("--help")) continue;
            this.printUsage();
            System.exit(0);
        }
        if (!(this.mProcessUri || this.mProcessUsers || this.mProcessRoles || this.mProcessJobReportUnits)) {
            this.mProcessNothing = true;
        }
    }

    private void processCommandLineArgsImport(String[] args) {
        int i;
        this.mPrependPathValuesList = new ArrayList();
        this.mOutputDirNameList = new ArrayList();
        this.mOutputFileNameList = new ArrayList();
        System.out.println("ExportImportCommand: --- test: Print out all args");
        for (i = 0; i < args.length; ++i) {
            System.out.println("ExportImportCommand: ----- args[" + i + "]=" + args[i]);
        }
        block1: for (i = 1; i < args.length; ++i) {
            int strLen;
            int j;
            if (args[i].startsWith("--prepend-path")) {
                if (args[i].length() == "--prepend-path".length()) {
                    this.mImportProcessPrependPath = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mPrependPathValuesList.add(args[j]);
                            System.out.println("prepend value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block1;
                        System.out.println("--prepend option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--prepend-path".length();
                if (args[i].length() <= strLen) continue;
                this.mImportProcessPrependPath = true;
                this.mPrependPathValuesList.add(args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--import-file")) {
                if (args[i].length() == "--import-file".length()) {
                    this.mUseNamedOutputFile = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mOutputFileNameList.add(args[j]);
                            System.out.println("import filename value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block1;
                        System.out.println("--import-filename option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--import-file".length();
                if (args[i].length() <= strLen) continue;
                this.mUseNamedOutputFile = true;
                this.mOutputFileNameList.add(args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].startsWith("--import-path")) {
                if (args[i].length() == "--import-path".length()) {
                    this.mUseNamedOutputDir = true;
                    for (j = i + 1; j < args.length; ++j) {
                        if (args[j] != null && args[j].length() > 0 && !args[j].startsWith("-")) {
                            this.mOutputDirNameList.add(args[j]);
                            System.out.println("import dirname value=" + args[j]);
                            continue;
                        }
                        if (j != i) continue block1;
                        System.out.println("--import-directory option does not include a value, args[j-" + j + "]=" + args[j]);
                        this.printUsage();
                    }
                    continue;
                }
                strLen = "--import-path".length();
                if (args[i].length() <= strLen) continue;
                this.mUseNamedOutputDir = true;
                this.mOutputDirNameList.add(args[i].substring(strLen + 1));
                continue;
            }
            if (args[i].equalsIgnoreCase("--dev-env")) {
                this.mDevEnv = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--verbose")) {
                this.mVerbose = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("--help")) continue;
            this.printUsage();
            System.exit(0);
        }
    }

    public void printUsage() {
        if (sExportOperation) {
            System.out.println("");
            System.out.println("usage: ji-export [OPTIONS]");
            System.out.println("Specify repository resources such as reports, images, folders, users,");
            System.out.println("roles, and scheduled jobs to export to an XML format file on disk.");
            System.out.println("The export file is known as a \"repository catalog\" file.");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  --uri             URI path of a repository resource");
            System.out.println("  --users           comma separated list of users to export");
            System.out.println("  --roles           comma separated list of roles to export");
            System.out.println("  --scheduled-jobs  comma separated list of scheduled jobs to export");
            System.out.println("                    (specify the URI path of the associated report)");
            System.out.println("  --export-path     path for export catalog file");
            System.out.println("  --export-file     name of export catalog file");
            System.out.println("  --help            print usage message");
            System.out.println("  --verbose         print flag settings used in the operation");
            System.out.println("");
            System.out.println("Examples:");
            System.out.println("  ji-export --uri=/reports/samples/AllAccounts");
            System.out.println("  ji-export --uri=/reports");
            System.out.println("  ji-export --uri=/images/JRLogo --users=jasperadmin,joeuser");
            System.out.println("  ji-export --roles=ROLE_USER,ROLE_ADMINISTRATOR");
            System.out.println("  ji-export --uri=/images/JRLogo --export-path=myDir/myDir2 --export-file=myFileName");
            System.out.println("  ji-export --scheduled-jobs=/reports/samples/AllAccounts");
            System.out.println("  ji-export --uri=/images/JRLogo --users=jasperadmin,joeuser");
            System.out.println("  ji-export --uri=/images/JRLogo --users=jasperadmin,joeuser");
            System.out.println("  ji-export --uri=/images/JRLogo --users=jasperadmin,joeuser");
            System.out.println("");
            System.out.println("Notes:");
            System.out.println("  The --uri option only allows for specifying one resource (ie a list of");
            System.out.println("  resources is not currently supported). A URI can specify a resource such as");
            System.out.println("  a ReportUnit. In this case, all associated resources such as images, ");
            System.out.println("  sub-reports, datasources, resource bundles, and classfiles will be exported.");
            System.out.println("  A URI can also specify a folder. If a folder is specified, the export operation");
            System.out.println("  will export all files and folders contained in the folder. In addition, it will");
            System.out.println("  recurse through all sub-folders.");
            System.out.println("");
            System.out.println("  If you export a user, the user information will be exported. In addition, the export");
            System.out.println("  will keep information on roles that the user belongs to. On the import operation,");
            System.out.println("  if the role names exist, the user will be added to these roles.");
            System.out.println("");
            System.out.println("  Special handling for roles: if you specify roles to export (and do not specify ");
            System.out.println("  users to export), the associated users will also get exported. This is in order");
            System.out.println("  to support the functionality where you, for instance, specify two roles ROLE_USER ");
            System.out.println("  and ROLE_ADMINISTRATOR, and you would like all users who belong to these two roles to");
            System.out.println("  also be exported. This is the current default behavior for roles.");
            System.out.println("  Todo: enable this functionality with a --include-users-with-role option");
            System.out.println("");
            System.out.println("  If no catalog path or catalog file is specified, the default of ");
            System.out.println("  target/ji-catalog/ji-catalog.xml will be used.");
            System.out.println("");
            System.out.println("");
        } else if (sImportOperation) {
            System.out.println("");
            System.out.println("usage: ji-import [OPTIONS]");
            System.out.println("Read a repository catalog file from disk (created using the ji-export command) and ");
            System.out.println("create the named resources in the current JapserIntelligence application repository.");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  --prepend-path    string to prepend to a URI path for all imported resources");
            System.out.println("  --import-path     path for import catalog file");
            System.out.println("  --import-file     name of import catalog file");
            System.out.println("  --help            print usage message");
            System.out.println("  --verbose         print flag settings used in the operation");
            System.out.println("");
            System.out.println("Examples:");
            System.out.println("  ji-import");
            System.out.println("  ji-import --import-path=myDir/myDir2 --import-file=myFileName");
            System.out.println("  ji-import --prepend-path=myNewDir");
            System.out.println("");
            System.out.println("Notes:");
            System.out.println("  The prepend-path option is handy for avoiding uri path conflicts on an import operation.");
            System.out.println("  If the resource in the catalog file is \"/images/JRLogo\" and you set a prepend-path of \"myNewDir\"");
            System.out.println("  then the resource will be imported and created under the URI path \"/myNewDir/images/JRLogo \".");
            System.out.println("  So, if you are importing a set of resources into a repository and there is the possibility of");
            System.out.println("  URI naming conflicts in the target repository, adding a prepend-path can help avoid these ");
            System.out.println("  these naming conflicts.");
            System.out.println("");
            System.out.println("  On an import operation, if a resource is found in the target repository that has the same URI");
            System.out.println("  as the resource that is attempting to be created, the create operation will be skipped and");
            System.out.println("  the existing resource will be left unchanged (ie. an overwrite will not occur).");
            System.out.println("");
            System.out.println("");
        } else {
            System.out.println("ExportImportCommand: unknown usage");
        }
    }

    protected void printoutOperationValues() {
        if (this.mVerbose) {
            if (sExportOperation) {
                System.out.println("");
                System.out.println("------ Export Operation Values: ");
                System.out.println("   --- mProcessUri=" + this.mProcessUri);
                System.out.println("   --- mProcessUsers=" + this.mProcessUsers);
                System.out.println("   --- mProcessRoles=" + this.mProcessRoles);
                System.out.println("   --- mProcessJobReportUnits=" + this.mProcessJobReportUnits);
                System.out.println("   --- mProcessNothing=" + this.mProcessNothing);
                System.out.println("   ---  additional: mUseNamedOutputDir=" + this.mUseNamedOutputDir);
                System.out.println("   ---  additional: mOutputDirName=" + this.mOutputDirName);
                System.out.println("   ---  additional: mUseNamedOutputFile=" + this.mUseNamedOutputFile);
                System.out.println("   ---  additional: mOutputFileName=" + this.mOutputFileName);
                System.out.println("   ---  additional: mVerbose=" + this.mVerbose);
                System.out.println("   ---  additional: mDevEnv=" + this.mDevEnv);
                System.out.println("");
            } else if (sImportOperation) {
                System.out.println("");
                System.out.println("------ Import Operation Values: ");
                System.out.println("   --- mImportProcessPrependPath=" + this.mImportProcessPrependPath);
                System.out.println("   ---  additional: mUseNamedOutputDir=" + this.mUseNamedOutputDir);
                System.out.println("   ---  additional: mOutputDirName=" + this.mOutputDirName);
                System.out.println("   ---  additional: mUseNamedOutputFile=" + this.mUseNamedOutputFile);
                System.out.println("   ---  additional: mOutputFileName=" + this.mOutputFileName);
                System.out.println("   ---  additional: mVerbose=" + this.mVerbose);
                System.out.println("   ---  additional: mDevEnv=" + this.mDevEnv);
                System.out.println("");
            } else {
                System.out.println("ERROR: unknown operation");
            }
        }
    }

    protected void setUpRepositoryConnections() {
        ClassPathXmlApplicationContext appContext = null;
        try {
            if (this.mDevEnv) {
                System.out.println("ExportImportCommand: - running DEV Env mode");
                appContext = new ClassPathXmlApplicationContext(new String[]{"hibernateConfig.xml", "viewService.xml", "userAuthorityService.xml", "engine.xml"});
                this.mRepo = (RepositoryService)appContext.getBean("repoService");
            } else {
                System.out.println("ExportImportCommand: - running PROD Env mode");
                appContext = new ClassPathXmlApplicationContext(new String[]{"applicationContext-for-export.xml", "applicationContext-report-scheduling-for-export.xml"});
                this.mRepo = (RepositoryService)appContext.getBean("repositoryService");
            }
            this.mAuth = (UserAuthorityService)appContext.getBean("userAuthorityService");
            this.mReportScheduler = (ReportSchedulingService)appContext.getBean(REPORT_SCHEDULING_SERVICE_BEAN_NAME);
            this.mReportSchedulerInternal = (ReportSchedulingInternalService)appContext.getBean(REPORT_SCHEDULING_INTERNAL_SERVICE_BEAN_NAME);
            this.encodingProvider = (CharacterEncodingProvider)appContext.getBean(ENCODING_PROVIDER_BEAN_NAME);
            this.mContext = new ExecutionContextImpl();
        }
        catch (Exception e) {
            System.out.println("ExportImportCommand: caught exception, exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

