/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataSource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.util.ContentResourceBean;
import com.jaspersoft.jasperserver.util.DataSourceBean;
import com.jaspersoft.jasperserver.util.DataTypeBean;
import com.jaspersoft.jasperserver.util.ExportImportBean;
import com.jaspersoft.jasperserver.util.ExportImportUtils;
import com.jaspersoft.jasperserver.util.FileResourceBean;
import com.jaspersoft.jasperserver.util.FolderBean;
import com.jaspersoft.jasperserver.util.InputControlBean;
import com.jaspersoft.jasperserver.util.JdbcDataSourceBean;
import com.jaspersoft.jasperserver.util.JndiJdbcDataSourceBean;
import com.jaspersoft.jasperserver.util.ListOfValuesBean;
import com.jaspersoft.jasperserver.util.ListOfValuesItemBean;
import com.jaspersoft.jasperserver.util.MappingHelper;
import com.jaspersoft.jasperserver.util.MondrianConnectionBean;
import com.jaspersoft.jasperserver.util.MondrianXmlaDefinitionBean;
import com.jaspersoft.jasperserver.util.OlapClientConnectionBean;
import com.jaspersoft.jasperserver.util.OlapUnitBean;
import com.jaspersoft.jasperserver.util.ParameterBean;
import com.jaspersoft.jasperserver.util.QueryBean;
import com.jaspersoft.jasperserver.util.ReportJobBean;
import com.jaspersoft.jasperserver.util.ReportJobCalendarTriggerBean;
import com.jaspersoft.jasperserver.util.ReportJobMailNotificationBean;
import com.jaspersoft.jasperserver.util.ReportJobRepositoryDestinationBean;
import com.jaspersoft.jasperserver.util.ReportJobSimpleTriggerBean;
import com.jaspersoft.jasperserver.util.ReportJobSourceBean;
import com.jaspersoft.jasperserver.util.ReportJobTriggerBean;
import com.jaspersoft.jasperserver.util.ReportUnitBean;
import com.jaspersoft.jasperserver.util.ResourceBean;
import com.jaspersoft.jasperserver.util.RoleBean;
import com.jaspersoft.jasperserver.util.UserBean;
import com.jaspersoft.jasperserver.util.UserRoleHolderBean;
import com.jaspersoft.jasperserver.util.XmlaConnectionBean;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Marshaller;

public class ExportResource {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$util$ExportResource == null ? (class$com$jaspersoft$jasperserver$util$ExportResource = ExportResource.class$("com.jaspersoft.jasperserver.util.ExportResource")) : class$com$jaspersoft$jasperserver$util$ExportResource));
    public static final String PATH_SEP = "/";
    public static final String CATALOG_DIR_NAME = "target/ji-catalog";
    public static final String CATALOG_FILE_NAME = "ji-catalog.xml";
    public static final String PRODUCT_VERSION_1_0 = "1.0";
    public static final String PRODUCT_VERSION_0_9_2 = "0.9.2";
    public static final String PRODUCT_VERSION_1_1_0 = "1.1.0";
    public static final String PRODUCT_VERSION = "1.1.0";
    public static final boolean TOP_LEVEL_OBJECT = true;
    public static final boolean NOT_TOP_LEVEL_OBJECT = false;
    private RepositoryService mRepo;
    private UserAuthorityService mAuth;
    private ReportSchedulingService mReportScheduler;
    private ExecutionContext mContext;
    private String mStartUri;
    private boolean mProcessUsersRoles;
    private String[] mUserNames;
    private String[] mRoleNames;
    private boolean mProcessReportJobs;
    private String[] mReportJobUnitNames;
    private String mCatalogDirName;
    private String mCatalogFileName;
    private final String mCharacterEncoding;
    private FilterCriteria filterCriteria;
    private ExportImportBean mExportImportBean;
    boolean mProcessUserRoleOnly = false;
    boolean mProcessUriOnly = false;
    boolean mProcessReportJobsOnly = false;
    boolean mProcessAll = false;
    boolean mProcessNothing = false;
    private boolean mIsAllUsersRoles = false;
    private boolean mIsNamedUsers = false;
    private boolean mIsNamedRoles = false;
    private boolean mIsNamedUsersRoles = false;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$util$ExportResource;

    public static void main(String[] args) {
    }

    public ExportResource(RepositoryService repo, UserAuthorityService userAuthService, ReportSchedulingService reportSchedulingService, ExecutionContext context, String startUri, boolean processUsersRoles, String[] userNames, String[] roleNames, boolean processReportJobs, String[] reportJobUnitNames, String catalogDirName, String catalogFileName) {
        this(repo, userAuthService, reportSchedulingService, context, startUri, processUsersRoles, userNames, roleNames, processReportJobs, reportJobUnitNames, catalogDirName, catalogFileName, ExportImportUtils.getDefaultCharacterEncoding());
    }

    public ExportResource(RepositoryService repo, UserAuthorityService userAuthService, ReportSchedulingService reportSchedulingService, ExecutionContext context, String startUri, boolean processUsersRoles, String[] userNames, String[] roleNames, boolean processReportJobs, String[] reportJobUnitNames, String catalogDirName, String catalogFileName, String characterEncoding) {
        this.mRepo = repo;
        this.mAuth = userAuthService;
        this.mReportScheduler = reportSchedulingService;
        this.mContext = context;
        this.mStartUri = startUri;
        this.mProcessUsersRoles = processUsersRoles;
        this.mUserNames = userNames;
        this.mRoleNames = roleNames;
        this.mProcessReportJobs = processReportJobs;
        this.mReportJobUnitNames = reportJobUnitNames;
        this.mCatalogDirName = catalogDirName;
        this.mCatalogFileName = catalogFileName;
        this.mCharacterEncoding = characterEncoding;
        this.filterCriteria = new FilterCriteria();
    }

    protected void checkForProcessing() {
        boolean processUri = false;
        processUri = this.mStartUri != null && this.mStartUri.length() != 0;
        if (processUri && this.mProcessUsersRoles) {
            this.mProcessAll = true;
        } else if (processUri && !this.mProcessUsersRoles) {
            this.mProcessUriOnly = true;
        } else if (!processUri && this.mProcessUsersRoles) {
            this.mProcessUserRoleOnly = true;
        } else if (!processUri && !this.mProcessUsersRoles && this.mProcessReportJobs) {
            this.mProcessReportJobsOnly = true;
        } else {
            this.mProcessNothing = true;
            log.error((Object)"ERROR: Nothing to process. Check for valid inputs.");
        }
        log.warn((Object)"----- Processing Values:");
        log.warn((Object)("        mProcessAll=" + this.mProcessAll));
        log.warn((Object)("        mProcessUriOnly=" + this.mProcessUriOnly));
        log.warn((Object)("        mProcessUserRoleOnly=" + this.mProcessUserRoleOnly));
        log.warn((Object)("        mProcessReportJobsOnly=" + this.mProcessReportJobsOnly));
        log.warn((Object)("        mProcessNothing=" + this.mProcessNothing));
        System.out.println("----- Processing Values:");
        System.out.println("        mProcessAll=" + this.mProcessAll);
        System.out.println("        mProcessUriOnly=" + this.mProcessUriOnly);
        System.out.println("        mProcessUserRoleOnly=" + this.mProcessUserRoleOnly);
        System.out.println("        mProcessReportJobsOnly=" + this.mProcessReportJobsOnly);
        System.out.println("        mProcessNothing=" + this.mProcessNothing);
    }

    public void process() {
        System.out.println("ExportResource: top of process()");
        log.debug((Object)"top of process()");
        this.mExportImportBean = new ExportImportBean();
        this.mExportImportBean.setVersion("1.1.0");
        this.checkForProcessing();
        if (this.mProcessUriOnly) {
            this.processUri();
        } else if (this.mProcessUserRoleOnly) {
            this.processUsersRoles();
        } else if (this.mProcessReportJobsOnly) {
            this.processReportJobs(true);
        } else if (this.mProcessAll) {
            this.processUsersRoles();
            this.processReportJobs(true);
            this.processUri();
        } else if (this.mProcessNothing) {
            log.warn((Object)"WARN: Nothing to process. Check for valid inputs");
        } else {
            log.error((Object)"ERROR: Unknown processing operation. Check for valid inputs");
        }
    }

    public void processUri() {
        block15: {
            try {
                Resource res = this.mRepo.getResource(null, this.mStartUri);
                if (res == null) {
                    Folder folder = this.mRepo.getFolder(null, this.mStartUri);
                    if (folder != null) {
                        this.process(folder, true);
                        break block15;
                    }
                    throw new Exception("unknown resource uri, uri=" + this.mStartUri);
                }
                if (res instanceof ReportUnit) {
                    this.process((ReportUnit)res, true);
                    break block15;
                }
                if (res instanceof OlapUnit) {
                    this.process((OlapUnit)res, true);
                    break block15;
                }
                if (res instanceof FileResource) {
                    this.process((FileResource)res, true);
                    break block15;
                }
                if (res instanceof ContentResource) {
                    this.process((ContentResource)res, true);
                    break block15;
                }
                if (res instanceof DataSource) {
                    this.process((DataSource)res, true);
                    break block15;
                }
                if (res instanceof OlapClientConnection) {
                    this.process((OlapClientConnection)res, true);
                    break block15;
                }
                if (res instanceof MondrianXMLADefinition) {
                    this.process((MondrianXMLADefinition)res, true);
                    break block15;
                }
                if (res instanceof InputControl) {
                    this.process((InputControl)res, true);
                    break block15;
                }
                if (res instanceof DataType) {
                    this.process((DataType)res, true);
                    break block15;
                }
                if (res instanceof ListOfValues) {
                    this.process((ListOfValues)res, true);
                    break block15;
                }
                if (res instanceof Query) {
                    this.process((Query)res, true);
                    break block15;
                }
                throw new Exception("Unhandled resourceType, resourceType=" + res.getResourceType());
            }
            catch (Exception e) {
                log.error((Object)(" caught exception: " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public void processUsersRoles() {
        this.checkForUserRoleProcessing();
        UserRoleHolderBean bean = null;
        if (this.mIsAllUsersRoles) {
            bean = this.processAllUsersRoles(true);
        } else if (this.mIsNamedUsers) {
            bean = this.processNamedUsers(this.mUserNames, true);
        } else if (this.mIsNamedRoles) {
            bean = this.processNamedRoles(this.mRoleNames, true);
        } else if (this.mIsNamedUsersRoles) {
            bean = this.processNamedUsersRoles(this.mUserNames, this.mRoleNames, true);
        } else {
            log.error((Object)"ERROR: unknown user-role operation type");
        }
        this.mExportImportBean.setUserRoleHolder(bean);
        if (this.mProcessUserRoleOnly) {
            this.writeCatalogFile(this.mExportImportBean);
        }
    }

    public void processReportJobs(boolean isTopLevel) {
        if (this.mReportJobUnitNames != null) {
            ArrayList<ReportJobBean> reportJobBeanList = new ArrayList<ReportJobBean>();
            for (int i = 0; i < this.mReportJobUnitNames.length; ++i) {
                List jobs = this.mReportScheduler.getScheduledJobs(this.mContext, this.mReportJobUnitNames[i]);
                if (jobs == null || jobs.isEmpty()) continue;
                Iterator it = jobs.iterator();
                while (it.hasNext()) {
                    ReportJobSummary sum = (ReportJobSummary)it.next();
                    ReportJob job = this.mReportScheduler.getScheduledJob(this.mContext, sum.getId());
                    reportJobBeanList.add(this.process(job, false));
                }
            }
            ReportJobBean[] reportJobs = null;
            if (reportJobBeanList != null && reportJobBeanList.size() > 0) {
                reportJobs = new ReportJobBean[reportJobBeanList.size()];
                int j = 0;
                Iterator it2 = reportJobBeanList.iterator();
                while (it2.hasNext()) {
                    reportJobs[j] = (ReportJobBean)it2.next();
                    ++j;
                }
            }
            this.mExportImportBean.setReportJobs(reportJobs);
            if (this.mProcessReportJobsOnly) {
                this.writeCatalogFile(this.mExportImportBean);
            }
        }
    }

    public FolderBean process(Folder topFolder, boolean isTopLevel) {
        FolderBean topFolderBean = new FolderBean();
        this.fillCommonBeanFields(topFolderBean, (Resource)topFolder);
        ResourceBean[] resourceBeans = this.handleResourcesInFolder(topFolder);
        topFolderBean.setResources(resourceBeans);
        List subFolders = this.mRepo.getSubFolders(null, topFolder.getURIString());
        FolderBean[] subFolderBeans = new FolderBean[subFolders.size()];
        int i = 0;
        Iterator it = subFolders.iterator();
        while (it.hasNext()) {
            subFolderBeans[i] = new FolderBean();
            this.processFolder((Folder)it.next(), subFolderBeans[i]);
            ++i;
        }
        topFolderBean.setFolders(subFolderBeans);
        if (isTopLevel) {
            this.mExportImportBean.setResource(topFolderBean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(topFolderBean);
        }
        return topFolderBean;
    }

    public void processFolder(Folder folder, FolderBean bean) {
        this.fillCommonBeanFields(bean, (Resource)folder);
        ResourceBean[] resourceBeans = this.handleResourcesInFolder(folder);
        bean.setResources(resourceBeans);
        List subFolders = this.mRepo.getSubFolders(null, folder.getURIString());
        FolderBean[] subFolderBeans = new FolderBean[subFolders.size()];
        int i = 0;
        Iterator it = subFolders.iterator();
        while (it.hasNext()) {
            subFolderBeans[i] = new FolderBean();
            this.processFolder((Folder)it.next(), subFolderBeans[i]);
            ++i;
        }
        bean.setFolders(subFolderBeans);
    }

    public FileResourceBean process(FileResource fileResource, boolean isTopLevel) {
        FileResourceBean bean = new FileResourceBean();
        this.fillBean(bean, fileResource);
        if (fileResource.isReference()) {
            bean.setIsReference(fileResource.isReference());
            bean.setReferenceUri(fileResource.getReferenceURI());
            FileResourceBean targetBean = this.process((FileResource)this.mRepo.getResource(this.mContext, fileResource.getReferenceURI()), false);
            bean.setLinkTarget(targetBean);
        } else {
            bean.setFileType(fileResource.getFileType());
        }
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(bean);
        }
        return bean;
    }

    public ContentResourceBean process(ContentResource contentResource, boolean isTopLevel) {
        log.debug((Object)"top of process(ContentResource)");
        ContentResourceBean bean = new ContentResourceBean();
        this.fillBean(bean, contentResource);
        if (contentResource.isReference()) {
            bean.setReferenceUri(contentResource.getReferenceURI());
            ContentResourceBean targetBean = this.process((ContentResource)this.mRepo.getResource(this.mContext, contentResource.getReferenceURI()), false);
            bean.setLinkTarget(targetBean);
            bean.setFileType(contentResource.getFileType());
        } else {
            bean.setFileType(contentResource.getFileType());
        }
        if (contentResource.getResources() != null) {
            List resources = contentResource.getResources();
            ContentResourceBean[] childResources = new ContentResourceBean[resources.size()];
            int i = 0;
            Iterator it = resources.iterator();
            while (it.hasNext()) {
                childResources[i] = this.process((ContentResource)it.next(), false);
                ++i;
            }
            bean.setResources(childResources);
        }
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(bean);
        }
        return bean;
    }

    public ReportUnitBean process(ReportUnit reportUnit, boolean isTopLevel) {
        ReportUnitBean bean = new ReportUnitBean();
        this.fillCommonBeanFields(bean, (Resource)reportUnit);
        if (reportUnit.getDataSource() != null) {
            Resource dataSource = this.dereference(null, reportUnit.getDataSource());
            DataSourceBean dsBean = this.process((DataSource)dataSource, false);
            if (reportUnit.getDataSource().isLocal()) {
                dsBean.setIsUriReference(false);
            } else {
                dsBean.setIsUriReference(true);
            }
            bean.setDataSource(dsBean);
        }
        if (reportUnit.getQuery() != null) {
            Query query = (Query)this.dereference(null, reportUnit.getQuery());
            QueryBean queryBean = this.process(query, false);
            if (reportUnit.getQuery().isLocal()) {
                queryBean.setIsUriReference(false);
            } else {
                queryBean.setIsUriReference(true);
            }
            bean.setQuery(queryBean);
        }
        if (reportUnit.getMainReport() != null) {
            FileResource reportRes = (FileResource)this.dereference(null, reportUnit.getMainReport());
            FileResourceBean reportBean = this.process(reportRes, false);
            if (reportUnit.getMainReport().isLocal()) {
                reportBean.setIsUriReference(false);
            } else {
                reportBean.setIsUriReference(true);
            }
            bean.setMainReport(reportBean);
        }
        if (reportUnit.getInputControls() != null) {
            InputControlBean[] inputControlBeans = this.handleInputControls(reportUnit, false);
            bean.setInputControls(inputControlBeans);
        }
        if (reportUnit.getResources() != null) {
            List resources = reportUnit.getResources();
            FileResourceBean[] resourcesArray = new FileResourceBean[resources.size()];
            int i = 0;
            Iterator it = resources.iterator();
            while (it.hasNext()) {
                FileResource res = (FileResource)this.dereference(null, (ResourceReference)it.next());
                if (res instanceof FileResource) {
                    FileResourceBean frBean;
                    resourcesArray[i] = frBean = this.process(res, false);
                } else {
                    log.error((Object)("ERROR: unexpected report unit resource type, res.name=" + res.getName()));
                }
                ++i;
            }
            bean.setResources(resourcesArray);
        }
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(bean);
        }
        return bean;
    }

    public OlapUnitBean process(OlapUnit unit, boolean isTopLevel) {
        log.debug((Object)"top of process(OlapUnit)");
        OlapUnitBean bean = new OlapUnitBean();
        this.fillBean(bean, unit);
        OlapClientConnection conn = (OlapClientConnection)this.dereference(this.mContext, unit.getOlapClientConnection());
        OlapClientConnectionBean connBean = this.process(conn, false);
        if (unit.getOlapClientConnection().isLocal()) {
            connBean.setIsUriReference(false);
        } else {
            connBean.setIsUriReference(true);
        }
        bean.setOlapClientConnection(connBean);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(bean);
        }
        return bean;
    }

    public OlapClientConnectionBean process(OlapClientConnection conn, boolean isTopLevel) {
        log.debug((Object)"top of process(OlapClientConnection)");
        if (conn instanceof XMLAConnection) {
            return this.process((XMLAConnection)conn, isTopLevel);
        }
        if (conn instanceof MondrianConnection) {
            return this.process((MondrianConnection)conn, isTopLevel);
        }
        log.error((Object)("Unknown OlapClientConnection type, conn.uri=" + conn.getURIString()));
        return null;
    }

    public XmlaConnectionBean process(XMLAConnection conn, boolean isTopLevel) {
        XmlaConnectionBean bean = new XmlaConnectionBean();
        this.fillBean(bean, conn);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public MondrianConnectionBean process(MondrianConnection conn, boolean isTopLevel) {
        MondrianConnectionBean bean = new MondrianConnectionBean();
        this.fillBean(bean, conn);
        FileResource schema = (FileResource)this.dereference(this.mContext, conn.getSchema());
        FileResourceBean schemaBean = this.process(schema, false);
        if (conn.getSchema().isLocal()) {
            schemaBean.setIsUriReference(false);
        } else {
            schemaBean.setIsUriReference(true);
        }
        bean.setSchema(schemaBean);
        DataSource ds = (DataSource)this.dereference(this.mContext, conn.getDataSource());
        DataSourceBean dsBean = this.process(ds, false);
        if (conn.getDataSource().isLocal()) {
            dsBean.setIsUriReference(false);
        } else {
            dsBean.setIsUriReference(true);
        }
        bean.setDataSource(dsBean);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(bean);
        }
        return bean;
    }

    public MondrianXmlaDefinitionBean process(MondrianXMLADefinition xDef, boolean isTopLevel) {
        log.debug((Object)"top of process(MondrianXMLADefinition)");
        MondrianXmlaDefinitionBean bean = new MondrianXmlaDefinitionBean();
        this.fillBean(bean, xDef);
        MondrianConnection conn = (MondrianConnection)this.dereference(this.mContext, xDef.getMondrianConnection());
        MondrianConnectionBean mondBean = this.process(conn, false);
        if (xDef.getMondrianConnection().isLocal()) {
            mondBean.setIsUriReference(false);
        } else {
            mondBean.setIsUriReference(true);
        }
        bean.setMondrianConnection(mondBean);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
            this.writeCatalogData(bean);
        }
        return bean;
    }

    public DataSourceBean process(DataSource dataSource, boolean isTopLevel) {
        if (dataSource instanceof JdbcReportDataSource) {
            return this.process((JdbcReportDataSource)dataSource, isTopLevel);
        }
        if (dataSource instanceof JndiJdbcReportDataSource) {
            return this.process((JndiJdbcReportDataSource)dataSource, isTopLevel);
        }
        log.error((Object)("Unknown datasource type, dataSource.name=" + dataSource.getName()));
        return null;
    }

    public JdbcDataSourceBean process(JdbcReportDataSource dataSource, boolean isTopLevel) {
        JdbcDataSourceBean bean = new JdbcDataSourceBean();
        this.fillBean(bean, dataSource);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public JndiJdbcDataSourceBean process(JndiJdbcReportDataSource dataSource, boolean isTopLevel) {
        JndiJdbcDataSourceBean bean = new JndiJdbcDataSourceBean();
        this.fillBean(bean, dataSource);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public InputControlBean process(InputControl inputControl, boolean isTopLevel) {
        log.debug((Object)"top of process(InputControl)");
        InputControlBean bean = new InputControlBean();
        this.fillBean(bean, inputControl);
        if (inputControl.getDataType() != null) {
            DataType dataType = (DataType)this.dereference(null, inputControl.getDataType());
            DataTypeBean dataTypeBean = this.process(dataType, false);
            if (inputControl.getDataType().isLocal()) {
                dataTypeBean.setIsUriReference(false);
            } else {
                dataTypeBean.setIsUriReference(true);
            }
            bean.setDataType(dataTypeBean);
        }
        if (inputControl.getListOfValues() != null) {
            ListOfValues listOfValues = (ListOfValues)this.dereference(null, inputControl.getListOfValues());
            ListOfValuesBean listOfValuesBean = this.process(listOfValues, false);
            if (inputControl.getListOfValues().isLocal()) {
                listOfValuesBean.setIsUriReference(false);
            } else {
                listOfValuesBean.setIsUriReference(true);
            }
            bean.setListOfValues(listOfValuesBean);
        }
        if (inputControl.getQuery() != null) {
            Query query = (Query)this.dereference(null, inputControl.getQuery());
            QueryBean queryBean = this.process(query, false);
            if (inputControl.getQuery().isLocal()) {
                queryBean.setIsUriReference(false);
            } else {
                queryBean.setIsUriReference(true);
            }
            bean.setQuery(queryBean);
        }
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public QueryBean process(Query query, boolean isTopLevel) {
        QueryBean bean = new QueryBean();
        this.fillBean(bean, query);
        if (query.getDataSource() != null) {
            DataSource dataSource = (DataSource)this.dereference(null, query.getDataSource());
            DataSourceBean dsBean = this.process(dataSource, false);
            if (query.getDataSource().isLocal()) {
                dsBean.setIsUriReference(false);
            } else {
                dsBean.setIsUriReference(true);
            }
            bean.setDataSource(dsBean);
        }
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public DataTypeBean process(DataType dataType, boolean isTopLevel) {
        DataTypeBean bean = new DataTypeBean();
        this.fillBean(bean, dataType);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public ListOfValuesBean process(ListOfValues listOfValues, boolean isTopLevel) {
        ListOfValuesBean bean = new ListOfValuesBean();
        this.fillBean(bean, listOfValues);
        if (isTopLevel) {
            this.mExportImportBean.setResource(bean);
            this.writeCatalogFile(this.mExportImportBean);
        }
        return bean;
    }

    public ReportJobBean process(ReportJob job, boolean isTopLevel) {
        ReportJobBean bean = new ReportJobBean();
        bean.setId(job.getId());
        bean.setVersion(job.getVersion());
        bean.setUsername(job.getUsername());
        bean.setLabel(job.getLabel());
        bean.setDescription(job.getDescription());
        bean.setBaseOutputFilename(job.getBaseOutputFilename());
        bean.setOutputLocale(job.getOutputLocale());
        ReportJobTrigger trigger = job.getTrigger();
        if (trigger != null) {
            ReportJobTriggerBean jtBean;
            if (trigger instanceof ReportJobSimpleTrigger) {
                jtBean = new ReportJobSimpleTriggerBean();
                jtBean.copyFrom(trigger);
            } else if (trigger instanceof ReportJobCalendarTrigger) {
                jtBean = new ReportJobCalendarTriggerBean();
                jtBean.copyFrom(trigger);
            } else {
                String quotedTriggerType = "\"" + trigger.getClass().getName() + "\"";
                throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedTriggerType});
            }
            bean.setTrigger(jtBean);
        }
        if (job.getSource() != null) {
            ReportJobSourceBean srcBean = new ReportJobSourceBean();
            ReportJobSource src = job.getSource();
            srcBean.setReportUnitURI(src.getReportUnitURI());
            if (src.getParametersMap() != null) {
                Map parms = src.getParametersMap();
                Set keys = parms.keySet();
                ParameterBean[] parmBeans = new ParameterBean[keys.size()];
                int i = 0;
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = parms.get(key).toString();
                    ParameterBean pb = new ParameterBean();
                    pb.setKey(key);
                    pb.setValue(value);
                    parmBeans[i] = pb;
                    ++i;
                }
                srcBean.setParameters(parmBeans);
            }
            bean.setSource(srcBean);
        }
        if (job.getOutputFormats() != null) {
            Set outputFormats = job.getOutputFormats();
            byte[] outArray = new byte[outputFormats.size()];
            int i = 0;
            Iterator it = outputFormats.iterator();
            while (it.hasNext()) {
                outArray[i] = (Byte)it.next();
                ++i;
            }
            bean.setOutputFormats(outArray);
        }
        if (job.getContentRepositoryDestination() != null) {
            ReportJobRepositoryDestinationBean destBean = new ReportJobRepositoryDestinationBean();
            ReportJobRepositoryDestination dest = job.getContentRepositoryDestination();
            destBean.setId(dest.getId());
            destBean.setVersion(dest.getVersion());
            destBean.setFolderURI(dest.getFolderURI());
            destBean.setSequentialFilenames(dest.isSequentialFilenames());
            destBean.setOverwriteFiles(dest.isOverwriteFiles());
            bean.setContentRepositoryDestination(destBean);
        }
        if (job.getMailNotification() != null) {
            ReportJobMailNotificationBean noteBean = new ReportJobMailNotificationBean();
            ReportJobMailNotification note = job.getMailNotification();
            noteBean.setId(note.getId());
            noteBean.setVersion(note.getVersion());
            if (note.getToAddresses() != null) {
                noteBean.setToAddresses(note.getToAddresses().toArray(new String[note.getToAddresses().size()]));
            }
            noteBean.setSubject(note.getSubject());
            noteBean.setMessageText(note.getMessageText());
            noteBean.setResultSendType(note.getResultSendType());
            bean.setMailNotification(noteBean);
        }
        return bean;
    }

    public UserRoleHolderBean processAllUsersRoles(boolean isTopLevel) {
        UserRoleHolderBean bean = new UserRoleHolderBean();
        List userList = this.mAuth.getUsers(this.mContext, this.filterCriteria);
        String[] usernames = new String[userList.size()];
        int i = 0;
        Iterator it = userList.iterator();
        while (it.hasNext()) {
            usernames[i] = ((User)it.next()).getUsername();
            ++i;
        }
        bean.setUsers(this.handleUsers(usernames, false));
        List roleList = this.mAuth.getRoles(this.mContext, this.filterCriteria);
        String[] rolenames = new String[roleList.size()];
        int j = 0;
        Iterator it2 = roleList.iterator();
        while (it2.hasNext()) {
            rolenames[j] = ((Role)it2.next()).getRoleName();
            ++j;
        }
        bean.setRoles(this.handleRoles(rolenames, false));
        if (isTopLevel) {
            // empty if block
        }
        return bean;
    }

    public UserRoleHolderBean processNamedUsers(String[] usernames, boolean isTopLevel) {
        UserRoleHolderBean bean = new UserRoleHolderBean();
        bean.setUsers(this.handleUsers(usernames, false));
        return bean;
    }

    public UserRoleHolderBean processNamedRoles(String[] rolenames, boolean isTopLevel) {
        UserRoleHolderBean bean = new UserRoleHolderBean();
        RoleBean[] roleBeans = this.handleRoles(rolenames, false);
        bean.setRoles(roleBeans);
        UserBean[] userBeans = this.getUsersFromRole(roleBeans);
        bean.setUsers(userBeans);
        return bean;
    }

    public UserRoleHolderBean processNamedUsersRoles(String[] usernames, String[] rolenames, boolean isTopLevel) {
        UserRoleHolderBean bean = new UserRoleHolderBean();
        bean.setUsers(this.handleUsers(usernames, false));
        bean.setRoles(this.handleRoles(rolenames, false));
        return bean;
    }

    public UserBean[] handleUsers(String[] usernames, boolean isTopLevel) {
        UserBean[] userBeans = new UserBean[usernames.length];
        for (int i = 0; i < usernames.length; ++i) {
            UserBean bean = new UserBean();
            User user = this.mAuth.getUser(this.mContext, usernames[i]);
            bean.setUsername(user.getUsername());
            bean.setFullName(user.getFullName());
            bean.setPassword(user.getPassword());
            bean.setEmailAddress(user.getEmailAddress());
            bean.setExternallyDefined(user.isExternallyDefined());
            bean.setEnabled(user.isEnabled());
            bean.setRoleSet(this.getRolesFromUser(user));
            userBeans[i] = bean;
        }
        return userBeans;
    }

    public RoleBean[] handleRoles(String[] rolenames, boolean isTopLevel) {
        RoleBean[] roleBeans = new RoleBean[rolenames.length];
        for (int i = 0; i < rolenames.length; ++i) {
            RoleBean bean = new RoleBean();
            Role role = this.mAuth.getRole(this.mContext, rolenames[i]);
            bean.setRoleName(role.getRoleName());
            bean.setExternallyDefined(role.isExternallyDefined());
            roleBeans[i] = bean;
        }
        return roleBeans;
    }

    protected RoleBean[] getRolesFromUser(User user) {
        Set roleSet = user.getRoles();
        RoleBean[] roleArray = new RoleBean[roleSet.size()];
        int i = 0;
        Iterator it = roleSet.iterator();
        while (it.hasNext()) {
            RoleBean bean = new RoleBean();
            Role role = (Role)it.next();
            bean.setRoleName(role.getRoleName());
            roleArray[i] = bean;
            ++i;
        }
        return roleArray;
    }

    protected UserBean[] getUsersFromRole(RoleBean[] exportRoleBeans) {
        List userList = this.mAuth.getUsers(this.mContext, this.filterCriteria);
        ArrayList<String> finalUserNameList = new ArrayList<String>();
        Iterator it = userList.iterator();
        while (it.hasNext()) {
            User user = (User)it.next();
            Set roleSet = user.getRoles();
            Iterator it2 = roleSet.iterator();
            while (it2.hasNext()) {
                Role role = (Role)it2.next();
                for (int i = 0; i < exportRoleBeans.length; ++i) {
                    if (!role.getRoleName().equals(exportRoleBeans[i].getRoleName()) || finalUserNameList.contains(user.getUsername())) continue;
                    log.debug((Object)("   Adding this user, username=" + user.getUsername()));
                    finalUserNameList.add(user.getUsername());
                }
            }
        }
        return this.handleUsers(finalUserNameList.toArray(new String[finalUserNameList.size()]), false);
    }

    protected InputControlBean[] handleInputControls(ReportUnit unit, boolean isTopLevel) {
        List inputControls = unit.getInputControls();
        InputControlBean[] inputControlBeans = new InputControlBean[inputControls.size()];
        int i = 0;
        Iterator it = inputControls.iterator();
        while (it.hasNext()) {
            ResourceReference resRef = (ResourceReference)it.next();
            InputControl ic = (InputControl)this.dereference(null, resRef);
            InputControlBean bean = this.process(ic, isTopLevel);
            if (resRef.isLocal()) {
                bean.setIsUriReference(false);
            } else {
                bean.setIsUriReference(true);
            }
            inputControlBeans[i] = bean;
            ++i;
        }
        return inputControlBeans;
    }

    protected FolderBean[] handleSubFolders(Folder topFolder) {
        List subFolders = this.mRepo.getSubFolders(null, topFolder.getURIString());
        FolderBean[] subFolderBeans = new FolderBean[subFolders.size()];
        int i = 0;
        Iterator it = subFolders.iterator();
        while (it.hasNext()) {
            FolderBean bean = new FolderBean();
            Folder folder = (Folder)it.next();
            this.fillCommonBeanFields(bean, (Resource)folder);
            subFolderBeans[i] = bean;
            ++i;
        }
        return subFolderBeans;
    }

    protected ResourceBean[] handleResourcesInFolder(Folder folder) {
        FilterCriteria filterCriteria = new FilterCriteria();
        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folder.getURIString()));
        ResourceLookup[] files = this.mRepo.findResource(null, filterCriteria);
        ResourceBean[] resourceBeans = new ResourceBean[files.length];
        for (int i = 0; i < files.length; ++i) {
            ResourceBean bean;
            log.debug((Object)("file name=" + files[i].getName()));
            Resource res = this.mRepo.getResource(null, files[i].getURIString());
            if (res instanceof ReportUnit) {
                log.debug((Object)"file inst of RU");
                bean = this.process((ReportUnit)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof OlapUnit) {
                log.debug((Object)"file inst of OlapUnit");
                bean = this.process((OlapUnit)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof FileResource) {
                log.debug((Object)"file inst of FR");
                bean = this.process((FileResource)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof ContentResource) {
                log.debug((Object)"file inst of CR");
                bean = this.process((ContentResource)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof DataSource) {
                log.debug((Object)"file inst of DS");
                bean = this.process((DataSource)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof OlapClientConnection) {
                log.debug((Object)"file inst of OlapClientConnection");
                bean = this.process((OlapClientConnection)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof MondrianXMLADefinition) {
                log.debug((Object)"file inst of MondrianXMLADefinition");
                bean = this.process((MondrianXMLADefinition)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof InputControl) {
                log.debug((Object)"file inst of InputControl");
                bean = this.process((InputControl)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof DataType) {
                log.debug((Object)"file inst of DataType");
                bean = this.process((DataType)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof ListOfValues) {
                log.debug((Object)"file inst of ListOfValues");
                bean = this.process((ListOfValues)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            if (res instanceof Query) {
                log.debug((Object)"file inst of Query");
                bean = this.process((Query)res, false);
                resourceBeans[i] = bean;
                continue;
            }
            log.error((Object)("NOT HANDLING THIS RESOURCE TYPE YET, resourceType=" + files[i].getResourceType()));
        }
        return resourceBeans;
    }

    protected void checkForUserRoleProcessing() {
        if (!(this.mUserNames != null && this.mUserNames.length != 0 || this.mRoleNames != null && this.mRoleNames.length != 0)) {
            this.mIsAllUsersRoles = true;
        } else if (this.mUserNames != null && this.mUserNames.length > 0 && (this.mRoleNames == null || this.mRoleNames.length == 0)) {
            this.mIsNamedUsers = true;
        } else if (this.mRoleNames != null && this.mRoleNames.length > 0 && (this.mUserNames == null || this.mUserNames.length == 0)) {
            this.mIsNamedRoles = true;
        } else if (this.mUserNames != null && this.mUserNames.length > 0 && this.mRoleNames != null && this.mRoleNames.length > 0) {
            this.mIsNamedUsersRoles = true;
        } else {
            log.error((Object)"ERROR: User Role processing operation unknown");
        }
        log.warn((Object)" ----- User-Role Processing Values:");
        log.warn((Object)("         mIsAllUsersRoles=" + this.mIsAllUsersRoles));
        log.warn((Object)("         mIsNamedUsers=" + this.mIsNamedUsers));
        log.warn((Object)("         mIsNamedRoles=" + this.mIsNamedRoles));
        log.warn((Object)("         mIsNamedUsersRoles=" + this.mIsNamedUsersRoles));
    }

    protected void writeCatalogFile(ExportImportBean bean) {
        log.debug((Object)"top of writeCatalogFile()");
        try {
            File dir = new File(this.mCatalogDirName);
            dir.mkdir();
            File outCatalog = new File(dir, this.mCatalogFileName);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outCatalog), this.mCharacterEncoding);
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping(MappingHelper.getExportImportBeanMapping());
            marshaller.marshal((Object)bean);
            System.out.println("ExportResource: writeCatalogFile(): catDir=" + this.mCatalogDirName + ", catFile=" + this.mCatalogFileName);
            log.debug((Object)("ExportResource: writeCatalogFile(): outCatalog=" + outCatalog.toString()));
        }
        catch (Exception e) {
            log.error((Object)("caught exception creating catalog file: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected void writeCatalogData(FolderBean bean) {
        ResourceBean[] resourceBeans = bean.getResources();
        for (int i = 0; i < resourceBeans.length; ++i) {
            if (resourceBeans[i] instanceof FileResourceBean) {
                this.writeCatalogData((FileResourceBean)resourceBeans[i]);
                continue;
            }
            if (resourceBeans[i] instanceof ContentResourceBean) {
                this.writeCatalogData((ContentResourceBean)resourceBeans[i]);
                continue;
            }
            if (resourceBeans[i] instanceof ReportUnitBean) {
                this.writeCatalogData((ReportUnitBean)resourceBeans[i]);
                continue;
            }
            log.debug((Object)("DEBUG: skipped bean resource (for write data), name=" + resourceBeans[i].getName()));
        }
        FolderBean[] folderBeans = bean.getFolders();
        for (int j = 0; j < folderBeans.length; ++j) {
            this.writeCatalogDataFolder(folderBeans[j]);
        }
    }

    protected void writeCatalogDataFolder(FolderBean bean) {
        ResourceBean[] resourceBeans = bean.getResources();
        for (int i = 0; i < resourceBeans.length; ++i) {
            if (resourceBeans[i] instanceof FileResourceBean) {
                this.writeCatalogData((FileResourceBean)resourceBeans[i]);
                continue;
            }
            if (resourceBeans[i] instanceof ContentResourceBean) {
                this.writeCatalogData((ContentResourceBean)resourceBeans[i]);
                continue;
            }
            if (resourceBeans[i] instanceof ReportUnitBean) {
                this.writeCatalogData((ReportUnitBean)resourceBeans[i]);
                continue;
            }
            log.debug((Object)("DEBUG2: skipped bean resource (for write data), name=" + resourceBeans[i].getName()));
        }
        FolderBean[] folderBeans = bean.getFolders();
        for (int j = 0; j < folderBeans.length; ++j) {
            this.writeCatalogDataFolder(folderBeans[j]);
        }
    }

    protected void writeCatalogData(ReportUnitBean bean) {
        log.debug((Object)"top of writeCatalogData(RU)");
        this.writeCatalogDataMainReport(bean.getMainReport());
        FileResourceBean[] resourceBeans = bean.getResources();
        for (int i = 0; i < resourceBeans.length; ++i) {
            this.writeCatalogData(resourceBeans[i]);
        }
    }

    protected void writeCatalogData(OlapUnitBean bean) {
        log.debug((Object)"top of writeCatalogData(OlapUnitBean)");
        this.writeCatalogData(bean.getOlapClientConnection());
    }

    protected void writeCatalogData(OlapClientConnectionBean bean) {
        log.debug((Object)"top of writeCatalogData(OlapClientConnectionBean)");
        if (bean.getConnectionType().equals("CONN_TYPE_MONDRIAN")) {
            this.writeCatalogData(((MondrianConnectionBean)bean).getSchema());
        }
    }

    protected void writeCatalogData(MondrianXmlaDefinitionBean bean) {
        log.debug((Object)"top of writeCatalogData(MondrianXmlaDefinitionBean)");
        MondrianConnectionBean mondBean = bean.getMondrianConnection();
        this.writeCatalogData(mondBean.getSchema());
    }

    protected void writeCatalogDataMainReport(FileResourceBean bean) {
        File parentPath = null;
        Object name = null;
        FileResourceData data = null;
        try {
            parentPath = this.createParentPath(bean);
            data = this.mRepo.getResourceData(null, bean.getUriString());
            if (data != null) {
                FileOutputStream out = new FileOutputStream(new File(parentPath, bean.getName()));
                out.write(data.getData());
            }
        }
        catch (Exception e) {
            log.error((Object)("ERROR: caught exception processing data to disk, file=" + parentPath + PATH_SEP + bean.getName() + ", exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected void writeCatalogData(FileResourceBean bean) {
        log.debug((Object)"top of writeCatalogData(FileResourceBean)");
        File parentPath = null;
        String name = null;
        FileResourceData data = null;
        try {
            if (bean.getIsReference()) {
                parentPath = this.createParentPath(bean.getLinkTarget());
                data = this.mRepo.getResourceData(null, bean.getLinkTarget().getUriString());
                name = bean.getLinkTarget().getName();
            } else {
                parentPath = this.createParentPath(bean);
                data = this.mRepo.getResourceData(null, bean.getUriString());
                name = bean.getName();
            }
            if (data != null) {
                FileOutputStream out = new FileOutputStream(new File(parentPath, name));
                log.debug((Object)("number of bytes to write out=" + data.getData().length));
                out.write(data.getData());
            }
        }
        catch (Exception e) {
            log.error((Object)("ERROR: caught exception processing data to disk, file=" + parentPath + PATH_SEP + name + ", exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected void writeCatalogData(ContentResourceBean bean) {
        File parentPath = null;
        String name = null;
        FileResourceData data = null;
        try {
            if (bean.getIsReference()) {
                log.debug((Object)(" in writeCatalogData(CRB), bean is reference, bean.name=" + bean.getName()));
                parentPath = this.createParentPath(bean.getLinkTarget());
                data = this.mRepo.getContentResourceData(null, bean.getLinkTarget().getUriString());
                name = bean.getLinkTarget().getName();
            } else {
                log.debug((Object)(" in writeCatalogData(CRB), bean is NOT reference, bean.name=" + bean.getName()));
                parentPath = this.createParentPath(bean);
                data = this.mRepo.getContentResourceData(null, bean.getUriString());
                name = bean.getName();
            }
            if (data != null) {
                FileOutputStream out = new FileOutputStream(new File(parentPath, name));
                out.write(data.getData());
            }
            if (bean.getResources() != null) {
                ContentResourceBean[] childResources = bean.getResources();
                for (int i = 0; i < childResources.length; ++i) {
                    this.writeCatalogData(childResources[i]);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("ERROR: caught exception processing data to disk, file=" + parentPath + PATH_SEP + name + ", exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected File createParentPath(ResourceBean bean) {
        File parentPath = new File(this.mCatalogDirName, bean.getParentFolder());
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            log.error((Object)("ERROR: Error creating parent path, path=" + bean.getParentFolder()));
        }
        return parentPath;
    }

    public Resource dereference(ExecutionContext mContext, ResourceReference ref) {
        if (ref.isLocal()) {
            return ref.getLocalResource();
        }
        return this.mRepo.getResource(null, ref.getReferenceLookup().getURIString());
    }

    protected void fillCommonBeanFields(ResourceBean bean, Resource res) {
        bean.setName(res.getName());
        bean.setLabel(res.getLabel());
        bean.setDescription(res.getDescription());
        bean.setUriString(res.getURIString());
        bean.setParentFolder(res.getParentFolder());
        bean.setResourceType(res.getResourceType());
        bean.setIsNew(res.isNew());
        bean.setCreationDate(res.getCreationDate());
        bean.setVersion(res.getVersion());
        bean.setProductReleaseVersion(PRODUCT_VERSION_1_0);
    }

    protected void fillBean(FileResourceBean bean, FileResource fileResource) {
        this.fillCommonBeanFields(bean, (Resource)fileResource);
        bean.setHasData(fileResource.hasData());
        bean.setResourceBeanType(bean.getClass().toString());
    }

    protected void fillBean(ContentResourceBean bean, ContentResource contentResource) {
        this.fillCommonBeanFields(bean, (Resource)contentResource);
        bean.setHasData(contentResource.hasData());
        bean.setResourceBeanType(bean.getClass().toString());
    }

    protected void fillBean(JdbcDataSourceBean bean, JdbcReportDataSource dataSource) {
        this.fillCommonBeanFields(bean, (Resource)dataSource);
        bean.setDataSourceType("DS_TYPE_JDBC");
        bean.setDriverClass(dataSource.getDriverClass());
        bean.setConnectionUrl(dataSource.getConnectionUrl());
        bean.setUsername(dataSource.getUsername());
        bean.setPassword(dataSource.getPassword());
    }

    protected void fillBean(JndiJdbcDataSourceBean bean, JndiJdbcReportDataSource dataSource) {
        this.fillCommonBeanFields(bean, (Resource)dataSource);
        bean.setDataSourceType("DS_TYPE_JNDI_JDBC");
        bean.setJndiName(dataSource.getJndiName());
    }

    protected void fillBean(OlapUnitBean bean, OlapUnit unit) {
        this.fillCommonBeanFields(bean, (Resource)unit);
        bean.setMdxQuery(unit.getMdxQuery());
    }

    protected void fillBean(XmlaConnectionBean bean, XMLAConnection conn) {
        this.fillCommonBeanFields(bean, (Resource)conn);
        bean.setConnectionType("CONN_TYPE_XMLA");
        bean.setUri(conn.getURI());
        bean.setDataSource(conn.getDataSource());
        bean.setCatalog(conn.getCatalog());
        bean.setUsername(conn.getUsername());
        bean.setPassword(conn.getPassword());
    }

    protected void fillBean(MondrianConnectionBean bean, MondrianConnection conn) {
        this.fillCommonBeanFields(bean, (Resource)conn);
        bean.setConnectionType("CONN_TYPE_MONDRIAN");
    }

    protected void fillBean(MondrianXmlaDefinitionBean bean, MondrianXMLADefinition xDef) {
        this.fillCommonBeanFields(bean, (Resource)xDef);
        bean.setCatalog(xDef.getCatalog());
    }

    protected void fillBean(InputControlBean bean, InputControl ic) {
        this.fillCommonBeanFields(bean, (Resource)ic);
        bean.setType(ic.getType());
        bean.setIsMandatory(ic.isMandatory());
        bean.setIsReadOnly(ic.isReadOnly());
        bean.setQueryVisibleColumns(ic.getQueryVisibleColumns());
        bean.setQueryValueColumn(ic.getQueryValueColumn());
        if (ic.getDefaultValue() != null) {
            bean.setDefaultValue(ic.getDefaultValue().toString());
        }
        if (ic.getDefaultValues() != null) {
            List values = ic.getDefaultValues();
            bean.setDefaultValues(values.toArray(new String[values.size()]));
        }
    }

    protected void fillBean(DataTypeBean bean, DataType dt) {
        this.fillCommonBeanFields(bean, (Resource)dt);
        bean.setType(dt.getType());
        bean.setMaxLength(dt.getMaxLength());
        bean.setDecimals(dt.getDecimals());
        bean.setRegularExpr(dt.getRegularExpr());
        if (dt.getMinValue() != null) {
            bean.setMinValue(dt.getMinValue().toString());
        }
        if (dt.getMaxValue() != null) {
            bean.setMaxValue(dt.getMaxValue().toString());
        }
        bean.setIsStrictMax(dt.isStrictMax());
        bean.setIsStrictMin(dt.isStrictMin());
    }

    protected void fillBean(ListOfValuesBean bean, ListOfValues listOfValues) {
        this.fillCommonBeanFields(bean, (Resource)listOfValues);
        ListOfValuesItem[] items = listOfValues.getValues();
        ListOfValuesItemBean[] beanItems = new ListOfValuesItemBean[items.length];
        for (int i = 0; i < items.length; ++i) {
            ListOfValuesItemBean itemBean = new ListOfValuesItemBean();
            itemBean.setLabel(items[i].getLabel());
            itemBean.setValue(items[i].getValue().toString());
            beanItems[i] = itemBean;
        }
        bean.setValues(beanItems);
    }

    protected void fillBean(QueryBean bean, Query query) {
        this.fillCommonBeanFields(bean, (Resource)query);
        bean.setLanguage(query.getLanguage());
        bean.setSql(query.getSql());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

