/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataSource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.QueryImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.util.ContentResourceBean;
import com.jaspersoft.jasperserver.util.DataSourceBean;
import com.jaspersoft.jasperserver.util.DataTypeBean;
import com.jaspersoft.jasperserver.util.ExportImportBean;
import com.jaspersoft.jasperserver.util.ExportImportUtils;
import com.jaspersoft.jasperserver.util.FileResourceBean;
import com.jaspersoft.jasperserver.util.FolderBean;
import com.jaspersoft.jasperserver.util.InputControlBean;
import com.jaspersoft.jasperserver.util.JdbcDataSourceBean;
import com.jaspersoft.jasperserver.util.JndiJdbcDataSourceBean;
import com.jaspersoft.jasperserver.util.ListOfValuesBean;
import com.jaspersoft.jasperserver.util.ListOfValuesItemBean;
import com.jaspersoft.jasperserver.util.MappingHelper;
import com.jaspersoft.jasperserver.util.MondrianConnectionBean;
import com.jaspersoft.jasperserver.util.MondrianXmlaDefinitionBean;
import com.jaspersoft.jasperserver.util.OlapClientConnectionBean;
import com.jaspersoft.jasperserver.util.OlapUnitBean;
import com.jaspersoft.jasperserver.util.ParameterBean;
import com.jaspersoft.jasperserver.util.QueryBean;
import com.jaspersoft.jasperserver.util.ReportJobBean;
import com.jaspersoft.jasperserver.util.ReportJobCalendarTriggerBean;
import com.jaspersoft.jasperserver.util.ReportJobMailNotificationBean;
import com.jaspersoft.jasperserver.util.ReportJobRepositoryDestinationBean;
import com.jaspersoft.jasperserver.util.ReportJobSimpleTriggerBean;
import com.jaspersoft.jasperserver.util.ReportJobSourceBean;
import com.jaspersoft.jasperserver.util.ReportJobTriggerBean;
import com.jaspersoft.jasperserver.util.ReportUnitBean;
import com.jaspersoft.jasperserver.util.ResourceBean;
import com.jaspersoft.jasperserver.util.RoleBean;
import com.jaspersoft.jasperserver.util.UserBean;
import com.jaspersoft.jasperserver.util.UserRoleHolderBean;
import com.jaspersoft.jasperserver.util.XmlaConnectionBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Unmarshaller;

public class ImportResource {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$util$ImportResource == null ? (class$com$jaspersoft$jasperserver$util$ImportResource = ImportResource.class$("com.jaspersoft.jasperserver.util.ImportResource")) : class$com$jaspersoft$jasperserver$util$ImportResource));
    private static final String PATH_SEP = "/";
    private static final String LABEL = "_label";
    private static final boolean TOP_LEVEL_OBJECT = true;
    private static final boolean NOT_TOP_LEVEL_OBJECT = false;
    private RepositoryService repo;
    private UserAuthorityService auth;
    private ReportSchedulingInternalService mReportScheduler;
    private ExecutionContext context;
    private String catalogPath;
    private String catalogFileName;
    private Reader reader;
    private final String characterEncoding;
    private String prependPath;
    private String prependPathNoSlash;
    private boolean usePrependPath;
    private boolean failed = false;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$util$ImportResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$util$ExportImportBean;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query;

    public static void main(String[] args) {
    }

    public ImportResource(RepositoryService repo, UserAuthorityService auth, ReportSchedulingInternalService reportScheduler, ExecutionContext context, String catalogPath, String catalogFileName, String prependPath) {
        this(repo, auth, reportScheduler, context, catalogPath, catalogFileName, prependPath, ExportImportUtils.getDefaultCharacterEncoding());
    }

    public ImportResource(RepositoryService repo, UserAuthorityService auth, ReportSchedulingInternalService reportScheduler, ExecutionContext context, String catalogPath, String catalogFileName, String prependPath, String characterEncoding) {
        this.catalogPath = catalogPath;
        this.catalogFileName = catalogFileName;
        this.context = context;
        this.repo = repo;
        this.auth = auth;
        this.mReportScheduler = reportScheduler;
        this.characterEncoding = characterEncoding;
        if (prependPath == null || prependPath.equals(PATH_SEP) || prependPath.equals("")) {
            this.usePrependPath = false;
            this.prependPath = "";
            log.debug((Object)"not using prepend path");
        } else {
            this.usePrependPath = true;
            this.prependPath = this.setPrependPath(prependPath);
            this.prependPathNoSlash = this.setPrependPathNoSlash(this.prependPath);
            log.debug((Object)("using prepend path, path=" + this.prependPath));
        }
    }

    public boolean process() {
        log.debug((Object)"top of process()");
        this.loadCatalogFile();
        try {
            Unmarshaller unmarshaller = new Unmarshaller(class$com$jaspersoft$jasperserver$util$ExportImportBean == null ? (class$com$jaspersoft$jasperserver$util$ExportImportBean = ImportResource.class$("com.jaspersoft.jasperserver.util.ExportImportBean")) : class$com$jaspersoft$jasperserver$util$ExportImportBean);
            unmarshaller.setMapping(MappingHelper.getExportImportBeanMapping());
            ExportImportBean bean = (ExportImportBean)unmarshaller.unmarshal(this.reader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unmarshalled a " + bean.getVersion() + " exported bean"));
            }
            if (bean.getUserRoleHolder() != null) {
                this.processUsersRoles(bean.getUserRoleHolder());
            }
            if (bean.getResource() != null) {
                this.processResource(bean.getResource());
            }
            if (bean.getReportJobs() != null) {
                this.processReportJobs(bean.getReportJobs());
            }
        }
        catch (Exception e) {
            log.error((Object)("ERROR: caught exception unmarshalling catalog, file=" + this.catalogPath + PATH_SEP + "ji-catalog.xml" + ", exception: " + e.getMessage()));
            e.printStackTrace();
            this.failed = true;
        }
        return !this.failed;
    }

    public void processResource(ResourceBean bean) {
        log.debug((Object)"top of processResource()");
        try {
            if (bean instanceof FolderBean) {
                this.process((FolderBean)bean, true);
            } else if (bean instanceof ReportUnitBean) {
                this.process((ReportUnitBean)bean, true);
            } else if (bean instanceof OlapUnitBean) {
                this.process((OlapUnitBean)bean, true);
            } else if (bean instanceof FileResourceBean) {
                this.process((FileResourceBean)bean, true);
            } else if (bean instanceof ContentResourceBean) {
                this.process((ContentResourceBean)bean, true);
            } else if (bean instanceof DataSourceBean) {
                this.process((DataSourceBean)bean, true);
            } else if (bean instanceof OlapClientConnectionBean) {
                this.process((OlapClientConnectionBean)bean, true);
            } else if (bean instanceof MondrianXmlaDefinitionBean) {
                this.process((MondrianXmlaDefinitionBean)bean, true);
            } else if (bean instanceof InputControlBean) {
                this.process((InputControlBean)bean, true);
            } else if (bean instanceof DataTypeBean) {
                this.process((DataTypeBean)bean, true);
            } else if (bean instanceof ListOfValuesBean) {
                this.process((ListOfValuesBean)bean, true);
            } else if (bean instanceof QueryBean) {
                this.process((QueryBean)bean, true);
            } else {
                log.error((Object)"ERROR: unknown node type");
            }
        }
        catch (Exception e) {
            log.error((Object)("ERROR: caught exception processing, uri=" + bean.getUriString() + ", exception: " + e.getMessage()));
            e.printStackTrace();
            this.failed = true;
        }
    }

    public void processUsersRoles(UserRoleHolderBean bean) {
        this.process(bean, false);
    }

    public void processReportJobs(ReportJobBean[] beans) {
        for (int i = 0; i < beans.length; ++i) {
            this.process(beans[i], false);
        }
    }

    public Folder process(FolderBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(FolderBean)");
        FolderImpl folder = new FolderImpl();
        this.fillData((Folder)folder, bean);
        this.buildParentFolder((Resource)folder, bean);
        System.out.println("ImportResource: check and/or save folder, uri=" + folder.getURIString());
        this.handleSaveFolder((Folder)folder);
        if (bean.getResources() != null) {
            ResourceBean[] resources = bean.getResources();
            for (int i = 0; i < resources.length; ++i) {
                ReportUnit res;
                if (resources[i] instanceof ReportUnitBean) {
                    res = this.process((ReportUnitBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof OlapUnitBean) {
                    res = this.process((OlapUnitBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof FileResourceBean) {
                    res = this.process((FileResourceBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof ContentResourceBean) {
                    res = this.process((ContentResourceBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof DataSourceBean) {
                    res = this.process((DataSourceBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof OlapClientConnectionBean) {
                    res = this.process((OlapClientConnectionBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof MondrianXmlaDefinitionBean) {
                    res = this.process((MondrianXmlaDefinitionBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof InputControlBean) {
                    res = this.process((InputControlBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof DataTypeBean) {
                    res = this.process((DataTypeBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof ListOfValuesBean) {
                    res = this.process((ListOfValuesBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                if (resources[i] instanceof QueryBean) {
                    res = this.process((QueryBean)resources[i], false);
                    this.buildParentFolder((Resource)res, resources[i]);
                    this.handleSaveResource((Resource)res);
                    continue;
                }
                log.error((Object)("ERROR: unknown resource type, class=" + resources[i].getClass()));
            }
        }
        if (bean.getFolders() != null) {
            FolderBean[] folders = bean.getFolders();
            for (int j = 0; j < folders.length; ++j) {
                this.process(folders[j], false);
            }
        }
        return folder;
    }

    public ReportUnit process(ReportUnitBean bean, boolean isTopLevel) {
        FileResourceBean[] frArray;
        log.debug((Object)"top of processReportUnit()");
        ReportUnit unit = (ReportUnit)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$ReportUnit);
        this.fillData(bean, unit);
        if (bean.getDataSource() != null) {
            DataSource ds = this.process(bean.getDataSource(), false);
            if (bean.getDataSource().getIsUriReference()) {
                unit.setDataSourceReference(ds.getURIString());
            } else {
                unit.setDataSource((ReportDataSource)ds);
            }
        }
        if (bean.getQuery() != null) {
            Query query = this.process(bean.getQuery(), false);
            if (bean.getQuery().getIsUriReference()) {
                unit.setQuery(new ResourceReference(query.getURIString()));
            } else {
                unit.setQuery(new ResourceReference((Resource)query));
            }
        }
        if (bean.getMainReport() != null) {
            FileResource repRes = this.process(bean.getMainReport(), false);
            if (bean.getMainReport().getIsUriReference()) {
                unit.setMainReportReference(repRes.getURIString());
            } else {
                unit.setMainReport(repRes);
            }
        }
        if (bean.getInputControls() != null) {
            InputControlBean[] icArray = bean.getInputControls();
            for (int i = 0; i < icArray.length; ++i) {
                InputControl ic = this.process(icArray[i], false);
                if (icArray[i].getIsUriReference()) {
                    unit.addInputControlReference(ic.getURIString());
                    continue;
                }
                unit.addInputControl(ic);
            }
        }
        if ((frArray = bean.getResources()) != null) {
            for (int j = 0; j < frArray.length; ++j) {
                FileResource res = (FileResource)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource") : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
                if (frArray[j].getIsReference()) {
                    this.handleFileResourceRef(res, frArray[j]);
                } else {
                    this.fillData(res, frArray[j]);
                }
                unit.addResource(res);
            }
        }
        if (isTopLevel) {
            this.buildParentFolder((Resource)unit, bean);
            this.handleSaveResource((Resource)unit);
        }
        return unit;
    }

    public OlapUnit process(OlapUnitBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(OlapUnit)");
        OlapUnit unit = (OlapUnit)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit);
        this.fillData(unit, bean);
        if (bean.getOlapClientConnection() != null) {
            OlapClientConnection oc = this.process(bean.getOlapClientConnection(), false);
            if (bean.getOlapClientConnection().getIsUriReference()) {
                unit.setOlapClientConnectionReference(oc.getURIString());
            } else {
                unit.setOlapClientConnection(oc);
            }
        }
        if (isTopLevel) {
            this.buildParentFolder((Resource)unit, bean);
            this.handleSaveResource((Resource)unit);
        }
        return unit;
    }

    public FileResource process(FileResourceBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(FileResouceBean)");
        FileResource res = (FileResource)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
        this.fillData(res, bean);
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)res, bean);
            this.handleSaveResource((Resource)res);
        }
        return res;
    }

    public ContentResource process(ContentResourceBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(ContentResourceBean)");
        ContentResource res = (ContentResource)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource);
        this.fillData(res, bean);
        if (bean.getResources() != null) {
            ContentResourceBean[] childResources = bean.getResources();
            for (int i = 0; i < childResources.length; ++i) {
                ContentResource childRes = this.process(childResources[i], false);
                res.addChildResource(childRes);
            }
        }
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)res, bean);
            this.handleSaveResource((Resource)res);
        }
        return res;
    }

    public DataSource process(DataSourceBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(DataSourceBean)");
        JdbcReportDataSource ds = null;
        if (this.repo.getResource(null, this.prependPath + bean.getUriString()) == null) {
            if (bean.getDataSourceType().equals("DS_TYPE_JDBC")) {
                ds = (JdbcReportDataSource)this.repo.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JdbcReportDataSource);
                this.fillData((JdbcDataSourceBean)bean, ds);
            } else if (bean.getDataSourceType().equals("DS_TYPE_JNDI_JDBC")) {
                ds = (JndiJdbcReportDataSource)this.repo.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$jasperreports$domain$JndiJdbcReportDataSource);
                this.fillData((JndiJdbcDataSourceBean)bean, (JndiJdbcReportDataSource)ds);
            } else {
                log.error((Object)("ERROR: unknown data source type, datasource=" + this.prependPath + bean.getUriString()));
            }
            if (isTopLevel || bean.getIsUriReference()) {
                this.buildParentFolder((Resource)ds, bean);
                this.handleSaveResource((Resource)ds);
            }
        } else {
            log.warn((Object)("WARN: ReportDataSource already exists, skipping creation, using existing, uri=" + this.prependPath + bean.getUriString()));
            ds = (ReportDataSource)this.repo.getResource(this.context, this.prependPath + bean.getUriString());
        }
        return ds;
    }

    public OlapClientConnection process(OlapClientConnectionBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(OlapClientConnectionBean)");
        MondrianConnection oc = null;
        if (this.repo.getResource(this.context, this.prependPath + bean.getUriString()) == null) {
            if (bean.getConnectionType().equals("CONN_TYPE_MONDRIAN")) {
                oc = this.process((MondrianConnectionBean)bean, false);
            } else if (bean.getConnectionType().equals("CONN_TYPE_XMLA")) {
                oc = (XMLAConnection)this.repo.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection);
                this.fillData((XMLAConnection)oc, (XmlaConnectionBean)bean);
            } else {
                log.error((Object)("ERROR: unknown data source type, datasource=" + this.prependPath + bean.getUriString()));
            }
            if (isTopLevel || bean.getIsUriReference()) {
                this.buildParentFolder((Resource)oc, bean);
                this.handleSaveResource((Resource)oc);
            }
        } else {
            log.warn((Object)("WARN: OlapClientConnection already exists, skipping creation, using existing, uri=" + this.prependPath + bean.getUriString()));
            oc = (OlapClientConnection)this.repo.getResource(this.context, this.prependPath + bean.getUriString());
        }
        return oc;
    }

    public MondrianXMLADefinition process(MondrianXmlaDefinitionBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(MondrianXmlaDefinitionBean)");
        MondrianXMLADefinition xDef = (MondrianXMLADefinition)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition);
        this.fillData(xDef, bean);
        if (bean.getMondrianConnection() != null) {
            MondrianConnection mc = this.process(bean.getMondrianConnection(), false);
            if (bean.getMondrianConnection().getIsUriReference()) {
                xDef.setMondrianConnectionReference(mc.getURIString());
            } else {
                xDef.setMondrianConnection(mc);
            }
        }
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)xDef, bean);
            this.handleSaveResource((Resource)xDef);
        }
        return xDef;
    }

    public MondrianConnection process(MondrianConnectionBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(MondrianConnectionBean)");
        MondrianConnection conn = (MondrianConnection)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection);
        this.fillData(conn, bean);
        if (bean.getSchema() != null) {
            FileResource schema = this.process(bean.getSchema(), false);
            if (bean.getSchema().getIsUriReference()) {
                conn.setSchemaReference(schema.getURIString());
            } else {
                conn.setSchema(schema);
            }
        }
        if (bean.getDataSource() != null) {
            DataSource ds = this.process(bean.getDataSource(), false);
            if (bean.getDataSource().getIsUriReference()) {
                conn.setDataSourceReference(ds.getURIString());
            } else {
                conn.setDataSource((ReportDataSource)ds);
            }
        }
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)conn, bean);
            this.handleSaveResource((Resource)conn);
        }
        return conn;
    }

    public InputControl process(InputControlBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(InputControlBean)");
        InputControl ic = (InputControl)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl);
        this.fillData(bean, ic);
        if (bean.getDataType() != null) {
            DataType dt = this.process(bean.getDataType(), false);
            if (bean.getDataType().getIsUriReference()) {
                ic.setDataTypeReference(dt.getURIString());
            } else {
                ic.setDataType(dt);
            }
        }
        if (bean.getListOfValues() != null) {
            ListOfValues lov = this.process(bean.getListOfValues(), false);
            if (bean.getListOfValues().getIsUriReference()) {
                ic.setListOfValuesReference(lov.getURIString());
            } else {
                ic.setListOfValues(lov);
            }
        }
        if (bean.getQuery() != null) {
            Query query = this.process(bean.getQuery(), false);
            if (bean.getQuery().getIsUriReference()) {
                ic.setQueryReference(query.getURIString());
            } else {
                ic.setQuery(query);
            }
        }
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)ic, bean);
            this.handleSaveResource((Resource)ic);
        }
        return ic;
    }

    public DataType process(DataTypeBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(DataTypeBean)");
        DataType dt = (DataType)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.DataType")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType);
        this.fillData(bean, dt);
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)dt, bean);
            this.handleSaveResource((Resource)dt);
        }
        return dt;
    }

    public ListOfValues process(ListOfValuesBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(ListOfValuesBean)");
        Object lov = null;
        lov = isTopLevel ? (ListOfValues)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues) : new ListOfValuesImpl();
        this.fillData(bean, (ListOfValues)lov);
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)lov, bean);
            this.handleSaveResource((Resource)lov);
        }
        return lov;
    }

    public Query process(QueryBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(QueryBean)");
        Object query = null;
        query = isTopLevel ? (Query)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.Query")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query) : new QueryImpl();
        this.fillData(bean, (Query)query);
        if (bean.getDataSource() != null) {
            DataSource ds = this.process(bean.getDataSource(), false);
            if (bean.getDataSource().getIsUriReference()) {
                query.setDataSourceReference(ds.getURIString());
            } else {
                query.setDataSource((ReportDataSource)ds);
            }
        }
        if (isTopLevel || bean.getIsUriReference()) {
            this.buildParentFolder((Resource)query, bean);
            this.handleSaveResource((Resource)query);
        }
        return query;
    }

    public void process(UserRoleHolderBean bean, boolean isTopLevel) {
        log.debug((Object)"top of process(UsersRoleHolderBean)");
        Map allRolesMap = null;
        if (bean.getRoles() != null) {
            this.createRoles(bean.getRoles());
        }
        if (bean.getUsers() != null) {
            allRolesMap = this.getAllRoles();
            log.debug((Object)(" ### allRolesMap.size=" + allRolesMap.size()));
            UserBean[] userBeans = bean.getUsers();
            for (int i = 0; i < userBeans.length; ++i) {
                if (this.auth.getUser(this.context, userBeans[i].getUsername()) == null) {
                    User user = this.auth.newUser(null);
                    user.setUsername(userBeans[i].getUsername());
                    user.setPassword(userBeans[i].getPassword());
                    user.setFullName(userBeans[i].getFullName());
                    user.setEnabled(userBeans[i].getEnabled());
                    user.setExternallyDefined(userBeans[i].getExternallyDefined());
                    RoleBean[] roleBeans = userBeans[i].getRoleSet();
                    for (int j = 0; j < roleBeans.length; ++j) {
                        if (allRolesMap.containsKey(roleBeans[j].getRoleName())) {
                            user.addRole((Role)allRolesMap.get(roleBeans[j].getRoleName()));
                            continue;
                        }
                        log.error((Object)("ERROR: no role matching role held by user, username=" + userBeans[i].getUsername() + ", rolename=" + roleBeans[j].getRoleName()));
                    }
                    this.auth.putUser(this.context, user);
                    continue;
                }
                log.warn((Object)("WARN: user already exists, skipping, username=" + userBeans[i].getUsername()));
            }
        }
    }

    public ReportJob process(ReportJobBean bean, boolean isTopLevel) {
        int i;
        ReportJob job = new ReportJob();
        job.setId(bean.getId());
        job.setUsername(bean.getUsername());
        job.setLabel(bean.getLabel());
        job.setDescription(bean.getDescription());
        job.setBaseOutputFilename(bean.getBaseOutputFilename());
        job.setOutputLocale(bean.getOutputLocale());
        if (bean.getTrigger() != null) {
            try {
                ReportJobSimpleTrigger trig;
                ReportJobTriggerBean tb = bean.getTrigger();
                if (tb instanceof ReportJobSimpleTriggerBean) {
                    trig = new ReportJobSimpleTrigger();
                    tb.copyTo((ReportJobTrigger)trig);
                } else if (tb instanceof ReportJobCalendarTriggerBean) {
                    trig = new ReportJobCalendarTrigger();
                    tb.copyTo((ReportJobTrigger)trig);
                } else {
                    String quotedBeanClass = "\"" + tb.getClass().getName() + "\"";
                    throw new JSException("jsexception.job.unknown.trigger.bean.class", new Object[]{quotedBeanClass});
                }
                job.setTrigger((ReportJobTrigger)trig);
            }
            catch (Exception e) {
                log.error((Object)("ERROR: parsing a date, exception=" + e.getMessage()));
                e.printStackTrace();
                this.failed = true;
            }
        }
        if (bean.getSource() != null) {
            ReportJobSourceBean sb = bean.getSource();
            ReportJobSource src = new ReportJobSource();
            src.setReportUnitURI(sb.getReportUnitURI());
            HashMap<String, String> params = new HashMap<String, String>();
            if (sb.getParameters() != null) {
                ParameterBean[] pBeans = sb.getParameters();
                for (i = 0; i < pBeans.length; ++i) {
                    params.put(pBeans[i].getKey(), pBeans[i].getValue());
                }
                src.setParametersMap(params);
            }
            job.setSource(src);
        }
        if (bean.getOutputFormats() != null) {
            byte[] formats = bean.getOutputFormats();
            for (int i2 = 0; i2 < formats.length; ++i2) {
                job.addOutputFormat(formats[i2]);
            }
        }
        if (bean.getContentRepositoryDestination() != null) {
            ReportJobRepositoryDestinationBean rd = bean.getContentRepositoryDestination();
            ReportJobRepositoryDestination dest = new ReportJobRepositoryDestination();
            dest.setId(rd.getId());
            dest.setFolderURI(rd.getFolderURI());
            dest.setSequentialFilenames(rd.isSequentialFilenames());
            dest.setOverwriteFiles(rd.isOverwriteFiles());
            job.setContentRepositoryDestination(dest);
        }
        if (bean.getMailNotification() != null) {
            String[] bccAddrs;
            String[] ccAddrs;
            ReportJobMailNotificationBean nBean = bean.getMailNotification();
            ReportJobMailNotification note = new ReportJobMailNotification();
            note.setId(nBean.getId());
            String[] toAddrs = nBean.getToAddresses();
            if (toAddrs != null) {
                for (int i3 = 0; i3 < toAddrs.length; ++i3) {
                    note.addTo(toAddrs[i3]);
                }
            }
            if ((ccAddrs = nBean.getCcAddresses()) != null) {
                for (i = 0; i < ccAddrs.length; ++i) {
                    note.addCc(ccAddrs[i]);
                }
            }
            if ((bccAddrs = nBean.getBccAddresses()) != null) {
                for (int i4 = 0; i4 < bccAddrs.length; ++i4) {
                    note.addBcc(bccAddrs[i4]);
                }
            }
            if (nBean.getSubject() != null) {
                note.setSubject(nBean.getSubject());
            } else {
                note.setSubject("subject");
            }
            if (nBean.getMessageText() != null) {
                note.setMessageText(nBean.getMessageText());
            } else {
                note.setMessageText("message text");
            }
            note.setResultSendType(nBean.getResultSendType());
            job.setMailNotification(note);
        }
        this.mReportScheduler.saveJob(this.context, job);
        return job;
    }

    protected void createRoles(RoleBean[] roleBeans) {
        for (int i = 0; i < roleBeans.length; ++i) {
            Role role = null;
            if (this.auth.getRole(this.context, roleBeans[i].getRoleName()) == null) {
                role = this.auth.newRole(this.context);
                role.setRoleName(roleBeans[i].getRoleName());
                role.setExternallyDefined(roleBeans[i].getExternallyDefined());
                this.auth.putRole(this.context, role);
                continue;
            }
            log.debug((Object)("role already exists, not creating, rolename=" + roleBeans[i].getRoleName()));
        }
    }

    protected Map getAllRoles() {
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        List roleList = this.auth.getRoles(this.context, new FilterCriteria());
        Iterator it = roleList.iterator();
        while (it.hasNext()) {
            Role role = (Role)it.next();
            roleMap.put(role.getRoleName(), role);
        }
        return roleMap;
    }

    protected void handleFileResourceRef(FileResource res, FileResourceBean bean) {
        FileResource targetRes = (FileResource)this.repo.newResource(this.context, class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = ImportResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
        FileResourceBean targetBean = (FileResourceBean)bean.getLinkTarget();
        this.fillDataForRef(targetRes, targetBean);
        this.handleSaveResource((Resource)targetRes);
        this.fillCommonData((Resource)res, bean);
        res.setReferenceURI(bean.getReferenceUri());
    }

    protected void handleSaveResource(Resource res) {
        if (this.repo.getResource(this.context, res.getURIString()) == null) {
            this.repo.saveResource(this.context, res);
        } else {
            log.info((Object)("target resource already exists, leaving unchanged, uri=" + res.getURIString()));
        }
    }

    protected void handleSaveFolder(Folder folder) {
        if (this.repo.getFolder(this.context, folder.getURIString()) == null) {
            this.repo.saveFolder(this.context, folder);
        } else {
            log.info((Object)("folder already exists, leaving unchanged, uri=" + folder.getURIString()));
        }
    }

    protected void fillCommonData(Resource res, ResourceBean bean) {
        res.setName(bean.getName());
        res.setLabel(bean.getLabel());
        res.setDescription(bean.getDescription());
    }

    protected void fillData(Folder folder, FolderBean bean) {
        this.fillCommonData((Resource)folder, bean);
    }

    protected void fillData(ReportUnitBean bean, ReportUnit unit) {
        this.fillCommonData((Resource)unit, bean);
    }

    protected void fillData(OlapUnit unit, OlapUnitBean bean) {
        this.fillCommonData((Resource)unit, bean);
        unit.setMdxQuery(bean.getMdxQuery());
    }

    protected void fillData(JdbcDataSourceBean bean, JdbcReportDataSource ds) {
        this.fillCommonData((Resource)ds, bean);
        ds.setDriverClass(bean.getDriverClass());
        ds.setConnectionUrl(bean.getConnectionUrl());
        ds.setUsername(bean.getUsername());
        ds.setPassword(bean.getPassword());
    }

    protected void fillData(JndiJdbcDataSourceBean bean, JndiJdbcReportDataSource ds) {
        this.fillCommonData((Resource)ds, bean);
        ds.setJndiName(bean.getJndiName());
    }

    protected void fillData(MondrianConnection conn, MondrianConnectionBean bean) {
        this.fillCommonData((Resource)conn, bean);
    }

    protected void fillData(XMLAConnection conn, XmlaConnectionBean bean) {
        this.fillCommonData((Resource)conn, bean);
        conn.setURI(bean.getUri());
        conn.setDataSource(bean.getDataSource());
        conn.setCatalog(bean.getCatalog());
        conn.setUsername(bean.getUsername());
        conn.setPassword(bean.getPassword());
    }

    protected void fillData(MondrianXMLADefinition mx, MondrianXmlaDefinitionBean bean) {
        this.fillCommonData((Resource)mx, bean);
        mx.setCatalog(bean.getCatalog());
    }

    protected void fillData(FileResource fr, FileResourceBean bean) {
        this.fillCommonData((Resource)fr, bean);
        fr.setFileType(bean.getFileType());
        String fullPath = this.catalogPath + bean.getParentFolder() + PATH_SEP + bean.getName();
        fr.readData((InputStream)this.getBinaryData(fullPath));
    }

    protected void fillData(ContentResource res, ContentResourceBean bean) {
        this.fillCommonData((Resource)res, bean);
        res.setFileType(bean.getFileType());
        String fullPath = this.catalogPath + bean.getParentFolder() + PATH_SEP + bean.getName();
        res.readData((InputStream)this.getBinaryData(fullPath));
    }

    protected void fillDataForRef(FileResource targetRes, FileResourceBean targetBean) {
        this.fillCommonData((Resource)targetRes, targetBean);
        targetRes.setFileType(targetBean.getFileType());
        this.buildRepoFolderPath(this.context, this.prependPath + targetBean.getParentFolder());
        targetRes.setParentFolder(this.prependPath + targetBean.getParentFolder());
        String fullPath = this.catalogPath + targetBean.getParentFolder() + PATH_SEP + targetBean.getName();
        targetRes.readData((InputStream)this.getBinaryData(fullPath));
    }

    protected void fillData(DataTypeBean bean, DataType dt) {
        this.fillCommonData((Resource)dt, bean);
        dt.setType(bean.getType());
        dt.setMaxLength(bean.getMaxLength());
        dt.setDecimals(bean.getDecimals());
        dt.setRegularExpr(bean.getRegularExpr());
        dt.setMinValue((Comparable)((Object)bean.getMinValue()));
        dt.setMaxValue((Comparable)((Object)bean.getMaxValue()));
        dt.setStrictMin(bean.getIsStrictMin());
        dt.setStrictMax(bean.getIsStrictMax());
    }

    protected void fillData(ListOfValuesBean bean, ListOfValues lov) {
        this.fillCommonData((Resource)lov, bean);
        if (bean.getValues() != null) {
            ListOfValuesItemBean[] items = bean.getValues();
            for (int i = 0; i < items.length; ++i) {
                ListOfValuesItemImpl lovi = new ListOfValuesItemImpl();
                lovi.setLabel(items[i].getLabel());
                lovi.setValue((Object)items[i].getValue());
                lov.addValue((ListOfValuesItem)lovi);
            }
        }
    }

    protected void fillData(QueryBean bean, Query query) {
        this.fillCommonData((Resource)query, bean);
        String queryLanguage = bean.getLanguage();
        if (queryLanguage == null) {
            queryLanguage = "sql";
        }
        query.setLanguage(queryLanguage);
        query.setSql(bean.getSql());
    }

    protected void fillData(InputControlBean bean, InputControl ic) {
        this.fillCommonData((Resource)ic, bean);
        ic.setType(bean.getType());
        ic.setMandatory(bean.getIsMandatory());
        ic.setReadOnly(bean.getIsReadOnly());
        if (bean.getQueryVisibleColumns() != null) {
            String[] visCols = bean.getQueryVisibleColumns();
            for (int i = 0; i < visCols.length; ++i) {
                ic.addQueryVisibleColumn(visCols[i]);
            }
        }
        ic.setQueryValueColumn(bean.getQueryValueColumn());
        ic.setDefaultValue((Object)bean.getDefaultValue());
        if (bean.getDefaultValues() != null) {
            ArrayList<String> defValsList = new ArrayList<String>();
            String[] defVals = bean.getDefaultValues();
            for (int i = 0; i < defVals.length; ++i) {
                defValsList.add(defVals[i]);
            }
            ic.setDefaultValues(defValsList);
        }
    }

    protected FileInputStream getBinaryData(String fullPath) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(fullPath);
            log.debug((Object)("file=" + fullPath + ", fileInputStream.available()=" + input.available()));
        }
        catch (Exception e) {
            log.error((Object)("ERROR: caught exception opening file, file=" + fullPath + ", e=" + e.getMessage()));
            e.printStackTrace();
            this.failed = true;
        }
        return input;
    }

    protected void loadCatalogFile() {
        try {
            this.reader = new InputStreamReader((InputStream)new FileInputStream(new File(this.catalogPath, this.catalogFileName)), this.characterEncoding);
        }
        catch (Exception e) {
            log.error((Object)("ERROR: problem opening catalog file, e: " + e.getMessage()));
            e.printStackTrace();
            this.failed = true;
        }
    }

    protected void buildParentFolder(Resource res, ResourceBean bean) {
        if (bean.getUriString().equals(PATH_SEP) && bean.getParentFolder() == null) {
            if (this.prependPath == null || this.prependPath.equals("")) {
                this.buildRepoFolderPath(this.context, bean.getUriString());
            } else {
                res.setName(this.prependPathNoSlash);
                res.setParentFolder(PATH_SEP);
            }
        } else if (bean.getParentFolder().equals(PATH_SEP) && this.usePrependPath) {
            this.buildRepoFolderPath(this.context, this.prependPath);
            res.setParentFolder(this.prependPath);
        } else {
            this.buildRepoFolderPath(this.context, this.prependPath + bean.getParentFolder());
            res.setParentFolder(this.prependPath + bean.getParentFolder());
        }
    }

    protected String setPrependPath(String inPath) {
        if (inPath.indexOf(47) != 0) {
            return PATH_SEP + inPath;
        }
        return inPath;
    }

    protected String setPrependPathNoSlash(String inPath) {
        if (inPath.indexOf(47) != 0) {
            return inPath;
        }
        return inPath.substring(1);
    }

    private Folder buildRepoFolderPath(ExecutionContext context, String path) {
        log.debug((Object)("buildRepoFolderPath: build path=" + path));
        String[] splitPath = path.split(PATH_SEP);
        String folderName = "";
        Folder parentFolder = null;
        Folder folder = this.repo.getFolder(context, folderName);
        for (int i = 0; i < splitPath.length; ++i) {
            if ("".equals(splitPath[i])) continue;
            folderName = folderName + PATH_SEP + splitPath[i];
            parentFolder = folder;
            folder = this.repo.getFolder(context, folderName);
            if (folder != null) continue;
            folder = new FolderImpl();
            folder.setName(splitPath[i]);
            folder.setLabel(splitPath[i]);
            folder.setDescription(splitPath[i] + " folder");
            folder.setParentFolder(parentFolder);
            this.repo.saveFolder(context, folder);
        }
        return folder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

