/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtils {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResourceData == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResourceData = StreamUtils.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResourceData));
    private static final int READ_STREAM_BUFFER_SIZE = 10000;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResourceData;

    public static byte[] readData(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[10000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while reading data.", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        return baos.toByteArray();
    }

    public static byte[] readData(InputStream is, int size) {
        if (is == null) {
            return null;
        }
        try {
            byte[] data = new byte[size];
            int offset = 0;
            while (size > 0) {
                int read = is.read(data, offset, size);
                if (read < 0) {
                    throw new JSException("jsexception.input.stream.exhausted", new Object[]{new Integer(size)});
                }
                offset += read;
                size -= read;
            }
            return data;
        }
        catch (IOException e) {
            log.error((Object)"Error while reading data.", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public static byte[] readData(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return StreamUtils.readData(blob.getBinaryStream());
        }
        catch (SQLException e) {
            log.error((Object)"Error while reading blob data", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public static void pipeData(InputStream is, OutputStream os) throws IOException {
        if (is == null) {
            return;
        }
        byte[] bytes = new byte[10000];
        int ln = 0;
        while ((ln = is.read(bytes)) > 0) {
            os.write(bytes, 0, ln);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

