/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public abstract class AbstractBeanPropertyProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;
    private String beanName;
    private String propertyName;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(this.getBeanName());
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        Object value = null;
        PropertyValue propertyValue = propertyValues.getPropertyValue(this.getPropertyName());
        if (propertyValue != null) {
            value = propertyValue.getValue();
        }
        Object appendedValue = this.getProcessedPropertyValue(value);
        propertyValues.addPropertyValue(this.getPropertyName(), appendedValue);
    }

    protected abstract Object getProcessedPropertyValue(Object var1);

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }
}

