/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.spring.AbstractBeanPropertyProcessor;
import com.jaspersoft.jasperserver.api.common.util.spring.GenericBeanUpdaterDefinition;
import java.util.List;
import java.util.Map;

public class GenericBeanUpdater
extends AbstractBeanPropertyProcessor {
    private GenericBeanUpdaterDefinition definition;
    private String key;
    private Object value;
    private String before;
    private int order = 0;
    private boolean orderSet = false;

    protected Object getProcessedPropertyValue(Object originalValue) {
        if (this.definition.getOperation().equals("append")) {
            return this.append(originalValue);
        }
        if (this.definition.getOperation().equals("set")) {
            return this.set(originalValue);
        }
        if (this.definition.getOperation().equals("insert")) {
            return this.insert(originalValue);
        }
        throw new JSException("jsexception.unknown.updater.operation", new Object[]{this.getBeanName(), this.definition.getOperation()});
    }

    private Object append(Object originalValue) {
        if (originalValue == null) {
            return this.value;
        }
        if (originalValue instanceof Map) {
            Map newValue = (Map)originalValue;
            if (this.key != null) {
                newValue.put(this.key, this.value);
            } else if (this.value instanceof Map) {
                newValue.putAll((Map)this.value);
            } else {
                throw new JSException("jsexception.cant.append.to.map", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (originalValue instanceof List) {
            List newValue = (List)originalValue;
            if (this.value instanceof List) {
                newValue.addAll((List)this.value);
            } else {
                newValue.add(this.value);
            }
            return newValue;
        }
        if (originalValue instanceof String) {
            return (String)originalValue + this.value;
        }
        throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
    }

    private Object set(Object originalValue) {
        return this.value;
    }

    private Object insert(Object originalValue) {
        if (originalValue instanceof String) {
            StringBuffer newValue = new StringBuffer((String)originalValue);
            int index = 0;
            if (this.before != null && (index = newValue.indexOf(this.before)) == -1) {
                throw new JSException("jsexception.cant.find.before.string", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            newValue.insert(index, this.value);
            return newValue.toString();
        }
        throw new JSException("jsexception.cant.insert", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
    }

    public String getBeanName() {
        return this.definition.getBeanName();
    }

    public int getOrder() {
        return this.orderSet ? this.order : this.definition.getOrder();
    }

    public void setOrder(int order) {
        this.orderSet = true;
        this.order = order;
    }

    public String getPropertyName() {
        return this.definition.getPropertyName();
    }

    public GenericBeanUpdaterDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(GenericBeanUpdaterDefinition definition) {
        this.definition = definition;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getBefore() {
        return this.before;
    }

    public void setBefore(String before) {
        this.before = before;
    }
}

