/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
 
#include "attachment.h"
#include <sys/stat.h>

int jasperserver_attach_file(struct soap* soap,const char* fileName)
{
    struct stat sb;
    FILE* fd = NULL;
    jasperserver_attachment_t attachment;
    
    if (!fileName){
       fprintf(stderr, "File to attach not specified!");
       return 1;
    }

    if (!soap)
    {
       fprintf(stderr, "Soap struct NULL!");
       return 2;
    }
    
    fd = fopen(fileName,"rb");

    if (!fd)
    {
       fprintf(stderr, "File %s not found!",fileName);
       return 3;
    }
    
    if (!fstat(fileno(fd), &sb) && sb.st_size > 0)
    {
        soap->fdimereadopen = jasperserver_dime_read_open;
        soap->fdimereadclose = jasperserver_dime_read_close;
        soap->fdimeread = jasperserver_dime_read;
        attachment.__ptr = (unsigned char*)fd; // must set to non-NULL (this is our fd handle which we need in the callbacks)
        attachment.__size = sb.st_size; // must set size               
    }
    else
    {
        fprintf(stderr,"Unable to find the size of the file %s", fileName);
        return 4; // Unable to find file size...
    }
    attachment.id = "attachment";
    attachment.type = "application/octet-stream";
    attachment.options = soap_dime_option(soap, 0, "attachment");
    
    if (soap_set_dime_attachment(soap, attachment.__ptr, attachment.__size, attachment.type, attachment.id, 0, attachment.options) != SOAP_OK)
    {
       printf("Error setting up DIME attachment");
       return 5;
    }
  
    return 0;
}

void *jasperserver_dime_read_open(struct soap *soap, void *handle, const char *id, const char *type, const char *options)
{ 
     //printf("File opened %x", handle);
     //fflush(stdout);
     return handle;
}

void jasperserver_dime_read_close(struct soap *soap, void *handle)
{ 
     //printf("File closed!");
     //fflush(stdout);
     fclose((FILE*)handle);
}

size_t jasperserver_dime_read(struct soap *soap, void *handle, char *buf, size_t len)
{ 
  size_t s = fread(buf, 1, len, (FILE*)handle);
  //printf("File read %ul!", s);
  //fflush(stdout);
  return s;
}


int jasperserver_read_file(const char* fileName, char **dataPtr, size_t *sizePtr)
{
    FILE* fd = NULL;
    struct stat sb;
    
    if (!fileName){
       fprintf(stderr, "File to attach not specified!");
       return 1;
    }

    fd = fopen(fileName,"rb");

    if (!fd)
    {
       fprintf(stderr, "File %s not found!",fileName);
       return 3;
    }
    
    if (!fstat(fileno(fd), &sb) && sb.st_size > 0)
    {
        *dataPtr = (char *)malloc(sb.st_size);
        *sizePtr = sb.st_size;
        //printf("\nSize %ul\n", *sizePtr);
        //printf("\nAddress %x\n", sizePtr);
        //printf("\nSize %ul\n\n", sb.st_size);
        
        fread(*dataPtr, 1, sb.st_size, fd);
    }
    fclose(fd);
    return 0;
}
