/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

/** 
 *  \file jsget.c
 *  This sample shows how to get a resource from the repository. If the resource contains a file,
 *  it can be saved in a local file.
 *  
 *  \see  jasperserver_ws_get

*/

#include <jasperserver.h>

const char server[] = "http://127.0.0.1:8080/jasperserver/services/repository";

/** 
 *  \brief Sample function to download a resource from the repository
 *
 *  \param resource URI of the resource to get.
 *  \param outfile File destination of the resource content
*/
void get_resource(char *resource, char *outfile)
{
      jasperserver_request_t *request = NULL;
      jasperserver_server_t *jasperServer = NULL;
      jasperserver_resource_descriptor_t *res = NULL;
      jasperserver_operation_result_t *operationResult = NULL;
 
      // Create a new structure of type jasperserver_server_t to save the
      // server url and credentials.
      jasperServer = jasperserver_server_new();
      jasperserver_string_cset(jasperServer->url, server);
      jasperserver_string_cset(jasperServer->username, "tomcat");
      jasperserver_string_cset(jasperServer->password, "tomcat");
     
      // Create a new structure of type jasperserver_request_t to store
      // the request information like the resource to list    
      request = jasperserver_request_new();   
     
      //Creating and populating a new resource_descriptor...
      res = jasperserver_resource_descriptor_new();
      request->resource = res;
      jasperserver_string_cset(res->uriString, resource);
      
      // Call the web service
      operationResult = jasperserver_ws_get(jasperServer, request, outfile);
      
      if (operationResult->returnCode == 0)
      {
         printf("Server version: %s, Return code: '%d', Return message '%s'\n", JS_CSTR( operationResult->version),  operationResult->returnCode, JS_CSTR( operationResult->returnMessage ));
         printf("Requested resource: %s\n\n", JS_CSTR( request->resource->uriString));
         fflush( stdout );
         
         if (operationResult->resources)
         {
            jasperserver_print_resource_descriptor( operationResult->resources, 0 );
         }
      }
      else
      {
          //printf("Error executing the service: %d (%s)", operationResult->returnCode, JS_UTFSTR(operationResult->returnMessage) );
          printf("Error executing the service: %d (%s)", operationResult->returnCode, JS_UTFSTR(operationResult->returnMessage) );
      }
                                      
      jasperserver_server_free( jasperServer );
      jasperserver_request_free( request );
      jasperserver_operation_result_free( operationResult );
      
}


int main(int argc, char **argv)
{ 
   char *resource = NULL;
   char *outfile = NULL;
   printf("JasperServer list sample (C) 2007 JasperSoft Corp.!\n");
   
   if (argc > 1)
   {
     resource = argv[1]; 
     if (argc > 2)
     {
          outfile = argv[2]; 
     }
   }
   else
   {
     printf("Usage: jsget <resource uri> [output file name]\n");
     printf("I.e.  jsget /images/JRLogo myimage.gif\n");
     exit(0);
   }
   get_resource(resource, outfile);

  return 0;
}
