/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

/** 
 *  \file jsrun.c
 *  This sample shows how to run a report unit. In particular this sample shows how run a report unit and export it in
 *  html. The file is saved in a file specified by the user. If there are images, them are saved inside the directory
 *  images.
 *  
 *  A more complex sample about how run a report unit having input controls is named jsrun_params.c 
 *  
 *  \see  jasperserver_ws_runReport
*/

#include <jasperserver.h>

const char server[] = "http://127.0.0.1:8080/jasperserver/services/repository";

void run_report(char *reportUnitUri, char *outfile)
{
      jasperserver_request_t *request = NULL;
      jasperserver_server_t *jasperServer = NULL;
      jasperserver_argument_t *argPdfExport = NULL;
      jasperserver_resource_descriptor_t *res = NULL;
      jasperserver_operation_result_t *operationResult = NULL;
 
      // Create a new structure of type jasperserver_server_t to save the
      // server url and credentials.
      jasperServer = jasperserver_server_new();
      jasperserver_string_cset(jasperServer->url, server);
      jasperserver_string_cset(jasperServer->username, "tomcat");
      jasperserver_string_cset(jasperServer->password, "tomcat");
     
      // Create a new structure of type jasperserver_request_t to store
      // the request information like the resource to list    
      request = jasperserver_request_new();   
     
      // Set PDF as export format...
      argPdfExport = jasperserver_argument_new();
      jasperserver_string_cset(argPdfExport->name, JS_ARG_RUN_OUTPUT_FORMAT);
      jasperserver_string_cset(argPdfExport->value, JS_ARG_RUN_OUTPUT_FORMAT_HTML);
      
      jasperserver_list_append((jasperserver_list_t **)&request->arguments, (jasperserver_list_t *)argPdfExport);
      
      //Creating and populating a new resource_descriptor...
      res = jasperserver_resource_descriptor_new();
      request->resource = res;
      jasperserver_string_cset(res->uriString, reportUnitUri);
      
      // Call the web service
      operationResult = jasperserver_ws_runReport(jasperServer, request, outfile);
      
      if (operationResult->returnCode == 0)
      {
         printf("Server version: %s, Return code: '%d', Return message '%s'\n", JS_CSTR( operationResult->version),  operationResult->returnCode, JS_CSTR( operationResult->returnMessage ));
         printf("Requested resource: %s\n\n", JS_CSTR( request->resource->uriString));
         fflush( stdout );
      }
      else
      {
          printf("Error executing the service: %d (%s)", operationResult->returnCode, JS_UTFSTR(operationResult->returnMessage) );
      }
                                      
      jasperserver_server_free( jasperServer );
      jasperserver_request_free( request );
      jasperserver_operation_result_free( operationResult );
      
}


int main(int argc, char **argv)
{ 
   char *reportUnitUri = NULL;
   char *outfile = NULL;
   printf("JasperServer list sample (C) 2007 JasperSoft Corp.!\n");
   
   if (argc > 1)
   {
     reportUnitUri = argv[1]; 
     if (argc > 2)
     {
          outfile = argv[2]; 
     }
   }
   else
   {
     printf("Usage: jsrun <reportUnitUri> [output file name]\n");
     printf("I.e.  jsrun /reports/samples/AllAccounts allaccounts.html\n");
     exit(0);
   }
   run_report(reportUnitUri, outfile);

  return 0;
}
