--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: accounts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE accounts (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    name character varying(150),
    parent_id character varying(36),
    account_type character varying(25),
    industry character varying(25),
    annual_revenue character varying(25),
    phone_fax character varying(25),
    billing_address_street character varying(150),
    billing_address_city character varying(100),
    billing_address_state character varying(100),
    billing_address_postalcode character varying(20),
    billing_address_country character varying(100),
    description text,
    rating character varying(25),
    phone_office character varying(25),
    phone_alternate character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    website character varying(255),
    ownership character varying(100),
    employees character varying(10),
    sic_code character varying(10),
    ticker_symbol character varying(10),
    shipping_address_street character varying(150),
    shipping_address_city character varying(100),
    shipping_address_state character varying(100),
    shipping_address_postalcode character varying(20),
    shipping_address_country character varying(100),
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: accounts_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE accounts_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: accounts_bugs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE accounts_bugs (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    account_id character(36),
    bug_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: accounts_cases; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE accounts_cases (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    account_id character(36),
    case_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: accounts_contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE accounts_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    account_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: accounts_opportunities; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE accounts_opportunities (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    opportunity_id character(36),
    account_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: bugs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE bugs (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    bug_number bigserial NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    deleted smallint DEFAULT 0::smallint NOT NULL,
    name character varying(255),
    status character varying(25),
    priority character varying(25),
    description text,
    created_by character varying(36),
    resolution character varying(255),
    "release" character varying(255),
    "type" character varying(255),
    fixed_in_release character varying(255),
    work_log text,
    source character varying(255),
    product_category character varying(255)
);


--
-- Name: bugs_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE bugs_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: bugs_bug_number_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('bugs', 'bug_number'), 1, false);


--
-- Name: calls; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE calls (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(50),
    duration_hours character(2),
    duration_minutes character(2),
    date_start date,
    time_start time without time zone,
    date_end date,
    parent_type character varying(25),
    status character varying(25),
    direction character varying(25),
    parent_id character varying(36),
    description text,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    reminder_time integer DEFAULT -1,
    outlook_id character varying(255)
);


--
-- Name: calls_contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE calls_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    call_id character(36),
    contact_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: calls_users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE calls_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    call_id character(36),
    user_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: campaigns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE campaigns (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    tracker_key bigserial NOT NULL,
    tracker_count bigint DEFAULT 0::bigint,
    name character varying(50),
    refer_url character varying(255) DEFAULT 'http://'::character varying,
    tracker_text character varying(255),
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    modified_user_id character varying(36),
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT 0::smallint NOT NULL,
    start_date date,
    end_date date,
    status character varying(25),
    budget double precision,
    expected_cost double precision,
    actual_cost double precision,
    expected_revenue double precision,
    campaign_type character varying(25),
    objective text,
    content text
);


--
-- Name: campaigns_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE campaigns_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: campaigns_tracker_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('campaigns', 'tracker_key'), 1, false);


--
-- Name: cases; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cases (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    case_number bigserial NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT 0::smallint NOT NULL,
    name character varying(255),
    account_name character varying(100),
    account_id character varying(36),
    status character varying(25),
    priority character varying(25),
    description text,
    resolution text
);


--
-- Name: cases_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cases_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: cases_bugs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cases_bugs (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    case_id character(36),
    bug_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: cases_case_number_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('cases', 'case_number'), 1, false);


--
-- Name: config; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE config (
    category character varying(32) DEFAULT ''::character varying NOT NULL,
    name character varying(32) DEFAULT ''::character varying NOT NULL,
    value text
);


--
-- Name: contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contacts (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    salutation character varying(5),
    first_name character varying(100),
    last_name character varying(100),
    lead_source character varying(100),
    title character varying(25),
    department character varying(100),
    reports_to_id character varying(36),
    birthdate date,
    do_not_call character(3) DEFAULT '0'::bpchar,
    phone_home character varying(25),
    phone_mobile character varying(25),
    phone_work character varying(25),
    phone_other character varying(25),
    phone_fax character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    assistant character varying(75),
    assistant_phone character varying(25),
    email_opt_out character(3) DEFAULT '0'::bpchar,
    primary_address_street character varying(150),
    primary_address_city character varying(100),
    primary_address_state character varying(100),
    primary_address_postalcode character varying(20),
    primary_address_country character varying(100),
    alt_address_street character varying(150),
    alt_address_city character varying(100),
    alt_address_state character varying(100),
    alt_address_postalcode character varying(20),
    alt_address_country character varying(100),
    description text,
    portal_name character varying(255),
    portal_active smallint DEFAULT 0::smallint NOT NULL,
    portal_app character varying(255),
    invalid_email smallint DEFAULT 0::smallint
);


--
-- Name: contacts_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contacts_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: contacts_bugs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contacts_bugs (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    bug_id character(36),
    contact_role character(50),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: contacts_cases; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contacts_cases (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    case_id character(36),
    contact_role character(50),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: contacts_users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contacts_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    user_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: currencies; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE currencies (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    name character(36) DEFAULT ''::bpchar NOT NULL,
    symbol character(36) DEFAULT ''::bpchar NOT NULL,
    iso4217 character(3) DEFAULT ''::bpchar NOT NULL,
    conversion_rate double precision DEFAULT 0::double precision NOT NULL,
    status character(25),
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    created_by character(36) DEFAULT ''::bpchar NOT NULL
);


--
-- Name: custom_fields; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE custom_fields (
    bean_id character(36) DEFAULT ''::bpchar,
    set_num bigint DEFAULT 0::bigint,
    field0 character(255) DEFAULT ''::bpchar,
    field1 character(255) DEFAULT ''::bpchar,
    field2 character(255) DEFAULT ''::bpchar,
    field3 character(255) DEFAULT ''::bpchar,
    field4 character(255) DEFAULT ''::bpchar,
    field5 character(255) DEFAULT ''::bpchar,
    field6 character(255) DEFAULT ''::bpchar,
    field7 character(255) DEFAULT ''::bpchar,
    field8 character(255) DEFAULT ''::bpchar,
    field9 character(255) DEFAULT ''::bpchar,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: document_revisions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE document_revisions (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    change_log character varying(255),
    document_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone,
    created_by character varying(36),
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    file_ext character varying(25),
    file_mime_type character varying(100),
    revision character varying(25),
    deleted smallint DEFAULT 0::smallint,
    date_modified timestamp without time zone
);


--
-- Name: documents; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE documents (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    document_name character varying(255) DEFAULT ''::character varying NOT NULL,
    active_date date,
    exp_date date,
    description text,
    category_id character varying(25),
    subcategory_id character varying(25),
    status_id character varying(25),
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint,
    modified_user_id character varying(36),
    created_by character varying(36),
    document_revision_id character varying(36)
);


--
-- Name: email_marketing; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_marketing (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(255),
    from_addr character varying(100),
    from_name character varying(100),
    date_start date,
    time_start time without time zone,
    template_id character varying(36) DEFAULT ''::character varying NOT NULL,
    campaign_id character varying(36) DEFAULT ''::character varying NOT NULL
);


--
-- Name: email_templates; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_templates (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    published character(3),
    name character varying(255),
    description text,
    subject character varying(255),
    body text,
    body_html text,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: emailman; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emailman (
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    user_id character varying(36),
    template_id character varying(36),
    from_email character varying(255),
    from_name character varying(255),
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    module_id character varying(36),
    campaign_id character varying(36),
    marketing_id character varying(36),
    list_id character varying(36),
    module character varying(100),
    send_date_time timestamp without time zone,
    modified_user_id character varying(36),
    invalid_email smallint DEFAULT 0::smallint,
    in_queue smallint DEFAULT 0::smallint,
    in_queue_date timestamp without time zone,
    send_attempts bigint DEFAULT 0::bigint,
    deleted smallint DEFAULT 0::smallint,
    user_name character varying(255),
    campaign_name character varying(50),
    to_contact character varying(255),
    to_prospect character varying(255),
    to_lead character varying(255),
    contact_email character varying(100),
    prospect_email character varying(100),
    lead_email character varying(100)
);


--
-- Name: emailman_sent; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emailman_sent (
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    user_id character varying(36),
    template_id character varying(36),
    from_email character varying(255),
    from_name character varying(255),
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    module_id character varying(36),
    campaign_id character varying(36),
    marketing_id character varying(36),
    list_id character varying(36),
    module character varying(100),
    send_date_time timestamp without time zone,
    modified_user_id character varying(36),
    invalid_email smallint DEFAULT 0::smallint,
    in_queue smallint DEFAULT 0::smallint,
    in_queue_date timestamp without time zone,
    send_attempts bigint DEFAULT 0::bigint,
    deleted smallint DEFAULT 0::smallint,
    user_name character varying(255),
    campaign_name character varying(50),
    to_contact character varying(255),
    to_prospect character varying(255),
    to_lead character varying(255),
    contact_email character varying(100),
    prospect_email character varying(100),
    lead_email character varying(100)
);


--
-- Name: emails; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emails (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    date_start date,
    time_start time without time zone,
    parent_type character varying(25),
    parent_id character varying(36),
    description text,
    description_html text,
    from_addr character varying(100),
    from_name character varying(100),
    to_addrs text,
    cc_addrs text,
    bcc_addrs text,
    to_addrs_ids text,
    to_addrs_names text,
    to_addrs_emails text,
    cc_addrs_ids text,
    cc_addrs_names text,
    cc_addrs_emails text,
    bcc_addrs_ids text,
    bcc_addrs_names text,
    bcc_addrs_emails text,
    "type" character varying(25),
    status character varying(25),
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: emails_accounts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emails_accounts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    account_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: emails_cases; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emails_cases (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    case_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: emails_contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emails_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    contact_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: emails_opportunities; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emails_opportunities (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    opportunity_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: emails_users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE emails_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    user_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: feeds; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE feeds (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    title character varying(100),
    description text,
    url character varying(255)
);


--
-- Name: fields_meta_data; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE fields_meta_data (
    id character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    label character varying(255) DEFAULT ''::character varying NOT NULL,
    custom_module character varying(255) DEFAULT ''::character varying,
    data_type character varying(255) DEFAULT ''::character varying NOT NULL,
    max_size bigint DEFAULT 0::bigint,
    required_option character varying(255) DEFAULT ''::character varying,
    default_value character varying(255) DEFAULT ''::character varying,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint,
    audited smallint DEFAULT 0::smallint,
    ext1 character varying(255) DEFAULT '0'::character varying,
    ext2 character varying(255) DEFAULT '0'::character varying,
    ext3 character varying(255) DEFAULT '0'::character varying
);


--
-- Name: files; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE files (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    name character varying(36),
    content bytea,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36)
);


--
-- Name: iframes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE iframes (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    name character(255) DEFAULT ''::bpchar NOT NULL,
    url character(255) DEFAULT ''::bpchar NOT NULL,
    "type" character(255) DEFAULT ''::bpchar NOT NULL,
    placement character(255) DEFAULT ''::bpchar NOT NULL,
    status smallint DEFAULT 0::smallint NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    created_by character(36) DEFAULT ''::bpchar NOT NULL
);


--
-- Name: import_maps; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE import_maps (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    name character varying(36) DEFAULT ''::character varying NOT NULL,
    source character varying(36) DEFAULT ''::character varying NOT NULL,
    module character varying(36) DEFAULT ''::character varying NOT NULL,
    content bytea,
    has_header smallint DEFAULT 1::smallint NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    is_published character(3) DEFAULT 'no'::bpchar NOT NULL
);


--
-- Name: leads; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE leads (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    converted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    salutation character varying(5),
    first_name character varying(25),
    last_name character varying(25),
    title character varying(100),
    refered_by character varying(100),
    lead_source character varying(100),
    lead_source_description text,
    status character varying(100),
    status_description text,
    department character varying(100),
    reports_to_id character varying(36),
    do_not_call character(3) DEFAULT '0'::bpchar,
    phone_home character varying(25),
    phone_mobile character varying(25),
    phone_work character varying(25),
    phone_other character varying(25),
    phone_fax character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    email_opt_out character(3) DEFAULT '0'::bpchar,
    primary_address_street character varying(150),
    primary_address_city character varying(100),
    primary_address_state character varying(100),
    primary_address_postalcode character varying(20),
    primary_address_country character varying(100),
    alt_address_street character varying(150),
    alt_address_city character varying(100),
    alt_address_state character varying(100),
    alt_address_postalcode character varying(20),
    alt_address_country character varying(100),
    description text,
    account_name character varying(150),
    account_description text,
    contact_id character varying(36),
    account_id character varying(36),
    opportunity_id character varying(36),
    opportunity_name character varying(255),
    opportunity_amount character varying(50),
    portal_name character varying(255),
    portal_app character varying(255),
    invalid_email smallint DEFAULT 0::smallint
);


--
-- Name: leads_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE leads_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: meetings; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE meetings (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(50),
    "location" character varying(50),
    duration_hours character(2),
    duration_minutes character(2),
    date_start date,
    time_start time without time zone,
    date_end date,
    parent_type character varying(25),
    status character varying(25),
    parent_id character varying(36),
    description text,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    reminder_time bigint DEFAULT -1::bigint,
    outlook_id character varying(255)
);


--
-- Name: meetings_contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE meetings_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    meeting_id character(36),
    contact_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: meetings_users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE meetings_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    meeting_id character(36),
    user_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: mond_customer; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mond_customer (
    customer_id bigint,
    account_num bigint,
    lname character varying(30),
    fname character varying(30),
    mi character varying(30),
    address1 character varying(30),
    address2 character varying(30),
    address3 character varying(30),
    address4 character varying(30),
    city character varying(30),
    state_province character varying(30),
    postal_code character varying(30),
    country character varying(30),
    customer_region_id bigint,
    phone1 character varying(30),
    phone2 character varying(30),
    birthdate date,
    marital_status character varying(30),
    yearly_income character varying(30),
    gender character varying(30),
    total_children bigint,
    num_children_at_home bigint,
    education character varying(30),
    date_accnt_opened date,
    member_card character varying(30),
    occupation character varying(30),
    houseowner character varying(30),
    num_cars_owned bigint
);


--
-- Name: notes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE notes (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(255),
    filename character varying(255),
    file_mime_type character varying(100),
    parent_type character varying(25),
    parent_id character varying(36),
    contact_id character varying(36),
    portal_flag smallint DEFAULT 0::smallint NOT NULL,
    description text,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: opportunities; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE opportunities (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT 0::smallint NOT NULL,
    name character varying(50),
    opportunity_type character varying(255),
    lead_source character varying(50),
    amount double precision,
    amount_backup character varying(25),
    amount_usdollar double precision,
    currency_id character varying(36),
    date_closed date,
    next_step character varying(100),
    sales_stage character varying(25),
    probability double precision,
    description text
);


--
-- Name: opportunities_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE opportunities_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: opportunities_contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE opportunities_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    opportunity_id character(36),
    contact_role character(50),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: project; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE project (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    description text,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: project_relation; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE project_relation (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    project_id character varying(36) DEFAULT ''::character varying NOT NULL,
    relation_id character varying(36) DEFAULT ''::character varying NOT NULL,
    relation_type character varying(255) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL
);


--
-- Name: project_task; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE project_task (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    status character varying(255),
    date_due date,
    time_due time without time zone,
    date_start date,
    time_start time without time zone,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    priority character varying(255),
    description text,
    order_number bigint DEFAULT 1::bigint,
    task_number bigint,
    depends_on_id character varying(36),
    milestone_flag character varying(255),
    estimated_effort bigint,
    actual_effort bigint,
    utilization bigint DEFAULT 100::bigint,
    percent_complete bigint DEFAULT 0::bigint,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: project_task_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE project_task_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: prospect_list_campaigns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE prospect_list_campaigns (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    prospect_list_id character(36) DEFAULT ''::bpchar,
    campaign_id character(36) DEFAULT ''::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: prospect_lists; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE prospect_lists (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    name character varying(50),
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    modified_user_id character varying(36),
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT 0::smallint NOT NULL,
    description text
);


--
-- Name: prospect_lists_prospects; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE prospect_lists_prospects (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    prospect_list_id character(36) DEFAULT ''::bpchar,
    prospect_id character(36) DEFAULT ''::bpchar,
    contact_id character(36) DEFAULT ''::bpchar,
    lead_id character(36) DEFAULT ''::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: prospects; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE prospects (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    tracker_key bigserial NOT NULL,
    deleted smallint DEFAULT 0::smallint,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    salutation character varying(5),
    first_name character varying(100),
    last_name character varying(100),
    title character varying(25),
    department character varying(255),
    birthdate date,
    do_not_call character(3) DEFAULT '0'::bpchar,
    phone_home character varying(25),
    phone_mobile character varying(25),
    phone_work character varying(25),
    phone_other character varying(25),
    phone_fax character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    assistant character varying(75),
    assistant_phone character varying(25),
    email_opt_out character(3) DEFAULT '0'::bpchar,
    primary_address_street character varying(150),
    primary_address_city character varying(100),
    primary_address_state character varying(100),
    primary_address_postalcode character varying(20),
    primary_address_country character varying(100),
    alt_address_street character varying(150),
    alt_address_city character varying(100),
    alt_address_state character varying(100),
    alt_address_postalcode character varying(20),
    alt_address_country character varying(100),
    description text,
    invalid_email smallint DEFAULT 0::smallint
);


--
-- Name: prospects_tracker_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('prospects', 'tracker_key'), 1, false);


--
-- Name: relationships; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE relationships (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    relationship_name character varying(150) DEFAULT ''::character varying NOT NULL,
    lhs_module character varying(100) DEFAULT ''::character varying NOT NULL,
    lhs_table character varying(64) DEFAULT ''::character varying NOT NULL,
    lhs_key character varying(64) DEFAULT ''::character varying NOT NULL,
    rhs_module character varying(100) DEFAULT ''::character varying NOT NULL,
    rhs_table character varying(64) DEFAULT ''::character varying NOT NULL,
    rhs_key character varying(64) DEFAULT ''::character varying NOT NULL,
    join_table character varying(64),
    join_key_lhs character varying(64),
    join_key_rhs character varying(64),
    relationship_type character varying(64),
    relationship_role_column character varying(64),
    relationship_role_column_value character varying(15),
    reverse smallint DEFAULT 0::smallint,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: releases; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE releases (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    list_order integer,
    status character varying(25)
);


--
-- Name: roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE roles (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(150),
    description text,
    modules text,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: roles_modules; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE roles_modules (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    role_id character(36) DEFAULT ''::bpchar,
    module_id character(36) DEFAULT ''::bpchar,
    allow smallint DEFAULT 0::smallint,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: roles_users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE roles_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    role_id character(36) DEFAULT ''::bpchar,
    user_id character(36) DEFAULT ''::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint
);


--
-- Name: sales_account; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_account (
    id bigserial NOT NULL,
    account_name character varying(150),
    account_type character varying(25),
    industry character varying(25)
);


--
-- Name: sales_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_account', 'id'), 1, false);


--
-- Name: sales_date_of_close; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_date_of_close (
    id bigserial NOT NULL,
    close_year smallint,
    close_quarter_in_year smallint,
    close_quarter_name character varying(5),
    close_month smallint,
    close_month_name character varying(10),
    close_week_in_year bigint,
    close_week_in_month bigint
);


--
-- Name: sales_date_of_close_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_date_of_close', 'id'), 1, false);


--
-- Name: sales_date_of_start; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_date_of_start (
    id bigserial NOT NULL,
    start_year smallint,
    start_quarter_in_year smallint,
    start_quarter_name character varying(5),
    start_month smallint,
    start_month_name character varying(10),
    start_week_in_year smallint,
    start_week_in_month smallint
);


--
-- Name: sales_date_of_start_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_date_of_start', 'id'), 1, false);


--
-- Name: sales_fact; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_fact (
    id bigserial NOT NULL,
    sales_date_of_close_id bigint,
    sales_date_of_start_id bigint,
    sales_person_id bigint,
    sales_account_id bigint,
    sales_location_id bigint,
    sales_state_id bigint,
    amount bigint,
    time_to_close bigint,
    probability bigint
);


--
-- Name: sales_fact_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_fact', 'id'), 1, false);


--
-- Name: sales_location; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_location (
    id bigserial NOT NULL,
    zipcode character varying(20),
    city character varying(100),
    state character varying(100),
    country character varying(100)
);


--
-- Name: sales_location_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_location', 'id'), 1, false);


--
-- Name: sales_person; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_person (
    id bigserial NOT NULL,
    first_name character varying(30),
    last_name character varying(30),
    full_name character varying(60),
    manager_id bigint
);


--
-- Name: sales_person_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_person', 'id'), 1, false);


--
-- Name: sales_state; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sales_state (
    id bigserial NOT NULL,
    sales_state character varying(25)
);


--
-- Name: sales_state_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('sales_state', 'id'), 1, false);


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasks (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(50),
    status character varying(25),
    date_due_flag character varying(5) DEFAULT 'on'::character varying,
    date_due date,
    time_due time without time zone,
    date_start_flag character varying(5) DEFAULT 'on'::character varying,
    date_start date,
    time_start time without time zone,
    parent_type character varying(25),
    parent_id character varying(36),
    contact_id character varying(36),
    priority character varying(25),
    description text,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: tracker; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tracker (
    id bigserial NOT NULL,
    user_id character(36),
    module_name character(25),
    item_id character(36),
    item_summary character(255),
    date_modified timestamp without time zone
);


--
-- Name: tracker_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('tracker', 'id'), 1, false);


--
-- Name: upgrade_history; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE upgrade_history (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    md5sum character varying(32) DEFAULT ''::character varying NOT NULL,
    "type" character varying(30) DEFAULT ''::character varying NOT NULL,
    status character varying(50) DEFAULT ''::character varying NOT NULL,
    version character varying(10) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL
);


--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    user_name character varying(20),
    user_password character varying(30),
    user_hash character varying(32),
    first_name character varying(30),
    last_name character varying(30),
    reports_to_id character varying(36),
    is_admin character(3) DEFAULT '0'::bpchar,
    receive_notifications character(1) DEFAULT '1'::bpchar,
    description text,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    title character varying(50),
    department character varying(50),
    phone_home character varying(50),
    phone_mobile character varying(50),
    phone_work character varying(50),
    phone_other character varying(50),
    phone_fax character varying(50),
    email1 character varying(100),
    email2 character varying(100),
    status character varying(25),
    address_street character varying(150),
    address_city character varying(100),
    address_state character varying(100),
    address_country character varying(25),
    address_postalcode character varying(9),
    user_preferences text,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    portal_only smallint DEFAULT 0::smallint,
    employee_status character varying(25),
    messenger_id character varying(25),
    messenger_type character varying(25)
);


--
-- Name: users_feeds; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users_feeds (
    user_id character(36) DEFAULT ''::bpchar NOT NULL,
    feed_id character(36) DEFAULT ''::bpchar NOT NULL,
    rank bigint DEFAULT 0::bigint NOT NULL,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: users_last_import; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users_last_import (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    assigned_user_id character(36),
    bean_type character(36),
    bean_id character(36),
    deleted smallint DEFAULT 0::smallint NOT NULL
);


--
-- Name: vcals; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vcals (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    "type" character varying(25),
    source character varying(25),
    content text
);


--
-- Name: versions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE versions (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    deleted smallint DEFAULT 0::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character(36) DEFAULT ''::bpchar NOT NULL,
    created_by character(36),
    name character(255) DEFAULT ''::bpchar NOT NULL,
    file_version character(255) DEFAULT ''::bpchar NOT NULL,
    db_version character(255) DEFAULT ''::bpchar NOT NULL
);


--
-- Name: orders; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE orders (
    orderid integer,
    customerid character varying(5),
    employeeid integer,
    orderdate timestamp without time zone,
    requireddate timestamp without time zone,
    shippeddate timestamp without time zone,
    shipvia integer,
    freight numeric,
    shipname character varying(255),
    shipaddress character varying(255),
    shipcity character varying(100),
    shipregion character varying(100),
    shippostalcode character varying(20),
    shipcountry character varying(100)
);


--
-- Data for Name: accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY accounts (id, date_entered, date_modified, modified_user_id, assigned_user_id, created_by, name, parent_id, account_type, industry, annual_revenue, phone_fax, billing_address_street, billing_address_city, billing_address_state, billing_address_postalcode, billing_address_country, description, rating, phone_office, phone_alternate, email1, email2, website, ownership, employees, sic_code, ticker_symbol, shipping_address_street, shipping_address_city, shipping_address_state, shipping_address_postalcode, shipping_address_country, deleted) FROM stdin;
a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:19:03	2005-11-30 19:19:03	1	beth_id	1	Alpha-Murraiin Communications, Inc	\N	Manufacturing	Communications	\N	\N	5423 Camby Rd.	La Mesa	CA	35890	USA	\N	\N	612-555-4878	\N	\N	\N	www.alpha-murraiincommunications,inc.com	\N	\N	\N	\N	5423 Camby Rd.	La Mesa	CA	35890	USA	0
e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:19:03	2005-11-30 19:19:03	1	sarah_id	1	N & W Creek Transportation Corp	\N	Distribution	Transportation	\N	\N	1792 Belmont Rd.	Chula Vista	CA	40520	USA	\N	\N	555-555-2714	\N	\N	\N	www.nwcreektransportationcorp.com	\N	\N	\N	\N	1792 Belmont Rd.	Chula Vista	CA	40520	USA	0
18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:19:04	2005-11-30 19:19:04	1	matt_id	1	Creek-Medina Engineering Partners	\N	Supply	Engineering	\N	\N	3796 Keller Ridge	Mexico City	Mexico	59554	Mexico	\N	\N	343-555-9778	\N	\N	\N	www.creek-medinaengineeringpartners.com	\N	\N	\N	\N	3796 Keller Ridge	Mexico City	Mexico	59554	Mexico	0
419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:19:04	2005-11-30 19:19:04	1	sarah_id	1	O & D Rutledge Communications Associates	\N	Distribution	Communications	\N	\N	3074 Ardith Drive	Lincoln Acres	CA	30346	USA	\N	\N	659-555-3160	\N	\N	\N	www.odrutledgecommunicationsassociates.com	\N	\N	\N	\N	3074 Ardith Drive	Lincoln Acres	CA	30346	USA	0
67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:19:04	2005-11-30 19:19:04	1	sally_id	1	Rutledge-Cavestany Transportation Company	\N	Consulting	Transportation	\N	\N	7987 Seawind Dr.	Oak Bay	BC	15542	Canada	\N	\N	471-555-8853	\N	\N	\N	www.rutledge-cavestanytransportationcompany.com	\N	\N	\N	\N	7987 Seawind Dr.	Oak Bay	BC	15542	Canada	0
8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:19:04	2005-11-30 19:19:04	1	sally_id	1	M & Y Planck Communications, Ltd	\N	Supply	Communications	\N	\N	4864 San Carlos	Camacho	Zacatecas	77787	Mexico	\N	\N	698-555-7603	\N	\N	\N	www.myplanckcommunications,ltd.com	\N	\N	\N	\N	4864 San Carlos	Camacho	Zacatecas	77787	Mexico	0
b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:19:04	2005-11-30 19:19:04	1	beth_id	1	Planck-Marshall Communications Associates	\N	Consulting	Communications	\N	\N	2687 Ridge Road	Arcadia	CA	28530	USA	\N	\N	771-555-6581	\N	\N	\N	www.planck-marshallcommunicationsassociates.com	\N	\N	\N	\N	2687 Ridge Road	Arcadia	CA	28530	USA	0
dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:19:04	2005-11-30 19:19:04	1	max_id	1	B & D Wolter Machinery Partners	\N	Consulting	Machinery	\N	\N	2473 Orchard Way	Altadena	CA	49680	USA	\N	\N	121-555-3960	\N	\N	\N	www.bdwoltermachinerypartners.com	\N	\N	\N	\N	2473 Orchard Way	Altadena	CA	49680	USA	0
e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:19:05	2005-11-30 19:19:05	1	sarah_id	1	Wolter-Collins Construction Partners	\N	Manufacturing	Construction	\N	\N	551 Rainier Dr	Oakland	CA	21486	USA	\N	\N	217-555-1567	\N	\N	\N	www.wolter-collinsconstructionpartners.com	\N	\N	\N	\N	551 Rainier Dr	Oakland	CA	21486	USA	0
33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:19:05	2005-11-30 19:19:05	1	kristen_id	1	H & E Baker Machinery Group	\N	Supply	Machinery	\N	\N	591 Merriewood Drive	Spring Valley	CA	88762	USA	\N	\N	617-555-7972	\N	\N	\N	www.hebakermachinerygroup.com	\N	\N	\N	\N	591 Merriewood Drive	Spring Valley	CA	88762	USA	0
60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:19:05	2005-11-30 19:19:05	1	beth_id	1	Baker-Castillo Electronics Holdings	\N	Supply	Electronics	\N	\N	1579 Plaza Rosa	Renton	WA	71442	USA	\N	\N	975-555-7865	\N	\N	\N	www.baker-castilloelectronicsholdings.com	\N	\N	\N	\N	1579 Plaza Rosa	Renton	WA	71442	USA	0
8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:19:05	2005-11-30 19:19:05	1	max_id	1	X & M Borges Construction Corp	\N	Manufacturing	Construction	\N	\N	1873 Lyon Circle	Bellingham	WA	78588	USA	\N	\N	610-555-6158	\N	\N	\N	www.xmborgesconstructioncorp.com	\N	\N	\N	\N	1873 Lyon Circle	Bellingham	WA	78588	USA	0
b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:19:05	2005-11-30 19:19:05	1	sally_id	1	Borges-Wyro Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	3114 Notre Dame Ave.	La Jolla	CA	27430	USA	\N	\N	444-555-1517	\N	\N	\N	www.borges-wyrotelecommunications,ltd.com	\N	\N	\N	\N	3114 Notre Dame Ave.	La Jolla	CA	27430	USA	0
de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:19:05	2005-11-30 19:19:05	1	chris_id	1	I & M Wyllie Transportation, Ltd	\N	Supply	Transportation	\N	\N	6318 Marclair Dr.	Santa Fe	DF	99737	Mexico	\N	\N	102-555-7439	\N	\N	\N	www.imwyllietransportation,ltd.com	\N	\N	\N	\N	6318 Marclair Dr.	Santa Fe	DF	99737	Mexico	0
fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:19:06	2005-11-30 19:19:06	1	will_id	1	Wyllie-Conley Electronics Corp	\N	Manufacturing	Electronics	\N	\N	7814 Milburn Dr.	Haney	BC	65710	Canada	\N	\N	506-555-4589	\N	\N	\N	www.wyllie-conleyelectronicscorp.com	\N	\N	\N	\N	7814 Milburn Dr.	Haney	BC	65710	Canada	0
382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:19:06	2005-11-30 19:19:06	1	kristen_id	1	H & Y Bernard Engineering, Inc	\N	Distribution	Engineering	\N	\N	3928 San Francisco	Burbank	CA	51809	USA	\N	\N	425-555-3796	\N	\N	\N	www.hybernardengineering,inc.com	\N	\N	\N	\N	3928 San Francisco	Burbank	CA	51809	USA	0
611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:19:06	2005-11-30 19:19:06	1	jaime_id	1	Bernard-Macaluso Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	5678 McElroy Court	Anacortes	WA	58052	USA	\N	\N	852-555-8574	\N	\N	\N	www.bernard-macalusotelecommunications,ltd.com	\N	\N	\N	\N	5678 McElroy Court	Anacortes	WA	58052	USA	0
87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:19:06	2005-11-30 19:19:06	1	sally_id	1	D & A Wood Machinery Group	\N	Manufacturing	Machinery	\N	\N	2046 Las Palmas	Everett	WA	88974	USA	\N	\N	794-555-6410	\N	\N	\N	www.dawoodmachinerygroup.com	\N	\N	\N	\N	2046 Las Palmas	Everett	WA	88974	USA	0
aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:19:06	2005-11-30 19:19:06	1	max_id	1	Wood-Armstrong Construction Associates	\N	Consulting	Construction	\N	\N	608 Lincoln Dr.	Oak Bay	BC	90098	Canada	\N	\N	583-555-4474	\N	\N	\N	www.wood-armstrongconstructionassociates.com	\N	\N	\N	\N	608 Lincoln Dr.	Oak Bay	BC	90098	Canada	0
d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:19:06	2005-11-30 19:19:06	1	max_id	1	D & Z Goldey Electronics, Ltd	\N	Consulting	Electronics	\N	\N	7230 Berrellesa Street	Milwaukie	OR	78800	USA	\N	\N	548-555-9939	\N	\N	\N	www.dzgoldeyelectronics,ltd.com	\N	\N	\N	\N	7230 Berrellesa Street	Milwaukie	OR	78800	USA	0
c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:19:07	2005-11-30 19:19:07	1	kristen_id	1	Goldey-Nickell Engineering Corp	\N	Consulting	Engineering	\N	\N	2144 San Rafael	Concord	CA	63996	USA	\N	\N	598-555-1289	\N	\N	\N	www.goldey-nickellengineeringcorp.com	\N	\N	\N	\N	2144 San Rafael	Concord	CA	63996	USA	0
3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:19:07	2005-11-30 19:19:07	1	will_id	1	Q & Q Long Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	1676 Greer Ave.	Ladner	BC	99949	Canada	\N	\N	937-555-2299	\N	\N	\N	www.qqlongtelecommunicationsassociates.com	\N	\N	\N	\N	1676 Greer Ave.	Ladner	BC	99949	Canada	0
5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:19:07	2005-11-30 19:19:07	1	max_id	1	Long-Solimena Engineering Company	\N	Manufacturing	Engineering	\N	\N	6843 San Simeon Dr.	Santa Cruz	CA	51307	USA	\N	\N	111-555-1278	\N	\N	\N	www.long-solimenaengineeringcompany.com	\N	\N	\N	\N	6843 San Simeon Dr.	Santa Cruz	CA	51307	USA	0
8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:19:07	2005-11-30 19:19:07	1	matt_id	1	Y & R Muenich Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	6629 Polson Circle	La Mesa	CA	53422	USA	\N	\N	361-555-7656	\N	\N	\N	www.yrmuenichmachinery,inc.com	\N	\N	\N	\N	6629 Polson Circle	La Mesa	CA	53422	USA	0
b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:19:07	2005-11-30 19:19:07	1	sarah_id	1	Muenich-Young Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	Rt. 470 Box A	Merida	Yucatan	69940	Mexico	\N	\N	457-555-5263	\N	\N	\N	www.muenich-youngengineering,inc.com	\N	\N	\N	\N	Rt. 470 Box A	Merida	Yucatan	69940	Mexico	0
e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:19:07	2005-11-30 19:19:07	1	kristen_id	1	E & F Arnold Machinery, Ltd	\N	Consulting	Machinery	\N	\N	7403 N. Broadway	Oregon City	OR	38217	USA	\N	\N	969-555-4928	\N	\N	\N	www.efarnoldmachinery,ltd.com	\N	\N	\N	\N	7403 N. Broadway	Oregon City	OR	38217	USA	0
12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:19:08	2005-11-30 19:19:08	1	chris_id	1	Arnold-Cooper Transportation Holdings	\N	Distribution	Transportation	\N	\N	5734 Ashford Court	Seattle	WA	93604	USA	\N	\N	188-555-1163	\N	\N	\N	www.arnold-coopertransportationholdings.com	\N	\N	\N	\N	5734 Ashford Court	Seattle	WA	93604	USA	0
3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:19:08	2005-11-30 19:19:08	1	will_id	1	N & O Petty Electronics, Inc	\N	Supply	Electronics	\N	\N	8684 Military East	Arcadia	CA	28043	USA	\N	\N	722-555-8456	\N	\N	\N	www.nopettyelectronics,inc.com	\N	\N	\N	\N	8684 Military East	Arcadia	CA	28043	USA	0
68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:19:08	2005-11-30 19:19:08	1	kristen_id	1	Petty-Olguin Machinery Group	\N	Distribution	Machinery	\N	\N	7270 Pepperidge Way	Lebanon	OR	49592	USA	\N	\N	203-555-6978	\N	\N	\N	www.petty-olguinmachinerygroup.com	\N	\N	\N	\N	7270 Pepperidge Way	Lebanon	OR	49592	USA	0
92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:19:08	2005-11-30 19:19:08	1	beth_id	1	U & W Burchett Construction Corp	\N	Supply	Construction	\N	\N	475 Santa Maria	Santa Cruz	CA	49192	USA	\N	\N	761-555-3899	\N	\N	\N	www.uwburchettconstructioncorp.com	\N	\N	\N	\N	475 Santa Maria	Santa Cruz	CA	49192	USA	0
ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:19:08	2005-11-30 19:19:08	1	max_id	1	Burchett-Bechard Electronics Company	\N	Consulting	Electronics	\N	\N	1970 Napa Ct.	W. Linn	OR	36903	USA	\N	\N	616-555-6966	\N	\N	\N	www.burchett-bechardelectronicscompany.com	\N	\N	\N	\N	1970 Napa Ct.	W. Linn	OR	36903	USA	0
df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:19:08	2005-11-30 19:19:08	1	chris_id	1	M & K Carter Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	8084 Cardiff Drive	San Andres	DF	94169	Mexico	\N	\N	535-555-6174	\N	\N	\N	www.mkcartertelecommunications,ltd.com	\N	\N	\N	\N	8084 Cardiff Drive	San Andres	DF	94169	Mexico	0
15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:19:09	2005-11-30 19:19:09	1	sarah_id	1	Carter-Sharp Machinery, Ltd	\N	Consulting	Machinery	\N	\N	9833 Mt. Dias Blv.	Burbank	CA	48042	USA	\N	\N	962-555-1952	\N	\N	\N	www.carter-sharpmachinery,ltd.com	\N	\N	\N	\N	9833 Mt. Dias Blv.	Burbank	CA	48042	USA	0
3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:19:09	2005-11-30 19:19:09	1	beth_id	1	L & E Brunner Communications Partners	\N	Distribution	Communications	\N	\N	6202 Seeno St.	Bellflower	CA	52673	USA	\N	\N	904-555-8788	\N	\N	\N	www.lebrunnercommunicationspartners.com	\N	\N	\N	\N	6202 Seeno St.	Bellflower	CA	52673	USA	0
62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:19:09	2005-11-30 19:19:09	1	sally_id	1	Brunner-Staton Construction Holdings	\N	Consulting	Construction	\N	\N	862 The Alameda	Renton	WA	71706	USA	\N	\N	693-555-6852	\N	\N	\N	www.brunner-statonconstructionholdings.com	\N	\N	\N	\N	862 The Alameda	Renton	WA	71706	USA	0
9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:19:09	2005-11-30 19:19:09	1	kristen_id	1	W & N Sims Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	7484 Roundtree Drive	Mill Valley	CA	68791	USA	\N	\N	658-555-3316	\N	\N	\N	www.wnsimstelecommunicationspartners.com	\N	\N	\N	\N	7484 Roundtree Drive	Mill Valley	CA	68791	USA	0
b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:19:09	2005-11-30 19:19:09	1	sally_id	1	Sims-De Carlo Transportation Holdings	\N	Consulting	Transportation	\N	\N	5053 Loftus Road	Oak Bay	BC	53986	Canada	\N	\N	708-555-3666	\N	\N	\N	www.sims-decarlotransportationholdings.com	\N	\N	\N	\N	5053 Loftus Road	Oak Bay	BC	53986	Canada	0
e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:19:09	2005-11-30 19:19:09	1	beth_id	1	V & A Williams Transportation Corp	\N	Consulting	Transportation	\N	\N	1930 Almondwood Drive	Camacho	Zacatecas	89939	Mexico	\N	\N	696-555-7759	\N	\N	\N	www.vawilliamstransportationcorp.com	\N	\N	\N	\N	1930 Almondwood Drive	Camacho	Zacatecas	89939	Mexico	0
19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:19:10	2005-11-30 19:19:10	1	max_id	1	Williams-Burke Communications Corp	\N	Consulting	Communications	\N	\N	9752 Jeanne Circle	Arcadia	CA	41297	USA	\N	\N	770-555-6738	\N	\N	\N	www.williams-burkecommunicationscorp.com	\N	\N	\N	\N	9752 Jeanne Circle	Arcadia	CA	41297	USA	0
44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:19:10	2005-11-30 19:19:10	1	sally_id	1	T & A Osborn Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	9539 Glenside Dr	Altadena	CA	43412	USA	\N	\N	119-555-4116	\N	\N	\N	www.taosbornelectronics,inc.com	\N	\N	\N	\N	9539 Glenside Dr	Altadena	CA	43412	USA	0
69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:19:10	2005-11-30 19:19:10	1	matt_id	1	Osborn-Binai Construction Associates	\N	Manufacturing	Construction	\N	\N	7616 Honey Court	Oakland	CA	33639	USA	\N	\N	216-555-1723	\N	\N	\N	www.osborn-binaiconstructionassociates.com	\N	\N	\N	\N	7616 Honey Court	Oakland	CA	33639	USA	0
9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:19:10	2005-11-30 19:19:10	1	chris_id	1	D & D Lozada Electronics Holdings	\N	Supply	Electronics	\N	\N	7657 H St.	Tixapan	DF	19185	Mexico	\N	\N	727-555-1388	\N	\N	\N	www.ddlozadaelectronicsholdings.com	\N	\N	\N	\N	7657 H St.	Tixapan	DF	19185	Mexico	0
c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:19:10	2005-11-30 19:19:10	1	sarah_id	1	Lozada-Tays Machinery, Inc	\N	Distribution	Machinery	\N	\N	5988 Red Leaf	Oak Bay	BC	83595	Canada	\N	\N	298-555-3541	\N	\N	\N	www.lozada-taysmachinery,inc.com	\N	\N	\N	\N	5988 Red Leaf	Oak Bay	BC	83595	Canada	0
24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:19:11	2005-11-30 19:19:11	1	sally_id	1	I & V Thorton Engineering, Inc	\N	Distribution	Engineering	\N	\N	8938 West Hookston Road	Metchosin	BC	18033	Canada	\N	\N	832-555-1834	\N	\N	\N	www.ivthortonengineering,inc.com	\N	\N	\N	\N	8938 West Hookston Road	Metchosin	BC	18033	Canada	0
28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:19:11	2005-11-30 19:19:11	1	beth_id	1	Thorton-Dumin Construction, Ltd	\N	Manufacturing	Construction	\N	\N	181 Gainsborough Drive	Grossmont	CA	39583	USA	\N	\N	313-555-9355	\N	\N	\N	www.thorton-duminconstruction,ltd.com	\N	\N	\N	\N	181 Gainsborough Drive	Grossmont	CA	39583	USA	0
5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:19:11	2005-11-30 19:19:11	1	matt_id	1	K & R Chin Communications Group	\N	Consulting	Communications	\N	\N	3385 Crestview Drive	Imperial Beach	CA	39182	USA	\N	\N	871-555-6277	\N	\N	\N	www.krchincommunicationsgroup.com	\N	\N	\N	\N	3385 Crestview Drive	Imperial Beach	CA	39182	USA	0
7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:19:11	2005-11-30 19:19:11	1	jaime_id	1	Chin-Lovell Engineering Associates	\N	Distribution	Engineering	\N	\N	6912 Laguna St.	San Andres	DF	26893	Mexico	\N	\N	375-555-3427	\N	\N	\N	www.chin-lovellengineeringassociates.com	\N	\N	\N	\N	6912 Laguna St.	San Andres	DF	26893	Mexico	0
a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:19:11	2005-11-30 19:19:11	1	max_id	1	B & P Ratcliff Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	371 Ahneita Dr.	Oakland	CA	65362	USA	\N	\N	294-555-2634	\N	\N	\N	www.bpratclifftelecommunicationsholdings.com	\N	\N	\N	\N	371 Ahneita Dr.	Oakland	CA	65362	USA	0
ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:19:11	2005-11-30 19:19:11	1	kristen_id	1	Ratcliff-Moss Electronics, Ltd	\N	Distribution	Electronics	\N	\N	4776 Kentucky Drive	Burnaby	BC	70204	Canada	\N	\N	721-555-7412	\N	\N	\N	www.ratcliff-mosselectronics,ltd.com	\N	\N	\N	\N	4776 Kentucky Drive	Burnaby	BC	70204	Canada	0
301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:19:12	2005-11-30 19:19:12	1	chris_id	1	Q & P Anderson Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	1145 Paraiso Ct.	Langley	BC	74834	Canada	\N	\N	663-555-5248	\N	\N	\N	www.qpandersontelecommunicationscompany.com	\N	\N	\N	\N	1145 Paraiso Ct.	Langley	BC	74834	Canada	0
2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:19:12	2005-11-30 19:19:12	1	beth_id	1	Anderson-Everson Transportation Holdings	\N	Consulting	Transportation	\N	\N	3148 Rose Street	Tacoma	WA	93868	USA	\N	\N	451-555-3312	\N	\N	\N	www.anderson-eversontransportationholdings.com	\N	\N	\N	\N	3148 Rose Street	Tacoma	WA	93868	USA	0
5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:19:12	2005-11-30 19:19:12	1	kristen_id	1	G & N Borden Communications Group	\N	Supply	Communications	\N	\N	2427 Notre Dame Ave.	Santa Monica	CA	64660	USA	\N	\N	656-555-3434	\N	\N	\N	www.gnbordencommunicationsgroup.com	\N	\N	\N	\N	2427 Notre Dame Ave.	Santa Monica	CA	64660	USA	0
812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:19:12	2005-11-30 19:19:12	1	kristen_id	1	Borden-Willson Construction Partners	\N	Distribution	Construction	\N	\N	7340 Green St.	Tlaxiaco	Oaxaca	49856	Mexico	\N	\N	467-555-9127	\N	\N	\N	www.borden-willsonconstructionpartners.com	\N	\N	\N	\N	7340 Green St.	Tlaxiaco	Oaxaca	49856	Mexico	0
c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:19:12	2005-11-30 19:19:12	1	kristen_id	1	H & Y Harris Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	6872 Thornwood Dr.	Beaverton	OR	85809	USA	\N	\N	814-555-9899	\N	\N	\N	www.hyharriselectronics,ltd.com	\N	\N	\N	\N	6872 Thornwood Dr.	Beaverton	OR	85809	USA	0
ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:19:12	2005-11-30 19:19:12	1	chris_id	1	Harris-Contreras Transportation Holdings	\N	Supply	Transportation	\N	\N	2040 Encino Drive	Metchosin	BC	37167	Canada	\N	\N	648-555-5221	\N	\N	\N	www.harris-contrerastransportationholdings.com	\N	\N	\N	\N	2040 Encino Drive	Metchosin	BC	37167	Canada	0
25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:19:13	2005-11-30 19:19:13	1	sarah_id	1	O & K Pusedu Transportation Corp	\N	Manufacturing	Transportation	\N	\N	1826 Corte Del Sol	Metchosin	BC	39282	Canada	\N	\N	898-555-2599	\N	\N	\N	www.okpusedutransportationcorp.com	\N	\N	\N	\N	1826 Corte Del Sol	Metchosin	BC	39282	Canada	0
5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:19:13	2005-11-30 19:19:13	1	beth_id	1	Pusedu-Stedman Construction Partners	\N	Consulting	Construction	\N	\N	9903 East Leland	Westminster	BC	55800	Canada	\N	\N	994-555-9206	\N	\N	\N	www.pusedu-stedmanconstructionpartners.com	\N	\N	\N	\N	9903 East Leland	Westminster	BC	55800	Canada	0
7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:19:13	2005-11-30 19:19:13	1	sally_id	1	D & D Zocchi Transportation, Ltd	\N	Distribution	Transportation	\N	\N	9943 Stonehedge Dr.	Hidalgo	Zacatecas	24077	Mexico	\N	\N	606-555-8871	\N	\N	\N	www.ddzocchitransportation,ltd.com	\N	\N	\N	\N	9943 Stonehedge Dr.	Hidalgo	Zacatecas	24077	Mexico	0
a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:19:13	2005-11-30 19:19:13	1	kristen_id	1	Zocchi-Walsh Machinery, Inc	\N	Consulting	Machinery	\N	\N	931 Corte De Luna	Los Angeles	CA	79465	USA	\N	\N	725-555-5106	\N	\N	\N	www.zocchi-walshmachinery,inc.com	\N	\N	\N	\N	931 Corte De Luna	Los Angeles	CA	79465	USA	0
cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:19:13	2005-11-30 19:19:13	1	beth_id	1	E & M Renfro Electronics Company	\N	Supply	Electronics	\N	\N	1226 Shoenic	Coronado	CA	13903	USA	\N	\N	360-555-3399	\N	\N	\N	www.emrenfroelectronicscompany.com	\N	\N	\N	\N	1226 Shoenic	Coronado	CA	13903	USA	0
f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:19:13	2005-11-30 19:19:13	1	matt_id	1	Renfro-Brockett Engineering, Ltd	\N	Distribution	Engineering	\N	\N	2467 Clearland Circle	La Cruz	Sinaloa	61745	Mexico	\N	\N	741-555-1921	\N	\N	\N	www.renfro-brockettengineering,ltd.com	\N	\N	\N	\N	2467 Clearland Circle	La Cruz	Sinaloa	61745	Mexico	0
221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:19:14	2005-11-30 19:19:14	1	matt_id	1	R & Z Anderson Communications, Inc	\N	Distribution	Communications	\N	\N	5671 Bel Air Dr.	Shawnee	BC	35052	Canada	\N	\N	398-555-7842	\N	\N	\N	www.rzandersoncommunications,inc.com	\N	\N	\N	\N	5671 Bel Air Dr.	Shawnee	BC	35052	Canada	0
49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:19:14	2005-11-30 19:19:14	1	chris_id	1	Anderson-Gomez Machinery Partners	\N	Supply	Machinery	\N	\N	7166 Brock Lane	Yakima	WA	49055	USA	\N	\N	802-555-4992	\N	\N	\N	www.anderson-gomezmachinerypartners.com	\N	\N	\N	\N	7166 Brock Lane	Yakima	WA	49055	USA	0
6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:19:14	2005-11-30 19:19:14	1	sarah_id	1	J & K Walker Communications Corp	\N	Supply	Communications	\N	\N	3281 Hillview Dr.	Ballard	WA	87524	USA	\N	\N	722-555-4199	\N	\N	\N	www.jkwalkercommunicationscorp.com	\N	\N	\N	\N	3281 Hillview Dr.	Ballard	WA	87524	USA	0
953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:19:14	2005-11-30 19:19:14	1	sally_id	1	Walker-Jones Construction, Ltd	\N	Supply	Construction	\N	\N	5030 Blue Ridge Dr.	Lynnwood	WA	35227	USA	\N	\N	248-555-8978	\N	\N	\N	www.walker-jonesconstruction,ltd.com	\N	\N	\N	\N	5030 Blue Ridge Dr.	Lynnwood	WA	35227	USA	0
baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:19:14	2005-11-30 19:19:14	1	max_id	1	W & W Winfrey Electronics Associates	\N	Supply	Electronics	\N	\N	1399 Firestone Drive	Port Orchard	WA	66150	USA	\N	\N	191-555-6813	\N	\N	\N	www.wwwinfreyelectronicsassociates.com	\N	\N	\N	\N	1399 Firestone Drive	Port Orchard	WA	66150	USA	0
eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:19:14	2005-11-30 19:19:14	1	max_id	1	Winfrey-Brown Machinery Group	\N	Manufacturing	Machinery	\N	\N	6058 Hill Street	Downey	CA	85184	USA	\N	\N	569-555-5452	\N	\N	\N	www.winfrey-brownmachinerygroup.com	\N	\N	\N	\N	6058 Hill Street	Downey	CA	85184	USA	0
1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:19:15	2005-11-30 19:19:15	1	beth_id	1	D & G Touchstone Transportation, Inc	\N	Distribution	Transportation	\N	\N	2681 Eagle Peak	Salem	OR	55976	USA	\N	\N	774-555-5574	\N	\N	\N	www.dgtouchstonetransportation,inc.com	\N	\N	\N	\N	2681 Eagle Peak	Salem	OR	55976	USA	0
4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:19:15	2005-11-30 19:19:15	1	matt_id	1	Touchstone-Bakhtyari Engineering, Ltd	\N	Supply	Engineering	\N	\N	7594 Alexander Pl.	Tacoma	WA	41172	USA	\N	\N	585-555-2267	\N	\N	\N	www.touchstone-bakhtyariengineering,ltd.com	\N	\N	\N	\N	7594 Alexander Pl.	Tacoma	WA	41172	USA	0
71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:19:15	2005-11-30 19:19:15	1	jaime_id	1	Z & L Glass Construction, Ltd	\N	Supply	Construction	\N	\N	7126 Edie Ct.	Lemon Grove	CA	77125	USA	\N	\N	812-555-1017	\N	\N	\N	www.zlglassconstruction,ltd.com	\N	\N	\N	\N	7126 Edie Ct.	Lemon Grove	CA	77125	USA	0
9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:19:15	2005-11-30 19:19:15	1	will_id	1	Glass-Cohen Transportation Group	\N	Manufacturing	Transportation	\N	\N	2294 West 39th St.	Milwaukie	OR	28482	USA	\N	\N	646-555-5338	\N	\N	\N	www.glass-cohentransportationgroup.com	\N	\N	\N	\N	2294 West 39th St.	Milwaukie	OR	28482	USA	0
bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:19:15	2005-11-30 19:19:15	1	max_id	1	V & P Kharman Transportation Corp	\N	Consulting	Transportation	\N	\N	2080 Sycamore Drive	Richmond	CA	30597	USA	\N	\N	896-555-2717	\N	\N	\N	www.vpkharmantransportationcorp.com	\N	\N	\N	\N	2080 Sycamore Drive	Richmond	CA	30597	USA	0
e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:19:15	2005-11-30 19:19:15	1	will_id	1	Kharman-Kirschner Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	158 Walnut Ave	Arcadia	CA	47116	USA	\N	\N	331-555-3981	\N	\N	\N	www.kharman-kirschnertelecommunications,inc.com	\N	\N	\N	\N	158 Walnut Ave	Arcadia	CA	47116	USA	0
16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:19:16	2005-11-30 19:19:16	1	matt_id	1	F & X Burger Communications Partners	\N	Consulting	Communications	\N	\N	2854 Magda Way	Haney	BC	88099	Canada	\N	\N	604-555-8988	\N	\N	\N	www.fxburgercommunicationspartners.com	\N	\N	\N	\N	2854 Magda Way	Haney	BC	88099	Canada	0
3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:19:16	2005-11-30 19:19:16	1	sally_id	1	Burger-Blau Communications Holdings	\N	Distribution	Communications	\N	\N	1185 Dallis Drive	Novato	CA	70780	USA	\N	\N	723-555-5224	\N	\N	\N	www.burger-blaucommunicationsholdings.com	\N	\N	\N	\N	1185 Dallis Drive	Novato	CA	70780	USA	0
672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:19:16	2005-11-30 19:19:16	1	sarah_id	1	S & X Derby Engineering Partners	\N	Distribution	Engineering	\N	\N	8154 Via Mexico	Bremerton	WA	52198	USA	\N	\N	358-555-3517	\N	\N	\N	www.sxderbyengineeringpartners.com	\N	\N	\N	\N	8154 Via Mexico	Bremerton	WA	52198	USA	0
8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:19:16	2005-11-30 19:19:16	1	sarah_id	1	Derby-Thomson Transportation, Inc	\N	Supply	Transportation	\N	\N	6740 Jalisco	N. Vancouver	BC	26768	Canada	\N	\N	739-555-2038	\N	\N	\N	www.derby-thomsontransportation,inc.com	\N	\N	\N	\N	6740 Jalisco	N. Vancouver	BC	26768	Canada	0
b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:19:16	2005-11-30 19:19:16	1	sarah_id	1	H & N Walton Machinery Corp	\N	Supply	Machinery	\N	\N	2601 Cambridge Drive	Milwaukie	OR	26367	USA	\N	\N	396-555-7960	\N	\N	\N	www.hnwaltonmachinerycorp.com	\N	\N	\N	\N	2601 Cambridge Drive	Milwaukie	OR	26367	USA	0
da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:19:16	2005-11-30 19:19:16	1	will_id	1	Walton-Meastas Machinery Associates	\N	Supply	Machinery	\N	\N	4096 San Remo	Woodland Hills	CA	14079	USA	\N	\N	912-555-7369	\N	\N	\N	www.walton-meastasmachineryassociates.com	\N	\N	\N	\N	4096 San Remo	Woodland Hills	CA	14079	USA	0
115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:19:17	2005-11-30 19:19:17	1	max_id	1	G & W Kouba Transportation, Inc	\N	Distribution	Transportation	\N	\N	7554 Lakeview Pl.	Sooke	BC	78839	Canada	\N	\N	832-555-6577	\N	\N	\N	www.gwkoubatransportation,inc.com	\N	\N	\N	\N	7554 Lakeview Pl.	Sooke	BC	78839	Canada	0
389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:19:17	2005-11-30 19:19:17	1	matt_id	1	Kouba-Clark Machinery Corp	\N	Manufacturing	Machinery	\N	\N	1960 Via Catanzaro	Long Beach	CA	32712	USA	\N	\N	597-555-6013	\N	\N	\N	www.kouba-clarkmachinerycorp.com	\N	\N	\N	\N	1960 Via Catanzaro	Long Beach	CA	32712	USA	0
63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:19:17	2005-11-30 19:19:17	1	beth_id	1	V & B Munn Transportation Holdings	\N	Supply	Transportation	\N	\N	5672 Hale Dr.	Arcadia	CA	61730	USA	\N	\N	540-555-3848	\N	\N	\N	www.vbmunntransportationholdings.com	\N	\N	\N	\N	5672 Hale Dr.	Arcadia	CA	61730	USA	0
8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:19:17	2005-11-30 19:19:17	1	beth_id	1	Munn-Goldberg Construction Company	\N	Consulting	Construction	\N	\N	332 Laguna Niguel	Woodburn	OR	80763	USA	\N	\N	989-555-7255	\N	\N	\N	www.munn-goldbergconstructioncompany.com	\N	\N	\N	\N	332 Laguna Niguel	Woodburn	OR	80763	USA	0
b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:19:17	2005-11-30 19:19:17	1	max_id	1	C & A Magenheim Engineering Group	\N	Supply	Engineering	\N	\N	6954 Garcia Ranch Road	Vancouver	BC	77848	Canada	\N	\N	293-555-7377	\N	\N	\N	www.camagenheimengineeringgroup.com	\N	\N	\N	\N	6954 Garcia Ranch Road	Vancouver	BC	77848	Canada	0
d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:19:17	2005-11-30 19:19:17	1	kristen_id	1	Magenheim-Hance Construction, Ltd	\N	Consulting	Construction	\N	\N	4523 Via Cortez	Tlaxiaco	Oaxaca	63043	Mexico	\N	\N	471-555-9125	\N	\N	\N	www.magenheim-hanceconstruction,ltd.com	\N	\N	\N	\N	4523 Via Cortez	Tlaxiaco	Oaxaca	63043	Mexico	0
cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:19:18	2005-11-30 19:19:18	1	chris_id	1	U & S Mehlert Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	1400 Gibrix Drive	Beaverton	OR	98996	USA	\N	\N	698-555-7875	\N	\N	\N	www.usmehlerttransportation,inc.com	\N	\N	\N	\N	1400 Gibrix Drive	Beaverton	OR	98996	USA	0
34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:19:18	2005-11-30 19:19:18	1	will_id	1	Mehlert-Duran Construction Group	\N	Distribution	Construction	\N	\N	9222 Roseann Drive	Richmond	BC	50354	Canada	\N	\N	532-555-3196	\N	\N	\N	www.mehlert-duranconstructiongroup.com	\N	\N	\N	\N	9222 Roseann Drive	Richmond	BC	50354	Canada	0
6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:19:18	2005-11-30 19:19:18	1	sarah_id	1	N & W Earley Transportation Corp	\N	Distribution	Transportation	\N	\N	9009 W 46th St	Richmond	BC	52469	Canada	\N	\N	121-555-4232	\N	\N	\N	www.nwearleytransportationcorp.com	\N	\N	\N	\N	9009 W 46th St	Richmond	BC	52469	Canada	0
8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:19:18	2005-11-30 19:19:18	1	matt_id	1	Earley-Horne Engineering Partners	\N	Supply	Engineering	\N	\N	7086 O St.	Port Orchard	WA	42696	USA	\N	\N	217-555-1839	\N	\N	\N	www.earley-horneengineeringpartners.com	\N	\N	\N	\N	7086 O St.	Port Orchard	WA	42696	USA	0
b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:19:18	2005-11-30 19:19:18	1	sarah_id	1	O & D Hunt Communications Associates	\N	Distribution	Communications	\N	\N	7127 Morengo Court	San Jose	CA	10972	USA	\N	\N	490-555-6846	\N	\N	\N	www.odhuntcommunicationsassociates.com	\N	\N	\N	\N	7127 Morengo Court	San Jose	CA	10972	USA	0
dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:19:18	2005-11-30 19:19:18	1	sally_id	1	Hunt-Allen Transportation Company	\N	Consulting	Transportation	\N	\N	5458 Encino Drive	N. Vancouver	BC	92652	Canada	\N	\N	848-555-6739	\N	\N	\N	www.hunt-allentransportationcompany.com	\N	\N	\N	\N	5458 Encino Drive	N. Vancouver	BC	92652	Canada	0
114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:19:19	2005-11-30 19:19:19	1	sally_id	1	M & Y Bruno Communications, Ltd	\N	Supply	Communications	\N	\N	8408 Via Del Sol	Langford	BC	99797	Canada	\N	\N	244-555-1375	\N	\N	\N	www.mybrunocommunications,ltd.com	\N	\N	\N	\N	8408 Via Del Sol	Langford	BC	99797	Canada	0
3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:19:19	2005-11-30 19:19:19	1	beth_id	1	Bruno-Bowers Communications Associates	\N	Consulting	Communications	\N	\N	9650 Valley View Road	Acapulco	Guerrero	48640	Mexico	\N	\N	737-555-2156	\N	\N	\N	www.bruno-bowerscommunicationsassociates.com	\N	\N	\N	\N	9650 Valley View Road	Acapulco	Guerrero	48640	Mexico	0
63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:19:19	2005-11-30 19:19:19	1	max_id	1	B & D Gonzales Machinery Partners	\N	Consulting	Machinery	\N	\N	2855 Playa	Hidalgo	Zacatecas	48239	Mexico	\N	\N	394-555-8077	\N	\N	\N	www.bdgonzalesmachinerypartners.com	\N	\N	\N	\N	2855 Playa	Hidalgo	Zacatecas	48239	Mexico	0
9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:19:19	2005-11-30 19:19:19	1	sarah_id	1	Gonzales-Valdez Construction Partners	\N	Manufacturing	Construction	\N	\N	4350 Mota Dr.	National City	CA	35950	USA	\N	\N	137-555-8885	\N	\N	\N	www.gonzales-valdezconstructionpartners.com	\N	\N	\N	\N	4350 Mota Dr.	National City	CA	35950	USA	0
b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:19:19	2005-11-30 19:19:19	1	kristen_id	1	H & E Stewart Machinery Group	\N	Supply	Machinery	\N	\N	7808 Brown St.	Long Beach	CA	74419	USA	\N	\N	717-555-4435	\N	\N	\N	www.hestewartmachinerygroup.com	\N	\N	\N	\N	7808 Brown St.	Long Beach	CA	74419	USA	0
e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:19:19	2005-11-30 19:19:19	1	beth_id	1	Stewart-Velasquez Electronics Holdings	\N	Supply	Electronics	\N	\N	2214 Solano	Cliffside	BC	54584	Canada	\N	\N	483-555-3870	\N	\N	\N	www.stewart-velasquezelectronicsholdings.com	\N	\N	\N	\N	2214 Solano	Cliffside	BC	54584	Canada	0
12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:19:20	2005-11-30 19:19:20	1	max_id	1	X & M Dubois Construction Corp	\N	Manufacturing	Construction	\N	\N	8582 San Jose Ave.	Shawnee	BC	59214	Canada	\N	\N	425-555-1706	\N	\N	\N	www.xmduboisconstructioncorp.com	\N	\N	\N	\N	8582 San Jose Ave.	Shawnee	BC	59214	Canada	0
3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:19:20	2005-11-30 19:19:20	1	sally_id	1	Dubois-Maestas Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	3241 Brock Lane	Newton	BC	76633	Canada	\N	\N	214-555-8770	\N	\N	\N	www.dubois-maestastelecommunications,ltd.com	\N	\N	\N	\N	3241 Brock Lane	Newton	BC	76633	Canada	0
64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:19:20	2005-11-30 19:19:20	1	chris_id	1	I & M Underwood Transportation, Ltd	\N	Supply	Transportation	\N	\N	9863 Ridge Place	West Covina	CA	47425	USA	\N	\N	179-555-5235	\N	\N	\N	www.imunderwoodtransportation,ltd.com	\N	\N	\N	\N	9863 Ridge Place	West Covina	CA	47425	USA	0
92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:19:20	2005-11-30 19:19:20	1	will_id	1	Underwood-Strain Electronics Corp	\N	Manufacturing	Electronics	\N	\N	4777 Rockne Drive	Palo Alto	CA	32621	USA	\N	\N	890-555-1927	\N	\N	\N	www.underwood-strainelectronicscorp.com	\N	\N	\N	\N	4777 Rockne Drive	Palo Alto	CA	32621	USA	0
be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:19:20	2005-11-30 19:19:20	1	kristen_id	1	H & Y Azari Engineering, Inc	\N	Distribution	Engineering	\N	\N	4310 Kenston Dr.	Santa Monica	CA	68574	USA	\N	\N	217-555-9677	\N	\N	\N	www.hyazariengineering,inc.com	\N	\N	\N	\N	4310 Kenston Dr.	Santa Monica	CA	68574	USA	0
e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:19:20	2005-11-30 19:19:20	1	jaime_id	1	Azari-Dabit Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	9476 Hill Top Rd.	Sooke	BC	19932	Canada	\N	\N	291-555-8656	\N	\N	\N	www.azari-dabittelecommunications,ltd.com	\N	\N	\N	\N	9476 Hill Top Rd.	Sooke	BC	19932	Canada	0
1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:19:21	2005-11-30 19:19:21	1	sally_id	1	D & A Carmona Machinery Group	\N	Manufacturing	Machinery	\N	\N	9263 Mt. McKinley Ct.	Sooke	BC	22047	Canada	\N	\N	541-555-6035	\N	\N	\N	www.dacarmonamachinerygroup.com	\N	\N	\N	\N	9263 Mt. McKinley Ct.	Sooke	BC	22047	Canada	0
491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:19:21	2005-11-30 19:19:21	1	max_id	1	Carmona-Saxton Construction Associates	\N	Consulting	Construction	\N	\N	620 Woodside Ct.	Altadena	CA	38565	USA	\N	\N	330-555-4138	\N	\N	\N	www.carmona-saxtonconstructionassociates.com	\N	\N	\N	\N	620 Woodside Ct.	Altadena	CA	38565	USA	0
75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:19:21	2005-11-30 19:19:21	1	max_id	1	D & Z McLaughlin Electronics, Ltd	\N	Consulting	Electronics	\N	\N	661 Miller Ave.	Burnaby	BC	68422	Canada	\N	\N	602-555-9145	\N	\N	\N	www.dzmclaughlinelectronics,ltd.com	\N	\N	\N	\N	661 Miller Ave.	Burnaby	BC	68422	Canada	0
9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:19:21	2005-11-30 19:19:21	1	kristen_id	1	McLaughlin-Eyster Engineering Corp	\N	Consulting	Engineering	\N	\N	1648 Eastgate Lane	Albany	OR	62230	USA	\N	\N	960-555-9038	\N	\N	\N	www.mclaughlin-eysterengineeringcorp.com	\N	\N	\N	\N	1648 Eastgate Lane	Albany	OR	62230	USA	0
c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:19:21	2005-11-30 19:19:21	1	will_id	1	Q & Q Henry Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	4598 Manila Avenue	Bremerton	WA	95667	USA	\N	\N	356-555-3673	\N	\N	\N	www.qqhenrytelecommunicationsassociates.com	\N	\N	\N	\N	4598 Manila Avenue	Bremerton	WA	95667	USA	0
59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:19:22	2005-11-30 19:19:22	1	max_id	1	Henry-Barros Engineering Company	\N	Manufacturing	Engineering	\N	\N	3183 Trasher Road	N. Vancouver	BC	18218	Canada	\N	\N	737-555-2195	\N	\N	\N	www.henry-barrosengineeringcompany.com	\N	\N	\N	\N	3183 Trasher Road	N. Vancouver	BC	18218	Canada	0
3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:19:22	2005-11-30 19:19:22	1	matt_id	1	Y & R Groome Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	6387 Scenic Avenue	Milwaukie	OR	17817	USA	\N	\N	634-555-2773	\N	\N	\N	www.yrgroomemachinery,inc.com	\N	\N	\N	\N	6387 Scenic Avenue	Milwaukie	OR	17817	USA	0
5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:19:22	2005-11-30 19:19:22	1	sarah_id	1	Groome-Hill Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	7883 Mitchell Canyon Court	Santa Monica	CA	55288	USA	\N	\N	137-555-8923	\N	\N	\N	www.groome-hillengineering,inc.com	\N	\N	\N	\N	7883 Mitchell Canyon Court	Santa Monica	CA	55288	USA	0
8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:19:22	2005-11-30 19:19:22	1	kristen_id	1	E & F Williams Machinery, Ltd	\N	Consulting	Machinery	\N	\N	3997 Via De Luna	Walla Walla	WA	70289	USA	\N	\N	718-555-4473	\N	\N	\N	www.efwilliamsmachinery,ltd.com	\N	\N	\N	\N	3997 Via De Luna	Walla Walla	WA	70289	USA	0
b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:19:22	2005-11-30 19:19:22	1	chris_id	1	Williams-Masters Transportation Holdings	\N	Distribution	Transportation	\N	\N	5747 Shirley Drive	Richmond	CA	24162	USA	\N	\N	483-555-3909	\N	\N	\N	www.williams-masterstransportationholdings.com	\N	\N	\N	\N	5747 Shirley Drive	Richmond	CA	24162	USA	0
df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:19:22	2005-11-30 19:19:22	1	will_id	1	N & O Brady, Jr. Electronics, Inc	\N	Supply	Electronics	\N	\N	2115 Pasado	Oakland	CA	55084	USA	\N	\N	426-555-1745	\N	\N	\N	www.nobrady,jrelectronics,inc.com	\N	\N	\N	\N	2115 Pasado	Oakland	CA	55084	USA	0
145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:19:23	2005-11-30 19:19:23	1	kristen_id	1	Brady, Jr.-Gray Machinery Group	\N	Distribution	Machinery	\N	\N	6774 Bonanza	Bellflower	CA	20209	USA	\N	\N	214-555-8809	\N	\N	\N	www.brady,jr-graymachinerygroup.com	\N	\N	\N	\N	6774 Bonanza	Bellflower	CA	20209	USA	0
47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:19:23	2005-11-30 19:19:23	1	beth_id	1	U & W Fielder Construction Corp	\N	Supply	Construction	\N	\N	3397 Rancho View Drive	Ballard	WA	90000	USA	\N	\N	179-555-5273	\N	\N	\N	www.uwfielderconstructioncorp.com	\N	\N	\N	\N	3397 Rancho View Drive	Ballard	WA	90000	USA	0
756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:19:23	2005-11-30 19:19:23	1	max_id	1	Fielder-Finnell Electronics Company	\N	Consulting	Electronics	\N	\N	8310 Ridge Circle	Everett	WA	75196	USA	\N	\N	103-555-4226	\N	\N	\N	www.fielder-finnellelectronicscompany.com	\N	\N	\N	\N	8310 Ridge Circle	Everett	WA	75196	USA	0
a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:19:23	2005-11-30 19:19:23	1	chris_id	1	M & K Schuetz Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	7842 Ygnacio Valley Road	Salem	OR	12150	USA	\N	\N	330-555-2976	\N	\N	\N	www.mkschuetztelecommunications,ltd.com	\N	\N	\N	\N	7842 Ygnacio Valley Road	Salem	OR	12150	USA	0
d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:19:23	2005-11-30 19:19:23	1	sarah_id	1	Schuetz-Runyon Machinery, Ltd	\N	Consulting	Machinery	\N	\N	5666 Hazelnut Lane	Concord	CA	62507	USA	\N	\N	403-555-1955	\N	\N	\N	www.schuetz-runyonmachinery,ltd.com	\N	\N	\N	\N	5666 Hazelnut Lane	Concord	CA	62507	USA	0
61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:19:24	2005-11-30 19:19:24	1	beth_id	1	L & E Potter Communications Partners	\N	Distribution	Communications	\N	\N	5452 Corte Gilberto	Concord	CA	64622	USA	\N	\N	653-555-8333	\N	\N	\N	www.lepottercommunicationspartners.com	\N	\N	\N	\N	5452 Corte Gilberto	Concord	CA	64622	USA	0
2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:19:24	2005-11-30 19:19:24	1	sally_id	1	Potter-Smith Construction Holdings	\N	Consulting	Construction	\N	\N	874 Olivera Road	La Jolla	CA	54848	USA	\N	\N	749-555-5940	\N	\N	\N	www.potter-smithconstructionholdings.com	\N	\N	\N	\N	874 Olivera Road	La Jolla	CA	54848	USA	0
5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:19:24	2005-11-30 19:19:24	1	kristen_id	1	W & N Brumagen Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	3570 Court Lane	Cliffside	BC	23125	Canada	\N	\N	122-555-1947	\N	\N	\N	www.wnbrumagentelecommunicationspartners.com	\N	\N	\N	\N	3570 Court Lane	Cliffside	BC	23125	Canada	0
860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:19:24	2005-11-30 19:19:24	1	sally_id	1	Brumagen-Hamilton Transportation Holdings	\N	Consulting	Transportation	\N	\N	1902 Santa Cruz	Burbank	CA	58058	USA	\N	\N	480-555-1840	\N	\N	\N	www.brumagen-hamiltontransportationholdings.com	\N	\N	\N	\N	1902 Santa Cruz	Burbank	CA	58058	USA	0
ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:19:24	2005-11-30 19:19:24	1	beth_id	1	V & A J Wilbert Transportation Corp	\N	Consulting	Transportation	\N	\N	4852 Chaparral Court	Spokane	WA	39243	USA	\N	\N	115-555-9133	\N	\N	\N	www.vajwilberttransportationcorp.com	\N	\N	\N	\N	4852 Chaparral Court	Spokane	WA	39243	USA	0
d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:19:24	2005-11-30 19:19:24	1	max_id	1	J Wilbert-Ingram Communications Corp	\N	Consulting	Communications	\N	\N	6093 Midway Ct.	Tixapan	DF	60792	Mexico	\N	\N	257-555-3997	\N	\N	\N	www.jwilbert-ingramcommunicationscorp.com	\N	\N	\N	\N	6093 Midway Ct.	Tixapan	DF	60792	Mexico	0
683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:19:25	2005-11-30 19:19:25	1	sally_id	1	T & A Haddix Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	9297 Kenston Dr.	Lynnwood	WA	60392	USA	\N	\N	153-555-4576	\N	\N	\N	www.tahaddixelectronics,inc.com	\N	\N	\N	\N	9297 Kenston Dr.	Lynnwood	WA	60392	USA	0
2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:19:25	2005-11-30 19:19:25	1	matt_id	1	Haddix-Thomas Construction Associates	\N	Manufacturing	Construction	\N	\N	793 Crawford Street	Newport Beach	CA	48103	USA	\N	\N	557-555-1726	\N	\N	\N	www.haddix-thomasconstructionassociates.com	\N	\N	\N	\N	793 Crawford Street	Newport Beach	CA	48103	USA	0
589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:19:25	2005-11-30 19:19:25	1	chris_id	1	D & D Wilson Electronics Holdings	\N	Supply	Electronics	\N	\N	4251 San Onofre Court	Oak Bay	BC	13864	Canada	\N	\N	238-555-6276	\N	\N	\N	www.ddwilsonelectronicsholdings.com	\N	\N	\N	\N	4251 San Onofre Court	Oak Bay	BC	13864	Canada	0
7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:19:25	2005-11-30 19:19:25	1	sarah_id	1	Wilson-Stovall Machinery, Inc	\N	Distribution	Machinery	\N	\N	8656 Lakespring Place	Coronado	CA	66736	USA	\N	\N	593-555-6287	\N	\N	\N	www.wilson-stovallmachinery,inc.com	\N	\N	\N	\N	8656 Lakespring Place	Coronado	CA	66736	USA	0
a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:19:25	2005-11-30 19:19:25	1	sally_id	1	I & V Russell Engineering, Inc	\N	Distribution	Engineering	\N	\N	5025 Holiday Hills	La Mesa	CA	71367	USA	\N	\N	536-555-4122	\N	\N	\N	www.ivrussellengineering,inc.com	\N	\N	\N	\N	5025 Holiday Hills	La Mesa	CA	71367	USA	0
d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:19:25	2005-11-30 19:19:25	1	beth_id	1	Russell-Doose Construction, Ltd	\N	Manufacturing	Construction	\N	\N	7028 San Gabriel Dr.	Santa Anita	DF	90401	Mexico	\N	\N	324-555-2187	\N	\N	\N	www.russell-dooseconstruction,ltd.com	\N	\N	\N	\N	7028 San Gabriel Dr.	Santa Anita	DF	90401	Mexico	0
99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:19:26	2005-11-30 19:19:26	1	matt_id	1	K & R Morreale Communications Group	\N	Consulting	Communications	\N	\N	6307 Grenadine Way	Renton	WA	84255	USA	\N	\N	289-555-7651	\N	\N	\N	www.krmorrealecommunicationsgroup.com	\N	\N	\N	\N	6307 Grenadine Way	Renton	WA	84255	USA	0
3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:19:26	2005-11-30 19:19:26	1	jaime_id	1	Morreale-Rupert Engineering Associates	\N	Distribution	Engineering	\N	\N	1220 Bradford Way	Glendale	CA	69451	USA	\N	\N	101-555-4344	\N	\N	\N	www.morreale-rupertengineeringassociates.com	\N	\N	\N	\N	1220 Bradford Way	Glendale	CA	69451	USA	0
6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:19:26	2005-11-30 19:19:26	1	max_id	1	B & P Pierson Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	1999 Orangewood Court	Westminster	BC	32697	Canada	\N	\N	328-555-3094	\N	\N	\N	www.bppiersontelecommunicationsholdings.com	\N	\N	\N	\N	1999 Orangewood Court	Westminster	BC	32697	Canada	0
9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:19:26	2005-11-30 19:19:26	1	kristen_id	1	Pierson-Nickels Electronics, Ltd	\N	Distribution	Electronics	\N	\N	9821 Juniper Drive	Victoria	BC	56762	Canada	\N	\N	401-555-2072	\N	\N	\N	www.pierson-nickelselectronics,ltd.com	\N	\N	\N	\N	9821 Juniper Drive	Victoria	BC	56762	Canada	0
cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:19:26	2005-11-30 19:19:26	1	chris_id	1	Q & P Neuhauser Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	9608 Grammercy Lane	Victoria	BC	58876	Canada	\N	\N	651-555-8451	\N	\N	\N	www.qpneuhausertelecommunicationscompany.com	\N	\N	\N	\N	9608 Grammercy Lane	Victoria	BC	58876	Canada	0
1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:19:27	2005-11-30 19:19:27	1	beth_id	1	Neuhauser-Coke Transportation Holdings	\N	Consulting	Transportation	\N	\N	7685 Imperial Dr	Sooke	BC	75395	Canada	\N	\N	747-555-6058	\N	\N	\N	www.neuhauser-coketransportationholdings.com	\N	\N	\N	\N	7685 Imperial Dr	Sooke	BC	75395	Canada	0
42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:19:27	2005-11-30 19:19:27	1	kristen_id	1	G & N Scarbrough Communications Group	\N	Supply	Communications	\N	\N	7726 Driftwood Drive	Kirkland	WA	43672	USA	\N	\N	120-555-2065	\N	\N	\N	www.gnscarbroughcommunicationsgroup.com	\N	\N	\N	\N	7726 Driftwood Drive	Kirkland	WA	43672	USA	0
6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:19:27	2005-11-30 19:19:27	1	kristen_id	1	Scarbrough-Martensen Construction Partners	\N	Distribution	Construction	\N	\N	8713 Yosemite Ct.	Chula Vista	CA	26352	USA	\N	\N	478-555-1958	\N	\N	\N	www.scarbrough-martensenconstructionpartners.com	\N	\N	\N	\N	8713 Yosemite Ct.	Chula Vista	CA	26352	USA	0
a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:19:27	2005-11-30 19:19:27	1	kristen_id	1	H & Y McCormick Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	9008 Creekside Drive	Seattle	WA	33498	USA	\N	\N	113-555-9251	\N	\N	\N	www.hymccormickelectronics,ltd.com	\N	\N	\N	\N	9008 Creekside Drive	Seattle	WA	33498	USA	0
c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:19:27	2005-11-30 19:19:27	1	chris_id	1	McCormick-Sparacino Transportation Holdings	\N	Supply	Transportation	\N	\N	250 Geary Ct.	San Jose	CA	81339	USA	\N	\N	606-555-1032	\N	\N	\N	www.mccormick-sparacinotransportationholdings.com	\N	\N	\N	\N	250 Geary Ct.	San Jose	CA	81339	USA	0
f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:19:27	2005-11-30 19:19:27	1	sarah_id	1	O & K Racette Transportation Corp	\N	Manufacturing	Transportation	\N	\N	3454 D Bel Air Drive	Ballard	WA	54647	USA	\N	\N	263-555-6954	\N	\N	\N	www.okracettetransportationcorp.com	\N	\N	\N	\N	3454 D Bel Air Drive	Ballard	WA	54647	USA	0
28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:19:28	2005-11-30 19:19:28	1	beth_id	1	Racette-Thompson Construction Partners	\N	Consulting	Construction	\N	\N	4949 Dutch Slough Rd	Guadalajara	Jalisco	68650	Mexico	\N	\N	667-555-4104	\N	\N	\N	www.racette-thompsonconstructionpartners.com	\N	\N	\N	\N	4949 Dutch Slough Rd	Guadalajara	Jalisco	68650	Mexico	0
51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:19:28	2005-11-30 19:19:28	1	sally_id	1	D & D Warren Transportation, Ltd	\N	Distribution	Transportation	\N	\N	1064 Slavio	Lebanon	OR	81192	USA	\N	\N	587-555-3311	\N	\N	\N	www.ddwarrentransportation,ltd.com	\N	\N	\N	\N	1064 Slavio	Lebanon	OR	81192	USA	0
827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:19:28	2005-11-30 19:19:28	1	kristen_id	1	Warren-Chow-Wang Machinery, Inc	\N	Consulting	Machinery	\N	\N	2813 Dew Drop Circle	Port Hammond	BC	60991	Canada	\N	\N	113-555-8089	\N	\N	\N	www.warren-chow-wangmachinery,inc.com	\N	\N	\N	\N	2813 Dew Drop Circle	Port Hammond	BC	60991	Canada	0
ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:19:28	2005-11-30 19:19:28	1	beth_id	1	E & M Wood Electronics Company	\N	Supply	Electronics	\N	\N	9181 La Vista Circle	Sooke	BC	91914	Canada	\N	\N	956-555-5925	\N	\N	\N	www.emwoodelectronicscompany.com	\N	\N	\N	\N	9181 La Vista Circle	Sooke	BC	91914	Canada	0
d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:19:28	2005-11-30 19:19:28	1	matt_id	1	Wood-Morgan Engineering, Ltd	\N	Distribution	Engineering	\N	\N	3841 Silver Oaks Place	La Mesa	CA	11949	USA	\N	\N	744-555-3989	\N	\N	\N	www.wood-morganengineering,ltd.com	\N	\N	\N	\N	3841 Silver Oaks Place	La Mesa	CA	11949	USA	0
16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:19:29	2005-11-30 19:19:29	1	matt_id	1	R & Z Boje Communications, Inc	\N	Distribution	Communications	\N	\N	463 H Stagecoach Rd.	Tacoma	WA	81740	USA	\N	\N	709-555-9453	\N	\N	\N	www.rzbojecommunications,inc.com	\N	\N	\N	\N	463 H Stagecoach Rd.	Tacoma	WA	81740	USA	0
4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:19:29	2005-11-30 19:19:29	1	chris_id	1	Boje-Tsujimoto Machinery Partners	\N	Supply	Machinery	\N	\N	5376 Catanzaro Way	Milwaukie	OR	12447	USA	\N	\N	760-555-9804	\N	\N	\N	www.boje-tsujimotomachinerypartners.com	\N	\N	\N	\N	5376 Catanzaro Way	Milwaukie	OR	12447	USA	0
709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:19:29	2005-11-30 19:19:29	1	sarah_id	1	J & K Bouton Communications Corp	\N	Supply	Communications	\N	\N	4909 Poco Lane	Renton	WA	48400	USA	\N	\N	748-555-4896	\N	\N	\N	www.jkboutoncommunicationscorp.com	\N	\N	\N	\N	4909 Poco Lane	Renton	WA	48400	USA	0
9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:19:29	2005-11-30 19:19:29	1	sally_id	1	Bouton-Gras Construction, Ltd	\N	Supply	Construction	\N	\N	77 Birchwood	Grossmont	CA	98756	USA	\N	\N	821-555-3875	\N	\N	\N	www.bouton-grasconstruction,ltd.com	\N	\N	\N	\N	77 Birchwood	Grossmont	CA	98756	USA	0
c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:19:29	2005-11-30 19:19:29	1	max_id	1	W & W Solano Electronics Associates	\N	Supply	Electronics	\N	\N	9862 Ahneita Dr.	Ladner	BC	18729	Canada	\N	\N	171-555-1254	\N	\N	\N	www.wwsolanoelectronicsassociates.com	\N	\N	\N	\N	9862 Ahneita Dr.	Ladner	BC	18729	Canada	0
cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:19:30	2005-11-30 19:19:30	1	max_id	1	Solano-Armstrong Machinery Group	\N	Manufacturing	Machinery	\N	\N	7939 Bayview Court	Los Angeles	CA	18391	USA	\N	\N	267-555-7861	\N	\N	\N	www.solano-armstrongmachinerygroup.com	\N	\N	\N	\N	7939 Bayview Court	Los Angeles	CA	18391	USA	0
322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:19:30	2005-11-30 19:19:30	1	beth_id	1	D & G Aldred Transportation, Inc	\N	Distribution	Transportation	\N	\N	636 Vine Hill Way	Coronado	CA	85666	USA	\N	\N	466-555-8179	\N	\N	\N	www.dgaldredtransportation,inc.com	\N	\N	\N	\N	636 Vine Hill Way	Coronado	CA	85666	USA	0
6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:19:30	2005-11-30 19:19:30	1	matt_id	1	Aldred-Jorgenson Engineering, Ltd	\N	Supply	Engineering	\N	\N	8967 Hamilton Ave.	Milwaukie	OR	42055	USA	\N	\N	585-555-4415	\N	\N	\N	www.aldred-jorgensonengineering,ltd.com	\N	\N	\N	\N	8967 Hamilton Ave.	Milwaukie	OR	42055	USA	0
85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:19:30	2005-11-30 19:19:30	1	jaime_id	1	Z & L Turner Construction, Ltd	\N	Supply	Construction	\N	\N	1918 Terra Granada	Oak Bay	BC	75493	Canada	\N	\N	220-555-2708	\N	\N	\N	www.zlturnerconstruction,ltd.com	\N	\N	\N	\N	1918 Terra Granada	Oak Bay	BC	75493	Canada	0
b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:19:30	2005-11-30 19:19:30	1	will_id	1	Turner-Zakerski Transportation Group	\N	Manufacturing	Transportation	\N	\N	504 O St.	Lemon Grove	CA	97042	USA	\N	\N	601-555-1229	\N	\N	\N	www.turner-zakerskitransportationgroup.com	\N	\N	\N	\N	504 O St.	Lemon Grove	CA	97042	USA	0
d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:19:30	2005-11-30 19:19:30	1	max_id	1	V & P Carlson Transportation Corp	\N	Consulting	Transportation	\N	\N	3708 Montana	Walla Walla	WA	96641	USA	\N	\N	259-555-7150	\N	\N	\N	www.vpcarlsontransportationcorp.com	\N	\N	\N	\N	3708 Montana	Walla Walla	WA	96641	USA	0
1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:19:31	2005-11-30 19:19:31	1	will_id	1	Carlson-Symons Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	5203 Virginia Lane	Lebanon	OR	84353	USA	\N	\N	662-555-4300	\N	\N	\N	www.carlson-symonstelecommunications,inc.com	\N	\N	\N	\N	5203 Virginia Lane	Lebanon	OR	84353	USA	0
54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:19:31	2005-11-30 19:19:31	1	matt_id	1	F & X Reynolds Communications Partners	\N	Consulting	Communications	\N	\N	1318 Lasalle Street	Los Angeles	CA	50114	USA	\N	\N	582-555-3508	\N	\N	\N	www.fxreynoldscommunicationspartners.com	\N	\N	\N	\N	1318 Lasalle Street	Los Angeles	CA	50114	USA	0
8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:19:31	2005-11-30 19:19:31	1	sally_id	1	Reynolds-Ibsen Communications Holdings	\N	Distribution	Communications	\N	\N	3067 Maya	Downey	CA	39870	USA	\N	\N	108-555-8286	\N	\N	\N	www.reynolds-ibsencommunicationsholdings.com	\N	\N	\N	\N	3067 Maya	Downey	CA	39870	USA	0
afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:19:31	2005-11-30 19:19:31	1	sarah_id	1	S & X Ciochon Engineering Partners	\N	Distribution	Engineering	\N	\N	9435 Breck Court	West Covina	CA	86178	USA	\N	\N	951-555-6122	\N	\N	\N	www.sxciochonengineeringpartners.com	\N	\N	\N	\N	9435 Breck Court	West Covina	CA	86178	USA	0
d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:19:31	2005-11-30 19:19:31	1	sarah_id	1	Ciochon-Berger Transportation, Inc	\N	Supply	Transportation	\N	\N	4095 Cooper Dr.	Bellingham	WA	27651	USA	\N	\N	739-555-4186	\N	\N	\N	www.ciochon-bergertransportation,inc.com	\N	\N	\N	\N	4095 Cooper Dr.	Bellingham	WA	27651	USA	0
1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:19:32	2005-11-30 19:19:32	1	sarah_id	1	H & N Bayol Machinery Corp	\N	Supply	Machinery	\N	\N	5242 Marvelle Ln.	San Carlos	CA	24735	USA	\N	\N	704-555-9650	\N	\N	\N	www.hnbayolmachinerycorp.com	\N	\N	\N	\N	5242 Marvelle Ln.	San Carlos	CA	24735	USA	0
52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:19:32	2005-11-30 19:19:32	1	will_id	1	Bayol-Thumann Machinery Associates	\N	Supply	Machinery	\N	\N	2812 East Lake Court	Metchosin	BC	99312	Canada	\N	\N	755-555-1000	\N	\N	\N	www.bayol-thumannmachineryassociates.com	\N	\N	\N	\N	2812 East Lake Court	Metchosin	BC	99312	Canada	0
78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:19:32	2005-11-30 19:19:32	1	max_id	1	G & W Jones Transportation, Inc	\N	Distribution	Transportation	\N	\N	9687 Shakespeare Drive	Concord	CA	44269	USA	\N	\N	855-555-7353	\N	\N	\N	www.gwjonestransportation,inc.com	\N	\N	\N	\N	9687 Shakespeare Drive	Concord	CA	44269	USA	0
ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:19:32	2005-11-30 19:19:32	1	matt_id	1	Jones-Bury Machinery Corp	\N	Manufacturing	Machinery	\N	\N	7511 Cooper Dr.	Corvallis	OR	94626	USA	\N	\N	928-555-6332	\N	\N	\N	www.jones-burymachinerycorp.com	\N	\N	\N	\N	7511 Cooper Dr.	Corvallis	OR	94626	USA	0
db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:19:32	2005-11-30 19:19:32	1	beth_id	1	V & B Bevan Transportation Holdings	\N	Supply	Transportation	\N	\N	7297 Rosalinda	Woodburn	OR	96741	USA	\N	\N	278-555-3710	\N	\N	\N	www.vbbevantransportationholdings.com	\N	\N	\N	\N	7297 Rosalinda	Woodburn	OR	96741	USA	0
e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:19:33	2005-11-30 19:19:33	1	beth_id	1	Bevan-Monarco Construction Company	\N	Consulting	Construction	\N	\N	5375 Clearland Circle	Lakewood	CA	86967	USA	\N	\N	374-555-1317	\N	\N	\N	www.bevan-monarcoconstructioncompany.com	\N	\N	\N	\N	5375 Clearland Circle	Lakewood	CA	86967	USA	0
44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:19:33	2005-11-30 19:19:33	1	max_id	1	C & A Zingarelli Engineering Group	\N	Supply	Engineering	\N	\N	5415 San Gabriel Dr.	Seattle	WA	55244	USA	\N	\N	886-555-9982	\N	\N	\N	www.cazingarelliengineeringgroup.com	\N	\N	\N	\N	5415 San Gabriel Dr.	Seattle	WA	55244	USA	0
73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:19:33	2005-11-30 19:19:33	1	kristen_id	1	Zingarelli-Valentine Construction, Ltd	\N	Consulting	Construction	\N	\N	3747 Likins Avenue	Bremerton	WA	37925	USA	\N	\N	105-555-6217	\N	\N	\N	www.zingarelli-valentineconstruction,ltd.com	\N	\N	\N	\N	3747 Likins Avenue	Bremerton	WA	37925	USA	0
a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:19:33	2005-11-30 19:19:33	1	chris_id	1	U & S Scheulen Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	6697 Ridge Park Drive	Everett	WA	71362	USA	\N	\N	640-555-4510	\N	\N	\N	www.usscheulentransportation,inc.com	\N	\N	\N	\N	6697 Ridge Park Drive	Everett	WA	71362	USA	0
d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:19:33	2005-11-30 19:19:33	1	will_id	1	Scheulen-Koon Construction Group	\N	Distribution	Construction	\N	\N	7938 Blue Ridge	Langford	BC	92912	Canada	\N	\N	121-555-3032	\N	\N	\N	www.scheulen-koonconstructiongroup.com	\N	\N	\N	\N	7938 Blue Ridge	Langford	BC	92912	Canada	0
7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:19:34	2005-11-30 19:19:34	1	sarah_id	1	N & W Amole Transportation Corp	\N	Distribution	Transportation	\N	\N	1143 Julpum Loop	Oak Bay	BC	92511	Canada	\N	\N	678-555-8953	\N	\N	\N	www.nwamoletransportationcorp.com	\N	\N	\N	\N	1143 Julpum Loop	Oak Bay	BC	92511	Canada	0
356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:19:34	2005-11-30 19:19:34	1	matt_id	1	Amole-Hill Engineering Partners	\N	Supply	Engineering	\N	\N	2639 Anchor Court	Edmonds	WA	80222	USA	\N	\N	182-555-6103	\N	\N	\N	www.amole-hillengineeringpartners.com	\N	\N	\N	\N	2639 Anchor Court	Edmonds	WA	80222	USA	0
5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:19:34	2005-11-30 19:19:34	1	sarah_id	1	O & D Tate Communications Associates	\N	Distribution	Communications	\N	\N	6097 Mt. McKinley Ct.	Imperial Beach	CA	19692	USA	\N	\N	102-555-5310	\N	\N	\N	www.odtatecommunicationsassociates.com	\N	\N	\N	\N	6097 Mt. McKinley Ct.	Imperial Beach	CA	19692	USA	0
82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:19:34	2005-11-30 19:19:34	1	sally_id	1	Tate-Schnurr Transportation Company	\N	Consulting	Transportation	\N	\N	502 Alexander Pl.	Woodburn	OR	98856	USA	\N	\N	528-555-1089	\N	\N	\N	www.tate-schnurrtransportationcompany.com	\N	\N	\N	\N	502 Alexander Pl.	Woodburn	OR	98856	USA	0
c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:19:34	2005-11-30 19:19:34	1	sally_id	1	M & Y Sutton Communications, Ltd	\N	Supply	Communications	\N	\N	6870 D Bel Air Drive	Albany	OR	44872	USA	\N	\N	836-555-3980	\N	\N	\N	www.mysuttoncommunications,ltd.com	\N	\N	\N	\N	6870 D Bel Air Drive	Albany	OR	44872	USA	0
137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:19:35	2005-11-30 19:19:35	1	beth_id	1	Sutton-Mlincek Communications Associates	\N	Consulting	Communications	\N	\N	8874 Folson Drive	Metchosin	BC	23521	Canada	\N	\N	625-555-2044	\N	\N	\N	www.sutton-mlincekcommunicationsassociates.com	\N	\N	\N	\N	8874 Folson Drive	Metchosin	BC	23521	Canada	0
548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:19:35	2005-11-30 19:19:35	1	max_id	1	B & D Tucker Machinery Partners	\N	Consulting	Machinery	\N	\N	8152 Claudia Dr.	Corvallis	OR	93312	USA	\N	\N	829-555-2166	\N	\N	\N	www.bdtuckermachinerypartners.com	\N	\N	\N	\N	8152 Claudia Dr.	Corvallis	OR	93312	USA	0
7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:19:35	2005-11-30 19:19:35	1	sarah_id	1	Tucker-Forham Construction Partners	\N	Manufacturing	Construction	\N	\N	3066 Wallace Dr.	Arcadia	CA	78508	USA	\N	\N	641-555-7858	\N	\N	\N	www.tucker-forhamconstructionpartners.com	\N	\N	\N	\N	3066 Wallace Dr.	Arcadia	CA	78508	USA	0
a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:19:35	2005-11-30 19:19:35	1	kristen_id	1	H & E Malik Machinery Group	\N	Supply	Machinery	\N	\N	2598 La Vista Circle	Spokane	WA	15462	USA	\N	\N	868-555-6608	\N	\N	\N	www.hemalikmachinerygroup.com	\N	\N	\N	\N	2598 La Vista Circle	Spokane	WA	15462	USA	0
cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:19:35	2005-11-30 19:19:35	1	beth_id	1	Malik-Eldridge Electronics Holdings	\N	Supply	Electronics	\N	\N	7765 Sunsine Drive	Los Angeles	CA	11910	USA	\N	\N	702-555-1930	\N	\N	\N	www.malik-eldridgeelectronicsholdings.com	\N	\N	\N	\N	7765 Sunsine Drive	Los Angeles	CA	11910	USA	0
ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:19:36	2005-11-30 19:19:36	1	max_id	1	X & M Anderson Construction Corp	\N	Manufacturing	Construction	\N	\N	7551 Santa Lucia	Mexico City	Mexico	14025	Mexico	\N	\N	952-555-8308	\N	\N	\N	www.xmandersonconstructioncorp.com	\N	\N	\N	\N	7551 Santa Lucia	Mexico City	Mexico	14025	Mexico	0
48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:19:36	2005-11-30 19:19:36	1	sally_id	1	Anderson-Sosa Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	5629 San Francisco	N. Vancouver	BC	30543	Canada	\N	\N	148-555-5915	\N	\N	\N	www.anderson-sosatelecommunications,ltd.com	\N	\N	\N	\N	5629 San Francisco	N. Vancouver	BC	30543	Canada	0
6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:19:36	2005-11-30 19:19:36	1	chris_id	1	I & M Mann Transportation, Ltd	\N	Supply	Transportation	\N	\N	5669 Ironwood Way	Daly City	CA	97819	USA	\N	\N	660-555-5580	\N	\N	\N	www.immanntransportation,ltd.com	\N	\N	\N	\N	5669 Ironwood Way	Daly City	CA	97819	USA	0
9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:19:36	2005-11-30 19:19:36	1	will_id	1	Mann-Prater Electronics Corp	\N	Manufacturing	Electronics	\N	\N	6657 Camino Solano	National City	CA	54207	USA	\N	\N	779-555-1815	\N	\N	\N	www.mann-praterelectronicscorp.com	\N	\N	\N	\N	6657 Camino Solano	National City	CA	54207	USA	0
bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:19:36	2005-11-30 19:19:36	1	kristen_id	1	H & Y Ansaldo Engineering, Inc	\N	Distribution	Engineering	\N	\N	6951 Harmony Way	Imperial Beach	CA	87645	USA	\N	\N	413-555-9108	\N	\N	\N	www.hyansaldoengineering,inc.com	\N	\N	\N	\N	6951 Harmony Way	Imperial Beach	CA	87645	USA	0
e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:19:36	2005-11-30 19:19:36	1	jaime_id	1	Ansaldo-Caijem Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	8192 Seagull Court	Richmond	CA	36487	USA	\N	\N	794-555-7630	\N	\N	\N	www.ansaldo-caijemtelecommunications,ltd.com	\N	\N	\N	\N	8192 Seagull Court	Richmond	CA	36487	USA	0
12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:19:37	2005-11-30 19:19:37	1	sally_id	1	D & A Yates Machinery Group	\N	Manufacturing	Machinery	\N	\N	1397 Paraiso Ct.	Los Angeles	CA	97953	USA	\N	\N	564-555-6811	\N	\N	\N	www.dayatesmachinerygroup.com	\N	\N	\N	\N	1397 Paraiso Ct.	Los Angeles	CA	97953	USA	0
38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:19:37	2005-11-30 19:19:37	1	max_id	1	Yates-Turner Construction Associates	\N	Consulting	Construction	\N	\N	2893 Vera	Santa Fe	DF	23798	Mexico	\N	\N	968-555-3961	\N	\N	\N	www.yates-turnerconstructionassociates.com	\N	\N	\N	\N	2893 Vera	Santa Fe	DF	23798	Mexico	0
60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:19:37	2005-11-30 19:19:37	1	max_id	1	D & Z Fulcher Electronics, Ltd	\N	Consulting	Electronics	\N	\N	9006 Woodside Way	Santa Cruz	CA	62266	USA	\N	\N	887-555-3168	\N	\N	\N	www.dzfulcherelectronics,ltd.com	\N	\N	\N	\N	9006 Woodside Way	Santa Cruz	CA	62266	USA	0
86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:19:37	2005-11-30 19:19:37	1	kristen_id	1	Fulcher-Berg Engineering Corp	\N	Consulting	Engineering	\N	\N	757 Pine Creek Way	Newton	BC	16139	Canada	\N	\N	414-555-7947	\N	\N	\N	www.fulcher-bergengineeringcorp.com	\N	\N	\N	\N	757 Pine Creek Way	Newton	BC	16139	Canada	0
ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:19:37	2005-11-30 19:19:37	1	will_id	1	Q & Q Lopez Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	8370 Acardia Pl.	N. Vancouver	BC	47062	Canada	\N	\N	356-555-5782	\N	\N	\N	www.qqlopeztelecommunicationsassociates.com	\N	\N	\N	\N	8370 Acardia Pl.	N. Vancouver	BC	47062	Canada	0
d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:19:37	2005-11-30 19:19:37	1	max_id	1	Lopez-Valdivia Engineering Company	\N	Manufacturing	Engineering	\N	\N	3030 Blackburn Ct.	San Diego	CA	66096	USA	\N	\N	145-555-3847	\N	\N	\N	www.lopez-valdiviaengineeringcompany.com	\N	\N	\N	\N	3030 Blackburn Ct.	San Diego	CA	66096	USA	0
6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:19:38	2005-11-30 19:19:38	1	matt_id	1	Y & R Cardoza Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	9652 Los Angeles	Sedro Woolley	WA	36888	USA	\N	\N	349-555-3968	\N	\N	\N	www.yrcardozamachinery,inc.com	\N	\N	\N	\N	9652 Los Angeles	Sedro Woolley	WA	36888	USA	0
30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:19:38	2005-11-30 19:19:38	1	sarah_id	1	Cardoza-Hall Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	4566 La Jolla	La Jolla	CA	22084	USA	\N	\N	160-555-9661	\N	\N	\N	www.cardoza-hallengineering,inc.com	\N	\N	\N	\N	4566 La Jolla	La Jolla	CA	22084	USA	0
57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:19:38	2005-11-30 19:19:38	1	kristen_id	1	E & F Minarick Machinery, Ltd	\N	Consulting	Machinery	\N	\N	4098 Woodcrest Dr.	Woodburn	OR	58037	USA	\N	\N	387-555-8411	\N	\N	\N	www.efminarickmachinery,ltd.com	\N	\N	\N	\N	4098 Woodcrest Dr.	Woodburn	OR	58037	USA	0
7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:19:38	2005-11-30 19:19:38	1	chris_id	1	Minarick-Los Olmos Transportation Holdings	\N	Distribution	Transportation	\N	\N	9265 La Paz	Imperial Beach	CA	93945	USA	\N	\N	222-555-3732	\N	\N	\N	www.minarick-losolmostransportationholdings.com	\N	\N	\N	\N	9265 La Paz	Imperial Beach	CA	93945	USA	0
a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:19:38	2005-11-30 19:19:38	1	will_id	1	N & O Garner Electronics, Inc	\N	Supply	Electronics	\N	\N	9052 Montgomery Avenue	Burnaby	BC	84216	Canada	\N	\N	472-555-1111	\N	\N	\N	www.nogarnerelectronics,inc.com	\N	\N	\N	\N	9052 Montgomery Avenue	Burnaby	BC	84216	Canada	0
cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:19:38	2005-11-30 19:19:38	1	kristen_id	1	Garner-Leong Machinery Group	\N	Distribution	Machinery	\N	\N	7129 Oakmead	Santa Anita	DF	17364	Mexico	\N	\N	807-555-2375	\N	\N	\N	www.garner-leongmachinerygroup.com	\N	\N	\N	\N	7129 Oakmead	Santa Anita	DF	17364	Mexico	0
f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:19:39	2005-11-30 19:19:39	1	beth_id	1	U & W Tate Construction Corp	\N	Supply	Construction	\N	\N	9825 Coralie Drive	Novato	CA	42719	USA	\N	\N	770-555-7957	\N	\N	\N	www.uwtateconstructioncorp.com	\N	\N	\N	\N	9825 Coralie Drive	Novato	CA	42719	USA	0
27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:19:39	2005-11-30 19:19:39	1	max_id	1	Tate-Watson Electronics Company	\N	Consulting	Electronics	\N	\N	8157 W. Buchanan	Woodland Hills	CA	25400	USA	\N	\N	889-555-4193	\N	\N	\N	www.tate-watsonelectronicscompany.com	\N	\N	\N	\N	8157 W. Buchanan	Woodland Hills	CA	25400	USA	0
4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:19:39	2005-11-30 19:19:39	1	chris_id	1	M & K Frank Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	1108 Catcus Court	Ladner	BC	58838	Canada	\N	\N	523-555-2486	\N	\N	\N	www.mkfranktelecommunications,ltd.com	\N	\N	\N	\N	1108 Catcus Court	Ladner	BC	58838	Canada	0
778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:19:39	2005-11-30 19:19:39	1	sarah_id	1	Frank-Wood Machinery, Ltd	\N	Consulting	Machinery	\N	\N	9693 Mellowood Street	National City	CA	80387	USA	\N	\N	904-555-1007	\N	\N	\N	www.frank-woodmachinery,ltd.com	\N	\N	\N	\N	9693 Mellowood Street	National City	CA	80387	USA	0
9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:19:39	2005-11-30 19:19:39	1	beth_id	1	L & E Baird Communications Partners	\N	Distribution	Communications	\N	\N	5553 Kahrs Avenue	Olympia	WA	79986	USA	\N	\N	562-555-6929	\N	\N	\N	www.lebairdcommunicationspartners.com	\N	\N	\N	\N	5553 Kahrs Avenue	Olympia	WA	79986	USA	0
c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:19:39	2005-11-30 19:19:39	1	sally_id	1	Baird-Jans Construction Holdings	\N	Consulting	Construction	\N	\N	7048 Laurel	Woodburn	OR	67698	USA	\N	\N	966-555-4079	\N	\N	\N	www.baird-jansconstructionholdings.com	\N	\N	\N	\N	7048 Laurel	Woodburn	OR	67698	USA	0
ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:19:39	2005-11-30 19:19:39	1	kristen_id	1	W & N Garrison Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	507 Sahara Drive	Santa Anita	DF	33459	Mexico	\N	\N	885-555-3286	\N	\N	\N	www.wngarrisontelecommunicationspartners.com	\N	\N	\N	\N	507 Sahara Drive	Santa Anita	DF	33459	Mexico	0
1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:19:40	2005-11-30 19:19:40	1	sally_id	1	Garrison-Zeller Transportation Holdings	\N	Consulting	Transportation	\N	\N	4912 La Vuelta	Bellflower	CA	86331	USA	\N	\N	651-555-2722	\N	\N	\N	www.garrison-zellertransportationholdings.com	\N	\N	\N	\N	4912 La Vuelta	Bellflower	CA	86331	USA	0
46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:19:40	2005-11-30 19:19:40	1	beth_id	1	V & A Ace Transportation Corp	\N	Consulting	Transportation	\N	\N	8624 Pepperidge Way	Torrance	CA	90961	USA	\N	\N	593-555-9557	\N	\N	\N	www.vaacetransportationcorp.com	\N	\N	\N	\N	8624 Pepperidge Way	Torrance	CA	90961	USA	0
71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:19:40	2005-11-30 19:19:40	1	max_id	1	Ace-Trujillo Communications Corp	\N	Consulting	Communications	\N	\N	3284 S. Bascom Avenue	Lynnwood	WA	10996	USA	\N	\N	143-555-3964	\N	\N	\N	www.ace-trujillocommunicationscorp.com	\N	\N	\N	\N	3284 S. Bascom Avenue	Lynnwood	WA	10996	USA	0
98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:19:40	2005-11-30 19:19:40	1	sally_id	1	T & A McCown Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	9906 Oak Grove Road	Lemon Grove	CA	80803	USA	\N	\N	347-555-4086	\N	\N	\N	www.tamccownelectronics,inc.com	\N	\N	\N	\N	9906 Oak Grove Road	Lemon Grove	CA	80803	USA	0
c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:19:40	2005-11-30 19:19:40	1	matt_id	1	McCown-Miller Construction Associates	\N	Manufacturing	Construction	\N	\N	7476 Halfmoon Court	Sooke	BC	92275	Canada	\N	\N	158-555-9779	\N	\N	\N	www.mccown-millerconstructionassociates.com	\N	\N	\N	\N	7476 Halfmoon Court	Sooke	BC	92275	Canada	0
e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:19:40	2005-11-30 19:19:40	1	chris_id	1	D & D Hollar Electronics Holdings	\N	Supply	Electronics	\N	\N	4352 Olive Ave.	La Cruz	Sinaloa	29229	Mexico	\N	\N	385-555-8529	\N	\N	\N	www.ddhollarelectronicsholdings.com	\N	\N	\N	\N	4352 Olive Ave.	La Cruz	Sinaloa	29229	Mexico	0
1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:19:41	2005-11-30 19:19:41	1	sarah_id	1	Hollar-Wallin Machinery, Inc	\N	Distribution	Machinery	\N	\N	2176 Apollo Way	Beaverton	OR	79586	USA	\N	\N	334-555-6031	\N	\N	\N	www.hollar-wallinmachinery,inc.com	\N	\N	\N	\N	2176 Apollo Way	Beaverton	OR	79586	USA	0
4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:19:41	2005-11-30 19:19:41	1	sally_id	1	I & V Bruha Engineering, Inc	\N	Distribution	Engineering	\N	\N	1962 Cunha Ct.	W. Linn	OR	27502	USA	\N	\N	823-555-7067	\N	\N	\N	www.ivbruhaengineering,inc.com	\N	\N	\N	\N	1962 Cunha Ct.	W. Linn	OR	27502	USA	0
705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:19:41	2005-11-30 19:19:41	1	beth_id	1	Bruha-Suggs Construction, Ltd	\N	Manufacturing	Construction	\N	\N	40 Ellis St.	Burbank	CA	17728	USA	\N	\N	919-555-4674	\N	\N	\N	www.bruha-suggsconstruction,ltd.com	\N	\N	\N	\N	40 Ellis St.	Burbank	CA	17728	USA	0
96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:19:41	2005-11-30 19:19:41	1	matt_id	1	K & R Turner Communications Group	\N	Consulting	Communications	\N	\N	80 Sunview Terrace	El Cajon	CA	85004	USA	\N	\N	292-555-9681	\N	\N	\N	www.krturnercommunicationsgroup.com	\N	\N	\N	\N	80 Sunview Terrace	El Cajon	CA	85004	USA	0
bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:19:41	2005-11-30 19:19:41	1	jaime_id	1	Turner-Griffin Engineering Associates	\N	Distribution	Engineering	\N	\N	8411 Mt. Olivet Place	Renton	WA	67685	USA	\N	\N	650-555-9574	\N	\N	\N	www.turner-griffinengineeringassociates.com	\N	\N	\N	\N	8411 Mt. Olivet Place	Renton	WA	67685	USA	0
e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:19:41	2005-11-30 19:19:41	1	max_id	1	B & P Guardamondo Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	1362 Somerset Place	Bellingham	WA	74830	USA	\N	\N	946-555-4209	\N	\N	\N	www.bpguardamondotelecommunicationsholdings.com	\N	\N	\N	\N	1362 Somerset Place	Bellingham	WA	74830	USA	0
2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:19:42	2005-11-30 19:19:42	1	kristen_id	1	Guardamondo-West Electronics, Ltd	\N	Distribution	Electronics	\N	\N	2603 Condor Place	Oak Bay	BC	23672	Canada	\N	\N	427-555-2731	\N	\N	\N	www.guardamondo-westelectronics,ltd.com	\N	\N	\N	\N	2603 Condor Place	Oak Bay	BC	23672	Canada	0
46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:19:42	2005-11-30 19:19:42	1	chris_id	1	Q & P Welsh Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	P.O. Box 1742	Ladner	BC	23272	Canada	\N	\N	984-555-8652	\N	\N	\N	www.qpwelshtelecommunicationscompany.com	\N	\N	\N	\N	P.O. Box 1742	Ladner	BC	23272	Canada	0
70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:19:42	2005-11-30 19:19:42	1	beth_id	1	Welsh-McCollum Transportation Holdings	\N	Consulting	Transportation	\N	\N	3238 Laguna Circle	Sedro Woolley	WA	10983	USA	\N	\N	727-555-9460	\N	\N	\N	www.welsh-mccollumtransportationholdings.com	\N	\N	\N	\N	3238 Laguna Circle	Sedro Woolley	WA	10983	USA	0
970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:19:42	2005-11-30 19:19:42	1	kristen_id	1	G & N Cramer Communications Group	\N	Supply	Communications	\N	\N	6696 Adria Drive	La Mesa	CA	49452	USA	\N	\N	408-555-5009	\N	\N	\N	www.gncramercommunicationsgroup.com	\N	\N	\N	\N	6696 Adria Drive	La Mesa	CA	49452	USA	0
bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:19:42	2005-11-30 19:19:42	1	kristen_id	1	Cramer-Fike Construction Partners	\N	Distribution	Construction	\N	\N	1102 Ravenwood	W. Linn	OR	29617	USA	\N	\N	173-555-4445	\N	\N	\N	www.cramer-fikeconstructionpartners.com	\N	\N	\N	\N	1102 Ravenwood	W. Linn	OR	29617	USA	0
ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:19:42	2005-11-30 19:19:42	1	kristen_id	1	H & Y Adair Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	7469 Paraiso Ct.	Oregon City	OR	34247	USA	\N	\N	116-555-2281	\N	\N	\N	www.hyadairelectronics,ltd.com	\N	\N	\N	\N	7469 Paraiso Ct.	Oregon City	OR	34247	USA	0
1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:19:43	2005-11-30 19:19:43	1	chris_id	1	Adair-Kolosso Transportation Holdings	\N	Supply	Transportation	\N	\N	2129 Acacia Drive	Royal Oak	BC	53281	Canada	\N	\N	255-555-6263	\N	\N	\N	www.adair-kolossotransportationholdings.com	\N	\N	\N	\N	2129 Acacia Drive	Royal Oak	BC	53281	Canada	0
4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:19:43	2005-11-30 19:19:43	1	sarah_id	1	O & K Carpenter Transportation Corp	\N	Manufacturing	Transportation	\N	\N	8751 Norse Drive	Milwaukie	OR	24073	USA	\N	\N	220-555-2727	\N	\N	\N	www.okcarpentertransportationcorp.com	\N	\N	\N	\N	8751 Norse Drive	Milwaukie	OR	24073	USA	0
74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:19:43	2005-11-30 19:19:43	1	beth_id	1	Carpenter-Watkins Construction Partners	\N	Consulting	Construction	\N	\N	3665 Oak Creek Ct.	Concord	CA	92694	USA	\N	\N	932-555-8420	\N	\N	\N	www.carpenter-watkinsconstructionpartners.com	\N	\N	\N	\N	3665 Oak Creek Ct.	Concord	CA	92694	USA	0
9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:19:43	2005-11-30 19:19:43	1	sally_id	1	D & D Barrera Transportation, Ltd	\N	Distribution	Transportation	\N	\N	3197 Thornhill Place	Glendale	CA	45222	USA	\N	\N	259-555-7170	\N	\N	\N	www.ddbarreratransportation,ltd.com	\N	\N	\N	\N	3197 Thornhill Place	Glendale	CA	45222	USA	0
c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:19:43	2005-11-30 19:19:43	1	kristen_id	1	Barrera-Price Machinery, Inc	\N	Consulting	Machinery	\N	\N	8364 Encinal Place	San Andres	DF	95578	Mexico	\N	\N	332-555-6148	\N	\N	\N	www.barrera-pricemachinery,inc.com	\N	\N	\N	\N	8364 Encinal Place	San Andres	DF	95578	Mexico	0
ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:19:43	2005-11-30 19:19:43	1	beth_id	1	E & M Rosemont Electronics Company	\N	Supply	Electronics	\N	\N	8150 Las Trampas	San Andres	DF	97693	Mexico	\N	\N	582-555-3527	\N	\N	\N	www.emrosemontelectronicscompany.com	\N	\N	\N	\N	8150 Las Trampas	San Andres	DF	97693	Mexico	0
1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:19:44	2005-11-30 19:19:44	1	matt_id	1	Rosemont-McMenama Engineering, Ltd	\N	Distribution	Engineering	\N	\N	6228 Meadowbrook Dr.	Burnaby	BC	15628	Canada	\N	\N	678-555-1134	\N	\N	\N	www.rosemont-mcmenamaengineering,ltd.com	\N	\N	\N	\N	6228 Meadowbrook Dr.	Burnaby	BC	15628	Canada	0
4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:19:44	2005-11-30 19:19:44	1	matt_id	1	R & Z Lyons Communications, Inc	\N	Distribution	Communications	\N	\N	6268 Breck Court	Merida	Yucatan	82904	Mexico	\N	\N	951-555-6141	\N	\N	\N	www.rzlyonscommunications,inc.com	\N	\N	\N	\N	6268 Breck Court	Merida	Yucatan	82904	Mexico	0
7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:19:44	2005-11-30 19:19:44	1	chris_id	1	Lyons-Sandy Kurtz Machinery Partners	\N	Supply	Machinery	\N	\N	7256 St. Paul Circle	Vancouver	BC	39293	Canada	\N	\N	409-555-6034	\N	\N	\N	www.lyons-sandykurtzmachinerypartners.com	\N	\N	\N	\N	7256 St. Paul Circle	Vancouver	BC	39293	Canada	0
a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:19:44	2005-11-30 19:19:44	1	sarah_id	1	J & K Santry Communications Corp	\N	Supply	Communications	\N	\N	207 Barquentine Court	Lincoln Acres	CA	72730	USA	\N	\N	705-555-9670	\N	\N	\N	www.jksantrycommunicationscorp.com	\N	\N	\N	\N	207 Barquentine Court	Lincoln Acres	CA	72730	USA	0
c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:19:44	2005-11-30 19:19:44	1	sally_id	1	Santry-Quigle Construction, Ltd	\N	Supply	Construction	\N	\N	8791 La Cadena	Tlaxiaco	Oaxaca	94279	Mexico	\N	\N	186-555-8191	\N	\N	\N	www.santry-quigleconstruction,ltd.com	\N	\N	\N	\N	8791 La Cadena	Tlaxiaco	Oaxaca	94279	Mexico	0
f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:19:44	2005-11-30 19:19:44	1	max_id	1	W & W Christensen Electronics Associates	\N	Supply	Electronics	\N	\N	1996 Glenhaven Ave South	Tixapan	DF	93879	Mexico	\N	\N	982-555-8770	\N	\N	\N	www.wwchristensenelectronicsassociates.com	\N	\N	\N	\N	1996 Glenhaven Ave South	Tixapan	DF	93879	Mexico	0
2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:19:45	2005-11-30 19:19:45	1	max_id	1	Christensen-Mercurio Machinery Group	\N	Manufacturing	Machinery	\N	\N	3492 Broadway Street	Richmond	BC	81590	Canada	\N	\N	837-555-2837	\N	\N	\N	www.christensen-mercuriomachinerygroup.com	\N	\N	\N	\N	3492 Broadway Street	Richmond	BC	81590	Canada	0
50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:19:45	2005-11-30 19:19:45	1	beth_id	1	D & G McGrath Transportation, Inc	\N	Distribution	Transportation	\N	\N	9605 Pheasant Circle	Lake Oswego	OR	47352	USA	\N	\N	518-555-7387	\N	\N	\N	www.dgmcgrathtransportation,inc.com	\N	\N	\N	\N	9605 Pheasant Circle	Lake Oswego	OR	47352	USA	0
76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:19:45	2005-11-30 19:19:45	1	matt_id	1	McGrath-Wright Engineering, Ltd	\N	Supply	Engineering	\N	\N	1356 Grove Way	La Mesa	CA	12255	USA	\N	\N	283-555-6823	\N	\N	\N	www.mcgrath-wrightengineering,ltd.com	\N	\N	\N	\N	1356 Grove Way	La Mesa	CA	12255	USA	0
a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:19:45	2005-11-30 19:19:45	1	jaime_id	1	Z & L Skuce Construction, Ltd	\N	Supply	Construction	\N	\N	7723 Firestone Drive	Chula Vista	CA	32147	USA	\N	\N	226-555-4659	\N	\N	\N	www.zlskuceconstruction,ltd.com	\N	\N	\N	\N	7723 Firestone Drive	Chula Vista	CA	32147	USA	0
e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:19:45	2005-11-30 19:19:45	1	will_id	1	Skuce-Coleman Transportation Group	\N	Manufacturing	Transportation	\N	\N	2383 Pepper Drive	Daly City	CA	51181	USA	\N	\N	914-555-2723	\N	\N	\N	www.skuce-colemantransportationgroup.com	\N	\N	\N	\N	2383 Pepper Drive	Daly City	CA	51181	USA	0
1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:19:46	2005-11-30 19:19:46	1	max_id	1	V & P Barnes Transportation Corp	\N	Consulting	Transportation	\N	\N	9005 Eagle Ct.	Metchosin	BC	21973	Canada	\N	\N	879-555-8187	\N	\N	\N	www.vpbarnestransportationcorp.com	\N	\N	\N	\N	9005 Eagle Ct.	Metchosin	BC	21973	Canada	0
50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:19:46	2005-11-30 19:19:46	1	will_id	1	Barnes-Camille Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	3919 El Pintado Road	Torrance	CA	71696	USA	\N	\N	691-555-4880	\N	\N	\N	www.barnes-camilletelecommunications,inc.com	\N	\N	\N	\N	3919 El Pintado Road	Torrance	CA	71696	USA	0
8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:19:46	2005-11-30 19:19:46	1	matt_id	1	F & X Allenbach Communications Partners	\N	Consulting	Communications	\N	\N	3451 Meier Road	Haney	BC	43122	Canada	\N	\N	918-555-3630	\N	\N	\N	www.fxallenbachcommunicationspartners.com	\N	\N	\N	\N	3451 Meier Road	Haney	BC	43122	Canada	0
cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:19:46	2005-11-30 19:19:46	1	sally_id	1	Allenbach-Smith Communications Holdings	\N	Distribution	Communications	\N	\N	1275 West Street	National City	CA	93479	USA	\N	\N	991-555-2609	\N	\N	\N	www.allenbach-smithcommunicationsholdings.com	\N	\N	\N	\N	1275 West Street	National City	CA	93479	USA	0
14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:19:47	2005-11-30 19:19:47	1	sarah_id	1	S & X Minker Engineering Partners	\N	Distribution	Engineering	\N	\N	1061 Buskrik Avenue	Coronado	CA	95593	USA	\N	\N	341-555-8987	\N	\N	\N	www.sxminkerengineeringpartners.com	\N	\N	\N	\N	1061 Buskrik Avenue	Coronado	CA	95593	USA	0
45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:19:47	2005-11-30 19:19:47	1	sarah_id	1	Minker-Jimenez Transportation, Inc	\N	Supply	Transportation	\N	\N	6482 Colt Ct.	Cliffside	BC	11498	Canada	\N	\N	437-555-6594	\N	\N	\N	www.minker-jimeneztransportation,inc.com	\N	\N	\N	\N	6482 Colt Ct.	Cliffside	BC	11498	Canada	0
789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:19:47	2005-11-30 19:19:47	1	sarah_id	1	H & N Malaby Machinery Corp	\N	Supply	Machinery	\N	\N	9178 Sand Pointe Lane	W. Linn	OR	78774	USA	\N	\N	710-555-2601	\N	\N	\N	www.hnmalabymachinerycorp.com	\N	\N	\N	\N	9178 Sand Pointe Lane	W. Linn	OR	78774	USA	0
a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:19:47	2005-11-30 19:19:47	1	will_id	1	Malaby-Caldwell Machinery Associates	\N	Supply	Machinery	\N	\N	8756 Nottingham Pl.	Spring Valley	CA	61454	USA	\N	\N	168-555-2494	\N	\N	\N	www.malaby-caldwellmachineryassociates.com	\N	\N	\N	\N	8756 Nottingham Pl.	Spring Valley	CA	61454	USA	0
d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:19:47	2005-11-30 19:19:47	1	max_id	1	G & W Tinder Transportation, Inc	\N	Distribution	Transportation	\N	\N	1707 Summerfield Drive	Westminster	BC	94892	Canada	\N	\N	154-555-6705	\N	\N	\N	www.gwtindertransportation,inc.com	\N	\N	\N	\N	1707 Summerfield Drive	Westminster	BC	94892	Canada	0
282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:19:48	2005-11-30 19:19:48	1	matt_id	1	Tinder-Kropff Machinery Corp	\N	Manufacturing	Machinery	\N	\N	2948 Dayton Court	Guadalajara	Jalisco	17442	Mexico	\N	\N	296-555-1569	\N	\N	\N	www.tinder-kropffmachinerycorp.com	\N	\N	\N	\N	2948 Dayton Court	Guadalajara	Jalisco	17442	Mexico	0
5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:19:48	2005-11-30 19:19:48	1	beth_id	1	V & B Worsham Transportation Holdings	\N	Supply	Transportation	\N	\N	6152 Buckingham Dr.	Sedro Woolley	WA	17042	USA	\N	\N	192-555-2147	\N	\N	\N	www.vbworshamtransportationholdings.com	\N	\N	\N	\N	6152 Buckingham Dr.	Sedro Woolley	WA	17042	USA	0
91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:19:48	2005-11-30 19:19:48	1	beth_id	1	Worsham-Bernal Construction Company	\N	Consulting	Construction	\N	\N	7647 Valencia Place	Lake Oswego	OR	4753	USA	\N	\N	596-555-8297	\N	\N	\N	www.worsham-bernalconstructioncompany.com	\N	\N	\N	\N	7647 Valencia Place	Lake Oswego	OR	4753	USA	0
c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:19:48	2005-11-30 19:19:48	1	max_id	1	C & A Zimmerman Engineering Group	\N	Supply	Engineering	\N	\N	1107 La Corte Bonita	Cliffside	BC	69514	Canada	\N	\N	276-555-3847	\N	\N	\N	www.cazimmermanengineeringgroup.com	\N	\N	\N	\N	1107 La Corte Bonita	Cliffside	BC	69514	Canada	0
f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:19:48	2005-11-30 19:19:48	1	kristen_id	1	Zimmerman-Evans Construction, Ltd	\N	Consulting	Construction	\N	\N	5511 Cape Cod Way	Altadena	CA	23387	USA	\N	\N	942-555-3283	\N	\N	\N	www.zimmerman-evansconstruction,ltd.com	\N	\N	\N	\N	5511 Cape Cod Way	Altadena	CA	23387	USA	0
3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:19:49	2005-11-30 19:19:49	1	chris_id	1	U & S Bowman Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	1880 Birchwood	San Gabriel	CA	28017	USA	\N	\N	884-555-1119	\N	\N	\N	www.usbowmantransportation,inc.com	\N	\N	\N	\N	1880 Birchwood	San Gabriel	CA	28017	USA	0
6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:19:49	2005-11-30 19:19:49	1	will_id	1	Bowman-Coleman Construction Group	\N	Distribution	Construction	\N	\N	3883 Kirkwood Dr	Novato	CA	47051	USA	\N	\N	673-555-8183	\N	\N	\N	www.bowman-colemanconstructiongroup.com	\N	\N	\N	\N	3883 Kirkwood Dr	Novato	CA	47051	USA	0
ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:19:49	2005-11-30 19:19:49	1	sarah_id	1	N & W Chrisulis Transportation Corp	\N	Distribution	Transportation	\N	\N	3162 Asilomaar Dr	San Diego	CA	17843	USA	\N	\N	638-555-4647	\N	\N	\N	www.nwchrisulistransportationcorp.com	\N	\N	\N	\N	3162 Asilomaar Dr	San Diego	CA	17843	USA	0
f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:19:49	2005-11-30 19:19:49	1	matt_id	1	Chrisulis-Whitcomb Engineering Partners	\N	Supply	Engineering	\N	\N	8075 Shangri-la Rd.	Ladner	BC	30396	Canada	\N	\N	449-555-1340	\N	\N	\N	www.chrisulis-whitcombengineeringpartners.com	\N	\N	\N	\N	8075 Shangri-la Rd.	Ladner	BC	30396	Canada	0
3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:19:50	2005-11-30 19:19:50	1	sarah_id	1	O & D Turcios Communications Associates	\N	Distribution	Communications	\N	\N	4951 G Street	Hidalgo	Zacatecas	65284	Mexico	\N	\N	676-555-9090	\N	\N	\N	www.odturcioscommunicationsassociates.com	\N	\N	\N	\N	4951 G Street	Hidalgo	Zacatecas	65284	Mexico	0
6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:19:50	2005-11-30 19:19:50	1	sally_id	1	Turcios-Confetti Transportation Company	\N	Consulting	Transportation	\N	\N	2775 Robinson Ave.	Long Beach	CA	89348	USA	\N	\N	750-555-8069	\N	\N	\N	www.turcios-confettitransportationcompany.com	\N	\N	\N	\N	2775 Robinson Ave.	Long Beach	CA	89348	USA	0
a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:19:50	2005-11-30 19:19:50	1	sally_id	1	M & Y Takemura Communications, Ltd	\N	Supply	Communications	\N	\N	2561 Palm St.	Albany	OR	91463	USA	\N	\N	290-555-7190	\N	\N	\N	www.mytakemuracommunications,ltd.com	\N	\N	\N	\N	2561 Palm St.	Albany	OR	91463	USA	0
dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:19:50	2005-11-30 19:19:50	1	beth_id	1	Takemura-Campbell Communications Associates	\N	Consulting	Communications	\N	\N	639 La Corte Bonita	Torrance	CA	89834	USA	\N	\N	386-555-4797	\N	\N	\N	www.takemura-campbellcommunicationsassociates.com	\N	\N	\N	\N	639 La Corte Bonita	Torrance	CA	89834	USA	0
2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:19:51	2005-11-30 19:19:51	1	max_id	1	B & D Smith Machinery Partners	\N	Consulting	Machinery	\N	\N	679 Minert Rd.	Ballard	WA	20735	USA	\N	\N	659-555-9804	\N	\N	\N	www.bdsmithmachinerypartners.com	\N	\N	\N	\N	679 Minert Rd.	Ballard	WA	20735	USA	0
54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:19:51	2005-11-30 19:19:51	1	sarah_id	1	Smith-Vuong Construction Partners	\N	Manufacturing	Construction	\N	\N	1666 Edward Avenue	Bellingham	WA	34155	USA	\N	\N	117-555-9697	\N	\N	\N	www.smith-vuongconstructionpartners.com	\N	\N	\N	\N	1666 Edward Avenue	Bellingham	WA	34155	USA	0
8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:19:51	2005-11-30 19:19:51	1	kristen_id	1	H & E Abbott Machinery Group	\N	Supply	Machinery	\N	\N	1961 Marfargoa Drive	Edmonds	WA	10561	USA	\N	\N	652-555-7990	\N	\N	\N	www.heabbottmachinerygroup.com	\N	\N	\N	\N	1961 Marfargoa Drive	Edmonds	WA	10561	USA	0
c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:19:51	2005-11-30 19:19:51	1	beth_id	1	Abbott-Liff Electronics Holdings	\N	Supply	Electronics	\N	\N	3202 Jalisco	Cliffside	BC	58402	Canada	\N	\N	133-555-6511	\N	\N	\N	www.abbott-liffelectronicsholdings.com	\N	\N	\N	\N	3202 Jalisco	Cliffside	BC	58402	Canada	0
f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:19:52	2005-11-30 19:19:52	1	max_id	1	X & M Steinberg Construction Corp	\N	Manufacturing	Construction	\N	\N	6406 Marlesta Rd.	Lebanon	OR	31710	USA	\N	\N	690-555-3433	\N	\N	\N	www.xmsteinbergconstructioncorp.com	\N	\N	\N	\N	6406 Marlesta Rd.	Lebanon	OR	31710	USA	0
51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:19:52	2005-11-30 19:19:52	1	sally_id	1	Steinberg-Megel Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	7901 Moccasin Ct.	Bellflower	CA	45713	USA	\N	\N	194-555-9583	\N	\N	\N	www.steinberg-megeltelecommunications,ltd.com	\N	\N	\N	\N	7901 Moccasin Ct.	Bellflower	CA	45713	USA	0
89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:19:52	2005-11-30 19:19:52	1	chris_id	1	I & M Styles Transportation, Ltd	\N	Supply	Transportation	\N	\N	4016 Boyd	Spring Valley	CA	84181	USA	\N	\N	113-555-8790	\N	\N	\N	www.imstylestransportation,ltd.com	\N	\N	\N	\N	4016 Boyd	Spring Valley	CA	84181	USA	0
c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:19:52	2005-11-30 19:19:52	1	will_id	1	Styles-Head Electronics Corp	\N	Manufacturing	Electronics	\N	\N	5765 Mellowood St.	Novato	CA	38054	USA	\N	\N	540-555-4568	\N	\N	\N	www.styles-headelectronicscorp.com	\N	\N	\N	\N	5765 Mellowood St.	Novato	CA	38054	USA	0
f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:19:53	2005-11-30 19:19:53	1	kristen_id	1	H & Y Story Engineering, Inc	\N	Distribution	Engineering	\N	\N	2134 Royal Links Ct	San Carlos	CA	68977	USA	\N	\N	482-555-2404	\N	\N	\N	www.hystoryengineering,inc.com	\N	\N	\N	\N	2134 Royal Links Ct	San Carlos	CA	68977	USA	0
376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:19:53	2005-11-30 19:19:53	1	jaime_id	1	Story-Boone Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	6793 Bonifacio St.	Woodland Hills	CA	88011	USA	\N	\N	271-555-9468	\N	\N	\N	www.story-boonetelecommunications,ltd.com	\N	\N	\N	\N	6793 Bonifacio St.	Woodland Hills	CA	88011	USA	0
7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:19:53	2005-11-30 19:19:53	1	sally_id	1	D & A Mccoy Machinery Group	\N	Manufacturing	Machinery	\N	\N	3416 Ravenwood Drive	Camacho	Zacatecas	58803	Mexico	\N	\N	587-555-2850	\N	\N	\N	www.damccoymachinerygroup.com	\N	\N	\N	\N	3416 Ravenwood Drive	Camacho	Zacatecas	58803	Mexico	0
ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:19:53	2005-11-30 19:19:53	1	max_id	1	Mccoy-Tuck Construction Associates	\N	Consulting	Construction	\N	\N	8329 La Vuelta	Arcadia	CA	43999	USA	\N	\N	638-555-3200	\N	\N	\N	www.mccoy-tuckconstructionassociates.com	\N	\N	\N	\N	8329 La Vuelta	Arcadia	CA	43999	USA	0
db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:19:53	2005-11-30 19:19:53	1	max_id	1	D & Z Sincich Electronics, Ltd	\N	Consulting	Electronics	\N	\N	7861 Yosemite Dr.	Downey	CA	79952	USA	\N	\N	626-555-7293	\N	\N	\N	www.dzsincichelectronics,ltd.com	\N	\N	\N	\N	7861 Yosemite Dr.	Downey	CA	79952	USA	0
1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:19:54	2005-11-30 19:19:54	1	kristen_id	1	Sincich-Jameson Engineering Corp	\N	Consulting	Engineering	\N	\N	3029 Heather Leaf Ln.	Los Angeles	CA	31309	USA	\N	\N	699-555-6272	\N	\N	\N	www.sincich-jamesonengineeringcorp.com	\N	\N	\N	\N	3029 Heather Leaf Ln.	Los Angeles	CA	31309	USA	0
6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:19:54	2005-11-30 19:19:54	1	will_id	1	Q & Q Sanchez Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	2815 La Vuelta	Everett	WA	33424	USA	\N	\N	949-555-3650	\N	\N	\N	www.qqsancheztelecommunicationsassociates.com	\N	\N	\N	\N	2815 La Vuelta	Everett	WA	33424	USA	0
9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:19:54	2005-11-30 19:19:54	1	max_id	1	Sanchez-Parks Engineering Company	\N	Manufacturing	Engineering	\N	\N	5581 Stanford Street	N. Vancouver	BC	49943	Canada	\N	\N	145-555-1257	\N	\N	\N	www.sanchez-parksengineeringcompany.com	\N	\N	\N	\N	5581 Stanford Street	N. Vancouver	BC	49943	Canada	0
dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:19:54	2005-11-30 19:19:54	1	matt_id	1	Y & R Vij Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	8277 Pinole Valley Rd.	Daly City	CA	18219	USA	\N	\N	657-555-9922	\N	\N	\N	www.yrvijmachinery,inc.com	\N	\N	\N	\N	8277 Pinole Valley Rd.	Daly City	CA	18219	USA	0
1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:19:55	2005-11-30 19:19:55	1	sarah_id	1	Vij-Zugschwert Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	6608 Calle Verde Dr.	Walla Walla	WA	98284	USA	\N	\N	776-555-6157	\N	\N	\N	www.vij-zugschwertengineering,inc.com	\N	\N	\N	\N	6608 Calle Verde Dr.	Walla Walla	WA	98284	USA	0
525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:19:55	2005-11-30 19:19:55	1	kristen_id	1	E & F Adams Machinery, Ltd	\N	Consulting	Machinery	\N	\N	9558 Orchard View Ave.	Imperial Beach	CA	32723	USA	\N	\N	411-555-4450	\N	\N	\N	www.efadamsmachinery,ltd.com	\N	\N	\N	\N	9558 Orchard View Ave.	Imperial Beach	CA	32723	USA	0
8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:19:55	2005-11-30 19:19:55	1	chris_id	1	Adams-Steen Transportation Holdings	\N	Distribution	Transportation	\N	\N	8144 Ryan Court	Richmond	CA	54272	USA	\N	\N	791-555-2972	\N	\N	\N	www.adams-steentransportationholdings.com	\N	\N	\N	\N	8144 Ryan Court	Richmond	CA	54272	USA	0
be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:19:55	2005-11-30 19:19:55	1	will_id	1	N & O Baker Electronics, Inc	\N	Supply	Electronics	\N	\N	1349 Palm Ave.	Los Angeles	CA	53872	USA	\N	\N	449-555-8893	\N	\N	\N	www.nobakerelectronics,inc.com	\N	\N	\N	\N	1349 Palm Ave.	Los Angeles	CA	53872	USA	0
efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:19:55	2005-11-30 19:19:55	1	kristen_id	1	Baker-Pearl Machinery Group	\N	Distribution	Machinery	\N	\N	2844 Plymouth Drive	Newton	BC	41583	Canada	\N	\N	853-555-6043	\N	\N	\N	www.baker-pearlmachinerygroup.com	\N	\N	\N	\N	2844 Plymouth Drive	Newton	BC	41583	Canada	0
491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:19:56	2005-11-30 19:19:56	1	beth_id	1	U & W Roundtree Construction Corp	\N	Supply	Construction	\N	\N	8958 Las Palmas	Merida	Yucatan	73444	Mexico	\N	\N	772-555-5250	\N	\N	\N	www.uwroundtreeconstructioncorp.com	\N	\N	\N	\N	8958 Las Palmas	Merida	Yucatan	73444	Mexico	0
98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:19:56	2005-11-30 19:19:56	1	max_id	1	Roundtree-Bollin Electronics Company	\N	Consulting	Electronics	\N	\N	708 Bonifacio	Ladner	BC	60216	Canada	\N	\N	426-555-2426	\N	\N	\N	www.roundtree-bollinelectronicscompany.com	\N	\N	\N	\N	708 Bonifacio	Ladner	BC	60216	Canada	0
c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:19:56	2005-11-30 19:19:56	1	chris_id	1	M & K Hopkins Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	7076 Terry Lynn Lane	Port Hammond	BC	64846	Canada	\N	\N	368-555-9262	\N	\N	\N	www.mkhopkinstelecommunications,ltd.com	\N	\N	\N	\N	7076 Terry Lynn Lane	Port Hammond	BC	64846	Canada	0
5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:19:57	2005-11-30 19:19:57	1	sarah_id	1	Hopkins-Vicknair Machinery, Ltd	\N	Consulting	Machinery	\N	\N	1736 Windsor Drive	Coronado	CA	83880	USA	\N	\N	156-555-7326	\N	\N	\N	www.hopkins-vicknairmachinery,ltd.com	\N	\N	\N	\N	1736 Windsor Drive	Coronado	CA	83880	USA	0
4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:19:57	2005-11-30 19:19:57	1	beth_id	1	L & E McPhearson Communications Partners	\N	Distribution	Communications	\N	\N	8358 St. Helena Drive	Marysville	WA	80965	USA	\N	\N	122-555-3790	\N	\N	\N	www.lemcphearsoncommunicationspartners.com	\N	\N	\N	\N	8358 St. Helena Drive	Marysville	WA	80965	USA	0
85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:19:57	2005-11-30 19:19:57	1	sally_id	1	McPhearson-Albright Construction Holdings	\N	Consulting	Construction	\N	\N	5927 Mt. Hood Circle	Fremont	CA	66160	USA	\N	\N	172-555-4141	\N	\N	\N	www.mcphearson-albrightconstructionholdings.com	\N	\N	\N	\N	5927 Mt. Hood Circle	Fremont	CA	66160	USA	0
c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:19:57	2005-11-30 19:19:57	1	kristen_id	1	W & N Thomas Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	2804 Boxer Blvd.	Albany	OR	31145	USA	\N	\N	160-555-8233	\N	\N	\N	www.wnthomastelecommunicationspartners.com	\N	\N	\N	\N	2804 Boxer Blvd.	Albany	OR	31145	USA	0
fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:19:58	2005-11-30 19:19:58	1	sally_id	1	Thomas-Perko Transportation Holdings	\N	Consulting	Transportation	\N	\N	628 Marina Lakes Drive	Langley	BC	53471	Canada	\N	\N	233-555-7212	\N	\N	\N	www.thomas-perkotransportationholdings.com	\N	\N	\N	\N	628 Marina Lakes Drive	Langley	BC	53471	Canada	0
58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:19:58	2005-11-30 19:19:58	1	beth_id	1	V & A McCarty Transportation Corp	\N	Consulting	Transportation	\N	\N	414 Joseph Ave	Langley	BC	55586	Canada	\N	\N	483-555-4590	\N	\N	\N	www.vamccartytransportationcorp.com	\N	\N	\N	\N	414 Joseph Ave	Langley	BC	55586	Canada	0
88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:19:58	2005-11-30 19:19:58	1	max_id	1	McCarty-Bent Communications Corp	\N	Consulting	Communications	\N	\N	8490 Longbrood Way	Sedro Woolley	WA	45813	USA	\N	\N	579-555-2198	\N	\N	\N	www.mccarty-bentcommunicationscorp.com	\N	\N	\N	\N	8490 Longbrood Way	Sedro Woolley	WA	45813	USA	0
cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:19:58	2005-11-30 19:19:58	1	sally_id	1	T & A Chambers Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	8531 Bayter Court	Burlingame	CA	14089	USA	\N	\N	191-555-1862	\N	\N	\N	www.tachamberselectronics,inc.com	\N	\N	\N	\N	8531 Bayter Court	Burlingame	CA	14089	USA	0
1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:19:59	2005-11-30 19:19:59	1	matt_id	1	Chambers-Bellifa Construction Associates	\N	Manufacturing	Construction	\N	\N	6863 Shakespeare Dr	Sooke	BC	87695	Canada	\N	\N	310-555-7098	\N	\N	\N	www.chambers-bellifaconstructionassociates.com	\N	\N	\N	\N	6863 Shakespeare Dr	Sooke	BC	87695	Canada	0
4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:19:59	2005-11-30 19:19:59	1	chris_id	1	D & D Johnson Electronics Holdings	\N	Supply	Electronics	\N	\N	9813 Morgan Terr. Rd	San Andres	DF	22133	Mexico	\N	\N	845-555-5391	\N	\N	\N	www.ddjohnsonelectronicsholdings.com	\N	\N	\N	\N	9813 Morgan Terr. Rd	San Andres	DF	22133	Mexico	0
9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:19:59	2005-11-30 19:19:59	1	sarah_id	1	Johnson-Vrins Machinery, Inc	\N	Distribution	Machinery	\N	\N	1055 Horseshoe Road	Pomona	CA	43683	USA	\N	\N	677-555-9829	\N	\N	\N	www.johnson-vrinsmachinery,inc.com	\N	\N	\N	\N	1055 Horseshoe Road	Pomona	CA	43683	USA	0
c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:19:59	2005-11-30 19:19:59	1	sally_id	1	I & V Mcdonald Engineering, Inc	\N	Distribution	Engineering	\N	\N	4259 Fenway	Downey	CA	43282	USA	\N	\N	335-555-6751	\N	\N	\N	www.ivmcdonaldengineering,inc.com	\N	\N	\N	\N	4259 Fenway	Downey	CA	43282	USA	0
246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:20:00	2005-11-30 19:20:00	1	beth_id	1	Mcdonald-Weldon Construction, Ltd	\N	Manufacturing	Construction	\N	\N	5754 Glenhaven Ave	Palo Alto	CA	30993	USA	\N	\N	738-555-3901	\N	\N	\N	www.mcdonald-weldonconstruction,ltd.com	\N	\N	\N	\N	5754 Glenhaven Ave	Palo Alto	CA	30993	USA	0
60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:20:00	2005-11-30 19:20:00	1	matt_id	1	K & R Choin Communications Group	\N	Consulting	Communications	\N	\N	9212 Tupelo Drive	Everett	WA	69462	USA	\N	\N	658-555-3108	\N	\N	\N	www.krchoincommunicationsgroup.com	\N	\N	\N	\N	9212 Tupelo Drive	Everett	WA	69462	USA	0
a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:20:00	2005-11-30 19:20:00	1	jaime_id	1	Choin-Crow Engineering Associates	\N	Distribution	Engineering	\N	\N	3618 Galveston Ct	Acapulco	Guerrero	49627	Mexico	\N	\N	184-555-7886	\N	\N	\N	www.choin-crowengineeringassociates.com	\N	\N	\N	\N	3618 Galveston Ct	Acapulco	Guerrero	49627	Mexico	0
e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:20:00	2005-11-30 19:20:00	1	max_id	1	B & P Avalos Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	9986 El Pintado	Tlaxiaco	Oaxaca	54257	Mexico	\N	\N	127-555-5722	\N	\N	\N	www.bpavalostelecommunicationsholdings.com	\N	\N	\N	\N	9986 El Pintado	Tlaxiaco	Oaxaca	54257	Mexico	0
2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:20:01	2005-11-30 19:20:01	1	kristen_id	1	Avalos-Jacobsen Electronics, Ltd	\N	Distribution	Electronics	\N	\N	1990 Guadalajara	Redmond	WA	73291	USA	\N	\N	815-555-3786	\N	\N	\N	www.avalos-jacobsenelectronics,ltd.com	\N	\N	\N	\N	1990 Guadalajara	Redmond	WA	73291	USA	0
66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:20:01	2005-11-30 19:20:01	1	chris_id	1	Q & P Castro Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	2515 Live Oak	Haney	BC	44083	Canada	\N	\N	120-555-3908	\N	\N	\N	www.qpcastrotelecommunicationscompany.com	\N	\N	\N	\N	2515 Live Oak	Haney	BC	44083	Canada	0
a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:20:01	2005-11-30 19:20:01	1	beth_id	1	Castro-Caldwell Transportation Holdings	\N	Consulting	Transportation	\N	\N	7427 Grove Way	Burien	WA	29279	USA	\N	\N	831-555-9601	\N	\N	\N	www.castro-caldwelltransportationholdings.com	\N	\N	\N	\N	7427 Grove Way	Burien	WA	29279	USA	0
e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:20:01	2005-11-30 19:20:01	1	kristen_id	1	G & N Reed Communications Group	\N	Supply	Communications	\N	\N	6960 Trees Drive	Mexico City	Mexico	65232	Mexico	\N	\N	158-555-8351	\N	\N	\N	www.gnreedcommunicationsgroup.com	\N	\N	\N	\N	6960 Trees Drive	Mexico City	Mexico	65232	Mexico	0
3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:20:02	2005-11-30 19:20:02	1	kristen_id	1	Reed-Kelley Construction Partners	\N	Distribution	Construction	\N	\N	2128 Evelyn Court	Merida	Yucatan	16590	Mexico	\N	\N	892-555-3672	\N	\N	\N	www.reed-kelleyconstructionpartners.com	\N	\N	\N	\N	2128 Evelyn Court	Merida	Yucatan	16590	Mexico	0
7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:20:02	2005-11-30 19:20:02	1	kristen_id	1	H & Y Taylor Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	1914 Creekside Dr.	Hidalgo	Zacatecas	18704	Mexico	\N	\N	242-555-1051	\N	\N	\N	www.hytaylorelectronics,ltd.com	\N	\N	\N	\N	1914 Creekside Dr.	Hidalgo	Zacatecas	18704	Mexico	0
c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:20:02	2005-11-30 19:20:02	1	chris_id	1	Taylor-Robinson Transportation Holdings	\N	Supply	Transportation	\N	\N	9991 El Pintado Road	Lemon Grove	CA	35223	USA	\N	\N	689-555-4575	\N	\N	\N	www.taylor-robinsontransportationholdings.com	\N	\N	\N	\N	9991 El Pintado Road	Lemon Grove	CA	35223	USA	0
f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:20:02	2005-11-30 19:20:02	1	sarah_id	1	O & K Thomsen Transportation Corp	\N	Manufacturing	Transportation	\N	\N	32 Sun View Terrace	Ladner	BC	35005	Canada	\N	\N	301-555-4240	\N	\N	\N	www.okthomsentransportationcorp.com	\N	\N	\N	\N	32 Sun View Terrace	Ladner	BC	35005	Canada	0
39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:20:03	2005-11-30 19:20:03	1	beth_id	1	Thomsen-Baldwin Construction Partners	\N	Consulting	Construction	\N	\N	1019 Mt. Davidson Court	Burien	WA	10857	USA	\N	\N	420-555-9475	\N	\N	\N	www.thomsen-baldwinconstructionpartners.com	\N	\N	\N	\N	1019 Mt. Davidson Court	Burien	WA	10857	USA	0
8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:20:03	2005-11-30 19:20:03	1	sally_id	1	D & D Yuhasz Transportation, Ltd	\N	Distribution	Transportation	\N	\N	1314 Skyline Dr.	Anacortes	WA	44295	USA	\N	\N	955-555-7768	\N	\N	\N	www.ddyuhasztransportation,ltd.com	\N	\N	\N	\N	1314 Skyline Dr.	Anacortes	WA	44295	USA	0
c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:20:03	2005-11-30 19:20:03	1	kristen_id	1	Yuhasz-Carmody Machinery, Inc	\N	Consulting	Machinery	\N	\N	2555 Via Rosa	Royal Oak	BC	92137	Canada	\N	\N	436-555-6290	\N	\N	\N	www.yuhasz-carmodymachinery,inc.com	\N	\N	\N	\N	2555 Via Rosa	Royal Oak	BC	92137	Canada	0
f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:20:03	2005-11-30 19:20:03	1	beth_id	1	E & M Gonzales Electronics Company	\N	Supply	Electronics	\N	\N	5759 Benton Street	Oregon City	OR	65444	USA	\N	\N	993-555-3211	\N	\N	\N	www.emgonzaleselectronicscompany.com	\N	\N	\N	\N	5759 Benton Street	Oregon City	OR	65444	USA	0
391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:20:04	2005-11-30 19:20:04	1	matt_id	1	Gonzales-Allen Engineering, Ltd	\N	Distribution	Engineering	\N	\N	7254 Buchanan Road	San Gabriel	CA	79447	USA	\N	\N	497-555-9361	\N	\N	\N	www.gonzales-allenengineering,ltd.com	\N	\N	\N	\N	7254 Buchanan Road	San Gabriel	CA	79447	USA	0
912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:20:04	2005-11-30 19:20:04	1	matt_id	1	R & Z Caprio Communications, Inc	\N	Distribution	Communications	\N	\N	3369 Houston Ct.	Westminster	BC	18917	Canada	\N	\N	417-555-8568	\N	\N	\N	www.rzcapriocommunications,inc.com	\N	\N	\N	\N	3369 Houston Ct.	Westminster	BC	18917	Canada	0
dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:20:04	2005-11-30 19:20:04	1	chris_id	1	Caprio-Slaven Machinery Partners	\N	Supply	Machinery	\N	\N	5118 Boxwood Dr.	Mill Valley	CA	71789	USA	\N	\N	843-555-4347	\N	\N	\N	www.caprio-slavenmachinerypartners.com	\N	\N	\N	\N	5118 Boxwood Dr.	Mill Valley	CA	71789	USA	0
191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:20:05	2005-11-30 19:20:05	1	sarah_id	1	J & K Ortiz Communications Corp	\N	Supply	Communications	\N	\N	1487 Franklin Canyon Road	Palo Alto	CA	37125	USA	\N	\N	786-555-2182	\N	\N	\N	www.jkortizcommunicationscorp.com	\N	\N	\N	\N	1487 Franklin Canyon Road	Palo Alto	CA	37125	USA	0
58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:20:05	2005-11-30 19:20:05	1	sally_id	1	Ortiz-Beaver Construction, Ltd	\N	Supply	Construction	\N	\N	6146 Holland Drive	Newport Beach	CA	22746	USA	\N	\N	574-555-9247	\N	\N	\N	www.ortiz-beaverconstruction,ltd.com	\N	\N	\N	\N	6146 Holland Drive	Newport Beach	CA	22746	USA	0
88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:20:05	2005-11-30 19:20:05	1	max_id	1	W & W Rhodes Electronics Associates	\N	Supply	Electronics	\N	\N	2769 Edward Ave.	Orizaba	Veracruz	92537	Mexico	\N	\N	778-555-9368	\N	\N	\N	www.wwrhodeselectronicsassociates.com	\N	\N	\N	\N	2769 Edward Ave.	Orizaba	Veracruz	92537	Mexico	0
d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:20:05	2005-11-30 19:20:05	1	max_id	1	Rhodes-Kaffer Machinery Group	\N	Manufacturing	Machinery	\N	\N	7682 Alta Vista	Tacoma	WA	77733	USA	\N	\N	590-555-6061	\N	\N	\N	www.rhodes-kaffermachinerygroup.com	\N	\N	\N	\N	7682 Alta Vista	Tacoma	WA	77733	USA	0
412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:20:06	2005-11-30 19:20:06	1	beth_id	1	D & G Bales Transportation, Inc	\N	Distribution	Transportation	\N	\N	7214 Elliott Dr	Bellflower	CA	14687	USA	\N	\N	271-555-1649	\N	\N	\N	www.dgbalestransportation,inc.com	\N	\N	\N	\N	7214 Elliott Dr	Bellflower	CA	14687	USA	0
8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:20:06	2005-11-30 19:20:06	1	matt_id	1	Bales-Stotka Engineering, Ltd	\N	Supply	Engineering	\N	\N	2382 Wibur Ave.	Santa Anita	DF	65044	Mexico	\N	\N	105-555-5971	\N	\N	\N	www.bales-stotkaengineering,ltd.com	\N	\N	\N	\N	2382 Wibur Ave.	Santa Anita	DF	65044	Mexico	0
ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:20:06	2005-11-30 19:20:06	1	jaime_id	1	Z & L Maynard Construction, Ltd	\N	Supply	Construction	\N	\N	2168 Terra Calitina	Bellingham	WA	67158	USA	\N	\N	355-555-3349	\N	\N	\N	www.zlmaynardconstruction,ltd.com	\N	\N	\N	\N	2168 Terra Calitina	Bellingham	WA	67158	USA	0
62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:20:07	2005-11-30 19:20:07	1	will_id	1	Maynard-Tuell Transportation Group	\N	Manufacturing	Transportation	\N	\N	246 Weatherly Way	Langley	BC	83677	Canada	\N	\N	690-555-4614	\N	\N	\N	www.maynard-tuelltransportationgroup.com	\N	\N	\N	\N	246 Weatherly Way	Langley	BC	83677	Canada	0
43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:20:07	2005-11-30 19:20:07	1	max_id	1	V & P Burnett Transportation Corp	\N	Consulting	Transportation	\N	\N	2942 Marina Road	Acapulco	Guerrero	25662	Mexico	\N	\N	963-555-9621	\N	\N	\N	www.vpburnetttransportationcorp.com	\N	\N	\N	\N	2942 Marina Road	Acapulco	Guerrero	25662	Mexico	0
90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:20:07	2005-11-30 19:20:07	1	will_id	1	Burnett-Haugh Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	1273 Deetmeadow Way	Olympia	WA	83425	USA	\N	\N	182-555-5856	\N	\N	\N	www.burnett-haughtelecommunications,inc.com	\N	\N	\N	\N	1273 Deetmeadow Way	Olympia	WA	83425	USA	0
cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:20:07	2005-11-30 19:20:07	1	matt_id	1	F & X Moberly Communications Partners	\N	Consulting	Communications	\N	\N	4223 Las Trampas Road	La Mesa	CA	93185	USA	\N	\N	716-555-4149	\N	\N	\N	www.fxmoberlycommunicationspartners.com	\N	\N	\N	\N	4223 Las Trampas Road	La Mesa	CA	93185	USA	0
1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:20:08	2005-11-30 19:20:08	1	sally_id	1	Moberly-Meyer Communications Holdings	\N	Distribution	Communications	\N	\N	2809 Via Montana	Colma	CA	30868	USA	\N	\N	197-555-2671	\N	\N	\N	www.moberly-meyercommunicationsholdings.com	\N	\N	\N	\N	2809 Via Montana	Colma	CA	30868	USA	0
5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:20:08	2005-11-30 19:20:08	1	sarah_id	1	S & X Orona Engineering Partners	\N	Distribution	Engineering	\N	\N	8669 Rotherham Dr.	Santa Anita	DF	30467	Mexico	\N	\N	755-555-8592	\N	\N	\N	www.sxoronaengineeringpartners.com	\N	\N	\N	\N	8669 Rotherham Dr.	Santa Anita	DF	30467	Mexico	0
a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:20:08	2005-11-30 19:20:08	1	sarah_id	1	Orona-Warmack Transportation, Inc	\N	Supply	Transportation	\N	\N	165 Schenone Court	Burnaby	BC	18178	Canada	\N	\N	259-555-5742	\N	\N	\N	www.orona-warmacktransportation,inc.com	\N	\N	\N	\N	165 Schenone Court	Burnaby	BC	18178	Canada	0
e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:20:08	2005-11-30 19:20:08	1	sarah_id	1	H & N Wall Machinery Corp	\N	Supply	Machinery	\N	\N	3623 Barquentine Court	Salem	OR	82939	USA	\N	\N	178-555-4949	\N	\N	\N	www.hnwallmachinerycorp.com	\N	\N	\N	\N	3623 Barquentine Court	Salem	OR	82939	USA	0
3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:20:09	2005-11-30 19:20:09	1	will_id	1	Wall-Appelbaum Machinery Associates	\N	Supply	Machinery	\N	\N	3963 Greentree Drive	Bellingham	WA	36812	USA	\N	\N	844-555-4385	\N	\N	\N	www.wall-appelbaummachineryassociates.com	\N	\N	\N	\N	3963 Greentree Drive	Bellingham	WA	36812	USA	0
705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:20:09	2005-11-30 19:20:09	1	max_id	1	G & W Kung Transportation, Inc	\N	Distribution	Transportation	\N	\N	7675 Moss Hollow Court	Sedro Woolley	WA	41442	USA	\N	\N	898-555-4481	\N	\N	\N	www.gwkungtransportation,inc.com	\N	\N	\N	\N	7675 Moss Hollow Court	Sedro Woolley	WA	41442	USA	0
af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:20:09	2005-11-30 19:20:09	1	matt_id	1	Kung-Wilson Machinery Corp	\N	Manufacturing	Machinery	\N	\N	2335 Peabody Road	Guadalajara	Jalisco	60476	Mexico	\N	\N	448-555-7888	\N	\N	\N	www.kung-wilsonmachinerycorp.com	\N	\N	\N	\N	2335 Peabody Road	Guadalajara	Jalisco	60476	Mexico	0
df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:20:09	2005-11-30 19:20:09	1	beth_id	1	V & B Tuffield Transportation Holdings	\N	Supply	Transportation	\N	\N	8957 Maureen Circle	Long Beach	CA	57560	USA	\N	\N	652-555-8009	\N	\N	\N	www.vbtuffieldtransportationholdings.com	\N	\N	\N	\N	8957 Maureen Circle	Long Beach	CA	57560	USA	0
37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:20:10	2005-11-30 19:20:10	1	beth_id	1	Tuffield-Ping Construction Company	\N	Consulting	Construction	\N	\N	6526 Edie Ct.	Tlaxiaco	Oaxaca	42756	Mexico	\N	\N	463-555-4702	\N	\N	\N	www.tuffield-pingconstructioncompany.com	\N	\N	\N	\N	6526 Edie Ct.	Tlaxiaco	Oaxaca	42756	Mexico	0
69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:20:10	2005-11-30 19:20:10	1	max_id	1	C & A Shepard Engineering Group	\N	Supply	Engineering	\N	\N	3403 Meadowbrook	W. Linn	OR	78709	USA	\N	\N	690-555-3452	\N	\N	\N	www.cashepardengineeringgroup.com	\N	\N	\N	\N	3403 Meadowbrook	W. Linn	OR	78709	USA	0
b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:20:10	2005-11-30 19:20:10	1	kristen_id	1	Shepard-Bailey Construction, Ltd	\N	Consulting	Construction	\N	\N	1227 Wesley Court	Richmond	BC	30067	Canada	\N	\N	525-555-7773	\N	\N	\N	www.shepard-baileyconstruction,ltd.com	\N	\N	\N	\N	1227 Wesley Court	Richmond	BC	30067	Canada	0
8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:20:11	2005-11-30 19:20:11	1	chris_id	1	U & S Chestnut Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	1013 Buchanan Rd	Yakima	WA	32182	USA	\N	\N	114-555-8809	\N	\N	\N	www.uschestnuttransportation,inc.com	\N	\N	\N	\N	1013 Buchanan Rd	Yakima	WA	32182	USA	0
307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:20:11	2005-11-30 19:20:11	1	will_id	1	Chestnut-Toone Construction Group	\N	Distribution	Construction	\N	\N	9090 Cristobal	Bremerton	WA	22408	USA	\N	\N	210-555-6416	\N	\N	\N	www.chestnut-tooneconstructiongroup.com	\N	\N	\N	\N	9090 Cristobal	Bremerton	WA	22408	USA	0
636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:20:11	2005-11-30 19:20:11	1	sarah_id	1	N & W Armstrong Transportation Corp	\N	Distribution	Transportation	\N	\N	9130 San Ramon Road	Mill Valley	CA	89684	USA	\N	\N	483-555-2423	\N	\N	\N	www.nwarmstrongtransportationcorp.com	\N	\N	\N	\N	9130 San Ramon Road	Mill Valley	CA	89684	USA	0
939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:20:11	2005-11-30 19:20:11	1	matt_id	1	Armstrong-Billstrom Engineering Partners	\N	Supply	Engineering	\N	\N	7462 Linden Land	Ladner	BC	72364	Canada	\N	\N	841-555-2316	\N	\N	\N	www.armstrong-billstromengineeringpartners.com	\N	\N	\N	\N	7462 Linden Land	Ladner	BC	72364	Canada	0
d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:20:11	2005-11-30 19:20:11	1	sarah_id	1	O & D Stotka Communications Associates	\N	Distribution	Communications	\N	\N	413 Rishell Ct	Sooke	BC	31770	Canada	\N	\N	236-555-5952	\N	\N	\N	www.odstotkacommunicationsassociates.com	\N	\N	\N	\N	413 Rishell Ct	Sooke	BC	31770	Canada	0
1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:20:12	2005-11-30 19:20:12	1	sally_id	1	Stotka-Johnson Transportation Company	\N	Consulting	Transportation	\N	\N	1654 Bonari Court	Imperial Beach	CA	79612	USA	\N	\N	617-555-4473	\N	\N	\N	www.stotka-johnsontransportationcompany.com	\N	\N	\N	\N	1654 Bonari Court	Imperial Beach	CA	79612	USA	0
4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:20:12	2005-11-30 19:20:12	1	sally_id	1	M & Y Lepro Communications, Ltd	\N	Supply	Communications	\N	\N	4858 Shannon Lane	La Mesa	CA	79211	USA	\N	\N	275-555-1395	\N	\N	\N	www.myleprocommunications,ltd.com	\N	\N	\N	\N	4858 Shannon Lane	La Mesa	CA	79211	USA	0
c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:20:12	2005-11-30 19:20:12	1	beth_id	1	Lepro-Elliott Communications Associates	\N	Consulting	Communications	\N	\N	6353 Dan Ysidro Court	Milwaukie	OR	66922	USA	\N	\N	608-555-2777	\N	\N	\N	www.lepro-elliottcommunicationsassociates.com	\N	\N	\N	\N	6353 Dan Ysidro Court	Milwaukie	OR	66922	USA	0
f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:20:12	2005-11-30 19:20:12	1	max_id	1	B & D Steelman Machinery Partners	\N	Consulting	Machinery	\N	\N	9811 Toledo	Shawnee	BC	63923	Canada	\N	\N	288-555-7327	\N	\N	\N	www.bdsteelmanmachinerypartners.com	\N	\N	\N	\N	9811 Toledo	Shawnee	BC	63923	Canada	0
4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:20:13	2005-11-30 19:20:13	1	sarah_id	1	Steelman-Adams Construction Partners	\N	Manufacturing	Construction	\N	\N	4217 Almond Avenue	San Gabriel	CA	85556	USA	\N	\N	954-555-6763	\N	\N	\N	www.steelman-adamsconstructionpartners.com	\N	\N	\N	\N	4217 Almond Avenue	San Gabriel	CA	85556	USA	0
9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:20:13	2005-11-30 19:20:13	1	kristen_id	1	H & E Poorbaugh Machinery Group	\N	Supply	Machinery	\N	\N	586 Willow Pass Dr.	Glendale	CA	90186	USA	\N	\N	896-555-4598	\N	\N	\N	www.hepoorbaughmachinerygroup.com	\N	\N	\N	\N	586 Willow Pass Dr.	Glendale	CA	90186	USA	0
dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:20:13	2005-11-30 19:20:13	1	beth_id	1	Poorbaugh-Hasty Electronics Holdings	\N	Supply	Electronics	\N	\N	5245 Fraga Court	Burlingame	CA	10221	USA	\N	\N	685-555-2663	\N	\N	\N	www.poorbaugh-hastyelectronicsholdings.com	\N	\N	\N	\N	5245 Fraga Court	Burlingame	CA	10221	USA	0
280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:20:14	2005-11-30 19:20:14	1	max_id	1	X & M Betsekas Construction Corp	\N	Manufacturing	Construction	\N	\N	1867 Seville	National City	CA	80012	USA	\N	\N	650-555-8127	\N	\N	\N	www.xmbetsekasconstructioncorp.com	\N	\N	\N	\N	1867 Seville	National City	CA	80012	USA	0
6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:20:14	2005-11-30 19:20:14	1	sally_id	1	Betsekas-Ziegler Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	6780 Ware Ct.	Port Hammond	BC	65208	Canada	\N	\N	461-555-4820	\N	\N	\N	www.betsekas-zieglertelecommunications,ltd.com	\N	\N	\N	\N	6780 Ware Ct.	Port Hammond	BC	65208	Canada	0
aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:20:14	2005-11-30 19:20:14	1	chris_id	1	I & M Weyerhaeuser Transportation, Ltd	\N	Supply	Transportation	\N	\N	6313 Collins Drive	Shawnee	BC	21626	Canada	\N	\N	688-555-3570	\N	\N	\N	www.imweyerhaeusertransportation,ltd.com	\N	\N	\N	\N	6313 Collins Drive	Shawnee	BC	21626	Canada	0
ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:20:14	2005-11-30 19:20:14	1	will_id	1	Weyerhaeuser-Robinson Electronics Corp	\N	Manufacturing	Electronics	\N	\N	1481 Near Ct.	Altadena	CA	52519	USA	\N	\N	762-555-2548	\N	\N	\N	www.weyerhaeuser-robinsonelectronicscorp.com	\N	\N	\N	\N	1481 Near Ct.	Altadena	CA	52519	USA	0
4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:20:15	2005-11-30 19:20:15	1	kristen_id	1	H & Y Brunner Engineering, Inc	\N	Distribution	Engineering	\N	\N	1267 Scenic Drive	Santa Monica	CA	54634	USA	\N	\N	111-555-8927	\N	\N	\N	www.hybrunnerengineering,inc.com	\N	\N	\N	\N	1267 Scenic Drive	Santa Monica	CA	54634	USA	0
7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:20:15	2005-11-30 19:20:15	1	jaime_id	1	Brunner-Frazier Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	9344 Stony Hill Circle	Berkeley	CA	71152	USA	\N	\N	208-555-6534	\N	\N	\N	www.brunner-fraziertelecommunications,ltd.com	\N	\N	\N	\N	9344 Stony Hill Circle	Berkeley	CA	71152	USA	0
bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:20:15	2005-11-30 19:20:15	1	sally_id	1	D & A Rector Machinery Group	\N	Manufacturing	Machinery	\N	\N	9384 Jamie Way	Bellingham	WA	39429	USA	\N	\N	480-555-2541	\N	\N	\N	www.darectormachinerygroup.com	\N	\N	\N	\N	9384 Jamie Way	Bellingham	WA	39429	USA	0
95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:20:16	2005-11-30 19:20:16	1	max_id	1	Rector-Caldwell Construction Associates	\N	Consulting	Construction	\N	\N	372 Canyon Creek Drive	Corvallis	OR	94816	USA	\N	\N	951-555-4694	\N	\N	\N	www.rector-caldwellconstructionassociates.com	\N	\N	\N	\N	372 Canyon Creek Drive	Corvallis	OR	94816	USA	0
49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:20:16	2005-11-30 19:20:16	1	max_id	1	D & Z Gonzales Electronics, Ltd	\N	Consulting	Electronics	\N	\N	3322 Haven Hill Drive	Lynnwood	WA	29255	USA	\N	\N	346-555-8329	\N	\N	\N	www.dzgonzaleselectronics,ltd.com	\N	\N	\N	\N	3322 Haven Hill Drive	Lynnwood	WA	29255	USA	0
8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:20:16	2005-11-30 19:20:16	1	kristen_id	1	Gonzales-Monitor Engineering Corp	\N	Consulting	Engineering	\N	\N	1908 San Jose Ave	Newton	BC	43020	Canada	\N	\N	727-555-6851	\N	\N	\N	www.gonzales-monitorengineeringcorp.com	\N	\N	\N	\N	1908 San Jose Ave	Newton	BC	43020	Canada	0
e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:20:16	2005-11-30 19:20:16	1	will_id	1	Q & Q Lewin Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	6358 Parkview Court	Lake Oswego	OR	42620	USA	\N	\N	624-555-7430	\N	\N	\N	www.qqlewintelecommunicationsassociates.com	\N	\N	\N	\N	6358 Parkview Court	Lake Oswego	OR	42620	USA	0
30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:20:17	2005-11-30 19:20:17	1	max_id	1	Lewin-Desalvo Engineering Company	\N	Manufacturing	Engineering	\N	\N	7853 Millfield Place	Beverly Hills	CA	30331	USA	\N	\N	127-555-4580	\N	\N	\N	www.lewin-desalvoengineeringcompany.com	\N	\N	\N	\N	7853 Millfield Place	Beverly Hills	CA	30331	USA	0
630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:20:17	2005-11-30 19:20:17	1	matt_id	1	Y & R Alpuerto Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	3968 Bonifacio	Spokane	WA	95091	USA	\N	\N	708-555-9130	\N	\N	\N	www.yralpuertomachinery,inc.com	\N	\N	\N	\N	3968 Bonifacio	Spokane	WA	95091	USA	0
a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:20:17	2005-11-30 19:20:17	1	sarah_id	1	Alpuerto-Marshall Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	5717 Shenandoah Drive	Fremont	CA	48964	USA	\N	\N	474-555-8565	\N	\N	\N	www.alpuerto-marshallengineering,inc.com	\N	\N	\N	\N	5717 Shenandoah Drive	Fremont	CA	48964	USA	0
e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:20:17	2005-11-30 19:20:17	1	kristen_id	1	E & F Bockenkamp Machinery, Ltd	\N	Consulting	Machinery	\N	\N	2086 Rotherham Dr.	Berkeley	CA	79887	USA	\N	\N	416-555-6401	\N	\N	\N	www.efbockenkampmachinery,ltd.com	\N	\N	\N	\N	2086 Rotherham Dr.	Berkeley	CA	79887	USA	0
20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:20:18	2005-11-30 19:20:18	1	chris_id	1	Bockenkamp-Kesterson Transportation Holdings	\N	Distribution	Transportation	\N	\N	6745 Blue Ridge Drive	Glendale	CA	98921	USA	\N	\N	204-555-4465	\N	\N	\N	www.bockenkamp-kestersontransportationholdings.com	\N	\N	\N	\N	6745 Blue Ridge Drive	Glendale	CA	98921	USA	0
64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:20:18	2005-11-30 19:20:18	1	will_id	1	N & O Alexander Electronics, Inc	\N	Supply	Electronics	\N	\N	3368 Rainier Dr.	Richmond	BC	69713	Canada	\N	\N	757-555-1584	\N	\N	\N	www.noalexanderelectronics,inc.com	\N	\N	\N	\N	3368 Rainier Dr.	Richmond	BC	69713	Canada	0
94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:20:18	2005-11-30 19:20:18	1	kristen_id	1	Alexander-Mendoza Machinery Group	\N	Distribution	Machinery	\N	\N	8281 Rhoda Way	Novato	CA	54909	USA	\N	\N	569-555-7276	\N	\N	\N	www.alexander-mendozamachinerygroup.com	\N	\N	\N	\N	8281 Rhoda Way	Novato	CA	54909	USA	0
c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:20:18	2005-11-30 19:20:18	1	beth_id	1	U & W Herrick Construction Corp	\N	Supply	Construction	\N	\N	7813 Worth Ct.	Anacortes	WA	90861	USA	\N	\N	796-555-6026	\N	\N	\N	www.uwherrickconstructioncorp.com	\N	\N	\N	\N	7813 Worth Ct.	Anacortes	WA	90861	USA	0
3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:20:19	2005-11-30 19:20:19	1	max_id	1	Herrick-McCoy Electronics Company	\N	Consulting	Electronics	\N	\N	5636 Barcelona	Langford	BC	42219	Canada	\N	\N	869-555-5005	\N	\N	\N	www.herrick-mccoyelectronicscompany.com	\N	\N	\N	\N	5636 Barcelona	Langford	BC	42219	Canada	0
65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:20:19	2005-11-30 19:20:19	1	chris_id	1	M & K Thoreson Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	5423 Morengo Ct.	Langford	BC	44334	Canada	\N	\N	219-555-2384	\N	\N	\N	www.mkthoresontelecommunications,ltd.com	\N	\N	\N	\N	5423 Morengo Ct.	Langford	BC	44334	Canada	0
c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:20:19	2005-11-30 19:20:19	1	sarah_id	1	Thoreson-Snowden Machinery, Ltd	\N	Consulting	Machinery	\N	\N	845 Olive Ave	Walla Walla	WA	34561	USA	\N	\N	315-555-8991	\N	\N	\N	www.thoreson-snowdenmachinery,ltd.com	\N	\N	\N	\N	845 Olive Ave	Walla Walla	WA	34561	USA	0
18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:20:20	2005-11-30 19:20:20	1	beth_id	1	L & E Blanton Communications Partners	\N	Distribution	Communications	\N	\N	3541 Corte Poquito	Arcadia	CA	28375	USA	\N	\N	588-555-4998	\N	\N	\N	www.leblantoncommunicationspartners.com	\N	\N	\N	\N	3541 Corte Poquito	Arcadia	CA	28375	USA	0
5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:20:20	2005-11-30 19:20:20	1	sally_id	1	Blanton-Gibbens Construction Holdings	\N	Consulting	Construction	\N	\N	1872 Walnut Avenue	Santa Fe	DF	84517	Mexico	\N	\N	946-555-4891	\N	\N	\N	www.blanton-gibbensconstructionholdings.com	\N	\N	\N	\N	1872 Walnut Avenue	Santa Fe	DF	84517	Mexico	0
a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:20:20	2005-11-30 19:20:20	1	kristen_id	1	W & N Alcorn Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	4822 Center Street	Fremont	CA	18956	USA	\N	\N	580-555-3184	\N	\N	\N	www.wnalcorntelecommunicationspartners.com	\N	\N	\N	\N	4822 Center Street	Fremont	CA	18956	USA	0
d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:20:20	2005-11-30 19:20:20	1	sally_id	1	Alcorn-Miller Transportation Holdings	\N	Consulting	Transportation	\N	\N	6064 Madrid	Bellflower	CA	40505	USA	\N	\N	722-555-7048	\N	\N	\N	www.alcorn-millertransportationholdings.com	\N	\N	\N	\N	6064 Madrid	Bellflower	CA	40505	USA	0
31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:20:21	2005-11-30 19:20:21	1	beth_id	1	V & A Campen Transportation Corp	\N	Consulting	Transportation	\N	\N	9268 Keller Ridge	Salem	OR	90784	USA	\N	\N	619-555-7627	\N	\N	\N	www.vacampentransportationcorp.com	\N	\N	\N	\N	9268 Keller Ridge	Salem	OR	90784	USA	0
64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:20:21	2005-11-30 19:20:21	1	max_id	1	Campen-Coffman Communications Corp	\N	Consulting	Communications	\N	\N	764 Nahua	San Diego	CA	78495	USA	\N	\N	123-555-4777	\N	\N	\N	www.campen-coffmancommunicationscorp.com	\N	\N	\N	\N	764 Nahua	San Diego	CA	78495	USA	0
9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:20:21	2005-11-30 19:20:21	1	sally_id	1	T & A Bustamante Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	4222 San Jose Dr.	Concord	CA	44256	USA	\N	\N	815-555-2586	\N	\N	\N	www.tabustamanteelectronics,inc.com	\N	\N	\N	\N	4222 San Jose Dr.	Concord	CA	44256	USA	0
2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:20:22	2005-11-30 19:20:22	1	matt_id	1	Bustamante-Eldridge Construction Associates	\N	Manufacturing	Construction	\N	\N	8627 Laguna Street	San Diego	CA	97128	USA	\N	\N	581-555-2022	\N	\N	\N	www.bustamante-eldridgeconstructionassociates.com	\N	\N	\N	\N	8627 Laguna Street	San Diego	CA	97128	USA	0
82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:20:22	2005-11-30 19:20:22	1	chris_id	1	D & D Sipsy Electronics Holdings	\N	Supply	Electronics	\N	\N	4996 Hillview Drive	National City	CA	27594	USA	\N	\N	523-555-8858	\N	\N	\N	www.ddsipsyelectronicsholdings.com	\N	\N	\N	\N	4996 Hillview Drive	National City	CA	27594	USA	0
c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:20:22	2005-11-30 19:20:22	1	sarah_id	1	Sipsy-Weimer Machinery, Inc	\N	Distribution	Machinery	\N	\N	6999 Salem St.	San Andres	DF	21793	Mexico	\N	\N	312-555-6922	\N	\N	\N	www.sipsy-weimermachinery,inc.com	\N	\N	\N	\N	6999 Salem St.	San Andres	DF	21793	Mexico	0
1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:20:23	2005-11-30 19:20:23	1	sally_id	1	I & V Irwin Engineering, Inc	\N	Distribution	Engineering	\N	\N	6277 Greenview Court	Lebanon	OR	91585	USA	\N	\N	277-555-3386	\N	\N	\N	www.ivirwinengineering,inc.com	\N	\N	\N	\N	6277 Greenview Court	Lebanon	OR	91585	USA	0
31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:20:23	2005-11-30 19:20:23	1	beth_id	1	Irwin-Son Construction, Ltd	\N	Manufacturing	Construction	\N	\N	1191 Boxwood Dr.	Burbank	CA	76780	USA	\N	\N	988-555-9079	\N	\N	\N	www.irwin-sonconstruction,ltd.com	\N	\N	\N	\N	1191 Boxwood Dr.	Burbank	CA	76780	USA	0
ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:20:23	2005-11-30 19:20:23	1	matt_id	1	K & R Brandon Communications Group	\N	Consulting	Communications	\N	\N	8067 Olympic Drive	Yakima	WA	40026	USA	\N	\N	315-555-7829	\N	\N	\N	www.krbrandoncommunicationsgroup.com	\N	\N	\N	\N	8067 Olympic Drive	Yakima	WA	40026	USA	0
de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:20:23	2005-11-30 19:20:23	1	jaime_id	1	Brandon-Quintana Engineering Associates	\N	Distribution	Engineering	\N	\N	5890 Ardith Drive	Vancouver	BC	64091	Canada	\N	\N	389-555-6808	\N	\N	\N	www.brandon-quintanaengineeringassociates.com	\N	\N	\N	\N	5890 Ardith Drive	Vancouver	BC	64091	Canada	0
2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:20:24	2005-11-30 19:20:24	1	max_id	1	B & P Colon Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	5677 William Reed Dr.	Guadalajara	Jalisco	66206	Mexico	\N	\N	639-555-4186	\N	\N	\N	www.bpcolontelecommunicationsholdings.com	\N	\N	\N	\N	5677 William Reed Dr.	Guadalajara	Jalisco	66206	Mexico	0
848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:20:24	2005-11-30 19:20:24	1	kristen_id	1	Colon-Barlow Electronics, Ltd	\N	Distribution	Electronics	\N	\N	3754 Alray Drive	Oak Bay	BC	82725	Canada	\N	\N	735-555-1793	\N	\N	\N	www.colon-barlowelectronics,ltd.com	\N	\N	\N	\N	3754 Alray Drive	Oak Bay	BC	82725	Canada	0
c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:20:24	2005-11-30 19:20:24	1	chris_id	1	Q & P Adina Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	3795 Tabora Drive	Woodland Hills	CA	51001	USA	\N	\N	108-555-6800	\N	\N	\N	www.qpadinatelecommunicationscompany.com	\N	\N	\N	\N	3795 Tabora Drive	Woodland Hills	CA	51001	USA	0
4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:20:25	2005-11-30 19:20:25	1	beth_id	1	Adina-Bohling Transportation Holdings	\N	Consulting	Transportation	\N	\N	4782 Mt. Whitney Dr.	Bellflower	CA	33682	USA	\N	\N	831-555-2749	\N	\N	\N	www.adina-bohlingtransportationholdings.com	\N	\N	\N	\N	4782 Mt. Whitney Dr.	Bellflower	CA	33682	USA	0
a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:20:25	2005-11-30 19:20:25	1	kristen_id	1	G & N Wheeler Communications Group	\N	Supply	Communications	\N	\N	2258 Pablo Neruda	West Covina	CA	40827	USA	\N	\N	466-555-1042	\N	\N	\N	www.gnwheelercommunicationsgroup.com	\N	\N	\N	\N	2258 Pablo Neruda	West Covina	CA	40827	USA	0
e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:20:25	2005-11-30 19:20:25	1	kristen_id	1	Wheeler-Swearengin Construction Partners	\N	Distribution	Construction	\N	\N	3499 Parkway Drive	Everett	WA	88669	USA	\N	\N	847-555-8563	\N	\N	\N	www.wheeler-swearenginconstructionpartners.com	\N	\N	\N	\N	3499 Parkway Drive	Everett	WA	88669	USA	0
4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:20:26	2005-11-30 19:20:26	1	kristen_id	1	H & Y Givens Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	6703 Milburn Dr.	Santa Monica	CA	61976	USA	\N	\N	505-555-5484	\N	\N	\N	www.hygivenselectronics,ltd.com	\N	\N	\N	\N	6703 Milburn Dr.	Santa Monica	CA	61976	USA	0
92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:20:26	2005-11-30 19:20:26	1	chris_id	1	Givens-Beanston Transportation Holdings	\N	Supply	Transportation	\N	\N	8198 Mt. Whitney Dr.	La Jolla	CA	92873	USA	\N	\N	908-555-2634	\N	\N	\N	www.givens-beanstontransportationholdings.com	\N	\N	\N	\N	8198 Mt. Whitney Dr.	La Jolla	CA	92873	USA	0
d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:20:26	2005-11-30 19:20:26	1	sarah_id	1	O & K Bruno Transportation Corp	\N	Manufacturing	Transportation	\N	\N	4313 Camby Rd.	Sooke	BC	32342	Canada	\N	\N	828-555-1842	\N	\N	\N	www.okbrunotransportationcorp.com	\N	\N	\N	\N	4313 Camby Rd.	Sooke	BC	32342	Canada	0
4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:20:27	2005-11-30 19:20:27	1	beth_id	1	Bruno-Berger Construction Partners	\N	Consulting	Construction	\N	\N	6062 Mota Dr.	Redmond	WA	85214	USA	\N	\N	354-555-6620	\N	\N	\N	www.bruno-bergerconstructionpartners.com	\N	\N	\N	\N	6062 Mota Dr.	Redmond	WA	85214	USA	0
a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:20:27	2005-11-30 19:20:27	1	sally_id	1	D & D Sultan Transportation, Ltd	\N	Distribution	Transportation	\N	\N	2431 Santa Lucia Dr.	Portland	OR	17137	USA	\N	\N	297-555-4456	\N	\N	\N	www.ddsultantransportation,ltd.com	\N	\N	\N	\N	2431 Santa Lucia Dr.	Portland	OR	17137	USA	0
e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:20:27	2005-11-30 19:20:27	1	kristen_id	1	Sultan-Svoboda Machinery, Inc	\N	Consulting	Machinery	\N	\N	7090 C. Mount Hood	Santa Cruz	CA	36171	USA	\N	\N	985-555-2520	\N	\N	\N	www.sultan-svobodamachinery,inc.com	\N	\N	\N	\N	7090 C. Mount Hood	Santa Cruz	CA	36171	USA	0
2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:20:28	2005-11-30 19:20:28	1	beth_id	1	E & M Tullao Electronics Company	\N	Supply	Electronics	\N	\N	3713 Rollingwood Dr.	Vancouver	BC	69633	Canada	\N	\N	950-555-7984	\N	\N	\N	www.emtullaoelectronicscompany.com	\N	\N	\N	\N	3713 Rollingwood Dr.	Vancouver	BC	69633	Canada	0
55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:20:28	2005-11-30 19:20:28	1	matt_id	1	Tullao-Hernandez Engineering, Ltd	\N	Distribution	Engineering	\N	\N	8626 Lillian Dr	Langley	BC	91158	Canada	\N	\N	101-555-8334	\N	\N	\N	www.tullao-hernandezengineering,ltd.com	\N	\N	\N	\N	8626 Lillian Dr	Langley	BC	91158	Canada	0
b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:20:28	2005-11-30 19:20:28	1	matt_id	1	R & Z Wilkie Communications, Inc	\N	Distribution	Communications	\N	\N	8158 Ahwanee Lane	Langford	BC	28112	Canada	\N	\N	989-555-3427	\N	\N	\N	www.rzwilkiecommunications,inc.com	\N	\N	\N	\N	8158 Ahwanee Lane	Langford	BC	28112	Canada	0
ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:20:29	2005-11-30 19:20:29	1	chris_id	1	Wilkie-Lunt Machinery Partners	\N	Supply	Machinery	\N	\N	3326 Indianhead Ct.	West Covina	CA	78469	USA	\N	\N	274-555-4666	\N	\N	\N	www.wilkie-luntmachinerypartners.com	\N	\N	\N	\N	3326 Indianhead Ct.	West Covina	CA	78469	USA	0
43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:20:29	2005-11-30 19:20:29	1	sarah_id	1	J & K Fulton Communications Corp	\N	Supply	Communications	\N	\N	3112 Gilardy Dr.	Tlaxiaco	Oaxaca	80584	Mexico	\N	\N	524-555-2044	\N	\N	\N	www.jkfultoncommunicationscorp.com	\N	\N	\N	\N	3112 Gilardy Dr.	Tlaxiaco	Oaxaca	80584	Mexico	0
8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:20:29	2005-11-30 19:20:29	1	sally_id	1	Fulton-Dillon Construction, Ltd	\N	Supply	Construction	\N	\N	1190 Hill Top Rd.	Concord	CA	97102	USA	\N	\N	620-555-8651	\N	\N	\N	www.fulton-dillonconstruction,ltd.com	\N	\N	\N	\N	1190 Hill Top Rd.	Concord	CA	97102	USA	0
284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:20:30	2005-11-30 19:20:30	1	max_id	1	W & W Miller Electronics Associates	\N	Supply	Electronics	\N	\N	3886 Delta View Ln.	Walla Walla	WA	65379	USA	\N	\N	232-555-8316	\N	\N	\N	www.wwmillerelectronicsassociates.com	\N	\N	\N	\N	3886 Delta View Ln.	Walla Walla	WA	65379	USA	0
5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:20:30	2005-11-30 19:20:30	1	max_id	1	Miller-Stern Machinery Group	\N	Manufacturing	Machinery	\N	\N	2217 Pueblo Dr.	Oakland	CA	21767	USA	\N	\N	351-555-4551	\N	\N	\N	www.miller-sternmachinerygroup.com	\N	\N	\N	\N	2217 Pueblo Dr.	Oakland	CA	21767	USA	0
cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:20:30	2005-11-30 19:20:30	1	beth_id	1	D & G Suffin Transportation, Inc	\N	Distribution	Transportation	\N	\N	5167 Condor Place	Albany	OR	55205	USA	\N	\N	886-555-2844	\N	\N	\N	www.dgsuffintransportation,inc.com	\N	\N	\N	\N	5167 Condor Place	Albany	OR	55205	USA	0
73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:20:31	2005-11-30 19:20:31	1	matt_id	1	Suffin-Cleary Engineering, Ltd	\N	Supply	Engineering	\N	\N	3753 Forest Way	Burnaby	BC	76754	Canada	\N	\N	367-555-1366	\N	\N	\N	www.suffin-clearyengineering,ltd.com	\N	\N	\N	\N	3753 Forest Way	Burnaby	BC	76754	Canada	0
77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:20:31	2005-11-30 19:20:31	1	jaime_id	1	Z & L Homax Construction, Ltd	\N	Supply	Construction	\N	\N	6957 Corte Poquito	West Covina	CA	76354	USA	\N	\N	924-555-7287	\N	\N	\N	www.zlhomaxconstruction,ltd.com	\N	\N	\N	\N	6957 Corte Poquito	West Covina	CA	76354	USA	0
a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:20:31	2005-11-30 19:20:31	1	will_id	1	Homax-Adams Transportation Group	\N	Manufacturing	Transportation	\N	\N	8452 Dewing Avenue	San Carlos	CA	64065	USA	\N	\N	428-555-4437	\N	\N	\N	www.homax-adamstransportationgroup.com	\N	\N	\N	\N	8452 Dewing Avenue	San Carlos	CA	64065	USA	0
d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:20:32	2005-11-30 19:20:32	1	max_id	1	V & P Zubaty Transportation Corp	\N	Consulting	Transportation	\N	\N	4567 Shannon Lane	Edmonds	WA	81086	USA	\N	\N	348-555-3644	\N	\N	\N	www.vpzubatytransportationcorp.com	\N	\N	\N	\N	4567 Shannon Lane	Edmonds	WA	81086	USA	0
3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:20:32	2005-11-30 19:20:32	1	will_id	1	Zubaty-Khan Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	6316 Damascus Loop	Tlaxiaco	Oaxaca	34959	Mexico	\N	\N	774-555-8423	\N	\N	\N	www.zubaty-khantelecommunications,inc.com	\N	\N	\N	\N	6316 Damascus Loop	Tlaxiaco	Oaxaca	34959	Mexico	0
7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:20:32	2005-11-30 19:20:32	1	matt_id	1	F & X Brinkd Communications Partners	\N	Consulting	Communications	\N	\N	2685 Keith Court	Colma	CA	39589	USA	\N	\N	717-555-6258	\N	\N	\N	www.fxbrinkdcommunicationspartners.com	\N	\N	\N	\N	2685 Keith Court	Colma	CA	39589	USA	0
b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:20:32	2005-11-30 19:20:32	1	sally_id	1	Brinkd-Clark Communications Holdings	\N	Distribution	Communications	\N	\N	7344 Maureen Lane	Altadena	CA	58623	USA	\N	\N	195-555-4898	\N	\N	\N	www.brinkd-clarkcommunicationsholdings.com	\N	\N	\N	\N	7344 Maureen Lane	Altadena	CA	58623	USA	0
6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:20:33	2005-11-30 19:20:33	1	sarah_id	1	S & X Dennis Engineering Partners	\N	Distribution	Engineering	\N	\N	3967 High Street	Spokane	WA	55707	USA	\N	\N	160-555-1362	\N	\N	\N	www.sxdennisengineeringpartners.com	\N	\N	\N	\N	3967 High Street	Spokane	WA	55707	USA	0
d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:20:33	2005-11-30 19:20:33	1	sarah_id	1	Dennis-Brumfield Transportation, Inc	\N	Supply	Transportation	\N	\N	1536 Camino Verde Ct.	San Jose	CA	40903	USA	\N	\N	211-555-1712	\N	\N	\N	www.dennis-brumfieldtransportation,inc.com	\N	\N	\N	\N	1536 Camino Verde Ct.	San Jose	CA	40903	USA	0
58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:20:34	2005-11-30 19:20:34	1	sarah_id	1	H & N Sanchez Machinery Corp	\N	Supply	Machinery	\N	\N	8412 Jorge	Lynnwood	WA	76856	USA	\N	\N	199-555-5805	\N	\N	\N	www.hnsanchezmachinerycorp.com	\N	\N	\N	\N	8412 Jorge	Lynnwood	WA	76856	USA	0
8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:20:34	2005-11-30 19:20:34	1	will_id	1	Sanchez-Suess Machinery Associates	\N	Supply	Machinery	\N	\N	6235 Bayview Cr	Oak Bay	BC	28214	Canada	\N	\N	272-555-4783	\N	\N	\N	www.sanchez-suessmachineryassociates.com	\N	\N	\N	\N	6235 Bayview Cr	Oak Bay	BC	28214	Canada	0
9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:20:35	2005-11-30 19:20:35	1	max_id	1	G & W Trach Transportation, Inc	\N	Distribution	Transportation	\N	\N	6022 La Salle Ct.	Oak Bay	BC	30329	Canada	\N	\N	522-555-2162	\N	\N	\N	www.gwtrachtransportation,inc.com	\N	\N	\N	\N	6022 La Salle Ct.	Oak Bay	BC	30329	Canada	0
86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:20:35	2005-11-30 19:20:35	1	matt_id	1	Trach-White Machinery Corp	\N	Manufacturing	Machinery	\N	\N	5346 Clayburn Road	Olympia	WA	20555	USA	\N	\N	618-555-8769	\N	\N	\N	www.trach-whitemachinerycorp.com	\N	\N	\N	\N	5346 Clayburn Road	Olympia	WA	20555	USA	0
dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:20:35	2005-11-30 19:20:35	1	beth_id	1	V & B Brian Transportation Holdings	\N	Supply	Transportation	\N	\N	5386 Salvio St.	Long Beach	CA	87831	USA	\N	\N	230-555-8433	\N	\N	\N	www.vbbriantransportationholdings.com	\N	\N	\N	\N	5386 Salvio St.	Long Beach	CA	87831	USA	0
59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:20:36	2005-11-30 19:20:36	1	beth_id	1	Brian-Trujillo Construction Company	\N	Consulting	Construction	\N	\N	3718 Loma Linda	Shawnee	BC	70511	Canada	\N	\N	349-555-4669	\N	\N	\N	www.brian-trujilloconstructioncompany.com	\N	\N	\N	\N	3718 Loma Linda	Shawnee	BC	70511	Canada	0
b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:20:36	2005-11-30 19:20:36	1	max_id	1	C & A Alameda Engineering Group	\N	Supply	Engineering	\N	\N	6668 Mazatlan	Mexico City	Mexico	49504	Mexico	\N	\N	884-555-2962	\N	\N	\N	www.caalamedaengineeringgroup.com	\N	\N	\N	\N	6668 Mazatlan	Mexico City	Mexico	49504	Mexico	0
e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:20:36	2005-11-30 19:20:36	1	kristen_id	1	Alameda-Fox Construction, Ltd	\N	Consulting	Construction	\N	\N	7909 Yorba Linda	Salem	OR	26499	USA	\N	\N	365-555-1483	\N	\N	\N	www.alameda-foxconstruction,ltd.com	\N	\N	\N	\N	7909 Yorba Linda	Salem	OR	26499	USA	0
39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:20:37	2005-11-30 19:20:37	1	chris_id	1	U & S Gallagher Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	1114 R St.	Ballard	WA	26099	USA	\N	\N	922-555-7405	\N	\N	\N	www.usgallaghertransportation,inc.com	\N	\N	\N	\N	1114 R St.	Ballard	WA	26099	USA	0
6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:20:37	2005-11-30 19:20:37	1	will_id	1	Gallagher-Myer Construction Group	\N	Distribution	Construction	\N	\N	2609 Amarillo	Guadalajara	Jalisco	13810	Mexico	\N	\N	426-555-4555	\N	\N	\N	www.gallagher-myerconstructiongroup.com	\N	\N	\N	\N	2609 Amarillo	Guadalajara	Jalisco	13810	Mexico	0
b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:20:37	2005-11-30 19:20:37	1	sarah_id	1	N & W Byrnes Transportation Corp	\N	Distribution	Transportation	\N	\N	6067 Mt. Diablo St.	Torrance	CA	44494	USA	\N	\N	460-555-5943	\N	\N	\N	www.nwbyrnestransportationcorp.com	\N	\N	\N	\N	6067 Mt. Diablo St.	Torrance	CA	44494	USA	0
e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:20:37	2005-11-30 19:20:37	1	matt_id	1	Byrnes-Ryan Engineering Partners	\N	Supply	Engineering	\N	\N	473 Akyn Rock Drive	Guadalajara	Jalisco	24659	Mexico	\N	\N	887-555-1721	\N	\N	\N	www.byrnes-ryanengineeringpartners.com	\N	\N	\N	\N	473 Akyn Rock Drive	Guadalajara	Jalisco	24659	Mexico	0
1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:20:38	2005-11-30 19:20:38	1	sarah_id	1	O & D Chand Communications Associates	\N	Distribution	Communications	\N	\N	6841 Curletto Dr.	Victoria	BC	29290	Canada	\N	\N	829-555-8557	\N	\N	\N	www.odchandcommunicationsassociates.com	\N	\N	\N	\N	6841 Curletto Dr.	Victoria	BC	29290	Canada	0
7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:20:38	2005-11-30 19:20:38	1	sally_id	1	Chand-Vanderkamp Transportation Company	\N	Consulting	Transportation	\N	\N	8844 Fitzpatrick Drive	Cliffside	BC	48324	Canada	\N	\N	618-555-6621	\N	\N	\N	www.chand-vanderkamptransportationcompany.com	\N	\N	\N	\N	8844 Fitzpatrick Drive	Cliffside	BC	48324	Canada	0
c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:20:38	2005-11-30 19:20:38	1	sally_id	1	M & Y Carroll Communications, Ltd	\N	Supply	Communications	\N	\N	8122 Cincerto Circle	Woodburn	OR	19116	USA	\N	\N	822-555-6743	\N	\N	\N	www.mycarrollcommunications,ltd.com	\N	\N	\N	\N	8122 Cincerto Circle	Woodburn	OR	19116	USA	0
19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:20:39	2005-11-30 19:20:39	1	beth_id	1	Carroll-Contreras Communications Associates	\N	Consulting	Communications	\N	\N	3036 W. Cypress Road	Altadena	CA	43124	USA	\N	\N	633-555-3436	\N	\N	\N	www.carroll-contrerascommunicationsassociates.com	\N	\N	\N	\N	3036 W. Cypress Road	Altadena	CA	43124	USA	0
31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:20:39	2005-11-30 19:20:39	1	max_id	1	B & D Cantoni Machinery Partners	\N	Consulting	Machinery	\N	\N	2569 La Orinda Pl.	Puyallup	WA	40265	USA	\N	\N	860-555-2186	\N	\N	\N	www.bdcantonimachinerypartners.com	\N	\N	\N	\N	2569 La Orinda Pl.	Puyallup	WA	40265	USA	0
6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:20:39	2005-11-30 19:20:39	1	sarah_id	1	Cantoni-Reed Construction Partners	\N	Manufacturing	Construction	\N	\N	7736 Sunnybrook Drive	Mexico City	Mexico	90621	Mexico	\N	\N	695-555-6507	\N	\N	\N	www.cantoni-reedconstructionpartners.com	\N	\N	\N	\N	7736 Sunnybrook Drive	Mexico City	Mexico	90621	Mexico	0
95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:20:39	2005-11-30 19:20:39	1	kristen_id	1	H & E Peterson Machinery Group	\N	Supply	Machinery	\N	\N	7522 Santa Ana Drive	Mexico City	Mexico	92736	Mexico	\N	\N	945-555-3885	\N	\N	\N	www.hepetersonmachinerygroup.com	\N	\N	\N	\N	7522 Santa Ana Drive	Mexico City	Mexico	92736	Mexico	0
dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:20:39	2005-11-30 19:20:39	1	beth_id	1	Peterson-Osborn Electronics Holdings	\N	Supply	Electronics	\N	\N	5600 Star Tree Court	Ladner	BC	10256	Canada	\N	\N	141-555-1493	\N	\N	\N	www.peterson-osbornelectronicsholdings.com	\N	\N	\N	\N	5600 Star Tree Court	Ladner	BC	10256	Canada	0
17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:20:40	2005-11-30 19:20:40	1	max_id	1	X & M Graham. Construction Corp	\N	Manufacturing	Construction	\N	\N	5640 Indianhead Way	Tlaxiaco	Oaxaca	77531	Mexico	\N	\N	653-555-1157	\N	\N	\N	www.xmgrahamconstructioncorp.com	\N	\N	\N	\N	5640 Indianhead Way	Tlaxiaco	Oaxaca	77531	Mexico	0
4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:20:40	2005-11-30 19:20:40	1	sally_id	1	Graham.-Shaddy Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	6627 Camelback Ct.	Coronado	CA	33920	USA	\N	\N	771-555-6393	\N	\N	\N	www.graham-shaddytelecommunications,ltd.com	\N	\N	\N	\N	6627 Camelback Ct.	Coronado	CA	33920	USA	0
7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:20:40	2005-11-30 19:20:40	1	chris_id	1	I & M Haemon Transportation, Ltd	\N	Supply	Transportation	\N	\N	6922 Hamlet	Tacoma	WA	67358	USA	\N	\N	996-555-5260	\N	\N	\N	www.imhaemontransportation,ltd.com	\N	\N	\N	\N	6922 Hamlet	Tacoma	WA	67358	USA	0
ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:20:40	2005-11-30 19:20:40	1	will_id	1	Haemon-Krow Electronics Corp	\N	Manufacturing	Electronics	\N	\N	8163 S. Forest Hill	Shawnee	BC	16200	Canada	\N	\N	477-555-3782	\N	\N	\N	www.haemon-krowelectronicscorp.com	\N	\N	\N	\N	8163 S. Forest Hill	Shawnee	BC	16200	Canada	0
ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:20:40	2005-11-30 19:20:40	1	kristen_id	1	H & Y Belli Engineering, Inc	\N	Distribution	Engineering	\N	\N	1368 Palms Drive	Renton	WA	88506	USA	\N	\N	135-555-9703	\N	\N	\N	www.hybelliengineering,inc.com	\N	\N	\N	\N	1368 Palms Drive	Renton	WA	88506	USA	0
1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:20:41	2005-11-30 19:20:41	1	jaime_id	1	Belli-Porter Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	2863 Polk Street	Torrance	CA	35114	USA	\N	\N	539-555-6853	\N	\N	\N	www.belli-portertelecommunications,ltd.com	\N	\N	\N	\N	2863 Polk Street	Torrance	CA	35114	USA	0
4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:20:41	2005-11-30 19:20:41	1	sally_id	1	D & A Lesko Machinery Group	\N	Manufacturing	Machinery	\N	\N	8977 Woodhaven Lane	Ladner	BC	41979	Canada	\N	\N	458-555-6060	\N	\N	\N	www.daleskomachinerygroup.com	\N	\N	\N	\N	8977 Woodhaven Lane	Ladner	BC	41979	Canada	0
7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:20:41	2005-11-30 19:20:41	1	max_id	1	Lesko-Worland Construction Associates	\N	Consulting	Construction	\N	\N	727 Pheasant Ct.	Burlingame	CA	20239	USA	\N	\N	885-555-1839	\N	\N	\N	www.lesko-worlandconstructionassociates.com	\N	\N	\N	\N	727 Pheasant Ct.	Burlingame	CA	20239	USA	0
af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:20:41	2005-11-30 19:20:41	1	max_id	1	D & Z Torre Electronics, Ltd	\N	Consulting	Electronics	\N	\N	7095 Thames Drive	Concord	CA	51162	USA	\N	\N	827-555-8675	\N	\N	\N	www.dztorreelectronics,ltd.com	\N	\N	\N	\N	7095 Thames Drive	Concord	CA	51162	USA	0
e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:20:41	2005-11-30 19:20:41	1	kristen_id	1	Torre-Ramos Engineering Corp	\N	Consulting	Engineering	\N	\N	1755 Winton Drive	Lake Oswego	OR	70195	USA	\N	\N	616-555-6739	\N	\N	\N	www.torre-ramosengineeringcorp.com	\N	\N	\N	\N	1755 Winton Drive	Lake Oswego	OR	70195	USA	0
1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:20:42	2005-11-30 19:20:42	1	will_id	1	Q & Q Christie Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	8377 St. Raphael Drive	La Cruz	Sinaloa	40988	Mexico	\N	\N	820-555-6860	\N	\N	\N	www.qqchristietelecommunicationsassociates.com	\N	\N	\N	\N	8377 St. Raphael Drive	La Cruz	Sinaloa	40988	Mexico	0
4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:20:42	2005-11-30 19:20:42	1	max_id	1	Christie-Zocchi Engineering Company	\N	Manufacturing	Engineering	\N	\N	3290 Las Palmas	Yakima	WA	26183	USA	\N	\N	631-555-3553	\N	\N	\N	www.christie-zocchiengineeringcompany.com	\N	\N	\N	\N	3290 Las Palmas	Yakima	WA	26183	USA	0
8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:20:42	2005-11-30 19:20:42	1	matt_id	1	Y & R Altamirano Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	8757 Keith Court	Seattle	WA	62136	USA	\N	\N	858-555-2303	\N	\N	\N	www.yraltamiranomachinery,inc.com	\N	\N	\N	\N	8757 Keith Court	Seattle	WA	62136	USA	0
b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:20:42	2005-11-30 19:20:42	1	sarah_id	1	Altamirano-Benson Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	3925 Boyd	Corvallis	OR	13494	USA	\N	\N	692-555-6625	\N	\N	\N	www.altamirano-bensonengineering,inc.com	\N	\N	\N	\N	3925 Boyd	Corvallis	OR	13494	USA	0
e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:20:42	2005-11-30 19:20:42	1	kristen_id	1	E & F Deborde Machinery, Ltd	\N	Consulting	Machinery	\N	\N	3711 Amargosa Drive	Glendale	CA	15609	USA	\N	\N	155-555-6263	\N	\N	\N	www.efdebordemachinery,ltd.com	\N	\N	\N	\N	3711 Amargosa Drive	Glendale	CA	15609	USA	0
25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:20:43	2005-11-30 19:20:43	1	chris_id	1	Deborde-Calone Transportation Holdings	\N	Distribution	Transportation	\N	\N	1789 Birchwood Dr.	Corvallis	OR	32128	USA	\N	\N	490-555-7528	\N	\N	\N	www.deborde-calonetransportationholdings.com	\N	\N	\N	\N	1789 Birchwood Dr.	Corvallis	OR	32128	USA	0
56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:20:43	2005-11-30 19:20:43	1	will_id	1	N & O Pompa Electronics, Inc	\N	Supply	Electronics	\N	\N	4485 Pheasant Court	Guadalajara	Jalisco	73111	Mexico	\N	\N	763-555-3535	\N	\N	\N	www.nopompaelectronics,inc.com	\N	\N	\N	\N	4485 Pheasant Court	Guadalajara	Jalisco	73111	Mexico	0
8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:20:43	2005-11-30 19:20:43	1	kristen_id	1	Pompa-Traube Machinery Group	\N	Distribution	Machinery	\N	\N	2816 Hemlock Drive	Pomona	CA	55792	USA	\N	\N	882-555-8770	\N	\N	\N	www.pompa-traubemachinerygroup.com	\N	\N	\N	\N	2816 Hemlock Drive	Pomona	CA	55792	USA	0
bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:20:43	2005-11-30 19:20:43	1	beth_id	1	U & W Sloan Construction Corp	\N	Supply	Construction	\N	\N	5767 Oakmead	Newton	BC	89229	Canada	\N	\N	516-555-7063	\N	\N	\N	www.uwsloanconstructioncorp.com	\N	\N	\N	\N	5767 Oakmead	Newton	BC	89229	Canada	0
eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:20:43	2005-11-30 19:20:43	1	max_id	1	Sloan-Villa Electronics Company	\N	Consulting	Electronics	\N	\N	4352 Acardia Pl.	Coronado	CA	11780	USA	\N	\N	897-555-5585	\N	\N	\N	www.sloan-villaelectronicscompany.com	\N	\N	\N	\N	4352 Acardia Pl.	Coronado	CA	11780	USA	0
2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:20:44	2005-11-30 19:20:44	1	chris_id	1	M & K Herman Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	213 Valencia Place	Tacoma	WA	11379	USA	\N	\N	555-555-2506	\N	\N	\N	www.mkhermantelecommunications,ltd.com	\N	\N	\N	\N	213 Valencia Place	Tacoma	WA	11379	USA	0
616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:20:44	2005-11-30 19:20:44	1	sarah_id	1	Herman-Roberts Machinery, Ltd	\N	Consulting	Machinery	\N	\N	1708 Weaver Lane	Oregon City	OR	98089	USA	\N	\N	958-555-8656	\N	\N	\N	www.herman-robertsmachinery,ltd.com	\N	\N	\N	\N	1708 Weaver Lane	Oregon City	OR	98089	USA	0
95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:20:44	2005-11-30 19:20:44	1	beth_id	1	L & E Mc Clane Communications Partners	\N	Distribution	Communications	\N	\N	5166 D Kiska Ct.	Tixapan	DF	63851	Mexico	\N	\N	878-555-7863	\N	\N	\N	www.lemcclanecommunicationspartners.com	\N	\N	\N	\N	5166 D Kiska Ct.	Tixapan	DF	63851	Mexico	0
c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:20:44	2005-11-30 19:20:44	1	sally_id	1	Mc Clane-Maxham Construction Holdings	\N	Consulting	Construction	\N	\N	9571 Live Oak Dr.	Glendale	CA	17724	USA	\N	\N	644-555-7299	\N	\N	\N	www.mcclane-maxhamconstructionholdings.com	\N	\N	\N	\N	9571 Live Oak Dr.	Glendale	CA	17724	USA	0
3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:20:45	2005-11-30 19:20:45	1	kristen_id	1	W & N Sullivan Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	3284 Bynum Way	Lakewood	CA	16185	USA	\N	\N	586-555-5135	\N	\N	\N	www.wnsullivantelecommunicationspartners.com	\N	\N	\N	\N	3284 Bynum Way	Lakewood	CA	16185	USA	0
3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:20:45	2005-11-30 19:20:45	1	sally_id	1	Sullivan-Watada Transportation Holdings	\N	Consulting	Transportation	\N	\N	7943 Cunha Ct.	Burien	WA	35219	USA	\N	\N	135-555-8542	\N	\N	\N	www.sullivan-watadatransportationholdings.com	\N	\N	\N	\N	7943 Cunha Ct.	Burien	WA	35219	USA	0
6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:20:45	2005-11-30 19:20:45	1	beth_id	1	V & A Rhiger Transportation Corp	\N	Consulting	Transportation	\N	\N	4566 Bermad Drive	La Mesa	CA	32303	USA	\N	\N	930-555-9238	\N	\N	\N	www.varhigertransportationcorp.com	\N	\N	\N	\N	4566 Bermad Drive	La Mesa	CA	32303	USA	0
aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:20:45	2005-11-30 19:20:45	1	max_id	1	Rhiger-Finley Communications Corp	\N	Consulting	Communications	\N	\N	2135 St. Paul Way	Kirkland	WA	17499	USA	\N	\N	741-555-5931	\N	\N	\N	www.rhiger-finleycommunicationscorp.com	\N	\N	\N	\N	2135 St. Paul Way	Kirkland	WA	17499	USA	0
dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:20:45	2005-11-30 19:20:45	1	sally_id	1	T & A Winter Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	9011 Blackburn Ct.	Oak Bay	BC	53452	Canada	\N	\N	968-555-4681	\N	\N	\N	www.tawinterelectronics,inc.com	\N	\N	\N	\N	9011 Blackburn Ct.	Oak Bay	BC	53452	Canada	0
1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:20:46	2005-11-30 19:20:46	1	matt_id	1	Winter-Adams Construction Associates	\N	Manufacturing	Construction	\N	\N	6835 Lynwood Drive	Spring Valley	CA	48094	USA	\N	\N	802-555-9002	\N	\N	\N	www.winter-adamsconstructionassociates.com	\N	\N	\N	\N	6835 Lynwood Drive	Spring Valley	CA	48094	USA	0
4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:20:46	2005-11-30 19:20:46	1	chris_id	1	D & D Tench Electronics Holdings	\N	Supply	Electronics	\N	\N	6621 Polaris Dr.	Imperial Beach	CA	69245	USA	\N	\N	391-555-1038	\N	\N	\N	www.ddtenchelectronicsholdings.com	\N	\N	\N	\N	6621 Polaris Dr.	Imperial Beach	CA	69245	USA	0
8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:20:46	2005-11-30 19:20:46	1	sarah_id	1	Tench-Brink Machinery, Inc	\N	Distribution	Machinery	\N	\N	4698 Royal Oak Rd.	San Francisco	CA	96150	USA	\N	\N	488-555-7645	\N	\N	\N	www.tench-brinkmachinery,inc.com	\N	\N	\N	\N	4698 Royal Oak Rd.	San Francisco	CA	96150	USA	0
bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:20:46	2005-11-30 19:20:46	1	sally_id	1	I & V Reynolds Engineering, Inc	\N	Distribution	Engineering	\N	\N	4739 Garden Ave.	Lebanon	OR	64427	USA	\N	\N	760-555-3652	\N	\N	\N	www.ivreynoldsengineering,inc.com	\N	\N	\N	\N	4739 Garden Ave.	Lebanon	OR	64427	USA	0
edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:20:46	2005-11-30 19:20:46	1	beth_id	1	Reynolds-Posner Construction, Ltd	\N	Manufacturing	Construction	\N	\N	3071 Asilomar	Issaquah	WA	47107	USA	\N	\N	218-555-3545	\N	\N	\N	www.reynolds-posnerconstruction,ltd.com	\N	\N	\N	\N	3071 Asilomar	Issaquah	WA	47107	USA	0
323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:20:47	2005-11-30 19:20:47	1	matt_id	1	K & R Hapke Communications Group	\N	Consulting	Communications	\N	\N	6021 Ellis St.	Merida	Yucatan	54253	Mexico	\N	\N	514-555-7181	\N	\N	\N	www.krhapkecommunicationsgroup.com	\N	\N	\N	\N	6021 Ellis St.	Merida	Yucatan	54253	Mexico	0
6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:20:47	2005-11-30 19:20:47	1	jaime_id	1	Hapke-Huff Engineering Associates	\N	Distribution	Engineering	\N	\N	7262 Pepperidge Way	Beverly Hills	CA	30955	USA	\N	\N	895-555-5702	\N	\N	\N	www.hapke-huffengineeringassociates.com	\N	\N	\N	\N	7262 Pepperidge Way	Beverly Hills	CA	30955	USA	0
a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:20:47	2005-11-30 19:20:47	1	max_id	1	B & P Brown Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	467 Moccasin Ct.	San Carlos	CA	26954	USA	\N	\N	552-555-2624	\N	\N	\N	www.bpbrowntelecommunicationsholdings.com	\N	\N	\N	\N	467 Moccasin Ct.	San Carlos	CA	26954	USA	0
d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:20:47	2005-11-30 19:20:47	1	kristen_id	1	Brown-Giglio Electronics, Ltd	\N	Distribution	Electronics	\N	\N	1962 Geary Road	Acapulco	Guerrero	89405	Mexico	\N	\N	295-555-3431	\N	\N	\N	www.brown-giglioelectronics,ltd.com	\N	\N	\N	\N	1962 Geary Road	Acapulco	Guerrero	89405	Mexico	0
19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:20:48	2005-11-30 19:20:48	1	chris_id	1	Q & P Sherwood Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	5420 Thornwood Drive	Beaverton	OR	28874	USA	\N	\N	876-555-7981	\N	\N	\N	www.qpsherwoodtelecommunicationscompany.com	\N	\N	\N	\N	5420 Thornwood Drive	Beaverton	OR	28874	USA	0
4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:20:48	2005-11-30 19:20:48	1	beth_id	1	Sherwood-Becker Transportation Holdings	\N	Consulting	Transportation	\N	\N	9825 Mt. Dell Drive	Acapulco	Guerrero	90392	Mexico	\N	\N	761-555-9439	\N	\N	\N	www.sherwood-beckertransportationholdings.com	\N	\N	\N	\N	9825 Mt. Dell Drive	Acapulco	Guerrero	90392	Mexico	0
88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:20:48	2005-11-30 19:20:48	1	kristen_id	1	G & N Tedford Communications Group	\N	Supply	Communications	\N	\N	6194 Via Maria	Daly City	CA	13669	USA	\N	\N	704-555-7275	\N	\N	\N	www.gntedfordcommunicationsgroup.com	\N	\N	\N	\N	6194 Via Maria	Daly City	CA	13669	USA	0
c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:20:48	2005-11-30 19:20:48	1	kristen_id	1	Tedford-Roy Construction Partners	\N	Distribution	Construction	\N	\N	2100 Grant Street	Ballard	WA	57381	USA	\N	\N	492-555-5339	\N	\N	\N	www.tedford-royconstructionpartners.com	\N	\N	\N	\N	2100 Grant Street	Ballard	WA	57381	USA	0
f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:20:48	2005-11-30 19:20:48	1	kristen_id	1	H & Y Holloway Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	8722 Norcross Lane	Haney	BC	28173	Canada	\N	\N	457-555-1803	\N	\N	\N	www.hyhollowayelectronics,ltd.com	\N	\N	\N	\N	8722 Norcross Lane	Haney	BC	28173	Canada	0
34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:20:49	2005-11-30 19:20:49	1	chris_id	1	Holloway-Trau Transportation Holdings	\N	Supply	Transportation	\N	\N	3635 N Ridgewood Drive	Lynnwood	WA	13369	USA	\N	\N	269-555-7496	\N	\N	\N	www.holloway-trautransportationholdings.com	\N	\N	\N	\N	3635 N Ridgewood Drive	Lynnwood	WA	13369	USA	0
6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:20:49	2005-11-30 19:20:49	1	sarah_id	1	O & K Carnes Transportation Corp	\N	Manufacturing	Transportation	\N	\N	3168 Thames Drive	Marysville	WA	49322	USA	\N	\N	496-555-6246	\N	\N	\N	www.okcarnestransportationcorp.com	\N	\N	\N	\N	3168 Thames Drive	Marysville	WA	49322	USA	0
9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:20:49	2005-11-30 19:20:49	1	beth_id	1	Carnes-Potts Construction Partners	\N	Consulting	Construction	\N	\N	8335 Elm Rd.	Camacho	Zacatecas	99678	Mexico	\N	\N	569-555-5225	\N	\N	\N	www.carnes-pottsconstructionpartners.com	\N	\N	\N	\N	8335 Elm Rd.	Camacho	Zacatecas	99678	Mexico	0
d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:20:49	2005-11-30 19:20:49	1	sally_id	1	D & D Kozlowski Transportation, Ltd	\N	Distribution	Transportation	\N	\N	8121 Larkin Dr.	Merida	Yucatan	27943	Mexico	\N	\N	819-555-2604	\N	\N	\N	www.ddkozlowskitransportation,ltd.com	\N	\N	\N	\N	8121 Larkin Dr.	Merida	Yucatan	27943	Mexico	0
bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:20:50	2005-11-30 19:20:50	1	kristen_id	1	Kozlowski-Looney Machinery, Inc	\N	Consulting	Machinery	\N	\N	6199 McElroy	Chula Vista	CA	19313	USA	\N	\N	915-555-9211	\N	\N	\N	www.kozlowski-looneymachinery,inc.com	\N	\N	\N	\N	6199 McElroy	Chula Vista	CA	19313	USA	0
3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:20:50	2005-11-30 19:20:50	1	beth_id	1	E & M Magenheimer Electronics Company	\N	Supply	Electronics	\N	\N	6239 Boyd Road	Bellflower	CA	86589	USA	\N	\N	288-555-5218	\N	\N	\N	www.emmagenheimerelectronicscompany.com	\N	\N	\N	\N	6239 Boyd Road	Bellflower	CA	86589	USA	0
73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:20:50	2005-11-30 19:20:50	1	matt_id	1	Magenheimer-Hofsetz Engineering, Ltd	\N	Distribution	Engineering	\N	\N	7226 Casa Real	La Jolla	CA	42977	USA	\N	\N	646-555-5111	\N	\N	\N	www.magenheimer-hofsetzengineering,ltd.com	\N	\N	\N	\N	7226 Casa Real	La Jolla	CA	42977	USA	0
a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:20:50	2005-11-30 19:20:50	1	matt_id	1	R & Z Gilliat Communications, Inc	\N	Distribution	Communications	\N	\N	177 Bancroft Road	Marysville	WA	76415	USA	\N	\N	408-555-4801	\N	\N	\N	www.rzgilliatcommunications,inc.com	\N	\N	\N	\N	177 Bancroft Road	Marysville	WA	76415	USA	0
d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:20:50	2005-11-30 19:20:50	1	chris_id	1	Gilliat-Wojcik Machinery Partners	\N	Supply	Machinery	\N	\N	8762 Kiska Court	Cliffside	BC	97964	Canada	\N	\N	789-555-3323	\N	\N	\N	www.gilliat-wojcikmachinerypartners.com	\N	\N	\N	\N	8762 Kiska Court	Cliffside	BC	97964	Canada	0
2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:20:51	2005-11-30 19:20:51	1	sarah_id	1	J & K Wolf Communications Corp	\N	Supply	Communications	\N	\N	1967 Glen Court	Albany	OR	97563	USA	\N	\N	685-555-3902	\N	\N	\N	www.jkwolfcommunicationscorp.com	\N	\N	\N	\N	1967 Glen Court	Albany	OR	97563	USA	0
60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:20:51	2005-11-30 19:20:51	1	sally_id	1	Wolf-Whitworth Construction, Ltd	\N	Supply	Construction	\N	\N	3462 Briarcliff Ct.	Bellflower	CA	85275	USA	\N	\N	189-555-1051	\N	\N	\N	www.wolf-whitworthconstruction,ltd.com	\N	\N	\N	\N	3462 Briarcliff Ct.	Bellflower	CA	85275	USA	0
98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:20:51	2005-11-30 19:20:51	1	max_id	1	W & W Thames Electronics Associates	\N	Supply	Electronics	\N	\N	9576 Pepperidge Place	Langley	BC	51036	Canada	\N	\N	769-555-5601	\N	\N	\N	www.wwthameselectronicsassociates.com	\N	\N	\N	\N	9576 Pepperidge Place	Langley	BC	51036	Canada	0
d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:20:51	2005-11-30 19:20:51	1	max_id	1	Thames-Rusek Machinery Group	\N	Manufacturing	Machinery	\N	\N	1326 Greenwood Place	Palo Alto	CA	49095	USA	\N	\N	535-555-5037	\N	\N	\N	www.thames-rusekmachinerygroup.com	\N	\N	\N	\N	1326 Greenwood Place	Palo Alto	CA	49095	USA	0
1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:20:52	2005-11-30 19:20:52	1	beth_id	1	D & G Justice Transportation, Inc	\N	Distribution	Transportation	\N	\N	7694 Furness Street	Burlingame	CA	35831	USA	\N	\N	477-555-2873	\N	\N	\N	www.dgjusticetransportation,inc.com	\N	\N	\N	\N	7694 Furness Street	Burlingame	CA	35831	USA	0
5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:20:52	2005-11-30 19:20:52	1	matt_id	1	Justice-Conner Engineering, Ltd	\N	Supply	Engineering	\N	\N	2354 Pear Dr.	Pomona	CA	53540	USA	\N	\N	266-555-9937	\N	\N	\N	www.justice-connerengineering,ltd.com	\N	\N	\N	\N	2354 Pear Dr.	Pomona	CA	53540	USA	0
90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:20:52	2005-11-30 19:20:52	1	jaime_id	1	Z & L Bauer Construction, Ltd	\N	Supply	Construction	\N	\N	8976 E Leland	Camacho	Zacatecas	24333	Mexico	\N	\N	231-555-6401	\N	\N	\N	www.zlbauerconstruction,ltd.com	\N	\N	\N	\N	8976 E Leland	Camacho	Zacatecas	24333	Mexico	0
c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:20:52	2005-11-30 19:20:52	1	will_id	1	Bauer-Collins Transportation Group	\N	Manufacturing	Transportation	\N	\N	3890 El Camino Drive	Spokane	WA	95286	USA	\N	\N	942-555-3094	\N	\N	\N	www.bauer-collinstransportationgroup.com	\N	\N	\N	\N	3890 El Camino Drive	Spokane	WA	95286	USA	0
23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:20:53	2005-11-30 19:20:53	1	max_id	1	V & P Smith Transportation Corp	\N	Consulting	Transportation	\N	\N	3422 Meadowvale Court	El Cajon	CA	45481	USA	\N	\N	269-555-1844	\N	\N	\N	www.vpsmithtransportationcorp.com	\N	\N	\N	\N	3422 Meadowvale Court	El Cajon	CA	45481	USA	0
44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:20:53	2005-11-30 19:20:53	1	will_id	1	Smith-Yasi Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	1245 West Hookston Road	San Jose	CA	95838	USA	\N	\N	343-555-9823	\N	\N	\N	www.smith-yasitelecommunications,inc.com	\N	\N	\N	\N	1245 West Hookston Road	San Jose	CA	95838	USA	0
81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:20:53	2005-11-30 19:20:53	1	matt_id	1	F & X Bowman Communications Partners	\N	Consulting	Communications	\N	\N	1032 Buena Vista	San Jose	CA	97953	USA	\N	\N	593-555-7201	\N	\N	\N	www.fxbowmancommunicationspartners.com	\N	\N	\N	\N	1032 Buena Vista	San Jose	CA	97953	USA	0
b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:20:53	2005-11-30 19:20:53	1	sally_id	1	Bowman-Germanson Communications Holdings	\N	Distribution	Communications	\N	\N	6453 Coggins Drive	San Jose	CA	88180	USA	\N	\N	801-555-7068	\N	\N	\N	www.bowman-germansoncommunicationsholdings.com	\N	\N	\N	\N	6453 Coggins Drive	San Jose	CA	88180	USA	0
eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:20:53	2005-11-30 19:20:53	1	sarah_id	1	S & X Smith Engineering Partners	\N	Distribution	Engineering	\N	\N	9149 San Simeon Drive	San Francisco	CA	56456	USA	\N	\N	174-555-3075	\N	\N	\N	www.sxsmithengineeringpartners.com	\N	\N	\N	\N	9149 San Simeon Drive	San Francisco	CA	56456	USA	0
2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:20:54	2005-11-30 19:20:54	1	sarah_id	1	Smith-Serventi Transportation, Inc	\N	Supply	Transportation	\N	\N	7480 Linton Terr	Newport Beach	CA	39137	USA	\N	\N	532-555-2968	\N	\N	\N	www.smith-serventitransportation,inc.com	\N	\N	\N	\N	7480 Linton Terr	Newport Beach	CA	39137	USA	0
60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:20:54	2005-11-30 19:20:54	1	sarah_id	1	H & N Chapla Machinery Corp	\N	Supply	Machinery	\N	\N	431 Riverside Drive	Haney	BC	72574	Canada	\N	\N	166-555-1261	\N	\N	\N	www.hnchaplamachinerycorp.com	\N	\N	\N	\N	431 Riverside Drive	Haney	BC	72574	Canada	0
9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:20:54	2005-11-30 19:20:54	1	will_id	1	Chapla-Cameron Machinery Associates	\N	Supply	Machinery	\N	\N	1673 Buena Vista	Victoria	BC	94124	Canada	\N	\N	308-555-5125	\N	\N	\N	www.chapla-cameronmachineryassociates.com	\N	\N	\N	\N	1673 Buena Vista	Victoria	BC	94124	Canada	0
cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:20:54	2005-11-30 19:20:54	1	max_id	1	G & W Zgeirmann Transportation, Inc	\N	Distribution	Transportation	\N	\N	4877 Zona Rosa	Marysville	WA	93723	USA	\N	\N	205-555-5704	\N	\N	\N	www.gwzgeirmanntransportation,inc.com	\N	\N	\N	\N	4877 Zona Rosa	Marysville	WA	93723	USA	0
1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:20:55	2005-11-30 19:20:55	1	matt_id	1	Zgeirmann-Mondragon Machinery Corp	\N	Manufacturing	Machinery	\N	\N	1061 Delta Fair Blvd.	Milwaukie	OR	81434	USA	\N	\N	609-555-2854	\N	\N	\N	www.zgeirmann-mondragonmachinerycorp.com	\N	\N	\N	\N	1061 Delta Fair Blvd.	Milwaukie	OR	81434	USA	0
4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:20:55	2005-11-30 19:20:55	1	beth_id	1	V & B Allison Transportation Holdings	\N	Supply	Transportation	\N	\N	4519 Sequoia Drive	Shawnee	BC	47196	Canada	\N	\N	289-555-7404	\N	\N	\N	www.vballisontransportationholdings.com	\N	\N	\N	\N	4519 Sequoia Drive	Shawnee	BC	47196	Canada	0
7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:20:55	2005-11-30 19:20:55	1	beth_id	1	Allison-Vargas Construction Company	\N	Consulting	Construction	\N	\N	8924 Lindley Ct.	San Gabriel	CA	10695	USA	\N	\N	955-555-6840	\N	\N	\N	www.allison-vargasconstructioncompany.com	\N	\N	\N	\N	8924 Lindley Ct.	San Gabriel	CA	10695	USA	0
b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:20:55	2005-11-30 19:20:55	1	max_id	1	C & A Vlass Engineering Group	\N	Supply	Engineering	\N	\N	5293 Juliet Court	Glendale	CA	56995	USA	\N	\N	897-555-4676	\N	\N	\N	www.cavlassengineeringgroup.com	\N	\N	\N	\N	5293 Juliet Court	Glendale	CA	56995	USA	0
304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:20:56	2005-11-30 19:20:56	1	kristen_id	1	Vlass-Gonzalez Construction, Ltd	\N	Consulting	Construction	\N	\N	7296 Seawind Dr.	Burlingame	CA	69533	USA	\N	\N	686-555-2740	\N	\N	\N	www.vlass-gonzalezconstruction,ltd.com	\N	\N	\N	\N	7296 Seawind Dr.	Burlingame	CA	69533	USA	0
3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:20:56	2005-11-30 19:20:56	1	chris_id	1	U & S Ison Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	6574 Hemlock Ave.	National City	CA	40325	USA	\N	\N	651-555-8204	\N	\N	\N	www.usisontransportation,inc.com	\N	\N	\N	\N	6574 Hemlock Ave.	National City	CA	40325	USA	0
751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:20:56	2005-11-30 19:20:56	1	will_id	1	Ison-Trent Construction Group	\N	Distribution	Construction	\N	\N	1488 Cambelback Place	Pomona	CA	25521	USA	\N	\N	152-555-5472	\N	\N	\N	www.ison-trentconstructiongroup.com	\N	\N	\N	\N	1488 Cambelback Place	Pomona	CA	25521	USA	0
a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:20:56	2005-11-30 19:20:56	1	sarah_id	1	N & W Vaca Transportation Corp	\N	Distribution	Transportation	\N	\N	8364 Pepper Drive	N. Vancouver	BC	87766	Canada	\N	\N	379-555-4222	\N	\N	\N	www.nwvacatransportationcorp.com	\N	\N	\N	\N	8364 Pepper Drive	N. Vancouver	BC	87766	Canada	0
e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:20:56	2005-11-30 19:20:56	1	matt_id	1	Vaca-Arbelaez Engineering Partners	\N	Supply	Engineering	\N	\N	6187 Barquentine Court	Chula Vista	CA	12832	USA	\N	\N	453-555-3200	\N	\N	\N	www.vaca-arbelaezengineeringpartners.com	\N	\N	\N	\N	6187 Barquentine Court	Chula Vista	CA	12832	USA	0
2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:20:57	2005-11-30 19:20:57	1	sarah_id	1	O & D Lee Communications Associates	\N	Distribution	Communications	\N	\N	5974 N St.	Lemon Grove	CA	14947	USA	\N	\N	703-555-9579	\N	\N	\N	www.odleecommunicationsassociates.com	\N	\N	\N	\N	5974 N St.	Lemon Grove	CA	14947	USA	0
622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:20:57	2005-11-30 19:20:57	1	sally_id	1	Lee-Maes Transportation Company	\N	Consulting	Transportation	\N	\N	4051 Athene Drive	Tixapan	DF	31465	Mexico	\N	\N	799-555-7186	\N	\N	\N	www.lee-maestransportationcompany.com	\N	\N	\N	\N	4051 Athene Drive	Tixapan	DF	31465	Mexico	0
9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:20:57	2005-11-30 19:20:57	1	sally_id	1	M & Y Antrim Communications, Ltd	\N	Supply	Communications	\N	\N	4092 Tupelp Drive	Woodburn	OR	98741	USA	\N	\N	172-555-3193	\N	\N	\N	www.myantrimcommunications,ltd.com	\N	\N	\N	\N	4092 Tupelp Drive	Woodburn	OR	98741	USA	0
cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:20:57	2005-11-30 19:20:57	1	beth_id	1	Antrim-Friedland Communications Associates	\N	Consulting	Communications	\N	\N	5079 Notre Dame Avenue	Redmond	WA	81421	USA	\N	\N	530-555-3086	\N	\N	\N	www.antrim-friedlandcommunicationsassociates.com	\N	\N	\N	\N	5079 Notre Dame Avenue	Redmond	WA	81421	USA	0
fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:20:58	2005-11-30 19:20:58	1	max_id	1	B & D Strange Machinery Partners	\N	Consulting	Machinery	\N	\N	5373 Summerfield Dr	Orizaba	Veracruz	88567	Mexico	\N	\N	164-555-1379	\N	\N	\N	www.bdstrangemachinerypartners.com	\N	\N	\N	\N	5373 Summerfield Dr	Orizaba	Veracruz	88567	Mexico	0
4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:20:58	2005-11-30 19:20:58	1	sarah_id	1	Strange-Richter Construction Partners	\N	Manufacturing	Construction	\N	\N	6615 Winterglenn Way	Redwood City	CA	37409	USA	\N	\N	545-555-8901	\N	\N	\N	www.strange-richterconstructionpartners.com	\N	\N	\N	\N	6615 Winterglenn Way	Redwood City	CA	37409	USA	0
8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:20:58	2005-11-30 19:20:58	1	kristen_id	1	H & E Amland Machinery Group	\N	Supply	Machinery	\N	\N	9819 Sunsine Drive	Chula Vista	CA	10717	USA	\N	\N	203-555-5822	\N	\N	\N	www.heamlandmachinerygroup.com	\N	\N	\N	\N	9819 Sunsine Drive	Chula Vista	CA	10717	USA	0
baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:20:58	2005-11-30 19:20:58	1	beth_id	1	Amland-Albury Electronics Holdings	\N	Supply	Electronics	\N	\N	1315 Union St	Shawnee	BC	24720	Canada	\N	\N	606-555-2972	\N	\N	\N	www.amland-alburyelectronicsholdings.com	\N	\N	\N	\N	1315 Union St	Shawnee	BC	24720	Canada	0
f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:20:58	2005-11-30 19:20:58	1	max_id	1	X & M Richmeier Construction Corp	\N	Manufacturing	Construction	\N	\N	7429 La Cadena	Milwaukie	OR	63188	USA	\N	\N	526-555-2179	\N	\N	\N	www.xmrichmeierconstructioncorp.com	\N	\N	\N	\N	7429 La Cadena	Milwaukie	OR	63188	USA	0
504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:20:59	2005-11-30 19:20:59	1	sally_id	1	Richmeier-Jacobson Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	9178 Thornhill Place	Westminster	BC	17061	Canada	\N	\N	165-555-9217	\N	\N	\N	www.richmeier-jacobsontelecommunications,ltd.com	\N	\N	\N	\N	9178 Thornhill Place	Westminster	BC	17061	Canada	0
849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:20:59	2005-11-30 19:20:59	1	chris_id	1	I & M Bartness Transportation, Ltd	\N	Supply	Transportation	\N	\N	5547 Montoya	Tixapan	DF	47984	Mexico	\N	\N	107-555-7053	\N	\N	\N	www.imbartnesstransportation,ltd.com	\N	\N	\N	\N	5547 Montoya	Tixapan	DF	47984	Mexico	0
c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:20:59	2005-11-30 19:20:59	1	will_id	1	Bartness-Cobb Electronics Corp	\N	Manufacturing	Electronics	\N	\N	206 Kirkwood Ct.	Grossmont	CA	67018	USA	\N	\N	796-555-5117	\N	\N	\N	www.bartness-cobbelectronicscorp.com	\N	\N	\N	\N	206 Kirkwood Ct.	Grossmont	CA	67018	USA	0
36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:21:00	2005-11-30 19:21:00	1	kristen_id	1	H & Y Lique Engineering, Inc	\N	Distribution	Engineering	\N	\N	6828 Ashwood Drive	Richmond	BC	38225	Canada	\N	\N	761-555-1582	\N	\N	\N	www.hyliqueengineering,inc.com	\N	\N	\N	\N	6828 Ashwood Drive	Richmond	BC	38225	Canada	0
45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:21:00	2005-11-30 19:21:00	1	jaime_id	1	Lique-Bernacchi Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	1742 Shakespeare Drive	Albany	OR	23421	USA	\N	\N	811-555-1932	\N	\N	\N	www.lique-bernacchitelecommunications,ltd.com	\N	\N	\N	\N	1742 Shakespeare Drive	Albany	OR	23421	USA	0
80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:21:00	2005-11-30 19:21:00	1	sally_id	1	D & A Zubaty Machinery Group	\N	Manufacturing	Machinery	\N	\N	1274 Frisbie Ct.	Anacortes	WA	59374	USA	\N	\N	799-555-6024	\N	\N	\N	www.dazubatymachinerygroup.com	\N	\N	\N	\N	1274 Frisbie Ct.	Anacortes	WA	59374	USA	0
ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:21:00	2005-11-30 19:21:00	1	max_id	1	Zubaty-Hunter Construction Associates	\N	Consulting	Construction	\N	\N	6441 Roberta Avenue	Salem	OR	10732	USA	\N	\N	872-555-5003	\N	\N	\N	www.zubaty-hunterconstructionassociates.com	\N	\N	\N	\N	6441 Roberta Avenue	Salem	OR	10732	USA	0
ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:21:01	2005-11-30 19:21:01	1	max_id	1	D & Z Vonholt Electronics, Ltd	\N	Consulting	Electronics	\N	\N	6228 Palm Avenue	Langford	BC	12847	Canada	\N	\N	222-555-2382	\N	\N	\N	www.dzvonholtelectronics,ltd.com	\N	\N	\N	\N	6228 Palm Avenue	Langford	BC	12847	Canada	0
3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:21:01	2005-11-30 19:21:01	1	kristen_id	1	Vonholt-Holmes Engineering Corp	\N	Consulting	Engineering	\N	\N	4305 Madrid	National City	CA	29365	USA	\N	\N	319-555-8989	\N	\N	\N	www.vonholt-holmesengineeringcorp.com	\N	\N	\N	\N	4305 Madrid	National City	CA	29365	USA	0
838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:21:01	2005-11-30 19:21:01	1	will_id	1	Q & Q Drury Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	7001 Mills Dr.	Arcadia	CA	96641	USA	\N	\N	830-555-8653	\N	\N	\N	www.qqdrurytelecommunicationsassociates.com	\N	\N	\N	\N	7001 Mills Dr.	Arcadia	CA	96641	USA	0
c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:21:01	2005-11-30 19:21:01	1	max_id	1	Drury-Watts Engineering Company	\N	Manufacturing	Engineering	\N	\N	5333 Adria Drive	San Francisco	CA	53029	USA	\N	\N	949-555-4889	\N	\N	\N	www.drury-wattsengineeringcompany.com	\N	\N	\N	\N	5333 Adria Drive	San Francisco	CA	53029	USA	0
a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:21:02	2005-11-30 19:21:02	1	matt_id	1	Y & R Short Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	9529 Oonegal Court	Richmond	CA	86467	USA	\N	\N	584-555-3182	\N	\N	\N	www.yrshortmachinery,inc.com	\N	\N	\N	\N	9529 Oonegal Court	Richmond	CA	86467	USA	0
5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:21:02	2005-11-30 19:21:02	1	sarah_id	1	Short-Mc Guigan Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	8115 Royal Links Ct	Lakewood	CA	90175	USA	\N	\N	965-555-1703	\N	\N	\N	www.short-mcguiganengineering,inc.com	\N	\N	\N	\N	8115 Royal Links Ct	Lakewood	CA	90175	USA	0
9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:21:02	2005-11-30 19:21:02	1	kristen_id	1	E & F Wollesen Machinery, Ltd	\N	Consulting	Machinery	\N	\N	1320 Pacheco St	W. Linn	OR	86173	USA	\N	\N	976-555-4463	\N	\N	\N	www.efwollesenmachinery,ltd.com	\N	\N	\N	\N	1320 Pacheco St	W. Linn	OR	86173	USA	0
dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:21:02	2005-11-30 19:21:02	1	chris_id	1	Wollesen-Lee Transportation Holdings	\N	Distribution	Transportation	\N	\N	2815 Piper Ridge Court	Altadena	CA	95327	USA	\N	\N	480-555-1613	\N	\N	\N	www.wollesen-leetransportationholdings.com	\N	\N	\N	\N	2815 Piper Ridge Court	Altadena	CA	95327	USA	0
340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:21:03	2005-11-30 19:21:03	1	will_id	1	N & O Gimmi Electronics, Inc	\N	Supply	Electronics	\N	\N	8929 Dayton Court	Yakima	WA	61088	USA	\N	\N	400-555-9820	\N	\N	\N	www.nogimmielectronics,inc.com	\N	\N	\N	\N	8929 Dayton Court	Yakima	WA	61088	USA	0
70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:21:03	2005-11-30 19:21:03	1	kristen_id	1	Gimmi-Pugh Machinery Group	\N	Distribution	Machinery	\N	\N	679 Pepperidge Way	Berkeley	CA	14962	USA	\N	\N	826-555-5598	\N	\N	\N	www.gimmi-pughmachinerygroup.com	\N	\N	\N	\N	679 Pepperidge Way	Berkeley	CA	14962	USA	0
a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:21:03	2005-11-30 19:21:03	1	beth_id	1	U & W Bennetts Construction Corp	\N	Supply	Construction	\N	\N	7047 Terra Granda	San Jose	CA	19592	USA	\N	\N	768-555-3434	\N	\N	\N	www.uwbennettsconstructioncorp.com	\N	\N	\N	\N	7047 Terra Granda	San Jose	CA	19592	USA	0
e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:21:03	2005-11-30 19:21:03	1	max_id	1	Bennetts-Woodard Electronics Company	\N	Consulting	Electronics	\N	\N	1707 Willowwood Ct.	Torrance	CA	38626	USA	\N	\N	557-555-1499	\N	\N	\N	www.bennetts-woodardelectronicscompany.com	\N	\N	\N	\N	1707 Willowwood Ct.	Torrance	CA	38626	USA	0
20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:21:04	2005-11-30 19:21:04	1	chris_id	1	M & K Manzanares Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	8328 San Francisco	Portland	OR	35710	USA	\N	\N	522-555-6963	\N	\N	\N	www.mkmanzanarestelecommunications,ltd.com	\N	\N	\N	\N	8328 San Francisco	Portland	OR	35710	USA	0
70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:21:04	2005-11-30 19:21:04	1	sarah_id	1	Manzanares-Stotler Machinery, Ltd	\N	Consulting	Machinery	\N	\N	5898 Mt. Dell	Marysville	WA	90383	USA	\N	\N	573-555-7313	\N	\N	\N	www.manzanares-stotlermachinery,ltd.com	\N	\N	\N	\N	5898 Mt. Dell	Marysville	WA	90383	USA	0
a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:21:04	2005-11-30 19:21:04	1	beth_id	1	L & E Peoples Communications Partners	\N	Distribution	Communications	\N	\N	2775 Bonifacio Street	La Mesa	CA	27337	USA	\N	\N	561-555-2406	\N	\N	\N	www.lepeoplescommunicationspartners.com	\N	\N	\N	\N	2775 Bonifacio Street	La Mesa	CA	27337	USA	0
e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:21:04	2005-11-30 19:21:04	1	sally_id	1	Peoples-Choi Construction Holdings	\N	Consulting	Construction	\N	\N	598 Marfargoa Drive	Fremont	CA	77694	USA	\N	\N	634-555-1384	\N	\N	\N	www.peoples-choiconstructionholdings.com	\N	\N	\N	\N	598 Marfargoa Drive	Fremont	CA	77694	USA	0
2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:21:05	2005-11-30 19:21:05	1	kristen_id	1	W & N Quintana Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	385 Joan Ave	Fremont	CA	79809	USA	\N	\N	884-555-7763	\N	\N	\N	www.wnquintanatelecommunicationspartners.com	\N	\N	\N	\N	385 Joan Ave	Fremont	CA	79809	USA	0
71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:21:05	2005-11-30 19:21:05	1	sally_id	1	Quintana-Bright Transportation Holdings	\N	Consulting	Transportation	\N	\N	8461 Lodge Drive	Issaquah	WA	70035	USA	\N	\N	980-555-5370	\N	\N	\N	www.quintana-brighttransportationholdings.com	\N	\N	\N	\N	8461 Lodge Drive	Issaquah	WA	70035	USA	0
c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:21:05	2005-11-30 19:21:05	1	beth_id	1	V & A Rodgers Transportation Corp	\N	Consulting	Transportation	\N	\N	8502 Bates Court	Hidalgo	Zacatecas	38312	Mexico	\N	\N	943-555-1952	\N	\N	\N	www.varodgerstransportationcorp.com	\N	\N	\N	\N	8502 Bates Court	Hidalgo	Zacatecas	38312	Mexico	0
10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:21:06	2005-11-30 19:21:06	1	max_id	1	Rodgers-Gates Communications Corp	\N	Consulting	Communications	\N	\N	6833 Filomena	Edmonds	WA	20992	USA	\N	\N	162-555-7187	\N	\N	\N	www.rodgers-gatescommunicationscorp.com	\N	\N	\N	\N	6833 Filomena	Edmonds	WA	20992	USA	0
6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:21:06	2005-11-30 19:21:06	1	sally_id	1	T & A Watkins Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	9783 Amaranth Way	Walla Walla	WA	54430	USA	\N	\N	697-555-5480	\N	\N	\N	www.tawatkinselectronics,inc.com	\N	\N	\N	\N	9783 Amaranth Way	Walla Walla	WA	54430	USA	0
9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:21:06	2005-11-30 19:21:06	1	matt_id	1	Watkins-Christensen Construction Associates	\N	Manufacturing	Construction	\N	\N	1025 Holly Oak Drive	Santa Fe	DF	75979	Mexico	\N	\N	178-555-4002	\N	\N	\N	www.watkins-christensenconstructionassociates.com	\N	\N	\N	\N	1025 Holly Oak Drive	Santa Fe	DF	75979	Mexico	0
e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:21:06	2005-11-30 19:21:06	1	chris_id	1	D & D Banks Electronics Holdings	\N	Supply	Electronics	\N	\N	4230 Falcon Place	San Andres	DF	75579	Mexico	\N	\N	735-555-9923	\N	\N	\N	www.ddbankselectronicsholdings.com	\N	\N	\N	\N	4230 Falcon Place	San Andres	DF	75579	Mexico	0
1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:21:07	2005-11-30 19:21:07	1	sarah_id	1	Banks-Carlisle Machinery, Inc	\N	Distribution	Machinery	\N	\N	5725 Glazier Drive	Yakima	WA	63290	USA	\N	\N	239-555-7073	\N	\N	\N	www.banks-carlislemachinery,inc.com	\N	\N	\N	\N	5725 Glazier Drive	Yakima	WA	63290	USA	0
59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:21:07	2005-11-30 19:21:07	1	sally_id	1	I & V Tramel Engineering, Inc	\N	Distribution	Engineering	\N	\N	9183 Via Del Sol	Issaquah	WA	27592	USA	\N	\N	158-555-6280	\N	\N	\N	www.ivtramelengineering,inc.com	\N	\N	\N	\N	9183 Via Del Sol	Issaquah	WA	27592	USA	0
96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:21:07	2005-11-30 19:21:07	1	beth_id	1	Tramel-Curry Construction, Ltd	\N	Manufacturing	Construction	\N	\N	3589 G Street	Bremerton	WA	81923	USA	\N	\N	585-555-2059	\N	\N	\N	www.tramel-curryconstruction,ltd.com	\N	\N	\N	\N	3589 G Street	Bremerton	WA	81923	USA	0
dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:21:07	2005-11-30 19:21:07	1	matt_id	1	K & R Haines Communications Group	\N	Consulting	Communications	\N	\N	9956 McNeil Place	Bellingham	WA	86554	USA	\N	\N	527-555-8894	\N	\N	\N	www.krhainescommunicationsgroup.com	\N	\N	\N	\N	9956 McNeil Place	Bellingham	WA	86554	USA	0
2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:21:08	2005-11-30 19:21:08	1	jaime_id	1	Haines-Campbell Engineering Associates	\N	Distribution	Engineering	\N	\N	1961 Oak Grove Road	Beaverton	OR	65893	USA	\N	\N	316-555-6959	\N	\N	\N	www.haines-campbellengineeringassociates.com	\N	\N	\N	\N	1961 Oak Grove Road	Beaverton	OR	65893	USA	0
5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:21:08	2005-11-30 19:21:08	1	max_id	1	B & P Whitney Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	1239 Linnet Court	La Jolla	CA	76380	USA	\N	\N	520-555-7080	\N	\N	\N	www.bpwhitneytelecommunicationsholdings.com	\N	\N	\N	\N	1239 Linnet Court	La Jolla	CA	76380	USA	0
9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:21:08	2005-11-30 19:21:08	1	kristen_id	1	Whitney-Mitchell Electronics, Ltd	\N	Distribution	Electronics	\N	\N	6152 Del Mar Ave	Imperial Beach	CA	61576	USA	\N	\N	331-555-3773	\N	\N	\N	www.whitney-mitchellelectronics,ltd.com	\N	\N	\N	\N	6152 Del Mar Ave	Imperial Beach	CA	61576	USA	0
e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:21:08	2005-11-30 19:21:08	1	chris_id	1	Q & P Dodd Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	5684 San Marino Ct.	Burnaby	BC	96204	Canada	\N	\N	910-555-8441	\N	\N	\N	www.qpdoddtelecommunicationscompany.com	\N	\N	\N	\N	5684 San Marino Ct.	Burnaby	BC	96204	Canada	0
20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:21:09	2005-11-30 19:21:09	1	beth_id	1	Dodd-Cereghino Transportation Holdings	\N	Consulting	Transportation	\N	\N	852 Santa Maria	Coronado	CA	47561	USA	\N	\N	744-555-3762	\N	\N	\N	www.dodd-cereghinotransportationholdings.com	\N	\N	\N	\N	852 Santa Maria	Coronado	CA	47561	USA	0
5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:21:09	2005-11-30 19:21:09	1	kristen_id	1	G & N Meyer Communications Group	\N	Supply	Communications	\N	\N	639 Bermad Drive	San Diego	CA	49676	USA	\N	\N	994-555-1140	\N	\N	\N	www.gnmeyercommunicationsgroup.com	\N	\N	\N	\N	639 Bermad Drive	San Diego	CA	49676	USA	0
9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:21:09	2005-11-30 19:21:09	1	kristen_id	1	Meyer-Stevens Construction Partners	\N	Distribution	Construction	\N	\N	4650 Carlos Dr.	Langford	BC	66195	Canada	\N	\N	190-555-7747	\N	\N	\N	www.meyer-stevensconstructionpartners.com	\N	\N	\N	\N	4650 Carlos Dr.	Langford	BC	66195	Canada	0
caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:21:09	2005-11-30 19:21:09	1	kristen_id	1	H & Y Campbell Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	4691 Frisbie Court	Berkeley	CA	34472	USA	\N	\N	702-555-7412	\N	\N	\N	www.hycampbellelectronics,ltd.com	\N	\N	\N	\N	4691 Frisbie Court	Berkeley	CA	34472	USA	0
1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:21:10	2005-11-30 19:21:10	1	chris_id	1	Campbell-Walker Transportation Holdings	\N	Supply	Transportation	\N	\N	5678 Arlington Way	Imperial Beach	CA	89859	USA	\N	\N	821-555-3648	\N	\N	\N	www.campbell-walkertransportationholdings.com	\N	\N	\N	\N	5678 Arlington Way	Imperial Beach	CA	89859	USA	0
736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:21:10	2005-11-30 19:21:10	1	sarah_id	1	O & K Pasumansky Transportation Corp	\N	Manufacturing	Transportation	\N	\N	5972 El Pintado Road	Redmond	WA	24298	USA	\N	\N	456-555-1940	\N	\N	\N	www.okpasumanskytransportationcorp.com	\N	\N	\N	\N	5972 El Pintado Road	Redmond	WA	24298	USA	0
a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:21:10	2005-11-30 19:21:10	1	beth_id	1	Pasumansky-Whitney Construction Partners	\N	Consulting	Construction	\N	\N	7214 Peachwillow	Santa Cruz	CA	72139	USA	\N	\N	836-555-9462	\N	\N	\N	www.pasumansky-whitneyconstructionpartners.com	\N	\N	\N	\N	7214 Peachwillow	Santa Cruz	CA	72139	USA	0
dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:21:10	2005-11-30 19:21:10	1	sally_id	1	D & D Saunders Transportation, Ltd	\N	Distribution	Transportation	\N	\N	419 Mills Dr.	Coronado	CA	45447	USA	\N	\N	494-555-6383	\N	\N	\N	www.ddsaunderstransportation,ltd.com	\N	\N	\N	\N	419 Mills Dr.	Coronado	CA	45447	USA	0
4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:21:11	2005-11-30 19:21:11	1	kristen_id	1	Saunders-Vandenouer Machinery, Inc	\N	Consulting	Machinery	\N	\N	1914 N Lucile Lane	Royal Oak	BC	59450	Canada	\N	\N	898-555-3533	\N	\N	\N	www.saunders-vandenouermachinery,inc.com	\N	\N	\N	\N	1914 N Lucile Lane	Royal Oak	BC	59450	Canada	0
82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:21:11	2005-11-30 19:21:11	1	beth_id	1	E & M Vincenzi Electronics Company	\N	Supply	Electronics	\N	\N	8028 39th Avenue	Daly City	CA	97918	USA	\N	\N	817-555-2740	\N	\N	\N	www.emvincenzielectronicscompany.com	\N	\N	\N	\N	8028 39th Avenue	Daly City	CA	97918	USA	0
bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:21:11	2005-11-30 19:21:11	1	matt_id	1	Vincenzi-Herring Engineering, Ltd	\N	Distribution	Engineering	\N	\N	9777 Mozden Lane	Puyallup	WA	51791	USA	\N	\N	344-555-7519	\N	\N	\N	www.vincenzi-herringengineering,ltd.com	\N	\N	\N	\N	9777 Mozden Lane	Puyallup	WA	51791	USA	0
98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:21:12	2005-11-30 19:21:12	1	matt_id	1	R & Z Garza Communications, Inc	\N	Distribution	Communications	\N	\N	6146 Schenone Court	Yakima	WA	82714	USA	\N	\N	286-555-5355	\N	\N	\N	www.rzgarzacommunications,inc.com	\N	\N	\N	\N	6146 Schenone Court	Yakima	WA	82714	USA	0
3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:21:12	2005-11-30 19:21:12	1	chris_id	1	Garza-Westover Machinery Partners	\N	Supply	Machinery	\N	\N	805 Willow Lane	Palo Alto	CA	2748	USA	\N	\N	426-555-9336	\N	\N	\N	www.garza-westovermachinerypartners.com	\N	\N	\N	\N	805 Willow Lane	Palo Alto	CA	2748	USA	0
7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:21:12	2005-11-30 19:21:12	1	sarah_id	1	J & K Hagemann Communications Corp	\N	Supply	Communications	\N	\N	7427 Terra Catalina	Victoria	BC	72540	Canada	\N	\N	630-555-9458	\N	\N	\N	www.jkhagemanncommunicationscorp.com	\N	\N	\N	\N	7427 Terra Catalina	Victoria	BC	72540	Canada	0
ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:21:12	2005-11-30 19:21:12	1	sally_id	1	Hagemann-Vasquez Construction, Ltd	\N	Supply	Construction	\N	\N	2341 Lindley Ct	Beaverton	OR	57735	USA	\N	\N	441-555-6151	\N	\N	\N	www.hagemann-vasquezconstruction,ltd.com	\N	\N	\N	\N	2341 Lindley Ct	Beaverton	OR	57735	USA	0
db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:21:12	2005-11-30 19:21:12	1	max_id	1	W & W McCarthy Electronics Associates	\N	Supply	Electronics	\N	\N	1874 Royal Links Circle	Cliffside	BC	93688	Canada	\N	\N	668-555-4901	\N	\N	\N	www.wwmccarthyelectronicsassociates.com	\N	\N	\N	\N	1874 Royal Links Circle	Cliffside	BC	93688	Canada	0
30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:21:13	2005-11-30 19:21:13	1	max_id	1	McCarthy-Bacalzo Machinery Group	\N	Manufacturing	Machinery	\N	\N	7040 Isabel Dr.	Beverly Hills	CA	89846	USA	\N	\N	503-555-9222	\N	\N	\N	www.mccarthy-bacalzomachinerygroup.com	\N	\N	\N	\N	7040 Isabel Dr.	Beverly Hills	CA	89846	USA	0
70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:21:13	2005-11-30 19:21:13	1	beth_id	1	D & G Berch Transportation, Inc	\N	Distribution	Transportation	\N	\N	6827 Glazier Dr.	Seattle	WA	91961	USA	\N	\N	753-555-6601	\N	\N	\N	www.dgberchtransportation,inc.com	\N	\N	\N	\N	6827 Glazier Dr.	Seattle	WA	91961	USA	0
a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:21:13	2005-11-30 19:21:13	1	matt_id	1	Berch-Taylor Engineering, Ltd	\N	Supply	Engineering	\N	\N	4904 Hillview Drive	La Jolla	CA	94813	USA	\N	\N	188-555-7865	\N	\N	\N	www.berch-taylorengineering,ltd.com	\N	\N	\N	\N	4904 Hillview Drive	La Jolla	CA	94813	USA	0
d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:21:13	2005-11-30 19:21:13	1	jaime_id	1	Z & L Whipple Construction, Ltd	\N	Supply	Construction	\N	\N	7600 Yosemite Circle	Lynnwood	WA	50464	USA	\N	\N	461-555-3872	\N	\N	\N	www.zlwhippleconstruction,ltd.com	\N	\N	\N	\N	7600 Yosemite Circle	Lynnwood	WA	50464	USA	0
1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:21:14	2005-11-30 19:21:14	1	will_id	1	Whipple-Laursen Transportation Group	\N	Manufacturing	Transportation	\N	\N	5932 Rainier Dr.	Hidalgo	Zacatecas	33145	Mexico	\N	\N	580-555-9108	\N	\N	\N	www.whipple-laursentransportationgroup.com	\N	\N	\N	\N	5932 Rainier Dr.	Hidalgo	Zacatecas	33145	Mexico	0
7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:21:14	2005-11-30 19:21:14	1	max_id	1	V & P Olguin Transportation Corp	\N	Consulting	Transportation	\N	\N	8882 Weatherly Way	Newport Beach	CA	66582	USA	\N	\N	214-555-7401	\N	\N	\N	www.vpolguintransportationcorp.com	\N	\N	\N	\N	8882 Weatherly Way	Newport Beach	CA	66582	USA	0
a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:21:14	2005-11-30 19:21:14	1	will_id	1	Olguin-Ayers Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	7468 Franklin Canyon Road	Sedro Woolley	WA	88132	USA	\N	\N	595-555-5922	\N	\N	\N	www.olguin-ayerstelecommunications,inc.com	\N	\N	\N	\N	7468 Franklin Canyon Road	Sedro Woolley	WA	88132	USA	0
d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:21:14	2005-11-30 19:21:14	1	matt_id	1	F & X Kotc Communications Partners	\N	Consulting	Communications	\N	\N	3328 Via Cortez	Long Beach	CA	87731	USA	\N	\N	253-555-2843	\N	\N	\N	www.fxkotccommunicationspartners.com	\N	\N	\N	\N	3328 Via Cortez	Long Beach	CA	87731	USA	0
3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:21:15	2005-11-30 19:21:15	1	sally_id	1	Kotc-Coriell Communications Holdings	\N	Distribution	Communications	\N	\N	4824 Discovery Bay	Beverly Hills	CA	75442	USA	\N	\N	783-555-1391	\N	\N	\N	www.kotc-coriellcommunicationsholdings.com	\N	\N	\N	\N	4824 Discovery Bay	Beverly Hills	CA	75442	USA	0
6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:21:15	2005-11-30 19:21:15	1	sarah_id	1	S & X Warthen Engineering Partners	\N	Distribution	Engineering	\N	\N	8282 Meadowbrook Court	Puyallup	WA	41204	USA	\N	\N	703-555-9598	\N	\N	\N	www.sxwarthenengineeringpartners.com	\N	\N	\N	\N	8282 Meadowbrook Court	Puyallup	WA	41204	USA	0
e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:21:15	2005-11-30 19:21:15	1	sarah_id	1	Warthen-Johnson Transportation, Inc	\N	Supply	Transportation	\N	\N	2687 Gilberto	La Jolla	CA	94076	USA	\N	\N	468-555-9034	\N	\N	\N	www.warthen-johnsontransportation,inc.com	\N	\N	\N	\N	2687 Gilberto	La Jolla	CA	94076	USA	0
1daf85c8-6874-a17b-17cb-438dfb55a65f	2005-11-30 19:21:16	2005-11-30 19:21:16	1	sarah_id	1	H & N Huckaby Machinery Corp	\N	Supply	Machinery	\N	\N	6400 Kenwal Rd.	Richmond	CA	98706	USA	\N	\N	411-555-6870	\N	\N	\N	www.hnhuckabymachinerycorp.com	\N	\N	\N	\N	6400 Kenwal Rd.	Richmond	CA	98706	USA	0
69ac166c-2b09-54c5-e12e-438dfb58be75	2005-11-30 19:21:16	2005-11-30 19:21:16	1	will_id	1	Huckaby-Gustafson Machinery Associates	\N	Supply	Machinery	\N	\N	1060 McElroy Court	Burbank	CA	18741	USA	\N	\N	860-555-1277	\N	\N	\N	www.huckaby-gustafsonmachineryassociates.com	\N	\N	\N	\N	1060 McElroy Court	Burbank	CA	18741	USA	0
c64ca1f4-971c-ba58-e3a6-438dfbe4e18a	2005-11-30 19:21:16	2005-11-30 19:21:16	1	max_id	1	G & W Thompson Transportation, Inc	\N	Distribution	Transportation	\N	\N	7681 Hillcrest	Port Hammond	BC	15825	Canada	\N	\N	164-555-1398	\N	\N	\N	www.gwthompsontransportation,inc.com	\N	\N	\N	\N	7681 Hillcrest	Port Hammond	BC	15825	Canada	0
2e151528-0941-acdb-9162-438dfb4fb878	2005-11-30 19:21:17	2005-11-30 19:21:17	1	matt_id	1	Thompson-Hendricks Machinery Corp	\N	Manufacturing	Machinery	\N	\N	5251 Canyon Road	Anacortes	WA	10214	USA	\N	\N	876-555-7091	\N	\N	\N	www.thompson-hendricksmachinerycorp.com	\N	\N	\N	\N	5251 Canyon Road	Anacortes	WA	10214	USA	0
7d77c5de-1ccb-a31f-2fa0-438dfb56e39b	2005-11-30 19:21:17	2005-11-30 19:21:17	1	beth_id	1	V & B Black Transportation Holdings	\N	Supply	Transportation	\N	\N	2128 Holland Drive.	Coronado	CA	36974	USA	\N	\N	203-555-5841	\N	\N	\N	www.vbblacktransportationholdings.com	\N	\N	\N	\N	2128 Holland Drive.	Coronado	CA	36974	USA	0
ca27de55-8edd-4ee9-e5ac-438dfbd89907	2005-11-30 19:21:17	2005-11-30 19:21:17	1	beth_id	1	Black-Vansant Construction Company	\N	Consulting	Construction	\N	\N	1314 Westover Dr.	Daly City	CA	87331	USA	\N	\N	937-555-1162	\N	\N	\N	www.black-vansantconstructioncompany.com	\N	\N	\N	\N	1314 Westover Dr.	Daly City	CA	87331	USA	0
60b70a54-714f-be7a-4b60-438dfb818721	2005-11-30 19:21:18	2005-11-30 19:21:18	1	max_id	1	C & A Bentley Engineering Group	\N	Supply	Engineering	\N	\N	1101 C Street	Daly City	CA	87541	USA	\N	\N	526-555-2198	\N	\N	\N	www.cabentleyengineeringgroup.com	\N	\N	\N	\N	1101 C Street	Daly City	CA	87541	USA	0
4493f50e-b438-9309-7460-438dfbd1e55a	2005-11-30 19:21:18	2005-11-30 19:21:18	1	kristen_id	1	Bentley-Ritacco Construction, Ltd	\N	Consulting	Construction	\N	\N	9177 Concord Royale	Grossmont	CA	77767	USA	\N	\N	622-555-8806	\N	\N	\N	www.bentley-ritaccoconstruction,ltd.com	\N	\N	\N	\N	9177 Concord Royale	Grossmont	CA	77767	USA	0
7785d491-20b6-5a33-d7f5-438dfbbcdfe4	2005-11-30 19:21:18	2005-11-30 19:21:18	1	chris_id	1	U & S Theisen Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	9218 Sanford St.	Walla Walla	WA	46044	USA	\N	\N	895-555-4813	\N	\N	\N	www.ustheisentransportation,inc.com	\N	\N	\N	\N	9218 Sanford St.	Walla Walla	WA	46044	USA	0
b72ef6a5-a70e-7e32-7555-438dfb48175a	2005-11-30 19:21:18	2005-11-30 19:21:18	1	will_id	1	Theisen-Berger Construction Group	\N	Distribution	Construction	\N	\N	7549 Longview Rd.	Mill Valley	CA	28725	USA	\N	\N	702-555-1702	\N	\N	\N	www.theisen-bergerconstructiongroup.com	\N	\N	\N	\N	7549 Longview Rd.	Mill Valley	CA	28725	USA	0
1226c48a-8e8a-48fd-168f-438dfbbc24a6	2005-11-30 19:21:19	2005-11-30 19:21:19	1	sarah_id	1	N & W Koski Transportation Corp	\N	Distribution	Transportation	\N	\N	500 Rockledge Lane	Tacoma	WA	35870	USA	\N	\N	997-555-5337	\N	\N	\N	www.nwkoskitransportationcorp.com	\N	\N	\N	\N	500 Rockledge Lane	Tacoma	WA	35870	USA	0
51069b30-5071-f6e7-81d6-438dfbfac69a	2005-11-30 19:21:19	2005-11-30 19:21:19	1	matt_id	1	Koski-Fitzgerald Engineering Partners	\N	Supply	Engineering	\N	\N	1742 Breck Court	Shawnee	BC	83711	Canada	\N	\N	478-555-3859	\N	\N	\N	www.koski-fitzgeraldengineeringpartners.com	\N	\N	\N	\N	1742 Breck Court	Shawnee	BC	83711	Canada	0
a169e42d-a69b-b039-6170-438dfbd9dd1b	2005-11-30 19:21:19	2005-11-30 19:21:19	1	sarah_id	1	O & D Camacho Communications Associates	\N	Distribution	Communications	\N	\N	4946 Abbey Court	Langford	BC	83311	Canada	\N	\N	136-555-9780	\N	\N	\N	www.odcamachocommunicationsassociates.com	\N	\N	\N	\N	4946 Abbey Court	Langford	BC	83311	Canada	0
d1c588fa-0835-de12-f760-438dfb25122d	2005-11-30 19:21:19	2005-11-30 19:21:19	1	sally_id	1	Camacho-Alvarado Transportation Company	\N	Consulting	Transportation	\N	\N	6441 Via Santa Fe	Puyallup	WA	71022	USA	\N	\N	779-555-1588	\N	\N	\N	www.camacho-alvaradotransportationcompany.com	\N	\N	\N	\N	6441 Via Santa Fe	Puyallup	WA	71022	USA	0
1463cd37-29f8-b0f2-4514-438dfb7af5ba	2005-11-30 19:21:20	2005-11-30 19:21:20	1	sally_id	1	M & Y Brummer Communications, Ltd	\N	Supply	Communications	\N	\N	9899 Geary Court	Grossmont	CA	10492	USA	\N	\N	459-555-6138	\N	\N	\N	www.mybrummercommunications,ltd.com	\N	\N	\N	\N	9899 Geary Court	Grossmont	CA	10492	USA	0
4488073d-4339-fb11-e278-438dfb45d751	2005-11-30 19:21:20	2005-11-30 19:21:20	1	beth_id	1	Brummer-Pinkston Communications Associates	\N	Consulting	Communications	\N	\N	4305 Amanda Circle	Lebanon	OR	89656	USA	\N	\N	225-555-5573	\N	\N	\N	www.brummer-pinkstoncommunicationsassociates.com	\N	\N	\N	\N	4305 Amanda Circle	Lebanon	OR	89656	USA	0
86b427e1-a1dd-4d58-d470-438dfbdd6dfd	2005-11-30 19:21:20	2005-11-30 19:21:20	1	max_id	1	B & D Spivey Machinery Partners	\N	Consulting	Machinery	\N	\N	674 Woodchuck Pl.	Burien	WA	94286	USA	\N	\N	167-555-3409	\N	\N	\N	www.bdspiveymachinerypartners.com	\N	\N	\N	\N	674 Woodchuck Pl.	Burien	WA	94286	USA	0
e4ce44fa-216f-d1c7-e9ef-438dfbb2cc13	2005-11-30 19:21:20	2005-11-30 19:21:20	1	sarah_id	1	Spivey-Whiting Construction Partners	\N	Manufacturing	Construction	\N	\N	5333 Garaventa Drive	Lake Oswego	OR	14321	USA	\N	\N	855-555-1473	\N	\N	\N	www.spivey-whitingconstructionpartners.com	\N	\N	\N	\N	5333 Garaventa Drive	Lake Oswego	OR	14321	USA	0
30243b86-0c2f-4cd9-cf98-438dfb7a611e	2005-11-30 19:21:21	2005-11-30 19:21:21	1	kristen_id	1	H & E Espinoza Machinery Group	\N	Supply	Machinery	\N	\N	1955 Wallace Dr.	La Cruz	Sinaloa	84112	Mexico	\N	\N	821-555-6938	\N	\N	\N	www.heespinozamachinerygroup.com	\N	\N	\N	\N	1955 Wallace Dr.	La Cruz	Sinaloa	84112	Mexico	0
7282206d-2097-c88f-cc36-438dfb4272e6	2005-11-30 19:21:21	2005-11-30 19:21:21	1	beth_id	1	Espinoza-Robinett Electronics Holdings	\N	Supply	Electronics	\N	\N	6868 West	Lincoln Acres	CA	69308	USA	\N	\N	632-555-3630	\N	\N	\N	www.espinoza-robinettelectronicsholdings.com	\N	\N	\N	\N	6868 West	Lincoln Acres	CA	69308	USA	0
b269cbcc-3523-84cd-76a1-438dfb8cca3e	2005-11-30 19:21:21	2005-11-30 19:21:21	1	max_id	1	X & M Lundahl Construction Corp	\N	Manufacturing	Construction	\N	\N	6401 Cook Street	Seattle	WA	62625	USA	\N	\N	859-555-2380	\N	\N	\N	www.xmlundahlconstructioncorp.com	\N	\N	\N	\N	6401 Cook Street	Seattle	WA	62625	USA	0
db29071d-ab61-8267-207d-438dfbd07e1f	2005-11-30 19:21:22	2005-11-30 19:21:22	1	sally_id	1	Lundahl-Demicell Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	1569 Norse Drive	Corvallis	OR	56618	USA	\N	\N	932-555-1359	\N	\N	\N	www.lundahl-demicelltelecommunications,ltd.com	\N	\N	\N	\N	1569 Norse Drive	Corvallis	OR	56618	USA	0
52e4fd3b-926a-77bb-c6ba-438dfbe5a927	2005-11-30 19:21:22	2005-11-30 19:21:22	1	chris_id	1	I & M Rousey Transportation, Ltd	\N	Supply	Transportation	\N	\N	1355 Sequoia Drive	Guadalajara	Jalisco	78856	Mexico	\N	\N	634-555-4655	\N	\N	\N	www.imrouseytransportation,ltd.com	\N	\N	\N	\N	1355 Sequoia Drive	Guadalajara	Jalisco	78856	Mexico	0
861f83dc-68b6-733b-cbce-438dfb2b868a	2005-11-30 19:21:22	2005-11-30 19:21:22	1	will_id	1	Rousey-Marcovecchio Electronics Corp	\N	Manufacturing	Electronics	\N	\N	9431 Sun View Terrace	Port Hammond	BC	95375	Canada	\N	\N	730-555-2262	\N	\N	\N	www.rousey-marcovecchioelectronicscorp.com	\N	\N	\N	\N	9431 Sun View Terrace	Port Hammond	BC	95375	Canada	0
c661b334-bf51-1dde-62bf-438dfbf2442c	2005-11-30 19:21:22	2005-11-30 19:21:22	1	kristen_id	1	H & Y Evans Engineering, Inc	\N	Distribution	Engineering	\N	\N	9472 Juliet Court	Colma	CA	63651	USA	\N	\N	102-555-7269	\N	\N	\N	www.hyevansengineering,inc.com	\N	\N	\N	\N	9472 Juliet Court	Colma	CA	63651	USA	0
12814883-6201-bc73-1589-438dfbe68b5d	2005-11-30 19:21:23	2005-11-30 19:21:23	1	jaime_id	1	Evans-Storjohann Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	460 Carzino Ct	La Mesa	CA	20040	USA	\N	\N	460-555-7162	\N	\N	\N	www.evans-storjohanntelecommunications,ltd.com	\N	\N	\N	\N	460 Carzino Ct	La Mesa	CA	20040	USA	0
68359cf5-c82c-2694-bcf9-438dfbe295ac	2005-11-30 19:21:23	2005-11-30 19:21:23	1	sally_id	1	D & A Maccietto Machinery Group	\N	Manufacturing	Machinery	\N	\N	3410 Hemlock Ave.	El Cajon	CA	53478	USA	\N	\N	756-555-1798	\N	\N	\N	www.damacciettomachinerygroup.com	\N	\N	\N	\N	3410 Hemlock Ave.	El Cajon	CA	53478	USA	0
a2f0f610-c757-4a3d-0e53-438dfb0662eb	2005-11-30 19:21:23	2005-11-30 19:21:23	1	max_id	1	Maccietto-Buskirk Construction Associates	\N	Consulting	Construction	\N	\N	1996 Sand Pointe Lane	Oakland	CA	75027	USA	\N	\N	237-555-9319	\N	\N	\N	www.maccietto-buskirkconstructionassociates.com	\N	\N	\N	\N	1996 Sand Pointe Lane	Oakland	CA	75027	USA	0
d6b280a6-e776-1416-4a2f-438dfbc155a4	2005-11-30 19:21:23	2005-11-30 19:21:23	1	max_id	1	D & Z Kesslep Electronics, Ltd	\N	Consulting	Electronics	\N	\N	5200 Pennsylvania Blvd	Vancouver	BC	74626	Canada	\N	\N	134-555-9898	\N	\N	\N	www.dzkesslepelectronics,ltd.com	\N	\N	\N	\N	5200 Pennsylvania Blvd	Vancouver	BC	74626	Canada	0
1620dad8-2eb7-e7e0-cc51-438dfb06f565	2005-11-30 19:21:24	2005-11-30 19:21:24	1	kristen_id	1	Kesslep-Schultz Engineering Corp	\N	Consulting	Engineering	\N	\N	6695 Kathleen Drive	N. Vancouver	BC	62338	Canada	\N	\N	537-555-7048	\N	\N	\N	www.kesslep-schultzengineeringcorp.com	\N	\N	\N	\N	6695 Kathleen Drive	N. Vancouver	BC	62338	Canada	0
4ca2c4b2-a7ad-2dd5-c8ce-438dfbacc559	2005-11-30 19:21:24	2005-11-30 19:21:24	1	will_id	1	Q & Q Bergin Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	2810 Guadalupe	Acapulco	Guerrero	28099	Mexico	\N	\N	218-555-2598	\N	\N	\N	www.qqbergintelecommunicationsassociates.com	\N	\N	\N	\N	2810 Guadalupe	Acapulco	Guerrero	28099	Mexico	0
94a3441e-a450-ea5a-d820-438dfb458713	2005-11-30 19:21:24	2005-11-30 19:21:24	1	max_id	1	Bergin-Steel Engineering Company	\N	Manufacturing	Engineering	\N	\N	P.O. Box 4559	Edmonds	WA	80971	USA	\N	\N	883-555-2034	\N	\N	\N	www.bergin-steelengineeringcompany.com	\N	\N	\N	\N	P.O. Box 4559	Edmonds	WA	80971	USA	0
d882d439-557f-3c8a-2b84-438dfb8fb443	2005-11-30 19:21:24	2005-11-30 19:21:24	1	matt_id	1	Y & R Marple Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	928 Old Mountain View Dr.	Olympia	WA	12894	USA	\N	\N	826-555-8869	\N	\N	\N	www.yrmarplemachinery,inc.com	\N	\N	\N	\N	928 Old Mountain View Dr.	Olympia	WA	12894	USA	0
27d80dd7-5709-0d55-bc59-438dfb2ecf77	2005-11-30 19:21:25	2005-11-30 19:21:25	1	sarah_id	1	Marple-Evans Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	5587 D St.	Cliffside	BC	31928	Canada	\N	\N	614-555-6934	\N	\N	\N	www.marple-evansengineering,inc.com	\N	\N	\N	\N	5587 D St.	Cliffside	BC	31928	Canada	0
6bdb4764-4c85-d993-60a3-438dfbd78877	2005-11-30 19:21:25	2005-11-30 19:21:25	1	kristen_id	1	E & F Bruner Machinery, Ltd	\N	Consulting	Machinery	\N	\N	6111 Guadalajara	Oregon City	OR	27206	USA	\N	\N	579-555-3398	\N	\N	\N	www.efbrunermachinery,ltd.com	\N	\N	\N	\N	6111 Guadalajara	Oregon City	OR	27206	USA	0
b0e04bdb-7d18-6594-1161-438dfbdd2db8	2005-11-30 19:21:25	2005-11-30 19:21:25	1	chris_id	1	Bruner-Troyer Transportation Holdings	\N	Distribution	Transportation	\N	\N	1025 R St.	Kirkland	WA	86915	USA	\N	\N	742-555-6008	\N	\N	\N	www.bruner-troyertransportationholdings.com	\N	\N	\N	\N	1025 R St.	Kirkland	WA	86915	USA	0
f36732ff-d18a-33cf-cdef-438dfb50e080	2005-11-30 19:21:25	2005-11-30 19:21:25	1	will_id	1	N & O Sandidge Electronics, Inc	\N	Supply	Electronics	\N	\N	557 Diver Way	Royal Oak	BC	23869	Canada	\N	\N	969-555-4758	\N	\N	\N	www.nosandidgeelectronics,inc.com	\N	\N	\N	\N	557 Diver Way	Royal Oak	BC	23869	Canada	0
52bed83a-38fc-b11f-f87f-438dfb98b92e	2005-11-30 19:21:26	2005-11-30 19:21:26	1	kristen_id	1	Sandidge-Skonnard Machinery Group	\N	Distribution	Machinery	\N	\N	8380 Paso Del Rio Court	Spring Valley	CA	74226	USA	\N	\N	142-555-3737	\N	\N	\N	www.sandidge-skonnardmachinerygroup.com	\N	\N	\N	\N	8380 Paso Del Rio Court	Spring Valley	CA	74226	USA	0
86d3263a-ebb4-fe6c-af85-438dfb92f6e9	2005-11-30 19:21:26	2005-11-30 19:21:26	1	beth_id	1	U & W Beck Construction Corp	\N	Supply	Construction	\N	\N	8166 Starflower Dr	Spring Valley	CA	76341	USA	\N	\N	392-555-1115	\N	\N	\N	www.uwbeckconstructioncorp.com	\N	\N	\N	\N	8166 Starflower Dr	Spring Valley	CA	76341	USA	0
c899fe71-1c72-cefa-3506-438dfbf06cbb	2005-11-30 19:21:26	2005-11-30 19:21:26	1	max_id	1	Beck-Abel Electronics Company	\N	Consulting	Electronics	\N	\N	3588 Vancouver Way	San Francisco	CA	64952	USA	\N	\N	488-555-7722	\N	\N	\N	www.beck-abelelectronicscompany.com	\N	\N	\N	\N	3588 Vancouver Way	San Francisco	CA	64952	USA	0
3848e594-7629-8173-06a8-438dfbd07afa	2005-11-30 19:21:27	2005-11-30 19:21:27	1	chris_id	1	M & K Miller Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	6284 Levee Rd.	Lebanon	OR	33229	USA	\N	\N	761-555-3729	\N	\N	\N	www.mkmillertelecommunications,ltd.com	\N	\N	\N	\N	6284 Levee Rd.	Lebanon	OR	33229	USA	0
7cb73f6a-5de6-f957-936b-438dfb2ab8cb	2005-11-30 19:21:27	2005-11-30 19:21:27	1	sarah_id	1	Miller-Walker Machinery, Ltd	\N	Consulting	Machinery	\N	\N	4616 Cordova Way	Portland	OR	15910	USA	\N	\N	219-555-3622	\N	\N	\N	www.miller-walkermachinery,ltd.com	\N	\N	\N	\N	4616 Cordova Way	Portland	OR	15910	USA	0
ad0c8ac5-b1f9-9dcd-ca34-438dfb04c1a8	2005-11-30 19:21:27	2005-11-30 19:21:27	1	beth_id	1	L & E Brooks Communications Partners	\N	Distribution	Communications	\N	\N	7566 Keller Ridge Dr.	Bellflower	CA	49347	USA	\N	\N	754-555-1915	\N	\N	\N	www.lebrookscommunicationspartners.com	\N	\N	\N	\N	7566 Keller Ridge Dr.	Bellflower	CA	49347	USA	0
c98d0766-adf0-5ff8-63d0-438dfb9a8e9e	2005-11-30 19:21:28	2005-11-30 19:21:28	1	sally_id	1	Brooks-Logan Construction Holdings	\N	Consulting	Construction	\N	\N	8807 Soto St.	Bremerton	WA	70897	USA	\N	\N	896-555-5779	\N	\N	\N	www.brooks-loganconstructionholdings.com	\N	\N	\N	\N	8807 Soto St.	Bremerton	WA	70897	USA	0
3ce7d434-1d87-d2ac-cb37-438dfb6eaebb	2005-11-30 19:21:28	2005-11-30 19:21:28	1	kristen_id	1	W & N Several Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	2012 Reisling Court	San Carlos	CA	70496	USA	\N	\N	792-555-6358	\N	\N	\N	www.wnseveraltelecommunicationspartners.com	\N	\N	\N	\N	2012 Reisling Court	San Carlos	CA	70496	USA	0
6d531631-8b4e-ed30-477f-438dfb9e4024	2005-11-30 19:21:28	2005-11-30 19:21:28	1	sally_id	1	Several-Thomas Transportation Holdings	\N	Consulting	Transportation	\N	\N	3507 Limeridge Drive	Acapulco	Guerrero	58207	Mexico	\N	\N	296-555-3508	\N	\N	\N	www.several-thomastransportationholdings.com	\N	\N	\N	\N	3507 Limeridge Drive	Acapulco	Guerrero	58207	Mexico	0
b3341af8-246f-e384-a007-438dfbc474a3	2005-11-30 19:21:28	2005-11-30 19:21:28	1	beth_id	1	V & A Vessa Transportation Corp	\N	Consulting	Transportation	\N	\N	6965 Appalachian Drive	Beaverton	OR	23969	USA	\N	\N	877-555-8058	\N	\N	\N	www.vavessatransportationcorp.com	\N	\N	\N	\N	6965 Appalachian Drive	Beaverton	OR	23969	USA	0
13116248-d871-2b8d-45af-438dfb8b4196	2005-11-30 19:21:29	2005-11-30 19:21:29	1	max_id	1	Vessa-Tran Communications Corp	\N	Consulting	Communications	\N	\N	1371 Rogers Ave	Imperial Beach	CA	76841	USA	\N	\N	993-555-4411	\N	\N	\N	www.vessa-trancommunicationscorp.com	\N	\N	\N	\N	1371 Rogers Ave	Imperial Beach	CA	76841	USA	0
5602b4b8-2825-616c-26d1-438dfb0c802e	2005-11-30 19:21:29	2005-11-30 19:21:29	1	sally_id	1	T & A Crow Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	7739 Pineknoll	Newport Beach	CA	81471	USA	\N	\N	936-555-2247	\N	\N	\N	www.tacrowelectronics,inc.com	\N	\N	\N	\N	7739 Pineknoll	Newport Beach	CA	81471	USA	0
9aecd983-eb46-0d41-825d-438dfb1bcc5c	2005-11-30 19:21:29	2005-11-30 19:21:29	1	matt_id	1	Crow-Sims Construction Associates	\N	Manufacturing	Construction	\N	\N	9742 Anderson Way	Long Beach	CA	15065	USA	\N	\N	724-555-9311	\N	\N	\N	www.crow-simsconstructionassociates.com	\N	\N	\N	\N	9742 Anderson Way	Long Beach	CA	15065	USA	0
cb4e19da-1b76-52ef-4756-438dfb152979	2005-11-30 19:21:29	2005-11-30 19:21:29	1	chris_id	1	D & D Tatman Electronics Holdings	\N	Supply	Electronics	\N	\N	9021 Onley Dr	Chula Vista	CA	71297	USA	\N	\N	689-555-5775	\N	\N	\N	www.ddtatmanelectronicsholdings.com	\N	\N	\N	\N	9021 Onley Dr	Chula Vista	CA	71297	USA	0
198c4b42-3db0-a532-fe75-438dfb4ed4c3	2005-11-30 19:21:30	2005-11-30 19:21:30	1	sarah_id	1	Tatman-Nelsen Machinery, Inc	\N	Distribution	Machinery	\N	\N	3935 Hawkins Street	Langford	BC	56493	Canada	\N	\N	501-555-2468	\N	\N	\N	www.tatman-nelsenmachinery,inc.com	\N	\N	\N	\N	3935 Hawkins Street	Langford	BC	56493	Canada	0
721ccb5b-ba24-966e-5cbd-438dfb4043f6	2005-11-30 19:21:30	2005-11-30 19:21:30	1	sally_id	1	I & V Cole Engineering, Inc	\N	Distribution	Engineering	\N	\N	811 Via Cordona	Daly City	CA	19739	USA	\N	\N	728-555-1218	\N	\N	\N	www.ivcoleengineering,inc.com	\N	\N	\N	\N	811 Via Cordona	Daly City	CA	19739	USA	0
c70c9652-fb23-1d97-2bcf-438dfbb6fe01	2005-11-30 19:21:30	2005-11-30 19:21:30	1	beth_id	1	Cole-Huntsman Construction, Ltd	\N	Manufacturing	Construction	\N	\N	8634 Forte Way	Glendale	CA	43804	USA	\N	\N	801-555-9197	\N	\N	\N	www.cole-huntsmanconstruction,ltd.com	\N	\N	\N	\N	8634 Forte Way	Glendale	CA	43804	USA	0
33aa0685-459e-a142-1291-438dfba1fba4	2005-11-30 19:21:31	2005-11-30 19:21:31	1	matt_id	1	K & R Arakawa Communications Group	\N	Consulting	Communications	\N	\N	8420 Dayton Court	Glendale	CA	45919	USA	\N	\N	151-555-6575	\N	\N	\N	www.krarakawacommunicationsgroup.com	\N	\N	\N	\N	8420 Dayton Court	Glendale	CA	45919	USA	0
337bdd25-c908-7d88-d70e-438dfb6d5a65	2005-11-30 19:21:31	2005-11-30 19:21:31	1	jaime_id	1	Arakawa-Steuber Engineering Associates	\N	Distribution	Engineering	\N	\N	6498 Pasa Del Rio	Palo Alto	CA	62437	USA	\N	\N	247-555-4183	\N	\N	\N	www.arakawa-steuberengineeringassociates.com	\N	\N	\N	\N	6498 Pasa Del Rio	Palo Alto	CA	62437	USA	0
9e9d1ad7-e038-da60-b03f-438dfbb22801	2005-11-30 19:21:31	2005-11-30 19:21:31	1	max_id	1	B & P Cox Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	6538 Camelback Road	Los Angeles	CA	55681	USA	\N	\N	520-555-9190	\N	\N	\N	www.bpcoxtelecommunicationsholdings.com	\N	\N	\N	\N	6538 Camelback Road	Los Angeles	CA	55681	USA	0
5b3205e4-12a6-dee0-efd5-438dfb40c431	2005-11-30 19:21:32	2005-11-30 19:21:32	1	kristen_id	1	Cox-Jacobs Electronics, Ltd	\N	Distribution	Electronics	\N	\N	7525 Sutcliffe Pl.	Pomona	CA	38362	USA	\N	\N	878-555-9083	\N	\N	\N	www.cox-jacobselectronics,ltd.com	\N	\N	\N	\N	7525 Sutcliffe Pl.	Pomona	CA	38362	USA	0
48baf602-37b8-7988-804f-438dfb47231a	2005-11-30 19:21:32	2005-11-30 19:21:32	1	chris_id	1	Q & P Barley Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	7820 Blackridge Drive	W. Linn	OR	45507	USA	\N	\N	513-555-7376	\N	\N	\N	www.qpbarleytelecommunicationscompany.com	\N	\N	\N	\N	7820 Blackridge Drive	W. Linn	OR	45507	USA	0
8ef3c7cf-ee6c-1e89-f6c4-438dfb171221	2005-11-30 19:21:32	2005-11-30 19:21:32	1	beth_id	1	Barley-Alvaro Transportation Holdings	\N	Consulting	Transportation	\N	\N	9061 Isabel	Spokane	WA	93349	USA	\N	\N	894-555-5897	\N	\N	\N	www.barley-alvarotransportationholdings.com	\N	\N	\N	\N	9061 Isabel	Spokane	WA	93349	USA	0
d2373f7e-3be1-ac95-0bbd-438dfb96caeb	2005-11-30 19:21:32	2005-11-30 19:21:32	1	kristen_id	1	G & N Waters Communications Group	\N	Supply	Communications	\N	\N	2266 Bonifacio Street	Woodburn	OR	66656	USA	\N	\N	666-555-4999	\N	\N	\N	www.gnwaterscommunicationsgroup.com	\N	\N	\N	\N	2266 Bonifacio Street	Woodburn	OR	66656	USA	0
34777a04-8cf2-130c-c206-438dfb71857f	2005-11-30 19:21:33	2005-11-30 19:21:33	1	kristen_id	1	Waters-Jarvis Construction Partners	\N	Distribution	Construction	\N	\N	3761 Cancroft Road	San Gabriel	CA	80659	USA	\N	\N	170-555-2149	\N	\N	\N	www.waters-jarvisconstructionpartners.com	\N	\N	\N	\N	3761 Cancroft Road	San Gabriel	CA	80659	USA	0
64db3226-ae3d-4e8a-5749-438dfb42ff39	2005-11-30 19:21:33	2005-11-30 19:21:33	1	kristen_id	1	H & Y Styles Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	9875 Prestwick Court	Lemon Grove	CA	20129	USA	\N	\N	989-555-1356	\N	\N	\N	www.hystyleselectronics,ltd.com	\N	\N	\N	\N	9875 Prestwick Court	Lemon Grove	CA	20129	USA	0
97bd6b61-bc71-d178-5a95-438dfb05fd04	2005-11-30 19:21:33	2005-11-30 19:21:33	1	chris_id	1	Styles-Glenn Transportation Holdings	\N	Supply	Transportation	\N	\N	1625 Buckingham Dr.	San Jose	CA	73001	USA	\N	\N	516-555-6135	\N	\N	\N	www.styles-glenntransportationholdings.com	\N	\N	\N	\N	1625 Buckingham Dr.	San Jose	CA	73001	USA	0
c8efe193-131a-8773-9b67-438dfbcae321	2005-11-30 19:21:33	2005-11-30 19:21:33	1	sarah_id	1	O & K Smith Transportation Corp	\N	Manufacturing	Transportation	\N	\N	2519 Gill Ct.	Palo Alto	CA	49244	USA	\N	\N	458-555-3971	\N	\N	\N	www.oksmithtransportationcorp.com	\N	\N	\N	\N	2519 Gill Ct.	Palo Alto	CA	49244	USA	0
18cf8c9b-25fd-9b30-f993-438dfb879e80	2005-11-30 19:21:34	2005-11-30 19:21:34	1	beth_id	1	Smith-Duff Construction Partners	\N	Consulting	Construction	\N	\N	7178 Cancroft Road	Newport Beach	CA	23958	USA	\N	\N	247-555-2035	\N	\N	\N	www.smith-duffconstructionpartners.com	\N	\N	\N	\N	7178 Cancroft Road	Newport Beach	CA	23958	USA	0
48f9d0d4-e10b-53cd-1a0b-438dfbb23a4d	2005-11-30 19:21:34	2005-11-30 19:21:34	1	sally_id	1	D & D Lucero Transportation, Ltd	\N	Distribution	Transportation	\N	\N	3801 Roundhouse Place	Orizaba	Veracruz	93749	Mexico	\N	\N	212-555-7499	\N	\N	\N	www.ddlucerotransportation,ltd.com	\N	\N	\N	\N	3801 Roundhouse Place	Orizaba	Veracruz	93749	Mexico	0
8f7f554f-8242-46f3-6454-438dfb8ee5fe	2005-11-30 19:21:34	2005-11-30 19:21:34	1	kristen_id	1	Lucero-Burton Machinery, Inc	\N	Consulting	Machinery	\N	\N	8713 Live Oak Avenue	Vancouver	BC	78945	Canada	\N	\N	262-555-7849	\N	\N	\N	www.lucero-burtonmachinery,inc.com	\N	\N	\N	\N	8713 Live Oak Avenue	Vancouver	BC	78945	Canada	0
e7ab3484-832b-285b-9e13-438dfbc947f0	2005-11-30 19:21:34	2005-11-30 19:21:34	1	beth_id	1	E & M Consentino Electronics Company	\N	Supply	Electronics	\N	\N	8246 Via Del Sol	Chula Vista	CA	15899	USA	\N	\N	250-555-2942	\N	\N	\N	www.emconsentinoelectronicscompany.com	\N	\N	\N	\N	8246 Via Del Sol	Chula Vista	CA	15899	USA	0
2399516f-d014-ece7-7267-438dfb20a957	2005-11-30 19:21:35	2005-11-30 19:21:35	1	matt_id	1	Consentino-Lutes Engineering, Ltd	\N	Distribution	Engineering	\N	\N	3414 Jason Court	Milwaukie	OR	66256	USA	\N	\N	324-555-1921	\N	\N	\N	www.consentino-lutesengineering,ltd.com	\N	\N	\N	\N	3414 Jason Court	Milwaukie	OR	66256	USA	0
7f281512-f478-c01d-bd68-438dfb8e94ef	2005-11-30 19:21:35	2005-11-30 19:21:35	1	matt_id	1	R & Z Ecoffey Communications, Inc	\N	Distribution	Communications	\N	\N	3200 Glenmount Drive	Berkeley	CA	68370	USA	\N	\N	574-555-8299	\N	\N	\N	www.rzecoffeycommunications,inc.com	\N	\N	\N	\N	3200 Glenmount Drive	Berkeley	CA	68370	USA	0
d7b2d1e3-13e2-0239-45f8-438dfb71d950	2005-11-30 19:21:35	2005-11-30 19:21:35	1	chris_id	1	Ecoffey-Swint Machinery Partners	\N	Supply	Machinery	\N	\N	1278 Holly Oak Drive	San Gabriel	CA	84889	USA	\N	\N	670-555-5906	\N	\N	\N	www.ecoffey-swintmachinerypartners.com	\N	\N	\N	\N	1278 Holly Oak Drive	San Gabriel	CA	84889	USA	0
13732b70-8431-4e65-826e-438dfbc8b6b9	2005-11-30 19:21:36	2005-11-30 19:21:36	1	sarah_id	1	J & K Slattengren Communications Corp	\N	Supply	Communications	\N	\N	3974 Diver Way	Lakewood	CA	53166	USA	\N	\N	872-555-6146	\N	\N	\N	www.jkslattengrencommunicationscorp.com	\N	\N	\N	\N	3974 Diver Way	Lakewood	CA	53166	USA	0
6c574e51-9fc9-902c-bb97-438dfb3d4859	2005-11-30 19:21:36	2005-11-30 19:21:36	1	sally_id	1	Slattengren-Heymsfield Construction, Ltd	\N	Supply	Construction	\N	\N	2305 Ravenwood Drive	Victoria	BC	28062	Canada	\N	\N	991-555-2381	\N	\N	\N	www.slattengren-heymsfieldconstruction,ltd.com	\N	\N	\N	\N	2305 Ravenwood Drive	Victoria	BC	28062	Canada	0
c76da14e-ad51-81c1-dc28-438dfb72b7c5	2005-11-30 19:21:36	2005-11-30 19:21:36	1	max_id	1	W & W Whitehead Electronics Associates	\N	Supply	Electronics	\N	\N	5255 Corte Valencia	Santa Cruz	CA	61500	USA	\N	\N	625-555-9674	\N	\N	\N	www.wwwhiteheadelectronicsassociates.com	\N	\N	\N	\N	5255 Corte Valencia	Santa Cruz	CA	61500	USA	0
3644006f-4f8d-5c21-276a-438dfb9dcb96	2005-11-30 19:21:37	2005-11-30 19:21:37	1	max_id	1	Whitehead-Roy Machinery Group	\N	Manufacturing	Machinery	\N	\N	3841 Frisbie Ct	Pomona	CA	83049	USA	\N	\N	106-555-8196	\N	\N	\N	www.whitehead-roymachinerygroup.com	\N	\N	\N	\N	3841 Frisbie Ct	Pomona	CA	83049	USA	0
4812da65-b53f-1751-8610-438dfbb4962b	2005-11-30 19:21:37	2005-11-30 19:21:37	1	beth_id	1	D & G Burkhardt Transportation, Inc	\N	Distribution	Transportation	\N	\N	7045 Creekside Drive	La Cruz	Sinaloa	82649	Mexico	\N	\N	664-555-5117	\N	\N	\N	www.dgburkhardttransportation,inc.com	\N	\N	\N	\N	7045 Creekside Drive	La Cruz	Sinaloa	82649	Mexico	0
a5388d7b-fcfd-a575-9e4d-438dfb967005	2005-11-30 19:21:37	2005-11-30 19:21:37	1	matt_id	1	Burkhardt-Whitney Engineering, Ltd	\N	Supply	Engineering	\N	\N	8540 Donegal Road	Chula Vista	CA	70360	USA	\N	\N	168-555-2267	\N	\N	\N	www.burkhardt-whitneyengineering,ltd.com	\N	\N	\N	\N	8540 Donegal Road	Chula Vista	CA	70360	USA	0
c1400045-4d2d-7fdf-4a95-438dfbbc7abf	2005-11-30 19:21:38	2005-11-30 19:21:38	1	jaime_id	1	Z & L Wisnewski Construction, Ltd	\N	Supply	Construction	\N	\N	4655 Shuey Ave	San Gabriel	CA	36121	USA	\N	\N	987-555-1474	\N	\N	\N	www.zlwisnewskiconstruction,ltd.com	\N	\N	\N	\N	4655 Shuey Ave	San Gabriel	CA	36121	USA	0
3d28e556-d760-cce4-1c6e-438dfb740e75	2005-11-30 19:21:38	2005-11-30 19:21:38	1	will_id	1	Wisnewski-Burkhardt Transportation Group	\N	Manufacturing	Transportation	\N	\N	6404 Del Mar Ave	Tixapan	DF	88993	Mexico	\N	\N	514-555-6252	\N	\N	\N	www.wisnewski-burkhardttransportationgroup.com	\N	\N	\N	\N	6404 Del Mar Ave	Tixapan	DF	88993	Mexico	0
6ea925d0-f283-ae03-e457-438dfbf5c7c2	2005-11-30 19:21:38	2005-11-30 19:21:38	1	max_id	1	V & P Mcanich Transportation Corp	\N	Consulting	Transportation	\N	\N	2773 Kirkwood Dr	San Francisco	CA	93623	USA	\N	\N	456-555-4088	\N	\N	\N	www.vpmcanichtransportationcorp.com	\N	\N	\N	\N	2773 Kirkwood Dr	San Francisco	CA	93623	USA	0
b7f0204d-c5da-0bac-fb1f-438dfbab43a1	2005-11-30 19:21:38	2005-11-30 19:21:38	1	will_id	1	Mcanich-Browning Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	7432 Corte Valencia	Redmond	WA	13658	USA	\N	\N	245-555-2152	\N	\N	\N	www.mcanich-browningtelecommunications,inc.com	\N	\N	\N	\N	7432 Corte Valencia	Redmond	WA	13658	USA	0
34348439-2f14-69b5-9373-438dfb8feeee	2005-11-30 19:21:39	2005-11-30 19:21:39	1	matt_id	1	F & X Wellington Communications Partners	\N	Consulting	Communications	\N	\N	4055 Hitchcock	Burnaby	BC	10743	Canada	\N	\N	210-555-7617	\N	\N	\N	www.fxwellingtoncommunicationspartners.com	\N	\N	\N	\N	4055 Hitchcock	Burnaby	BC	10743	Canada	0
647cf0ab-fc93-d5d6-357f-438dfb507848	2005-11-30 19:21:39	2005-11-30 19:21:39	1	sally_id	1	Wellington-Bacugalupi Communications Holdings	\N	Distribution	Communications	\N	\N	1624 Carlisle Way	Redwood City	CA	94937	USA	\N	\N	260-555-7967	\N	\N	\N	www.wellington-bacugalupicommunicationsholdings.com	\N	\N	\N	\N	1624 Carlisle Way	Redwood City	CA	94937	USA	0
c1c8000d-1b0e-79b7-b29a-438dfb14fa50	2005-11-30 19:21:39	2005-11-30 19:21:39	1	sarah_id	1	S & X Rizzi Engineering Partners	\N	Distribution	Engineering	\N	\N	8500 Pinehurst Court	Everett	WA	31891	USA	\N	\N	248-555-3060	\N	\N	\N	www.sxrizziengineeringpartners.com	\N	\N	\N	\N	8500 Pinehurst Court	Everett	WA	31891	USA	0
135ff079-16c6-0b0b-4f55-438dfbf9fbef	2005-11-30 19:21:40	2005-11-30 19:21:40	1	sarah_id	1	Rizzi-Sotelo Transportation, Inc	\N	Supply	Transportation	\N	\N	6323 Benedict Court	Lincoln Acres	CA	82248	USA	\N	\N	434-555-4298	\N	\N	\N	www.rizzi-sotelotransportation,inc.com	\N	\N	\N	\N	6323 Benedict Court	Lincoln Acres	CA	82248	USA	0
6e8e2660-d6e8-bb25-5cf3-438dfb4910ff	2005-11-30 19:21:40	2005-11-30 19:21:40	1	sarah_id	1	H & N Stanley Machinery Corp	\N	Supply	Machinery	\N	\N	6110 Price Lane	Lincoln Acres	CA	84363	USA	\N	\N	684-555-1677	\N	\N	\N	www.hnstanleymachinerycorp.com	\N	\N	\N	\N	6110 Price Lane	Lincoln Acres	CA	84363	USA	0
cc37afac-d26c-7be4-dac5-438dfb6cf69d	2005-11-30 19:21:40	2005-11-30 19:21:40	1	will_id	1	Stanley-Markwood Machinery Associates	\N	Supply	Machinery	\N	\N	4187 Banbury Loop	Metchosin	BC	74590	Canada	\N	\N	780-555-8284	\N	\N	\N	www.stanley-markwoodmachineryassociates.com	\N	\N	\N	\N	4187 Banbury Loop	Metchosin	BC	74590	Canada	0
8512079f-f956-4a23-8a37-438dfbb02101	2005-11-30 19:21:41	2005-11-30 19:21:41	1	max_id	1	G & W Valentine Transportation, Inc	\N	Distribution	Transportation	\N	\N	4228 Pacheco St.	Beaverton	OR	42866	USA	\N	\N	392-555-7948	\N	\N	\N	www.gwvalentinetransportation,inc.com	\N	\N	\N	\N	4228 Pacheco St.	Beaverton	OR	42866	USA	0
38843ba3-2413-4dcb-c56d-438dfbb925ee	2005-11-30 19:21:41	2005-11-30 19:21:41	1	matt_id	1	Valentine-Reams Machinery Corp	\N	Manufacturing	Machinery	\N	\N	2559 Gumwood	Grossmont	CA	25547	USA	\N	\N	511-555-4184	\N	\N	\N	www.valentine-reamsmachinerycorp.com	\N	\N	\N	\N	2559 Gumwood	Grossmont	CA	25547	USA	0
68dd5109-aad1-d62f-b4ac-438dfb484563	2005-11-30 19:21:41	2005-11-30 19:21:41	1	beth_id	1	V & B Long Transportation Holdings	\N	Supply	Transportation	\N	\N	5509 Newcastle Road	Portland	OR	83372	USA	\N	\N	145-555-2477	\N	\N	\N	www.vblongtransportationholdings.com	\N	\N	\N	\N	5509 Newcastle Road	Portland	OR	83372	USA	0
f355358b-92a4-c9c0-9890-438dfb4cbd09	2005-11-30 19:21:41	2005-11-30 19:21:41	1	beth_id	1	Long-Olenzek Construction Company	\N	Consulting	Construction	\N	\N	6751 Yosemite Ct.	Burlingame	CA	59223	USA	\N	\N	526-555-9998	\N	\N	\N	www.long-olenzekconstructioncompany.com	\N	\N	\N	\N	6751 Yosemite Ct.	Burlingame	CA	59223	USA	0
45676a3b-9212-eee8-5971-438dfb7f3881	2005-11-30 19:21:42	2005-11-30 19:21:42	1	max_id	1	C & A Valerio Engineering Group	\N	Supply	Engineering	\N	\N	9955 Terra Granada	San Jose	CA	55213	USA	\N	\N	184-555-6920	\N	\N	\N	www.cavalerioengineeringgroup.com	\N	\N	\N	\N	9955 Terra Granada	San Jose	CA	55213	USA	0
785db1b9-b296-52c9-900a-438dfbeaeace	2005-11-30 19:21:42	2005-11-30 19:21:42	1	kristen_id	1	Valerio-Ahlering Construction, Ltd	\N	Consulting	Construction	\N	\N	1451 Victory Lane	Salem	OR	92232	USA	\N	\N	587-555-4069	\N	\N	\N	www.valerio-ahleringconstruction,ltd.com	\N	\N	\N	\N	1451 Victory Lane	Salem	OR	92232	USA	0
eb362250-759c-9ba0-ae66-438dfb65e251	2005-11-30 19:21:42	2005-11-30 19:21:42	1	chris_id	1	U & S Burke Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	8811 Lombardy Lane	Kirkland	WA	31701	USA	\N	\N	507-555-3277	\N	\N	\N	www.usburketransportation,inc.com	\N	\N	\N	\N	8811 Lombardy Lane	Kirkland	WA	31701	USA	0
27795a7a-69be-075d-3a2b-438dfb625195	2005-11-30 19:21:43	2005-11-30 19:21:43	1	will_id	1	Burke-Bates Construction Group	\N	Distribution	Construction	\N	\N	3217 Elm St	National City	CA	11866	USA	\N	\N	934-555-8055	\N	\N	\N	www.burke-batesconstructiongroup.com	\N	\N	\N	\N	3217 Elm St	National City	CA	11866	USA	0
87412abc-b1d1-2243-4493-438dfb1387a5	2005-11-30 19:21:43	2005-11-30 19:21:43	1	sarah_id	1	N & W White Transportation Corp	\N	Distribution	Transportation	\N	\N	9584 Logan Ct	Lemon Grove	CA	16496	USA	\N	\N	876-555-5891	\N	\N	\N	www.nwwhitetransportationcorp.com	\N	\N	\N	\N	9584 Logan Ct	Lemon Grove	CA	16496	USA	0
b7a00e4f-c220-5842-62dd-438dfb9c5da2	2005-11-30 19:21:43	2005-11-30 19:21:43	1	matt_id	1	White-Simpson Engineering Partners	\N	Supply	Engineering	\N	\N	1589 Mt. Tamalpais Place	San Francisco	CA	35530	USA	\N	\N	664-555-3955	\N	\N	\N	www.white-simpsonengineeringpartners.com	\N	\N	\N	\N	1589 Mt. Tamalpais Place	San Francisco	CA	35530	USA	0
abf606cb-985d-df3b-31d3-438dfb244337	2005-11-30 19:21:44	2005-11-30 19:21:44	1	sarah_id	1	O & D Jones Communications Associates	\N	Distribution	Communications	\N	\N	867 La Orinda Place	Lincoln Acres	CA	63222	USA	\N	\N	334-555-9132	\N	\N	\N	www.odjonescommunicationsassociates.com	\N	\N	\N	\N	867 La Orinda Place	Lincoln Acres	CA	63222	USA	0
3b08a4cf-21d7-9a7b-a902-438dfb3bb829	2005-11-30 19:21:44	2005-11-30 19:21:44	1	sally_id	1	Jones-Casts Transportation Company	\N	Consulting	Transportation	\N	\N	5780 Conifer Terrace	Royal Oak	BC	90517	Canada	\N	\N	146-555-5825	\N	\N	\N	www.jones-caststransportationcompany.com	\N	\N	\N	\N	5780 Conifer Terrace	Royal Oak	BC	90517	Canada	0
9b38016e-c8c4-fd77-e640-438dfba26384	2005-11-30 19:21:44	2005-11-30 19:21:44	1	sally_id	1	M & Y Browqett Communications, Ltd	\N	Supply	Communications	\N	\N	5312 Riverwood Circle	Acapulco	Guerrero	27471	Mexico	\N	\N	373-555-4575	\N	\N	\N	www.mybrowqettcommunications,ltd.com	\N	\N	\N	\N	5312 Riverwood Circle	Acapulco	Guerrero	27471	Mexico	0
cb9c933f-85ae-e605-63f7-438dfbe24a0b	2005-11-30 19:21:44	2005-11-30 19:21:44	1	beth_id	1	Browqett-Kartz Communications Associates	\N	Consulting	Communications	\N	\N	480 C Kenwal Rd	Arcadia	CA	77828	USA	\N	\N	207-555-8896	\N	\N	\N	www.browqett-kartzcommunicationsassociates.com	\N	\N	\N	\N	480 C Kenwal Rd	Arcadia	CA	77828	USA	0
79380c9a-6503-7414-02f4-438dfbd217e4	2005-11-30 19:21:45	2005-11-30 19:21:45	1	max_id	1	B & D Wold Machinery Partners	\N	Consulting	Machinery	\N	\N	267 Aspen Drive	Arcadia	CA	79943	USA	\N	\N	457-555-6275	\N	\N	\N	www.bdwoldmachinerypartners.com	\N	\N	\N	\N	267 Aspen Drive	Arcadia	CA	79943	USA	0
37b7f271-1f25-cd1f-44bc-438dfbf47e45	2005-11-30 19:21:45	2005-11-30 19:21:45	1	sarah_id	1	Wold-French Construction Partners	\N	Manufacturing	Construction	\N	\N	8343 Briowes Valley Rd	Mill Valley	CA	96461	USA	\N	\N	553-555-3882	\N	\N	\N	www.wold-frenchconstructionpartners.com	\N	\N	\N	\N	8343 Briowes Valley Rd	Mill Valley	CA	96461	USA	0
af580786-dc85-f4b7-3643-438dfb894439	2005-11-30 19:21:45	2005-11-30 19:21:45	1	kristen_id	1	H & E Pederson Machinery Group	\N	Supply	Machinery	\N	\N	8384 Potomac Drive	Sedro Woolley	WA	64738	USA	\N	\N	165-555-3546	\N	\N	\N	www.hepedersonmachinerygroup.com	\N	\N	\N	\N	8384 Potomac Drive	Sedro Woolley	WA	64738	USA	0
3124580f-664b-4103-ef3e-438dfb1904b1	2005-11-30 19:21:46	2005-11-30 19:21:46	1	beth_id	1	Pederson-Renn Electronics Holdings	\N	Supply	Electronics	\N	\N	9371 Corte Del Sol	Downey	CA	21127	USA	\N	\N	284-555-8782	\N	\N	\N	www.pederson-rennelectronicsholdings.com	\N	\N	\N	\N	9371 Corte Del Sol	Downey	CA	21127	USA	0
6196bb05-c4fe-c086-55ca-438dfbe61361	2005-11-30 19:21:46	2005-11-30 19:21:46	1	max_id	1	X & M Catalano Construction Corp	\N	Manufacturing	Construction	\N	\N	9665 Pamploma Ct.	Kirkland	WA	54564	USA	\N	\N	819-555-7075	\N	\N	\N	www.xmcatalanoconstructioncorp.com	\N	\N	\N	\N	9665 Pamploma Ct.	Kirkland	WA	54564	USA	0
94482729-93a9-c5c2-ac96-438dfb62fd32	2005-11-30 19:21:46	2005-11-30 19:21:46	1	sally_id	1	Catalano-Coleman Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	907 Ameno Road	Tacoma	WA	46592	USA	\N	\N	300-555-5596	\N	\N	\N	www.catalano-colemantelecommunications,ltd.com	\N	\N	\N	\N	907 Ameno Road	Tacoma	WA	46592	USA	0
f34f0288-6e50-49a1-3087-438dfb21818a	2005-11-30 19:21:46	2005-11-30 19:21:46	1	chris_id	1	I & M Hurkett Transportation, Ltd	\N	Supply	Transportation	\N	\N	4111 Vista Diablo	San Gabriel	CA	19899	USA	\N	\N	857-555-2517	\N	\N	\N	www.imhurketttransportation,ltd.com	\N	\N	\N	\N	4111 Vista Diablo	San Gabriel	CA	19899	USA	0
46af97b1-278e-a1b7-6f9a-438dfb57c0ec	2005-11-30 19:21:47	2005-11-30 19:21:47	1	will_id	1	Hurkett-Pettengill Electronics Corp	\N	Manufacturing	Electronics	\N	\N	5607 Willow Creek Ct.	Berkeley	CA	33902	USA	\N	\N	361-555-8667	\N	\N	\N	www.hurkett-pettengillelectronicscorp.com	\N	\N	\N	\N	5607 Willow Creek Ct.	Berkeley	CA	33902	USA	0
91606de9-ecc7-35f6-9f44-438dfb189f7d	2005-11-30 19:21:47	2005-11-30 19:21:47	1	kristen_id	1	H & Y Elson Engineering, Inc	\N	Distribution	Engineering	\N	\N	1721 Dianda	Walla Walla	WA	72371	USA	\N	\N	393-555-1135	\N	\N	\N	www.hyelsonengineering,inc.com	\N	\N	\N	\N	1721 Dianda	Walla Walla	WA	72371	USA	0
d95a7a99-170c-499e-428e-438dfb361dce	2005-11-30 19:21:47	2005-11-30 19:21:47	1	jaime_id	1	Elson-Hirota Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	3471 West Ste. Michelle	Richmond	CA	26244	USA	\N	\N	819-555-5913	\N	\N	\N	www.elson-hirotatelecommunications,ltd.com	\N	\N	\N	\N	3471 West Ste. Michelle	Richmond	CA	26244	USA	0
7427f840-c2c9-d834-f101-438dfb56c870	2005-11-30 19:21:48	2005-11-30 19:21:48	1	sally_id	1	D & A Blasingame Machinery Group	\N	Manufacturing	Machinery	\N	\N	9838 Carob Way	Mill Valley	CA	57166	USA	\N	\N	762-555-3749	\N	\N	\N	www.dablasingamemachinerygroup.com	\N	\N	\N	\N	9838 Carob Way	Mill Valley	CA	57166	USA	0
a6d286c3-ebd0-936e-7eda-438dfbc6f7fe	2005-11-30 19:21:48	2005-11-30 19:21:48	1	max_id	1	Blasingame-Blackwell Construction Associates	\N	Consulting	Construction	\N	\N	4498 Dennis Circle	Lakewood	CA	76200	USA	\N	\N	550-555-1813	\N	\N	\N	www.blasingame-blackwellconstructionassociates.com	\N	\N	\N	\N	4498 Dennis Circle	Lakewood	CA	76200	USA	0
d8298c3a-2e00-563b-0bae-438dfb77a99a	2005-11-30 19:21:48	2005-11-30 19:21:48	1	max_id	1	D & Z Moya Electronics, Ltd	\N	Consulting	Electronics	\N	\N	1121 Boynton Avenue	Issaquah	WA	46992	USA	\N	\N	754-555-1935	\N	\N	\N	www.dzmoyaelectronics,ltd.com	\N	\N	\N	\N	1121 Boynton Avenue	Issaquah	WA	46992	USA	0
2e58254c-eae7-84c9-3019-438dfba6f7c4	2005-11-30 19:21:49	2005-11-30 19:21:49	1	kristen_id	1	Moya-Chesnut Engineering Corp	\N	Consulting	Engineering	\N	\N	6034 Sunset Circle	Marysville	WA	32188	USA	\N	\N	566-555-7627	\N	\N	\N	www.moya-chesnutengineeringcorp.com	\N	\N	\N	\N	6034 Sunset Circle	Marysville	WA	32188	USA	0
79453030-58ba-a4c2-fb42-438dfb5babf3	2005-11-30 19:21:49	2005-11-30 19:21:49	1	will_id	1	Q & Q Ortiz Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	5566 Brook Way	Lincoln Acres	CA	68141	USA	\N	\N	793-555-6377	\N	\N	\N	www.qqortiztelecommunicationsassociates.com	\N	\N	\N	\N	5566 Brook Way	Lincoln Acres	CA	68141	USA	0
c16881fb-499b-da86-1ad4-438dfb189086	2005-11-30 19:21:49	2005-11-30 19:21:49	1	max_id	1	Ortiz-Tearpak Engineering Company	\N	Manufacturing	Engineering	\N	\N	734 Selena Court	Woodland Hills	CA	19499	USA	\N	\N	627-555-1699	\N	\N	\N	www.ortiz-tearpakengineeringcompany.com	\N	\N	\N	\N	734 Selena Court	Woodland Hills	CA	19499	USA	0
f18bc447-43c2-7a4c-76a4-438dfb3b6210	2005-11-30 19:21:49	2005-11-30 19:21:49	1	matt_id	1	Y & R Hall Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	521 Red Leaf Way	La Jolla	CA	21614	USA	\N	\N	877-555-8077	\N	\N	\N	www.yrhallmachinery,inc.com	\N	\N	\N	\N	521 Red Leaf Way	La Jolla	CA	21614	USA	0
2d6eeb58-8ed8-ffa5-00c1-438dfb302163	2005-11-30 19:21:50	2005-11-30 19:21:50	1	sarah_id	1	Hall-Narberes Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	8597 Sandra	Long Beach	CA	38132	USA	\N	\N	312-555-9342	\N	\N	\N	www.hall-narberesengineering,inc.com	\N	\N	\N	\N	8597 Sandra	Long Beach	CA	38132	USA	0
aa07e3e9-14d4-7ea5-0364-438dfb423b85	2005-11-30 19:21:50	2005-11-30 19:21:50	1	kristen_id	1	E & F Weber Machinery, Ltd	\N	Consulting	Machinery	\N	\N	1294 Golden Rain Road	Richmond	BC	79116	Canada	\N	\N	585-555-5349	\N	\N	\N	www.efwebermachinery,ltd.com	\N	\N	\N	\N	1294 Golden Rain Road	Richmond	BC	79116	Canada	0
dc32d1a7-baa7-4ddc-ad19-438dfb2b4fd8	2005-11-30 19:21:50	2005-11-30 19:21:50	1	chris_id	1	Weber-Kabbes Transportation Holdings	\N	Distribution	Transportation	\N	\N	2904 Bay View Drive	Santa Cruz	CA	61796	USA	\N	\N	704-555-1584	\N	\N	\N	www.weber-kabbestransportationholdings.com	\N	\N	\N	\N	2904 Bay View Drive	Santa Cruz	CA	61796	USA	0
4bd4969c-6b43-e0dc-efc5-438dfbfebe9b	2005-11-30 19:21:51	2005-11-30 19:21:51	1	will_id	1	N & O Townsend Electronics, Inc	\N	Supply	Electronics	\N	\N	5854 Onley Dr	Burien	WA	95234	USA	\N	\N	339-555-8877	\N	\N	\N	www.notownsendelectronics,inc.com	\N	\N	\N	\N	5854 Onley Dr	Burien	WA	95234	USA	0
8020ee80-2bc1-61ee-2d0c-438dfb47ffc7	2005-11-30 19:21:51	2005-11-30 19:21:51	1	kristen_id	1	Townsend-Rockne Machinery Group	\N	Distribution	Machinery	\N	\N	4440 Algiers Drive	Downey	CA	42752	USA	\N	\N	418-555-7736	\N	\N	\N	www.townsend-rocknemachinerygroup.com	\N	\N	\N	\N	4440 Algiers Drive	Downey	CA	42752	USA	0
b15df275-d23f-d4e7-5c0b-438dfb6f426e	2005-11-30 19:21:51	2005-11-30 19:21:51	1	beth_id	1	U & W Heaney Construction Corp	\N	Supply	Construction	\N	\N	301 Sandy Ln.	Merida	Yucatan	42351	Mexico	\N	\N	975-555-4658	\N	\N	\N	www.uwheaneyconstructioncorp.com	\N	\N	\N	\N	301 Sandy Ln.	Merida	Yucatan	42351	Mexico	0
76fd063d-d3b5-5a36-cc8e-438dfbea1f29	2005-11-30 19:21:52	2005-11-30 19:21:52	1	max_id	1	Heaney-Karavites Electronics Company	\N	Consulting	Electronics	\N	\N	1796 Westbury Dr.	Lincoln Acres	CA	30062	USA	\N	\N	479-555-1808	\N	\N	\N	www.heaney-karaviteselectronicscompany.com	\N	\N	\N	\N	1796 Westbury Dr.	Lincoln Acres	CA	30062	USA	0
509dc2bc-855f-8229-e87d-438dfb3ee35f	2005-11-30 19:21:52	2005-11-30 19:21:52	1	chris_id	1	M & K Carreras Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	5254 Daylight Place	Santa Monica	CA	94823	USA	\N	\N	398-555-1015	\N	\N	\N	www.mkcarrerastelecommunications,ltd.com	\N	\N	\N	\N	5254 Daylight Place	Santa Monica	CA	94823	USA	0
9cde617d-0978-99e0-4aae-438dfbc944bf	2005-11-30 19:21:52	2005-11-30 19:21:52	1	sarah_id	1	Carreras-Mendiola Machinery, Ltd	\N	Consulting	Machinery	\N	\N	9659 Walnut Blvd	Metchosin	BC	48696	Canada	\N	\N	164-555-9451	\N	\N	\N	www.carreras-mendiolamachinery,ltd.com	\N	\N	\N	\N	9659 Walnut Blvd	Metchosin	BC	48696	Canada	0
b26006b3-c1e1-78bf-41e3-438dfbb3abc9	2005-11-30 19:21:53	2005-11-30 19:21:53	1	beth_id	1	L & E Trolen Communications Partners	\N	Distribution	Communications	\N	\N	3372 Via Cordona	Tixapan	DF	53326	Mexico	\N	\N	106-555-7287	\N	\N	\N	www.letrolencommunicationspartners.com	\N	\N	\N	\N	3372 Via Cordona	Tixapan	DF	53326	Mexico	0
3b976dba-9c67-c85c-1b46-438dfb6e2b10	2005-11-30 19:21:53	2005-11-30 19:21:53	1	sally_id	1	Trolen-Vernon Construction Holdings	\N	Consulting	Construction	\N	\N	8031 Danesta Dr.	Grossmont	CA	72360	USA	\N	\N	556-555-1693	\N	\N	\N	www.trolen-vernonconstructionholdings.com	\N	\N	\N	\N	8031 Danesta Dr.	Grossmont	CA	72360	USA	0
87997809-5094-024a-2814-438dfbaf7d3e	2005-11-30 19:21:53	2005-11-30 19:21:53	1	kristen_id	1	W & N Lynn Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	4654 Blackridge Drive	Pomona	CA	69444	USA	\N	\N	760-555-1815	\N	\N	\N	www.wnlynntelecommunicationspartners.com	\N	\N	\N	\N	4654 Blackridge Drive	Pomona	CA	69444	USA	0
b7f3e4ed-f834-8e31-5f4d-438dfb359ed2	2005-11-30 19:21:53	2005-11-30 19:21:53	1	sally_id	1	Lynn-Cavendish Transportation Holdings	\N	Consulting	Transportation	\N	\N	2223 Stillwater Court	Burlingame	CA	54640	USA	\N	\N	571-555-7508	\N	\N	\N	www.lynn-cavendishtransportationholdings.com	\N	\N	\N	\N	2223 Stillwater Court	Burlingame	CA	54640	USA	0
e8e59f02-1eed-27d0-6d7e-438dfba9d868	2005-11-30 19:21:53	2005-11-30 19:21:53	1	beth_id	1	V & A Baltazar Transportation Corp	\N	Consulting	Transportation	\N	\N	9099 Bonifacio St	Anacortes	WA	90593	USA	\N	\N	798-555-6258	\N	\N	\N	www.vabaltazartransportationcorp.com	\N	\N	\N	\N	9099 Bonifacio St	Anacortes	WA	90593	USA	0
71c71ca8-8151-f6db-5da4-438dfb255755	2005-11-30 19:21:54	2005-11-30 19:21:54	1	max_id	1	Baltazar-Higgs Communications Corp	\N	Consulting	Communications	\N	\N	6922 Estudello	Cliffside	BC	41951	Canada	\N	\N	633-555-1579	\N	\N	\N	www.baltazar-higgscommunicationscorp.com	\N	\N	\N	\N	6922 Estudello	Cliffside	BC	41951	Canada	0
a4a3717a-c2d5-691b-c4e2-438dfbb87573	2005-11-30 19:21:54	2005-11-30 19:21:54	1	sally_id	1	T & A Demott Jr Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	6709 Prestwick Ave	Langford	BC	44066	Canada	\N	\N	222-555-2615	\N	\N	\N	www.tademottjrelectronics,inc.com	\N	\N	\N	\N	6709 Prestwick Ave	Langford	BC	44066	Canada	0
eeaabf09-d964-c5dc-639d-438dfbccad87	2005-11-30 19:21:54	2005-11-30 19:21:54	1	matt_id	1	Demott Jr-Carmichael Construction Associates	\N	Manufacturing	Construction	\N	\N	4786 Salvio St.	Yakima	WA	34292	USA	\N	\N	318-555-9222	\N	\N	\N	www.demottjr-carmichaelconstructionassociates.com	\N	\N	\N	\N	4786 Salvio St.	Yakima	WA	34292	USA	0
449cf514-d107-bf13-e22d-438dfb6346c5	2005-11-30 19:21:55	2005-11-30 19:21:55	1	chris_id	1	D & D Montera Electronics Holdings	\N	Supply	Electronics	\N	\N	4827 Gilardy Drive	Milwaukie	OR	25692	USA	\N	\N	703-555-7489	\N	\N	\N	www.ddmonteraelectronicsholdings.com	\N	\N	\N	\N	4827 Gilardy Drive	Milwaukie	OR	25692	USA	0
9160e67c-7f47-05f8-1b62-438dfbb654a6	2005-11-30 19:21:55	2005-11-30 19:21:55	1	sarah_id	1	Montera-Ciochon Machinery, Inc	\N	Distribution	Machinery	\N	\N	3158 B Avenue I	Imperial Beach	CA	84248	USA	\N	\N	161-555-7382	\N	\N	\N	www.montera-ciochonmachinery,inc.com	\N	\N	\N	\N	3158 B Avenue I	Imperial Beach	CA	84248	USA	0
35b9c4e3-e670-d12b-dc94-438dfb3c3e70	2005-11-30 19:21:56	2005-11-30 19:21:56	1	sally_id	1	I & V Anderson Engineering, Inc	\N	Distribution	Engineering	\N	\N	6108 Estudello St.	Ballard	WA	91394	USA	\N	\N	456-555-2018	\N	\N	\N	www.ivandersonengineering,inc.com	\N	\N	\N	\N	6108 Estudello St.	Ballard	WA	91394	USA	0
660a9106-4c87-1508-c45b-438dfb157396	2005-11-30 19:21:56	2005-11-30 19:21:56	1	beth_id	1	Anderson-Allen Construction, Ltd	\N	Manufacturing	Construction	\N	\N	7350 Pinon	Santa Cruz	CA	40236	USA	\N	\N	837-555-9539	\N	\N	\N	www.anderson-allenconstruction,ltd.com	\N	\N	\N	\N	7350 Pinon	Santa Cruz	CA	40236	USA	0
b2fe2a8c-729b-82ff-875d-438dfb786209	2005-11-30 19:21:56	2005-11-30 19:21:56	1	matt_id	1	K & R Bidelman Communications Group	\N	Consulting	Communications	\N	\N	555 Moretti Drive	Oakland	CA	32052	USA	\N	\N	495-555-6460	\N	\N	\N	www.krbidelmancommunicationsgroup.com	\N	\N	\N	\N	555 Moretti Drive	Oakland	CA	32052	USA	0
23b45f1c-189f-1aff-e722-438dfbd23fb4	2005-11-30 19:21:57	2005-11-30 19:21:57	1	jaime_id	1	Bidelman-Gee Engineering Associates	\N	Distribution	Engineering	\N	\N	2050 Glazier Dr	Issaquah	WA	19763	USA	\N	\N	238-555-7268	\N	\N	\N	www.bidelman-geeengineeringassociates.com	\N	\N	\N	\N	2050 Glazier Dr	Issaquah	WA	19763	USA	0
a594ad62-21e6-fe38-3ac1-438dfb6ab474	2005-11-30 19:21:57	2005-11-30 19:21:57	1	max_id	1	B & P Breer Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	5508 Trembath Court	West Covina	CA	58231	USA	\N	\N	818-555-2818	\N	\N	\N	www.bpbreertelecommunicationsholdings.com	\N	\N	\N	\N	5508 Trembath Court	West Covina	CA	58231	USA	0
f054b6dd-897a-65d2-95ef-438dfb80f3f6	2005-11-30 19:21:57	2005-11-30 19:21:57	1	kristen_id	1	Breer-Barrera Electronics, Ltd	\N	Distribution	Electronics	\N	\N	9913 Mt. Whitney Way	San Diego	CA	38396	USA	\N	\N	584-555-2254	\N	\N	\N	www.breer-barreraelectronics,ltd.com	\N	\N	\N	\N	9913 Mt. Whitney Way	San Diego	CA	38396	USA	0
2c8ed1d1-6cc4-05df-84d8-438dfbb6eb82	2005-11-30 19:21:58	2005-11-30 19:21:58	1	chris_id	1	Q & P Banack Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	6282 McNeil Place	National City	CA	43027	USA	\N	\N	526-555-9089	\N	\N	\N	www.qpbanacktelecommunicationscompany.com	\N	\N	\N	\N	6282 McNeil Place	National City	CA	43027	USA	0
60211e94-e474-918e-8c77-438dfb92d148	2005-11-30 19:21:58	2005-11-30 19:21:58	1	beth_id	1	Banack-Dean Transportation Holdings	\N	Consulting	Transportation	\N	\N	941 Tosco Way	Tixapan	DF	62060	Mexico	\N	\N	315-555-7154	\N	\N	\N	www.banack-deantransportationholdings.com	\N	\N	\N	\N	941 Tosco Way	Tixapan	DF	62060	Mexico	0
95939537-69ed-0569-349e-438dfb51b14d	2005-11-30 19:21:58	2005-11-30 19:21:58	1	kristen_id	1	G & N Thompson Communications Group	\N	Supply	Communications	\N	\N	7563 Florencia	Lebanon	OR	32853	USA	\N	\N	280-555-3618	\N	\N	\N	www.gnthompsoncommunicationsgroup.com	\N	\N	\N	\N	7563 Florencia	Lebanon	OR	32853	USA	0
22fda997-049c-6ff8-d2ac-438dfb8b8fe1	2005-11-30 19:21:59	2005-11-30 19:21:59	1	kristen_id	1	Thompson-Stevens Construction Partners	\N	Distribution	Construction	\N	\N	2477 MacAlven Drive	Burbank	CA	18048	USA	\N	\N	991-555-9310	\N	\N	\N	www.thompson-stevensconstructionpartners.com	\N	\N	\N	\N	2477 MacAlven Drive	Burbank	CA	18048	USA	0
530cf751-bc28-78f8-9727-438dfbc5fce0	2005-11-30 19:21:59	2005-11-30 19:21:59	1	kristen_id	1	H & Y Davis Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	2009 San Marino	Orizaba	Veracruz	54001	Mexico	\N	\N	908-555-8635	\N	\N	\N	www.hydaviselectronics,ltd.com	\N	\N	\N	\N	2009 San Marino	Orizaba	Veracruz	54001	Mexico	0
8606d7b7-fb12-5bc8-fcc8-438dfb8c13a6	2005-11-30 19:21:59	2005-11-30 19:21:59	1	chris_id	1	Davis-Westgaard Transportation Holdings	\N	Supply	Transportation	\N	\N	7176 Chatworth	Bremerton	WA	53592	USA	\N	\N	982-555-7614	\N	\N	\N	www.davis-westgaardtransportationholdings.com	\N	\N	\N	\N	7176 Chatworth	Bremerton	WA	53592	USA	0
ec620ae9-1b97-e528-2707-438dfb142f20	2005-11-30 19:21:59	2005-11-30 19:21:59	1	sarah_id	1	O & K Agcaoili Transportation Corp	\N	Manufacturing	Transportation	\N	\N	6963 Grand View Avenue	Bremerton	WA	74743	USA	\N	\N	332-555-4993	\N	\N	\N	www.okagcaoilitransportationcorp.com	\N	\N	\N	\N	6963 Grand View Avenue	Bremerton	WA	74743	USA	0
44567144-d98c-55ff-600a-438dfb9b05e7	2005-11-30 19:22:00	2005-11-30 19:22:00	1	beth_id	1	Agcaoili-Sabella Construction Partners	\N	Consulting	Construction	\N	\N	8942 Sierra Road	Woodland Hills	CA	23993	USA	\N	\N	428-555-2600	\N	\N	\N	www.agcaoili-sabellaconstructionpartners.com	\N	\N	\N	\N	8942 Sierra Road	Woodland Hills	CA	23993	USA	0
ad9d4f16-4948-5b22-c2a5-438dfb42471c	2005-11-30 19:22:00	2005-11-30 19:22:00	1	sally_id	1	D & D Vanderlinden Transportation, Ltd	\N	Distribution	Transportation	\N	\N	8983 Haynes Court	Metchosin	BC	91268	Canada	\N	\N	701-555-7607	\N	\N	\N	www.ddvanderlindentransportation,ltd.com	\N	\N	\N	\N	8983 Haynes Court	Metchosin	BC	91268	Canada	0
ddbbf86c-83d1-1323-7353-438dfb2cde8e	2005-11-30 19:22:00	2005-11-30 19:22:00	1	kristen_id	1	Vanderlinden-Virden Machinery, Inc	\N	Consulting	Machinery	\N	\N	9970 Loma Linda	Edmonds	WA	47657	USA	\N	\N	159-555-7500	\N	\N	\N	www.vanderlinden-virdenmachinery,inc.com	\N	\N	\N	\N	9970 Loma Linda	Edmonds	WA	47657	USA	0
50f592cd-46e8-38ec-8bc4-438dfb69255a	2005-11-30 19:22:01	2005-11-30 19:22:01	1	beth_id	1	E & M Spencer Electronics Company	\N	Supply	Electronics	\N	\N	2921 Glen Wood Drive	Walla Walla	WA	81094	USA	\N	\N	454-555-2135	\N	\N	\N	www.emspencerelectronicscompany.com	\N	\N	\N	\N	2921 Glen Wood Drive	Walla Walla	WA	81094	USA	0
83ebac8d-3061-b06e-e9c2-438dfbc1c1b7	2005-11-30 19:22:01	2005-11-30 19:22:01	1	matt_id	1	Spencer-Castellucio Engineering, Ltd	\N	Distribution	Engineering	\N	\N	1506 River Rock Lane	Santa Anita	DF	36454	Mexico	\N	\N	835-555-9657	\N	\N	\N	www.spencer-castellucioengineering,ltd.com	\N	\N	\N	\N	1506 River Rock Lane	Santa Anita	DF	36454	Mexico	0
cfae570c-8617-1ed0-9552-438dfbbed9a1	2005-11-30 19:22:01	2005-11-30 19:22:01	1	matt_id	1	R & Z Zugelder Communications, Inc	\N	Distribution	Communications	\N	\N	4710 Northridge Drive	Port Orchard	WA	53924	USA	\N	\N	732-555-1236	\N	\N	\N	www.rzzugeldercommunications,inc.com	\N	\N	\N	\N	4710 Northridge Drive	Port Orchard	WA	53924	USA	0
bd2e0f70-1ee0-114b-6b3f-438dfb7beaca	2005-11-30 19:22:02	2005-11-30 19:22:02	1	chris_id	1	Zugelder-Malmendier Machinery Partners	\N	Supply	Machinery	\N	\N	6206 Heavenly Drive	West Covina	CA	41635	USA	\N	\N	236-555-7386	\N	\N	\N	www.zugelder-malmendiermachinerypartners.com	\N	\N	\N	\N	6206 Heavenly Drive	West Covina	CA	41635	USA	0
73d068dc-4ebc-f503-320a-438dfbbe3b7e	2005-11-30 19:22:02	2005-11-30 19:22:02	1	sarah_id	1	J & K Farrell Communications Corp	\N	Supply	Communications	\N	\N	2320 Wee Donegal	Royal Oak	BC	73962	Canada	\N	\N	816-555-2935	\N	\N	\N	www.jkfarrellcommunicationscorp.com	\N	\N	\N	\N	2320 Wee Donegal	Royal Oak	BC	73962	Canada	0
c25cd6b3-3646-b570-d9c9-438dfb849f55	2005-11-30 19:22:02	2005-11-30 19:22:02	1	sally_id	1	Farrell-Ault Construction, Ltd	\N	Supply	Construction	\N	\N	4070 Orange Street	Beverly Hills	CA	60268	USA	\N	\N	582-555-2371	\N	\N	\N	www.farrell-aultconstruction,ltd.com	\N	\N	\N	\N	4070 Orange Street	Beverly Hills	CA	60268	USA	0
1a933345-5bdc-a589-eb6d-438dfbf1c77c	2005-11-30 19:22:03	2005-11-30 19:22:03	1	max_id	1	W & W Highfill Electronics Associates	\N	Supply	Electronics	\N	\N	438 Mt. Etna	Santa Monica	CA	91190	USA	\N	\N	875-555-6124	\N	\N	\N	www.wwhighfillelectronicsassociates.com	\N	\N	\N	\N	438 Mt. Etna	Santa Monica	CA	91190	USA	0
4ab47181-24ce-f863-8995-438dfb35ea06	2005-11-30 19:22:03	2005-11-30 19:22:03	1	max_id	1	Highfill-Waggoner Machinery Group	\N	Manufacturing	Machinery	\N	\N	5097 Waterfall Way	San Francisco	CA	11225	USA	\N	\N	664-555-4189	\N	\N	\N	www.highfill-waggonermachinerygroup.com	\N	\N	\N	\N	5097 Waterfall Way	San Francisco	CA	11225	USA	0
9ad78299-6c72-66e4-74d1-438dfb8d9bcb	2005-11-30 19:22:03	2005-11-30 19:22:03	1	beth_id	1	D & G Estes Transportation, Inc	\N	Distribution	Transportation	\N	\N	1720 Medburn St	Burien	WA	81017	USA	\N	\N	629-555-9653	\N	\N	\N	www.dgestestransportation,inc.com	\N	\N	\N	\N	1720 Medburn St	Burien	WA	81017	USA	0
e85ffc5b-c699-2dbd-c014-438dfbaf09a1	2005-11-30 19:22:03	2005-11-30 19:22:03	1	matt_id	1	Estes-Jarmillo Engineering, Ltd	\N	Supply	Engineering	\N	\N	6633 Military East	Camacho	Zacatecas	66212	Mexico	\N	\N	440-555-6346	\N	\N	\N	www.estes-jarmilloengineering,ltd.com	\N	\N	\N	\N	6633 Military East	Camacho	Zacatecas	66212	Mexico	0
5f03bf7a-fd7e-e9a7-db69-438dfba8a354	2005-11-30 19:22:04	2005-11-30 19:22:04	1	jaime_id	1	Z & L Steele Construction, Ltd	\N	Supply	Construction	\N	\N	6165 Silverwood Drive	Kirkland	WA	31667	USA	\N	\N	667-555-5096	\N	\N	\N	www.zlsteeleconstruction,ltd.com	\N	\N	\N	\N	6165 Silverwood Drive	Kirkland	WA	31667	USA	0
af8cf563-7e1e-cbda-c837-438dfba030fb	2005-11-30 19:22:04	2005-11-30 19:22:04	1	will_id	1	Steele-Thompson Transportation Group	\N	Manufacturing	Transportation	\N	\N	3989 Crestwood Circle	Spokane	WA	53523	USA	\N	\N	741-555-4074	\N	\N	\N	www.steele-thompsontransportationgroup.com	\N	\N	\N	\N	3989 Crestwood Circle	Spokane	WA	53523	USA	0
98c806a1-600c-08bb-697c-438dfbc8eb58	2005-11-30 19:22:05	2005-11-30 19:22:05	1	max_id	1	V & P Howard Transportation Corp	\N	Consulting	Transportation	\N	\N	3775 Hilltop Dr.	Puyallup	WA	55638	USA	\N	\N	990-555-1453	\N	\N	\N	www.vphowardtransportationcorp.com	\N	\N	\N	\N	3775 Hilltop Dr.	Puyallup	WA	55638	USA	0
571ba74f-afdf-9159-0899-438dfb3eb14d	2005-11-30 19:22:05	2005-11-30 19:22:05	1	will_id	1	Howard-Elliott Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	9196 Landana Dr.	Renton	WA	45864	USA	\N	\N	187-555-8060	\N	\N	\N	www.howard-elliotttelecommunications,inc.com	\N	\N	\N	\N	9196 Landana Dr.	Renton	WA	45864	USA	0
e0418399-719d-3607-9e7f-438dfb72fae9	2005-11-30 19:22:05	2005-11-30 19:22:05	1	matt_id	1	F & X Kobylinski Communications Partners	\N	Consulting	Communications	\N	\N	1893 Argyll Ave.	Berkeley	CA	14141	USA	\N	\N	459-555-4067	\N	\N	\N	www.fxkobylinskicommunicationspartners.com	\N	\N	\N	\N	1893 Argyll Ave.	Berkeley	CA	14141	USA	0
92ab49c9-ee9b-e5d2-43d8-438dfb969816	2005-11-30 19:22:06	2005-11-30 19:22:06	1	sally_id	1	Kobylinski-Verdad Communications Holdings	\N	Distribution	Communications	\N	\N	225 San Miguel Rd.	Haney	BC	95821	Canada	\N	\N	817-555-3960	\N	\N	\N	www.kobylinski-verdadcommunicationsholdings.com	\N	\N	\N	\N	225 San Miguel Rd.	Haney	BC	95821	Canada	0
df7de535-ff70-7af4-cb91-438dfbc9af09	2005-11-30 19:22:06	2005-11-30 19:22:06	1	sarah_id	1	S & X Browning Engineering Partners	\N	Distribution	Engineering	\N	\N	3175 Olivera Rd.	Redmond	WA	30259	USA	\N	\N	452-555-2253	\N	\N	\N	www.sxbrowningengineeringpartners.com	\N	\N	\N	\N	3175 Olivera Rd.	Redmond	WA	30259	USA	0
1bb1c78c-3ccd-b176-be2b-438dfb317c0e	2005-11-30 19:22:07	2005-11-30 19:22:07	1	sarah_id	1	Browning-Lyeba Transportation, Inc	\N	Supply	Transportation	\N	\N	4416 Harvard Drive	Santa Cruz	CA	51809	USA	\N	\N	594-555-6117	\N	\N	\N	www.browning-lyebatransportation,inc.com	\N	\N	\N	\N	4416 Harvard Drive	Santa Cruz	CA	51809	USA	0
a5b8eb90-51f1-e1ff-ad22-438dfb208ceb	2005-11-30 19:22:07	2005-11-30 19:22:07	1	sarah_id	1	H & N Handley Machinery Corp	\N	Supply	Machinery	\N	\N	7620 Del Vista	Coronado	CA	51408	USA	\N	\N	491-555-6696	\N	\N	\N	www.hnhandleymachinerycorp.com	\N	\N	\N	\N	7620 Del Vista	Coronado	CA	51408	USA	0
f2df2e86-0c13-c5ba-c500-438dfb56c033	2005-11-30 19:22:07	2005-11-30 19:22:07	1	will_id	1	Handley-Meyerhoff Machinery Associates	\N	Supply	Machinery	\N	\N	9115 Arthur Rd.	Fremont	CA	66587	USA	\N	\N	348-555-9684	\N	\N	\N	www.handley-meyerhoffmachineryassociates.com	\N	\N	\N	\N	9115 Arthur Rd.	Fremont	CA	66587	USA	0
4c13abc6-b8e1-c1ae-8ba7-438dfb9ec64a	2005-11-30 19:22:08	2005-11-30 19:22:08	1	max_id	1	G & W Vigil Transportation, Inc	\N	Distribution	Transportation	\N	\N	2574 Napa	Renton	WA	71418	USA	\N	\N	929-555-5234	\N	\N	\N	www.gwvigiltransportation,inc.com	\N	\N	\N	\N	2574 Napa	Renton	WA	71418	USA	0
9c1b9f81-bfac-e57b-5ffe-438dfb441499	2005-11-30 19:22:08	2005-11-30 19:22:08	1	matt_id	1	Vigil-Gash Machinery Corp	\N	Manufacturing	Machinery	\N	\N	6979 Euclid Ave.	Ballard	WA	25291	USA	\N	\N	694-555-4670	\N	\N	\N	www.vigil-gashmachinerycorp.com	\N	\N	\N	\N	6979 Euclid Ave.	Ballard	WA	25291	USA	0
cc387178-6c46-a15a-2fe6-438dfb374c74	2005-11-30 19:22:08	2005-11-30 19:22:08	1	beth_id	1	V & B Greer Transportation Holdings	\N	Supply	Transportation	\N	\N	3348 Del Vista Court	Salem	OR	29922	USA	\N	\N	637-555-2505	\N	\N	\N	www.vbgreertransportationholdings.com	\N	\N	\N	\N	3348 Del Vista Court	Salem	OR	29922	USA	0
268fd281-bad6-2ceb-8bbc-438dfb22fc8c	2005-11-30 19:22:09	2005-11-30 19:22:09	1	beth_id	1	Greer-Benson Construction Company	\N	Consulting	Construction	\N	\N	5351 N. Civic Dr.	Lemon Grove	CA	48956	USA	\N	\N	425-555-9570	\N	\N	\N	www.greer-bensonconstructioncompany.com	\N	\N	\N	\N	5351 N. Civic Dr.	Lemon Grove	CA	48956	USA	0
94982e2e-3f66-9441-e92b-438dfbddd2e5	2005-11-30 19:22:09	2005-11-30 19:22:09	1	max_id	1	C & A Mitzner Engineering Group	\N	Supply	Engineering	\N	\N	4630 Concord Blvd.	Olympia	WA	19748	USA	\N	\N	390-555-6034	\N	\N	\N	www.camitznerengineeringgroup.com	\N	\N	\N	\N	4630 Concord Blvd.	Olympia	WA	19748	USA	0
c4aedb48-1af4-dc3f-f3c7-438dfb1a48c0	2005-11-30 19:22:09	2005-11-30 19:22:09	1	kristen_id	1	Mitzner-Brooks Construction, Ltd	\N	Consulting	Construction	\N	\N	9543 West I St.	Beaverton	OR	49447	USA	\N	\N	202-555-2727	\N	\N	\N	www.mitzner-brooksconstruction,ltd.com	\N	\N	\N	\N	9543 West I St.	Beaverton	OR	49447	USA	0
1e63f0f0-a1bb-ec9b-b3b8-438dfbc720ee	2005-11-30 19:22:10	2005-11-30 19:22:10	1	chris_id	1	U & S Hass Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	8452 Pine Hollow Rd.	Cliffside	BC	67189	Canada	\N	\N	429-555-1477	\N	\N	\N	www.ushasstransportation,inc.com	\N	\N	\N	\N	8452 Pine Hollow Rd.	Cliffside	BC	67189	Canada	0
aa8b2195-f958-e7d7-9ddb-438dfb8ebf80	2005-11-30 19:22:10	2005-11-30 19:22:10	1	will_id	1	Hass-Netz Construction Group	\N	Distribution	Construction	\N	\N	6275 Bel Air Drive	Redmond	WA	91253	USA	\N	\N	502-555-9455	\N	\N	\N	www.hass-netzconstructiongroup.com	\N	\N	\N	\N	6275 Bel Air Drive	Redmond	WA	91253	USA	0
daaf0fbd-ade6-d9bd-38ce-438dfbb8b158	2005-11-30 19:22:10	2005-11-30 19:22:10	1	sarah_id	1	N & W Hill Transportation Corp	\N	Distribution	Transportation	\N	\N	6062 Sudan Loop	Seattle	WA	93368	USA	\N	\N	752-555-6834	\N	\N	\N	www.nwhilltransportationcorp.com	\N	\N	\N	\N	6062 Sudan Loop	Seattle	WA	93368	USA	0
16ede1f8-2014-d5da-74e5-438dfba39ec3	2005-11-30 19:22:11	2005-11-30 19:22:11	1	matt_id	1	Hill-Drury Engineering Partners	\N	Supply	Engineering	\N	\N	4139 Bailey Road	Vancouver	BC	10888	Canada	\N	\N	848-555-4441	\N	\N	\N	www.hill-druryengineeringpartners.com	\N	\N	\N	\N	4139 Bailey Road	Vancouver	BC	10888	Canada	0
863ce0cb-c3b2-a2e2-3c24-438dfb60a8fd	2005-11-30 19:22:11	2005-11-30 19:22:11	1	sarah_id	1	O & D White Communications Associates	\N	Distribution	Communications	\N	\N	4180 Valley Manor	Lynnwood	WA	78163	USA	\N	\N	221-555-9448	\N	\N	\N	www.odwhitecommunicationsassociates.com	\N	\N	\N	\N	4180 Valley Manor	Lynnwood	WA	78163	USA	0
1d21fa61-f1ec-b3c3-108d-438dfbc1ba7c	2005-11-30 19:22:12	2005-11-30 19:22:12	1	sally_id	1	White-Kahl Transportation Company	\N	Consulting	Transportation	\N	\N	5167 Oakmead	Hidalgo	Zacatecas	60844	Mexico	\N	\N	579-555-9341	\N	\N	\N	www.white-kahltransportationcompany.com	\N	\N	\N	\N	5167 Oakmead	Hidalgo	Zacatecas	60844	Mexico	0
4d1789b7-3e5c-005c-5bc6-438dfb48ed0c	2005-11-30 19:22:12	2005-11-30 19:22:12	1	sally_id	1	M & Y Aguilar Communications, Ltd	\N	Supply	Communications	\N	\N	5461 Sunview Terrace	Lebanon	OR	67990	USA	\N	\N	565-555-4551	\N	\N	\N	www.myaguilarcommunications,ltd.com	\N	\N	\N	\N	5461 Sunview Terrace	Lebanon	OR	67990	USA	0
9ef17cae-5cff-52f2-b8f6-438dfb8a9336	2005-11-30 19:22:12	2005-11-30 19:22:12	1	beth_id	1	Aguilar-Vanderbout Communications Associates	\N	Consulting	Communications	\N	\N	6702 Woodsworth Lane	Haney	BC	16832	Canada	\N	\N	946-555-3073	\N	\N	\N	www.aguilar-vanderboutcommunicationsassociates.com	\N	\N	\N	\N	6702 Woodsworth Lane	Haney	BC	16832	Canada	0
cf131d8b-9fe6-7663-f52f-438dfb9b02c6	2005-11-30 19:22:12	2005-11-30 19:22:12	1	max_id	1	B & D Visser Machinery Partners	\N	Consulting	Machinery	\N	\N	9907 Via Appia	Pomona	CA	89138	USA	\N	\N	603-555-8994	\N	\N	\N	www.bdvissermachinerypartners.com	\N	\N	\N	\N	9907 Via Appia	Pomona	CA	89138	USA	0
29836014-3a39-deac-1cd1-438dfbac8ab2	2005-11-30 19:22:13	2005-11-30 19:22:13	1	sarah_id	1	Visser-Sanchez Construction Partners	\N	Manufacturing	Construction	\N	\N	1403 McMillan Ave.	Redwood City	CA	41438	USA	\N	\N	107-555-6144	\N	\N	\N	www.visser-sanchezconstructionpartners.com	\N	\N	\N	\N	1403 McMillan Ave.	Redwood City	CA	41438	USA	0
5998aee4-86a3-263e-e38c-438dfb952cd8	2005-11-30 19:22:13	2005-11-30 19:22:13	1	kristen_id	1	H & E Spicer Machinery Group	\N	Supply	Machinery	\N	\N	7516 Laguna Street	Vancouver	BC	93580	Canada	\N	\N	926-555-5351	\N	\N	\N	www.hespicermachinerygroup.com	\N	\N	\N	\N	7516 Laguna Street	Vancouver	BC	93580	Canada	0
ab04e4f7-4808-7a3a-9d6a-438dfb8750ef	2005-11-30 19:22:13	2005-11-30 19:22:13	1	beth_id	1	Spicer-Medina Electronics Holdings	\N	Supply	Electronics	\N	\N	9266 Trees Drive	Daly City	CA	47453	USA	\N	\N	453-555-1130	\N	\N	\N	www.spicer-medinaelectronicsholdings.com	\N	\N	\N	\N	9266 Trees Drive	Daly City	CA	47453	USA	0
dc9c513e-6661-d1ce-f317-438dfb5c6d58	2005-11-30 19:22:13	2005-11-30 19:22:13	1	max_id	1	X & M Young Construction Corp	\N	Manufacturing	Construction	\N	\N	5634 Blue Ridge Drive	La Jolla	CA	78376	USA	\N	\N	395-555-7966	\N	\N	\N	www.xmyoungconstructioncorp.com	\N	\N	\N	\N	5634 Blue Ridge Drive	La Jolla	CA	78376	USA	0
571e34d2-5904-1c4e-fb8e-438dfbddf351	2005-11-30 19:22:14	2005-11-30 19:22:14	1	sally_id	1	Young-Krupka Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	294 La Vuelta	Arcadia	CA	97410	USA	\N	\N	184-555-6030	\N	\N	\N	www.young-krupkatelecommunications,ltd.com	\N	\N	\N	\N	294 La Vuelta	Arcadia	CA	97410	USA	0
8a079568-e82a-9f09-d3d4-438dfb37c239	2005-11-30 19:22:14	2005-11-30 19:22:14	1	chris_id	1	I & M Buensalido Transportation, Ltd	\N	Supply	Transportation	\N	\N	6916 Azores	Grossmont	CA	68202	USA	\N	\N	149-555-2494	\N	\N	\N	www.imbuensalidotransportation,ltd.com	\N	\N	\N	\N	6916 Azores	Grossmont	CA	68202	USA	0
d94d9c49-9e7e-6f02-e077-438dfb93f40f	2005-11-30 19:22:14	2005-11-30 19:22:14	1	will_id	1	Buensalido-Donovan Electronics Corp	\N	Manufacturing	Electronics	\N	\N	1830 Shore Rd.	San Andres	DF	53398	Mexico	\N	\N	199-555-2844	\N	\N	\N	www.buensalido-donovanelectronicscorp.com	\N	\N	\N	\N	1830 Shore Rd.	San Andres	DF	53398	Mexico	0
1567c52a-c9fa-8585-e646-438dfb66bda9	2005-11-30 19:22:15	2005-11-30 19:22:15	1	kristen_id	1	H & Y Smith Engineering, Inc	\N	Distribution	Engineering	\N	\N	1362 Geary Road	Victoria	BC	89351	Canada	\N	\N	188-555-6937	\N	\N	\N	www.hysmithengineering,inc.com	\N	\N	\N	\N	1362 Geary Road	Victoria	BC	89351	Canada	0
460a8351-5516-8efa-cc7e-438dfb3ec28b	2005-11-30 19:22:15	2005-11-30 19:22:15	1	jaime_id	1	Smith-Gentile Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	6529 Buena Vista	Downey	CA	40708	USA	\N	\N	261-555-5916	\N	\N	\N	www.smith-gentiletelecommunications,ltd.com	\N	\N	\N	\N	6529 Buena Vista	Downey	CA	40708	USA	0
7668abc9-efc4-f8c6-4968-438dfb4d1ecc	2005-11-30 19:22:15	2005-11-30 19:22:15	1	sally_id	1	D & A Tancredy Machinery Group	\N	Manufacturing	Machinery	\N	\N	6316 Parkway Drive	San Carlos	CA	42823	USA	\N	\N	638-555-4692	\N	\N	\N	www.datancredymachinerygroup.com	\N	\N	\N	\N	6316 Parkway Drive	San Carlos	CA	42823	USA	0
c8788aba-6a1e-c258-caf7-438dfb46e44a	2005-11-30 19:22:15	2005-11-30 19:22:15	1	max_id	1	Tancredy-Wilson Construction Associates	\N	Consulting	Construction	\N	\N	4393 Ridge Road	Newport Beach	CA	59342	USA	\N	\N	734-555-2299	\N	\N	\N	www.tancredy-wilsonconstructionassociates.com	\N	\N	\N	\N	4393 Ridge Road	Newport Beach	CA	59342	USA	0
477701eb-6645-9ccb-33d7-438dfb7ba579	2005-11-30 19:22:16	2005-11-30 19:22:16	1	max_id	1	D & Z Leri Electronics, Ltd	\N	Consulting	Electronics	\N	\N	7089 Monti Circle	Sooke	BC	27618	Canada	\N	\N	346-555-1963	\N	\N	\N	www.dzlerielectronics,ltd.com	\N	\N	\N	\N	7089 Monti Circle	Sooke	BC	27618	Canada	0
543e70ac-6e33-8917-5565-438dfb360fb5	2005-11-30 19:22:16	2005-11-30 19:22:16	1	kristen_id	1	Leri-Carr Engineering Corp	\N	Consulting	Engineering	\N	\N	5421 Almond Avenue	Arcadia	CA	83006	USA	\N	\N	465-555-7199	\N	\N	\N	www.leri-carrengineeringcorp.com	\N	\N	\N	\N	5421 Almond Avenue	Arcadia	CA	83006	USA	0
e75c3ecb-99f2-dadf-5d15-438dfbf076d3	2005-11-30 19:22:16	2005-11-30 19:22:16	1	will_id	1	Q & Q Zobairi Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	8371 Marlesta Rd	Olympia	WA	17445	USA	\N	\N	999-555-5492	\N	\N	\N	www.qqzobairitelecommunicationsassociates.com	\N	\N	\N	\N	8371 Marlesta Rd	Olympia	WA	17445	USA	0
443cbfd7-d176-1227-049b-438dfb1483d1	2005-11-30 19:22:17	2005-11-30 19:22:17	1	max_id	1	Zobairi-Zimmerman Engineering Company	\N	Manufacturing	Engineering	\N	\N	6957 Olivewood Ct.	Shawnee	BC	38994	Canada	\N	\N	480-555-4013	\N	\N	\N	www.zobairi-zimmermanengineeringcompany.com	\N	\N	\N	\N	6957 Olivewood Ct.	Shawnee	BC	38994	Canada	0
981fe79f-b6ca-8f21-c19c-438dfb4c4ebe	2005-11-30 19:22:17	2005-11-30 19:22:17	1	matt_id	1	Y & R Sherfy Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	162 Maureen Lane	Burien	WA	38593	USA	\N	\N	138-555-9935	\N	\N	\N	www.yrsherfymachinery,inc.com	\N	\N	\N	\N	162 Maureen Lane	Burien	WA	38593	USA	0
e969de4c-f3b5-0f2e-b5ac-438dfbeb1d30	2005-11-30 19:22:17	2005-11-30 19:22:17	1	sarah_id	1	Sherfy-Behnke Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	1657 Morengo Ct.	Torrance	CA	26305	USA	\N	\N	541-555-7085	\N	\N	\N	www.sherfy-behnkeengineering,inc.com	\N	\N	\N	\N	1657 Morengo Ct.	Torrance	CA	26305	USA	0
26d4ce17-e466-3006-20f2-438dfb6b462a	2005-11-30 19:22:18	2005-11-30 19:22:18	1	kristen_id	1	E & F Tu Machinery, Ltd	\N	Consulting	Machinery	\N	\N	7770 Brodia Court	N. Vancouver	BC	91065	Canada	\N	\N	461-555-6292	\N	\N	\N	www.eftumachinery,ltd.com	\N	\N	\N	\N	7770 Brodia Court	N. Vancouver	BC	91065	Canada	0
579dad95-4140-81fe-b554-438dfb1a04c7	2005-11-30 19:22:18	2005-11-30 19:22:18	1	chris_id	1	Tu-Harris Transportation Holdings	\N	Distribution	Transportation	\N	\N	9520 Milburn Dr.	San Carlos	CA	37444	USA	\N	\N	888-555-2070	\N	\N	\N	www.tu-harristransportationholdings.com	\N	\N	\N	\N	9520 Milburn Dr.	San Carlos	CA	37444	USA	0
8a6dd188-d156-8ec3-3281-438dfba5aeaf	2005-11-30 19:22:18	2005-11-30 19:22:18	1	will_id	1	N & O Faubert Electronics, Inc	\N	Supply	Electronics	\N	\N	5888 Salem St.	Concord	CA	42074	USA	\N	\N	830-555-8906	\N	\N	\N	www.nofaubertelectronics,inc.com	\N	\N	\N	\N	5888 Salem St.	Concord	CA	42074	USA	0
ba82c3c4-e4ec-b757-fa28-438dfbd013aa	2005-11-30 19:22:18	2005-11-30 19:22:18	1	kristen_id	1	Faubert-Bonilla Machinery Group	\N	Distribution	Machinery	\N	\N	548 Stony Hill Circle	Lake Oswego	OR	61108	USA	\N	\N	618-555-6970	\N	\N	\N	www.faubert-bonillamachinerygroup.com	\N	\N	\N	\N	548 Stony Hill Circle	Lake Oswego	OR	61108	USA	0
17d4f4fb-a181-0c9b-821a-438dfbffc092	2005-11-30 19:22:19	2005-11-30 19:22:19	1	beth_id	1	U & W Hirschboeck Construction Corp	\N	Supply	Construction	\N	\N	1073 Bonnie Lane	La Cruz	Sinaloa	58192	Mexico	\N	\N	935-555-9352	\N	\N	\N	www.uwhirschboeckconstructioncorp.com	\N	\N	\N	\N	1073 Bonnie Lane	La Cruz	Sinaloa	58192	Mexico	0
69938c8b-9b0b-4890-abe3-438dfb85413f	2005-11-30 19:22:19	2005-11-30 19:22:19	1	max_id	1	Hirschboeck-VanHarn Electronics Company	\N	Consulting	Electronics	\N	\N	8641 Summitview Dr.	Orizaba	Veracruz	43388	Mexico	\N	\N	985-555-9702	\N	\N	\N	www.hirschboeck-vanharnelectronicscompany.com	\N	\N	\N	\N	8641 Summitview Dr.	Orizaba	Veracruz	43388	Mexico	0
a3e600ee-970a-cee2-8b37-438dfbca1077	2005-11-30 19:22:20	2005-11-30 19:22:20	1	chris_id	1	M & K Steffen Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	5518 San Rafael	West Covina	CA	79341	USA	\N	\N	973-555-4795	\N	\N	\N	www.mksteffentelecommunications,ltd.com	\N	\N	\N	\N	5518 San Rafael	West Covina	CA	79341	USA	0
9f11ccea-052b-e25c-6624-438dfb271b6e	2005-11-30 19:22:20	2005-11-30 19:22:20	1	sarah_id	1	Steffen-Flynn Machinery, Ltd	\N	Consulting	Machinery	\N	\N	3342 Sea Point Way	Tacoma	WA	30699	USA	\N	\N	146-555-3773	\N	\N	\N	www.steffen-flynnmachinery,ltd.com	\N	\N	\N	\N	3342 Sea Point Way	Tacoma	WA	30699	USA	0
efe77bde-c437-665f-9060-438dfb780bc9	2005-11-30 19:22:20	2005-11-30 19:22:20	1	beth_id	1	L & E Richardson Communications Partners	\N	Distribution	Communications	\N	\N	3128 Ramsey Circle	Edmonds	WA	32814	USA	\N	\N	396-555-1152	\N	\N	\N	www.lerichardsoncommunicationspartners.com	\N	\N	\N	\N	3128 Ramsey Circle	Edmonds	WA	32814	USA	0
6e0daa10-3e3b-58ad-c869-438dfbfedbd4	2005-11-30 19:22:21	2005-11-30 19:22:21	1	sally_id	1	Richardson-Brew Construction Holdings	\N	Consulting	Construction	\N	\N	1206 San Simeon Drive	Corvallis	OR	23040	USA	\N	\N	493-555-7759	\N	\N	\N	www.richardson-brewconstructionholdings.com	\N	\N	\N	\N	1206 San Simeon Drive	Corvallis	OR	23040	USA	0
a0b9b02e-61de-5f22-07ed-438dfb253137	2005-11-30 19:22:21	2005-11-30 19:22:21	1	kristen_id	1	W & N Cook Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	1246 Glenside Ct.	La Jolla	CA	90316	USA	\N	\N	104-555-7423	\N	\N	\N	www.wncooktelecommunicationspartners.com	\N	\N	\N	\N	1246 Glenside Ct.	La Jolla	CA	90316	USA	0
f1d43701-d60b-cd1a-e59e-438dfbc6cdb6	2005-11-30 19:22:21	2005-11-30 19:22:21	1	sally_id	1	Cook-Thompson Transportation Holdings	\N	Consulting	Transportation	\N	\N	9577 Santa Fe	Richmond	BC	72996	Canada	\N	\N	223-555-3659	\N	\N	\N	www.cook-thompsontransportationholdings.com	\N	\N	\N	\N	9577 Santa Fe	Richmond	BC	72996	Canada	0
2dcaf8ac-1e3b-52e5-2f79-438dfb2abe72	2005-11-30 19:22:22	2005-11-30 19:22:22	1	beth_id	1	V & A Gentry Transportation Corp	\N	Consulting	Transportation	\N	\N	2528 Fall Creek Road	Newton	BC	74354	Canada	\N	\N	758-555-1952	\N	\N	\N	www.vagentrytransportationcorp.com	\N	\N	\N	\N	2528 Fall Creek Road	Newton	BC	74354	Canada	0
5df5e2e9-5db1-4193-bd90-438dfb97c738	2005-11-30 19:22:22	2005-11-30 19:22:22	1	max_id	1	Gentry-Heckman Communications Corp	\N	Consulting	Communications	\N	\N	3769 Loma Linda	Coronado	CA	28984	USA	\N	\N	239-555-9473	\N	\N	\N	www.gentry-heckmancommunicationscorp.com	\N	\N	\N	\N	3769 Loma Linda	Coronado	CA	28984	USA	0
d36355c8-e0d2-1427-3d27-438dfb8d905d	2005-11-30 19:22:22	2005-11-30 19:22:22	1	sally_id	1	T & A Reasoner Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	6973 Mt. Hood Circle	Vancouver	BC	28584	Canada	\N	\N	797-555-6395	\N	\N	\N	www.tareasonerelectronics,inc.com	\N	\N	\N	\N	6973 Mt. Hood Circle	Vancouver	BC	28584	Canada	0
fa620e7e-59f5-1a0c-c09c-438dfb095eb5	2005-11-30 19:22:23	2005-11-30 19:22:23	1	matt_id	1	Reasoner-Wheeler Construction Associates	\N	Manufacturing	Construction	\N	\N	8468 Buena Vista	N. Vancouver	BC	16295	Canada	\N	\N	300-555-3545	\N	\N	\N	www.reasoner-wheelerconstructionassociates.com	\N	\N	\N	\N	8468 Buena Vista	N. Vancouver	BC	16295	Canada	0
3fe3554d-2b2d-aea4-8ef6-438dfb9dcb8f	2005-11-30 19:22:23	2005-11-30 19:22:23	1	chris_id	1	D & D Weller Electronics Holdings	\N	Supply	Electronics	\N	\N	1927 Chablis Court	Acapulco	Guerrero	54763	Mexico	\N	\N	220-555-2752	\N	\N	\N	www.ddwellerelectronicsholdings.com	\N	\N	\N	\N	1927 Chablis Court	Acapulco	Guerrero	54763	Mexico	0
703c1b7e-8570-46c2-7f7c-438dfbf84b5f	2005-11-30 19:22:23	2005-11-30 19:22:23	1	sarah_id	1	Weller-Bloomberg Machinery, Inc	\N	Distribution	Machinery	\N	\N	6332 N. Thompson Rd	Grossmont	CA	34929	USA	\N	\N	998-555-4448	\N	\N	\N	www.weller-bloombergmachinery,inc.com	\N	\N	\N	\N	6332 N. Thompson Rd	Grossmont	CA	34929	USA	0
e6576172-75fb-f3d3-7b86-438dfb157db9	2005-11-30 19:22:23	2005-11-30 19:22:23	1	sally_id	1	I & V Netz Engineering, Inc	\N	Distribution	Engineering	\N	\N	2701 Sierra Rd	Redmond	WA	62621	USA	\N	\N	940-555-2284	\N	\N	\N	www.ivnetzengineering,inc.com	\N	\N	\N	\N	2701 Sierra Rd	Redmond	WA	62621	USA	0
66fa9906-6c40-fdf0-a2e1-438dfbfe512b	2005-11-30 19:22:24	2005-11-30 19:22:24	1	beth_id	1	Netz-Green Construction, Ltd	\N	Manufacturing	Construction	\N	\N	4704 Tustin Court	National City	CA	81655	USA	\N	\N	728-555-9348	\N	\N	\N	www.netz-greenconstruction,ltd.com	\N	\N	\N	\N	4704 Tustin Court	National City	CA	81655	USA	0
9a1f12a5-9343-222f-e3e6-438dfb777755	2005-11-30 19:22:24	2005-11-30 19:22:24	1	matt_id	1	K & R Bobbitt Communications Group	\N	Consulting	Communications	\N	\N	3982 San Michele Drive	Marysville	WA	52447	USA	\N	\N	933-555-9469	\N	\N	\N	www.krbobbittcommunicationsgroup.com	\N	\N	\N	\N	3982 San Michele Drive	Marysville	WA	52447	USA	0
cad99cf8-0af8-2048-a57a-438dfbdb0c2a	2005-11-30 19:22:24	2005-11-30 19:22:24	1	jaime_id	1	Bobbitt-Boston Engineering Associates	\N	Distribution	Engineering	\N	\N	8895 Margo Dr.	Kirkland	WA	37643	USA	\N	\N	744-555-6162	\N	\N	\N	www.bobbitt-bostonengineeringassociates.com	\N	\N	\N	\N	8895 Margo Dr.	Kirkland	WA	37643	USA	0
28db0226-8ff5-a194-6afd-438dfbd26c02	2005-11-30 19:22:25	2005-11-30 19:22:25	1	max_id	1	B & P Barry Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	8428 Appia Court	Royal Oak	BC	73596	Canada	\N	\N	971-555-4912	\N	\N	\N	www.bpbarrytelecommunicationsholdings.com	\N	\N	\N	\N	8428 Appia Court	Royal Oak	BC	73596	Canada	0
58e70e90-21d7-2d97-f046-438dfb7c28a5	2005-11-30 19:22:25	2005-11-30 19:22:25	1	kristen_id	1	Barry-Chang Electronics, Ltd	\N	Distribution	Electronics	\N	\N	3596 Kingsford Dr.	Spring Valley	CA	24954	USA	\N	\N	805-555-9234	\N	\N	\N	www.barry-changelectronics,ltd.com	\N	\N	\N	\N	3596 Kingsford Dr.	Spring Valley	CA	24954	USA	0
f1f9a52c-3d9f-93d1-3fec-438dfbc77c32	2005-11-30 19:22:25	2005-11-30 19:22:25	1	chris_id	1	Q & P Carreras Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	3382 Greer Ave	Spring Valley	CA	27069	USA	\N	\N	155-555-6612	\N	\N	\N	www.qpcarrerastelecommunicationscompany.com	\N	\N	\N	\N	3382 Greer Ave	Spring Valley	CA	27069	USA	0
508543b2-9c94-99cb-e595-438dfb2abb6d	2005-11-30 19:22:26	2005-11-30 19:22:26	1	beth_id	1	Carreras-Burtis Transportation Holdings	\N	Consulting	Transportation	\N	\N	1460 Jasper Court	San Francisco	CA	43587	USA	\N	\N	251-555-4219	\N	\N	\N	www.carreras-burtistransportationholdings.com	\N	\N	\N	\N	1460 Jasper Court	San Francisco	CA	43587	USA	0
c7d12a8d-0403-3ab7-a0e3-438dfb2d63d6	2005-11-30 19:22:26	2005-11-30 19:22:26	1	kristen_id	1	G & N Sanders Communications Group	\N	Supply	Communications	\N	\N	1500 Grant Street	Burlingame	CA	11864	USA	\N	\N	763-555-3884	\N	\N	\N	www.gnsanderscommunicationsgroup.com	\N	\N	\N	\N	1500 Grant Street	Burlingame	CA	11864	USA	0
40300bde-e741-a773-4a15-438dfbeee35a	2005-11-30 19:22:27	2005-11-30 19:22:27	1	kristen_id	1	Sanders-Steinberg Construction Partners	\N	Distribution	Construction	\N	\N	2487 Riverside Drive	Portland	OR	67251	USA	\N	\N	882-555-9119	\N	\N	\N	www.sanders-steinbergconstructionpartners.com	\N	\N	\N	\N	2487 Riverside Drive	Portland	OR	67251	USA	0
347267d1-c06e-b7b5-fa65-438dfb8e8dd4	2005-11-30 19:22:27	2005-11-30 19:22:27	1	kristen_id	1	H & Y Viellieux Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	2782 San Simeon	Camacho	Zacatecas	16902	Mexico	\N	\N	517-555-7412	\N	\N	\N	www.hyviellieuxelectronics,ltd.com	\N	\N	\N	\N	2782 San Simeon	Camacho	Zacatecas	16902	Mexico	0
d7b82553-166f-c86f-4feb-438dfba34ec5	2005-11-30 19:22:27	2005-11-30 19:22:27	1	chris_id	1	Viellieux-Baugh Transportation Holdings	\N	Supply	Transportation	\N	\N	4023 Glen Court	Long Beach	CA	49531	USA	\N	\N	898-555-5934	\N	\N	\N	www.viellieux-baughtransportationholdings.com	\N	\N	\N	\N	4023 Glen Court	Long Beach	CA	49531	USA	0
7be641b1-ecdd-a545-3bbf-438dfb50769a	2005-11-30 19:22:28	2005-11-30 19:22:28	1	sarah_id	1	O & K Mullins Transportation Corp	\N	Manufacturing	Transportation	\N	\N	7227 Serafina	Downey	CA	22839	USA	\N	\N	904-555-8851	\N	\N	\N	www.okmullinstransportationcorp.com	\N	\N	\N	\N	7227 Serafina	Downey	CA	22839	USA	0
22f4419a-563a-4a6f-ab54-438dfba24b49	2005-11-30 19:22:29	2005-11-30 19:22:29	1	beth_id	1	Mullins-Maes Construction Partners	\N	Consulting	Construction	\N	\N	8722 East View Place	Palo Alto	CA	36842	USA	\N	\N	408-555-6001	\N	\N	\N	www.mullins-maesconstructionpartners.com	\N	\N	\N	\N	8722 East View Place	Palo Alto	CA	36842	USA	0
76e613b6-66dc-da59-7dc3-438dfb4fff7a	2005-11-30 19:22:29	2005-11-30 19:22:29	1	sally_id	1	D & D Trujillo Transportation, Ltd	\N	Distribution	Transportation	\N	\N	4837 Mohr Lane	Everett	WA	75310	USA	\N	\N	327-555-5209	\N	\N	\N	www.ddtrujillotransportation,ltd.com	\N	\N	\N	\N	4837 Mohr Lane	Everett	WA	75310	USA	0
cc7d000d-19c9-bb48-44fe-438dfbef8917	2005-11-30 19:22:29	2005-11-30 19:22:29	1	kristen_id	1	Trujillo-Barrington Machinery, Inc	\N	Consulting	Machinery	\N	\N	9865 Montana	Acapulco	Guerrero	29184	Mexico	\N	\N	754-555-9987	\N	\N	\N	www.trujillo-barringtonmachinery,inc.com	\N	\N	\N	\N	9865 Montana	Acapulco	Guerrero	29184	Mexico	0
dcb5074e-614a-78ef-f0ab-438dfbd631ff	2005-11-30 19:22:30	2005-11-30 19:22:30	1	beth_id	1	E & M Zuluaga Electronics Company	\N	Supply	Electronics	\N	\N	6233 Serpentine	Tlaxiaco	Oaxaca	79373	Mexico	\N	\N	696-555-7823	\N	\N	\N	www.emzuluagaelectronicscompany.com	\N	\N	\N	\N	6233 Serpentine	Tlaxiaco	Oaxaca	79373	Mexico	0
89475c72-6b72-9ca4-52f2-438dfbd736d1	2005-11-30 19:22:30	2005-11-30 19:22:30	1	matt_id	1	Zuluaga-Abo Engineering, Ltd	\N	Distribution	Engineering	\N	\N	893 Thornwood Drive	Long Beach	CA	26971	USA	\N	\N	485-555-5887	\N	\N	\N	www.zuluaga-aboengineering,ltd.com	\N	\N	\N	\N	893 Thornwood Drive	Long Beach	CA	26971	USA	0
baa43c5d-69de-a271-0c25-438dfb74fea8	2005-11-30 19:22:30	2005-11-30 19:22:30	1	matt_id	1	R & Z Azzolino Communications, Inc	\N	Distribution	Communications	\N	\N	7515 Royal Oak Rd.	Chula Vista	CA	96762	USA	\N	\N	689-555-6009	\N	\N	\N	www.rzazzolinocommunications,inc.com	\N	\N	\N	\N	7515 Royal Oak Rd.	Chula Vista	CA	96762	USA	0
ec1efaef-ce0d-bb93-ebfe-438dfb73d939	2005-11-30 19:22:30	2005-11-30 19:22:30	1	chris_id	1	Azzolino-Archuleta Machinery Partners	\N	Supply	Machinery	\N	\N	2429 Longview Road	Burien	WA	81958	USA	\N	\N	500-555-2702	\N	\N	\N	www.azzolino-archuletamachinerypartners.com	\N	\N	\N	\N	2429 Longview Road	Burien	WA	81958	USA	0
ba751781-d364-4a0d-5de6-438dfb165ad5	2005-11-30 19:22:31	2005-11-30 19:22:31	1	sarah_id	1	J & K Campos Communications Corp	\N	Supply	Communications	\N	\N	1961 Sahara Drive	Mexico City	Mexico	18912	Mexico	\N	\N	727-555-1452	\N	\N	\N	www.jkcamposcommunicationscorp.com	\N	\N	\N	\N	1961 Sahara Drive	Mexico City	Mexico	18912	Mexico	0
f1cfb3dd-1cb4-eeb4-60f4-438dfb0c1b12	2005-11-30 19:22:31	2005-11-30 19:22:31	1	sally_id	1	Campos-Unfried Construction, Ltd	\N	Supply	Construction	\N	\N	7128 Joan Ave.	Glendale	CA	69269	USA	\N	\N	561-555-5773	\N	\N	\N	www.campos-unfriedconstruction,ltd.com	\N	\N	\N	\N	7128 Joan Ave.	Glendale	CA	69269	USA	0
77504603-324f-a0d3-a501-438dfbdf4697	2005-11-30 19:22:32	2005-11-30 19:22:32	1	max_id	1	W & W Bozeman Electronics Associates	\N	Supply	Electronics	\N	\N	6915 Golden Leaf Way	Hidalgo	Zacatecas	71384	Mexico	\N	\N	811-555-3151	\N	\N	\N	www.wwbozemanelectronicsassociates.com	\N	\N	\N	\N	6915 Golden Leaf Way	Hidalgo	Zacatecas	71384	Mexico	0
aa1defb3-634a-3879-f66d-438dfb8513c3	2005-11-30 19:22:32	2005-11-30 19:22:32	1	max_id	1	Bozeman-Kassab Machinery Group	\N	Manufacturing	Machinery	\N	\N	4992 Yorba Linda	Palo Alto	CA	87902	USA	\N	\N	247-555-4416	\N	\N	\N	www.bozeman-kassabmachinerygroup.com	\N	\N	\N	\N	4992 Yorba Linda	Palo Alto	CA	87902	USA	0
2dfe29c0-10b8-8b37-ef7c-438dfb8c33e1	2005-11-30 19:22:33	2005-11-30 19:22:33	1	beth_id	1	D & G Enlow Transportation, Inc	\N	Distribution	Transportation	\N	\N	7688 P St.	Marysville	WA	29887	USA	\N	\N	632-555-2683	\N	\N	\N	www.dgenlowtransportation,inc.com	\N	\N	\N	\N	7688 P St.	Marysville	WA	29887	USA	0
82c2ab66-d0ac-9766-3603-438dfb6fd1f5	2005-11-30 19:22:33	2005-11-30 19:22:33	1	matt_id	1	Enlow-Lee Engineering, Ltd	\N	Supply	Engineering	\N	\N	6020 Regency Dr.	Concord	CA	12567	USA	\N	\N	751-555-7918	\N	\N	\N	www.enlow-leeengineering,ltd.com	\N	\N	\N	\N	6020 Regency Dr.	Concord	CA	12567	USA	0
d99ac000-1591-f7d4-645b-438dfb9c52a9	2005-11-30 19:22:33	2005-11-30 19:22:33	1	jaime_id	1	Z & L Skapinok Construction, Ltd	\N	Supply	Construction	\N	\N	8970 West 39th St	Anacortes	WA	46005	USA	\N	\N	385-555-6211	\N	\N	\N	www.zlskapinokconstruction,ltd.com	\N	\N	\N	\N	8970 West 39th St	Anacortes	WA	46005	USA	0
39f27a0e-0400-fa81-07dd-438dfb57ce13	2005-11-30 19:22:34	2005-11-30 19:22:34	1	will_id	1	Skapinok-Marsden Transportation Group	\N	Manufacturing	Transportation	\N	\N	7556 Garcia Ranch Road	Royal Oak	BC	67554	Canada	\N	\N	766-555-4733	\N	\N	\N	www.skapinok-marsdentransportationgroup.com	\N	\N	\N	\N	7556 Garcia Ranch Road	Royal Oak	BC	67554	Canada	0
6ad22ccc-c235-de00-80c7-438dfbeb8caf	2005-11-30 19:22:34	2005-11-30 19:22:34	1	max_id	1	V & P Campbell Transportation Corp	\N	Consulting	Transportation	\N	\N	3416 Cunha Ct	Oregon City	OR	67154	USA	\N	\N	424-555-1654	\N	\N	\N	www.vpcampbelltransportationcorp.com	\N	\N	\N	\N	3416 Cunha Ct	Oregon City	OR	67154	USA	0
e69e09bd-23e8-b36b-3e3a-438dfbb1062d	2005-11-30 19:22:34	2005-11-30 19:22:34	1	will_id	1	Campbell-Roberts Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	4911 Dubhe Court	San Gabriel	CA	54865	USA	\N	\N	827-555-7804	\N	\N	\N	www.campbell-robertstelecommunications,inc.com	\N	\N	\N	\N	4911 Dubhe Court	San Gabriel	CA	54865	USA	0
6b7e6016-b265-3ba5-ff42-438dfb51a9ed	2005-11-30 19:22:35	2005-11-30 19:22:35	1	matt_id	1	F & X Larkin Communications Partners	\N	Consulting	Communications	\N	\N	8370 Merced Circle	Westminster	BC	20626	Canada	\N	\N	747-555-7011	\N	\N	\N	www.fxlarkincommunicationspartners.com	\N	\N	\N	\N	8370 Merced Circle	Westminster	BC	20626	Canada	0
c2bb3f7c-9af5-a61f-a3e2-438dfb7727a9	2005-11-30 19:22:35	2005-11-30 19:22:35	1	sally_id	1	Larkin-Bitler Communications Holdings	\N	Distribution	Communications	\N	\N	2775 Delta View Ln.	Mill Valley	CA	73498	USA	\N	\N	513-555-6447	\N	\N	\N	www.larkin-bitlercommunicationsholdings.com	\N	\N	\N	\N	2775 Delta View Ln.	Mill Valley	CA	73498	USA	0
239a9544-7bdd-167e-07bd-438dfb299c59	2005-11-30 19:22:36	2005-11-30 19:22:36	1	sarah_id	1	S & X Allen Engineering Partners	\N	Distribution	Engineering	\N	\N	6488 Dublin Blvd.	Palo Alto	CA	78129	USA	\N	\N	455-555-4283	\N	\N	\N	www.sxallenengineeringpartners.com	\N	\N	\N	\N	6488 Dublin Blvd.	Palo Alto	CA	78129	USA	0
78ff9990-540c-dd40-27c5-438dfb183793	2005-11-30 19:22:36	2005-11-30 19:22:36	1	sarah_id	1	Allen-Worth Transportation, Inc	\N	Supply	Transportation	\N	\N	1147 Mellowood Street	Newport Beach	CA	95548	USA	\N	\N	904-555-7690	\N	\N	\N	www.allen-worthtransportation,inc.com	\N	\N	\N	\N	1147 Mellowood Street	Newport Beach	CA	95548	USA	0
d0923769-e322-cf84-3521-438dfb84c9ca	2005-11-30 19:22:36	2005-11-30 19:22:36	1	sarah_id	1	H & N Mauro Machinery Corp	\N	Supply	Machinery	\N	\N	7769 Holton Court	Cliffside	BC	92632	Canada	\N	\N	209-555-7811	\N	\N	\N	www.hnmauromachinerycorp.com	\N	\N	\N	\N	7769 Holton Court	Cliffside	BC	92632	Canada	0
31737d1f-1289-7fcd-5d14-438dfbd580bb	2005-11-30 19:22:37	2005-11-30 19:22:37	1	will_id	1	Mauro-Stroh Machinery Associates	\N	Supply	Machinery	\N	\N	5339 Cashew Street	Tacoma	WA	77828	USA	\N	\N	920-555-4504	\N	\N	\N	www.mauro-strohmachineryassociates.com	\N	\N	\N	\N	5339 Cashew Street	Tacoma	WA	77828	USA	0
895cc6e7-0091-44a7-21a6-438dfb1d162e	2005-11-30 19:22:37	2005-11-30 19:22:37	1	max_id	1	G & W Theriault Transportation, Inc	\N	Distribution	Transportation	\N	\N	2215 La Corte Bonita	Chula Vista	CA	14782	USA	\N	\N	247-555-3254	\N	\N	\N	www.gwtheriaulttransportation,inc.com	\N	\N	\N	\N	2215 La Corte Bonita	Chula Vista	CA	14782	USA	0
343b349e-f4d2-005d-0269-438dfbc49cbb	2005-11-30 19:22:38	2005-11-30 19:22:38	1	matt_id	1	Theriault-Ketterman Machinery Corp	\N	Manufacturing	Machinery	\N	\N	39 Southbrook Drive	Tixapan	DF	65138	Mexico	\N	\N	671-555-8150	\N	\N	\N	www.theriault-kettermanmachinerycorp.com	\N	\N	\N	\N	39 Southbrook Drive	Tixapan	DF	65138	Mexico	0
867109fb-918b-35a3-7cfd-438dfb68d6ff	2005-11-30 19:22:39	2005-11-30 19:22:39	1	beth_id	1	V & B Beavers Transportation Holdings	\N	Supply	Transportation	\N	\N	9824 San Rafael	Tixapan	DF	67253	Mexico	\N	\N	260-555-9186	\N	\N	\N	www.vbbeaverstransportationholdings.com	\N	\N	\N	\N	9824 San Rafael	Tixapan	DF	67253	Mexico	0
3931744b-5e96-d2da-5dd2-438dfb47595f	2005-11-30 19:22:39	2005-11-30 19:22:39	1	beth_id	1	Beavers-Dephillipo Construction Company	\N	Consulting	Construction	\N	\N	7902 Bates Court	Haney	BC	57480	Canada	\N	\N	357-555-6794	\N	\N	\N	www.beavers-dephillipoconstructioncompany.com	\N	\N	\N	\N	7902 Bates Court	Haney	BC	57480	Canada	0
9257041c-6deb-f667-eccd-438dfbc973ff	2005-11-30 19:22:39	2005-11-30 19:22:39	1	max_id	1	C & A Orando Engineering Group	\N	Supply	Engineering	\N	\N	7942 Palms	Lakewood	CA	25757	USA	\N	\N	629-555-2801	\N	\N	\N	www.caorandoengineeringgroup.com	\N	\N	\N	\N	7942 Palms	Lakewood	CA	25757	USA	0
19132155-4eaa-cd95-cb9f-438dfc5af020	2005-11-30 19:22:40	2005-11-30 19:22:40	1	kristen_id	1	Orando-Troxell Construction, Ltd	\N	Consulting	Construction	\N	\N	6274 San Antonio	Victoria	BC	84372	Canada	\N	\N	987-555-2694	\N	\N	\N	www.orando-troxellconstruction,ltd.com	\N	\N	\N	\N	6274 San Antonio	Victoria	BC	84372	Canada	0
e1806030-63f9-3872-1154-438dfce4e5b8	2005-11-30 19:22:40	2005-11-30 19:22:40	1	chris_id	1	U & S Gabbard Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	9224 Nob Hill Drive	La Mesa	CA	15583	USA	\N	\N	383-555-6329	\N	\N	\N	www.usgabbardtransportation,inc.com	\N	\N	\N	\N	9224 Nob Hill Drive	La Mesa	CA	15583	USA	0
692d3a91-9858-15f9-05e2-438dfc10aa6e	2005-11-30 19:22:41	2005-11-30 19:22:41	1	will_id	1	Gabbard-Lebaron Construction Group	\N	Distribution	Construction	\N	\N	466 E St.	Colma	CA	63424	USA	\N	\N	764-555-4851	\N	\N	\N	www.gabbard-lebaronconstructiongroup.com	\N	\N	\N	\N	466 E St.	Colma	CA	63424	USA	0
9c4c03e1-b5b6-b2e3-ef3a-438dfc80f2ff	2005-11-30 19:22:41	2005-11-30 19:22:41	1	sarah_id	1	N & W Hill Transportation Corp	\N	Distribution	Transportation	\N	\N	7572 Easley Drive	Acapulco	Guerrero	63024	Mexico	\N	\N	422-555-1772	\N	\N	\N	www.nwhilltransportationcorp.com	\N	\N	\N	\N	7572 Easley Drive	Acapulco	Guerrero	63024	Mexico	0
23c14364-2b8a-f05a-56c3-438dfc3bd2c7	2005-11-30 19:22:42	2005-11-30 19:22:42	1	matt_id	1	Hill-Butcher Engineering Partners	\N	Supply	Engineering	\N	\N	9067 Argonne Drive	Lemon Grove	CA	50735	USA	\N	\N	164-555-2579	\N	\N	\N	www.hill-butcherengineeringpartners.com	\N	\N	\N	\N	9067 Argonne Drive	Lemon Grove	CA	50735	USA	0
79b00146-200c-599b-f545-438dfce60df3	2005-11-30 19:22:42	2005-11-30 19:22:42	1	sarah_id	1	O & D Taurman Communications Associates	\N	Distribution	Communications	\N	\N	2526 N Willow Glen Court	Arcadia	CA	89203	USA	\N	\N	745-555-7129	\N	\N	\N	www.odtaurmancommunicationsassociates.com	\N	\N	\N	\N	2526 N Willow Glen Court	Arcadia	CA	89203	USA	0
aca283ec-2e56-abb8-9776-438dfc574914	2005-11-30 19:22:42	2005-11-30 19:22:42	1	sally_id	1	Taurman-Rachak Transportation Company	\N	Consulting	Transportation	\N	\N	6931 Erie Dr.	San Andres	DF	69368	Mexico	\N	\N	510-555-6565	\N	\N	\N	www.taurman-rachaktransportationcompany.com	\N	\N	\N	\N	6931 Erie Dr.	San Andres	DF	69368	Mexico	0
e8a00854-eae8-47ff-d743-438dfc6b7863	2005-11-30 19:22:43	2005-11-30 19:22:43	1	sally_id	1	M & Y Caro Communications, Ltd	\N	Supply	Communications	\N	\N	3300 Country View Lane	Santa Fe	DF	73998	Mexico	\N	\N	453-555-4401	\N	\N	\N	www.mycarocommunications,ltd.com	\N	\N	\N	\N	3300 Country View Lane	Santa Fe	DF	73998	Mexico	0
64c05cfe-ac02-e2d8-12bc-438dfc8b0aaf	2005-11-30 19:22:43	2005-11-30 19:22:43	1	beth_id	1	Caro-Robertson Communications Associates	\N	Consulting	Communications	\N	\N	7959 Mt. Wilson Way	Port Hammond	BC	93032	Canada	\N	\N	353-555-4725	\N	\N	\N	www.caro-robertsoncommunicationsassociates.com	\N	\N	\N	\N	7959 Mt. Wilson Way	Port Hammond	BC	93032	Canada	0
97ac316a-488e-ce89-1fc8-438dfcaec675	2005-11-30 19:22:43	2005-11-30 19:22:43	1	max_id	1	B & D Potter Machinery Partners	\N	Consulting	Machinery	\N	\N	4581 Coggins Drive	Port Orchard	WA	99162	USA	\N	\N	319-555-1189	\N	\N	\N	www.bdpottermachinerypartners.com	\N	\N	\N	\N	4581 Coggins Drive	Port Orchard	WA	99162	USA	0
20de29e6-39cc-7c65-c97a-438dfceb2640	2005-11-30 19:22:44	2005-11-30 19:22:44	1	sarah_id	1	Potter-Holmes Construction Partners	\N	Manufacturing	Construction	\N	\N	9494 Buena Vista	Downey	CA	94110	USA	\N	\N	130-555-6882	\N	\N	\N	www.potter-holmesconstructionpartners.com	\N	\N	\N	\N	9494 Buena Vista	Downey	CA	94110	USA	0
52d5aba1-bdec-b7ce-1ae1-438dfcf4428b	2005-11-30 19:22:44	2005-11-30 19:22:44	1	kristen_id	1	H & E Crouch Machinery Group	\N	Supply	Machinery	\N	\N	9027 Lancelot Dr	W. Linn	OR	31064	USA	\N	\N	357-555-5632	\N	\N	\N	www.hecrouchmachinerygroup.com	\N	\N	\N	\N	9027 Lancelot Dr	W. Linn	OR	31064	USA	0
adff7314-4992-f2b0-e2b0-438dfc5eb6ad	2005-11-30 19:22:44	2005-11-30 19:22:44	1	beth_id	1	Crouch-Henderson Electronics Holdings	\N	Supply	Electronics	\N	\N	4195 San Paolo	Lincoln Acres	CA	81421	USA	\N	\N	430-555-4611	\N	\N	\N	www.crouch-hendersonelectronicsholdings.com	\N	\N	\N	\N	4195 San Paolo	Lincoln Acres	CA	81421	USA	0
df394a46-8924-6ce8-24e4-438dfcc0045c	2005-11-30 19:22:44	2005-11-30 19:22:44	1	max_id	1	X & M Witte Construction Corp	\N	Manufacturing	Construction	\N	\N	3981 Augustine Drive	National City	CA	83536	USA	\N	\N	680-555-1989	\N	\N	\N	www.xmwitteconstructioncorp.com	\N	\N	\N	\N	3981 Augustine Drive	National City	CA	83536	USA	0
69f6e1fb-cf31-0283-314d-438dfc773540	2005-11-30 19:22:45	2005-11-30 19:22:45	1	sally_id	1	Witte-Bauer Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	2059 Brookdale Dr	Metchosin	BC	10562	Canada	\N	\N	776-555-8596	\N	\N	\N	www.witte-bauertelecommunications,ltd.com	\N	\N	\N	\N	2059 Brookdale Dr	Metchosin	BC	10562	Canada	0
c4ea893c-9696-f55c-d060-438dfc022203	2005-11-30 19:22:45	2005-11-30 19:22:45	1	chris_id	1	I & M Thompson Transportation, Ltd	\N	Supply	Transportation	\N	\N	2099 San Jose	Mill Valley	CA	68331	USA	\N	\N	149-555-4603	\N	\N	\N	www.imthompsontransportation,ltd.com	\N	\N	\N	\N	2099 San Jose	Mill Valley	CA	68331	USA	0
4e7fb6cc-21c4-f851-9763-438dfcbeec1d	2005-11-30 19:22:46	2005-11-30 19:22:46	1	will_id	1	Thompson-Sturgel Electronics Corp	\N	Manufacturing	Electronics	\N	\N	3086 Indigo Ct	El Cajon	CA	24720	USA	\N	\N	507-555-4496	\N	\N	\N	www.thompson-sturgelelectronicscorp.com	\N	\N	\N	\N	3086 Indigo Ct	El Cajon	CA	24720	USA	0
7ed9e009-9cd7-4eac-0a05-438dfcb6bd57	2005-11-30 19:22:46	2005-11-30 19:22:46	1	kristen_id	1	H & Y Gambao Engineering, Inc	\N	Distribution	Engineering	\N	\N	6036 Park Glenn	Issaquah	WA	58157	USA	\N	\N	803-555-8132	\N	\N	\N	www.hygambaoengineering,inc.com	\N	\N	\N	\N	6036 Park Glenn	Issaquah	WA	58157	USA	0
d890703c-8f14-175c-2d29-438dfc486f5d	2005-11-30 19:22:46	2005-11-30 19:22:46	1	jaime_id	1	Gambao-Snow Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	4622 Andrea Lane	Novato	CA	79707	USA	\N	\N	284-555-6653	\N	\N	\N	www.gambao-snowtelecommunications,ltd.com	\N	\N	\N	\N	4622 Andrea Lane	Novato	CA	79707	USA	0
62ca07a3-8432-3273-b5d3-438dfc2ffcd4	2005-11-30 19:22:47	2005-11-30 19:22:47	1	sally_id	1	D & A Vaughn Machinery Group	\N	Manufacturing	Machinery	\N	\N	7826 W. Hookston Road	Lincoln Acres	CA	79306	USA	\N	\N	180-555-7232	\N	\N	\N	www.davaughnmachinerygroup.com	\N	\N	\N	\N	7826 W. Hookston Road	Lincoln Acres	CA	79306	USA	0
bd1e34d7-2283-d1fb-ea70-438dfc3d837c	2005-11-30 19:22:47	2005-11-30 19:22:47	1	max_id	1	Vaughn-Baccus Construction Associates	\N	Consulting	Construction	\N	\N	9321 Quiet Place Drive	Langford	BC	67017	Canada	\N	\N	584-555-4382	\N	\N	\N	www.vaughn-baccusconstructionassociates.com	\N	\N	\N	\N	9321 Quiet Place Drive	Langford	BC	67017	Canada	0
47ce2c70-6514-da71-de9d-438dfc189dc3	2005-11-30 19:22:48	2005-11-30 19:22:48	1	max_id	1	D & Z Smith Electronics, Ltd	\N	Consulting	Electronics	\N	\N	5436 Via Del Sol	La Jolla	CA	32779	USA	\N	\N	857-555-9428	\N	\N	\N	www.dzsmithelectronics,ltd.com	\N	\N	\N	\N	5436 Via Del Sol	La Jolla	CA	32779	USA	0
a26b4d1a-8d73-2beb-6552-438dfc7b122d	2005-11-30 19:22:48	2005-11-30 19:22:48	1	kristen_id	1	Smith-Potter Engineering Corp	\N	Consulting	Engineering	\N	\N	7185 Westcliffe Place	San Gabriel	CA	85651	USA	\N	\N	623-555-8863	\N	\N	\N	www.smith-potterengineeringcorp.com	\N	\N	\N	\N	7185 Westcliffe Place	San Gabriel	CA	85651	USA	0
d2a10099-e3ec-17a9-b47c-438dfc811b36	2005-11-30 19:22:48	2005-11-30 19:22:48	1	will_id	1	Q & Q Gerber Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	3554 Trinity Ave	Glendale	CA	17574	USA	\N	\N	565-555-6699	\N	\N	\N	www.qqgerbertelecommunicationsassociates.com	\N	\N	\N	\N	3554 Trinity Ave	Glendale	CA	17574	USA	0
5da2f2ef-631b-b399-81ec-438dfc34c906	2005-11-30 19:22:49	2005-11-30 19:22:49	1	max_id	1	Gerber-Vanderslice Engineering Company	\N	Manufacturing	Engineering	\N	\N	8213 Dianda Dr	Lebanon	OR	36608	USA	\N	\N	354-555-4763	\N	\N	\N	www.gerber-vandersliceengineeringcompany.com	\N	\N	\N	\N	8213 Dianda Dr	Lebanon	OR	36608	USA	0
e085ffea-a012-5b9a-928e-438dfca18c8b	2005-11-30 19:22:49	2005-11-30 19:22:49	1	matt_id	1	Y & R Wood Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	4836 Stratton Circle	Oakland	CA	80107	USA	\N	\N	319-555-1228	\N	\N	\N	www.yrwoodmachinery,inc.com	\N	\N	\N	\N	4836 Stratton Circle	Oakland	CA	80107	USA	0
445d98cb-2bb6-5a5a-7e25-438dfce95daf	2005-11-30 19:22:50	2005-11-30 19:22:50	1	sarah_id	1	Wood-Bostwick Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	9748 Sutherland Dr	Port Hammond	BC	65303	Canada	\N	\N	130-555-6920	\N	\N	\N	www.wood-bostwickengineering,inc.com	\N	\N	\N	\N	9748 Sutherland Dr	Port Hammond	BC	65303	Canada	0
9f3832b4-60be-268b-9145-438dfc8b7a6e	2005-11-30 19:22:50	2005-11-30 19:22:50	1	kristen_id	1	E & F Corcoran Machinery, Ltd	\N	Consulting	Machinery	\N	\N	9281 Brushcreek Dr	Merida	Yucatan	22572	Mexico	\N	\N	357-555-5670	\N	\N	\N	www.efcorcoranmachinery,ltd.com	\N	\N	\N	\N	9281 Brushcreek Dr	Merida	Yucatan	22572	Mexico	0
31a30751-21d5-38ab-56e8-438dfc995474	2005-11-30 19:22:51	2005-11-30 19:22:51	1	chris_id	1	Corcoran-Good Transportation Holdings	\N	Distribution	Transportation	\N	\N	7104 May Way	Altadena	CA	52614	USA	\N	\N	431-555-4649	\N	\N	\N	www.corcoran-goodtransportationholdings.com	\N	\N	\N	\N	7104 May Way	Altadena	CA	52614	USA	0
3348b98e-721d-c914-852f-438dfc65c395	2005-11-30 19:22:51	2005-11-30 19:22:51	1	will_id	1	N & O Grosvenor Electronics, Inc	\N	Supply	Electronics	\N	\N	6891 Relis Valley Road	Santa Monica	CA	54729	USA	\N	\N	681-555-2028	\N	\N	\N	www.nogrosvenorelectronics,inc.com	\N	\N	\N	\N	6891 Relis Valley Road	Santa Monica	CA	54729	USA	0
b654628e-362d-8623-200b-438dfc160cb2	2005-11-30 19:22:51	2005-11-30 19:22:51	1	kristen_id	1	Grosvenor-Smrha Machinery Group	\N	Distribution	Machinery	\N	\N	2313 Santa Cruz Drive	Berkeley	CA	44955	USA	\N	\N	777-555-8635	\N	\N	\N	www.grosvenor-smrhamachinerygroup.com	\N	\N	\N	\N	2313 Santa Cruz Drive	Berkeley	CA	44955	USA	0
6ae0a1e2-cece-b38d-237a-438dfc684d06	2005-11-30 19:22:52	2005-11-30 19:22:52	1	beth_id	1	U & W Wright Construction Corp	\N	Supply	Construction	\N	\N	5009 Grasswood Circle	Lemon Grove	CA	13232	USA	\N	\N	262-555-6902	\N	\N	\N	www.uwwrightconstructioncorp.com	\N	\N	\N	\N	5009 Grasswood Circle	Lemon Grove	CA	13232	USA	0
c61b206d-2e30-b36f-eed5-438dfc73c046	2005-11-30 19:22:52	2005-11-30 19:22:52	1	max_id	1	Wright-Kalman Electronics Company	\N	Consulting	Electronics	\N	\N	3340 Baywood Drive	Corvallis	OR	94911	USA	\N	\N	620-555-6795	\N	\N	\N	www.wright-kalmanelectronicscompany.com	\N	\N	\N	\N	3340 Baywood Drive	Corvallis	OR	94911	USA	0
2ad884a9-8705-3671-3b1b-438dfcf263fa	2005-11-30 19:22:53	2005-11-30 19:22:53	1	chris_id	1	M & K Ponce Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	7537 Kaski Lane	Cliffside	BC	29350	Canada	\N	\N	255-555-5088	\N	\N	\N	www.mkponcetelecommunications,ltd.com	\N	\N	\N	\N	7537 Kaski Lane	Cliffside	BC	29350	Canada	0
5b392773-b350-e644-1e5f-438dfc976788	2005-11-30 19:22:53	2005-11-30 19:22:53	1	sarah_id	1	Ponce-Borrelli Machinery, Ltd	\N	Consulting	Machinery	\N	\N	8778 So. Silver Spring	El Cajon	CA	50899	USA	\N	\N	396-555-8952	\N	\N	\N	www.ponce-borrellimachinery,ltd.com	\N	\N	\N	\N	8778 So. Silver Spring	El Cajon	CA	50899	USA	0
b6f3e8a1-3732-6193-0153-438dfc83d486	2005-11-30 19:22:53	2005-11-30 19:22:53	1	beth_id	1	L & E Gillmore Communications Partners	\N	Distribution	Communications	\N	\N	1983 Santa Cruz	Burnaby	BC	50499	Canada	\N	\N	293-555-9531	\N	\N	\N	www.legillmorecommunicationspartners.com	\N	\N	\N	\N	1983 Santa Cruz	Burnaby	BC	50499	Canada	0
1ba04981-4ef6-6ed0-8e17-438dfc1eb2f6	2005-11-30 19:22:54	2005-11-30 19:22:54	1	sally_id	1	Gillmore-Mixon Construction Holdings	\N	Consulting	Construction	\N	\N	3478 Liana Lane	Bremerton	WA	38210	USA	\N	\N	697-555-6680	\N	\N	\N	www.gillmore-mixonconstructionholdings.com	\N	\N	\N	\N	3478 Liana Lane	Bremerton	WA	38210	USA	0
7492d5ae-dfba-6e60-5f6b-438dfc9ebfe6	2005-11-30 19:22:54	2005-11-30 19:22:54	1	kristen_id	1	W & N Tommerup Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	6936 Andrews Drive	San Diego	CA	39712	USA	\N	\N	377-555-2230	\N	\N	\N	www.wntommeruptelecommunicationspartners.com	\N	\N	\N	\N	6936 Andrews Drive	San Diego	CA	39712	USA	0
2ea7c9d3-0784-d9b9-2a4b-438dfcf8c620	2005-11-30 19:22:55	2005-11-30 19:22:55	1	sally_id	1	Tommerup-Martinez Transportation Holdings	\N	Consulting	Transportation	\N	\N	1342 Isla Bonita	Woodland Hills	CA	56843	USA	\N	\N	143-555-1666	\N	\N	\N	www.tommerup-martineztransportationholdings.com	\N	\N	\N	\N	1342 Isla Bonita	Woodland Hills	CA	56843	USA	0
88142010-9a16-7fad-97d5-438dfc2da9d0	2005-11-30 19:22:55	2005-11-30 19:22:55	1	beth_id	1	V & A Glancy Transportation Corp	\N	Consulting	Transportation	\N	\N	7710 Pine St	Milwaukie	OR	61474	USA	\N	\N	985-555-8502	\N	\N	\N	www.vaglancytransportationcorp.com	\N	\N	\N	\N	7710 Pine St	Milwaukie	OR	61474	USA	0
bad8904a-8332-da27-a94c-438dfcaefdb0	2005-11-30 19:22:55	2005-11-30 19:22:55	1	max_id	1	Glancy-Cappa Communications Corp	\N	Consulting	Communications	\N	\N	9713 Amhurst Way	Glendale	CA	80508	USA	\N	\N	774-555-6566	\N	\N	\N	www.glancy-cappacommunicationscorp.com	\N	\N	\N	\N	9713 Amhurst Way	Glendale	CA	80508	USA	0
7285b03b-f984-af24-7766-438dfc2d4fd1	2005-11-30 19:22:56	2005-11-30 19:22:56	1	sally_id	1	T & A Netz Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	8991 Olivera	Redmond	WA	51300	USA	\N	\N	739-555-3030	\N	\N	\N	www.tanetzelectronics,inc.com	\N	\N	\N	\N	8991 Olivera	Redmond	WA	51300	USA	0
ce702aea-7cc2-7743-d67d-438dfc418801	2005-11-30 19:22:56	2005-11-30 19:22:56	1	matt_id	1	Netz-Blanc Construction Associates	\N	Manufacturing	Construction	\N	\N	3905 Harvard Drive	Santa Anita	DF	81296	Mexico	\N	\N	550-555-8723	\N	\N	\N	www.netz-blancconstructionassociates.com	\N	\N	\N	\N	3905 Harvard Drive	Santa Anita	DF	81296	Mexico	0
5d7daa65-e669-d1cc-a6fa-438dfc8de07d	2005-11-30 19:22:57	2005-11-30 19:22:57	1	chris_id	1	D & D Collins Electronics Holdings	\N	Supply	Electronics	\N	\N	782 Veale Avenue	Oakland	CA	44542	USA	\N	\N	243-555-3528	\N	\N	\N	www.ddcollinselectronicsholdings.com	\N	\N	\N	\N	782 Veale Avenue	Oakland	CA	44542	USA	0
ba5dd704-982d-5927-37a6-438dfc7f3e9b	2005-11-30 19:22:57	2005-11-30 19:22:57	1	sarah_id	1	Collins-Scroggins Machinery, Inc	\N	Distribution	Machinery	\N	\N	8605 Flamingo Dr	Metchosin	BC	68606	Canada	\N	\N	316-555-2507	\N	\N	\N	www.collins-scrogginsmachinery,inc.com	\N	\N	\N	\N	8605 Flamingo Dr	Metchosin	BC	68606	Canada	0
4a1ee6a0-25ee-6a7a-f7a5-438dfc317653	2005-11-30 19:22:58	2005-11-30 19:22:58	1	sally_id	1	I & V Marsh Engineering, Inc	\N	Distribution	Engineering	\N	\N	8391 Olivera	Metchosin	BC	70721	Canada	\N	\N	566-555-8885	\N	\N	\N	www.ivmarshengineering,inc.com	\N	\N	\N	\N	8391 Olivera	Metchosin	BC	70721	Canada	0
d1ddc9ee-af9d-f257-89be-438dfcdc46fc	2005-11-30 19:22:58	2005-11-30 19:22:58	1	beth_id	1	Marsh-Robinson Construction, Ltd	\N	Manufacturing	Construction	\N	\N	6469 Ethan Ct	Richmond	BC	87240	Canada	\N	\N	662-555-6493	\N	\N	\N	www.marsh-robinsonconstruction,ltd.com	\N	\N	\N	\N	6469 Ethan Ct	Richmond	BC	87240	Canada	0
f5da0877-97a9-1cc3-c0ad-438dfca40468	2005-11-30 19:22:59	2005-11-30 19:22:59	1	matt_id	1	K & R Cox Communications Group	\N	Consulting	Communications	\N	\N	6509 California Street	Burbank	CA	55517	USA	\N	\N	935-555-2500	\N	\N	\N	www.krcoxcommunicationsgroup.com	\N	\N	\N	\N	6509 California Street	Burbank	CA	55517	USA	0
40f5032c-52e9-76ab-c376-438dfc53b0e6	2005-11-30 19:22:59	2005-11-30 19:22:59	1	jaime_id	1	Cox-Clare Engineering Associates	\N	Distribution	Engineering	\N	\N	7496 Sunset Meadows	Los Angeles	CA	38197	USA	\N	\N	393-555-2393	\N	\N	\N	www.cox-clareengineeringassociates.com	\N	\N	\N	\N	7496 Sunset Meadows	Los Angeles	CA	38197	USA	0
9f4db6ad-aeb6-b920-a4d0-438dfccfb949	2005-11-30 19:22:59	2005-11-30 19:22:59	1	max_id	1	B & P Barnurn Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	7791 Black Pine Lane	Coronado	CA	45343	USA	\N	\N	928-555-9686	\N	\N	\N	www.bpbarnurntelecommunicationsholdings.com	\N	\N	\N	\N	7791 Black Pine Lane	Coronado	CA	45343	USA	0
6c780887-b1a5-0c37-cb6c-438dfce0f0d3	2005-11-30 19:23:00	2005-11-30 19:23:00	1	kristen_id	1	Barnurn-Chrisman Electronics, Ltd	\N	Distribution	Electronics	\N	\N	9032 Santa Fe	La Cruz	Sinaloa	93184	Mexico	\N	\N	409-555-8207	\N	\N	\N	www.barnurn-chrismanelectronics,ltd.com	\N	\N	\N	\N	9032 Santa Fe	La Cruz	Sinaloa	93184	Mexico	0
6947c741-d69a-c50a-32c6-438dfcfba4b1	2005-11-30 19:23:00	2005-11-30 19:23:00	1	chris_id	1	Q & P Taryle Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	2237 Boca Raton Court	Shawnee	BC	66491	Canada	\N	\N	966-555-5128	\N	\N	\N	www.qptaryletelecommunicationscompany.com	\N	\N	\N	\N	2237 Boca Raton Court	Shawnee	BC	66491	Canada	0
f1013808-d829-d48e-3273-438dfc5b4db7	2005-11-30 19:23:00	2005-11-30 19:23:00	1	beth_id	1	Taryle-Spencer Transportation Holdings	\N	Consulting	Transportation	\N	\N	3732 Camino Norte	Yakima	WA	80495	USA	\N	\N	470-555-2278	\N	\N	\N	www.taryle-spencertransportationholdings.com	\N	\N	\N	\N	3732 Camino Norte	Yakima	WA	80495	USA	0
ae8527b5-109f-deea-06e4-438dfcc22740	2005-11-30 19:23:01	2005-11-30 19:23:01	1	kristen_id	1	G & N Tribble Communications Group	\N	Supply	Communications	\N	\N	9846 Powell Drive	Long Beach	CA	19964	USA	\N	\N	390-555-1486	\N	\N	\N	www.gntribblecommunicationsgroup.com	\N	\N	\N	\N	9846 Powell Drive	Long Beach	CA	19964	USA	0
15219ad3-ea69-968a-df11-438dfcfc7a29	2005-11-30 19:23:02	2005-11-30 19:23:02	1	kristen_id	1	Tribble-Skapinok Construction Partners	\N	Distribution	Construction	\N	\N	1596 Bryce Dr	Lynnwood	WA	72836	USA	\N	\N	816-555-6264	\N	\N	\N	www.tribble-skapinokconstructionpartners.com	\N	\N	\N	\N	1596 Bryce Dr	Lynnwood	WA	72836	USA	0
45b906e0-9cb3-4c7a-df6f-438dfc9be258	2005-11-30 19:23:02	2005-11-30 19:23:02	1	kristen_id	1	H & Y Belleci Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	7964 Gentrytown Drive	Port Orchard	WA	47592	USA	\N	\N	871-555-6360	\N	\N	\N	www.hybellecielectronics,ltd.com	\N	\N	\N	\N	7964 Gentrytown Drive	Port Orchard	WA	47592	USA	0
75dbb3c5-710a-b367-717c-438dfcc55f67	2005-11-30 19:23:02	2005-11-30 19:23:02	1	chris_id	1	Belleci-Armstrong Transportation Holdings	\N	Supply	Transportation	\N	\N	2624 Pome Court	Santa Anita	DF	23793	Mexico	\N	\N	659-555-4424	\N	\N	\N	www.belleci-armstrongtransportationholdings.com	\N	\N	\N	\N	2624 Pome Court	Santa Anita	DF	23793	Mexico	0
a8db442f-b908-57c2-4caf-438dfcd5c45b	2005-11-30 19:23:02	2005-11-30 19:23:02	1	sarah_id	1	O & K Koeber Transportation Corp	\N	Manufacturing	Transportation	\N	\N	9245 Escobar	Burien	WA	93584	USA	\N	\N	624-555-9888	\N	\N	\N	www.okkoebertransportationcorp.com	\N	\N	\N	\N	9245 Escobar	Burien	WA	93584	USA	0
d8fd3433-b8b5-9a6a-8f33-438dfcce7e1e	2005-11-30 19:23:02	2005-11-30 19:23:02	1	beth_id	1	Koeber-Wagner Construction Partners	\N	Consulting	Construction	\N	\N	4159 Apple Drive	Bellflower	CA	78780	USA	\N	\N	675-555-1238	\N	\N	\N	www.koeber-wagnerconstructionpartners.com	\N	\N	\N	\N	4159 Apple Drive	Bellflower	CA	78780	USA	0
14c49ab1-5c89-20b7-c3cd-438dfc37065c	2005-11-30 19:23:03	2005-11-30 19:23:03	1	sally_id	1	D & D Noice Transportation, Ltd	\N	Distribution	Transportation	\N	\N	3692 Morales	Kirkland	WA	13829	USA	\N	\N	663-555-5331	\N	\N	\N	www.ddnoicetransportation,ltd.com	\N	\N	\N	\N	3692 Morales	Kirkland	WA	13829	USA	0
4529b043-8473-f470-da4b-438dfc4ff3d2	2005-11-30 19:23:03	2005-11-30 19:23:03	1	kristen_id	1	Noice-Lindall Machinery, Inc	\N	Consulting	Machinery	\N	\N	8859 Wood Ranch Circle	San Diego	CA	64186	USA	\N	\N	736-555-4310	\N	\N	\N	www.noice-lindallmachinery,inc.com	\N	\N	\N	\N	8859 Wood Ranch Circle	San Diego	CA	64186	USA	0
cdedf12f-00c6-96ab-ead9-438dfc45f071	2005-11-30 19:23:03	2005-11-30 19:23:03	1	beth_id	1	E & M Noakes Electronics Company	\N	Supply	Electronics	\N	\N	5826 Norman Avenue	Puyallup	WA	66301	USA	\N	\N	986-555-1688	\N	\N	\N	www.emnoakeselectronicscompany.com	\N	\N	\N	\N	5826 Norman Avenue	Puyallup	WA	66301	USA	0
601fcce4-b0ac-96c8-317e-438dfccc081c	2005-11-30 19:23:04	2005-11-30 19:23:04	1	matt_id	1	Noakes-Mc Nair Engineering, Ltd	\N	Distribution	Engineering	\N	\N	3904 Piedra Drive	Sooke	BC	82820	Canada	\N	\N	182-555-8295	\N	\N	\N	www.noakes-mcnairengineering,ltd.com	\N	\N	\N	\N	3904 Piedra Drive	Sooke	BC	82820	Canada	0
ea0fe542-2c78-f2f9-e743-438dfc119cf8	2005-11-30 19:23:04	2005-11-30 19:23:04	1	matt_id	1	R & Z Ceballos Communications, Inc	\N	Distribution	Communications	\N	\N	6600 Maricopa	Richmond	CA	51096	USA	\N	\N	694-555-7960	\N	\N	\N	www.rzceballoscommunications,inc.com	\N	\N	\N	\N	6600 Maricopa	Richmond	CA	51096	USA	0
515ebf84-c673-1c9c-f5fc-438dfc99ece3	2005-11-30 19:23:05	2005-11-30 19:23:05	1	chris_id	1	Ceballos-Landrum Machinery Partners	\N	Supply	Machinery	\N	\N	4932 La Jolla	Haney	BC	74852	Canada	\N	\N	813-555-4195	\N	\N	\N	www.ceballos-landrummachinerypartners.com	\N	\N	\N	\N	4932 La Jolla	Haney	BC	74852	Canada	0
db95808c-1342-bf59-0da1-438dfcf16624	2005-11-30 19:23:05	2005-11-30 19:23:05	1	sarah_id	1	J & K Netz Communications Corp	\N	Supply	Communications	\N	\N	7882 Las Lomas Way	Redmond	WA	40922	USA	\N	\N	448-555-2488	\N	\N	\N	www.jknetzcommunicationscorp.com	\N	\N	\N	\N	7882 Las Lomas Way	Redmond	WA	40922	USA	0
432ef0db-2c18-bb20-548f-438dfccc8682	2005-11-30 19:23:06	2005-11-30 19:23:06	1	sally_id	1	Netz-Amyotte Construction, Ltd	\N	Supply	Construction	\N	\N	6467 Buena Vista	San Jose	CA	62472	USA	\N	\N	829-555-1010	\N	\N	\N	www.netz-amyotteconstruction,ltd.com	\N	\N	\N	\N	6467 Buena Vista	San Jose	CA	62472	USA	0
609003bf-2a08-438b-2cdc-438dfca0b6a1	2005-11-30 19:23:07	2005-11-30 19:23:07	1	max_id	1	W & W Watson Electronics Associates	\N	Supply	Electronics	\N	\N	9671 Leewood Place	San Diego	CA	62071	USA	\N	\N	486-555-6931	\N	\N	\N	www.wwwatsonelectronicsassociates.com	\N	\N	\N	\N	9671 Leewood Place	San Diego	CA	62071	USA	0
6204bccd-609d-2069-13ee-438dfc168e35	2005-11-30 19:23:07	2005-11-30 19:23:07	1	max_id	1	Watson-Waddle Machinery Group	\N	Manufacturing	Machinery	\N	\N	1168 Escobar	Woodland Hills	CA	49782	USA	\N	\N	580-555-4656	\N	\N	\N	www.watson-waddlemachinerygroup.com	\N	\N	\N	\N	1168 Escobar	Woodland Hills	CA	49782	USA	0
94e43fe9-95af-d874-e9fc-438dfcf5d51c	2005-11-30 19:23:07	2005-11-30 19:23:07	1	beth_id	1	D & G Shintani Transportation, Inc	\N	Distribution	Transportation	\N	\N	7281 Barberry Court	Sooke	BC	15544	Canada	\N	\N	500-555-3863	\N	\N	\N	www.dgshintanitransportation,inc.com	\N	\N	\N	\N	7281 Barberry Court	Sooke	BC	15544	Canada	0
c594dad7-18a9-dfa1-5f69-438dfca073ba	2005-11-30 19:23:07	2005-11-30 19:23:07	1	matt_id	1	Shintani-Chavez Engineering, Ltd	\N	Supply	Engineering	\N	\N	9030 Louisiana Dr.	Long Beach	CA	68416	USA	\N	\N	926-555-8642	\N	\N	\N	www.shintani-chavezengineering,ltd.com	\N	\N	\N	\N	9030 Louisiana Dr.	Long Beach	CA	68416	USA	0
1988011e-1fb0-7f64-6f56-438dfca9f939	2005-11-30 19:23:08	2005-11-30 19:23:08	1	jaime_id	1	Z & L Wilson Construction, Ltd	\N	Supply	Construction	\N	\N	5399 Red Maple Ct.	Arcadia	CA	73046	USA	\N	\N	869-555-6477	\N	\N	\N	www.zlwilsonconstruction,ltd.com	\N	\N	\N	\N	5399 Red Maple Ct.	Arcadia	CA	73046	USA	0
32300f8e-5ff9-1d8d-0510-438dfc3e860f	2005-11-30 19:23:08	2005-11-30 19:23:08	1	will_id	1	Wilson-Gill Transportation Group	\N	Manufacturing	Transportation	\N	\N	59 Sharon Place	Woodburn	OR	92080	USA	\N	\N	657-555-4542	\N	\N	\N	www.wilson-gilltransportationgroup.com	\N	\N	\N	\N	59 Sharon Place	Woodburn	OR	92080	USA	0
8e8513ea-8926-9895-3afd-438dfcf13b88	2005-11-30 19:23:08	2005-11-30 19:23:08	1	max_id	1	V & P Smallwood Transportation Corp	\N	Consulting	Transportation	\N	\N	6681 Pestana Way	Fremont	CA	89164	USA	\N	\N	622-555-1006	\N	\N	\N	www.vpsmallwoodtransportationcorp.com	\N	\N	\N	\N	6681 Pestana Way	Fremont	CA	89164	USA	0
ed96efc5-56ff-f8c8-b303-438dfcf7a76b	2005-11-30 19:23:08	2005-11-30 19:23:08	1	will_id	1	Smallwood-Chavez Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	4250 Huston Rd	Langley	BC	74360	Canada	\N	\N	673-555-1356	\N	\N	\N	www.smallwood-chaveztelecommunications,inc.com	\N	\N	\N	\N	4250 Huston Rd	Langley	BC	74360	Canada	0
4206630a-0fc2-0692-269f-438dfc3dce7a	2005-11-30 19:23:09	2005-11-30 19:23:09	1	matt_id	1	F & X Blackburn Communications Partners	\N	Consulting	Communications	\N	\N	1127 Wellington Avenue	Salem	OR	35991	USA	\N	\N	661-555-5449	\N	\N	\N	www.fxblackburncommunicationspartners.com	\N	\N	\N	\N	1127 Wellington Avenue	Salem	OR	35991	USA	0
cde328fd-1085-f663-68a5-438dfcfb2788	2005-11-30 19:23:09	2005-11-30 19:23:09	1	sally_id	1	Blackburn-Abston Communications Holdings	\N	Distribution	Communications	\N	\N	8950 Glenwood Dr.	Concord	CA	86348	USA	\N	\N	734-555-4427	\N	\N	\N	www.blackburn-abstoncommunicationsholdings.com	\N	\N	\N	\N	8950 Glenwood Dr.	Concord	CA	86348	USA	0
90a85cb5-09ae-3944-73d3-438dfc1ece40	2005-11-30 19:23:10	2005-11-30 19:23:10	1	sarah_id	1	S & X Blauvelt Engineering Partners	\N	Distribution	Engineering	\N	\N	8736 E. 62nd Street	Concord	CA	88463	USA	\N	\N	984-555-1806	\N	\N	\N	www.sxblauveltengineeringpartners.com	\N	\N	\N	\N	8736 E. 62nd Street	Concord	CA	88463	USA	0
efdf250d-2235-3922-c847-438dfc7f2648	2005-11-30 19:23:10	2005-11-30 19:23:10	1	sarah_id	1	Blauvelt-Wardley Transportation, Inc	\N	Supply	Transportation	\N	\N	6814 Gatewood Court	La Jolla	CA	78689	USA	\N	\N	180-555-8413	\N	\N	\N	www.blauvelt-wardleytransportation,inc.com	\N	\N	\N	\N	6814 Gatewood Court	La Jolla	CA	78689	USA	0
5897fd94-0082-4b99-926d-438dfceb8b63	2005-11-30 19:23:11	2005-11-30 19:23:11	1	sarah_id	1	H & N Durocher Machinery Corp	\N	Supply	Machinery	\N	\N	6854 Veale Ave.	Cliffside	BC	46966	Canada	\N	\N	692-555-8077	\N	\N	\N	www.hndurochermachinerycorp.com	\N	\N	\N	\N	6854 Veale Ave.	Cliffside	BC	46966	Canada	0
4c9833d0-3c0d-cc22-667e-438dfc2cbfe0	2005-11-30 19:23:12	2005-11-30 19:23:12	1	will_id	1	Durocher-Terbush Machinery Associates	\N	Supply	Machinery	\N	\N	5186 Oeffler Ln.	Beaverton	OR	29647	USA	\N	\N	931-555-6336	\N	\N	\N	www.durocher-terbushmachineryassociates.com	\N	\N	\N	\N	5186 Oeffler Ln.	Beaverton	OR	29647	USA	0
7e29ad13-68e1-2c33-12ac-438dfcaf4ea1	2005-11-30 19:23:12	2005-11-30 19:23:12	1	max_id	1	G & W Poisson Transportation, Inc	\N	Distribution	Transportation	\N	\N	8136 Guadalajara	Lebanon	OR	63084	USA	\N	\N	566-555-4629	\N	\N	\N	www.gwpoissontransportation,inc.com	\N	\N	\N	\N	8136 Guadalajara	Lebanon	OR	63084	USA	0
df27c279-dd8b-4906-18d8-438dfc536de4	2005-11-30 19:23:12	2005-11-30 19:23:12	1	matt_id	1	Poisson-Cosby Machinery Corp	\N	Manufacturing	Machinery	\N	\N	9377 Detroit Ave	Haney	BC	84634	Canada	\N	\N	947-555-3150	\N	\N	\N	www.poisson-cosbymachinerycorp.com	\N	\N	\N	\N	9377 Detroit Ave	Haney	BC	84634	Canada	0
76d00a10-3ef0-9a5f-1f68-438dfc28d168	2005-11-30 19:23:13	2005-11-30 19:23:13	1	beth_id	1	V & B Oss Transportation Holdings	\N	Supply	Transportation	\N	\N	2582 California Street	Richmond	BC	84233	Canada	\N	\N	604-555-9071	\N	\N	\N	www.vbosstransportationholdings.com	\N	\N	\N	\N	2582 California Street	Richmond	BC	84233	Canada	0
aad102f0-6ca6-3b3a-d374-438dfc18d752	2005-11-30 19:23:13	2005-11-30 19:23:13	1	beth_id	1	Oss-Smith Construction Company	\N	Consulting	Construction	\N	\N	4077 Chinquapin Ct	Burien	WA	71944	USA	\N	\N	108-555-6221	\N	\N	\N	www.oss-smithconstructioncompany.com	\N	\N	\N	\N	4077 Chinquapin Ct	Burien	WA	71944	USA	0
14dd4d0a-360d-88c6-bed5-438dfc462ea2	2005-11-30 19:23:14	2005-11-30 19:23:14	1	max_id	1	C & A Christensen Engineering Group	\N	Supply	Engineering	\N	\N	7535 Roanoke Drive	Vancouver	BC	11414	Canada	\N	\N	927-555-5429	\N	\N	\N	www.cachristensenengineeringgroup.com	\N	\N	\N	\N	7535 Roanoke Drive	Vancouver	BC	11414	Canada	0
72627cba-1687-f765-d88c-438dfc2f7978	2005-11-30 19:23:14	2005-11-30 19:23:14	1	kristen_id	1	Christensen-Pectol Construction, Ltd	\N	Consulting	Construction	\N	\N	1941 Hacienda	West Covina	CA	90578	USA	\N	\N	454-555-1207	\N	\N	\N	www.christensen-pectolconstruction,ltd.com	\N	\N	\N	\N	1941 Hacienda	West Covina	CA	90578	USA	0
d3431f37-fcc8-2405-eb66-438dfc52eb4c	2005-11-30 19:23:14	2005-11-30 19:23:14	1	chris_id	1	U & S Baker Transportation, Inc	\N	Manufacturing	Transportation	\N	\N	8309 Colonial Way	Woodland Hills	CA	95208	USA	\N	\N	396-555-8043	\N	\N	\N	www.usbakertransportation,inc.com	\N	\N	\N	\N	8309 Colonial Way	Woodland Hills	CA	95208	USA	0
6b1fb4fa-6cb6-8534-d59c-438dfc75d9be	2005-11-30 19:23:15	2005-11-30 19:23:15	1	will_id	1	Baker-Finke Construction Group	\N	Distribution	Construction	\N	\N	313 Ladera	San Gabriel	CA	15243	USA	\N	\N	185-555-6107	\N	\N	\N	www.baker-finkeconstructiongroup.com	\N	\N	\N	\N	313 Ladera	San Gabriel	CA	15243	USA	0
cb4e8fc7-f8f0-e1a2-d80b-438dfc2e57c1	2005-11-30 19:23:15	2005-11-30 19:23:15	1	sarah_id	1	N & W Beutel Transportation Corp	\N	Distribution	Transportation	\N	\N	9590 Galloway Dr	Grossmont	CA	85034	USA	\N	\N	389-555-6229	\N	\N	\N	www.nwbeuteltransportationcorp.com	\N	\N	\N	\N	9590 Galloway Dr	Grossmont	CA	85034	USA	0
914ccf1c-bf0a-f7ed-58c5-438dfca75a45	2005-11-30 19:23:16	2005-11-30 19:23:16	1	matt_id	1	Beutel-Duvalle Engineering Partners	\N	Supply	Engineering	\N	\N	5751 Concord Place	San Andres	DF	70230	Mexico	\N	\N	200-555-2921	\N	\N	\N	www.beutel-duvalleengineeringpartners.com	\N	\N	\N	\N	5751 Concord Place	San Andres	DF	70230	Mexico	0
f1baec4e-7c74-c96a-68a3-438dfc8cb99b	2005-11-30 19:23:16	2005-11-30 19:23:16	1	sarah_id	1	O & D Sloper Communications Associates	\N	Distribution	Communications	\N	\N	5283 Rishell Ct.	Richmond	CA	71842	USA	\N	\N	427-555-1672	\N	\N	\N	www.odslopercommunicationsassociates.com	\N	\N	\N	\N	5283 Rishell Ct.	Richmond	CA	71842	USA	0
bab27711-9702-e9e0-da79-438dfcc3aa62	2005-11-30 19:23:17	2005-11-30 19:23:17	1	sally_id	1	Sloper-Weinzimmer Transportation Company	\N	Consulting	Transportation	\N	\N	451 Buskirk Ave.	Downey	CA	20172	USA	\N	\N	852-555-6568	\N	\N	\N	www.sloper-weinzimmertransportationcompany.com	\N	\N	\N	\N	451 Buskirk Ave.	Downey	CA	20172	USA	0
eae78d25-3a40-ec1c-c24d-438dfc8f5eb2	2005-11-30 19:23:17	2005-11-30 19:23:17	1	sally_id	1	M & Y Moore Communications, Ltd	\N	Supply	Communications	\N	\N	237 Ashley Way	Ballard	WA	41322	USA	\N	\N	202-555-3946	\N	\N	\N	www.mymoorecommunications,ltd.com	\N	\N	\N	\N	237 Ashley Way	Ballard	WA	41322	USA	0
2748039e-54c4-cb87-e152-438dfc2b0d6f	2005-11-30 19:23:18	2005-11-30 19:23:18	1	beth_id	1	Moore-Chaw Communications Associates	\N	Consulting	Communications	\N	\N	8314 Brandywine Way	San Diego	CA	20650	USA	\N	\N	298-555-1553	\N	\N	\N	www.moore-chawcommunicationsassociates.com	\N	\N	\N	\N	8314 Brandywine Way	San Diego	CA	20650	USA	0
57ad5a94-8201-6bc2-5ae4-438dfc415be8	2005-11-30 19:23:18	2005-11-30 19:23:18	1	max_id	1	B & D Reitzel Machinery Partners	\N	Consulting	Machinery	\N	\N	8354 Ponderosa Drive	Santa Monica	CA	87926	USA	\N	\N	810-555-1218	\N	\N	\N	www.bdreitzelmachinerypartners.com	\N	\N	\N	\N	8354 Ponderosa Drive	Santa Monica	CA	87926	USA	0
883c8ad1-e540-4dd6-ccb1-438dfc95b2c7	2005-11-30 19:23:18	2005-11-30 19:23:18	1	sarah_id	1	Reitzel-Horbach Construction Partners	\N	Manufacturing	Construction	\N	\N	9341 Horseshoe Circle	Camacho	Zacatecas	44314	Mexico	\N	\N	929-555-6453	\N	\N	\N	www.reitzel-horbachconstructionpartners.com	\N	\N	\N	\N	9341 Horseshoe Circle	Camacho	Zacatecas	44314	Mexico	0
bba46bbd-e936-368b-f563-438dfc060181	2005-11-30 19:23:18	2005-11-30 19:23:18	1	kristen_id	1	H & E Knobel Machinery Group	\N	Supply	Machinery	\N	\N	9636 Palisade Court	Colma	CA	77752	USA	\N	\N	564-555-4746	\N	\N	\N	www.heknobelmachinerygroup.com	\N	\N	\N	\N	9636 Palisade Court	Colma	CA	77752	USA	0
ebe2430a-1961-633a-a68d-438dfc818e50	2005-11-30 19:23:18	2005-11-30 19:23:18	1	beth_id	1	Knobel-Hope Electronics Holdings	\N	Supply	Electronics	\N	\N	878 Amador Ct	Burbank	CA	26594	USA	\N	\N	944-555-3268	\N	\N	\N	www.knobel-hopeelectronicsholdings.com	\N	\N	\N	\N	878 Amador Ct	Burbank	CA	26594	USA	0
281a7cd0-fb77-6171-1a50-438dfc3c109a	2005-11-30 19:23:19	2005-11-30 19:23:19	1	max_id	1	X & M Fisher Construction Corp	\N	Manufacturing	Construction	\N	\N	4082 Virginia Hills	Issaquah	WA	98901	USA	\N	\N	602-555-9189	\N	\N	\N	www.xmfisherconstructioncorp.com	\N	\N	\N	\N	4082 Virginia Hills	Issaquah	WA	98901	USA	0
5926592f-9977-2855-c423-438dfcd03f4c	2005-11-30 19:23:19	2005-11-30 19:23:19	1	sally_id	1	Fisher-Dabit Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	5577 Laredo	Vancouver	BC	13905	Canada	\N	\N	106-555-6339	\N	\N	\N	www.fisher-dabittelecommunications,ltd.com	\N	\N	\N	\N	5577 Laredo	Vancouver	BC	13905	Canada	0
8a3f3731-8ac9-e132-840e-438dfc018323	2005-11-30 19:23:19	2005-11-30 19:23:19	1	chris_id	1	I & M Turner Transportation, Ltd	\N	Supply	Transportation	\N	\N	1692 Detroit Ave	San Carlos	CA	52373	USA	\N	\N	925-555-5546	\N	\N	\N	www.imturnertransportation,ltd.com	\N	\N	\N	\N	1692 Detroit Ave	San Carlos	CA	52373	USA	0
bf2aa340-1a5b-b67c-5244-438dfcb55652	2005-11-30 19:23:19	2005-11-30 19:23:19	1	will_id	1	Turner-Clark Electronics Corp	\N	Manufacturing	Electronics	\N	\N	3441 Wellington Ct.	Oak Bay	BC	62463	Canada	\N	\N	452-555-1325	\N	\N	\N	www.turner-clarkelectronicscorp.com	\N	\N	\N	\N	3441 Wellington Ct.	Oak Bay	BC	62463	Canada	0
f2b6de7a-dfb9-1f15-8d7a-438dfcedbe55	2005-11-30 19:23:19	2005-11-30 19:23:19	1	kristen_id	1	H & Y Schimanski Engineering, Inc	\N	Distribution	Engineering	\N	\N	9809 Cardinet Drive	Langford	BC	37169	Canada	\N	\N	394-555-8160	\N	\N	\N	www.hyschimanskiengineering,inc.com	\N	\N	\N	\N	9809 Cardinet Drive	Langford	BC	37169	Canada	0
2f4ab363-a0e3-ee3e-0807-438dfcef783d	2005-11-30 19:23:20	2005-11-30 19:23:20	1	jaime_id	1	Schimanski-Alumbaugh Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	4469 Dellwood Court	Lemon Grove	CA	56203	USA	\N	\N	183-555-6225	\N	\N	\N	www.schimanski-alumbaughtelecommunications,ltd.com	\N	\N	\N	\N	4469 Dellwood Court	Lemon Grove	CA	56203	USA	0
5f78a5ac-c8e4-d74e-de14-438dfc4ba53c	2005-11-30 19:23:20	2005-11-30 19:23:20	1	sally_id	1	D & A Benson Machinery Group	\N	Manufacturing	Machinery	\N	\N	1092 Boxer Blvd	Port Hammond	BC	26995	Canada	\N	\N	499-555-8606	\N	\N	\N	www.dabensonmachinerygroup.com	\N	\N	\N	\N	1092 Boxer Blvd	Port Hammond	BC	26995	Canada	0
90f58c4a-8556-0ec0-c999-438dfcb4680a	2005-11-30 19:23:20	2005-11-30 19:23:20	1	max_id	1	Benson-Rusch Construction Associates	\N	Consulting	Construction	\N	\N	6005 Sun View Drive	Arcadia	CA	12191	USA	\N	\N	310-555-5299	\N	\N	\N	www.benson-ruschconstructionassociates.com	\N	\N	\N	\N	6005 Sun View Drive	Arcadia	CA	12191	USA	0
c6ab6a84-2c1d-6ee1-fb84-438dfc7a9b31	2005-11-30 19:23:20	2005-11-30 19:23:20	1	max_id	1	D & Z Cocadiz Electronics, Ltd	\N	Consulting	Electronics	\N	\N	5537 Broadway	Spokane	WA	48144	USA	\N	\N	537-555-4049	\N	\N	\N	www.dzcocadizelectronics,ltd.com	\N	\N	\N	\N	5537 Broadway	Spokane	WA	48144	USA	0
5db004c3-0bc7-0f1f-0333-438dfc1dd327	2005-11-30 19:23:21	2005-11-30 19:23:21	1	kristen_id	1	Cocadiz-Mcgough Engineering Corp	\N	Consulting	Engineering	\N	\N	705 Seaview Avenue	Colma	CA	98500	USA	\N	\N	372-555-8370	\N	\N	\N	www.cocadiz-mcgoughengineeringcorp.com	\N	\N	\N	\N	705 Seaview Avenue	Colma	CA	98500	USA	0
37ed14c6-a48d-5a88-32de-438dfc344b87	2005-11-30 19:23:21	2005-11-30 19:23:21	1	will_id	1	Q & Q King Telecommunications Associates	\N	Supply	Telecommunications	\N	\N	491 Cali	Mexico City	Mexico	26294	Mexico	\N	\N	622-555-5749	\N	\N	\N	www.qqkingtelecommunicationsassociates.com	\N	\N	\N	\N	491 Cali	Mexico City	Mexico	26294	Mexico	0
6be54043-f48f-b735-139f-438dfc1c2fc2	2005-11-30 19:23:21	2005-11-30 19:23:21	1	max_id	1	King-Smith Engineering Company	\N	Manufacturing	Engineering	\N	\N	8568 San Vincente Drive	Seattle	WA	42812	USA	\N	\N	957-555-7013	\N	\N	\N	www.king-smithengineeringcompany.com	\N	\N	\N	\N	8568 San Vincente Drive	Seattle	WA	42812	USA	0
a0bfb889-e57c-c6b1-4a16-438dfc2ce66f	2005-11-30 19:23:21	2005-11-30 19:23:21	1	matt_id	1	Y & R Campbell Machinery, Inc	\N	Manufacturing	Machinery	\N	\N	1265 Gloria Terr.	West Covina	CA	83796	USA	\N	\N	330-555-3020	\N	\N	\N	www.yrcampbellmachinery,inc.com	\N	\N	\N	\N	1265 Gloria Terr.	West Covina	CA	83796	USA	0
d09daf64-3366-7d89-d80e-438dfc78fd52	2005-11-30 19:23:21	2005-11-30 19:23:21	1	sarah_id	1	Campbell-Watson Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	9595 Barbie Dr.	National City	CA	66476	USA	\N	\N	449-555-8256	\N	\N	\N	www.campbell-watsonengineering,inc.com	\N	\N	\N	\N	9595 Barbie Dr.	National City	CA	66476	USA	0
10c85c97-4838-66f7-ca9c-438dfc62b69d	2005-11-30 19:23:22	2005-11-30 19:23:22	1	kristen_id	1	E & F Anderson Machinery, Ltd	\N	Consulting	Machinery	\N	\N	2546 Fawn Glen Circle	Burlingame	CA	99914	USA	\N	\N	983-555-6549	\N	\N	\N	www.efandersonmachinery,ltd.com	\N	\N	\N	\N	2546 Fawn Glen Circle	Burlingame	CA	99914	USA	0
47b2de2c-877f-5ea3-3e3c-438dfc69b421	2005-11-30 19:23:22	2005-11-30 19:23:22	1	chris_id	1	Anderson-Duncan Transportation Holdings	\N	Distribution	Transportation	\N	\N	1132 Plymouth Dr.	Lake Oswego	OR	22464	USA	\N	\N	464-555-5070	\N	\N	\N	www.anderson-duncantransportationholdings.com	\N	\N	\N	\N	1132 Plymouth Dr.	Lake Oswego	OR	22464	USA	0
7a0f3a9f-919d-93ac-64d4-438dfc575d2d	2005-11-30 19:23:22	2005-11-30 19:23:22	1	will_id	1	N & O Wilson Electronics, Inc	\N	Supply	Electronics	\N	\N	6992 Mt. Whitney Way	Colma	CA	22064	USA	\N	\N	122-555-1992	\N	\N	\N	www.nowilsonelectronics,inc.com	\N	\N	\N	\N	6992 Mt. Whitney Way	Colma	CA	22064	USA	0
ad4d52a7-b4f6-2449-85c1-438dfccbc0eb	2005-11-30 19:23:22	2005-11-30 19:23:22	1	kristen_id	1	Wilson-Morrow Machinery Group	\N	Distribution	Machinery	\N	\N	8487 Amador	El Cajon	CA	97753	USA	\N	\N	526-555-8142	\N	\N	\N	www.wilson-morrowmachinerygroup.com	\N	\N	\N	\N	8487 Amador	El Cajon	CA	97753	USA	0
dfb5d15e-4d90-008a-c4a0-438dfc1e6796	2005-11-30 19:23:22	2005-11-30 19:23:22	1	beth_id	1	U & W Wall Construction Corp	\N	Supply	Construction	\N	\N	1946 Valley Crest Drive	Seattle	WA	74535	USA	\N	\N	135-555-7924	\N	\N	\N	www.uwwallconstructioncorp.com	\N	\N	\N	\N	1946 Valley Crest Drive	Seattle	WA	74535	USA	0
1e2e0eaf-a436-2e2f-079a-438dfcc978c2	2005-11-30 19:23:23	2005-11-30 19:23:23	1	max_id	1	Wall-Clendenen Electronics Company	\N	Consulting	Electronics	\N	\N	6351 22nd Ave.	Renton	WA	28408	USA	\N	\N	801-555-7360	\N	\N	\N	www.wall-clendenenelectronicscompany.com	\N	\N	\N	\N	6351 22nd Ave.	Renton	WA	28408	USA	0
511417c9-515a-5271-83cd-438dfc3602b3	2005-11-30 19:23:23	2005-11-30 19:23:23	1	chris_id	1	M & K Willeford Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	5998 Hilltop Road	Lynnwood	WA	33039	USA	\N	\N	743-555-5195	\N	\N	\N	www.mkwillefordtelecommunications,ltd.com	\N	\N	\N	\N	5998 Hilltop Road	Lynnwood	WA	33039	USA	0
81739667-916f-2f70-f9b6-438dfcef40da	2005-11-30 19:23:23	2005-11-30 19:23:23	1	sarah_id	1	Willeford-Nutter Machinery, Ltd	\N	Consulting	Machinery	\N	\N	658 Liscome Way	Haney	BC	52073	Canada	\N	\N	293-555-8602	\N	\N	\N	www.willeford-nuttermachinery,ltd.com	\N	\N	\N	\N	658 Liscome Way	Haney	BC	52073	Canada	0
b458bb25-107a-9c13-28cb-438dfce22eb8	2005-11-30 19:23:23	2005-11-30 19:23:23	1	beth_id	1	L & E Case Communications Partners	\N	Distribution	Communications	\N	\N	7280 Greendell Pl	Tlaxiaco	Oaxaca	49157	Mexico	\N	\N	497-555-8724	\N	\N	\N	www.lecasecommunicationspartners.com	\N	\N	\N	\N	7280 Greendell Pl	Tlaxiaco	Oaxaca	49157	Mexico	0
ea48fde4-32a8-c93f-deb5-438dfce647a7	2005-11-30 19:23:23	2005-11-30 19:23:23	1	sally_id	1	Case-Terry Construction Holdings	\N	Consulting	Construction	\N	\N	4849 Bovlevard	La Mesa	CA	34353	USA	\N	\N	308-555-5417	\N	\N	\N	www.case-terryconstructionholdings.com	\N	\N	\N	\N	4849 Bovlevard	La Mesa	CA	34353	USA	0
2f17041d-6ce9-52da-f900-438dfc42caf8	2005-11-30 19:23:24	2005-11-30 19:23:24	1	kristen_id	1	W & N Cabrera Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	1726 Hacienda	Beverly Hills	CA	70306	USA	\N	\N	535-555-4167	\N	\N	\N	www.wncabreratelecommunicationspartners.com	\N	\N	\N	\N	1726 Hacienda	Beverly Hills	CA	70306	USA	0
62385afb-c905-f7a8-2a44-438dfca04f24	2005-11-30 19:23:24	2005-11-30 19:23:24	1	sally_id	1	Cabrera-Bunosky Transportation Holdings	\N	Consulting	Transportation	\N	\N	9549 Sandra Circle	Albany	OR	21663	USA	\N	\N	370-555-8488	\N	\N	\N	www.cabrera-bunoskytransportationholdings.com	\N	\N	\N	\N	9549 Sandra Circle	Albany	OR	21663	USA	0
958696f6-dd18-293d-8b6a-438dfc8aed00	2005-11-30 19:23:24	2005-11-30 19:23:24	1	beth_id	1	V & A Burke Transportation Corp	\N	Consulting	Transportation	\N	\N	9335 Wilke Drive	Albany	OR	23778	USA	\N	\N	859-555-9524	\N	\N	\N	www.vaburketransportationcorp.com	\N	\N	\N	\N	9335 Wilke Drive	Albany	OR	23778	USA	0
cb5c47a5-1b26-9d7e-13d6-438dfc4e1bd3	2005-11-30 19:23:24	2005-11-30 19:23:24	1	max_id	1	Burke-Lindsay Telecommunications Partners	\N	Supply	Telecommunications	\N	\N	7413 Alpine Drive	Torrance	CA	67914	USA	\N	\N	955-555-7131	\N	\N	\N	www.burke-lindsaytelecommunicationspartners.com	\N	\N	\N	\N	7413 Alpine Drive	Torrance	CA	67914	USA	0
75e50a23-9265-c54c-8b4e-438dfcd2223b	2005-11-30 19:23:25	2005-11-30 19:23:25	1	will_id	1	L & N Murphy Electronics Company	\N	Manufacturing	Electronics	\N	\N	4304 Hieber Drive	Ballard	WA	75883	USA	\N	\N	327-555-3138	\N	\N	\N	www.lnmurphyelectronicscompany.com	\N	\N	\N	\N	4304 Hieber Drive	Ballard	WA	75883	USA	0
388be0fd-b842-efd0-f18e-438dfc552b9e	2005-11-30 19:23:25	2005-11-30 19:23:25	1	matt_id	1	Murphy-Sweet Telecommunications Corp	\N	Supply	Telecommunications	\N	\N	673 Noah Court	Port Orchard	WA	26604	USA	\N	\N	686-555-3031	\N	\N	\N	www.murphy-sweettelecommunicationscorp.com	\N	\N	\N	\N	673 Noah Court	Port Orchard	WA	26604	USA	0
7157d805-6abe-331a-5fb9-438dfc620237	2005-11-30 19:23:25	2005-11-30 19:23:25	1	chris_id	1	D & D Jantzer Electronics Holdings	\N	Supply	Electronics	\N	\N	2676 Premier Pl.	Ladner	BC	45638	Canada	\N	\N	196-555-8847	\N	\N	\N	www.ddjantzerelectronicsholdings.com	\N	\N	\N	\N	2676 Premier Pl.	Ladner	BC	45638	Canada	0
a5742340-8530-36ea-0b70-438dfc49fba9	2005-11-30 19:23:25	2005-11-30 19:23:25	1	sarah_id	1	Jantzer-Dittmar Machinery, Inc	\N	Distribution	Machinery	\N	\N	1955 Montgomery Ave	National City	CA	16430	USA	\N	\N	577-555-7369	\N	\N	\N	www.jantzer-dittmarmachinery,inc.com	\N	\N	\N	\N	1955 Montgomery Ave	National City	CA	16430	USA	0
d69a09f2-05b3-787c-3830-438dfcf05a6f	2005-11-30 19:23:25	2005-11-30 19:23:25	1	sally_id	1	I & V Gutirrez Engineering, Inc	\N	Distribution	Engineering	\N	\N	6868 Firestone	Victoria	BC	1626	Canada	\N	\N	234-555-4290	\N	\N	\N	www.ivgutirrezengineering,inc.com	\N	\N	\N	\N	6868 Firestone	Victoria	BC	1626	Canada	0
179e125d-284a-d3b2-0038-438dfcf93aaa	2005-11-30 19:23:26	2005-11-30 19:23:26	1	beth_id	1	Gutirrez-Carol Construction, Ltd	\N	Manufacturing	Construction	\N	\N	6400 St. John Lane	Port Hammond	BC	37579	Canada	\N	\N	877-555-5098	\N	\N	\N	www.gutirrez-carolconstruction,ltd.com	\N	\N	\N	\N	6400 St. John Lane	Port Hammond	BC	37579	Canada	0
495768d6-47f1-1b9f-577a-438dfc1aac48	2005-11-30 19:23:26	2005-11-30 19:23:26	1	matt_id	1	K & R Holmes Communications Group	\N	Consulting	Communications	\N	\N	1568 Delta Fair Blvd.	La Cruz	Sinaloa	87935	Mexico	\N	\N	558-555-9647	\N	\N	\N	www.krholmescommunicationsgroup.com	\N	\N	\N	\N	1568 Delta Fair Blvd.	La Cruz	Sinaloa	87935	Mexico	0
7e3eb19c-1d64-396b-5c09-438dfcb45107	2005-11-30 19:23:26	2005-11-30 19:23:26	1	jaime_id	1	Holmes-Chandler Engineering Associates	\N	Distribution	Engineering	\N	\N	1354 Catalpa Court	Tacoma	WA	90050	USA	\N	\N	323-555-9083	\N	\N	\N	www.holmes-chandlerengineeringassociates.com	\N	\N	\N	\N	1354 Catalpa Court	Tacoma	WA	90050	USA	0
b566c7ed-03b1-4b94-b3c0-438dfc90b079	2005-11-30 19:23:26	2005-11-30 19:23:26	1	max_id	1	B & P Burkett Telecommunications Holdings	\N	Distribution	Telecommunications	\N	\N	9431 D Bel Air Dr.	Puyallup	WA	75702	USA	\N	\N	266-555-6919	\N	\N	\N	www.bpburketttelecommunicationsholdings.com	\N	\N	\N	\N	9431 D Bel Air Dr.	Puyallup	WA	75702	USA	0
edb6480f-7a94-ab84-d7f7-438dfc6d05e7	2005-11-30 19:23:26	2005-11-30 19:23:26	1	will_id	1	Burkett-Drake Engineering Partners	\N	Consulting	Engineering	\N	\N	9471 Shelly Dr.	Bremerton	WA	74846	USA	\N	\N	954-555-4983	\N	\N	\N	www.burkett-drakeengineeringpartners.com	\N	\N	\N	\N	9471 Shelly Dr.	Bremerton	WA	74846	USA	0
2ade2bad-f421-e522-0893-438dfc6f9001	2005-11-30 19:23:27	2005-11-30 19:23:27	1	chris_id	1	Q & P Barber Telecommunications Company	\N	Manufacturing	Telecommunications	\N	\N	1706 Vallejo	Palo Alto	CA	31234	USA	\N	\N	919-555-1447	\N	\N	\N	www.qpbarbertelecommunicationscompany.com	\N	\N	\N	\N	1706 Vallejo	Palo Alto	CA	31234	USA	0
63ac9d63-cef0-cc86-3eb8-438dfc83a95f	2005-11-30 19:23:27	2005-11-30 19:23:27	1	sally_id	1	Barber-Richendollar Electronics Group	\N	Consulting	Electronics	\N	\N	2000 Thornwood Dr.	Portland	OR	64672	USA	\N	\N	731-555-7140	\N	\N	\N	www.barber-richendollarelectronicsgroup.com	\N	\N	\N	\N	2000 Thornwood Dr.	Portland	OR	64672	USA	0
9b204880-a0ef-5c4d-4be0-438dfc20677e	2005-11-30 19:23:27	2005-11-30 19:23:27	1	kristen_id	1	A & X Caravello Engineering, Inc	\N	Supply	Engineering	\N	\N	3241 Dutch Slough Rd.	Tlaxiaco	Oaxaca	13514	Mexico	\N	\N	958-555-5890	\N	\N	\N	www.axcaravelloengineering,inc.com	\N	\N	\N	\N	3241 Dutch Slough Rd.	Tlaxiaco	Oaxaca	13514	Mexico	0
cfe9578f-3e6b-aa60-aa17-438dfc0054b8	2005-11-30 19:23:27	2005-11-30 19:23:27	1	kristen_id	1	Caravello-Paulson Construction Partners	\N	Distribution	Construction	\N	\N	6445 Cashew Street	Marysville	WA	85821	USA	\N	\N	497-555-9924	\N	\N	\N	www.caravello-paulsonconstructionpartners.com	\N	\N	\N	\N	6445 Cashew Street	Marysville	WA	85821	USA	0
bfe90793-7042-b281-a29b-438dfcd94a83	2005-11-30 19:23:28	2005-11-30 19:23:28	1	kristen_id	1	H & Y Trujillo Electronics, Ltd	\N	Manufacturing	Electronics	\N	\N	7941 Cristobal	Grossmont	CA	23887	USA	\N	\N	747-555-7303	\N	\N	\N	www.hytrujilloelectronics,ltd.com	\N	\N	\N	\N	7941 Cristobal	Grossmont	CA	23887	USA	0
3c5230ab-6269-a413-a1da-438dfce24849	2005-11-30 19:23:28	2005-11-30 19:23:28	1	chris_id	1	Trujillo-Barajas Transportation Holdings	\N	Supply	Transportation	\N	\N	4055 Leonard Ct.	Guadalajara	Jalisco	62356	Mexico	\N	\N	843-555-4910	\N	\N	\N	www.trujillo-barajastransportationholdings.com	\N	\N	\N	\N	4055 Leonard Ct.	Guadalajara	Jalisco	62356	Mexico	0
75fbe8a1-0cc5-7f5f-3f5d-438dfcba3444	2005-11-30 19:23:28	2005-11-30 19:23:28	1	sarah_id	1	O & K Ealey Transportation Corp	\N	Manufacturing	Transportation	\N	\N	5805 Churchill Dr.	Concord	CA	16229	USA	\N	\N	216-555-9917	\N	\N	\N	www.okealeytransportationcorp.com	\N	\N	\N	\N	5805 Churchill Dr.	Concord	CA	16229	USA	0
a8be972a-939a-3dca-b61a-438dfc6effc4	2005-11-30 19:23:28	2005-11-30 19:23:28	1	beth_id	1	Ealey-Pigman Construction Partners	\N	Consulting	Construction	\N	\N	2173 Heartwood Drive	Orizaba	Veracruz	47151	Mexico	\N	\N	574-555-9810	\N	\N	\N	www.ealey-pigmanconstructionpartners.com	\N	\N	\N	\N	2173 Heartwood Drive	Orizaba	Veracruz	47151	Mexico	0
d8ad2277-df7d-f46f-f387-438dfc9fc67c	2005-11-30 19:23:28	2005-11-30 19:23:28	1	sally_id	1	D & D Minniear Transportation, Ltd	\N	Distribution	Transportation	\N	\N	6832 Le Jean Way	La Cruz	Sinaloa	66185	Mexico	\N	\N	869-555-4445	\N	\N	\N	www.ddminnieartransportation,ltd.com	\N	\N	\N	\N	6832 Le Jean Way	La Cruz	Sinaloa	66185	Mexico	0
1f2068b3-8dfd-886c-701a-438dfc9c060b	2005-11-30 19:23:29	2005-11-30 19:23:29	1	beth_id	1	Minniear-Robinson Communications Group	\N	Supply	Communications	\N	\N	3455 Mexico	Altadena	CA	36977	USA	\N	\N	350-555-2967	\N	\N	\N	www.minniear-robinsoncommunicationsgroup.com	\N	\N	\N	\N	3455 Mexico	Altadena	CA	36977	USA	0
54a0d864-0354-75f6-828b-438dfce8bd19	2005-11-30 19:23:29	2005-11-30 19:23:29	1	beth_id	1	E & M Steger Electronics Company	\N	Supply	Electronics	\N	\N	8368 Birchwood	Seattle	WA	22173	USA	\N	\N	247-555-3546	\N	\N	\N	www.emstegerelectronicscompany.com	\N	\N	\N	\N	8368 Birchwood	Seattle	WA	22173	USA	0
94e3b641-f6ba-cc12-a786-438dfcc4dc4a	2005-11-30 19:23:29	2005-11-30 19:23:29	1	matt_id	1	Steger-Lindsey Engineering, Ltd	\N	Distribution	Engineering	\N	\N	7900 Grammercy Lane	Mexico City	Mexico	58126	Mexico	\N	\N	651-555-9696	\N	\N	\N	www.steger-lindseyengineering,ltd.com	\N	\N	\N	\N	7900 Grammercy Lane	Mexico City	Mexico	58126	Mexico	0
c79ec9db-7704-6f87-c385-438dfc36b819	2005-11-30 19:23:29	2005-11-30 19:23:29	1	matt_id	1	R & Z Larson Communications, Inc	\N	Distribution	Communications	\N	\N	3068 Altura	Palo Alto	CA	94832	USA	\N	\N	331-555-5245	\N	\N	\N	www.rzlarsoncommunications,inc.com	\N	\N	\N	\N	3068 Altura	Palo Alto	CA	94832	USA	0
492a0d69-45ec-0626-ad08-438dfc957527	2005-11-30 19:23:30	2005-11-30 19:23:30	1	sally_id	1	Larson-Heyer Electronics Associates	\N	Consulting	Electronics	\N	\N	2855 West F St.	Ladner	BC	11598	Canada	\N	\N	997-555-4681	\N	\N	\N	www.larson-heyerelectronicsassociates.com	\N	\N	\N	\N	2855 West F St.	Ladner	BC	11598	Canada	0
405a1f89-b637-f966-5355-438dfc8e0091	2005-11-30 19:23:30	2005-11-30 19:23:30	1	sarah_id	1	J & K Clifford Communications Corp	\N	Supply	Communications	\N	\N	932 Acardia Pl.	Oak Bay	BC	28117	Canada	\N	\N	939-555-2517	\N	\N	\N	www.jkcliffordcommunicationscorp.com	\N	\N	\N	\N	932 Acardia Pl.	Oak Bay	BC	28117	Canada	0
7072fe03-b8b5-5554-6d14-438dfc2f5a34	2005-11-30 19:23:30	2005-11-30 19:23:30	1	sally_id	1	Clifford-Smith Construction, Ltd	\N	Supply	Construction	\N	\N	3628 Mt. McKinley Ct.	National City	CA	69101	USA	\N	\N	728-555-9581	\N	\N	\N	www.clifford-smithconstruction,ltd.com	\N	\N	\N	\N	3628 Mt. McKinley Ct.	National City	CA	69101	USA	0
a902c86d-af73-bb58-03d8-438dfce6da2a	2005-11-30 19:23:30	2005-11-30 19:23:30	1	matt_id	1	G & Q Todd Transportation Company	\N	Manufacturing	Transportation	\N	\N	1960 Fernando Court	Ladner	BC	51781	Canada	\N	\N	805-555-8305	\N	\N	\N	www.gqtoddtransportationcompany.com	\N	\N	\N	\N	1960 Fernando Court	Ladner	BC	51781	Canada	0
d90e7371-642f-b58a-283a-438dfcf43684	2005-11-30 19:23:30	2005-11-30 19:23:30	1	max_id	1	Todd-Batouche Machinery Group	\N	Manufacturing	Machinery	\N	\N	4910 Melinda Court	Long Beach	CA	85219	USA	\N	\N	616-555-4998	\N	\N	\N	www.todd-batouchemachinerygroup.com	\N	\N	\N	\N	4910 Melinda Court	Long Beach	CA	85219	USA	0
26bc2c8a-cf99-5250-f0aa-438dfc686818	2005-11-30 19:23:31	2005-11-30 19:23:31	1	sally_id	1	L & D Marple Electronics Corp	\N	Manufacturing	Electronics	\N	\N	3495 Virginia Lane	Tacoma	WA	77693	USA	\N	\N	843-555-3748	\N	\N	\N	www.ldmarpleelectronicscorp.com	\N	\N	\N	\N	3495 Virginia Lane	Tacoma	WA	77693	USA	0
573647e1-999c-69cf-2397-438dfc17623f	2005-11-30 19:23:31	2005-11-30 19:23:31	1	matt_id	1	Marple-Griffin Engineering, Ltd	\N	Supply	Engineering	\N	\N	9355 Slavio	Santa Anita	DF	51879	Mexico	\N	\N	917-555-2727	\N	\N	\N	www.marple-griffinengineering,ltd.com	\N	\N	\N	\N	9355 Slavio	Santa Anita	DF	51879	Mexico	0
877eb60b-134a-f479-802c-438dfc448522	2005-11-30 19:23:31	2005-11-30 19:23:31	1	jaime_id	1	Z & L Carrington Construction, Ltd	\N	Supply	Construction	\N	\N	851 Summerfield Drive	Santa Anita	DF	39590	Mexico	\N	\N	267-555-9105	\N	\N	\N	www.zlcarringtonconstruction,ltd.com	\N	\N	\N	\N	851 Summerfield Drive	Santa Anita	DF	39590	Mexico	0
c66b15b6-1295-c446-8285-438dfc13ef91	2005-11-30 19:23:31	2005-11-30 19:23:31	1	will_id	1	Carrington-Vigil Transportation Group	\N	Manufacturing	Transportation	\N	\N	4309 Cambridge Drive	Langley	BC	53512	Canada	\N	\N	363-555-6712	\N	\N	\N	www.carrington-vigiltransportationgroup.com	\N	\N	\N	\N	4309 Cambridge Drive	Langley	BC	53512	Canada	0
15876252-21f9-8801-edf5-438dfc514ffd	2005-11-30 19:23:32	2005-11-30 19:23:32	1	max_id	1	V & P Gonzales Transportation Corp	\N	Consulting	Transportation	\N	\N	8714 St. Paul Way	Torrance	CA	58223	USA	\N	\N	636-555-2719	\N	\N	\N	www.vpgonzalestransportationcorp.com	\N	\N	\N	\N	8714 St. Paul Way	Torrance	CA	58223	USA	0
52649e63-6cbc-9626-db97-438dfcc96538	2005-11-30 19:23:32	2005-11-30 19:23:32	1	will_id	1	Gonzales-Starr Telecommunications, Inc	\N	Consulting	Telecommunications	\N	\N	2427 Arnold Dr	Victoria	BC	62853	Canada	\N	\N	994-555-2613	\N	\N	\N	www.gonzales-starrtelecommunications,inc.com	\N	\N	\N	\N	2427 Arnold Dr	Victoria	BC	62853	Canada	0
8931952d-ca9b-aaef-d3bf-438dfc559055	2005-11-30 19:23:32	2005-11-30 19:23:32	1	matt_id	1	F & X Murphy Communications Partners	\N	Consulting	Communications	\N	\N	7086 C Wharton Way	Santa Cruz	CA	81887	USA	\N	\N	628-555-9905	\N	\N	\N	www.fxmurphycommunicationspartners.com	\N	\N	\N	\N	7086 C Wharton Way	Santa Cruz	CA	81887	USA	0
bbf35b4f-d530-f5ec-3f2a-438dfc01924c	2005-11-30 19:23:32	2005-11-30 19:23:32	1	sally_id	1	Murphy-Rinks Communications Holdings	\N	Distribution	Communications	\N	\N	890 Ridgeview Dr	Pomona	CA	78972	USA	\N	\N	770-555-4769	\N	\N	\N	www.murphy-rinkscommunicationsholdings.com	\N	\N	\N	\N	890 Ridgeview Dr	Pomona	CA	78972	USA	0
53e902c2-1531-2e88-6849-438dfcf7e277	2005-11-30 19:23:33	2005-11-30 19:23:33	1	sarah_id	1	S & X Kroes Engineering Partners	\N	Distribution	Engineering	\N	\N	8459 Patricia	La Cruz	Sinaloa	64167	Mexico	\N	\N	667-555-5348	\N	\N	\N	www.sxkroesengineeringpartners.com	\N	\N	\N	\N	8459 Patricia	La Cruz	Sinaloa	64167	Mexico	0
3571dd34-b4e1-d163-6193-438dfc2a52df	2005-11-30 19:23:33	2005-11-30 19:23:33	1	sarah_id	1	Kroes-Shafer Transportation, Inc	\N	Supply	Transportation	\N	\N	5336 Roberts Ct	Chula Vista	CA	11212	USA	\N	\N	171-555-2498	\N	\N	\N	www.kroes-shafertransportation,inc.com	\N	\N	\N	\N	5336 Roberts Ct	Chula Vista	CA	11212	USA	0
65b6ae82-e853-4b4a-907a-438dfc41e4ea	2005-11-30 19:23:33	2005-11-30 19:23:33	1	sarah_id	1	H & N Price Machinery Corp	\N	Supply	Machinery	\N	\N	3159 C Wharton Way	Spring Valley	CA	51478	USA	\N	\N	441-555-7623	\N	\N	\N	www.hnpricemachinerycorp.com	\N	\N	\N	\N	3159 C Wharton Way	Spring Valley	CA	51478	USA	0
ad7eebc8-9008-48aa-8999-438dfc2bd7db	2005-11-30 19:23:33	2005-11-30 19:23:33	1	max_id	1	Price-Driscoll Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	2946 Frayne Ct	Corvallis	OR	53593	USA	\N	\N	207-555-7059	\N	\N	\N	www.price-driscolltelecommunicationspartners.com	\N	\N	\N	\N	2946 Frayne Ct	Corvallis	OR	53593	USA	0
dddc337f-cd80-2112-6c27-438dfcd65851	2005-11-30 19:23:33	2005-11-30 19:23:33	1	sally_id	1	C & Z Morris Communications Associates	\N	Manufacturing	Communications	\N	\N	1023 Hawkins Street	Lebanon	OR	43819	USA	\N	\N	149-555-4894	\N	\N	\N	www.czmorriscommunicationsassociates.com	\N	\N	\N	\N	1023 Hawkins Street	Lebanon	OR	43819	USA	0
19ffc069-9d38-b1b6-1dae-438dfcbadb5a	2005-11-30 19:23:34	2005-11-30 19:23:34	1	beth_id	1	Morris-Price Electronics Holdings	\N	Distribution	Electronics	\N	\N	1064 William Way	Woodland Hills	CA	12096	USA	\N	\N	838-555-2959	\N	\N	\N	www.morris-priceelectronicsholdings.com	\N	\N	\N	\N	1064 William Way	Woodland Hills	CA	12096	USA	0
4abce901-f399-395c-cfc1-438dfc680d17	2005-11-30 19:23:34	2005-11-30 19:23:34	1	will_id	1	G & H Marez Transportation, Inc	\N	Supply	Transportation	\N	\N	9394 Piper Ridge Court	Camacho	Zacatecas	93776	Mexico	\N	\N	803-555-8423	\N	\N	\N	www.ghmareztransportation,inc.com	\N	\N	\N	\N	9394 Piper Ridge Court	Camacho	Zacatecas	93776	Mexico	0
89aa25e0-abb7-8da8-5f7c-438dfcc93527	2005-11-30 19:23:34	2005-11-30 19:23:34	1	jaime_id	1	Marez-Wachterman Transportation Company	\N	Consulting	Transportation	\N	\N	2345 Yorba Linda	Coronado	CA	99306	USA	\N	\N	614-555-5116	\N	\N	\N	www.marez-wachtermantransportationcompany.com	\N	\N	\N	\N	2345 Yorba Linda	Coronado	CA	99306	USA	0
c42d53c8-319a-14cb-031b-438dfc639b30	2005-11-30 19:23:34	2005-11-30 19:23:34	1	sarah_id	1	X & W Usnick Machinery Group	\N	Supply	Machinery	\N	\N	3586 Everett Court	Redwood City	CA	48149	USA	\N	\N	841-555-3866	\N	\N	\N	www.xwusnickmachinerygroup.com	\N	\N	\N	\N	3586 Everett Court	Redwood City	CA	48149	USA	0
f8ae0395-a072-805c-afa3-438dfc1b9db1	2005-11-30 19:23:35	2005-11-30 19:23:35	1	will_id	1	Usnick-Brown Communications, Inc	\N	Manufacturing	Communications	\N	\N	6790 Loma Linda	Oregon City	OR	47748	USA	\N	\N	915-555-2844	\N	\N	\N	www.usnick-browncommunications,inc.com	\N	\N	\N	\N	6790 Loma Linda	Oregon City	OR	47748	USA	0
5597c255-2788-329c-788b-438dfc89c0d8	2005-11-30 19:23:35	2005-11-30 19:23:35	1	sally_id	1	D & H Galich Engineering Group	\N	Distribution	Engineering	\N	\N	8286 Willow St.	Oregon City	OR	35460	USA	\N	\N	264-555-9223	\N	\N	\N	www.dhgalichengineeringgroup.com	\N	\N	\N	\N	8286 Willow St.	Oregon City	OR	35460	USA	0
9562372a-7c6b-0f03-5180-438dfc684ff2	2005-11-30 19:23:35	2005-11-30 19:23:35	1	sally_id	1	Galich-Watson Construction, Ltd	\N	Consulting	Construction	\N	\N	1745 Marina Hill Pkwy.	Glendale	CA	73928	USA	\N	\N	361-555-6830	\N	\N	\N	www.galich-watsonconstruction,ltd.com	\N	\N	\N	\N	1745 Marina Hill Pkwy.	Glendale	CA	73928	USA	0
d78273c2-d1a4-c2e1-cb4c-438dfc1d695e	2005-11-30 19:23:35	2005-11-30 19:23:35	1	chris_id	1	K & I Ardell Machinery Corp	\N	Manufacturing	Machinery	\N	\N	6150 San Antonio	Grossmont	CA	54093	USA	\N	\N	633-555-2837	\N	\N	\N	www.kiardellmachinerycorp.com	\N	\N	\N	\N	6150 San Antonio	Grossmont	CA	54093	USA	0
2337d344-998b-9825-9a1d-438dfc6dafc6	2005-11-30 19:23:36	2005-11-30 19:23:36	1	sarah_id	1	Ardell-Nakauchi Electronics, Inc	\N	Distribution	Electronics	\N	\N	2518 Cashew Street	Lynnwood	WA	58723	USA	\N	\N	991-555-2730	\N	\N	\N	www.ardell-nakauchielectronics,inc.com	\N	\N	\N	\N	2518 Cashew Street	Lynnwood	WA	58723	USA	0
5377769e-2add-65c8-fae0-438dfc5634c3	2005-11-30 19:23:36	2005-11-30 19:23:36	1	chris_id	1	A & L Powers Engineering, Inc	\N	Consulting	Engineering	\N	\N	7177 Santa Rosa	Haney	BC	77757	Canada	\N	\N	738-555-3283	\N	\N	\N	www.alpowersengineering,inc.com	\N	\N	\N	\N	7177 Santa Rosa	Haney	BC	77757	Canada	0
83588aa9-47a5-ea7e-f3fe-438dfc246337	2005-11-30 19:23:36	2005-11-30 19:23:36	1	sally_id	1	Powers-Amburgey Construction, Ltd	\N	Consulting	Construction	\N	\N	3800 Breck Court	Victoria	BC	48549	Canada	\N	\N	219-555-1804	\N	\N	\N	www.powers-amburgeyconstruction,ltd.com	\N	\N	\N	\N	3800 Breck Court	Victoria	BC	48549	Canada	0
b625d5bb-cd93-43e5-6e8b-438dfc2936c1	2005-11-30 19:23:36	2005-11-30 19:23:36	1	beth_id	1	U & D Johnston Communications, Ltd	\N	Manufacturing	Communications	\N	\N	8713 Buchanan Street	Marysville	WA	33745	USA	\N	\N	777-555-7726	\N	\N	\N	www.udjohnstoncommunications,ltd.com	\N	\N	\N	\N	8713 Buchanan Street	Marysville	WA	33745	USA	0
ee8bad1c-a0dc-5296-19c3-438dfc606916	2005-11-30 19:23:36	2005-11-30 19:23:36	1	matt_id	1	Johnston-Hager Engineering Associates	\N	Supply	Engineering	\N	\N	8245 Heartwood Drive	W. Linn	OR	69698	USA	\N	\N	281-555-4876	\N	\N	\N	www.johnston-hagerengineeringassociates.com	\N	\N	\N	\N	8245 Heartwood Drive	W. Linn	OR	69698	USA	0
32dbd4f6-fc0a-ee15-c211-438dfc5792cf	2005-11-30 19:23:37	2005-11-30 19:23:37	1	max_id	1	C & R Posey Engineering Partners	\N	Supply	Engineering	\N	\N	3413 Sequoia Woods Pl.	Merida	Yucatan	21056	Mexico	\N	\N	200-555-4083	\N	\N	\N	www.crposeyengineeringpartners.com	\N	\N	\N	\N	3413 Sequoia Woods Pl.	Merida	Yucatan	21056	Mexico	0
7a09f220-a444-3557-babd-438dfc835374	2005-11-30 19:23:37	2005-11-30 19:23:37	1	max_id	1	Posey-Dimon Engineering Company	\N	Consulting	Engineering	\N	\N	3200 Wren Ave.	San Gabriel	CA	23171	USA	\N	\N	627-555-8861	\N	\N	\N	www.posey-dimonengineeringcompany.com	\N	\N	\N	\N	3200 Wren Ave.	San Gabriel	CA	23171	USA	0
b6fee153-e674-0ce9-1876-438dfcd49190	2005-11-30 19:23:37	2005-11-30 19:23:37	1	sarah_id	1	X & N Williams Construction Corp	\N	Consulting	Construction	\N	\N	1277 Argenta Dr.	Glendale	CA	39689	USA	\N	\N	569-555-6697	\N	\N	\N	www.xnwilliamsconstructioncorp.com	\N	\N	\N	\N	1277 Argenta Dr.	Glendale	CA	39689	USA	0
f0c98417-28e4-750f-3158-438dfc753a4a	2005-11-30 19:23:37	2005-11-30 19:23:37	1	kristen_id	1	Williams-Fien Machinery Group	\N	Supply	Machinery	\N	\N	1318 Nottingham Pl.	Lebanon	OR	79662	USA	\N	\N	357-555-4761	\N	\N	\N	www.williams-fienmachinerygroup.com	\N	\N	\N	\N	1318 Nottingham Pl.	Lebanon	OR	79662	USA	0
3f3906cd-9417-2089-b784-438dfcbfcc98	2005-11-30 19:23:38	2005-11-30 19:23:38	1	max_id	1	A & U Stalker Telecommunications, Inc	\N	Manufacturing	Telecommunications	\N	\N	2305 Glazier Drive	Mill Valley	CA	94451	USA	\N	\N	323-555-1226	\N	\N	\N	www.austalkertelecommunications,inc.com	\N	\N	\N	\N	2305 Glazier Drive	Mill Valley	CA	94451	USA	0
70a2eb1b-e3e3-24ea-79db-438dfcfd0cac	2005-11-30 19:23:38	2005-11-30 19:23:38	1	beth_id	1	Stalker-Fan Telecommunications Group	\N	Manufacturing	Telecommunications	\N	\N	6501 Mr. Wilson Way	Redmond	WA	42882	USA	\N	\N	373-555-1576	\N	\N	\N	www.stalker-fantelecommunicationsgroup.com	\N	\N	\N	\N	6501 Mr. Wilson Way	Redmond	WA	42882	USA	0
ad779176-e6f2-3a2a-7988-438dfca1fc7f	2005-11-30 19:23:38	2005-11-30 19:23:38	1	sally_id	1	C & Z Kamas Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	5087 Bella Avenue	Camacho	Zacatecas	64431	Mexico	\N	\N	361-555-5669	\N	\N	\N	www.czkamastelecommunications,ltd.com	\N	\N	\N	\N	5087 Bella Avenue	Camacho	Zacatecas	64431	Mexico	0
e6794b89-cc73-f353-e58d-438dfc4ade8c	2005-11-30 19:23:38	2005-11-30 19:23:38	1	will_id	1	Kamas-Barr Construction Group	\N	Distribution	Construction	\N	\N	8291 Woodland Drive	Anacortes	WA	64031	USA	\N	\N	434-555-4647	\N	\N	\N	www.kamas-barrconstructiongroup.com	\N	\N	\N	\N	8291 Woodland Drive	Anacortes	WA	64031	USA	0
22a32b5c-d5be-2c77-7d86-438dfc775cd6	2005-11-30 19:23:39	2005-11-30 19:23:39	1	sarah_id	1	E & Q Petranoff Engineering, Ltd	\N	Supply	Engineering	\N	\N	9786 Roundtree Court	Altadena	CA	51742	USA	\N	\N	684-555-2026	\N	\N	\N	www.eqpetranoffengineering,ltd.com	\N	\N	\N	\N	9786 Roundtree Court	Altadena	CA	51742	USA	0
65157916-93a9-67e5-d373-438dfc35ed6b	2005-11-30 19:23:39	2005-11-30 19:23:39	1	sally_id	1	Petranoff-ONeill Engineering Holdings	\N	Supply	Engineering	\N	\N	5901 F Mt Hood Circle	Tixapan	DF	17504	Mexico	\N	\N	229-555-5629	\N	\N	\N	www.petranoff-oneillengineeringholdings.com	\N	\N	\N	\N	5901 F Mt Hood Circle	Tixapan	DF	17504	Mexico	0
a7b39e5d-493c-5021-3027-438dfcce30dd	2005-11-30 19:23:39	2005-11-30 19:23:39	1	sally_id	1	J & C McDonald Telecommunications Associates	\N	Consulting	Telecommunications	\N	\N	7650 Northridge Drive	Palo Alto	CA	70376	USA	\N	\N	741-555-5294	\N	\N	\N	www.jcmcdonaldtelecommunicationsassociates.com	\N	\N	\N	\N	7650 Northridge Drive	Palo Alto	CA	70376	USA	0
d7a3fd9c-3715-e6f2-2e8b-438dfc374d45	2005-11-30 19:23:39	2005-11-30 19:23:39	1	max_id	1	McDonald-Walter Electronics Holdings	\N	Distribution	Electronics	\N	\N	4019 Weaver Lane	Port Hammond	BC	22992	Canada	\N	\N	860-555-1529	\N	\N	\N	www.mcdonald-walterelectronicsholdings.com	\N	\N	\N	\N	4019 Weaver Lane	Port Hammond	BC	22992	Canada	0
1cea29e6-0f31-0943-b9ab-438dfc45d065	2005-11-30 19:23:40	2005-11-30 19:23:40	1	max_id	1	F & P McGuin Communications, Inc	\N	Consulting	Communications	\N	\N	8678 Estudillo Street	Orizaba	Veracruz	21333	Mexico	\N	\N	494-555-8822	\N	\N	\N	www.fpmcguincommunications,inc.com	\N	\N	\N	\N	8678 Estudillo Street	Orizaba	Veracruz	21333	Mexico	0
6a0493ef-90c2-3391-e434-438dfc67e7f3	2005-11-30 19:23:40	2005-11-30 19:23:40	1	jaime_id	1	McGuin-Amper Engineering, Inc	\N	Consulting	Engineering	\N	\N	5300 Turrin Dr.	Redwood City	CA	91124	USA	\N	\N	875-555-7344	\N	\N	\N	www.mcguin-amperengineering,inc.com	\N	\N	\N	\N	5300 Turrin Dr.	Redwood City	CA	91124	USA	0
a672e98c-171b-2ec5-7d03-438dfc20800e	2005-11-30 19:23:40	2005-11-30 19:23:40	1	max_id	1	F & M Hansen Transportation Corp	\N	Consulting	Transportation	\N	\N	214 Via Del Sol	Chula Vista	CA	76320	USA	\N	\N	533-555-4265	\N	\N	\N	www.fmhansentransportationcorp.com	\N	\N	\N	\N	214 Via Del Sol	Chula Vista	CA	76320	USA	0
e9bbdad1-2981-a54e-4e5b-438dfc08455d	2005-11-30 19:23:40	2005-11-30 19:23:40	1	will_id	1	Hansen-Craycraft Transportation Corp	\N	Distribution	Transportation	\N	\N	9746 Vallejo	Shawnee	BC	13274	Canada	\N	\N	937-555-1415	\N	\N	\N	www.hansen-craycrafttransportationcorp.com	\N	\N	\N	\N	9746 Vallejo	Shawnee	BC	13274	Canada	0
2f921331-569e-4ebf-b85f-438dfc2a8506	2005-11-30 19:23:41	2005-11-30 19:23:41	1	jaime_id	1	O & C Johnson Construction, Inc	\N	Distribution	Construction	\N	\N	7569 Mt. Everest Court	Berkeley	CA	63631	USA	\N	\N	856-555-9622	\N	\N	\N	www.ocjohnsonconstruction,inc.com	\N	\N	\N	\N	7569 Mt. Everest Court	Berkeley	CA	63631	USA	0
69c01b1b-cc6d-c6ba-7d82-438dfcb29df2	2005-11-30 19:23:41	2005-11-30 19:23:41	1	sally_id	1	Johnson-Marlowe Telecommunications Group	\N	Distribution	Telecommunications	\N	\N	7355 San Benito	Westminster	BC	65745	Canada	\N	\N	383-555-5401	\N	\N	\N	www.johnson-marlowetelecommunicationsgroup.com	\N	\N	\N	\N	7355 San Benito	Westminster	BC	65745	Canada	0
a6a6780e-665a-b236-013e-438dfcb9b481	2005-11-30 19:23:41	2005-11-30 19:23:41	1	sarah_id	1	O & F Ortiz Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	2777 Spring Hill Drive	Haney	BC	29680	Canada	\N	\N	325-555-3236	\N	\N	\N	www.ofortizengineering,inc.com	\N	\N	\N	\N	2777 Spring Hill Drive	Haney	BC	29680	Canada	0
e0bf6505-a4cb-5da4-ff16-438dfc3160c7	2005-11-30 19:23:41	2005-11-30 19:23:41	1	beth_id	1	Ortiz-Michaels Transportation Corp	\N	Distribution	Transportation	\N	\N	5473 Hillridge Way	Los Angeles	CA	96956	USA	\N	\N	114-555-1301	\N	\N	\N	www.ortiz-michaelstransportationcorp.com	\N	\N	\N	\N	5473 Hillridge Way	Los Angeles	CA	96956	USA	0
1cc1c1ae-8282-a9b8-0990-438dfc21f836	2005-11-30 19:23:42	2005-11-30 19:23:42	1	chris_id	1	I & U Obaugh Transportation Holdings	\N	Distribution	Transportation	\N	\N	3805 BrushCreek Court	Port Orchard	WA	79636	USA	\N	\N	979-555-6765	\N	\N	\N	www.iuobaughtransportationholdings.com	\N	\N	\N	\N	3805 BrushCreek Court	Port Orchard	WA	79636	USA	0
61281b35-9522-a961-b110-438dfc96ffd5	2005-11-30 19:23:42	2005-11-30 19:23:42	1	will_id	1	Obaugh-Hammons Electronics, Inc	\N	Supply	Electronics	\N	\N	6755 Green View Court	Albany	OR	14075	USA	\N	\N	480-555-4033	\N	\N	\N	www.obaugh-hammonselectronics,inc.com	\N	\N	\N	\N	6755 Green View Court	Albany	OR	14075	USA	0
9b8d325f-2245-2777-7458-438dfcf98dff	2005-11-30 19:23:42	2005-11-30 19:23:42	1	kristen_id	1	I & G Curl Machinery Group	\N	Distribution	Machinery	\N	\N	7996 Ronda Ct.	Santa Anita	DF	35624	Mexico	\N	\N	468-555-8125	\N	\N	\N	www.igcurlmachinerygroup.com	\N	\N	\N	\N	7996 Ronda Ct.	Santa Anita	DF	35624	Mexico	0
e2a26fcb-15b9-e3f4-5278-438dfcd05868	2005-11-30 19:23:42	2005-11-30 19:23:42	1	beth_id	1	Curl-Heth Construction Corp	\N	Supply	Construction	\N	\N	1201 Olive Hill	Salem	OR	35224	USA	\N	\N	542-555-7104	\N	\N	\N	www.curl-hethconstructioncorp.com	\N	\N	\N	\N	1201 Olive Hill	Salem	OR	35224	USA	0
1ec4e7bb-052b-c1a8-6d80-438dfc3ef908	2005-11-30 19:23:43	2005-11-30 19:23:43	1	beth_id	1	D & E Salazar Telecommunications, Inc	\N	Manufacturing	Telecommunications	\N	\N	2697 Hobby Court	Salem	OR	22935	USA	\N	\N	792-555-4482	\N	\N	\N	www.desalazartelecommunications,inc.com	\N	\N	\N	\N	2697 Hobby Court	Salem	OR	22935	USA	0
78f888c0-fbe2-aa7e-16ba-438dfceac795	2005-11-30 19:23:43	2005-11-30 19:23:43	1	chris_id	1	Salazar-Reardon Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	6155 Wilbur Drive	National City	CA	87695	USA	\N	\N	888-555-2090	\N	\N	\N	www.salazar-reardontelecommunications,ltd.com	\N	\N	\N	\N	6155 Wilbur Drive	National City	CA	87695	USA	0
b7b06c1d-d4d2-7a12-0c06-438dfc86b73a	2005-11-30 19:23:43	2005-11-30 19:23:43	1	sarah_id	1	T & P Chenault Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	561 Park Glenn	Sedro Woolley	WA	41568	USA	\N	\N	500-555-1754	\N	\N	\N	www.tpchenaultengineering,inc.com	\N	\N	\N	\N	561 Park Glenn	Sedro Woolley	WA	41568	USA	0
e85850ac-0a63-0b69-a9b1-438dfca59923	2005-11-30 19:23:43	2005-11-30 19:23:43	1	beth_id	1	Chenault-Edwards Communications Partners	\N	Distribution	Communications	\N	\N	6928 N. th Street	Tlaxiaco	Oaxaca	46198	Mexico	\N	\N	619-555-6990	\N	\N	\N	www.chenault-edwardscommunicationspartners.com	\N	\N	\N	\N	6928 N. th Street	Tlaxiaco	Oaxaca	46198	Mexico	0
3a070ce3-f7cd-617d-d237-438dfc16a689	2005-11-30 19:23:44	2005-11-30 19:23:44	1	jaime_id	1	R & Y Sowards Machinery Associates	\N	Manufacturing	Machinery	\N	\N	8932 Westwood Way	Richmond	CA	65232	USA	\N	\N	253-555-5282	\N	\N	\N	www.rysowardsmachineryassociates.com	\N	\N	\N	\N	8932 Westwood Way	Richmond	CA	65232	USA	0
6a7528ab-6435-5063-cfd9-438dfce53729	2005-11-30 19:23:44	2005-11-30 19:23:44	1	kristen_id	1	Sowards-James Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	8210 Mines Road	Lakewood	CA	36024	USA	\N	\N	634-555-3804	\N	\N	\N	www.sowards-jamestelecommunicationspartners.com	\N	\N	\N	\N	8210 Mines Road	Lakewood	CA	36024	USA	0
9af11752-a9fe-aecb-fab7-438dfc778a8b	2005-11-30 19:23:44	2005-11-30 19:23:44	1	sally_id	1	D & T Coy Transportation Holdings	\N	Consulting	Transportation	\N	\N	3124 Fall Creek	San Gabriel	CA	21220	USA	\N	\N	292-555-9725	\N	\N	\N	www.dtcoytransportationholdings.com	\N	\N	\N	\N	3124 Fall Creek	San Gabriel	CA	21220	USA	0
cdaa34ca-831d-c9d6-c0e5-438dfc14756d	2005-11-30 19:23:44	2005-11-30 19:23:44	1	will_id	1	Coy-Putinas Engineering Associates	\N	Distribution	Engineering	\N	\N	5935 Isabel	Berkeley	CA	83465	USA	\N	\N	695-555-6875	\N	\N	\N	www.coy-putinasengineeringassociates.com	\N	\N	\N	\N	5935 Isabel	Berkeley	CA	83465	USA	0
14b514b2-e83e-11d1-1217-438dfc8c5156	2005-11-30 19:23:45	2005-11-30 19:23:45	1	chris_id	1	O & A Jasper Engineering Corp	\N	Supply	Engineering	\N	\N	3758 Springwood Way	Lynnwood	WA	85311	USA	\N	\N	615-555-6083	\N	\N	\N	www.oajasperengineeringcorp.com	\N	\N	\N	\N	3758 Springwood Way	Lynnwood	WA	85311	USA	0
50293355-7599-eea7-5a72-438dfcfaa9d6	2005-11-30 19:23:45	2005-11-30 19:23:45	1	will_id	1	Jasper-Morris Machinery Holdings	\N	Distribution	Machinery	\N	\N	3545 Rotherham Dr.	Milwaukie	OR	10646	USA	\N	\N	493-555-7778	\N	\N	\N	www.jasper-morrismachineryholdings.com	\N	\N	\N	\N	3545 Rotherham Dr.	Milwaukie	OR	10646	USA	0
8c41aa8f-d82c-2dd1-6752-438dfc68590b	2005-11-30 19:23:45	2005-11-30 19:23:45	1	chris_id	1	J & B Laudenslager Telecommunications Company	\N	Consulting	Telecommunications	\N	\N	1622 Silver Oaks Place	Beaverton	OR	71965	USA	\N	\N	435-555-5614	\N	\N	\N	www.jblaudenslagertelecommunicationscompany.com	\N	\N	\N	\N	1622 Silver Oaks Place	Beaverton	OR	71965	USA	0
ca6288e8-018b-a6bb-6c4f-438dfc1d6b02	2005-11-30 19:23:45	2005-11-30 19:23:45	1	matt_id	1	Laudenslager-Dominica Telecommunications Group	\N	Supply	Telecommunications	\N	\N	1663 Park Glen Court	Lakewood	CA	40241	USA	\N	\N	224-555-3678	\N	\N	\N	www.laudenslager-dominicatelecommunicationsgroup.com	\N	\N	\N	\N	1663 Park Glen Court	Lakewood	CA	40241	USA	0
1d240a24-733d-3ab7-64c1-438dfc3357a2	2005-11-30 19:23:46	2005-11-30 19:23:46	1	matt_id	1	G & Q Brandberry Engineering Corp	\N	Manufacturing	Engineering	\N	\N	2650 Hamlet	Portland	OR	22922	USA	\N	\N	428-555-3800	\N	\N	\N	www.gqbrandberryengineeringcorp.com	\N	\N	\N	\N	2650 Hamlet	Portland	OR	22922	USA	0
4d633ea8-f28f-16a7-fbbd-438dfcce24b5	2005-11-30 19:23:46	2005-11-30 19:23:46	1	matt_id	1	Brandberry-Henderson Electronics Group	\N	Consulting	Electronics	\N	\N	2944 North Main St.	Los Angeles	CA	30067	USA	\N	\N	239-555-9493	\N	\N	\N	www.brandberry-hendersonelectronicsgroup.com	\N	\N	\N	\N	2944 North Main St.	Los Angeles	CA	30067	USA	0
954bd18b-4cad-5731-0c27-438dfc7a98e1	2005-11-30 19:23:46	2005-11-30 19:23:46	1	jaime_id	1	S & Y Williamson Electronics Holdings	\N	Manufacturing	Electronics	\N	\N	4185 River Ash Court	San Jose	CA	77909	USA	\N	\N	466-555-8243	\N	\N	\N	www.sywilliamsonelectronicsholdings.com	\N	\N	\N	\N	4185 River Ash Court	San Jose	CA	77909	USA	0
c7ee6c19-78aa-9877-288e-438dfc64ad91	2005-11-30 19:23:46	2005-11-30 19:23:46	1	chris_id	1	Williamson-Goodwater Construction, Ltd	\N	Distribution	Construction	\N	\N	7390 Notre Dame Avenue	Kirkland	WA	51216	USA	\N	\N	301-555-3564	\N	\N	\N	www.williamson-goodwaterconstruction,ltd.com	\N	\N	\N	\N	7390 Notre Dame Avenue	Kirkland	WA	51216	USA	0
fcc0072c-570b-aa7a-0a10-438dfca14c06	2005-11-30 19:23:47	2005-11-30 19:23:47	1	chris_id	1	C & Y Tomlinson Machinery Partners	\N	Supply	Machinery	\N	\N	8885 Partridge Dr.	Woodland Hills	CA	65219	USA	\N	\N	550-555-9943	\N	\N	\N	www.cytomlinsonmachinerypartners.com	\N	\N	\N	\N	8885 Partridge Dr.	Woodland Hills	CA	65219	USA	0
4002a8d9-2b45-20ad-7490-438dfcd3c7b9	2005-11-30 19:23:47	2005-11-30 19:23:47	1	jaime_id	1	Tomlinson-Springate Machinery, Ltd	\N	Manufacturing	Machinery	\N	\N	4999 Corte Segunda	Santa Monica	CA	46893	USA	\N	\N	647-555-7550	\N	\N	\N	www.tomlinson-springatemachinery,ltd.com	\N	\N	\N	\N	4999 Corte Segunda	Santa Monica	CA	46893	USA	0
704e62a8-3a73-3800-3d63-438dfc87d2ce	2005-11-30 19:23:47	2005-11-30 19:23:47	1	beth_id	1	P & J Delhay Telecommunications, Ltd	\N	Manufacturing	Telecommunications	\N	\N	6749 Orchid Ct.	Westminster	BC	57561	Canada	\N	\N	258-555-7214	\N	\N	\N	www.pjdelhaytelecommunications,ltd.com	\N	\N	\N	\N	6749 Orchid Ct.	Westminster	BC	57561	Canada	0
af242932-aa0d-8446-5bea-438dfcc32b6c	2005-11-30 19:23:47	2005-11-30 19:23:47	1	will_id	1	Delhay-Petrick Transportation Associates	\N	Supply	Transportation	\N	\N	3117 Storey Lane	Woodburn	OR	88483	USA	\N	\N	377-555-3450	\N	\N	\N	www.delhay-petricktransportationassociates.com	\N	\N	\N	\N	3117 Storey Lane	Woodburn	OR	88483	USA	0
eb81ef28-ed52-2cdd-0492-438dfcb8efaf	2005-11-30 19:23:47	2005-11-30 19:23:47	1	chris_id	1	B & Y Maestas Engineering Holdings	\N	Manufacturing	Engineering	\N	\N	7776 Cordoba Way	Burien	WA	85181	USA	\N	\N	912-555-1743	\N	\N	\N	www.bymaestasengineeringholdings.com	\N	\N	\N	\N	7776 Cordoba Way	Burien	WA	85181	USA	0
278d5dfa-a9bd-1405-8b20-438dfcf24c04	2005-11-30 19:23:48	2005-11-30 19:23:48	1	sally_id	1	Maestas-Balchuck Electronics Associates	\N	Manufacturing	Electronics	\N	\N	4399 Shuey Ave	Newton	BC	78309	Canada	\N	\N	744-555-6182	\N	\N	\N	www.maestas-balchuckelectronicsassociates.com	\N	\N	\N	\N	4399 Shuey Ave	Newton	BC	78309	Canada	0
893518ed-1f3c-bf65-29d9-438dfc2bba65	2005-11-30 19:23:48	2005-11-30 19:23:48	1	jaime_id	1	B & X Waller Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	9312 Corte Del Sol	Shawnee	BC	63505	Canada	\N	\N	402-555-3103	\N	\N	\N	www.bxwallerelectronics,inc.com	\N	\N	\N	\N	9312 Corte Del Sol	Shawnee	BC	63505	Canada	0
c8881c14-f62e-59f6-9d97-438dfcd0c92a	2005-11-30 19:23:48	2005-11-30 19:23:48	1	kristen_id	1	Waller-Barney Communications, Inc	\N	Manufacturing	Communications	\N	\N	8844 Bel Aire Drive	Yakima	WA	99458	USA	\N	\N	806-555-9253	\N	\N	\N	www.waller-barneycommunications,inc.com	\N	\N	\N	\N	8844 Bel Aire Drive	Yakima	WA	99458	USA	0
112a9128-7496-d4c3-c741-438dfc78433a	2005-11-30 19:23:49	2005-11-30 19:23:49	1	will_id	1	H & G Gerber Machinery Corp	\N	Manufacturing	Machinery	\N	\N	4012 Lime Ridge Drive	Ballard	WA	50816	USA	\N	\N	725-555-8460	\N	\N	\N	www.hggerbermachinerycorp.com	\N	\N	\N	\N	4012 Lime Ridge Drive	Ballard	WA	50816	USA	0
41489b20-3b66-0f87-0ed8-438dfcba09b7	2005-11-30 19:23:49	2005-11-30 19:23:49	1	kristen_id	1	Gerber-Grayson Electronics Corp	\N	Supply	Electronics	\N	\N	3799 Hilton Way	Lynnwood	WA	51026	USA	\N	\N	252-555-4238	\N	\N	\N	www.gerber-graysonelectronicscorp.com	\N	\N	\N	\N	3799 Hilton Way	Lynnwood	WA	51026	USA	0
8c4df6e9-bf3c-6c7f-d616-438dfcdc2492	2005-11-30 19:23:49	2005-11-30 19:23:49	1	kristen_id	1	X & V Purcell Communications Partners	\N	Consulting	Communications	\N	\N	1876 Lanitos Ct.	Bellingham	WA	67544	USA	\N	\N	194-555-2074	\N	\N	\N	www.xvpurcellcommunicationspartners.com	\N	\N	\N	\N	1876 Lanitos Ct.	Bellingham	WA	67544	USA	0
cd076a95-a03a-8166-54fe-438dfcdae315	2005-11-30 19:23:49	2005-11-30 19:23:49	1	beth_id	1	Purcell-Eurich Construction Group	\N	Manufacturing	Construction	\N	\N	4572 Fitzpatrick Drive	Ladner	BC	35821	Canada	\N	\N	882-555-9139	\N	\N	\N	www.purcell-eurichconstructiongroup.com	\N	\N	\N	\N	4572 Fitzpatrick Drive	Ladner	BC	35821	Canada	0
1820ef8f-c74c-624d-e2d1-438dfc773520	2005-11-30 19:23:50	2005-11-30 19:23:50	1	beth_id	1	W & A Pierson Construction Company	\N	Supply	Construction	\N	\N	2904 San Simeon Ct.	Pomona	CA	91208	USA	\N	\N	187-555-9260	\N	\N	\N	www.wapiersonconstructioncompany.com	\N	\N	\N	\N	2904 San Simeon Ct.	Pomona	CA	91208	USA	0
63d3a33d-c0b8-3e5e-6424-438dfca3b887	2005-11-30 19:23:50	2005-11-30 19:23:50	1	will_id	1	Pierson-Jones Engineering Corp	\N	Manufacturing	Engineering	\N	\N	5854 Eagle Way	Chula Vista	CA	25647	USA	\N	\N	898-555-5953	\N	\N	\N	www.pierson-jonesengineeringcorp.com	\N	\N	\N	\N	5854 Eagle Way	Chula Vista	CA	25647	USA	0
9563448c-792e-d962-288f-438dfc98c60f	2005-11-30 19:23:50	2005-11-30 19:23:50	1	matt_id	1	G & T Beatty Engineering, Ltd	\N	Distribution	Engineering	\N	\N	4440 Hawes Street	Altadena	CA	47196	USA	\N	\N	225-555-4703	\N	\N	\N	www.gtbeattyengineering,ltd.com	\N	\N	\N	\N	4440 Hawes Street	Altadena	CA	47196	USA	0
e27af1d7-4419-a694-0b12-438dfc6adf35	2005-11-30 19:23:50	2005-11-30 19:23:50	1	kristen_id	1	Beatty-McNight Machinery Company	\N	Distribution	Machinery	\N	\N	7644 Corte Segunda	Langford	BC	46796	Canada	\N	\N	959-555-9024	\N	\N	\N	www.beatty-mcnightmachinerycompany.com	\N	\N	\N	\N	7644 Corte Segunda	Langford	BC	46796	Canada	0
2bc0a270-26fc-7ae9-9313-438dfcf04250	2005-11-30 19:23:51	2005-11-30 19:23:51	1	chris_id	1	E & C Isaacs Machinery Partners	\N	Supply	Machinery	\N	\N	386 Kelly	Renton	WA	34507	USA	\N	\N	309-555-6403	\N	\N	\N	www.ecisaacsmachinerypartners.com	\N	\N	\N	\N	386 Kelly	Renton	WA	34507	USA	0
5bf631be-1622-a5e9-1a8d-438dfcff57b6	2005-11-30 19:23:51	2005-11-30 19:23:51	1	sally_id	1	Isaacs-Yonce Engineering Corp	\N	Consulting	Engineering	\N	\N	6500 S St.	Walla Walla	WA	99268	USA	\N	\N	644-555-7667	\N	\N	\N	www.isaacs-yonceengineeringcorp.com	\N	\N	\N	\N	6500 S St.	Walla Walla	WA	99268	USA	0
aa0b180a-0efd-40d1-5435-438dfc48d2de	2005-11-30 19:23:51	2005-11-30 19:23:51	1	sally_id	1	S & Y Foster Construction, Ltd	\N	Supply	Construction	\N	\N	8249 La Jolla	Oakland	CA	53141	USA	\N	\N	144-555-5072	\N	\N	\N	www.syfosterconstruction,ltd.com	\N	\N	\N	\N	8249 La Jolla	Oakland	CA	53141	USA	0
1408024c-90ca-89db-f420-438dfc69555c	2005-11-30 19:23:52	2005-11-30 19:23:52	1	matt_id	1	Foster-Reed Transportation Company	\N	Manufacturing	Transportation	\N	\N	4618 Olive Hill	Newton	BC	57771	Canada	\N	\N	263-555-1308	\N	\N	\N	www.foster-reedtransportationcompany.com	\N	\N	\N	\N	4618 Olive Hill	Newton	BC	57771	Canada	0
5aa4340e-d0ac-4dbe-2eda-438dfc2ffaca	2005-11-30 19:23:52	2005-11-30 19:23:52	1	sally_id	1	V & B Kwiatkowski Machinery, Ltd	\N	Consulting	Machinery	\N	\N	9277 Ridgewood Court	Issaquah	WA	76805	USA	\N	\N	798-555-8600	\N	\N	\N	www.vbkwiatkowskimachinery,ltd.com	\N	\N	\N	\N	9277 Ridgewood Court	Issaquah	WA	76805	USA	0
996773d8-7459-442b-e781-438dfc17a340	2005-11-30 19:23:52	2005-11-30 19:23:52	1	sally_id	1	Kwiatkowski-Vann Electronics Corp	\N	Manufacturing	Electronics	\N	\N	5899 Mt. Wilson Place	Novato	CA	73889	USA	\N	\N	279-555-7122	\N	\N	\N	www.kwiatkowski-vannelectronicscorp.com	\N	\N	\N	\N	5899 Mt. Wilson Place	Novato	CA	73889	USA	0
cc6b9706-5113-ca5b-cb3b-438dfc78598d	2005-11-30 19:23:52	2005-11-30 19:23:52	1	matt_id	1	X & V Smith Construction, Ltd	\N	Consulting	Construction	\N	\N	3469 Gill Ct.	Lincoln Acres	CA	59085	USA	\N	\N	836-555-4043	\N	\N	\N	www.xvsmithconstruction,ltd.com	\N	\N	\N	\N	3469 Gill Ct.	Lincoln Acres	CA	59085	USA	0
88570831-b950-4b7e-6cd1-438dfc241b2e	2005-11-30 19:23:53	2005-11-30 19:23:53	1	will_id	1	Smith-Hensley Electronics Company	\N	Consulting	Electronics	\N	\N	346 Sutcliffe Pl.	Langford	BC	95038	Canada	\N	\N	340-555-1193	\N	\N	\N	www.smith-hensleyelectronicscompany.com	\N	\N	\N	\N	346 Sutcliffe Pl.	Langford	BC	95038	Canada	0
390ee98e-8b3c-5965-e4fd-438dfc1c6eaa	2005-11-30 19:23:53	2005-11-30 19:23:53	1	sarah_id	1	X & C Owens Transportation, Ltd	\N	Distribution	Transportation	\N	\N	8168 Eaker Way	La Jolla	CA	63289	USA	\N	\N	259-555-9401	\N	\N	\N	www.xcowenstransportation,ltd.com	\N	\N	\N	\N	8168 Eaker Way	La Jolla	CA	63289	USA	0
778b80e7-794c-0a12-6f96-438dfc41229c	2005-11-30 19:23:53	2005-11-30 19:23:53	1	kristen_id	1	Owens-Castillo Engineering Associates	\N	Distribution	Engineering	\N	\N	7955 Cleveland Rd.	Walla Walla	WA	65403	USA	\N	\N	925-555-8836	\N	\N	\N	www.owens-castilloengineeringassociates.com	\N	\N	\N	\N	7955 Cleveland Rd.	Walla Walla	WA	65403	USA	0
b8db6e77-2347-fbbf-e50e-438dfc33ba76	2005-11-30 19:23:53	2005-11-30 19:23:53	1	chris_id	1	J & F Munoz Electronics Corp	\N	Consulting	Electronics	\N	\N	6032 Delta Road	Richmond	BC	55630	Canada	\N	\N	867-555-6672	\N	\N	\N	www.jfmunozelectronicscorp.com	\N	\N	\N	\N	6032 Delta Road	Richmond	BC	55630	Canada	0
118c01c7-38b6-1470-71ce-438dfc47cedc	2005-11-30 19:23:54	2005-11-30 19:23:54	1	sarah_id	1	Munoz-Lightfoot Engineering Group	\N	Manufacturing	Engineering	\N	\N	6073 San Francisco	Santa Anita	DF	23907	Mexico	\N	\N	417-555-1079	\N	\N	\N	www.munoz-lightfootengineeringgroup.com	\N	\N	\N	\N	6073 San Francisco	Santa Anita	DF	23907	Mexico	0
501fc4d0-306b-3755-b0e4-438dfc055616	2005-11-30 19:23:54	2005-11-30 19:23:54	1	max_id	1	Y & B Simmons Communications Partners	\N	Manufacturing	Communications	\N	\N	4404 Mildred Avenue	Redwood City	CA	65871	USA	\N	\N	621-555-1201	\N	\N	\N	www.ybsimmonscommunicationspartners.com	\N	\N	\N	\N	4404 Mildred Avenue	Redwood City	CA	65871	USA	0
8f64ce1e-2846-22cf-52b1-438dfc1e4865	2005-11-30 19:23:54	2005-11-30 19:23:54	1	sarah_id	1	Simmons-Hays Engineering Partners	\N	Distribution	Engineering	\N	\N	7354 Scottsdale Rd	Merida	Yucatan	40025	Mexico	\N	\N	432-555-6893	\N	\N	\N	www.simmons-haysengineeringpartners.com	\N	\N	\N	\N	7354 Scottsdale Rd	Merida	Yucatan	40025	Mexico	0
d0f6f8f3-3f8d-6ac9-07a2-438dfca4d5a3	2005-11-30 19:23:54	2005-11-30 19:23:54	1	sarah_id	1	L & O Auintana Machinery Group	\N	Consulting	Machinery	\N	\N	8595 Central Avenue	Shawnee	BC	61574	Canada	\N	\N	113-555-2482	\N	\N	\N	www.loauintanamachinerygroup.com	\N	\N	\N	\N	8595 Central Avenue	Shawnee	BC	61574	Canada	0
d844099c-3218-4a53-04fd-438dfcf7fe24	2005-11-30 19:23:55	2005-11-30 19:23:55	1	sarah_id	1	Auintana-Flanigan Machinery Corp	\N	Supply	Machinery	\N	\N	1800 B Eagle Peak Rd.	Ballard	WA	61174	USA	\N	\N	848-555-6803	\N	\N	\N	www.auintana-flaniganmachinerycorp.com	\N	\N	\N	\N	1800 B Eagle Peak Rd.	Ballard	WA	61174	USA	0
4cc59be8-6a2b-045e-fffa-438dfcb7ecd1	2005-11-30 19:23:55	2005-11-30 19:23:55	1	beth_id	1	J & R Shanklin Construction Group	\N	Distribution	Construction	\N	\N	3296 Sinaloa	Ballard	WA	48885	USA	\N	\N	437-555-7839	\N	\N	\N	www.jrshanklinconstructiongroup.com	\N	\N	\N	\N	3296 Sinaloa	Ballard	WA	48885	USA	0
7e36e18a-2a32-95e6-141d-438dfc516b2e	2005-11-30 19:23:55	2005-11-30 19:23:55	1	sally_id	1	Shanklin-Lewis Communications Associates	\N	Manufacturing	Communications	\N	\N	6754 Pamploma Ct.	San Diego	CA	87353	USA	\N	\N	533-555-5446	\N	\N	\N	www.shanklin-lewiscommunicationsassociates.com	\N	\N	\N	\N	6754 Pamploma Ct.	San Diego	CA	87353	USA	0
b165ae47-2fc0-be05-a089-438dfc950f45	2005-11-30 19:23:55	2005-11-30 19:23:55	1	beth_id	1	I & O King Electronics Holdings	\N	Distribution	Electronics	\N	\N	1160 Bella Avenue	Port Orchard	WA	67518	USA	\N	\N	806-555-1453	\N	\N	\N	www.iokingelectronicsholdings.com	\N	\N	\N	\N	1160 Bella Avenue	Port Orchard	WA	67518	USA	0
1a2b5888-e59b-c7cd-18f1-438dfc046cd4	2005-11-30 19:23:56	2005-11-30 19:23:56	1	beth_id	1	King-Frongillo Transportation Holdings	\N	Supply	Transportation	\N	\N	7527 Eola	Camacho	Zacatecas	72149	Mexico	\N	\N	264-555-1346	\N	\N	\N	www.king-frongillotransportationholdings.com	\N	\N	\N	\N	7527 Eola	Camacho	Zacatecas	72149	Mexico	0
598d45b0-cf4d-be31-0b37-438dfcaf36de	2005-11-30 19:23:56	2005-11-30 19:23:56	1	beth_id	1	P & N Stallings Construction Company	\N	Consulting	Construction	\N	\N	9531 Harrison Street	Colma	CA	91182	USA	\N	\N	559-555-4982	\N	\N	\N	www.pnstallingsconstructioncompany.com	\N	\N	\N	\N	9531 Harrison Street	Colma	CA	91182	USA	0
ba2d0e92-2b82-c7a0-aefc-438dfc5bbc75	2005-11-30 19:23:56	2005-11-30 19:23:56	1	max_id	1	Stallings-Yoshimura Engineering Group	\N	Supply	Engineering	\N	\N	8809 Diablo View Road	Burbank	CA	61975	USA	\N	\N	940-555-3503	\N	\N	\N	www.stallings-yoshimuraengineeringgroup.com	\N	\N	\N	\N	8809 Diablo View Road	Burbank	CA	61975	USA	0
2414a861-856d-d2e2-bf08-438dfc9407bf	2005-11-30 19:23:57	2005-11-30 19:23:57	1	kristen_id	1	W & Y Rowland Construction, Ltd	\N	Consulting	Construction	\N	\N	3723 Mt. Sequoia Ct.	Santa Monica	CA	47170	USA	\N	\N	598-555-9424	\N	\N	\N	www.wyrowlandconstruction,ltd.com	\N	\N	\N	\N	3723 Mt. Sequoia Ct.	Santa Monica	CA	47170	USA	0
638ef092-a33f-0e0c-ebc2-438dfc121ac0	2005-11-30 19:23:57	2005-11-30 19:23:57	1	kristen_id	1	Rowland-Balleo Machinery, Inc	\N	Distribution	Machinery	\N	\N	3255 Marsh Elder	La Jolla	CA	83123	USA	\N	\N	340-555-1232	\N	\N	\N	www.rowland-balleomachinery,inc.com	\N	\N	\N	\N	3255 Marsh Elder	La Jolla	CA	83123	USA	0
a5efc69d-86e3-c51d-1f94-438dfc385db9	2005-11-30 19:23:57	2005-11-30 19:23:57	1	chris_id	1	Z & N Maggard Communications Partners	\N	Manufacturing	Communications	\N	\N	8422 W. Holly Drive	Renton	WA	85740	USA	\N	\N	921-555-5782	\N	\N	\N	www.znmaggardcommunicationspartners.com	\N	\N	\N	\N	8422 W. Holly Drive	Renton	WA	85740	USA	0
d6020c11-a159-8e9a-a1d7-438dfc1b496a	2005-11-30 19:23:57	2005-11-30 19:23:57	1	matt_id	1	Maggard-Bezic Electronics Associates	\N	Consulting	Electronics	\N	\N	2898 Forest Way	Redmond	WA	87855	USA	\N	\N	687-555-5217	\N	\N	\N	www.maggard-bezicelectronicsassociates.com	\N	\N	\N	\N	2898 Forest Way	Redmond	WA	87855	USA	0
1237d33b-03c3-419a-73ea-438dfcbee32d	2005-11-30 19:23:58	2005-11-30 19:23:58	1	matt_id	1	H & S Staley Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	975 Harris Circle	Lake Oswego	OR	53753	USA	\N	\N	980-555-8971	\N	\N	\N	www.hsstaleytelecommunications,ltd.com	\N	\N	\N	\N	975 Harris Circle	Lake Oswego	OR	53753	USA	0
428a4aeb-d8e7-e5f8-f4d6-438dfc715771	2005-11-30 19:23:58	2005-11-30 19:23:58	1	max_id	1	Staley-Lipford Engineering, Ltd	\N	Supply	Engineering	\N	\N	1016 Whyte Park Avenue	Burbank	CA	72651	USA	\N	\N	769-555-7035	\N	\N	\N	www.staley-lipfordengineering,ltd.com	\N	\N	\N	\N	1016 Whyte Park Avenue	Burbank	CA	72651	USA	0
a29bdad9-c920-afe4-d906-438dfcf200d1	2005-11-30 19:23:58	2005-11-30 19:23:58	1	sarah_id	1	M & R Winternitz Electronics Holdings	\N	Distribution	Electronics	\N	\N	2003 Pinecrest Dr.	Redmond	WA	29039	USA	\N	\N	734-555-3499	\N	\N	\N	www.mrwinternitzelectronicsholdings.com	\N	\N	\N	\N	2003 Pinecrest Dr.	Redmond	WA	29039	USA	0
d57a05ea-6231-9c57-f684-438dfc0ece79	2005-11-30 19:23:58	2005-11-30 19:23:58	1	matt_id	1	Winternitz-Burns Engineering Associates	\N	Supply	Engineering	\N	\N	2297 Via Valencia	Santa Anita	DF	62477	Mexico	\N	\N	545-555-9192	\N	\N	\N	www.winternitz-burnsengineeringassociates.com	\N	\N	\N	\N	2297 Via Valencia	Santa Anita	DF	62477	Mexico	0
11a182e9-8983-9899-e85b-438dfcae42d2	2005-11-30 19:23:59	2005-11-30 19:23:59	1	max_id	1	C & R Cruz Engineering Partners	\N	Supply	Engineering	\N	\N	3538 Esperanza Drive	Coronado	CA	11319	USA	\N	\N	772-555-7942	\N	\N	\N	www.crcruzengineeringpartners.com	\N	\N	\N	\N	3538 Esperanza Drive	Coronado	CA	11319	USA	0
421d206d-afa1-4024-ff07-438dfc380941	2005-11-30 19:23:59	2005-11-30 19:23:59	1	max_id	1	Cruz-Geiermann Engineering Company	\N	Consulting	Engineering	\N	\N	6742 Cleaveland Road	West Covina	CA	83626	USA	\N	\N	845-555-6921	\N	\N	\N	www.cruz-geiermannengineeringcompany.com	\N	\N	\N	\N	6742 Cleaveland Road	West Covina	CA	83626	USA	0
a5ff1c0f-fcab-e1db-053a-438dfc953533	2005-11-30 19:23:59	2005-11-30 19:23:59	1	sarah_id	1	X & N Eichorn Construction Corp	\N	Consulting	Construction	\N	\N	8238 D Kiska Ct.	Newport Beach	CA	97629	USA	\N	\N	195-555-4299	\N	\N	\N	www.xneichornconstructioncorp.com	\N	\N	\N	\N	8238 D Kiska Ct.	Newport Beach	CA	97629	USA	0
d63223ae-3fcd-0bbd-c6e9-438dfc2b5132	2005-11-30 19:23:59	2005-11-30 19:23:59	1	kristen_id	1	Eichorn-Belsey Machinery Group	\N	Supply	Machinery	\N	\N	4352 Marclair Dr.	Concord	CA	37098	USA	\N	\N	292-555-1906	\N	\N	\N	www.eichorn-belseymachinerygroup.com	\N	\N	\N	\N	4352 Marclair Dr.	Concord	CA	37098	USA	0
1291fd0e-0b21-b243-e90a-438dfcc8a6d4	2005-11-30 19:24:00	2005-11-30 19:24:00	1	max_id	1	A & U Jaramillo Telecommunications, Inc	\N	Manufacturing	Telecommunications	\N	\N	6102 Corte Poquito	Walla Walla	WA	89970	USA	\N	\N	564-555-6913	\N	\N	\N	www.aujaramillotelecommunications,inc.com	\N	\N	\N	\N	6102 Corte Poquito	Walla Walla	WA	89970	USA	0
53b25086-df00-b865-87bf-438dfc2e9e2a	2005-11-30 19:24:00	2005-11-30 19:24:00	1	beth_id	1	Jaramillo-Compagno Telecommunications Group	\N	Manufacturing	Telecommunications	\N	\N	2470 Indianhead Circle	W. Linn	OR	21894	USA	\N	\N	922-555-6806	\N	\N	\N	www.jaramillo-compagnotelecommunicationsgroup.com	\N	\N	\N	\N	2470 Indianhead Circle	W. Linn	OR	21894	USA	0
84a158a8-9b77-8763-f48e-438dfc86a84a	2005-11-30 19:24:00	2005-11-30 19:24:00	1	sally_id	1	C & Z Souza Telecommunications, Ltd	\N	Consulting	Telecommunications	\N	\N	7129 Corte Bonita	Albany	OR	40927	USA	\N	\N	318-555-1442	\N	\N	\N	www.czsouzatelecommunications,ltd.com	\N	\N	\N	\N	7129 Corte Bonita	Albany	OR	40927	USA	0
d8db292d-d903-51c1-7629-438dfc04dae1	2005-11-30 19:24:00	2005-11-30 19:24:00	1	will_id	1	Souza-Quick Construction Group	\N	Distribution	Construction	\N	\N	3752 Hamilton Ct	Burnaby	BC	11720	Canada	\N	\N	699-555-8963	\N	\N	\N	www.souza-quickconstructiongroup.com	\N	\N	\N	\N	3752 Hamilton Ct	Burnaby	BC	11720	Canada	0
46c1629b-ff53-12b7-de33-438dfc79acc0	2005-11-30 19:24:01	2005-11-30 19:24:01	1	sarah_id	1	E & Q Curtsinger Engineering, Ltd	\N	Supply	Engineering	\N	\N	8665 Brown Street	West Covina	CA	95914	USA	\N	\N	947-555-6459	\N	\N	\N	www.eqcurtsingerengineering,ltd.com	\N	\N	\N	\N	8665 Brown Street	West Covina	CA	95914	USA	0
7720b17b-d7d0-e845-e74d-438dfccdb560	2005-11-30 19:24:01	2005-11-30 19:24:01	1	sally_id	1	Curtsinger-Swartwood Engineering Holdings	\N	Supply	Engineering	\N	\N	8197 Haviland Place	Puyallup	WA	25084	USA	\N	\N	450-555-3609	\N	\N	\N	www.curtsinger-swartwoodengineeringholdings.com	\N	\N	\N	\N	8197 Haviland Place	Puyallup	WA	25084	USA	0
bcdea145-1765-f3d6-1f3f-438dfc89a81b	2005-11-30 19:24:01	2005-11-30 19:24:01	1	sally_id	1	J & C Anderson Telecommunications Associates	\N	Consulting	Telecommunications	\N	\N	3365 Atherton Circle	Grossmont	CA	75441	USA	\N	\N	131-555-8159	\N	\N	\N	www.jcandersontelecommunicationsassociates.com	\N	\N	\N	\N	3365 Atherton Circle	Grossmont	CA	75441	USA	0
f8fd0b41-cad8-e5ba-85c9-438dfc45bf5c	2005-11-30 19:24:02	2005-11-30 19:24:02	1	max_id	1	Anderson-Cutwright Electronics Holdings	\N	Distribution	Electronics	\N	\N	3152 Woodcrest Drive	Lebanon	OR	77556	USA	\N	\N	797-555-7595	\N	\N	\N	www.anderson-cutwrightelectronicsholdings.com	\N	\N	\N	\N	3152 Woodcrest Drive	Lebanon	OR	77556	USA	0
5478ecd4-649f-5f03-7ef5-438dfc409603	2005-11-30 19:24:02	2005-11-30 19:24:02	1	max_id	1	F & P Bishop Communications, Inc	\N	Consulting	Communications	\N	\N	1229 Apollo Way	Lynnwood	WA	94074	USA	\N	\N	739-555-5431	\N	\N	\N	www.fpbishopcommunications,inc.com	\N	\N	\N	\N	1229 Apollo Way	Lynnwood	WA	94074	USA	0
9743fa19-2c3a-af48-3303-438dfc988c03	2005-11-30 19:24:02	2005-11-30 19:24:02	1	jaime_id	1	Bishop-Ciruli Engineering, Inc	\N	Consulting	Engineering	\N	\N	3925 North 39th Street	Haney	BC	36059	Canada	\N	\N	527-555-3495	\N	\N	\N	www.bishop-ciruliengineering,inc.com	\N	\N	\N	\N	3925 North 39th Street	Haney	BC	36059	Canada	0
aac40ead-acb0-b31d-1133-438dfc9a4799	2005-11-30 19:24:03	2005-11-30 19:24:03	1	max_id	1	F & M Detwiler Transportation Corp	\N	Consulting	Transportation	\N	\N	2257 Gibrix Drive	Downey	CA	18740	USA	\N	\N	493-555-8959	\N	\N	\N	www.fmdetwilertransportationcorp.com	\N	\N	\N	\N	2257 Gibrix Drive	Downey	CA	18740	USA	0
6ffaba8d-eb1f-c28b-8644-438dfcbea0e4	2005-11-30 19:24:03	2005-11-30 19:24:03	1	will_id	1	Detwiler-Biltoft Transportation Corp	\N	Distribution	Transportation	\N	\N	5207 Mota Dr.	Lincoln Acres	CA	52177	USA	\N	\N	304-555-5652	\N	\N	\N	www.detwiler-biltofttransportationcorp.com	\N	\N	\N	\N	5207 Mota Dr.	Lincoln Acres	CA	52177	USA	0
a13886ab-0e56-9291-0447-438dfc4546dd	2005-11-30 19:24:03	2005-11-30 19:24:03	1	jaime_id	1	O & C Younce Construction, Inc	\N	Distribution	Construction	\N	\N	3792 Westwood Ct.	Beverly Hills	CA	73727	USA	\N	\N	531-555-4402	\N	\N	\N	www.ocyounceconstruction,inc.com	\N	\N	\N	\N	3792 Westwood Ct.	Beverly Hills	CA	73727	USA	0
2ca40a4f-c1a5-8085-4cbf-438dfcd9c2a9	2005-11-30 19:24:04	2005-11-30 19:24:04	1	sally_id	1	Younce-Pirnie Telecommunications Group	\N	Distribution	Telecommunications	\N	\N	9652 Steven Drive	Corvallis	OR	73326	USA	\N	\N	604-555-3381	\N	\N	\N	www.younce-pirnietelecommunicationsgroup.com	\N	\N	\N	\N	9652 Steven Drive	Corvallis	OR	73326	USA	0
33126c17-e9a1-4bd9-a94f-438dfc78c4ee	2005-11-30 19:24:04	2005-11-30 19:24:04	1	sarah_id	1	O & F Doolittle Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	1148 Thornwood Drive	Corvallis	OR	61037	USA	\N	\N	854-555-9759	\N	\N	\N	www.ofdoolittleengineering,inc.com	\N	\N	\N	\N	1148 Thornwood Drive	Corvallis	OR	61037	USA	0
86d63404-ca50-c4d2-1038-438dfc0d2ce3	2005-11-30 19:24:04	2005-11-30 19:24:04	1	beth_id	1	Doolittle-Burnham Transportation Corp	\N	Distribution	Transportation	\N	\N	4606 Charmttone Court	Torrance	CA	26799	USA	\N	\N	950-555-7366	\N	\N	\N	www.doolittle-burnhamtransportationcorp.com	\N	\N	\N	\N	4606 Charmttone Court	Torrance	CA	26799	USA	0
cc3411e6-b2f4-24e2-08cd-438dfcde2680	2005-11-30 19:24:04	2005-11-30 19:24:04	1	chris_id	1	I & U Stand Transportation Holdings	\N	Distribution	Transportation	\N	\N	9011 Tabora Drive	Redmond	WA	79671	USA	\N	\N	323-555-3373	\N	\N	\N	www.iustandtransportationholdings.com	\N	\N	\N	\N	9011 Tabora Drive	Redmond	WA	79671	USA	0
85840e37-3aaa-7bc1-b257-438dfc9b70fe	2005-11-30 19:24:05	2005-11-30 19:24:05	1	will_id	1	Stand-Backlin Electronics, Inc	\N	Supply	Electronics	\N	\N	3971 Confir Court	La Mesa	CA	84301	USA	\N	\N	132-555-9184	\N	\N	\N	www.stand-backlinelectronics,inc.com	\N	\N	\N	\N	3971 Confir Court	La Mesa	CA	84301	USA	0
386ecec0-8eb5-ce3c-0c4d-438dfc08982a	2005-11-30 19:24:05	2005-11-30 19:24:05	1	kristen_id	1	I & G Sharp Machinery Group	\N	Distribution	Machinery	\N	\N	8629 English Court	Redwood City	CA	43364	USA	\N	\N	667-555-7477	\N	\N	\N	www.igsharpmachinerygroup.com	\N	\N	\N	\N	8629 English Court	Redwood City	CA	43364	USA	0
7b1a3ffe-b883-9f36-d29d-438dfc6a9109	2005-11-30 19:24:05	2005-11-30 19:24:05	1	beth_id	1	Sharp-Torres Construction Corp	\N	Supply	Construction	\N	\N	5252 Santa Fe	W. Linn	OR	14203	USA	\N	\N	809-555-2341	\N	\N	\N	www.sharp-torresconstructioncorp.com	\N	\N	\N	\N	5252 Santa Fe	W. Linn	OR	14203	USA	0
e4c2a7f1-29e7-e674-dfda-438dfccc2bc2	2005-11-30 19:24:05	2005-11-30 19:24:05	1	beth_id	1	D & E Sall Telecommunications, Inc	\N	Manufacturing	Telecommunications	\N	\N	2822 Valmar Dr	Fremont	CA	13323	USA	\N	\N	706-555-2920	\N	\N	\N	www.desalltelecommunications,inc.com	\N	\N	\N	\N	2822 Valmar Dr	Fremont	CA	13323	USA	0
20eb8a51-b7ce-0529-75b1-438dfc371e81	2005-11-30 19:24:06	2005-11-30 19:24:06	1	chris_id	1	Sall-Scott Telecommunications, Ltd	\N	Supply	Telecommunications	\N	\N	9697 Central Ave	Seattle	WA	49276	USA	\N	\N	209-555-9070	\N	\N	\N	www.sall-scotttelecommunications,ltd.com	\N	\N	\N	\N	9697 Central Ave	Seattle	WA	49276	USA	0
514fcdd2-d85d-1a7d-7f1d-438dfc1bfc2b	2005-11-30 19:24:06	2005-11-30 19:24:06	1	sarah_id	1	T & P Zablah Engineering, Inc	\N	Manufacturing	Engineering	\N	\N	7521 Mount Aire Parkway	Torrance	CA	99633	USA	\N	\N	790-555-4619	\N	\N	\N	www.tpzablahengineering,inc.com	\N	\N	\N	\N	7521 Mount Aire Parkway	Torrance	CA	99633	USA	0
818ba130-82a0-510e-243c-438dfcadc657	2005-11-30 19:24:06	2005-11-30 19:24:06	1	beth_id	1	Zablah-Verity Communications Partners	\N	Distribution	Communications	\N	\N	7307 Corte Segundo	Guadalajara	Jalisco	27493	Mexico	\N	\N	555-555-4055	\N	\N	\N	www.zablah-veritycommunicationspartners.com	\N	\N	\N	\N	7307 Corte Segundo	Guadalajara	Jalisco	27493	Mexico	0
d967f00f-b4fb-546a-e2cd-438dfc51e139	2005-11-30 19:24:06	2005-11-30 19:24:06	1	jaime_id	1	R & Y Pope Machinery Associates	\N	Manufacturing	Machinery	\N	\N	5385 Sony Hill Circle	Victoria	BC	91975	Canada	\N	\N	498-555-1891	\N	\N	\N	www.rypopemachineryassociates.com	\N	\N	\N	\N	5385 Sony Hill Circle	Victoria	BC	91975	Canada	0
159db820-3506-22d0-baae-438dfc9d48c0	2005-11-30 19:24:07	2005-11-30 19:24:07	1	kristen_id	1	Pope-Harriman Telecommunications Partners	\N	Consulting	Telecommunications	\N	\N	5425 Highland Circle	Cliffside	BC	60251	Canada	\N	\N	286-555-8955	\N	\N	\N	www.pope-harrimantelecommunicationspartners.com	\N	\N	\N	\N	5425 Highland Circle	Cliffside	BC	60251	Canada	0
6b413b0a-a8f4-82f5-bdd6-438dfc03fea7	2005-11-30 19:24:07	2005-11-30 19:24:07	1	sally_id	1	D & T Bowen Transportation Holdings	\N	Consulting	Transportation	\N	\N	3757 Brook Hollow Ct	Woodburn	OR	42932	USA	\N	\N	251-555-5419	\N	\N	\N	www.dtbowentransportationholdings.com	\N	\N	\N	\N	3757 Brook Hollow Ct	Woodburn	OR	42932	USA	0
9c278db4-ede9-c13a-af84-438dfcd5ae49	2005-11-30 19:24:07	2005-11-30 19:24:07	1	will_id	1	Bowen-Pochert Engineering Associates	\N	Distribution	Engineering	\N	\N	6707 Grand View Avenue	Altadena	CA	50077	USA	\N	\N	963-555-2112	\N	\N	\N	www.bowen-pochertengineeringassociates.com	\N	\N	\N	\N	6707 Grand View Avenue	Altadena	CA	50077	USA	0
a410043f-7a9a-f5fe-d34c-438dfc51da32	2005-11-30 19:24:08	2005-11-30 19:24:08	1	chris_id	1	O & A Stone Engineering Corp	\N	Supply	Engineering	\N	\N	7948 Roehlidge Lane	Puyallup	WA	97919	USA	\N	\N	290-555-9862	\N	\N	\N	www.oastoneengineeringcorp.com	\N	\N	\N	\N	7948 Roehlidge Lane	Puyallup	WA	97919	USA	0
439df1d9-a1d2-938f-fcbc-438dfcc0b382	2005-11-30 19:24:08	2005-11-30 19:24:08	1	will_id	1	Stone-Lippman Machinery Holdings	\N	Distribution	Machinery	\N	\N	1153 Loma Linda	Mexico City	Mexico	97518	Mexico	\N	\N	483-555-1864	\N	\N	\N	www.stone-lippmanmachineryholdings.com	\N	\N	\N	\N	1153 Loma Linda	Mexico City	Mexico	97518	Mexico	0
9a01d899-3cd3-82bc-4879-438dfc4aa427	2005-11-30 19:24:08	2005-11-30 19:24:08	1	chris_id	1	J & B Heiser Telecommunications Company	\N	Consulting	Telecommunications	\N	\N	2648 Hillcrest	El Cajon	CA	85229	USA	\N	\N	733-555-8242	\N	\N	\N	www.jbheisertelecommunicationscompany.com	\N	\N	\N	\N	2648 Hillcrest	El Cajon	CA	85229	USA	0
13b9ce8d-5a7f-dc60-5f5d-438dfc417588	2005-11-30 19:24:09	2005-11-30 19:24:09	1	matt_id	1	Heiser-Craig Telecommunications Group	\N	Supply	Telecommunications	\N	\N	6107 Westwood Dr	Mexico City	Mexico	24699	Mexico	\N	\N	829-555-5849	\N	\N	\N	www.heiser-craigtelecommunicationsgroup.com	\N	\N	\N	\N	6107 Westwood Dr	Mexico City	Mexico	24699	Mexico	0
451eba4c-ebbc-e355-a55d-438dfc6dd0bf	2005-11-30 19:24:09	2005-11-30 19:24:09	1	matt_id	1	G & Q Castano Engineering Corp	\N	Manufacturing	Engineering	\N	\N	512 Palms Dr	Renton	WA	48644	USA	\N	\N	202-555-1856	\N	\N	\N	www.gqcastanoengineeringcorp.com	\N	\N	\N	\N	512 Palms Dr	Renton	WA	48644	USA	0
b4f569b4-c6a8-b257-fcb4-438dfcbcb5f0	2005-11-30 19:24:09	2005-11-30 19:24:09	1	matt_id	1	Castano-Caudill Electronics Group	\N	Consulting	Electronics	\N	\N	6880 N Lucile Lane	Salem	OR	94943	USA	\N	\N	560-555-1749	\N	\N	\N	www.castano-caudillelectronicsgroup.com	\N	\N	\N	\N	6880 N Lucile Lane	Salem	OR	94943	USA	0
e5ff98ed-075f-7aa5-56fa-438dfc049120	2005-11-30 19:24:09	2005-11-30 19:24:09	1	jaime_id	1	S & Y Romero Electronics Holdings	\N	Manufacturing	Electronics	\N	\N	1540 Westbury Dr	Acapulco	Guerrero	28528	Mexico	\N	\N	195-555-9042	\N	\N	\N	www.syromeroelectronicsholdings.com	\N	\N	\N	\N	1540 Westbury Dr	Acapulco	Guerrero	28528	Mexico	0
361fafb3-51ba-58de-391b-438dfc2a0aec	2005-11-30 19:24:10	2005-11-30 19:24:10	1	chris_id	1	Romero-Hicks Construction, Ltd	\N	Distribution	Construction	\N	\N	8162 Milden Road	Santa Monica	CA	98319	USA	\N	\N	576-555-7564	\N	\N	\N	www.romero-hicksconstruction,ltd.com	\N	\N	\N	\N	8162 Milden Road	Santa Monica	CA	98319	USA	0
79e65b4a-b856-c71a-19a1-438dfc5344ec	2005-11-30 19:24:10	2005-11-30 19:24:10	1	chris_id	1	C & Y Difatta Machinery Partners	\N	Supply	Machinery	\N	\N	3076 Monti Dr	Grossmont	CA	77346	USA	\N	\N	233-555-4485	\N	\N	\N	www.cydifattamachinerypartners.com	\N	\N	\N	\N	3076 Monti Dr	Grossmont	CA	77346	USA	0
c1abebb3-fd9d-f3f4-8bc6-438dfc756f30	2005-11-30 19:24:10	2005-11-30 19:24:10	1	jaime_id	1	Difatta-Schaidt Machinery, Ltd	\N	Manufacturing	Machinery	\N	\N	2608 Southhampton Road	Santa Fe	DF	14300	Mexico	\N	\N	637-555-1635	\N	\N	\N	www.difatta-schaidtmachinery,ltd.com	\N	\N	\N	\N	2608 Southhampton Road	Santa Fe	DF	14300	Mexico	0
f21a7b1f-7757-acc5-7e52-438dfcb88dc0	2005-11-30 19:24:10	2005-11-30 19:24:10	1	beth_id	1	P & J Brush Telecommunications, Ltd	\N	Manufacturing	Telecommunications	\N	\N	7775 San Ysidro Court	Oregon City	OR	64656	USA	\N	\N	556-555-9842	\N	\N	\N	www.pjbrushtelecommunications,ltd.com	\N	\N	\N	\N	7775 San Ysidro Court	Oregon City	OR	64656	USA	0
698916c3-7e8c-21c5-1f38-438dfc3931c8	2005-11-30 19:24:11	2005-11-30 19:24:11	1	will_id	1	Brush-Cambra Transportation Associates	\N	Supply	Transportation	\N	\N	7561 Humphrey Drive	Newton	BC	66771	Canada	\N	\N	983-555-5621	\N	\N	\N	www.brush-cambratransportationassociates.com	\N	\N	\N	\N	7561 Humphrey Drive	Newton	BC	66771	Canada	0
99edc13c-8d09-83c1-83b2-438dfc899358	2005-11-30 19:24:11	2005-11-30 19:24:11	1	chris_id	1	B & Y Mills Engineering Holdings	\N	Manufacturing	Engineering	\N	\N	5639 Lee Lane	N. Vancouver	BC	83290	Canada	\N	\N	925-555-3456	\N	\N	\N	www.bymillsengineeringholdings.com	\N	\N	\N	\N	5639 Lee Lane	N. Vancouver	BC	83290	Canada	0
ccda2c25-4079-1062-d2c6-438dfc514858	2005-11-30 19:24:11	2005-11-30 19:24:11	1	sally_id	1	Mills-Reed Electronics Associates	\N	Manufacturing	Electronics	\N	\N	5679 Atrice Lane	San Diego	CA	51567	USA	\N	\N	714-555-1521	\N	\N	\N	www.mills-reedelectronicsassociates.com	\N	\N	\N	\N	5679 Atrice Lane	San Diego	CA	51567	USA	0
310c5866-e450-bfc4-afcc-438dfc5e80b4	2005-11-30 19:24:12	2005-11-30 19:24:12	1	jaime_id	1	B & X Rybolt Electronics, Inc	\N	Manufacturing	Electronics	\N	\N	2602 Hale Dr	Burlingame	CA	79553	USA	\N	\N	369-555-7560	\N	\N	\N	www.bxryboltelectronics,inc.com	\N	\N	\N	\N	2602 Hale Dr	Burlingame	CA	79553	USA	0
61688ffe-959a-5488-a5b9-438dfc944381	2005-11-30 19:24:12	2005-11-30 19:24:12	1	kristen_id	1	Rybolt-Staton Communications, Inc	\N	Manufacturing	Communications	\N	\N	5552 Nob Hill Drive	Orizaba	Veracruz	41393	Mexico	\N	\N	420-555-7910	\N	\N	\N	www.rybolt-statoncommunications,inc.com	\N	\N	\N	\N	5552 Nob Hill Drive	Orizaba	Veracruz	41393	Mexico	0
916437d4-a690-4aea-354a-438dfca40de6	2005-11-30 19:24:12	2005-11-30 19:24:12	1	will_id	1	H & G Van Antwerp Machinery Corp	\N	Manufacturing	Machinery	\N	\N	4137 E St.	Colma	CA	62942	USA	\N	\N	408-555-3003	\N	\N	\N	www.hgvanantwerpmachinerycorp.com	\N	\N	\N	\N	4137 E St.	Colma	CA	62942	USA	0
c4c60cc4-e0e3-66ee-43ed-438dfc2a8f86	2005-11-30 19:24:12	2005-11-30 19:24:12	1	kristen_id	1	Van Antwerp-Springer Electronics Corp	\N	Supply	Electronics	\N	\N	7341 46th St.	Tacoma	WA	62542	USA	\N	\N	481-555-1981	\N	\N	\N	www.vanantwerp-springerelectronicscorp.com	\N	\N	\N	\N	7341 46th St.	Tacoma	WA	62542	USA	0
2968bc75-db89-7fcb-56f8-438dfcf65bda	2005-11-30 19:24:13	2005-11-30 19:24:13	1	kristen_id	1	X & V Thorne Communications Partners	\N	Consulting	Communications	\N	\N	8837 Paris Lane	Bellflower	CA	50253	USA	\N	\N	731-555-8360	\N	\N	\N	www.xvthornecommunicationspartners.com	\N	\N	\N	\N	8837 Paris Lane	Bellflower	CA	50253	USA	0
6e579ced-dff1-b00e-054c-438dfcb0a2bf	2005-11-30 19:24:13	2005-11-30 19:24:13	1	beth_id	1	Thorne-Surniak Construction Group	\N	Manufacturing	Construction	\N	\N	4951 Coralie Drive	Albany	OR	16014	USA	\N	\N	827-555-5967	\N	\N	\N	www.thorne-surniakconstructiongroup.com	\N	\N	\N	\N	4951 Coralie Drive	Albany	OR	16014	USA	0
f3fa2d58-c633-1382-097e-438dfce35be4	2005-11-30 19:24:13	2005-11-30 19:24:13	1	beth_id	1	W & A Short Construction Company	\N	Supply	Construction	\N	\N	6701 Valencia Place	Guadalajara	Jalisco	68886	Mexico	\N	\N	439-555-5631	\N	\N	\N	www.washortconstructioncompany.com	\N	\N	\N	\N	6701 Valencia Place	Guadalajara	Jalisco	68886	Mexico	0
30363e25-8393-14c0-d0de-438dfc6cd1fe	2005-11-30 19:24:14	2005-11-30 19:24:14	1	will_id	1	Short-Swesey Engineering Corp	\N	Manufacturing	Engineering	\N	\N	3069 Yolanda	Woodland Hills	CA	99808	USA	\N	\N	558-555-1867	\N	\N	\N	www.short-sweseyengineeringcorp.com	\N	\N	\N	\N	3069 Yolanda	Woodland Hills	CA	99808	USA	0
60a1fa34-84d7-e72b-2fbd-438dfc23de44	2005-11-30 19:24:14	2005-11-30 19:24:14	1	matt_id	1	G & T Carlson Engineering, Ltd	\N	Distribution	Engineering	\N	\N	7728 Condor Place	Ladner	BC	19843	Canada	\N	\N	193-555-9160	\N	\N	\N	www.gtcarlsonengineering,ltd.com	\N	\N	\N	\N	7728 Condor Place	Ladner	BC	19843	Canada	0
be2f892b-c4e9-bc8c-5209-438dfcf7aa79	2005-11-30 19:24:14	2005-11-30 19:24:14	1	kristen_id	1	Carlson-Margolis Machinery Company	\N	Distribution	Machinery	\N	\N	4351 Shenandoah Dr.	National City	CA	15313	USA	\N	\N	573-555-7681	\N	\N	\N	www.carlson-margolismachinerycompany.com	\N	\N	\N	\N	4351 Shenandoah Dr.	National City	CA	15313	USA	0
3be4c4aa-56e8-3702-fcfd-438dfc276ebc	2005-11-30 19:24:15	2005-11-30 19:24:15	1	chris_id	1	E & C Bowen Machinery Partners	\N	Supply	Machinery	\N	\N	9264 Slavio	Olympia	WA	99508	USA	\N	\N	231-555-4603	\N	\N	\N	www.ecbowenmachinerypartners.com	\N	\N	\N	\N	9264 Slavio	Olympia	WA	99508	USA	0
6e20cb65-1e32-a00f-8b24-438dfc59657c	2005-11-30 19:24:15	2005-11-30 19:24:15	1	sally_id	1	Bowen-Murphy Engineering Corp	\N	Consulting	Engineering	\N	\N	8796 Bayview Court	Woodburn	OR	36462	USA	\N	\N	635-555-1753	\N	\N	\N	www.bowen-murphyengineeringcorp.com	\N	\N	\N	\N	8796 Bayview Court	Woodburn	OR	36462	USA	0
b7bf4834-8d96-03b7-3bbe-438dfcae3cd2	2005-11-30 19:24:15	2005-11-30 19:24:15	1	sally_id	1	S & Y Miller Construction, Ltd	\N	Supply	Construction	\N	\N	6620 Leonard Ct.	Chula Vista	CA	86818	USA	\N	\N	666-555-3220	\N	\N	\N	www.symillerconstruction,ltd.com	\N	\N	\N	\N	6620 Leonard Ct.	Chula Vista	CA	86818	USA	0
e95db6e7-ddc6-81a1-45d6-438dfc91048c	2005-11-30 19:24:15	2005-11-30 19:24:15	1	matt_id	1	Miller-Abravaya Transportation Company	\N	Manufacturing	Transportation	\N	\N	6406 Pepperidge Way	Oregon City	OR	88933	USA	\N	\N	193-555-7998	\N	\N	\N	www.miller-abravayatransportationcompany.com	\N	\N	\N	\N	6406 Pepperidge Way	Oregon City	OR	88933	USA	0
51155650-c6fd-ca1e-6a67-438dfc197159	2005-11-30 19:24:16	2005-11-30 19:24:16	1	sally_id	1	V & B Hazlip Machinery, Ltd	\N	Consulting	Machinery	\N	\N	1828 Robinson Ave.	Albany	OR	79160	USA	\N	\N	135-555-5834	\N	\N	\N	www.vbhazlipmachinery,ltd.com	\N	\N	\N	\N	1828 Robinson Ave.	Albany	OR	79160	USA	0
c5bfba5d-771e-4caa-ef86-438dfc5b8d25	2005-11-30 19:24:16	2005-11-30 19:24:16	1	sally_id	1	Hazlip-Carter Electronics Corp	\N	Manufacturing	Electronics	\N	\N	4524 Ferndale Lane	Yakima	WA	47436	USA	\N	\N	824-555-3898	\N	\N	\N	www.hazlip-carterelectronicscorp.com	\N	\N	\N	\N	4524 Ferndale Lane	Yakima	WA	47436	USA	0
20100cbc-1024-71ea-4c44-438dfc40c76b	2005-11-30 19:24:17	2005-11-30 19:24:17	1	matt_id	1	X & V Slusher Construction, Ltd	\N	Consulting	Construction	\N	\N	2856 Amargosa Drive	Glendale	CA	30117	USA	\N	\N	789-555-9362	\N	\N	\N	www.xvslusherconstruction,ltd.com	\N	\N	\N	\N	2856 Amargosa Drive	Glendale	CA	30117	USA	0
884c44e1-66a1-d00a-3fb0-438dfca704ba	2005-11-30 19:24:17	2005-11-30 19:24:17	1	will_id	1	Slusher-Nzwonkwelle Electronics Company	\N	Consulting	Electronics	\N	\N	5806 Dutch Slough Rd	Victoria	BC	63555	Canada	\N	\N	839-555-9713	\N	\N	\N	www.slusher-nzwonkwelleelectronicscompany.com	\N	\N	\N	\N	5806 Dutch Slough Rd	Victoria	BC	63555	Canada	0
bb9a2963-700d-a74e-65e3-438dfccc85f8	2005-11-30 19:24:17	2005-11-30 19:24:17	1	sarah_id	1	X & C McCain Transportation, Ltd	\N	Distribution	Transportation	\N	\N	7047 Pacheco St	Burlingame	CA	85104	USA	\N	\N	828-555-4805	\N	\N	\N	www.xcmccaintransportation,ltd.com	\N	\N	\N	\N	7047 Pacheco St	Burlingame	CA	85104	USA	0
38fcbc18-f72b-fbe8-81bb-438dfc45196a	2005-11-30 19:24:18	2005-11-30 19:24:18	1	kristen_id	1	McCain-Daly Engineering Associates	\N	Distribution	Engineering	\N	\N	252 Meadowbrook Drive	W. Linn	OR	84703	USA	\N	\N	901-555-3784	\N	\N	\N	www.mccain-dalyengineeringassociates.com	\N	\N	\N	\N	252 Meadowbrook Drive	W. Linn	OR	84703	USA	0
6958a392-e1fd-f1b0-a66a-438dfc52fe10	2005-11-30 19:24:18	2005-11-30 19:24:18	1	chris_id	1	J & F LaTulippe Electronics Corp	\N	Consulting	Electronics	\N	\N	1747 Corte Segundo	W. Linn	OR	72415	USA	\N	\N	251-555-1162	\N	\N	\N	www.jflatulippeelectronicscorp.com	\N	\N	\N	\N	1747 Corte Segundo	W. Linn	OR	72415	USA	0
99f44c3f-87e7-9558-992e-438dfc055159	2005-11-30 19:24:18	2005-11-30 19:24:18	1	sarah_id	1	LaTulippe-Lewis Engineering Group	\N	Manufacturing	Engineering	\N	\N	5205 Sunview Terrace	Burbank	CA	38176	USA	\N	\N	347-555-7770	\N	\N	\N	www.latulippe-lewisengineeringgroup.com	\N	\N	\N	\N	5205 Sunview Terrace	Burbank	CA	38176	USA	0
30885088-ff80-58e7-e745-438dfcbcf297	2005-11-30 19:24:19	2005-11-30 19:24:19	1	max_id	1	Y & B Bomar Communications Partners	\N	Manufacturing	Communications	\N	\N	9610 Moccasin Ct	Spring Valley	CA	91048	USA	\N	\N	859-555-7434	\N	\N	\N	www.ybbomarcommunicationspartners.com	\N	\N	\N	\N	9610 Moccasin Ct	Spring Valley	CA	91048	USA	0
8cde5ad7-4cd2-4365-1771-438dfcf53c75	2005-11-30 19:24:19	2005-11-30 19:24:19	1	sarah_id	1	Bomar-Renfro Engineering Partners	\N	Distribution	Engineering	\N	\N	5979 Lynwood Drive	Renton	WA	95678	USA	\N	\N	444-555-8725	\N	\N	\N	www.bomar-renfroengineeringpartners.com	\N	\N	\N	\N	5979 Lynwood Drive	Renton	WA	95678	USA	0
c0a21503-5f76-f00e-48d9-438dfc082df1	2005-11-30 19:24:19	2005-11-30 19:24:19	1	sarah_id	1	L & O Wheeler Machinery Group	\N	Consulting	Machinery	\N	\N	9228 Via Del Sol	Imperial Beach	CA	14388	USA	\N	\N	978-555-7018	\N	\N	\N	www.lowheelermachinerygroup.com	\N	\N	\N	\N	9228 Via Del Sol	Imperial Beach	CA	14388	USA	0
299f8caa-246a-2d76-cc17-438dfce96996	2005-11-30 19:24:20	2005-11-30 19:24:20	1	sarah_id	1	Wheeler-Irvin Machinery Corp	\N	Supply	Machinery	\N	\N	8507 Mt. Palomar Pl.	Richmond	CA	84180	USA	\N	\N	459-555-5539	\N	\N	\N	www.wheeler-irvinmachinerycorp.com	\N	\N	\N	\N	8507 Mt. Palomar Pl.	Richmond	CA	84180	USA	0
5bac5a31-8b26-551c-115a-438dfc10fa26	2005-11-30 19:24:20	2005-11-30 19:24:20	1	beth_id	1	J & R Green Construction Group	\N	Distribution	Construction	\N	\N	3421 Gehringer Drive	Daly City	CA	69375	USA	\N	\N	117-555-2460	\N	\N	\N	www.jrgreenconstructiongroup.com	\N	\N	\N	\N	3421 Gehringer Drive	Daly City	CA	69375	USA	0
d3364601-0197-635a-5243-438dfc4ccd2b	2005-11-30 19:24:20	2005-11-30 19:24:20	1	sally_id	1	Green-Stanford Communications Associates	\N	Manufacturing	Communications	\N	\N	298 Sunnybrook Drive	Spring Valley	CA	32621	USA	\N	\N	520-555-8610	\N	\N	\N	www.green-stanfordcommunicationsassociates.com	\N	\N	\N	\N	298 Sunnybrook Drive	Spring Valley	CA	32621	USA	0
3c85e9b6-2a9c-6ac1-8654-438dfc6d6a4c	2005-11-30 19:24:21	2005-11-30 19:24:21	1	beth_id	1	I & O Ritchie Electronics Holdings	\N	Distribution	Electronics	\N	\N	8120 E Leland	Glendale	CA	56686	USA	\N	\N	440-555-7818	\N	\N	\N	www.ioritchieelectronicsholdings.com	\N	\N	\N	\N	8120 E Leland	Glendale	CA	56686	USA	0
\.


--
-- Data for Name: accounts_audit; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY accounts_audit (id, parent_id, date_created, created_by, field_name, data_type, before_value_string, after_value_string, before_value_text, after_value_text) FROM stdin;
\.


--
-- Data for Name: accounts_bugs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY accounts_bugs (id, account_id, bug_id, date_modified, deleted) FROM stdin;
\.


--
-- Data for Name: accounts_cases; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY accounts_cases (id, account_id, case_id, date_modified, deleted) FROM stdin;
\.


--
-- Data for Name: accounts_contacts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY accounts_contacts (id, contact_id, account_id, date_modified, deleted) FROM stdin;
bcc46e10-d7e9-d54a-b1e9-438dfbc4bafd	bb802563-dbfd-2639-c9fa-438dfb9199b8	a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:19:03	0
9d9606a9-1fc4-7d42-4e6e-438dfb950e23	8a210ac7-7523-9b8b-9faf-438dfb909a0c	e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:19:04	0
324e0c33-84d7-0609-a430-438dfb988a45	31136eba-e3e3-4b7d-3ee7-438dfb56849d	18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:19:04	0
5a6c8178-5f91-a152-8970-438dfb064ce0	593728c4-4173-b0bc-e23c-438dfb39cc6b	419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:19:04	0
81166bad-cb61-ae5b-81b2-438dfb139c59	7fd06dbb-9d41-5f4b-cb9e-438dfb066e1e	67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:19:04	0
a7d00f36-bf00-5c69-ad61-438dfbf1d770	a692eb2a-7fc3-554a-075e-438dfb3defbe	8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:19:04	0
cedeb064-367d-59b3-c112-438dfb292f76	cdabe509-e99f-10e6-b850-438dfb4e77ab	b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:19:04	0
c7a00076-0816-63c4-e4b6-438dfb4c40b9	f3bb465d-7373-1199-fa96-438dfbe70098	dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:19:05	0
262647ca-c0d3-d64c-0791-438dfbbc9ae8	24c17224-e34f-666a-932a-438dfb286732	e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:19:05	0
4f82c315-d7e7-aab4-43d5-438dfbccc7ea	4e46bc60-41f5-8793-ca11-438dfbd64e39	33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:19:05	0
7f302615-7ac7-7530-834b-438dfbb42516	7dfe3255-e3f2-9e59-541e-438dfb0d18ac	60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:19:05	0
a95486fc-a28f-3dee-4da5-438dfb530385	a6d648b2-0dd7-53e4-66b3-438dfb723a8e	8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:19:05	0
d1240ba7-7f7a-3f51-1462-438dfb4714be	cfee4945-1054-87f6-6095-438dfb82d731	b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:19:05	0
24c50e7d-2e98-8203-5fcd-438dfb47c5a0	11470142-1c2d-3484-7f80-438dfbf9e224	de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:19:06	0
2a966d8c-bbac-6ded-0043-438dfb082fc0	27e9e8b5-778c-2a97-170b-438dfb5bad1d	fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:19:06	0
53be3826-3622-e334-5ea0-438dfb5450b9	528b3285-5137-27d8-2239-438dfbcf86ca	382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:19:06	0
7a8bb56c-83c1-1524-6ab1-438dfb7617d6	79480537-6a23-807b-b5ce-438dfb7e0125	611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:19:06	0
a1837003-451e-d1bf-a131-438dfbaa80a3	a04eef15-2fc8-b045-118a-438dfbe190c3	87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:19:06	0
c8606997-ee9b-9b94-d55a-438dfb6df507	c7209bc9-cdf1-b2c0-04ad-438dfb7c971c	aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:19:06	0
f2add063-984a-4537-f513-438dfb31e90e	f17b0a36-dd67-e34a-8a26-438dfbda57ee	d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:19:06	0
27f6c014-0298-db7c-3470-438dfb75a34a	263e527e-1f82-b638-e106-438dfbf79c91	c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:19:07	0
52532d35-0ac2-f1ab-aa8c-438dfb59dac1	5117a2b0-5b05-93a4-94c8-438dfbdcbc82	3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:19:07	0
80d5b3a5-c5cf-7aba-67ca-438dfbdf81e8	7f9fefd7-0145-8f48-d5c6-438dfb2bbaaa	5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:19:07	0
ac139f3d-92e6-cc95-2c34-438dfb627c96	aadc4d2a-0ef2-3c65-f9e6-438dfbee0156	8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:19:07	0
d3680dde-9a93-abfa-4245-438dfbe25ec4	d2334399-c473-72ad-76d9-438dfbeabbbb	b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:19:07	0
54630b78-230d-176e-c475-438dfb9b2f4a	40d00a43-15bc-4b70-eab0-438dfbca436f	e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:19:08	0
2d08765e-5bdc-3f6d-e3d2-438dfbe07bda	2bd53b60-4e28-1041-8100-438dfbe53e5f	12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:19:08	0
5b5ebdc1-de75-14c6-d397-438dfb1c5ab4	5a16f961-a57e-941d-d844-438dfb7cd674	3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:19:08	0
8555b2be-2fe7-3ee9-e172-438dfb671ee0	841d9d0a-6f2b-d9f1-dc34-438dfbbae76a	68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:19:08	0
acff0470-8d47-6030-dd6d-438dfb38a92a	abcb8cfb-43c9-366c-c9b9-438dfb73e4fb	92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:19:08	0
d23e192f-dc1c-60ef-04f1-438dfb2b657b	d108fe2d-0635-8e6d-574e-438dfb6d7216	ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:19:08	0
87870893-f6a1-8ac3-9df8-438dfbd582fa	72fd0dd7-9020-07ef-1d6f-438dfb5c8d5b	df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:19:09	0
2e03a29d-d01b-6dfa-a3f6-438dfbc38ba1	2cc82984-4a85-76a0-43fe-438dfb2c8d15	15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:19:09	0
55928a58-1e2a-824f-9175-438dfb4fff71	545cb14d-527a-645f-0a1d-438dfb86862c	3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:19:09	0
8059e18e-86a0-fe81-0721-438dfb9120a8	7f113cac-cb20-909d-2bd0-438dfb985833	62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:19:09	0
ac659755-8689-8ff1-d4d8-438dfbd3dc30	ab2285a7-3eda-6915-0890-438dfbed0ec1	9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:19:09	0
d46e6732-0a8e-e789-371a-438dfb46ba81	d33b6eed-2503-1999-4f16-438dfbb86cdd	b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:19:09	0
928e07ed-a39b-a4b1-1970-438dfb04154f	7f380294-4d5a-2418-326a-438dfb97479e	e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:19:10	0
34e58380-5d23-3179-8b01-438dfb881691	339ff6ca-8783-9684-0457-438dfb07d717	19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:19:10	0
5c5ecc07-1541-6b9a-1588-438dfbf2e139	5b28b2bc-d4c4-7422-3742-438dfb9f0d53	44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:19:10	0
87f372ff-7ec9-fc59-c55a-438dfbc4dcce	86aff25f-1d29-195a-2da1-438dfbb2f27b	69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:19:10	0
b8371b91-c0d5-1e66-9f53-438dfba27235	b6f9c204-ce8b-02a7-f6c5-438dfb56b420	9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:19:10	0
e21f1859-01ab-69a4-adf7-438dfb12d7d5	e0e009ad-28b2-adb4-af1a-438dfb913008	c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:19:10	0
1afa1fd5-70ae-80e8-f28c-438dfb7a8d32	19bf50f3-ca1e-78ee-7776-438dfb6d64a3	24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:19:11	0
4cec690c-b00b-f0bd-4871-438dfb1088ee	4bad5d02-7445-fbca-999f-438dfbfbf5ac	28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:19:11	0
725b00f1-00fc-96ab-34c0-438dfb1b04e5	7119c042-2d7c-dc23-73a5-438dfb65becd	5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:19:11	0
97afc566-acf9-5c1e-b47b-438dfbc60f82	967ad106-7163-d1de-cf04-438dfbfde97e	7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:19:11	0
bcfc2199-439f-6b16-f4e7-438dfb399e35	bbc58875-cf6e-fc85-ce58-438dfb8d6e65	a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:19:11	0
e9bf4362-ae1f-a130-348c-438dfb8c4bda	e87e2072-12dc-87ca-0617-438dfbf93677	ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:19:11	0
225f3423-45b0-e87c-a82e-438dfbbf2d35	2120606a-0955-480b-e6d2-438dfbf02c42	301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:19:12	0
4decf75a-8ec0-df6a-a6fd-438dfbce3e09	4ca7b843-1a0c-c8bd-41e8-438dfbb96e5c	2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:19:12	0
73b654e8-421c-be11-78a0-438dfbc7829d	727bdc86-cc15-4887-fdb2-438dfb20aa21	5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:19:12	0
b58f7c45-6365-0868-c2ba-438dfb5ba6b5	b45957c0-0e7b-291e-5060-438dfb010d39	812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:19:12	0
df28163b-1cde-f92d-3266-438dfbc29050	ddf44cdd-dfa0-5804-4e7e-438dfb952497	c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:19:12	0
17be147a-22bf-0874-af36-438dfb467b8f	167e9a40-babb-5fcf-c7e0-438dfb37c1e5	ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:19:13	0
4d0cee57-4721-a2e3-64f5-438dfb526dc9	4bc6d3c1-0ba1-e888-e3dd-438dfbabe3bc	25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:19:13	0
7294b8c1-73a6-e91c-25e0-438dfb52953f	715a1c89-9563-a49c-0f74-438dfb5a299d	5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:19:13	0
97f3088d-41b4-79bb-f11d-438dfbf6446a	96b732db-0f25-0950-9b2a-438dfbdb2a24	7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:19:13	0
bd672e97-3998-e327-2019-438dfbacbf4a	bc254bfc-e799-a53e-be8c-438dfb96079c	a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:19:13	0
e33d9850-dff8-551f-97e7-438dfb3143f9	e1f907ff-1787-dd63-1859-438dfb648808	cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:19:13	0
14a58411-61f6-9603-d402-438dfbacc912	136de141-adcd-f7be-6797-438dfb2318c2	f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:19:14	0
3a803c64-637e-c1f5-6ebc-438dfba8ddc6	39451f50-83c1-64a8-7ff5-438dfb004619	221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:19:14	0
625e612d-9906-3be7-f406-438dfb971286	6125f6b6-47d4-c462-48a6-438dfb395c33	49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:19:14	0
87aa201f-bd65-db39-e11f-438dfbb26439	866fb183-32a3-55f7-5dc2-438dfb9d6362	6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:19:14	0
ad28e389-a93f-5833-a328-438dfbc3830c	abeb7043-fc40-2f0c-61b9-438dfbd2767e	953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:19:14	0
d487ebba-dd7b-b60a-7430-438dfb55500a	d349c763-90df-0b27-5d66-438dfb9513ae	baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:19:14	0
1268f26d-f7c3-ff1b-89a2-438dfb6db6f5	1136b8ac-1c42-0198-2f40-438dfb039aa7	eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:19:15	0
3a771b48-0e69-e3ed-798b-438dfbfb9a26	393d943f-cdbe-a0af-ffbc-438dfb4eb54e	1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:19:15	0
645ecb7d-4730-7d0f-693b-438dfb0698f8	63287cc0-1fd3-bfe3-b51a-438dfbfea241	4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:19:15	0
8aadad52-4bfd-a042-ceb3-438dfbfd49b1	89732904-ca5f-122d-243a-438dfb172253	71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:19:15	0
b008c118-5fa2-7399-0f85-438dfb623d58	aece530f-a91b-b630-76e5-438dfb297598	9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:19:15	0
d66d056a-9946-1272-a156-438dfbfb6707	d536a8dc-d8a9-3b88-7827-438dfb1c3a18	bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:19:15	0
8b140c87-c81b-0201-5107-438dfbe5f3dc	770a06b0-150e-497b-792f-438dfb2ff161	e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:19:16	0
31f4152d-cccb-c2c0-024a-438dfb3f2ac3	2f899226-e94a-e050-e252-438dfb4b3a5f	16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:19:16	0
59b958cd-4ab2-b8ef-ba39-438dfb3e5b2e	5865e81d-ecbf-6298-ed52-438dfbcedb7e	3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:19:16	0
804c1a2d-6b4c-f611-fd54-438dfba1b885	7f15ddfe-549f-620f-86f8-438dfb9d4720	672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:19:16	0
a71c75de-25e8-5dc3-d17c-438dfb39bbeb	a5e3e96c-95c7-7450-db68-438dfb54b406	8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:19:16	0
cc7ca02f-f288-203e-60bd-438dfbcddc20	cb3f0df6-d3b0-b003-9454-438dfb5e01d2	b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:19:16	0
3c2a048d-8340-4713-f3be-438dfbebcb10	27940605-6e82-fbe4-5532-438dfbf29045	da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:19:17	0
2b02d865-0df8-846a-2d3c-438dfb48414a	29a01cb7-7a4e-4edd-e402-438dfb4ca729	115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:19:17	0
55d5f0d3-5fbc-f5c2-d435-438dfbbd7869	54919bc9-5eb4-1211-79ce-438dfb77bcf5	389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:19:17	0
7bd40531-c034-38f1-5169-438dfbd5d057	7a98c258-e4e1-0520-d532-438dfb94e823	63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:19:17	0
a4c55156-02e9-1989-ffbd-438dfbbbbf19	a385df8d-6c2d-7325-f66f-438dfb3c415a	8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:19:17	0
cbeefa00-14a5-8ff0-b52e-438dfbc251bb	caafd3ec-ffe6-dfd3-3eb7-438dfb39be07	b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:19:17	0
f377dc70-a78c-36f5-90a1-438dfb3ac503	f23304bf-4215-df4f-fb8a-438dfba9f91e	d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:19:18	0
26cdcb85-db79-5ffb-a761-438dfb74f5c2	258a5f07-360a-c8cd-11cf-438dfbca3689	cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:19:18	0
54beb679-cada-c4ec-dfea-438dfbfe2c0e	537446e4-5d04-ab85-2893-438dfb18bd39	34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:19:18	0
7e78bacd-4c55-04ff-2d5f-438dfb4b8639	790410a3-d5bf-e225-36f4-438dfb428365	6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:19:18	0
a638b36a-79e7-ca34-ac9b-438dfb3b8702	a4fc684e-0745-5d43-5b95-438dfb537c7e	8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:19:18	0
d006f9b3-6c6a-53b8-5ef4-438dfb6ec445	ceced487-1e05-7d48-1c43-438dfb3c95b3	b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:19:18	0
3c850bd2-55c3-be29-555f-438dfb6c0a87	283a0cfb-8d13-3443-aa4b-438dfbd40bbd	dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:19:19	0
2bd2d962-6ffb-548c-6b1b-438dfbddfbba	2a76b7db-d29e-fc19-3e66-438dfb1a9ce7	114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:19:19	0
55cdebed-412f-2988-5fed-438dfb5a8dce	5499f38d-2452-480f-6a82-438dfb4339a5	3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:19:19	0
82e2bed1-899c-1f49-54a2-438dfb1e130a	819ebf07-9068-2265-3739-438dfb26ddf0	63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:19:19	0
aacd3e10-ab11-ef65-621c-438dfb09fcbb	a993780c-29e0-14c5-6c37-438dfbb7f3f3	9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:19:19	0
d2eddc01-79be-6942-725d-438dfbe24e05	d1b4f9da-9474-2dd4-dfac-438dfb1cf765	b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:19:19	0
4a40097b-f549-13bf-f545-438dfbb315c8	35c50219-a425-8f43-7566-438dfb064e4e	e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:19:20	0
2fc065a1-ccbf-49ab-6273-438dfbcc4694	2e865eed-39a2-3987-e5a5-438dfbf2b70a	12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:19:20	0
5769543c-d74d-9722-6beb-438dfbfbbbbe	562d1f1b-5752-11b7-9725-438dfbbdf622	3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:19:20	0
857d4c4c-4c36-2d76-bbad-438dfb204ccd	8443046f-b16a-c222-cc34-438dfb8fb06a	64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:19:20	0
b0d7c3b3-ce5c-4f5d-79ac-438dfbf6b7bd	af9c21d4-befe-7b2a-7274-438dfbf8cd23	92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:19:20	0
d951a950-9af3-1be9-002b-438dfbe57081	d8170029-51c7-b9cb-235c-438dfb16119b	be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:19:20	0
10dc5c87-a273-0375-28dd-438dfb3ece62	f9fe06d7-6202-eff3-9f14-438dfb23e331	e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:19:21	0
39a07596-243e-2d50-908a-438dfbf42d3b	3868028a-ef4e-3ada-3656-438dfb00b42a	1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:19:21	0
67bc22ea-fcda-1a5f-ffe9-438dfbb7b94e	6680952f-19e8-4e10-c31f-438dfb881bbd	491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:19:21	0
8dfee87d-b01d-f54b-d6a9-438dfbecaf14	8cc0df97-5709-0de6-ab07-438dfb74e0a8	75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:19:21	0
bad6f60d-de49-0a03-efa2-438dfb249cca	b996df6d-c8b8-f88b-023b-438dfb45858f	9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:19:21	0
ebc9bfc4-4251-858b-fc58-438dfbe903a8	ea824454-efb2-4aa6-e266-438dfb61a3d5	c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:19:21	0
2576006d-16fd-2a01-38b0-438dfb093301	2439132d-ba73-53f7-fba3-438dfb23a83a	59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:19:22	0
4dcad69a-bc55-64bc-a433-438dfb44dae2	4c93e3f6-28e3-2838-eeab-438dfb5e2821	3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:19:22	0
7edd5895-da98-7ade-f9e0-438dfb01e121	7d9ae852-f52b-1b75-9770-438dfbf00f09	5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:19:22	0
abd829f0-9dce-4171-fe27-438dfb553a5e	aa9b82c4-08a3-6f6d-c188-438dfb094e89	8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:19:22	0
d158c5c6-f256-a590-85d5-438dfb763b92	d01be770-137d-17c8-638f-438dfb46290d	b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:19:22	0
6d7c0a26-d25b-0e76-fc6a-438dfb597f49	59a502e3-2284-31a8-19ed-438dfb279276	df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:19:23	0
3847971d-d444-bbc5-1fbc-438dfbfc0262	37013eaa-abec-2a6c-5a24-438dfb08bf58	145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:19:23	0
67fd8c53-b495-0c57-43ea-438dfb5d6157	66ba4a7c-c25a-1980-fa88-438dfbab3062	47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:19:23	0
957d29c0-3754-3686-4825-438dfb945ee7	9441d611-d85e-30f2-681b-438dfb92a448	756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:19:23	0
c33ad68e-d2fb-622e-f71e-438dfbef0fc4	c1ee8e98-ab9e-ed88-8805-438dfbf902fc	a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:19:23	0
ecc68d52-3b05-f8b9-3519-438dfb81c1e4	eb8eb435-7a45-006f-1e55-438dfbd3ab4c	d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:19:23	0
1e1f7dae-69a2-cfbb-c10a-438dfba55ae0	1cda71ed-f945-6d54-8521-438dfb8d3a30	61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:19:24	0
45b415f0-81e2-f89c-d538-438dfbb8846e	427c41d3-cdce-dabf-ac7d-438dfb5750ba	2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:19:24	0
788f9d49-f59b-68aa-7c31-438dfb7dfbae	77566d1b-0ec6-1ca5-6f04-438dfb102ed6	5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:19:24	0
9dfa7402-d4c8-d121-9b26-438dfb275a60	9cbb9c04-c760-bcdd-5da9-438dfbf6c5dd	860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:19:24	0
c7cd376a-3a60-9c45-f951-438dfb9603e2	c6960b1c-72f0-fcf7-d688-438dfbe5a54f	ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:19:24	0
ed2049ab-a5b1-dcff-334e-438dfb93c9a3	ebe6e0fc-13c7-17fa-d77c-438dfb78437e	d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:19:24	0
1ed939c3-b7ef-4c75-aa74-438dfbcb7009	1d80898a-13ea-e09d-0b6d-438dfb309291	683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:19:25	0
4b05ee03-aa35-a78b-be49-438dfb3c065d	49c61ee7-e45d-58cd-9208-438dfb5baaec	2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:19:25	0
70dcc157-4463-3d89-b5a3-438dfb4547ec	6fa0db29-6446-b169-acb0-438dfbe72f12	589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:19:25	0
96462aa0-7662-66dd-dea6-438dfbaa6630	950f70ad-2c1b-f21f-5d9d-438dfb367669	7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:19:25	0
c5aa498a-4cf0-faed-ce60-438dfb6ddf79	ba84e8f6-5b81-1190-256d-438dfb8113ee	a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:19:25	0
f0472471-79e2-ec14-5b12-438dfbb1d330	ef0cd81b-ba24-743a-cc7b-438dfbb90482	d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:19:25	0
3108ad6b-0d02-5639-d201-438dfb5eb06b	2fbede29-f88d-0084-733c-438dfbc5e779	99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:19:26	0
5dfb9f5c-eda6-8dde-37a3-438dfb5a33c5	5cbf8d1f-4b07-3656-5c3c-438dfb057c9e	3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:19:26	0
8ddc0942-3b23-e7a8-1de1-438dfb53527c	8c95d8fc-6990-8abc-b3bc-438dfbdcdaa9	6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:19:26	0
bde9b3b3-4cba-17f5-7d27-438dfbe9379d	bc9fc81c-5702-c80c-2442-438dfb88891f	9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:19:26	0
49f60714-6200-f8af-30bd-438dfbeb1495	3592041a-0719-5e56-2ed2-438dfbc17944	cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:19:27	0
352740c7-2b4f-5094-73d0-438dfbbd0cc5	33e61fde-9201-5509-588e-438dfb4640a6	1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:19:27	0
5ccef672-86a4-3c9b-8a0b-438dfbfe6216	5b8a2402-a0c8-4603-9196-438dfbce88c9	42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:19:27	0
937539a1-1317-45b2-a2a2-438dfb55b42d	8c7dfaf8-f0a5-b2b4-6a97-438dfbff9a61	6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:19:27	0
b8f36ea4-85e1-3ab8-88d4-438dfb629b9e	b7bd6c9a-9d1b-1d13-5e34-438dfbb2a501	a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:19:27	0
e440d945-63eb-a01c-1a1b-438dfb7573e1	e2ff38cd-d2fb-a192-2252-438dfba48023	c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:19:27	0
1b77fdc8-0b42-40c2-e00b-438dfb19fcec	1a3d193b-8586-6cae-5ee5-438dfbcace66	f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:19:28	0
4162b82d-6fa2-3e7c-a63d-438dfb8fdd97	4028b56e-9e0e-755a-cb68-438dfbc44138	28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:19:28	0
75063ce6-47f7-5214-53ae-438dfb466627	73c2b29a-61da-9fad-6c88-438dfb3347e7	51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:19:28	0
a087f0c0-59f0-323b-e4f4-438dfbeb11e1	9f4c127d-9fb8-41b2-a428-438dfb262585	827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:19:28	0
cc13e2eb-4632-d433-167b-438dfb5a93ae	cad3aec5-15c0-f51d-37ed-438dfbd8e36b	ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:19:28	0
96cd02d2-d6c2-8196-071d-438dfb4d144b	82de0e50-aded-2288-2380-438dfbe71fa6	d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:19:29	0
3b57995d-c4ba-4870-9397-438dfb887711	3a0ed43e-b12e-8d5e-e7b3-438dfb06a6cf	16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:19:29	0
62f42d0c-1f2d-45cd-9406-438dfbc075bf	61b3ca44-234d-0362-46fc-438dfb3875ff	4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:19:29	0
8ed1dae6-2e4d-189a-5b55-438dfb1a2e00	8d866ec7-767d-d182-e7c4-438dfbdab705	709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:19:29	0
baa03a35-ee27-095c-74c8-438dfbb23b09	b960d4f5-54fc-3cd3-e40a-438dfb10ed57	9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:19:29	0
f356449d-be43-62e6-466e-438dfbc7937a	f219dbc4-a9b7-9203-a3ff-438dfb4e3c78	c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:19:29	0
2496bbf0-53e7-9681-6da7-438dfbcad85e	235e35cd-72a0-46ef-1100-438dfb94854b	cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:19:30	0
52c5f097-5aac-46e0-7a7c-438dfb07b82b	518aec41-ced5-fed4-5c17-438dfb8e4034	322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:19:30	0
784c3174-31ee-c5cb-3a59-438dfb97a868	77120e6c-ce95-4c79-d5e0-438dfba2a1aa	6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:19:30	0
a54588f5-a2d4-3dfe-f4e8-438dfbc24c3e	a40d393e-7d45-49d2-a417-438dfbf6afb3	85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:19:30	0
cab58526-3e5d-261e-e13b-438dfbdcd83a	c9756760-9f79-5ae9-7c4b-438dfb9971ef	b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:19:30	0
1184431b-bb54-aaca-94e2-438dfb6dfece	1039724e-858e-a7f4-2da6-438dfb589c61	d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:19:31	0
375dd0af-ef20-e330-b132-438dfbed7dfa	361f5e6f-269e-aa43-af97-438dfbb387ec	1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:19:31	0
75a74a0f-cfc1-c5d0-28b0-438dfb3a779c	746f64b0-e0c9-fd20-8391-438dfbb1302a	54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:19:31	0
a2440421-b1f3-050a-7038-438dfb7d79f1	a101f279-8f8e-b452-d0e7-438dfbe2ac2c	8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:19:31	0
c7d2324a-fa82-ed82-c6be-438dfbea1719	c68a5e6e-06dc-b478-79b3-438dfbb22351	afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:19:31	0
eeeb0b36-f85b-6be8-2dc1-438dfb417ee3	dac00f21-34af-8b1c-9d49-438dfb707d61	d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:19:32	0
43240998-bec1-f70c-25ae-438dfb01d914	41ea173b-5026-f9c2-44fe-438dfb5b519d	1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:19:32	0
6adb69df-1754-5a75-e84c-438dfb00d8f1	69a15b9c-ba1f-0b56-c4e3-438dfb1ed3b1	52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:19:32	0
9f952bdc-593d-3932-e33b-438dfb67226c	9e5ad4da-bebd-4fc7-757e-438dfba96019	78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:19:32	0
ccb19150-8f84-fce9-bcbf-438dfb594c02	cb739056-d549-a52c-9cfb-438dfb72d3f8	ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:19:32	0
f40adf0f-1f23-f6ee-c6c3-438dfbd02e85	f2c006f7-68c3-8518-11ae-438dfb9f603b	db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:19:33	0
365c0d5c-0276-689a-690c-438dfb159888	3513db0c-633e-ba0e-dfb9-438dfbfc7f63	e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:19:33	0
66730293-8e09-0d79-2347-438dfb248e82	6526f511-453f-b131-636e-438dfbbf2392	44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:19:33	0
93c64e3e-e6c9-ffec-134e-438dfb2652d4	928a2d9b-80a1-0ac6-a738-438dfb58f8c8	73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:19:33	0
c8dd3f74-a2d4-9ed2-4259-438dfbbc1fa9	c792c6c4-f0e2-c128-bd46-438dfbbf844a	a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:19:33	0
ee430067-3055-aa31-0720-438dfb3d1b02	ed0bb8d6-0a70-299b-bd61-438dfb09b0d5	d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:19:33	0
1fca07ca-e848-fbdd-5d1d-438dfb966b84	1e86a0f2-7f05-0edc-1e13-438dfb97c09b	7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:19:34	0
4f62b692-0a50-e7eb-626e-438dfb4066b2	4e29c3a9-cf5c-7614-6017-438dfb169fd4	356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:19:34	0
75675ce2-5665-4a91-07bb-438dfb507086	73ee799c-af53-d544-475e-438dfba140eb	5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:19:34	0
b3686bcf-f930-c3bd-7024-438dfbe4bfa3	b224ca6b-0196-ec35-5827-438dfb0772ea	82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:19:34	0
5e5303ee-f248-5884-a870-438dfbf156de	e868b404-9ea4-2b87-f816-438dfb8e35f1	c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:19:35	0
44779d3a-e48b-d9ec-f04b-438dfb80bdc4	433a0b75-adf7-5918-651b-438dfb0f7716	137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:19:35	0
6ca405b0-1c10-7a78-26f0-438dfb7b5961	6b69184c-d652-c3ab-2dd9-438dfbec4dc2	548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:19:35	0
9aa25b5f-f2e6-1817-2dc6-438dfbb89394	99640829-2013-718d-3c44-438dfb32f479	7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:19:35	0
c012d12d-62a5-e915-792b-438dfb45cb12	bed444fa-684a-534d-65e9-438dfb258cab	a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:19:35	0
2890038a-db63-76e8-1d64-438dfb09f2cc	143f0702-7b65-68f0-0723-438dfb45c00f	cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:19:36	0
39529b0b-ac9b-03db-60aa-438dfbb7fcc6	3815a954-8743-e120-33b0-438dfb05770f	ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:19:36	0
612629c3-f811-6c5e-a9fc-438dfb783083	5fed8b57-62a4-c15c-b118-438dfb281982	48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:19:36	0
86e2d37b-6193-6006-8610-438dfb78a869	85a60f7d-9587-1656-3b83-438dfb598875	6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:19:36	0
ad5f521a-c509-b519-4f11-438dfbc8aca0	ac1f04db-a85a-fb68-4025-438dfb51a395	9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:19:36	0
d37071bb-15e4-e180-e34d-438dfb4b3611	d2352fd3-ffeb-9558-65d1-438dfbc1f861	bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:19:36	0
52fe0bb1-99ff-341f-9b9d-438dfb92921d	3eec0406-5202-44bb-4e4c-438dfbaa2a8d	e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:19:37	0
2b4eb5ba-3aa1-8e88-5cb3-438dfba3541e	2a0ccd11-a8be-92e6-cee6-438dfb21b54a	12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:19:37	0
52e174cc-9a9c-9b54-8840-438dfbedc0e9	51aac716-2b45-762a-6fc7-438dfb839e11	38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:19:37	0
78dea0e5-431b-2236-0b5a-438dfbb97288	776599c7-a174-a3c2-ffe6-438dfb253633	60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:19:37	0
9febbbcd-daae-bae3-a1b8-438dfb89cea1	9eafaeb4-1820-798f-787b-438dfbecb32e	86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:19:37	0
c56f3865-8f15-6e93-4309-438dfb824e74	c434f91a-d271-3174-6cdc-438dfbdffd48	ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:19:37	0
ed80c3b8-27a9-7cf9-99e9-438dfb724f88	ec457caf-9418-32ba-7ce7-438dfb584e8b	d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:19:37	0
228d6764-9df7-69e8-7209-438dfbfc1b64	2145cd2c-cc9e-fe19-631d-438dfb576a32	6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:19:38	0
4a206950-55bf-5753-28a6-438dfbd16f7f	46e8c833-0042-a7b0-9c36-438dfb2081eb	30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:19:38	0
71dc6848-0aa7-4405-e8aa-438dfba5cb26	70980b53-67b8-f172-7449-438dfb415b17	57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:19:38	0
97582890-1ca4-8e78-4286-438dfbcf301b	961f0b7a-2020-7514-26b3-438dfb2f0d79	7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:19:38	0
bf243cea-8f1f-335d-3920-438dfb144cc3	bded0db1-6418-1126-bae1-438dfba93d2b	a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:19:38	0
e5caf1ff-eb86-568f-815d-438dfb7d5e8d	e48fabf1-5cae-b35d-27b0-438dfbb82d13	cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:19:38	0
17361047-5278-277f-97ac-438dfb05b73a	15fb9c0e-95cc-f8c9-6bfd-438dfb22d26e	f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:19:39	0
3f7b9b34-8da3-f9b9-524c-438dfba8b8cc	3e3e2d11-08cc-2355-8f5b-438dfbc773d6	27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:19:39	0
6a0e62d8-04a3-6cd5-3db6-438dfb3a4a38	68ca340f-ab88-eb87-d292-438dfb84f9d7	4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:19:39	0
918c2719-f200-5e0b-816e-438dfbbc71d0	904c62b8-4554-279e-9f9e-438dfb66dba1	778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:19:39	0
b95347a0-5eeb-fb13-51f2-438dfbe2df6f	b81981da-4714-600d-6002-438dfb1dfc49	9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:19:39	0
deb5652c-83fc-ed1a-d694-438dfbac4a26	dd7965df-b162-bdb6-7780-438dfbf1c4de	c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:19:39	0
11adb148-b370-0060-c167-438dfb456b8b	107116e8-0f2f-ec75-10aa-438dfb5eaf13	ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:19:40	0
3957742b-f2f8-c8b6-a05d-438dfbda425c	381bfa07-f82d-703f-d6a5-438dfb23a580	1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:19:40	0
645b4ebc-9981-3293-7c45-438dfb2de39a	61436bda-7784-8a98-fee4-438dfb3a7de0	46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:19:40	0
8abbcbc7-6335-46ec-eaf6-438dfb89c020	894e7203-3f6a-59f4-a48d-438dfb6ff374	71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:19:40	0
b60f8494-5471-180c-86f9-438dfb77324b	b4c69598-acef-0376-cf3c-438dfba3d6b8	98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:19:40	0
dbabf3c7-cf2c-c28c-8548-438dfb9eab9d	da64618a-6cae-9cd3-2878-438dfbaee8c2	c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:19:40	0
f44c0529-6233-053d-aea6-438dfb892a53	e0950eb8-d447-9c9d-ca04-438dfb3cb0dd	e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:19:41	0
3b43a33b-055a-71a4-dae8-438dfbf9d56e	3a07392d-4625-bf03-f6b0-438dfb244959	1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:19:41	0
62de0645-1cad-a18c-109a-438dfbe57851	61a2af81-ceac-22ca-b531-438dfb3c4b4c	4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:19:41	0
888cc10a-0d76-ccaa-25e7-438dfb0ec936	874aad29-6ec5-bdf7-41f8-438dfb9dc259	705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:19:41	0
b06c7731-0a37-0a81-9804-438dfb14f559	af25a1e3-5fe7-c912-63f2-438dfbe333a7	96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:19:41	0
daac93a2-ef1c-233c-a880-438dfb6b6d9e	d9730e7b-9d2d-3766-6acb-438dfb438131	bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:19:41	0
ea3f03be-efb0-0e01-94b1-438dfbc68b66	d5ec06b7-1260-225f-9f9d-438dfb7dbc5c	e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:19:42	0
395fd485-80f1-9c97-ccd0-438dfbaec9f9	3824122a-7f5a-420f-0279-438dfbd51aac	2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:19:42	0
6385c217-c505-41f6-1dd4-438dfbb4c1c1	624dde65-1436-3cd7-3c5b-438dfb36bb74	46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:19:42	0
897305bd-9cd3-986b-9664-438dfbfd3397	883417ab-65a4-1cc0-1b9f-438dfb6fbed3	70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:19:42	0
b1da6af5-0710-ab5d-f3dc-438dfbe40cd8	b09fed6d-6360-8fe0-0682-438dfbb64579	970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:19:42	0
dfc4109c-050c-7287-07c0-438dfb6a4cde	de86e4f6-d95c-37a9-98fc-438dfb0413d0	bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:19:42	0
115dde51-8777-ad54-4b34-438dfb376bb5	101d7eb7-52f6-2373-211a-438dfb8c134c	ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:19:43	0
3fed9ef9-c69e-aa15-b08f-438dfb0318f5	3ea5b45b-9d69-5220-069c-438dfb06916b	1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:19:43	0
675fd240-fcf4-1c7d-b5c2-438dfb7cd477	66188334-3548-544f-dbef-438dfbf03803	4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:19:43	0
902a361c-e969-f9e7-4b86-438dfbf16d81	8eebe63b-1a8f-dde0-fd22-438dfbdb063d	74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:19:43	0
b5977008-d11c-2d97-0302-438dfb439531	b4581850-679b-264c-177b-438dfba8b31f	9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:19:43	0
de6169d5-1019-f185-98cb-438dfb67833c	dd237fbb-dafd-7a1b-8b45-438dfbb96c9e	c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:19:43	0
1118490a-7806-a3f0-c379-438dfb349031	fd7d03bc-1a2b-e9c0-18fd-438dfb9f8af3	ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:19:44	0
3ee63d46-c033-454e-cd8a-438dfbe89fb2	3d9f1380-7c58-e597-2b2a-438dfbc62e2d	1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:19:44	0
6e78f9bc-09f5-21a4-e318-438dfb03d552	6d36c3d5-d9d7-e707-2f79-438dfb6990c1	4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:19:44	0
94345b0b-cbac-3a51-1ed9-438dfb44ba34	92f2b33d-32e0-b2fd-f252-438dfb36b86b	7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:19:44	0
b9b07206-3668-cb31-bb7f-438dfbdcedc2	b8673793-9dd1-aeb3-bb8c-438dfb10c5c8	a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:19:44	0
e2b08d62-3a67-826a-4417-438dfba77be2	e175255e-59e2-b3fb-7f4d-438dfb9bbedc	c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:19:44	0
17eed297-9fb0-77c9-cac0-438dfb59f0da	16b0233a-0619-426b-f513-438dfbb67b5d	f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:19:45	0
4161afda-1e42-beb7-23aa-438dfb7b718d	4021f92a-ea68-e799-c145-438dfb8bfb4d	2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:19:45	0
690223ca-25cf-616e-c6f2-438dfb36d127	67baa0d0-87d3-417b-4df4-438dfb89ba88	50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:19:45	0
959a5fde-3487-5d0f-0ebe-438dfbeefbac	9409ad1e-0280-2f21-e383-438dfb3e7633	76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:19:45	0
d08c98e7-a92c-3f81-f407-438dfb8a2dd4	cee7b966-2480-8d9c-eafc-438dfba89472	a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:19:45	0
c8e50f93-5a8a-d0d2-bc24-438dfbf9ab6e	af480f28-f9c1-d8f7-012b-438dfbf8f37a	e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:19:46	0
3cddabd3-08ab-f29f-f329-438dfb5e0df7	3b4761fe-3f0d-1481-d903-438dfbd585fa	1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:19:46	0
7abf18c1-f5c7-b2d4-768c-438dfb4efdac	792b092a-09e4-545b-cebf-438dfb843a11	50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:19:46	0
bc1a346c-ab64-9f84-f570-438dfbb374da	ba8287c2-cb83-aeba-508b-438dfbdce549	8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:19:46	0
38920eed-a3b8-fd54-902b-438dfbacf8df	1f3c0e58-4d97-95b5-39e1-438dfbfba571	cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:19:47	0
33cdef79-562d-5e53-fe3e-438dfbd37e44	3233fb6b-85a6-203b-9bc8-438dfb576554	14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:19:47	0
6725594d-5afd-7164-61c3-438dfb92d8dd	658350ed-52b1-4348-2909-438dfb71dff2	45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:19:47	0
97f481ba-fac5-6847-f549-438dfb5ed491	965c6a46-a880-ec46-58d0-438dfb69fa47	789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:19:47	0
c7f0a626-f82b-0509-95f9-438dfb509ba9	c65aded3-c296-a1a1-3e36-438dfb7c317d	a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:19:47	0
16aeae0b-94c6-252d-98f5-438dfb5caaae	1506cde5-fc12-26fa-0ac1-438dfbe00db9	d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:19:48	0
473b5745-02b4-7ce8-c68d-438dfbb39673	45952a1a-db7a-a5d5-652c-438dfb93cba6	282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:19:48	0
805610ca-16ae-def3-f589-438dfb1087fc	7ec3346c-278b-2910-5af2-438dfbc82a14	5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:19:48	0
b08fbd0b-45cf-b0dc-9beb-438dfb91f6bd	aef8c633-a8ac-e5f5-5bc1-438dfbfe723b	91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:19:48	0
e078e0bb-edc2-1c6c-55b6-438dfbb86500	dee2e0ef-0dea-badf-e6f5-438dfbd65277	c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:19:48	0
29cf3108-c1b1-0b1b-3e5f-438dfb29fe74	28392168-eded-4714-1cd9-438dfb84eb47	f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:19:49	0
5c95f6ab-9f96-cb22-94c1-438dfb78e142	5af7a2dd-ddd4-6e6c-6b6d-438dfb64839b	3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:19:49	0
9b05a0a3-f6b4-4f74-b610-438dfba82166	99380eaf-4801-adb5-5864-438dfb1a8485	6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:19:49	0
dfe638ef-737e-994d-4860-438dfbf3b926	d7638159-25a8-703e-5d6d-438dfb5312da	ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:19:49	0
2a43475c-08a5-0df1-341a-438dfbdb7ca8	28a0e705-de7f-aacd-086a-438dfb12fd38	f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:19:50	0
5d754339-a985-8877-446b-438dfb026e4b	5bb7382e-5165-c29d-00de-438dfbf7257d	3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:19:50	0
94df5493-bc69-1c50-1890-438dfbdffa0f	934b5b38-f799-5e29-7661-438dfb9c93a5	6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:19:50	0
cc1fd2c1-13a0-d151-3817-438dfb5d65b4	ca7e2eb3-c15f-2bfd-6061-438dfba5aba2	a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:19:50	0
f7c804bf-0d65-bec1-4978-438dfb0abd78	dd3109db-391f-34f1-5456-438dfb6ab9fd	dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:19:51	0
41098c9f-96c0-a46c-6cd7-438dfb2b9e06	3f601166-0fad-603d-1fa8-438dfbe38bd9	2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:19:51	0
7b370ebc-7809-3f7c-5093-438dfb051fb8	799e1386-522c-cf3d-4976-438dfb9241ef	54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:19:51	0
b2e466d4-97c8-b860-ae6d-438dfb624df8	b14a7f13-a6ea-090f-939a-438dfbd41a48	8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:19:51	0
f219352f-63a1-d6fb-e12c-438dfb100112	f08902b3-d9e0-883d-4c70-438dfb751521	c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:19:51	0
3ddb3cfa-dad3-6eb1-1f25-438dfb78284a	3c2e6c6e-67e7-1f93-c86f-438dfb2b6f95	f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:19:52	0
78a26457-3a85-88d3-e498-438dfb34aaeb	7702800a-816a-e10b-1263-438dfb7ef286	51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:19:52	0
b17c873b-01d3-07e3-dd66-438dfb1f1786	afe66e53-426d-6ab8-7079-438dfb2b8fac	89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:19:52	0
e190b2cd-ae2d-5390-b2f7-438dfb5a7e62	dffc361e-4437-407c-1a2d-438dfb014ae4	c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:19:52	0
26118457-2d1a-fe3a-cf33-438dfb76a285	2478194e-40ab-dffa-1fe0-438dfbb13f16	f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:19:53	0
696b4c87-3c31-c9d8-1f5a-438dfb1e6c48	67d44395-4b5b-d818-a580-438dfb90d815	376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:19:53	0
99c428d0-dc6b-484b-74c0-438dfbaf76ad	9817d918-b558-4416-e067-438dfbb00ac3	7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:19:53	0
ca21b3c6-2e59-e04f-2bab-438dfbfb7be4	c88cf6ff-bf68-754e-c5f7-438dfbffc4d3	ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:19:53	0
e8a80f00-e158-1a1c-fb08-438dfb58fab3	ce360ab5-b009-af3d-7ddf-438dfb56eeee	db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:19:54	0
5af996f9-9096-90f2-4474-438dfbd0c50c	59581ac2-2c43-32c5-8c08-438dfbb53a75	1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:19:54	0
8b608b6b-0888-2fcf-29d5-438dfbd06f3c	89bc281c-5b88-0a21-8bdc-438dfbbe1baa	6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:19:54	0
c774155f-30ce-d296-a5bb-438dfbe172fc	c5dd824e-a607-5691-b542-438dfbafdcae	9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:19:54	0
e1ea065d-1abd-0669-7e2b-438dfbec0a73	c87b0e59-5044-8cf7-d5d8-438dfbc9a6ae	dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:19:55	0
3e6e65ab-6043-b4a1-1d03-438dfb40adc3	3cdb06a0-9ad1-cea7-1959-438dfba473f6	1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:19:55	0
7b57225c-a00d-7e5e-ab98-438dfbb65b0f	7952f556-ed16-4c84-6b90-438dfb87944f	525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:19:55	0
acbe1ec1-ac99-7400-eca4-438dfbd1c29c	ab24c645-c052-67a0-62df-438dfbe6603a	8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:19:55	0
de09385c-1e7f-1b6b-4912-438dfb3459a3	dc63f764-1068-2c60-4430-438dfb1bf2c6	be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:19:55	0
36f47d3a-08f9-28a1-1654-438dfb244ec6	35557da2-371b-0464-603a-438dfb80dec5	efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:19:56	0
8731545d-179d-1b8b-dd82-438dfbdcb3b8	859225e9-1fd7-ef47-acab-438dfbfb3645	491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:19:56	0
b87ca7c0-1e60-4641-05cb-438dfbadc048	b6e1902d-d5f5-ae68-cc0a-438dfb5405b9	98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:19:56	0
e89f00e7-11d5-feb9-92ca-438dfb7c380b	e7068a6a-051f-dae4-9012-438dfbe22d8f	c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:19:56	0
37dc9487-da58-98d3-5610-438dfb176d38	3647b747-73b1-83c3-409a-438dfb867bce	5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:19:57	0
748922d6-1bfc-69f7-7667-438dfb657d3f	72f54a65-c53d-ffdf-5b04-438dfbe458c4	4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:19:57	0
aeef8307-f72a-8dae-5089-438dfb70da51	ad5a291e-8bdb-6bc9-fdff-438dfbcb3082	85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:19:57	0
f2be1bd2-2d1f-27f6-aee2-438dfb8b5e3a	f11ab305-a0e2-bb96-b103-438dfb6acce1	c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:19:57	0
44341c20-a129-c90e-bd7e-438dfb147693	429dcaaf-dd41-8b3f-b0de-438dfbf4401d	fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:19:58	0
773068d1-bfc6-7af4-6001-438dfbdd2457	75865b5d-a4d8-c1de-ce05-438dfbfde078	58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:19:58	0
bbf4fc0a-344d-2bcf-692a-438dfbb1c092	ba5c80d3-2ab7-ec3d-df9c-438dfbab724b	88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:19:58	0
cb4a0a79-ecc8-27bd-e79f-438dfbb6bf65	b1ab0db0-fa91-ceb2-a612-438dfb77794d	cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:19:59	0
3d1ee05c-6eb9-10d5-a7f6-438dfbfebc2c	3b80ec5d-e897-aee2-2aba-438dfb2a858f	1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:19:59	0
84d1d719-46ed-9837-33c7-438dfbbd616a	8337e6dd-eeae-9082-11f2-438dfb18cf6b	4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:19:59	0
b4fc8fe8-9a5d-b0de-7046-438dfb98d71e	b368d370-262d-34c8-14a8-438dfba8fd53	9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:19:59	0
e5141f1f-de34-f27b-1ea7-438dfbc8bd8c	e3724c59-f713-cbd5-d2b6-438dfb312320	c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:19:59	0
4ca29da8-9840-b15e-54e6-438dfb5bb1ff	4afff9a4-0a4b-1890-dc76-438dfb7afaa9	246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:20:00	0
9537942c-9a57-397e-e0e8-438dfbbf8b90	939c9d04-7e64-7856-b1e6-438dfb21738e	60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:20:00	0
d03ca716-6db9-f2d9-372d-438dfb5fed06	ce98183b-4f45-b592-c216-438dfb7baa3f	a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:20:00	0
c38e0822-2807-5fa7-65d2-438dfb62fe11	a93508bb-da69-7a17-66bc-438dfb1f8505	e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:20:01	0
5587f7b4-abfb-cd05-4705-438dfbf4b5ce	53e08fdb-89ad-e6b2-e5ca-438dfb06a7a1	2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:20:01	0
9125872b-e592-5cdc-5606-438dfb33176c	8f907340-20ea-f6c0-d04c-438dfbd68e25	66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:20:01	0
d7f88f0f-a705-5131-633d-438dfb747243	d665938e-c65f-9ca0-3dbf-438dfbf1e230	a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:20:01	0
2a712e5d-f831-636b-484e-438dfb8857f0	28d21bb4-8c9a-7edb-c7f2-438dfba04523	e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:20:02	0
68b54b0b-6d5b-f53c-c375-438dfb5080fc	671e3659-a85f-0f9c-2f3a-438dfb202486	3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:20:02	0
b095f0f2-48a2-679f-8f8a-438dfb191cb7	aee92370-a454-ba50-ccf3-438dfba82658	7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:20:02	0
e09670ab-46a8-3a90-dba5-438dfb399251	deff0d40-c4bb-997b-32c0-438dfb09e02c	c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:20:02	0
2857d06e-5783-9f59-213c-438dfb50740c	26c53482-e36f-662c-78bf-438dfb44428d	f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:20:03	0
72c0b275-b04a-ce81-924e-438dfbd8d636	71243b84-8117-d614-fa8c-438dfb6292a6	39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:20:03	0
af584ee8-b8c0-cbeb-5a0d-438dfb6e7d1d	adbc8e2c-812d-4ce6-495d-438dfb20c6b1	8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:20:03	0
dfa4fe5c-3036-3586-4130-438dfba5e213	de0c469c-7a57-b426-8661-438dfba7d9b4	c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:20:03	0
279fcaeb-a2c2-ea9d-2321-438dfb134eac	260790b5-55e5-5e5b-c897-438dfbca4cfb	f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:20:04	0
7f47e2bf-59a6-deb4-e295-438dfb2be705	7da4ae64-e32c-51d9-848b-438dfbf9c1dd	391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:20:04	0
cbd5a2c6-6f30-e10a-4718-438dfb41ac23	ca3cccb0-8974-61ce-57fa-438dfb118d0b	912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:20:04	0
7afa062a-e342-7235-08b0-438dfb0af2eb	614200dd-5958-f1d5-a712-438dfb9c10c2	dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:20:05	0
441ae2de-7ddd-68bf-9fdf-438dfb86caca	4288be16-71d1-7371-5b29-438dfbfb44cb	191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:20:05	0
779f7b18-e8fa-d221-eb1f-438dfb7ae4fd	760baad9-7d02-8cd3-db61-438dfbb47ee9	58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:20:05	0
c066d601-3b3f-f28d-e6a0-438dfb1a0a0f	becf2b1a-c927-df73-a590-438dfb1ab186	88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:20:05	0
2e7087d2-be8f-da0a-1111-438dfb135629	2cc41cb9-f0ab-9372-396c-438dfb9b605f	d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:20:06	0
7bd3157b-b05f-5eae-e3df-438dfb469d5c	7a322225-08f8-9553-2a50-438dfb657ed3	412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:20:06	0
b8d7fcaa-3c64-903b-c63f-438dfb725911	b73ca237-46ae-0302-8c7e-438dfbbda9d5	8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:20:06	0
e8ec27ae-fd73-b1ec-68ea-438dfb3bfe71	e7566913-22ea-dc41-b63a-438dfb2927da	ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:20:06	0
31de5d00-5f78-d58b-b456-438dfb314f58	3048de49-5d87-88d6-3e5a-438dfbee0aad	62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:20:07	0
71b6d5a9-3635-f29c-f9b2-438dfb0660a2	7020fe26-b1c3-1485-ecbe-438dfb71f32c	43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:20:07	0
be22d84a-8fe4-04e2-a18d-438dfbe03be6	bc861a7d-e5ba-5981-32b5-438dfba17da8	90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:20:07	0
84260a2a-df68-d174-adbf-438dfbe23a19	6a550819-42c2-c877-fa21-438dfb11c7fb	cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:20:08	0
47346236-f543-6def-b485-438dfbd36e93	459644ac-311f-bae5-108e-438dfb58c3df	1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:20:08	0
961d68aa-97ae-e7fd-97fd-438dfb65f7b2	948029e3-d23e-7fcf-1bd7-438dfb6583d7	5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:20:08	0
d4f1d7f5-6d31-a093-eb26-438dfbe6cbae	d356a82e-b005-3a82-a90b-438dfb6e92ff	a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:20:08	0
2c124385-0f62-70fa-6ee3-438dfb8f12ba	2a6bd51e-b835-7278-7eb1-438dfb1d7e1b	e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:20:09	0
5eecb511-532d-5b8b-0978-438dfbfcc863	5d57fece-f829-2c36-0709-438dfbe43dc3	3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:20:09	0
9e541802-88a0-1981-5954-438dfb4ee9e0	9cade42d-b856-7b89-9439-438dfbeb4b5a	705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:20:09	0
ce33fdc2-63c6-2cfb-a9d6-438dfb79dc56	cc995d70-82ab-819a-536e-438dfb683aca	af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:20:09	0
25c74649-b5e5-a1e8-de36-438dfb9e254c	2420f325-17aa-c257-30f7-438dfb7766a6	df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:20:10	0
587133a5-8154-007e-e179-438dfb68645c	565c8f77-d0b2-4238-993e-438dfbef8656	37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:20:10	0
a4d4d87e-64f4-b4e6-e87d-438dfbbb9473	a33528f2-51ce-e82e-50d6-438dfbe4f03c	69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:20:10	0
e3564588-d3d3-a10d-9dfb-438dfbf72094	e1c40347-5ed4-5945-ea2d-438dfbaee8b0	b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:20:10	0
1f4ea1db-b80e-3a85-4744-438dfb920c4d	1dbd5cc0-7e34-5fab-185a-438dfb77b676	8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:20:11	0
4f85e2b2-f473-cd72-946a-438dfb656d26	4df7a86e-0efb-4364-0f47-438dfbdbf6fa	307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:20:11	0
8241cda1-8b6e-2504-c4ed-438dfb5cde89	80948b17-513f-63c9-367e-438dfb2d41c2	636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:20:11	0
c110af8d-6736-5916-98eb-438dfbff54b8	bf809697-6fe6-f175-c00e-438dfb7f52f3	939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:20:11	0
b98609b9-1617-73ba-2912-438dfb98e009	a09e05bf-5a2f-6605-43fe-438dfb574b5a	d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:20:12	0
3bc1957b-ef00-6fae-1821-438dfb3e5f34	3a2bbafb-ab0b-fa02-0dbc-438dfba8b445	1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:20:12	0
a9fb2501-2050-cbe1-ff9c-438dfbc94057	a866029d-5a45-e7f4-c14b-438dfb74e906	4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:20:12	0
e068085a-5b0c-5283-00d9-438dfb36652d	deda9afb-2e60-ada8-747d-438dfb20bd11	c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:20:12	0
3b0c690d-1633-504a-b50a-438dfb6a144f	397f47b3-9646-47f1-ecab-438dfb07a116	f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:20:13	0
8c1d3e37-ac5d-02f8-bc13-438dfb04b95f	8a8beace-8d03-64c8-747e-438dfb9c4766	4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:20:13	0
cb520622-b469-8424-7fe7-438dfbc73f54	c9c496fe-ce41-bb3b-abcc-438dfbed9d62	9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:20:13	0
16b11be2-6d3f-547d-e3ef-438dfb880533	1526dbe7-a76a-8245-ac30-438dfb974ac1	dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:20:14	0
591132e7-2364-ef5f-a82a-438dfb6429b8	572e7abc-3990-1e1c-aae9-438dfbdec9c1	280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:20:14	0
98f426f5-6a8f-070d-bcf8-438dfb960da7	975f39f1-a529-4129-9da4-438dfb38c6f7	6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:20:14	0
ddfeb8c8-a2ff-fcb5-dc66-438dfb2bb51e	dc623760-e1b8-5046-e1b7-438dfbd0ee3f	aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:20:14	0
392aaa32-8fad-cd35-1d1a-438dfb5c9f98	37927bd3-2cc3-3329-45ed-438dfb6494eb	ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:20:15	0
6c02325d-e0d0-fa9c-6e64-438dfb147f97	6a6f5623-5821-5d7b-b1fd-438dfb26aefd	4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:20:15	0
abff928f-3178-9351-29b2-438dfb58df56	aa767ccf-5545-e919-f864-438dfb0ebc90	7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:20:15	0
ec33ad05-2980-dba1-8ed3-438dfb208e90	eaa68d29-9e2c-e39e-86e2-438dfb90ac8c	bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:20:15	0
3823be6e-ec94-9d93-f799-438dfb0a383f	36967a63-76f9-82a1-e11b-438dfb229078	95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:20:16	0
7b1129d7-a9d1-29c0-f8ec-438dfbb33ce6	7970ac63-a4f4-4541-0a19-438dfb36467d	49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:20:16	0
cc01930b-90d5-0fee-41e0-438dfbed4c85	ca16cf13-47ce-4ac7-4127-438dfbef5b58	8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:20:16	0
1f045554-c301-f63c-da5f-438dfb6c23c2	1d6eaba2-2ed7-9621-6b1b-438dfb96e4cb	e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:20:17	0
4f3c89b0-0b91-bb67-af99-438dfb683d88	4d965dd9-1f52-72b0-2fbf-438dfbd7b74a	30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:20:17	0
9216d639-8a56-c322-2272-438dfb6488cc	908a7db2-f29b-e56c-b454-438dfb130e01	630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:20:17	0
d3192a37-c802-cdab-cc22-438dfb863a1b	d1454d38-771d-4d2d-89a5-438dfbb5014c	a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:20:17	0
f445053a-9418-870f-59c0-438dfb6c5cb2	da8e025c-4606-fcb3-2b66-438dfb0261d3	e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:20:18	0
5053087b-a0de-5803-5696-438dfb38d69d	4ec683a4-ee2b-bd36-b5d2-438dfb625176	20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:20:18	0
82daa47b-8a15-16c0-cb00-438dfbc75684	81477909-77a3-63e5-0e6c-438dfbb3edcc	64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:20:18	0
b336fcbe-4fb1-46d3-3948-438dfb6b95a8	b1a3352a-4387-fe56-a158-438dfb1fc25f	94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:20:18	0
21ccc987-472e-a79b-154d-438dfb58fd13	2041af55-32c6-7607-0288-438dfbd1cfd7	c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:20:19	0
51f5a060-3571-0567-b5f1-438dfbddca22	50623487-d047-394f-60df-438dfb62ebca	3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:20:19	0
95aea336-a232-7f5a-118e-438dfb697179	94109170-76c4-55f4-7a80-438dfba4c953	65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:20:19	0
70c500f8-bd01-7d1a-6da1-438dfbbf2d77	56bc04f1-6bd3-b945-6ff5-438dfb351406	c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:20:20	0
49d33d8c-75b3-a022-2f54-438dfb458788	483b75d8-1d9b-d755-47ea-438dfb120b43	18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:20:20	0
8f085000-d277-7984-9705-438dfb88c3be	8d5986fa-1bde-fb66-8bcd-438dfb0f5dd6	5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:20:20	0
c01328a7-b1ec-874b-eee2-438dfb43acbe	be76b64b-2fc9-770b-1bea-438dfbeb4ecf	a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:20:20	0
203192df-39d1-e300-00bb-438dfba1dbd7	1e9d5c97-5d8b-fe70-91d6-438dfb171e53	d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:20:21	0
5112cfae-76e9-76e9-f1f0-438dfb64f282	4f8453c0-048f-c5e5-0a78-438dfb077837	31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:20:21	0
83b08f94-d381-8666-a67f-438dfb0d07d5	821cabbf-bc81-6133-e0e2-438dfb70ca83	64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:20:21	0
199d6a15-93a9-d1fa-15e7-438dfbeadcd9	17f335dd-51ce-aec7-b518-438dfb5b5179	9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:20:22	0
703f4a98-f9b4-2f2c-b61a-438dfbfc49cc	6e9f157c-0903-fb93-faa6-438dfbe6fde4	2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:20:22	0
b38b672f-fdd2-a347-c971-438dfb60b561	b1fca540-b603-3c39-e78a-438dfbd14c89	82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:20:22	0
e3ae03b0-9097-fcf1-fe53-438dfbe813bf	e2160452-3f5e-5abc-cfe6-438dfbfe798c	c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:20:22	0
20993e96-14fb-507f-ef43-438dfb454a01	1eff55b0-e70f-02bc-26b5-438dfbf0eb6e	1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:20:23	0
9c9c12ed-6e78-8a4d-1834-438dfb2e1cc2	9afb662f-311a-24ef-7c04-438dfb006059	31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:20:23	0
ccd29347-3e22-7261-d380-438dfba8812a	cb44a124-0e97-7083-409e-438dfb4a628f	ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:20:23	0
1b1270d8-5b9b-a77d-3430-438dfb8af7bb	1985d404-8d75-894f-8f86-438dfbe8f312	de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:20:24	0
72ac03a1-3606-0bf5-0b57-438dfbc0b530	7110808f-d0f9-2f6d-1e31-438dfb64e8f3	2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:20:24	0
b61d7e5b-0ce0-75df-6792-438dfb442cd0	b4627136-7509-0d4b-e540-438dfb634ad1	848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:20:24	0
3cc05da6-c2f5-14a4-a1c1-438dfb1ac65f	3b234eb7-cbff-9d13-38a1-438dfbee4d99	c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:20:25	0
9534b939-adbc-91bd-0ea2-438dfbe92a53	939dd6d8-b462-50b6-28c7-438dfb802d2b	4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:20:25	0
d8581409-571b-c24b-50d1-438dfbb97ec3	d6bf0e8a-3dd4-32ed-f6be-438dfba0e76a	a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:20:25	0
3b05d442-3c46-7e77-def2-438dfb1c3d57	395dd435-6781-494d-abb9-438dfb81034a	e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:20:26	0
814501df-6bad-eec8-3db8-438dfbc21ae1	7fb7feaf-c00b-cda3-d95d-438dfbe3a9d4	4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:20:26	0
c4a7c837-d33c-56e0-5014-438dfb720c22	c318fe56-13d4-7688-b3fe-438dfb495da3	92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:20:26	0
3a5029f1-973b-e209-3eca-438dfb74a39e	38a9ffbd-4ce8-1f0d-3edd-438dfbf7cf43	d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:20:27	0
93b255d4-0c88-4ccf-9cf2-438dfb8635e3	9212a191-1b14-8925-1a93-438dfb04fd9d	4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:20:27	0
d7e3e5df-32d0-a317-796a-438dfbe58595	d64c2019-e00e-3f96-fc49-438dfb6fd8c4	a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:20:27	0
143f857c-44a1-4dd3-6d4a-438dfbbb3e84	12b341c7-6053-9b8c-d4e5-438dfbe40d3d	e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:20:28	0
445d7983-b1ce-f3aa-5755-438dfb3046f4	42ad814c-90d7-5e97-3926-438dfbb341f2	2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:20:28	0
9ece75ff-c379-4755-cf5f-438dfbca0b19	9d38b81a-0552-d91c-9476-438dfb3bc660	55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:20:28	0
e2bd5d9f-3ac2-3cd0-3bf3-438dfb0cf3b9	e11ffd74-f8c1-3f79-613e-438dfbe85b85	b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:20:28	0
328068c5-cf23-2130-93ec-438dfbc08d84	30ed5bb9-636d-3c7e-edd6-438dfb1a73c2	ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:20:29	0
793edb52-7168-4f08-ff68-438dfb3bd5eb	77b00704-42ac-a6bb-b148-438dfb6553a7	43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:20:29	0
e575d3d3-e0ba-ab23-1ae1-438dfb03febf	e3de2212-f369-ad79-7a07-438dfbd5aa2c	8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:20:29	0
35f53e80-91c5-a7eb-e92d-438dfbf626e2	20496a90-f0fc-6c94-a630-438dfbe002cb	284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:20:30	0
b9d01ac7-b8fd-5888-7b89-438dfb474755	b83ab636-9daf-3906-43de-438dfb3675c8	5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:20:30	0
e9f62ab9-7968-da5f-aad0-438dfbc891bc	e85a617f-38a8-8410-3818-438dfbb46d3d	cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:20:30	0
666d16be-d3a3-ab24-b19e-438dfb401a39	4da423f5-ebd0-542c-d3b1-438dfb9fc8f0	73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:20:31	0
969c4c42-30c7-963c-bc76-438dfb6c9fff	94e3683c-caa7-d336-dd28-438dfba468ff	77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:20:31	0
efeab79b-a4fe-ed66-8e81-438dfb3463de	ee53b4c2-faef-df6e-daa6-438dfbaf601a	a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:20:31	0
2c2ddc3b-b071-2238-ab31-438dfb50000f	2a9f204a-2d5a-564e-1b60-438dfb772635	d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:20:32	0
5ec70891-3082-e664-6461-438dfb590cad	5d326262-133b-400a-b5e1-438dfb0d5ea9	3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:20:32	0
a52b8872-bd0c-afdc-ea74-438dfb62e3e3	a393cf1d-c9b5-1f70-248d-438dfbf384db	7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:20:32	0
36687ae8-3372-8963-e094-438dfbd3da62	34a0a599-9046-3a16-6cbf-438dfbde162d	b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:20:33	0
c53260da-6ba1-49cc-beac-438dfbb73888	add2aa3f-b534-326b-f490-438dfb40f079	6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:20:33	0
46490fe6-cde6-11db-0116-438dfbff2f9a	2f7ddc5c-a1bc-ca85-bf4c-438dfbecdc8b	d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:20:34	0
7a54bcbb-2043-770c-e531-438dfb5ce5c1	78bfda9e-03db-9b04-3d3b-438dfbeae7c6	58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:20:34	0
ebfa0d5b-fe17-6007-54bd-438dfb1ef676	ea61448c-4e97-e705-fb88-438dfbbf481a	8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:20:34	0
6d5af5f4-2417-9280-1b38-438dfb868196	6bbe3e62-900d-a065-3baf-438dfb896de9	9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:20:35	0
c8db5067-8eef-3253-7644-438dfb6d7a4e	c748065a-74e4-249c-d075-438dfbebce00	86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:20:35	0
4806cb04-7c32-0f13-4f19-438dfbde2065	4673b4d3-a4c9-6d04-2cf7-438dfb2d8810	dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:20:36	0
a6c5e41d-b42c-2228-7026-438dfb784e74	a5139910-a624-88f4-0272-438dfb2da0a6	59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:20:36	0
d6b982b3-7952-483c-bc05-438dfb1751d8	d527c052-0074-531b-e06c-438dfb645762	b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:20:36	0
28918ddb-a294-3bd1-dee0-438dfba5b761	270160db-2134-bce6-0748-438dfb52accc	e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:20:37	0
58efeb97-9654-82aa-4887-438dfb344358	576379f4-dfe0-6d4c-0bbf-438dfb25f8fd	39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:20:37	0
a1d3ea6c-d2e4-f6ca-b701-438dfbe82213	a017ef63-c5a5-5c5a-6971-438dfbf07eb7	6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:20:37	0
d2052b67-3d7a-13c1-19ae-438dfb3ce1b8	d06b2323-a058-7133-d1dd-438dfb312849	b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:20:37	0
dce702c7-735f-6d8e-ff54-438dfb347e40	c3a502bb-76ac-4efc-5dd9-438dfb211ba9	e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:20:38	0
6df6f5f3-2712-fddc-4f15-438dfb7f2277	6c5dae0c-a5ac-53df-aa37-438dfb5abd55	1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:20:38	0
b474f765-4133-bc3e-8796-438dfbb8149f	b2de575e-a362-1697-5f49-438dfbc00c41	7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:20:38	0
e45a939b-a3da-6f3e-ecbb-438dfbd472cf	e2c4fb3c-e5b9-b597-c970-438dfb471773	c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:20:38	0
2071c4de-ee3f-c489-0650-438dfbec7cdf	1ede6cdb-9d18-5c76-d197-438dfb1ac5d2	19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:20:39	0
510aa81a-8fb2-418d-dcc1-438dfb50ea42	4f73fb72-24b9-e833-b6af-438dfbfcd574	31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:20:39	0
83b4f8d5-78a6-4adf-8548-438dfb1b416a	821fd25a-7638-78c2-ef1a-438dfb50efcd	6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:20:39	0
caa2748e-3ca1-4a11-e50c-438dfb7e4601	c91511d6-1728-fc9f-0f2e-438dfb6e2256	95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:20:39	0
6a790032-ae97-3874-67c7-438dfb5a8ac4	50f80516-1e53-5cb6-b13a-438dfbffee25	dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:20:40	0
36f75c24-ef4a-6685-3eff-438dfb172a38	355dea2d-61f9-67d7-a13b-438dfb2bee21	17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:20:40	0
69c8831e-aff7-aacf-65cc-438dfb93b259	68385d77-223d-ac2a-3d3d-438dfb6ffe70	4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:20:40	0
9aa7459d-4fba-4eb2-4692-438dfb678d64	9913b68c-6e0b-8855-1d14-438dfb81e799	7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:20:40	0
cb758b4b-c7f3-2adf-a78f-438dfb9ec68f	c9cb23bc-1622-7417-6300-438dfbe6de33	ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:20:40	0
9241019c-2cfc-b0cb-c6ad-438dfb18d8f1	794c0411-d414-0a95-1d1d-438dfb9e4887	ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:20:41	0
3a2dd6a5-59e8-16cc-f0c9-438dfb92f65d	389caa67-c163-ed2f-9b7e-438dfb5bd598	1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:20:41	0
6d5fc8e7-7270-1942-879b-438dfb39941d	6bc20f35-387e-7e8f-2140-438dfba18d55	4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:20:41	0
9e1963b1-c71e-6d74-89e1-438dfb2c9cfe	9c853ab8-8d39-bfca-ddcc-438dfb40d006	7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:20:41	0
d004be24-b37b-01b5-ea6a-438dfbb40b48	cc8d7cee-8aba-94ea-1a40-438dfbfd7d63	af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:20:41	0
be6c07a5-dd7b-f509-5940-438dfb57589e	a47e0bed-cc14-35f3-d74c-438dfb07ee52	e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:20:42	0
3d27c002-c279-0aae-ce78-438dfb9f6e67	3b8a32ac-9bb3-c00b-b18c-438dfbb7f47e	1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:20:42	0
7111facb-4482-b1d0-9895-438dfb632311	6f84da37-d0ea-5e35-506f-438dfb60d95a	4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:20:42	0
a4ffb12d-0809-3403-4c61-438dfb023f86	a21f903d-dea7-7a97-9ac2-438dfb3c908a	8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:20:42	0
d65c5745-224d-791b-8009-438dfbbd4998	d4cc0a8d-2397-07d7-8e72-438dfb4d940f	b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:20:42	0
13d1e963-3e67-9c82-3d02-438dfb740830	123444ca-ec1a-b6eb-9589-438dfb08159e	e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:20:43	0
448916a2-6ffc-e60b-d6ed-438dfbc956d3	42e8ad96-cf83-59a7-12dc-438dfbbf71df	25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:20:43	0
79169e37-21e9-aeb2-7d69-438dfbb5fee6	7786b95e-3dc3-a434-a931-438dfb290713	56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:20:43	0
ab142bf8-eb8f-7465-a818-438dfbeaefd5	a9810142-3838-028b-6b37-438dfb6a2637	8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:20:43	0
dd60081a-4e1a-9985-3590-438dfb4b0dbb	dbc62b70-4e60-4858-8e1b-438dfbeb025f	bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:20:43	0
1d259254-a95c-4708-559a-438dfbc01c2f	1b87fc73-4473-8817-31b6-438dfbde63cd	eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:20:44	0
4d7ff1f6-aaec-1a06-b631-438dfbd31fee	4be7d2f3-f7d6-1fc1-146a-438dfb3f270f	2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:20:44	0
845c473a-462d-ff96-6d95-438dfba2afca	82bff714-4640-e311-2045-438dfbf4192e	616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:20:44	0
b693d3a4-f0a2-66b0-0f4b-438dfb1e0432	b504f7ec-7ddf-3b38-ddba-438dfbac79eb	95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:20:44	0
e6906ad1-6b13-f2c9-6fe4-438dfb510642	e4fe6e81-751c-099a-d274-438dfbcc70f6	c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:20:44	0
29b112d8-a07a-1b7d-c48a-438dfb2e9498	25b08878-26ce-def8-f21e-438dfbd38c2b	3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:20:45	0
59fb8c08-c73c-321d-1969-438dfbf42e42	586bc143-a510-8350-3e9e-438dfb70c949	3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:20:45	0
993cfe82-33d5-3ad6-30b0-438dfb3ac929	97ac765d-d208-4732-0629-438dfbc9a303	6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:20:45	0
cbe8174e-0489-1063-8509-438dfb391d57	ca54dca5-834c-1024-8cc3-438dfbabdd04	aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:20:45	0
ad300608-bf2b-ef79-c6d2-438dfb9fb3dd	92fb01cd-9334-134b-523c-438dfb6283d5	dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:20:46	0
3ae1dc65-cc6f-97ec-880f-438dfbff45cd	3942b6d9-86f2-3a67-2629-438dfb68c648	1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:20:46	0
792c2a59-1be3-832f-5dcb-438dfbea8bc3	778ee798-b48f-b6c5-edf7-438dfbf0b4c9	4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:20:46	0
ac69ab35-085d-dd10-0733-438dfba47447	aad2f37d-8ec0-5751-bb28-438dfbf83da1	8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:20:46	0
dc9fe303-f438-6f2f-d89f-438dfb1f7191	db06b71a-4012-6b0b-3844-438dfbbc3739	bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:20:46	0
201650b4-c61c-3683-1478-438dfb442628	1e7e547a-2cf5-6452-8efa-438dfb50b12c	edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:20:47	0
54fa7b8f-f268-e593-fec1-438dfbf8f07b	53618e98-fb11-4ed6-52b7-438dfb7b29de	323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:20:47	0
8f5eb77e-62fb-1854-97fd-438dfb609706	8dbc60b1-37db-f109-7368-438dfb18d348	6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:20:47	0
c41014fe-7de0-7ba9-a68b-438dfbe7b5e7	c27346e0-8bdb-7fad-e189-438dfb0764f4	a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:20:47	0
80200124-4400-fd9a-1091-438dfbf6f702	66c000f9-a424-c652-353f-438dfbcc8f04	d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:20:48	0
3999a7bb-6dfa-60c1-112c-438dfb43aa09	38032e85-5849-df1c-aaca-438dfb4909f2	19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:20:48	0
77685203-1174-90eb-e63f-438dfb9d7aba	75c2d280-c211-8eeb-8413-438dfb3cff64	4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:20:48	0
af50014d-bd9f-49fc-8ec1-438dfb74da68	ada8b73d-cb7f-1a54-2298-438dfb1d4afa	88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:20:48	0
df6a26cc-046e-2d90-38bb-438dfbdc8aab	ddcaf480-fc29-dc78-4dee-438dfbceb2a1	c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:20:48	0
2344f334-c264-fb8a-c885-438dfb855a27	21a2ee07-c342-f29f-8677-438dfb63eba5	f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:20:49	0
57ae75d8-d7a8-9413-88ff-438dfbdb6281	561bdaae-1564-248e-2157-438dfb7fc0b5	34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:20:49	0
8e4c9dcf-39c2-b79f-285f-438dfb4ec3b8	8cb33f29-1623-d72d-df2a-438dfb4be9fc	6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:20:49	0
be86a458-a95e-cf98-648d-438dfb3177f5	bcf0089f-2544-a601-fdf8-438dfbcf154c	9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:20:49	0
eed2ba07-2fa8-095f-9639-438dfbf4bab0	ed372c10-fb20-693e-aac8-438dfbf9bc41	d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:20:49	0
2aaeb92d-ca15-cb1d-5dfe-438dfb84bed3	29206d1c-f2fa-416f-77e3-438dfbd82d37	bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:20:50	0
5f8dae22-60ba-80ba-0cfc-438dfb7e6603	5df7be86-f390-7bab-dacd-438dfb1da75a	3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:20:50	0
91fd6c61-af24-aa90-869f-438dfbcf13b8	906f5754-e8a6-346e-0959-438dfb82a625	73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:20:50	0
c6ac9f65-29e4-ccaf-3cb2-438dfb2bd2b1	c5133eb4-da2f-21fc-d1f4-438dfb6032e3	a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:20:50	0
1a2fe7ca-4d2f-e293-83e2-438dfb4a14c3	1899bb4e-c29a-dd76-752b-438dfb015569	d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:20:51	0
4f97bfac-5c7d-fd96-d6af-438dfb51f93d	4e009722-3ad2-6866-395a-438dfb77a3f3	2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:20:51	0
871a6acb-62d9-69ac-198f-438dfbc75dd7	85804bd2-5f87-30a2-8e57-438dfbcaa0e8	60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:20:51	0
c16edee6-dde0-aa2a-5273-438dfb9835fb	bfd36235-c069-ae14-8f67-438dfb03432a	98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:20:51	0
794306f9-4567-83f8-ca65-438dfb673b83	5f130069-f38d-d378-8305-438dfb6f5dee	d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:20:52	0
4cdf0e8c-2a7a-d3af-4aae-438dfb8c2342	4b0e296c-51d7-49ad-3559-438dfb2943db	1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:20:52	0
7fa602e0-eab0-ddca-2b51-438dfbc5c7bb	7e131d0c-fb9b-bb99-9e2c-438dfb601c6d	5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:20:52	0
afb39bd7-2f5a-4d60-1c21-438dfb3fe750	ae1e2c7b-9aca-778a-02fe-438dfbb40118	90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:20:52	0
e51a9d4a-a2bf-2885-3bee-438dfb310c0d	e384fba2-a16f-f412-dac2-438dfb2392d9	c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:20:52	0
31cb3cf5-95ea-2003-546d-438dfb84ee3c	30292165-df86-8ea8-599b-438dfb520d77	23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:20:53	0
70797e8a-f251-ea8c-31d3-438dfb18a476	6eeafbfa-4e14-e6ae-0338-438dfbb3316b	44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:20:53	0
a646f38d-0275-fa23-6c2e-438dfbb806f1	a4b1684a-8a82-3246-450a-438dfbfde926	81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:20:53	0
dc640b69-8290-cdca-9a4c-438dfbb5972c	dace1f4b-8214-1cec-528d-438dfbd42b68	b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:20:53	0
194ef798-f07b-cf65-7fec-438dfbb16f09	17b0e3fa-56f6-7694-f2b7-438dfbd65ab1	eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:20:54	0
4f98bdc9-8148-cf4f-cd02-438dfbe39dd8	4dda1f46-88cc-386e-63bd-438dfbb7653b	2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:20:54	0
88414ca6-88f1-227d-732c-438dfb11a133	86aaf0a2-f7e4-08ca-d1f5-438dfb70585c	60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:20:54	0
be8cda8a-df76-2549-d461-438dfbe0b267	bcf048c4-8d5b-2c59-543d-438dfb364efe	9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:20:54	0
706801da-5f4d-8140-efbf-438dfbc4cc0b	f347fab7-ef86-4bcd-5ffe-438dfb16fcf1	cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:20:55	0
371384a6-851a-b736-06f7-438dfb2d376f	3578fa51-9e8b-b2ef-f479-438dfba35441	1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:20:55	0
69f6f7ca-9380-09d5-4795-438dfb09f3b0	68647185-ee73-93a2-e1d7-438dfb3f6742	4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:20:55	0
a0ccb53f-0c0d-1d4e-b6be-438dfb43225a	9f3b2f13-acb5-1849-aead-438dfbc6f3ef	7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:20:55	0
e5ce3804-4997-e9e2-e6bd-438dfbe59b97	e4256b33-026c-87f5-25a3-438dfba18a49	b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:20:55	0
21edb788-7802-62f2-9a5f-438dfba9bfd9	205a5184-19f4-b83c-0a8b-438dfbff0470	304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:20:56	0
6031a76a-53ba-3711-1b7b-438dfb8ec7ec	5ea03f7e-394e-3309-830c-438dfb3940f6	3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:20:56	0
9525e857-6b7e-470f-771b-438dfb139e44	9389db6e-4af1-49bf-c2e5-438dfb74e7c9	751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:20:56	0
cf175a2a-9520-e82e-50d7-438dfb5f5367	cd86badb-8b40-9ffe-9da0-438dfb183a64	a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:20:56	0
12194fde-ee2c-c7de-ef34-438dfba36c65	1089695d-7c35-441d-847b-438dfbc3bda6	e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:20:57	0
50ca60b9-4c0a-9281-b6d4-438dfb03f322	4f0c48f3-e55d-13ef-0ccf-438dfb2f47d3	2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:20:57	0
8ad331a8-c81f-ad9c-c85c-438dfb685ad1	893e8673-60cf-2811-b84f-438dfbb4c8e2	622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:20:57	0
bb0a5df0-5f84-2548-ca76-438dfb217b2e	b97c1a0e-e67e-4473-7650-438dfb4f095b	9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:20:57	0
f2bdc8cf-edfc-b0bf-d01f-438dfb14bfef	f12b4626-6a15-ac46-d341-438dfbe1f68d	cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:20:57	0
3dd4db5c-5779-6c5b-a37e-438dfba48d83	3c3bcdb8-9454-817b-5fb6-438dfb473c45	fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:20:58	0
78df538a-eacc-90ed-8be1-438dfb729839	774caf7a-3cea-5bd0-7e68-438dfbdb5d00	4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:20:58	0
a93abf1f-1444-28e3-8249-438dfb69ec14	a79af6e9-9a0d-d708-a57b-438dfbdb6fe5	8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:20:58	0
e1324d4a-5ad0-35a2-c318-438dfb70835b	df946194-dae6-f6fc-f559-438dfb483e6f	baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:20:58	0
3e8f5c7b-d69a-f609-bac4-438dfb2ec2ce	3ce94cbc-aa18-0e99-398c-438dfb0c71e5	f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:20:59	0
72cd3734-ae4a-caf0-86b9-438dfbca77e9	71341df4-2c20-aab2-86e8-438dfb691cd7	504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:20:59	0
b4757d41-e398-4ff6-e257-438dfb603aea	b2b16071-b19e-3f1d-ad87-438dfb71082e	849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:20:59	0
e5d857ad-733e-2de1-8a52-438dfb9281c2	e43341f9-5c56-e55a-1159-438dfb184800	c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:20:59	0
3440f9d8-1e20-1f1f-d5a8-438dfb8ee6ac	32a81608-cd1c-bfe2-d845-438dfb7f13c5	36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:21:00	0
6f5ef2e1-b23a-781b-3a32-438dfbb97119	6db6de42-8f75-532e-6d8a-438dfb92b4cf	45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:21:00	0
b8eb65aa-7fec-0b8d-ea4b-438dfb49627a	a63ea767-458b-c7c1-e1ef-438dfbbfadf0	80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:21:00	0
f1abc830-7cd2-38bd-1299-438dfbdda267	f0168b3d-753f-90d8-4cb7-438dfb41e813	ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:21:00	0
2d8f576d-b6d9-c916-7bdb-438dfb639ba6	2beb16a9-12f9-e8d1-ab6d-438dfb120f06	ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:21:01	0
7220422a-a6d0-4eb9-d38e-438dfba2e3e0	7089909f-73ee-8867-3bee-438dfbf24aa1	3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:21:01	0
b3fa15f4-ef63-9087-de58-438dfb796486	b231be8d-1714-a07f-4170-438dfb6cd84b	838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:21:01	0
ecdd0046-2f34-7276-c3b7-438dfbf819b7	eb436fc4-abf5-2592-24fc-438dfb6d3b99	c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:21:01	0
4cbb3fb0-41b9-a7d4-0d74-438dfb18bb60	4b133882-f531-8712-3870-438dfb0a38e4	a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:21:02	0
88c9023d-9281-23c9-bf2d-438dfbc7c6ce	8723405c-0551-39fc-7f72-438dfbf58033	5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:21:02	0
cb2a827a-fd21-f148-6c8a-438dfbe06881	c995d758-b175-9356-a25a-438dfb305bc4	9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:21:02	0
22a2aea5-3853-2afd-e4c9-438dfb08d883	17bab88d-c43f-6afe-2d95-438dfbb751e8	dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:21:03	0
5cc4afef-d993-6f79-52d6-438dfbea9e83	5b2847cf-c05f-1dd8-8439-438dfbd0e5ce	340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:21:03	0
8f672815-12bd-b654-aebe-438dfb9faa76	8dcb98d7-1fb9-fd3b-2d03-438dfb95f3ca	70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:21:03	0
d2e1896d-abf1-2f98-40e7-438dfb579957	d139c716-46d7-ea5b-dd2a-438dfb1db2c9	a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:21:03	0
ec530f5e-3691-973c-d454-438dfb048839	d2420e1a-9306-7581-0b77-438dfb45485d	e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:21:04	0
5c1d345a-9159-f725-f810-438dfb21b566	5a85581d-65b8-04c9-4f49-438dfb856d68	20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:21:04	0
989751ea-a58b-28d1-d668-438dfb8fa0c8	9701defd-48ef-9b70-ba34-438dfb721f54	70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:21:04	0
d2f7a8c7-539f-867a-2605-438dfb85a5d3	d161848f-b9b6-25da-e2ee-438dfb17d5d2	a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:21:04	0
18d43ddf-206c-105c-1e41-438dfb2e352b	172eaa2d-9143-e2ff-9052-438dfb19c356	e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:21:05	0
5e0feb38-50ac-f0f1-b995-438dfb938e41	5c2ccf04-3126-1057-aa06-438dfb5348c8	2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:21:05	0
aefdeead-3978-2888-5bd5-438dfb8edf69	ad613575-8132-eedd-3f2b-438dfb6d3a33	71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:21:05	0
f3975da2-6ba3-c33e-3f8a-438dfb647e3b	f1fd99b3-2b8d-f15a-4528-438dfb0120c3	c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:21:05	0
4e6d9594-592c-7b87-4fbe-438dfbd0ec55	385538b3-7b55-893e-4041-438dfb281c0f	10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:21:06	0
8bb8da71-8eb7-555f-9391-438dfbcacbe1	8a237a1a-0b09-b400-5cf1-438dfb006758	6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:21:06	0
d0dd972c-ffcb-b6df-a235-438dfba2884b	cf379c78-b6ce-fd22-e566-438dfb2f287a	9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:21:06	0
d181066c-3b26-5d00-0cf0-438dfb82b770	b7f902b5-a01c-dcc9-668a-438dfbd1fb79	e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:21:07	0
47e19c45-b57c-9864-e8cd-438dfb79f7b6	46446a44-3787-916c-9abf-438dfbe8f126	1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:21:07	0
8583660d-0bc1-9e9e-c38c-438dfba8a0f9	83f01693-d661-9ca0-a781-438dfb698921	59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:21:07	0
cb48a045-232e-db63-8ca5-438dfbf4cfd7	c9b10ba7-510a-e05e-0459-438dfbc0f13c	96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:21:07	0
1d6e4db2-f165-f97f-c0a1-438dfbd5916b	1bdd5126-1a32-6d4c-5ddf-438dfb128e73	dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:21:08	0
4d8237cd-b73f-dd0d-530e-438dfba6b59e	4beede9e-06f5-dcb2-20e9-438dfb2b3598	2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:21:08	0
8c4953fd-b0f2-5cb4-de6f-438dfb4cc6bb	8aac0eb3-bc50-60ba-4c72-438dfb462c8f	5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:21:08	0
d33588c0-7986-9150-ffce-438dfbfaa3ab	c6581ce4-2297-a509-e0cf-438dfb9da58d	9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:21:08	0
f3cc012c-c149-d2c0-78cd-438dfbac25f6	d884070c-5f9c-bc6d-c5cb-438dfb632b5e	e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:21:09	0
4ad545d7-20b2-576c-61f8-438dfb59f722	49340d14-91ff-ec1a-291f-438dfb528e7f	20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:21:09	0
894c8703-0694-44b0-412d-438dfb7c6def	87b678cc-4ef6-ff21-d0e5-438dfb959a96	5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:21:09	0
b9643fca-26ec-57db-0361-438dfbca92c1	b7c3c106-73c1-accf-cd0d-438dfb913dec	9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:21:09	0
c4bd018f-c7ef-1771-fe35-438dfba29b86	aab70ec1-bd50-d89f-5925-438dfbbe3010	caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:21:10	0
5f88a50d-89ce-09cd-1f70-438dfb482caf	5de345fd-fbad-a03d-1e72-438dfb1f206a	1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:21:10	0
923f5fe4-4d66-dd6f-4d8d-438dfbada68f	909103b7-02b6-2996-971a-438dfb04527d	736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:21:10	0
ce5b493c-4ae4-ca99-8f3c-438dfb5c2fdc	ccc521a1-42b0-0461-1db1-438dfbfc60e8	a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:21:10	0
3b804dd8-313c-45f6-1634-438dfb11fd5c	39772a90-136e-1c78-a7cf-438dfb73b6ec	dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:21:11	0
6fb682b5-5ff0-4606-49e7-438dfb3af92f	6dee0a49-5de9-eebe-48ea-438dfb4a8f88	4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:21:11	0
ae30a3f5-537d-abf7-76dd-438dfb15cf8f	ac939578-27f4-ffea-440d-438dfb6be363	82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:21:11	0
ebdda4ee-543f-2003-1a85-438dfbe5cbe7	ea478e3b-7bc7-c09e-0c50-438dfb951c3d	bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:21:11	0
2915a891-bc1e-8990-1705-438dfb6725cf	27752dc3-d98a-66c5-a10a-438dfbe6efb2	98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:21:12	0
6725b85b-20b6-bcbc-509c-438dfb874a3e	6589d325-291f-b196-87b9-438dfbda0fb5	3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:21:12	0
99d55cf6-e75e-38c8-4919-438dfb169363	9842a7d6-bca1-6145-e374-438dfbd14836	7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:21:12	0
c9fc87fa-c95c-58ce-422b-438dfbd45c20	c86a3792-77fc-aca7-f050-438dfb77d91f	ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:21:12	0
1f3c8fa1-10f7-5d38-86c9-438dfb7b26b5	1d9c4adc-2b8d-3332-93b8-438dfba0f4d5	db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:21:13	0
5c7b7524-d520-2953-e0ea-438dfb78ac85	5aeb3f00-a57e-bf48-947b-438dfb16af03	30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:21:13	0
8fd6f93e-5c45-720d-f800-438dfbe59258	8e4040ae-2931-7f7e-108b-438dfbd8da50	70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:21:13	0
c01ce75a-d289-9f89-d4c8-438dfb08b8f6	be88d5f9-09bd-47b7-f4fa-438dfbfe7eff	a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:21:13	0
95b4096f-6a66-a3ac-be46-438dfb666b8e	7c880d96-1f06-07ff-686d-438dfbddcf09	d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:21:14	0
61542517-6954-bbea-cfd0-438dfb14399c	5fbaedee-b36c-731b-a260-438dfb273327	1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:21:14	0
9447e079-4d12-9160-c191-438dfb5a81f5	929ff444-d7ad-bbc3-7513-438dfb817d0d	7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:21:14	0
c47f1e15-d226-b6cf-9ed9-438dfbe5aeaf	c2df9bfe-8f5e-6f0b-4eba-438dfbb11fad	a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:21:14	0
28a1b43b-d33d-2921-2362-438dfbd60921	26f7b83f-3b76-5998-55ac-438dfbdd0571	d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:21:15	0
5910ba90-3619-dc2d-27c7-438dfb80a548	5772ad6f-1d9e-50dc-91f4-438dfb83aea5	3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:21:15	0
b4ddad4d-7022-65d9-cd67-438dfb9f5dee	b347e318-2445-864a-206b-438dfbae6f05	6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:21:15	0
c2b0012a-1949-d1dd-eede-438dfb6f2a9e	a8530c92-04e8-acf7-4a8e-438dfbae1cfb	e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:21:16	0
58440e15-dd17-67a0-26e3-438dfb63ab7f	56830100-5245-e472-bf5c-438dfb597d22	1daf85c8-6874-a17b-17cb-438dfb55a65f	2005-11-30 19:21:16	0
b4d415e6-a920-3225-62e6-438dfb7787ac	b3306b7a-776f-4919-3d75-438dfb06b38b	69ac166c-2b09-54c5-e12e-438dfb58be75	2005-11-30 19:21:16	0
1c94fbb6-2161-eb45-b9a0-438dfbacb2ff	1ae33407-6a18-2e67-6c31-438dfb7e335d	c64ca1f4-971c-ba58-e3a6-438dfbe4e18a	2005-11-30 19:21:17	0
693e7852-6d83-1cfc-1ffd-438dfbd7bb31	67a75942-7b29-84c5-dc1b-438dfb4c6662	2e151528-0941-acdb-9162-438dfb4fb878	2005-11-30 19:21:17	0
b8aa68c3-c554-e2c9-e532-438dfbf91a5e	b708a38a-ddcb-e71c-0be9-438dfb6f14cb	7d77c5de-1ccb-a31f-2fa0-438dfb56e39b	2005-11-30 19:21:17	0
e8d40ddd-714a-fe2a-0193-438dfb322010	e73c2b75-51c1-556f-0175-438dfb3438d3	ca27de55-8edd-4ee9-e5ac-438dfbd89907	2005-11-30 19:21:17	0
333befab-27a7-d2b9-ca50-438dfb1bd59d	31941a18-98a5-78c3-b0f5-438dfbdea6a6	60b70a54-714f-be7a-4b60-438dfb818721	2005-11-30 19:21:18	0
63841f13-14b7-4655-44cb-438dfb5b10ec	61de8d58-0a88-daac-786f-438dfbfabc3d	4493f50e-b438-9309-7460-438dfbd1e55a	2005-11-30 19:21:18	0
a552329c-8bd6-40f8-68bb-438dfbc985dd	a3b7f50f-2927-05a1-448d-438dfb9f8b70	7785d491-20b6-5a33-d7f5-438dfbbcdfe4	2005-11-30 19:21:18	0
b0d0084f-6c5c-34fc-c8ff-438dfb7f623d	f338e55b-c6c2-b508-aba6-438dfbe17d7f	b72ef6a5-a70e-7e32-7555-438dfb48175a	2005-11-30 19:21:19	0
3fa26078-8c04-4058-25a2-438dfbcaa077	3e005fd4-ee61-6319-0fba-438dfb0f0503	1226c48a-8e8a-48fd-168f-438dfbbc24a6	2005-11-30 19:21:19	0
8ff290b9-e606-1458-a9e4-438dfbacfab1	8e557696-9cbb-d7fe-db7c-438dfb24aa6a	51069b30-5071-f6e7-81d6-438dfbfac69a	2005-11-30 19:21:19	0
c071dd83-1234-90f9-18c7-438dfb040030	bead48af-9252-a436-8286-438dfbe332d2	a169e42d-a69b-b039-6170-438dfbd9dd1b	2005-11-30 19:21:19	0
f0a65948-7dca-447e-5edc-438dfb1af5c7	ef0b0453-13d5-e932-aa5f-438dfb6c5b87	d1c588fa-0835-de12-f760-438dfb25122d	2005-11-30 19:21:19	0
33111f5b-69dc-62b0-27ab-438dfb2b1151	3179bf08-aa9e-6447-9ad2-438dfbaf64bb	1463cd37-29f8-b0f2-4514-438dfb7af5ba	2005-11-30 19:21:20	0
750d3356-70be-4211-ca4c-438dfb29a0db	7371f5a0-df4f-929e-f361-438dfbca4a1d	4488073d-4339-fb11-e278-438dfb45d751	2005-11-30 19:21:20	0
d3645d0f-b637-cf4b-f18f-438dfb163c3b	c2799ce6-f145-d487-d544-438dfb7e54de	86b427e1-a1dd-4d58-d470-438dfbdd6dfd	2005-11-30 19:21:20	0
1eda9fe0-31bf-e93d-4fce-438dfb65f273	1d35f104-81c6-91b2-aa22-438dfbb8d79b	e4ce44fa-216f-d1c7-e9ef-438dfbb2cc13	2005-11-30 19:21:21	0
5ea5f8a8-d270-e7fa-05e9-438dfb039edd	5d0e32f9-ccbd-5884-b558-438dfbd80618	30243b86-0c2f-4cd9-cf98-438dfb7a611e	2005-11-30 19:21:21	0
a0ee1dfa-db0f-6072-4390-438dfb13e962	9f4f9ecb-204f-86bf-51a4-438dfb908e62	7282206d-2097-c88f-cc36-438dfb4272e6	2005-11-30 19:21:21	0
f07aaf6d-19a0-b715-055c-438dfb221f76	cfbddcb2-d793-f7de-7ae0-438dfb13284e	b269cbcc-3523-84cd-76a1-438dfb8cca3e	2005-11-30 19:21:21	0
417feeb9-12e7-9cf6-72d6-438dfb651526	3fe3d218-f486-5e02-90e7-438dfb8e07c9	db29071d-ab61-8267-207d-438dfbd07e1f	2005-11-30 19:21:22	0
74a42902-3d68-ef51-85dc-438dfb946969	72fd3911-6a09-d547-8135-438dfbab92b6	52e4fd3b-926a-77bb-c6ba-438dfbe5a927	2005-11-30 19:21:22	0
b4e23ee9-2a0f-8d87-94fa-438dfb266be3	b34f3620-e06d-2204-bad6-438dfbde15d9	861f83dc-68b6-733b-cbce-438dfb2b868a	2005-11-30 19:21:22	0
f0f004f2-e5f4-0591-4a15-438dfb7c4557	f37ba3e7-5fba-8116-0c9f-438dfba4a4a4	c661b334-bf51-1dde-62bf-438dfbf2442c	2005-11-30 19:21:23	0
51c163ce-f768-5f0e-3068-438dfbaf7df7	50163f87-2578-8145-a6ba-438dfb7a64e7	12814883-6201-bc73-1589-438dfbe68b5d	2005-11-30 19:21:23	0
8f9a6387-db8a-3ff1-1305-438dfbb9aec2	8dfbdb3c-ea21-ba42-2b4e-438dfb1ed504	68359cf5-c82c-2694-bcf9-438dfbe295ac	2005-11-30 19:21:23	0
c3cb88a1-a060-804f-0ad6-438dfbb92676	c2287454-16a5-ad9f-53eb-438dfb449127	a2f0f610-c757-4a3d-0e53-438dfb0662eb	2005-11-30 19:21:23	0
317701a7-9269-7b12-bd88-438dfbb2882c	17130dfb-8f0e-76cd-2459-438dfb9a7d26	d6b280a6-e776-1416-4a2f-438dfbc155a4	2005-11-30 19:21:24	0
36aaa403-1655-56fc-997f-438dfb182d6b	35018c59-161b-f18c-70fa-438dfb2e22bc	1620dad8-2eb7-e7e0-cc51-438dfb06f565	2005-11-30 19:21:24	0
81114e09-3260-3df3-4d87-438dfb9bfc9d	7f602621-3a03-7c5b-299b-438dfbd7c79e	4ca2c4b2-a7ad-2dd5-c8ce-438dfbacc559	2005-11-30 19:21:24	0
c652feb5-8a73-7af0-e6f0-438dfbaf39d7	c4b41d6a-98f8-db12-4d87-438dfb17a0ee	94a3441e-a450-ea5a-d820-438dfb458713	2005-11-30 19:21:24	0
159d2d75-5efe-fe05-3199-438dfbe9ebc8	13ead050-5430-1f24-bbba-438dfb81df4b	d882d439-557f-3c8a-2b84-438dfb8fb443	2005-11-30 19:21:25	0
591eedf3-96ae-91f8-b470-438dfbf68628	576814a8-5b8e-aeec-882a-438dfbc108de	27d80dd7-5709-0d55-bc59-438dfb2ecf77	2005-11-30 19:21:25	0
9f0b3cb1-481e-fb8d-3f3a-438dfba146fb	9d5f576d-d8aa-a18d-03f6-438dfbf29aa0	6bdb4764-4c85-d993-60a3-438dfbd78877	2005-11-30 19:21:25	0
e193a6cf-41b0-c770-445b-438dfb53bfd4	dfe35de9-6a10-58fe-e8ac-438dfb444a89	b0e04bdb-7d18-6594-1161-438dfbdd2db8	2005-11-30 19:21:25	0
40f81930-a363-36b1-91e3-438dfbedb8a0	3f58df53-2d1f-14b1-99e3-438dfbf453bc	f36732ff-d18a-33cf-cdef-438dfb50e080	2005-11-30 19:21:26	0
75094e61-884b-a866-b4ac-438dfba87bc7	735e191f-1fc4-37f0-d279-438dfb58f8bb	52bed83a-38fc-b11f-f87f-438dfb98b92e	2005-11-30 19:21:26	0
b71e9ba6-a955-243d-9a45-438dfbdacc0e	b58876e3-c8b9-5cdb-9684-438dfb973b0c	86d3263a-ebb4-fe6c-af85-438dfb92f6e9	2005-11-30 19:21:26	0
26fc26e9-adcf-f292-1a98-438dfba47c80	255ddee7-76a8-3237-e26d-438dfb4d14d1	c899fe71-1c72-cefa-3506-438dfbf06cbb	2005-11-30 19:21:27	0
68c85032-8ee6-55d8-3b7b-438dfb4efce2	672a9d8d-1169-77f4-3e03-438dfb1b502d	3848e594-7629-8173-06a8-438dfbd07afa	2005-11-30 19:21:27	0
9b8bdaad-aa5d-0ea3-88c8-438dfb4e55e4	99ef86ab-70ad-c2c7-9019-438dfb9d42ea	7cb73f6a-5de6-f957-936b-438dfb2ab8cb	2005-11-30 19:21:27	0
ef2bf2da-4ca1-19b5-88c6-438dfbe5838d	ed983c1c-954f-ad34-cdac-438dfb13e2a3	ad0c8ac5-b1f9-9dcd-ca34-438dfb04c1a8	2005-11-30 19:21:27	0
2b60da17-87e4-bd12-336d-438dfbd08d91	29c5fa2b-917c-ee13-f67b-438dfb2aa822	c98d0766-adf0-5ff8-63d0-438dfb9a8e9e	2005-11-30 19:21:28	0
5c0fbef6-a20f-3ca7-eb98-438dfb19e5fe	5a42514a-1d12-21b5-0ef2-438dfba6baaa	3ce7d434-1d87-d2ac-cb37-438dfb6eaebb	2005-11-30 19:21:28	0
8ebfd332-e40e-03e1-1def-438dfb6813cb	8d255020-6ab1-1629-5957-438dfb5fefd9	6d531631-8b4e-ed30-477f-438dfb9e4024	2005-11-30 19:21:28	0
197e043c-ee68-a5bb-28df-438dfb577858	f42253fa-4431-bf39-1eff-438dfb5ccc2b	b3341af8-246f-e384-a007-438dfbc474a3	2005-11-30 19:21:29	0
44b16fb0-535b-7d76-48a6-438dfbf963f8	431d4846-1657-7eeb-ccca-438dfbd906d3	13116248-d871-2b8d-45af-438dfb8b4196	2005-11-30 19:21:29	0
898d5668-207d-5f0a-983b-438dfb1806f8	87e6cc8c-3963-ed6f-e757-438dfb9cee0f	5602b4b8-2825-616c-26d1-438dfb0c802e	2005-11-30 19:21:29	0
b9d82d83-540d-136d-a262-438dfb41454b	b836880a-50ee-b122-57d7-438dfb312840	9aecd983-eb46-0d41-825d-438dfb1bcc5c	2005-11-30 19:21:29	0
81580cf9-4c67-aad9-847b-438dfb482b0f	66cb06b4-9fa8-fa44-86ee-438dfb289f41	cb4e19da-1b76-52ef-4756-438dfb152979	2005-11-30 19:21:30	0
5d0ba24d-3daa-5029-7b4b-438dfb9f1a1b	36ad5d3d-c5ba-46de-6588-438dfb5e50f5	198c4b42-3db0-a532-fe75-438dfb4ed4c3	2005-11-30 19:21:30	0
b5a4dddb-6908-be61-d7e3-438dfb2f6a00	b411d972-3692-d425-7c61-438dfba7104b	721ccb5b-ba24-966e-5cbd-438dfb4043f6	2005-11-30 19:21:30	0
e5f53df9-86df-0efa-74cb-438dfb13c68b	e4606022-243b-cc24-ea46-438dfbab7ef1	c70c9652-fb23-1d97-2bcf-438dfbb6fe01	2005-11-30 19:21:30	0
22281716-991a-b83e-0f2a-438dfb3d6c16	2089b201-3ea3-f697-2702-438dfb4d6da0	33aa0685-459e-a142-1291-438dfba1fba4	2005-11-30 19:21:31	0
8d31ac8e-aae1-bab3-c6f5-438dfbead154	63b7cd92-1679-3792-289f-438dfbf297b2	337bdd25-c908-7d88-d70e-438dfb6d5a65	2005-11-30 19:21:31	0
d009e0a0-bd1d-9981-6dc6-438dfbb168fd	ce67176e-8137-83ab-eba0-438dfb7249de	9e9d1ad7-e038-da60-b03f-438dfbb22801	2005-11-30 19:21:31	0
374721a7-096b-8c33-ac25-438dfb6aecbd	35b22091-0b1b-c7fa-21b0-438dfb70d3a3	5b3205e4-12a6-dee0-efd5-438dfb40c431	2005-11-30 19:21:32	0
7d894c48-a727-5f37-f960-438dfb7efc15	7bf2fb4c-2bdd-2f3e-4d2e-438dfbbfbf4a	48baf602-37b8-7988-804f-438dfb47231a	2005-11-30 19:21:32	0
c0c771ca-7be4-e460-152f-438dfb645f5b	bf2e9820-ec17-72ef-9fe0-438dfb76c0a3	8ef3c7cf-ee6c-1e89-f6c4-438dfb171221	2005-11-30 19:21:32	0
23159ee6-5cb0-6927-3fd6-438dfb648352	217e43e1-caa2-58c7-738a-438dfba8d9c3	d2373f7e-3be1-ac95-0bbd-438dfb96caeb	2005-11-30 19:21:33	0
534a4fa1-ceee-16a5-a99f-438dfb5890f9	51afb235-7282-54fb-491b-438dfb20bd02	34777a04-8cf2-130c-c206-438dfb71857f	2005-11-30 19:21:33	0
86645bca-01f7-2983-1472-438dfb719630	84c9a387-9285-336b-da4a-438dfbccca30	64db3226-ae3d-4e8a-5749-438dfb42ff39	2005-11-30 19:21:33	0
b7a602d3-243f-33f9-7179-438dfb0de9ae	b607cbc4-9c0d-83ab-6177-438dfb1dedaa	97bd6b61-bc71-d178-5a95-438dfb05fd04	2005-11-30 19:21:33	0
75df0299-0bea-fb91-90f6-438dfb5421be	5b1b0bd2-a4de-3e2e-acd7-438dfbca4f42	c8efe193-131a-8773-9b67-438dfbcae321	2005-11-30 19:21:34	0
37837618-1132-2f10-f766-438dfb9d9178	35ea3447-51b9-f6cd-0e2f-438dfb83b57e	18cf8c9b-25fd-9b30-f993-438dfb879e80	2005-11-30 19:21:34	0
7e066504-0173-7018-98bc-438dfb495f97	7c5e1bd1-00e0-960a-2420-438dfb99df6a	48f9d0d4-e10b-53cd-1a0b-438dfbb23a4d	2005-11-30 19:21:34	0
d634604a-a609-842b-af25-438dfb9f630b	c0c047f2-f138-1c51-d11b-438dfb0e3d5f	8f7f554f-8242-46f3-6454-438dfb8ee5fe	2005-11-30 19:21:34	0
124d7abb-d78d-6867-b14f-438dfbffaba3	10b22f2b-80f3-796f-ecf4-438dfbb42bd9	e7ab3484-832b-285b-9e13-438dfbc947f0	2005-11-30 19:21:35	0
6b13dce3-c6fb-4bbd-b54b-438dfb4b83e1	696faf37-710d-16d7-e9c2-438dfb1f763c	2399516f-d014-ece7-7267-438dfb20a957	2005-11-30 19:21:35	0
c6174616-6255-bb6f-5314-438dfb122a44	c47bf03e-0f39-d39a-e747-438dfb3f6a35	7f281512-f478-c01d-bd68-438dfb8e94ef	2005-11-30 19:21:35	0
21f30f39-293d-bb80-2617-438dfb624ce3	8ae00f66-bca9-0e92-9425-438dfb778642	d7b2d1e3-13e2-0239-45f8-438dfb71d950	2005-11-30 19:21:36	0
5aa83daf-ae97-d5f2-3b6c-438dfb1d7f85	59070258-441a-dd89-ae16-438dfb0c6de5	13732b70-8431-4e65-826e-438dfbc8b6b9	2005-11-30 19:21:36	0
b623146e-2260-d623-8cc8-438dfbaf0f92	b48c8890-69f2-da7a-f32b-438dfb708928	6c574e51-9fc9-902c-bb97-438dfb3d4859	2005-11-30 19:21:36	0
e635a02d-4753-c484-dbc1-438dfb280538	e48346ac-4bd5-2f4e-355c-438dfb777c61	c76da14e-ad51-81c1-dc28-438dfb72b7c5	2005-11-30 19:21:36	0
36b59fdc-080b-dcf4-23ff-438dfb835bef	351bd9a4-d3b2-d68f-df5e-438dfb5f7e5f	3644006f-4f8d-5c21-276a-438dfb9dcb96	2005-11-30 19:21:37	0
92d9bfc1-ebd5-0357-a9d1-438dfb8c73f1	91362642-c0f4-ad62-0188-438dfb137389	4812da65-b53f-1751-8610-438dfbb4962b	2005-11-30 19:21:37	0
ee6c9b19-6439-f0ae-497f-438dfbd9d417	ecc2db88-50e6-ba48-6ddc-438dfb68fbb7	a5388d7b-fcfd-a575-9e4d-438dfb967005	2005-11-30 19:21:37	0
2b7887b0-4349-9250-bb06-438dfbe7fbbe	29d5012e-68f1-aedc-30ec-438dfbaeb0ff	c1400045-4d2d-7fdf-4a95-438dfbbc7abf	2005-11-30 19:21:38	0
5ca63bf8-94bb-9c38-01b4-438dfbbdbf10	5afdf11d-f2fe-1e8a-9137-438dfb7b6dd7	3d28e556-d760-cce4-1c6e-438dfb740e75	2005-11-30 19:21:38	0
a5e35901-8461-100d-adb7-438dfbc4c8e2	a43e6d97-0c51-6907-6d68-438dfb32cdfc	6ea925d0-f283-ae03-e457-438dfbf5c7c2	2005-11-30 19:21:38	0
22949bd2-13bf-397c-b023-438dfb175dba	20c99390-ee1a-ffe9-672d-438dfb6e71ba	b7f0204d-c5da-0bac-fb1f-438dfbab43a1	2005-11-30 19:21:39	0
5311d755-8eb6-5fa2-2eb9-438dfbb12db9	5166e954-0646-7926-e954-438dfb36ec3d	34348439-2f14-69b5-9373-438dfb8feeee	2005-11-30 19:21:39	0
b0491ffc-12b5-c480-7832-438dfb8303d4	ae9ac46e-20d6-e2e0-3213-438dfbaad8d3	647cf0ab-fc93-d5d6-357f-438dfb507848	2005-11-30 19:21:39	0
1c8e0180-a0a9-732e-1abe-438dfbc1910c	32f00a84-2dc8-013f-12fe-438dfb3e4592	c1c8000d-1b0e-79b7-b29a-438dfb14fa50	2005-11-30 19:21:40	0
5cf10fe8-240e-e61c-5bc6-438dfb47fc4b	5b4c15a1-72f4-7359-7a6d-438dfb258ac3	135ff079-16c6-0b0b-4f55-438dfbf9fbef	2005-11-30 19:21:40	0
bacec183-30c6-8d57-a72c-438dfb7a9432	b9286664-5119-e1b7-b201-438dfbb54f64	6e8e2660-d6e8-bb25-5cf3-438dfb4910ff	2005-11-30 19:21:40	0
eb33c1cd-648a-830d-b639-438dfb4ba2fb	e99e69c9-59bf-5b07-e8fb-438dfb4d3227	cc37afac-d26c-7be4-dac5-438dfb6cf69d	2005-11-30 19:21:40	0
27238c2a-2925-70ae-2eba-438dfbb50232	2589c2fc-695b-614f-3488-438dfb19204c	8512079f-f956-4a23-8a37-438dfbb02101	2005-11-30 19:21:41	0
575ed1c1-c75a-b034-79df-438dfbcd2008	55d4a0e8-4b62-3414-47eb-438dfb88219a	38843ba3-2413-4dcb-c56d-438dfbb925ee	2005-11-30 19:21:41	0
e1ee2861-1cf1-7402-1503-438dfb8c2b61	e0489c04-4362-a4aa-8b77-438dfb917639	68dd5109-aad1-d62f-b4ac-438dfb484563	2005-11-30 19:21:41	0
340114f7-62ee-09c4-f586-438dfba1fdaa	326e0b1a-bd5b-803f-0c2a-438dfb4092bd	f355358b-92a4-c9c0-9890-438dfb4cbd09	2005-11-30 19:21:42	0
647d01e6-fdda-a348-20c4-438dfbb5115d	62eea08c-9c71-5c87-21c3-438dfba3d06b	45676a3b-9212-eee8-5971-438dfb7f3881	2005-11-30 19:21:42	0
d9abf83a-b5bf-30f5-c161-438dfbd05b40	c1cbf81a-8d02-8dd0-dfdc-438dfb13ad6a	785db1b9-b296-52c9-900a-438dfbeaeace	2005-11-30 19:21:42	0
16177a4f-1600-774d-65e7-438dfbbc372c	14888954-203b-78a5-78d1-438dfb219a9b	eb362250-759c-9ba0-ae66-438dfb65e251	2005-11-30 19:21:43	0
5c9f560b-1f37-5b1c-aa3c-438dfb04722f	5b0ffecc-4804-19c4-2576-438dfbbdfecb	27795a7a-69be-075d-3a2b-438dfb625195	2005-11-30 19:21:43	0
a62e72da-96aa-eb76-e204-438dfb6f78b7	a4a027eb-edd5-c1a1-ec53-438dfb4a3f6b	87412abc-b1d1-2243-4493-438dfb1387a5	2005-11-30 19:21:43	0
ed8510cc-893b-b86b-30db-438dfb3d0bbd	ebf84d8e-0737-a4e1-ae5b-438dfba45631	b7a00e4f-c220-5842-62dd-438dfb9c5da2	2005-11-30 19:21:43	0
29a0fe6b-77b7-e81d-4164-438dfb4dd2bf	28108460-b8af-4e66-dd01-438dfbac92cc	abf606cb-985d-df3b-31d3-438dfb244337	2005-11-30 19:21:44	0
89bd0cdc-5c4d-2ebc-725e-438dfb6cdac3	881c3e57-8f17-7384-43b8-438dfbf9ccdc	3b08a4cf-21d7-9a7b-a902-438dfb3bb829	2005-11-30 19:21:44	0
ba003caa-03d4-613e-9e41-438dfb10c68d	b86b7017-bffd-ba61-3170-438dfb219307	9b38016e-c8c4-fd77-e640-438dfba26384	2005-11-30 19:21:44	0
ea5ad7d0-aa20-362f-3a7e-438dfb7fccc0	e8cf1e36-908b-5862-f8a8-438dfb8ccde5	cb9c933f-85ae-e605-63f7-438dfbe24a0b	2005-11-30 19:21:44	0
266a70b1-f198-52e4-9abb-438dfb77c02a	24dd8f9d-2dc1-c3e7-69a6-438dfbc1cc4b	79380c9a-6503-7414-02f4-438dfbd217e4	2005-11-30 19:21:45	0
9df665ff-a44b-209c-75a2-438dfb3e7d53	9c61e845-eb88-7bc8-0bcd-438dfb6b524e	37b7f271-1f25-cd1f-44bc-438dfbf47e45	2005-11-30 19:21:45	0
1f9d9041-f8ae-b9aa-3bc4-438dfb1ffc5b	1dfc723b-c827-2f2e-0900-438dfbdcaa05	af580786-dc85-f4b7-3643-438dfb894439	2005-11-30 19:21:46	0
500225ac-5af4-44fd-0f66-438dfb4ad1c0	4e5a42b8-683a-6576-1265-438dfbab780b	3124580f-664b-4103-ef3e-438dfb1904b1	2005-11-30 19:21:46	0
82ef0620-c060-51cc-0244-438dfbede16e	8157d20e-3c8d-b38e-2f52-438dfb6a870f	6196bb05-c4fe-c086-55ca-438dfbe61361	2005-11-30 19:21:46	0
e1d290ae-7a6b-1d4f-10da-438dfb26fc61	e041ac62-855e-20d9-bb5a-438dfb9a6c93	94482729-93a9-c5c2-ac96-438dfb62fd32	2005-11-30 19:21:46	0
3548a7d8-1e4a-d8f7-6ef4-438dfb7d7af8	33b9afff-b44a-b0a7-adce-438dfbfe2a30	f34f0288-6e50-49a1-3087-438dfb21818a	2005-11-30 19:21:47	0
7fe5206c-254f-7e12-2957-438dfb6e1ce3	7e513885-8410-5d59-c0c8-438dfbfdec91	46af97b1-278e-a1b7-6f9a-438dfb57c0ec	2005-11-30 19:21:47	0
c7b5e162-c3b9-b685-34a6-438dfbf5b911	c6275cc1-e87a-9089-5779-438dfb09a475	91606de9-ecc7-35f6-9f44-438dfb189f7d	2005-11-30 19:21:47	0
333728f9-2a01-e280-d371-438dfbfceab6	319abfaa-8fbd-85e8-5972-438dfbf6894b	d95a7a99-170c-499e-428e-438dfb361dce	2005-11-30 19:21:48	0
954e4c1b-6b1a-a014-9f20-438dfbd3d16b	93c0bbca-072e-c32a-6723-438dfb087d07	7427f840-c2c9-d834-f101-438dfb56c870	2005-11-30 19:21:48	0
c5fae370-1b4f-6080-1fb0-438dfb80ec0d	c4645f8d-d7f3-671e-3efa-438dfb5b4711	a6d286c3-ebd0-936e-7eda-438dfbc6f7fe	2005-11-30 19:21:48	0
1cfb06c4-370e-ce7b-e526-438dfb5d1ae1	1b7103e9-a3b4-7edf-a46c-438dfb3f9412	d8298c3a-2e00-563b-0bae-438dfb77a99a	2005-11-30 19:21:49	0
653991a7-7883-81ef-a79a-438dfbd4c61a	63a23180-ac3f-e4f9-2311-438dfbaebb8c	2e58254c-eae7-84c9-3019-438dfba6f7c4	2005-11-30 19:21:49	0
b009e73d-895f-e2eb-efb3-438dfbf949de	ae7aa2d3-5a31-a2b8-42ce-438dfbd4bbe4	79453030-58ba-a4c2-fb42-438dfb5babf3	2005-11-30 19:21:49	0
e022c9ab-7e41-7291-e650-438dfba1142e	de93d2d3-1ed4-f334-7001-438dfb24b595	c16881fb-499b-da86-1ad4-438dfb189086	2005-11-30 19:21:49	0
1c2bdf90-59dd-d464-07a4-438dfbac994e	1a9c9fdf-b080-337c-e85f-438dfb275861	f18bc447-43c2-7a4c-76a4-438dfb3b6210	2005-11-30 19:21:50	0
982056b3-0d4b-2ae1-ce9c-438dfbd3540f	96733ea1-ba91-ce6f-d2e4-438dfbe4c71b	2d6eeb58-8ed8-ffa5-00c1-438dfb302163	2005-11-30 19:21:50	0
ca23566f-0b0f-d931-7801-438dfba25335	c88a0811-e3d1-674c-5386-438dfb3ec160	aa07e3e9-14d4-7ea5-0364-438dfb423b85	2005-11-30 19:21:50	0
38e615f1-257a-bfdd-3ed6-438dfb0a9f94	37549e2f-ed07-091d-4f17-438dfb8c3077	dc32d1a7-baa7-4ddc-ad19-438dfb2b4fd8	2005-11-30 19:21:51	0
6bad1fdd-799d-c508-7ca3-438dfb41a294	69ffb1ab-208e-4947-14ec-438dfb152a0b	4bd4969c-6b43-e0dc-efc5-438dfbfebe9b	2005-11-30 19:21:51	0
9fabae21-254c-efc8-560a-438dfb2eef89	9e0ae308-100f-e8cf-3aeb-438dfbf747d9	8020ee80-2bc1-61ee-2d0c-438dfb47ffc7	2005-11-30 19:21:51	0
ea124983-c27b-311b-28f2-438dfbfe1d80	e86211ac-4d63-a5f6-998c-438dfb4d3908	b15df275-d23f-d4e7-5c0b-438dfb6f426e	2005-11-30 19:21:51	0
3f54fe20-09a2-a1a0-32c3-438dfb54d73b	3db177be-8fc5-658f-81e7-438dfb277687	76fd063d-d3b5-5a36-cc8e-438dfbea1f29	2005-11-30 19:21:52	0
8b6b31a8-d1fc-acf5-1cfb-438dfb5e2551	89c63bfa-81e2-cc7d-c689-438dfb9f7b0e	509dc2bc-855f-8229-e87d-438dfb3ee35f	2005-11-30 19:21:52	0
edee8005-1ea5-f1e0-5947-438dfb775895	ec5947a9-4a43-f0c6-f086-438dfbd42e9d	9cde617d-0978-99e0-4aae-438dfbc944bf	2005-11-30 19:21:52	0
2a2e9a1c-433e-0973-2351-438dfb3dc093	289d6108-eed3-9a4b-5ff3-438dfb3fc47e	b26006b3-c1e1-78bf-41e3-438dfbb3abc9	2005-11-30 19:21:53	0
73a60058-fd52-22ba-7b7a-438dfb03df01	7215bb16-bb2a-e729-a89f-438dfb114cb2	3b976dba-9c67-c85c-1b46-438dfb6e2b10	2005-11-30 19:21:53	0
a6751452-c598-d22a-aa98-438dfbf577e8	a4ddb613-e5d4-9fa9-69e9-438dfbf89032	87997809-5094-024a-2814-438dfbaf7d3e	2005-11-30 19:21:53	0
d743f6e3-40d1-6b9b-00a6-438dfb0899fd	d59eccaf-177a-bd0c-fabd-438dfb2f2b48	b7f3e4ed-f834-8e31-5f4d-438dfb359ed2	2005-11-30 19:21:53	0
601ee537-69dd-0918-67c4-438dfb434b15	5e69fa07-890b-26c1-ed45-438dfbf1ba9d	e8e59f02-1eed-27d0-6d7e-438dfba9d868	2005-11-30 19:21:54	0
933012f9-ef9d-cddb-a795-438dfb3845f0	9195a8f2-3f5c-c1e6-65e8-438dfbb16254	71c71ca8-8151-f6db-5da4-438dfb255755	2005-11-30 19:21:54	0
dd322d27-cf6a-606c-6117-438dfb598164	db94eb9c-efcb-634d-10ce-438dfbccd3cc	a4a3717a-c2d5-691b-c4e2-438dfbb87573	2005-11-30 19:21:54	0
331ec809-ed14-31f2-c2b9-438dfb86e250	318e815f-392a-3581-ab95-438dfb92c042	eeaabf09-d964-c5dc-639d-438dfbccad87	2005-11-30 19:21:55	0
80186478-bcb4-eebf-d750-438dfbfd958a	7e85945e-f5da-6266-9fba-438dfbb1f1bf	449cf514-d107-bf13-e22d-438dfb6346c5	2005-11-30 19:21:55	0
24527a15-b714-31d3-af40-438dfb37348c	22ac87a9-328c-e321-02e5-438dfb8322c9	9160e67c-7f47-05f8-1b62-438dfbb654a6	2005-11-30 19:21:56	0
548e756c-3bfe-1e47-982c-438dfb6a7ec5	52f6e3a3-1247-0670-fe95-438dfbf2dccc	35b9c4e3-e670-d12b-dc94-438dfb3c3e70	2005-11-30 19:21:56	0
a1993ad5-f0f7-2ed6-9412-438dfb58b850	9ffff8c0-a470-5dd0-b5c4-438dfbd49356	660a9106-4c87-1508-c45b-438dfb157396	2005-11-30 19:21:56	0
125ebbcb-97ed-4f47-6d14-438dfbf0b9e0	10b70f04-acf8-4a38-54c8-438dfbdff557	b2fe2a8c-729b-82ff-875d-438dfb786209	2005-11-30 19:21:57	0
943331ea-14b2-ebec-93ec-438dfbb0b277	928f8665-a811-875d-d688-438dfb3ce694	23b45f1c-189f-1aff-e722-438dfbd23fb4	2005-11-30 19:21:57	0
dead0535-4be4-5e57-2d2a-438dfb606b04	dd10ca84-2b2f-3077-3127-438dfba2a7ea	a594ad62-21e6-fe38-3ac1-438dfb6ab474	2005-11-30 19:21:57	0
1b15a2cf-694a-44a3-62e5-438dfbfe30b2	19775f67-6c73-87b0-abfe-438dfbe26612	f054b6dd-897a-65d2-95ef-438dfb80f3f6	2005-11-30 19:21:58	0
4b9176d0-9def-f154-cb0d-438dfbda5991	49f9b1be-1f45-af88-e315-438dfbedd97c	2c8ed1d1-6cc4-05df-84d8-438dfbb6eb82	2005-11-30 19:21:58	0
8432aed5-2e60-257c-9c57-438dfb15f406	829afa58-7227-58c6-49fc-438dfb52c7b3	60211e94-e474-918e-8c77-438dfb92d148	2005-11-30 19:21:58	0
11668843-72bf-c43f-0186-438dfbf4bd74	fc0c0a3d-81b0-edb4-3ef1-438dfb98b640	95939537-69ed-0569-349e-438dfb51b14d	2005-11-30 19:21:59	0
41cc828b-38b7-7f28-d4ab-438dfb1737cd	402a2a43-75ed-f69a-94df-438dfb9eb789	22fda997-049c-6ff8-d2ac-438dfb8b8fe1	2005-11-30 19:21:59	0
71d8a682-dee1-ec63-a3af-438dfb4dad2c	703cb1c6-dc5e-ea03-e96d-438dfb6c9a07	530cf751-bc28-78f8-9727-438dfbc5fce0	2005-11-30 19:21:59	0
dacdff30-8607-3cf8-8c77-438dfb475438	be2b7cf1-5f71-b37a-ffda-438dfba6a272	8606d7b7-fb12-5bc8-fcc8-438dfb8c13a6	2005-11-30 19:21:59	0
32fb546f-731d-e570-c62d-438dfb683f21	3161d160-3b14-d480-b56b-438dfbfb8e05	ec620ae9-1b97-e528-2707-438dfb142f20	2005-11-30 19:22:00	0
9c37094e-4206-d661-2a4a-438dfb01b108	9a9c94d7-5a1f-c63d-9ccc-438dfb4dc013	44567144-d98c-55ff-600a-438dfb9b05e7	2005-11-30 19:22:00	0
cc599533-57e1-6358-21ee-438dfb470d40	cac9e771-a4f6-4711-6a91-438dfb0a465b	ad9d4f16-4948-5b22-c2a5-438dfb42471c	2005-11-30 19:22:00	0
3f8bdcca-8171-b069-e8c6-438dfbb5d910	2270bf07-35a9-31ab-e5b8-438dfbbc1400	ddbbf86c-83d1-1323-7353-438dfb2cde8e	2005-11-30 19:22:01	0
6fefce78-fc69-6612-d0b6-438dfb16f628	6e5f3c74-086a-04fa-15c1-438dfbc15e98	50f592cd-46e8-38ec-8bc4-438dfb69255a	2005-11-30 19:22:01	0
be52ccc4-f71e-c951-c50c-438dfb198de6	bcbcfeb3-78e4-c2d2-df69-438dfb02aa8d	83ebac8d-3061-b06e-e9c2-438dfbc1c1b7	2005-11-30 19:22:01	0
ee85f241-97d3-81fb-b990-438dfbdc8d2c	ecf4702a-6f2e-50de-15ca-438dfb78ae0c	cfae570c-8617-1ed0-9552-438dfbbed9a1	2005-11-30 19:22:01	0
61fee87e-df0d-78ee-426d-438dfb476f3f	606caf60-b1bc-8ba8-2954-438dfbd67107	bd2e0f70-1ee0-114b-6b3f-438dfb7beaca	2005-11-30 19:22:02	0
b10da5b1-1ea5-9c4f-4e5f-438dfbddaf12	af74599a-74d0-c570-4728-438dfb78321f	73d068dc-4ebc-f503-320a-438dfbbe3b7e	2005-11-30 19:22:02	0
929c0a69-6005-97b1-034d-438dfb092dba	797504be-998c-71c0-3b7f-438dfb01a387	c25cd6b3-3646-b570-d9c9-438dfb849f55	2005-11-30 19:22:03	0
39674ccc-a9c1-d0d9-fbcf-438dfb503f71	37c53378-d432-bbdc-98de-438dfbbbe6e2	1a933345-5bdc-a589-eb6d-438dfbf1c77c	2005-11-30 19:22:03	0
8895d23a-07be-2099-2825-438dfb778941	86e0e874-75b4-15ae-5725-438dfbadd5d3	4ab47181-24ce-f863-8995-438dfb35ea06	2005-11-30 19:22:03	0
d6a784ab-aa35-6a49-3223-438dfb03c479	d50db904-5e4f-d353-726b-438dfbbf6650	9ad78299-6c72-66e4-74d1-438dfb8d9bcb	2005-11-30 19:22:03	0
4d0eac92-1f7e-4dec-b2e3-438dfb2403e6	4b6b6548-8ff0-5d0f-7fad-438dfb99072f	e85ffc5b-c699-2dbd-c014-438dfbaf09a1	2005-11-30 19:22:04	0
9da81804-c145-9cea-ded6-438dfb258443	9c122c61-e559-b813-4103-438dfbe4ecd7	5f03bf7a-fd7e-e9a7-db69-438dfba8a354	2005-11-30 19:22:04	0
ebd8e8ba-1763-8aa7-f12c-438dfb7370e3	ea2ee7ba-7dd5-959b-b577-438dfbef096e	af8cf563-7e1e-cbda-c837-438dfba030fb	2005-11-30 19:22:04	0
458f7594-3d57-3c78-7178-438dfb43fd55	43eeb21c-c93f-c150-2716-438dfb0289a6	98c806a1-600c-08bb-697c-438dfbc8eb58	2005-11-30 19:22:05	0
ced2b813-1b4a-2229-aa20-438dfb11139f	cd29045d-c4cf-6807-e70a-438dfbe5680f	571ba74f-afdf-9159-0899-438dfb3eb14d	2005-11-30 19:22:05	0
814d819c-4b21-d58c-6e03-438dfbfe4098	7f6a8cec-2988-639d-46c3-438dfb567162	e0418399-719d-3607-9e7f-438dfb72fae9	2005-11-30 19:22:06	0
ce440f9e-909d-78a9-821c-438dfb4ffd99	ccb60f42-0987-a640-093e-438dfbc36217	92ab49c9-ee9b-e5d2-43d8-438dfb969816	2005-11-30 19:22:06	0
a3cc0c0f-f135-452a-52eb-438dfbd98e21	89df0c3b-c3d4-5963-1ad6-438dfb0873b8	df7de535-ff70-7af4-cb91-438dfbc9af09	2005-11-30 19:22:07	0
944745c5-d01e-66f7-8063-438dfbaad629	92b8b64b-06f2-396c-e156-438dfbb0dccb	1bb1c78c-3ccd-b176-be2b-438dfb317c0e	2005-11-30 19:22:07	0
e16c28e8-a61a-69f1-d520-438dfbaab888	dfdc405f-9153-50f9-44d3-438dfbf7cd6e	a5b8eb90-51f1-e1ff-ad22-438dfb208ceb	2005-11-30 19:22:07	0
3ab49d58-b41c-d70c-0264-438dfb3a444a	3919615a-a53b-190c-94b7-438dfb617976	f2df2e86-0c13-c5ba-c500-438dfb56c033	2005-11-30 19:22:08	0
8abcd0c8-3962-7a42-9f84-438dfb63106c	8927ebd4-87e9-1a4d-ff74-438dfbe89fc9	4c13abc6-b8e1-c1ae-8ba7-438dfb9ec64a	2005-11-30 19:22:08	0
bad08033-9ce4-31c0-73f6-438dfb8c7f1b	b9362ff7-0d55-b46e-4b08-438dfb663f12	9c1b9f81-bfac-e57b-5ffe-438dfb441499	2005-11-30 19:22:08	0
149bd420-5175-60de-a1c7-438dfba842d9	12c375c1-be90-45bf-3bdd-438dfbf1deb3	cc387178-6c46-a15a-2fe6-438dfb374c74	2005-11-30 19:22:09	0
8343cf78-5009-9549-b5a1-438dfbe4f624	8166a64a-4a81-06ae-b1b0-438dfb814a57	268fd281-bad6-2ceb-8bbc-438dfb22fc8c	2005-11-30 19:22:09	0
b34f6b44-c4ff-c453-8cb2-438dfb0f717e	b1bf390c-6fe1-a333-237d-438dfb28671c	94982e2e-3f66-9441-e92b-438dfbddd2e5	2005-11-30 19:22:09	0
cd7503a9-6017-2a04-a666-438dfb33eff1	b4570356-f8fa-7915-632a-438dfb3d6edb	c4aedb48-1af4-dc3f-f3c7-438dfb1a48c0	2005-11-30 19:22:10	0
9925558f-e1ee-ee43-0eae-438dfb2a8fb4	97783bed-965b-277b-b690-438dfb372d6d	1e63f0f0-a1bb-ec9b-b3b8-438dfbc720ee	2005-11-30 19:22:10	0
c961e8bf-a275-a857-3be2-438dfb331126	c7c317ca-4a0f-64f1-b509-438dfba328c1	aa8b2195-f958-e7d7-9ddb-438dfb8ebf80	2005-11-30 19:22:10	0
58e50043-dbab-b472-968f-438dfb94c13e	3eef09e2-000e-be9e-84a3-438dfbeeec35	daaf0fbd-ade6-d9bd-38ce-438dfbb8b158	2005-11-30 19:22:11	0
7222351a-7e4c-5a60-3421-438dfbe686d4	708cfcf3-b44f-22fd-3cee-438dfbf573b7	16ede1f8-2014-d5da-74e5-438dfba39ec3	2005-11-30 19:22:11	0
b50e0fc1-010d-d9d0-6b78-438dfbef39a2	9ab907e9-70e5-b254-b72c-438dfbd91f9e	863ce0cb-c3b2-a2e2-3c24-438dfb60a8fd	2005-11-30 19:22:12	0
3bcb7a59-73de-a840-afe3-438dfbe159f4	3a31f343-b3a2-25aa-0aef-438dfb275b9a	1d21fa61-f1ec-b3c3-108d-438dfbc1ba7c	2005-11-30 19:22:12	0
8da971ab-95f7-f98a-37ba-438dfb0d59c3	8c063ab3-792e-7fff-07af-438dfb362e9f	4d1789b7-3e5c-005c-5bc6-438dfb48ed0c	2005-11-30 19:22:12	0
bdb8d457-0584-dab3-8183-438dfb4c6950	bc19f618-92f4-0b25-6b19-438dfbf0e871	9ef17cae-5cff-52f2-b8f6-438dfb8a9336	2005-11-30 19:22:12	0
184405a7-59f3-c561-3a5f-438dfb027fa2	16afe3ef-bc1f-03f2-f3f0-438dfb6e0815	cf131d8b-9fe6-7663-f52f-438dfb9b02c6	2005-11-30 19:22:13	0
48432895-5ecb-bf4c-a513-438dfb95782a	46b45f58-1096-ed96-a304-438dfb18ae25	29836014-3a39-deac-1cd1-438dfbac8ab2	2005-11-30 19:22:13	0
999f681e-8513-5ed5-3370-438dfbe6b8ab	980111c7-e70c-063a-0af2-438dfb7c608c	5998aee4-86a3-263e-e38c-438dfb952cd8	2005-11-30 19:22:13	0
ca25be66-3ea0-3c8a-4713-438dfb9911e0	c88932f9-755e-1bb3-389a-438dfbd73ab7	ab04e4f7-4808-7a3a-9d6a-438dfb8750ef	2005-11-30 19:22:13	0
45c39131-c55f-0d11-5f62-438dfb254c10	442abb64-0987-618a-4a53-438dfb615010	dc9c513e-6661-d1ce-f317-438dfb5c6d58	2005-11-30 19:22:14	0
7609ea3d-ddfc-08e7-1033-438dfb842080	7463343b-f16b-e43a-a354-438dfb3db275	571e34d2-5904-1c4e-fb8e-438dfbddf351	2005-11-30 19:22:14	0
c803379b-3d69-e994-c28c-438dfb8113a1	c65ca740-d010-521a-49aa-438dfb244146	8a079568-e82a-9f09-d3d4-438dfb37c239	2005-11-30 19:22:14	0
3f160c95-2935-e353-5173-438dfb8b1049	25c20011-2a71-ca47-8fb9-438dfb51c6fd	d94d9c49-9e7e-6f02-e077-438dfb93f40f	2005-11-30 19:22:15	0
34ac0523-6f44-3b00-da27-438dfb86a8ac	33104df4-d49d-982b-4a73-438dfb045c7d	1567c52a-c9fa-8585-e646-438dfb66bda9	2005-11-30 19:22:15	0
64c7f19c-7162-fc65-60b6-438dfbc5a248	6326c466-c2e9-884e-edeb-438dfb8010f7	460a8351-5516-8efa-cc7e-438dfb3ec28b	2005-11-30 19:22:15	0
b707f3d3-1a8f-7491-a6e7-438dfb317a9d	b574b4c8-14e1-18a4-76a8-438dfb9df297	7668abc9-efc4-f8c6-4968-438dfb4d1ecc	2005-11-30 19:22:15	0
e72df3e5-6c2c-da8c-2eb4-438dfb670982	e593b266-01fb-266e-e2b6-438dfb280b05	c8788aba-6a1e-c258-caf7-438dfb46e44a	2005-11-30 19:22:15	0
42e74972-bfc0-93d0-80a3-438dfb299e74	4154083b-0c05-6ab8-b939-438dfbe58e6f	477701eb-6645-9ccb-33d7-438dfb7ba579	2005-11-30 19:22:16	0
d5160381-d62e-3061-b2e4-438dfbd0a435	d370e5dd-5063-f8c6-a75a-438dfb26fe34	543e70ac-6e33-8917-5565-438dfb360fb5	2005-11-30 19:22:16	0
328d1c11-61be-c3f0-fb93-438dfb45aaea	30f41350-9956-1865-9628-438dfbedc29e	e75c3ecb-99f2-dadf-5d15-438dfbf076d3	2005-11-30 19:22:17	0
86414e05-c31c-e8a7-6951-438dfba6c0ff	84acd2eb-c778-68c8-99f4-438dfbde5383	443cbfd7-d176-1227-049b-438dfb1483d1	2005-11-30 19:22:17	0
d7a3cce7-f080-0a6c-0d47-438dfb701b3d	d6091bdc-caa6-6316-6377-438dfb95cb5a	981fe79f-b6ca-8f21-c19c-438dfb4c4ebe	2005-11-30 19:22:17	0
14e94c49-f108-02f0-30e9-438dfbe4ec11	1340ac91-ddc2-fb82-4022-438dfba0e98e	e969de4c-f3b5-0f2e-b5ac-438dfbeb1d30	2005-11-30 19:22:18	0
46471b34-63a9-0470-e6b9-438dfb306ab3	44a73d5b-41d6-d55e-e52a-438dfb042ad1	26d4ce17-e466-3006-20f2-438dfb6b462a	2005-11-30 19:22:18	0
768907aa-8b34-377e-2ab5-438dfb18a25e	74e62010-41ef-111b-9225-438dfb5ccf30	579dad95-4140-81fe-b554-438dfb1a04c7	2005-11-30 19:22:18	0
a90ed4b8-c61a-03ff-4f8e-438dfbfe83c8	a77ae199-7870-dda3-c992-438dfb83f576	8a6dd188-d156-8ec3-3281-438dfba5aeaf	2005-11-30 19:22:18	0
646002b5-4189-4c73-efdc-438dfbda744d	4b520c3f-b00a-d07a-c5d4-438dfb818be4	ba82c3c4-e4ec-b757-fa28-438dfbd013aa	2005-11-30 19:22:19	0
57d38dea-e8de-0dde-2993-438dfbcc0955	56391242-a684-5821-0476-438dfb07b70e	17d4f4fb-a181-0c9b-821a-438dfbffc092	2005-11-30 19:22:19	0
cc44baaf-9611-5542-d144-438dfb4f384e	cab00ff7-dfed-24be-5782-438dfbbfcc29	69938c8b-9b0b-4890-abe3-438dfb85413f	2005-11-30 19:22:19	0
49a15ce8-76e1-e49a-9f8e-438dfb07539f	4801d31d-31c4-2b7b-f0a2-438dfbc06eb7	a3e600ee-970a-cee2-8b37-438dfbca1077	2005-11-30 19:22:20	0
de7ec5ea-cd38-498b-dd4b-438dfb9b53a1	dcda72bb-1e05-90a2-5fd3-438dfb5dd8b4	9f11ccea-052b-e25c-6624-438dfb271b6e	2005-11-30 19:22:20	0
1a8d390c-380c-bc9d-8364-438dfbcf5bef	18f4ff09-a967-17c1-7336-438dfba49491	efe77bde-c437-665f-9060-438dfb780bc9	2005-11-30 19:22:21	0
8f565831-0400-673d-6790-438dfb3b4dc7	8dc56e36-e556-7985-bbe0-438dfbf14c5c	6e0daa10-3e3b-58ad-c869-438dfbfedbd4	2005-11-30 19:22:21	0
e07bf186-ad9a-33c6-d14e-438dfb8c6878	dee8db69-4d37-a95f-96b6-438dfbe70848	a0b9b02e-61de-5f22-07ed-438dfb253137	2005-11-30 19:22:21	0
1c9a23c3-30fc-a4ad-0dfc-438dfb523b3a	1b06ca73-cecc-2903-dca8-438dfbda1609	f1d43701-d60b-cd1a-e59e-438dfbc6cdb6	2005-11-30 19:22:22	0
4c8a7570-2921-a8c5-474f-438dfb9a7a62	4ae4ea6f-9a81-b631-313e-438dfb1617cb	2dcaf8ac-1e3b-52e5-2f79-438dfb2abe72	2005-11-30 19:22:22	0
c1c9876e-d533-dfcd-d164-438dfb4731fa	c02fd92a-56a7-ba19-2202-438dfbf6868e	5df5e2e9-5db1-4193-bd90-438dfb97c738	2005-11-30 19:22:22	0
f236f0e9-17d7-2c17-27d8-438dfb42634b	f09fdcd1-7e18-6d64-dd5b-438dfba6e8b1	d36355c8-e0d2-1427-3d27-438dfb8d905d	2005-11-30 19:22:22	0
2e6bc788-c585-3fc2-7fd4-438dfbe3da5e	2cd69e26-76d0-21ec-d73c-438dfb11891f	fa620e7e-59f5-1a0c-c09c-438dfb095eb5	2005-11-30 19:22:23	0
5ec1297e-2067-090a-a9ff-438dfb1c1204	5d2fb8ef-5010-3296-8d6b-438dfbea1cec	3fe3554d-2b2d-aea4-8ef6-438dfb9dcb8f	2005-11-30 19:22:23	0
d4d4475c-ee64-edd1-8949-438dfb3a1136	d3365996-38e7-fb88-1ae8-438dfbb39199	703c1b7e-8570-46c2-7f7c-438dfbf84b5f	2005-11-30 19:22:23	0
54a7942e-0aaa-4318-ccb6-438dfb01fa30	52eb33ea-8a43-bb9d-7ac9-438dfb31378e	e6576172-75fb-f3d3-7b86-438dfb157db9	2005-11-30 19:22:24	0
88c3d808-9cfa-7a5c-f786-438dfbf0c749	86f027b4-2426-b87d-abb2-438dfbce9837	66fa9906-6c40-fdf0-a2e1-438dfbfe512b	2005-11-30 19:22:24	0
b97c865a-3fbf-a2cd-0705-438dfb11d714	b7df7728-4909-f3b5-c09f-438dfba69779	9a1f12a5-9343-222f-e3e6-438dfb777755	2005-11-30 19:22:24	0
1776ca3b-df64-4350-4e60-438dfb8e5c21	15e38d79-df3b-68c5-44db-438dfbce45fc	cad99cf8-0af8-2048-a57a-438dfbdb0c2a	2005-11-30 19:22:25	0
47743412-cc30-2c6e-9593-438dfb143dc7	45e1dfdf-f9a0-fb55-ff83-438dfbec9ca1	28db0226-8ff5-a194-6afd-438dfbd26c02	2005-11-30 19:22:25	0
e0872f16-441e-d268-714e-438dfbe642be	9aadf32e-a24b-f163-e070-438dfbc19e1d	58e70e90-21d7-2d97-f046-438dfb7c28a5	2005-11-30 19:22:25	0
3f1ab58d-f4b8-e1bb-807a-438dfbe2d343	3d87d483-6d54-a315-b986-438dfb93ea7a	f1f9a52c-3d9f-93d1-3fec-438dfbc77c32	2005-11-30 19:22:26	0
b6654dbe-e7c7-ed86-4e0e-438dfbfcb4d2	b4ce489c-c04f-0811-3a50-438dfb674f66	508543b2-9c94-99cb-e595-438dfb2abb6d	2005-11-30 19:22:26	0
e6b78825-ec55-59a3-81fb-438dfbb761df	e526a2da-9e25-d27c-d0a4-438dfb7ae3b9	c7d12a8d-0403-3ab7-a0e3-438dfb2d63d6	2005-11-30 19:22:26	0
22e0008b-ee5d-ccc9-bc19-438dfb7e9ef6	214776e5-3bcc-5374-2e09-438dfb778832	40300bde-e741-a773-4a15-438dfbeee35a	2005-11-30 19:22:27	0
be8f472e-ada8-6e28-2e49-438dfbd9459d	bcf4055c-e49c-3ba2-f46c-438dfbb06f47	347267d1-c06e-b7b5-fa65-438dfb8e8dd4	2005-11-30 19:22:27	0
6a74385f-4968-b349-4b72-438dfbbbb9c0	68d4afd1-2c23-2687-4cc5-438dfbb2ab43	d7b82553-166f-c86f-4feb-438dfba34ec5	2005-11-30 19:22:28	0
1190dae5-84b2-880c-3c4d-438dfbbb9352	fe0d0062-2e34-f6dc-060c-438dfb36afe3	7be641b1-ecdd-a545-3bbf-438dfb50769a	2005-11-30 19:22:29	0
6515d410-f91f-93e5-62d2-438dfb0dbde5	6379dc29-6346-3bfa-fd15-438dfb8cb345	22f4419a-563a-4a6f-ab54-438dfba24b49	2005-11-30 19:22:29	0
bb218fa3-651f-c885-bb91-438dfb34f9a3	b9900f71-4f06-9c97-0369-438dfb0b6b90	76e613b6-66dc-da59-7dc3-438dfb4fff7a	2005-11-30 19:22:29	0
f0867b15-0dd4-c8de-392c-438dfb294042	eeee7ca9-c4f1-11d6-ae78-438dfb59a2ae	cc7d000d-19c9-bb48-44fe-438dfbef8917	2005-11-30 19:22:29	0
74b769aa-93f0-4726-f8cb-438dfb77c732	731379a5-71ea-d31b-c295-438dfb8b45bc	dcb5074e-614a-78ef-f0ab-438dfbd631ff	2005-11-30 19:22:30	0
a8c5e569-1c7e-b548-7bf9-438dfbfa80f2	a72397ea-f813-c02a-95ca-438dfbfb91eb	89475c72-6b72-9ca4-52f2-438dfbd736d1	2005-11-30 19:22:30	0
da558667-4d60-71d2-ede6-438dfb4b0fb4	d8b0f146-1a91-13c0-3a72-438dfbde557f	baa43c5d-69de-a271-0c25-438dfb74fea8	2005-11-30 19:22:30	0
a8a2e3ee-0549-4313-3771-438dfb462389	a6f9bf5b-0675-c0d6-e85f-438dfbdbd981	ec1efaef-ce0d-bb93-ebfe-438dfb73d939	2005-11-30 19:22:31	0
da17155e-36a8-7986-e5e0-438dfb345f8d	d8767e81-c450-d545-ae63-438dfb4916ae	ba751781-d364-4a0d-5de6-438dfb165ad5	2005-11-30 19:22:31	0
659a8a2e-616d-4bdb-316f-438dfbf2be3a	63f58ccc-e492-8d89-0d6b-438dfba946ea	f1cfb3dd-1cb4-eeb4-60f4-438dfb0c1b12	2005-11-30 19:22:32	0
98b5be16-9328-8ad6-9ee8-438dfb6c0d8e	971d5ad3-a70b-db64-a717-438dfbdb260d	77504603-324f-a0d3-a501-438dfbdf4697	2005-11-30 19:22:32	0
1c99e192-1ffa-9c14-e1a0-438dfb7bebc7	1ae50d23-8f86-8c43-1229-438dfb03f31c	aa1defb3-634a-3879-f66d-438dfb8513c3	2005-11-30 19:22:33	0
710e1d76-6386-e05d-6a5b-438dfbecb8fb	6f6acc46-a1ad-fe2c-b5a2-438dfb992013	2dfe29c0-10b8-8b37-ef7c-438dfb8c33e1	2005-11-30 19:22:33	0
c84c7320-1ba4-0229-ba1e-438dfbb44c6b	c6aabb4a-0296-4cea-df32-438dfbc0990a	82c2ab66-d0ac-9766-3603-438dfb6fd1f5	2005-11-30 19:22:33	0
288f9571-1518-dc6e-42ac-438dfbcdfa7b	26ef8127-7d96-8b76-44c7-438dfb23530d	d99ac000-1591-f7d4-645b-438dfb9c52a9	2005-11-30 19:22:34	0
58e5876e-dabb-d253-b557-438dfb9d2ea6	5744b753-4a28-a8f3-28bb-438dfb2b912d	39f27a0e-0400-fa81-07dd-438dfb57ce13	2005-11-30 19:22:34	0
d527b114-d99a-9ee6-398b-438dfbb6be22	d379c12b-4710-241e-384e-438dfbbbd559	6ad22ccc-c235-de00-80c7-438dfbeb8caf	2005-11-30 19:22:34	0
59f0fcd8-5503-f302-b8d1-438dfb4deb68	58542c90-1b49-7055-d17e-438dfbeada52	e69e09bd-23e8-b36b-3e3a-438dfbb1062d	2005-11-30 19:22:35	0
b14ed1f2-fb6d-0c40-f1a8-438dfb19f653	afb57170-9d7e-91f2-409d-438dfbb5d79d	6b7e6016-b265-3ba5-ff42-438dfb51a9ed	2005-11-30 19:22:35	0
1209ddd7-2037-2329-930e-438dfb20a39c	106a24d9-484d-89e5-2e8e-438dfbf3b6ef	c2bb3f7c-9af5-a61f-a3e2-438dfb7727a9	2005-11-30 19:22:36	0
672d0ccf-bafa-99ba-ea41-438dfb111219	65857415-903c-e84e-7a3a-438dfbb4ea4b	239a9544-7bdd-167e-07bd-438dfb299c59	2005-11-30 19:22:36	0
bf150fff-89ce-9aa5-cb3b-438dfb759a8d	bd7fc240-38d0-9a21-f408-438dfb78a7c8	78ff9990-540c-dd40-27c5-438dfb183793	2005-11-30 19:22:36	0
2016451f-033c-0b11-9288-438dfbb8d448	1e8192ee-90f5-9e62-20fd-438dfbbd87c3	d0923769-e322-cf84-3521-438dfb84c9ca	2005-11-30 19:22:37	0
756470ee-fd45-3bd9-f68d-438dfbdd32ea	73d1ce48-38bb-fb39-125b-438dfbfcd535	31737d1f-1289-7fcd-5d14-438dfbd580bb	2005-11-30 19:22:37	0
22cb4b37-ab71-677c-d77e-438dfb34d928	2120eaa3-e4ce-aac8-8282-438dfb13c9d5	895cc6e7-0091-44a7-21a6-438dfb1d162e	2005-11-30 19:22:38	0
ea06038b-9305-27f2-087d-438dfbc5b781	e85e5704-236d-95b0-c913-438dfbb27265	343b349e-f4d2-005d-0269-438dfbc49cbb	2005-11-30 19:22:38	0
27a1cc94-011c-f545-0274-438dfb6ef391	26003f57-f147-1296-9b07-438dfbd54997	867109fb-918b-35a3-7cfd-438dfb68d6ff	2005-11-30 19:22:39	0
7e58c9fa-1243-eccd-f380-438dfb908cdc	7cb9e579-5824-c66e-feaa-438dfbb13d76	3931744b-5e96-d2da-5dd2-438dfb47595f	2005-11-30 19:22:39	0
78c305bd-8c18-fabc-0bcc-438dfc0ead24	5f5b0402-2333-b0a8-d5f7-438dfcd4465a	9257041c-6deb-f667-eccd-438dfbc973ff	2005-11-30 19:22:40	0
d00ed613-73b1-7fae-5216-438dfcc9f0a9	ce6e50fa-639b-3001-cbd2-438dfce21449	19132155-4eaa-cd95-cb9f-438dfc5af020	2005-11-30 19:22:40	0
57babd1d-72df-de19-bc64-438dfc73ff7a	561eb0b9-9791-fb94-9699-438dfc37a65e	e1806030-63f9-3872-1154-438dfce4e5b8	2005-11-30 19:22:41	0
8aa788d0-7c11-547a-a13a-438dfc9c2fed	8698a308-501d-aa14-34b7-438dfcc4ff72	692d3a91-9858-15f9-05e2-438dfc10aa6e	2005-11-30 19:22:41	0
121bb197-c44f-61ac-0850-438dfc06f565	df089e63-a5c1-eb04-dc5f-438dfcb8b6ec	9c4c03e1-b5b6-b2e3-ef3a-438dfc80f2ff	2005-11-30 19:22:42	0
682f2985-73af-7744-2a5b-438dfc61be3f	669c582a-f20d-5d1c-c998-438dfc1da6eb	23c14364-2b8a-f05a-56c3-438dfc3bd2c7	2005-11-30 19:22:42	0
9b594505-09d1-9921-4069-438dfcf7c020	99c64088-3935-0880-90bb-438dfc0e4754	79b00146-200c-599b-f545-438dfce60df3	2005-11-30 19:22:42	0
f150ff81-d255-7256-6b5c-438dfc492e29	efbceb46-a1b9-763b-b6dd-438dfced69fe	aca283ec-2e56-abb8-9776-438dfc574914	2005-11-30 19:22:42	0
536eff93-979d-53cc-e1d7-438dfcacd0b6	51d9ffc7-957f-d421-09f0-438dfc17ef76	e8a00854-eae8-47ff-d743-438dfc6b7863	2005-11-30 19:22:43	0
83b41aa8-c9eb-2f60-2e70-438dfc05aff3	821bce65-fddd-5dae-50ee-438dfcb31428	64c05cfe-ac02-e2d8-12bc-438dfc8b0aaf	2005-11-30 19:22:43	0
ec220693-d6ff-bb76-309d-438dfc57b7e9	d19d0641-fb2f-daae-545c-438dfcaa1fa9	97ac316a-488e-ce89-1fc8-438dfcaec675	2005-11-30 19:22:44	0
40de6148-5320-5b40-18d4-438dfc088c76	3f3e343b-635b-9550-19e7-438dfcab706b	20de29e6-39cc-7c65-c97a-438dfceb2640	2005-11-30 19:22:44	0
9c3f8ea2-f309-23f0-d806-438dfcb3e6cb	9aa64d05-7734-d195-86da-438dfc1d4845	52d5aba1-bdec-b7ce-1ae1-438dfcf4428b	2005-11-30 19:22:44	0
cd64c30f-c31c-acb6-b0d5-438dfcdac315	cbc920fc-a60e-d22d-1e66-438dfc0bd753	adff7314-4992-f2b0-e2b0-438dfc5eb6ad	2005-11-30 19:22:44	0
580db94f-07dc-3cad-6aef-438dfc452fd4	5676d62d-d706-568f-2ba3-438dfc059083	df394a46-8924-6ce8-24e4-438dfcc0045c	2005-11-30 19:22:45	0
b315d567-6b66-cd53-5649-438dfc633c8e	b174d27b-cb80-d100-fa5d-438dfc602b1d	69f6e1fb-cf31-0283-314d-438dfc773540	2005-11-30 19:22:45	0
3d1fdb11-c3a0-f54a-eb84-438dfcaa190f	3b8ccf9a-b36c-02f4-5a68-438dfc09b6af	c4ea893c-9696-f55c-d060-438dfc022203	2005-11-30 19:22:46	0
6d5144a0-049a-327a-2ca5-438dfcd3bdbc	6bbb5b0c-1a54-d391-7c4c-438dfc4698f8	4e7fb6cc-21c4-f851-9763-438dfcbeec1d	2005-11-30 19:22:46	0
c734484c-77b7-7f27-2010-438dfc364644	c59fba97-8974-3bd9-3514-438dfc2c1b81	7ed9e009-9cd7-4eac-0a05-438dfcb6bd57	2005-11-30 19:22:46	0
5157b8c7-58fa-83c7-4642-438dfc7df937	4fc59f52-627d-a23e-7665-438dfc323b58	d890703c-8f14-175c-2d29-438dfc486f5d	2005-11-30 19:22:47	0
ab4d152a-afc4-ce72-11cc-438dfcc6a39c	a9aae895-be66-2cc4-4ae8-438dfcec3a85	62ca07a3-8432-3273-b5d3-438dfc2ffcd4	2005-11-30 19:22:47	0
36615d42-7459-a6c2-5ae9-438dfcf6bdc1	34c373fd-c249-fcd8-9384-438dfc9cf6dc	bd1e34d7-2283-d1fb-ea70-438dfc3d837c	2005-11-30 19:22:48	0
90a778dc-c097-4f07-83d6-438dfc597223	8f0d383b-3ab1-da69-46cc-438dfc548e82	47ce2c70-6514-da71-de9d-438dfc189dc3	2005-11-30 19:22:48	0
c10eb00f-7a55-7be2-cf3e-438dfc85e814	bf77d5ad-79f1-3240-3d6d-438dfc463053	a26b4d1a-8d73-2beb-6552-438dfc7b122d	2005-11-30 19:22:48	0
4c547988-3043-0a7d-63ad-438dfcccaaa4	4abaccf1-4196-6eee-a4c2-438dfce2c50f	d2a10099-e3ec-17a9-b47c-438dfc811b36	2005-11-30 19:22:49	0
cf110336-5ff2-4438-1d3d-438dfc887cc3	cd7c0a77-faa6-6826-fde4-438dfc2c1e2b	5da2f2ef-631b-b399-81ec-438dfc34c906	2005-11-30 19:22:49	0
32ed9366-ca45-5e1f-46cd-438dfcdb2e11	3157da52-c586-c013-0e8d-438dfc26ee2b	e085ffea-a012-5b9a-928e-438dfca18c8b	2005-11-30 19:22:50	0
8d903ba0-cc58-8479-8ef9-438dfcbf25ef	897a9222-60a4-e635-4738-438dfc333ccf	445d98cb-2bb6-5a5a-7e25-438dfce95daf	2005-11-30 19:22:50	0
e5d1f306-4bd0-3592-1557-438dfc54865e	e43aa64a-b701-ec48-ae92-438dfca3769f	9f3832b4-60be-268b-9145-438dfc8b7a6e	2005-11-30 19:22:50	0
21d86b7f-9822-5803-3e68-438dfc1f7f36	203c1477-7f18-fd09-9a1c-438dfca23fe8	31a30751-21d5-38ab-56e8-438dfc995474	2005-11-30 19:22:51	0
a501fe17-e2e4-42bb-c8f4-438dfc4afa18	a358c6d8-7975-44f6-f885-438dfc471e8f	3348b98e-721d-c914-852f-438dfc65c395	2005-11-30 19:22:51	0
597cec8c-87fd-59d5-6a17-438dfc8951d8	57bdd594-31b6-6c2b-7243-438dfcbca211	b654628e-362d-8623-200b-438dfc160cb2	2005-11-30 19:22:52	0
b4a873f5-bac1-11e8-bd90-438dfc906c67	b3141aa1-1c11-11ce-a07a-438dfc2ffc48	6ae0a1e2-cece-b38d-237a-438dfc684d06	2005-11-30 19:22:52	0
1939e441-8cbe-7548-d819-438dfcd704d7	1799dd6d-f5fb-3549-0137-438dfcdb0352	c61b206d-2e30-b36f-eed5-438dfc73c046	2005-11-30 19:22:53	0
49ac7000-0848-b53b-cfcb-438dfc9c154d	48120ecd-216e-7546-9f30-438dfca09e12	2ad884a9-8705-3671-3b1b-438dfcf263fa	2005-11-30 19:22:53	0
a583000d-9016-1b37-a7cf-438dfcd1489a	a3e763e5-3a0f-d50f-659d-438dfc062025	5b392773-b350-e644-1e5f-438dfc976788	2005-11-30 19:22:53	0
a07a0524-3b9a-cdca-cafb-438dfceea7f4	876000a6-8419-8b7d-c55f-438dfc2b233f	b6f3e8a1-3732-6193-0153-438dfc83d486	2005-11-30 19:22:54	0
6329afb4-edf8-fc6b-395a-438dfcffec82	6195e9bc-6e90-c7b8-fb3a-438dfc3f869e	1ba04981-4ef6-6ed0-8e17-438dfc1eb2f6	2005-11-30 19:22:54	0
1d212fd6-9c7c-7a6b-e088-438dfce7ac9f	1b7b5699-5918-ff6d-9b37-438dfcacbde4	7492d5ae-dfba-6e60-5f6b-438dfc9ebfe6	2005-11-30 19:22:55	0
7665cab7-b60c-a854-be21-438dfcfa4152	74d0d401-a9b0-54e5-25a3-438dfcd7778b	2ea7c9d3-0784-d9b9-2a4b-438dfcf8c620	2005-11-30 19:22:55	0
a9571eef-ba01-5eb9-d867-438dfcc763a1	a7c42568-08c9-6462-2604-438dfce1332e	88142010-9a16-7fad-97d5-438dfc2da9d0	2005-11-30 19:22:55	0
61161a62-2aa9-b7c6-c830-438dfcc73c75	5f629f82-e890-a7bf-4879-438dfcaf8561	bad8904a-8332-da27-a94c-438dfcaefdb0	2005-11-30 19:22:56	0
bd0ce117-acdd-bc79-9bb0-438dfc53d10d	bb7644a0-c0ab-9559-0ae5-438dfc192f84	7285b03b-f984-af24-7766-438dfc2d4fd1	2005-11-30 19:22:56	0
4c123b45-dd35-bb5a-6367-438dfc4df41c	4a6fc8ac-7159-01c0-1880-438dfc27f881	ce702aea-7cc2-7743-d67d-438dfc418801	2005-11-30 19:22:57	0
a879b1b9-d144-4f69-4b37-438dfc04088c	a6df1319-7276-f2ee-f4c4-438dfc39217b	5d7daa65-e669-d1cc-a6fa-438dfc8de07d	2005-11-30 19:22:57	0
38359b1d-8c99-14c8-05ec-438dfc7d850c	368de2f0-1bb7-5952-441a-438dfc41684a	ba5dd704-982d-5927-37a6-438dfc7f3e9b	2005-11-30 19:22:58	0
c01d6a25-a4a6-38e2-e0ff-438dfc9812f3	be7d639b-3ef6-90b0-6a37-438dfc74bca7	4a1ee6a0-25ee-6a7a-f7a5-438dfc317653	2005-11-30 19:22:58	0
f1a817b7-1cb8-73d2-29b0-438dfcdddd9f	f00ab81c-c579-e4a2-7721-438dfcb817f5	d1ddc9ee-af9d-f257-89be-438dfcdc46fc	2005-11-30 19:22:58	0
2f0f08de-73c5-b309-be2d-438dfc28a844	2d6e0847-3e3d-1e6c-cb2b-438dfc5ba94c	f5da0877-97a9-1cc3-c0ad-438dfca40468	2005-11-30 19:22:59	0
8aaac0ab-f2ed-89cb-b5d3-438dfcb01646	88feeb39-e56d-6d42-026e-438dfcb89b9c	40f5032c-52e9-76ab-c376-438dfc53b0e6	2005-11-30 19:22:59	0
e9856260-69c0-9f2a-c29a-438dfc8d4da0	e7d14997-01f3-d505-580b-438dfcac081b	9f4db6ad-aeb6-b920-a4d0-438dfccfb949	2005-11-30 19:22:59	0
551790ba-fa59-9f6e-a149-438dfc7d3fe9	5379f594-35fb-384d-0b47-438dfc6a6f9b	6c780887-b1a5-0c37-cb6c-438dfce0f0d3	2005-11-30 19:23:00	0
df79ff32-7f10-314f-bf41-438dfc2e0296	dde1257e-2eb6-1403-a81f-438dfc217296	6947c741-d69a-c50a-32c6-438dfcfba4b1	2005-11-30 19:23:00	0
9cfe28c9-7a84-4437-605e-438dfc449139	6e8b6f39-3e20-d2a9-a40b-438dfcd53838	f1013808-d829-d48e-3273-438dfc5b4db7	2005-11-30 19:23:01	0
3afa0965-21cb-b7f6-8098-438dfc822dbc	214d0582-1e4e-35dc-0f36-438dfced8b3f	ae8527b5-109f-deea-06e4-438dfcc22740	2005-11-30 19:23:02	0
343857f8-11d6-0cf1-34d4-438dfccbd6ce	329fb010-c120-3057-69da-438dfc2a66cb	15219ad3-ea69-968a-df11-438dfcfc7a29	2005-11-30 19:23:02	0
648c2399-bab6-0a3d-3d3f-438dfcde2d3b	62ef9b95-20b3-4028-2288-438dfc421c31	45b906e0-9cb3-4c7a-df6f-438dfc9be258	2005-11-30 19:23:02	0
97671224-ab64-212b-8a4e-438dfc1b7a98	95bff4b6-f27c-3ed1-6723-438dfc9c26b8	75dbb3c5-710a-b367-717c-438dfcc55f67	2005-11-30 19:23:02	0
c78c3418-763e-49eb-61a4-438dfc03b067	c5ecdbc0-540f-35d8-0eba-438dfc653e19	a8db442f-b908-57c2-4caf-438dfcd5c45b	2005-11-30 19:23:02	0
37780b66-a79a-ff8e-60f4-438dfcec73f2	1e180902-2ab9-86fa-6168-438dfcf136b0	d8fd3433-b8b5-9a6a-8f33-438dfcce7e1e	2005-11-30 19:23:03	0
33a48918-1ee4-a58c-96ac-438dfc867a4e	320a8a1e-ddfb-9b9d-d459-438dfc0ae4ce	14c49ab1-5c89-20b7-c3cd-438dfc37065c	2005-11-30 19:23:03	0
bc4f90de-9def-bb93-7258-438dfc362fd1	baac6caf-0177-1513-22a7-438dfcfa22d5	4529b043-8473-f470-da4b-438dfc4ff3d2	2005-11-30 19:23:03	0
4ec4a903-626e-578f-f1e0-438dfcdeec8c	4d1f9a93-bb94-71ac-6b06-438dfc88c3c2	cdedf12f-00c6-96ab-ead9-438dfc45f071	2005-11-30 19:23:04	0
d8c1f3bb-613b-190d-67de-438dfce5265c	d72df6a2-5094-fe9a-a646-438dfcf38aa1	601fcce4-b0ac-96c8-317e-438dfccc081c	2005-11-30 19:23:04	0
3fe2b7fd-21c0-d4dd-7775-438dfce1abe6	3e47ee4f-77c1-938e-ecbb-438dfc23c0a1	ea0fe542-2c78-f2f9-e743-438dfc119cf8	2005-11-30 19:23:05	0
ca2850d8-4155-9913-c636-438dfc663111	c88bfc69-0324-f0cc-ac03-438dfc14434b	515ebf84-c673-1c9c-f5fc-438dfc99ece3	2005-11-30 19:23:05	0
31b43dcf-699e-fa99-b6a6-438dfc6e164a	301d0fe5-89d7-ef2d-4d2c-438dfc229c51	db95808c-1342-bf59-0da1-438dfcf16624	2005-11-30 19:23:06	0
e7a31e8e-f401-4097-d15a-438dfcabf810	e5e8186d-d414-5646-ff2b-438dfc5fecf2	432ef0db-2c18-bb20-548f-438dfccc8682	2005-11-30 19:23:06	0
508e0291-f13a-f0f3-9f73-438dfc6b0cf2	4ee9be09-de8f-36f6-4317-438dfcc1a6d3	609003bf-2a08-438b-2cdc-438dfca0b6a1	2005-11-30 19:23:07	0
8132acde-53a7-db73-25c2-438dfcf50b2c	7f8ec69a-9928-c4e8-b18c-438dfc8f599e	6204bccd-609d-2069-13ee-438dfc168e35	2005-11-30 19:23:07	0
b4213560-43e6-ca48-2076-438dfc0ad350	b28cb776-7ddf-b167-ceee-438dfc80ed02	94e43fe9-95af-d874-e9fc-438dfcf5d51c	2005-11-30 19:23:07	0
e45e4ecb-7c81-e1f9-8246-438dfc4375cb	e2c86479-26de-764d-5907-438dfc2852c8	c594dad7-18a9-dfa1-5f69-438dfca073ba	2005-11-30 19:23:07	0
20b35efc-173a-26ac-bc5d-438dfc34707f	1f1b7f69-2d8b-fc15-96fa-438dfc4f4544	1988011e-1fb0-7f64-6f56-438dfca9f939	2005-11-30 19:23:08	0
7d22f0e1-6d05-e5bb-2a9e-438dfcca88c0	7b8dbbb1-71c5-33ca-c454-438dfcde10a3	32300f8e-5ff9-1d8d-0510-438dfc3e860f	2005-11-30 19:23:08	0
dc397f30-d47b-6059-5993-438dfc3a137d	da9a0756-3d18-33ba-3858-438dfc0139b3	8e8513ea-8926-9895-3afd-438dfcf13b88	2005-11-30 19:23:08	0
183ad11d-4be5-074f-20f6-438dfc91a5e7	1696af19-3a40-10df-ed0c-438dfcdcb73b	ed96efc5-56ff-f8c8-b303-438dfcf7a76b	2005-11-30 19:23:09	0
bc10443b-023e-f897-c98b-438dfc44514d	ba6ebefa-beef-7d29-8e2d-438dfc9ec741	4206630a-0fc2-0692-269f-438dfc3dce7a	2005-11-30 19:23:09	0
7f245ca9-85ff-20d7-b083-438dfc41df1d	7d5b0889-5a20-f982-9919-438dfcd9783e	cde328fd-1085-f663-68a5-438dfcfb2788	2005-11-30 19:23:10	0
de8984d5-5f53-dcc4-b9be-438dfca1992b	dcf35b98-3242-44fa-afe9-438dfc47865c	90a85cb5-09ae-3944-73d3-438dfc1ece40	2005-11-30 19:23:10	0
472fc599-9435-88c4-f034-438dfc4b05c4	459b0cb6-ecce-f9a5-d9ee-438dfcfe1103	efdf250d-2235-3922-c847-438dfc7f2648	2005-11-30 19:23:11	0
3a84fcd9-dee3-9ad6-c5b0-438dfc3b5a7a	38d640d7-74bd-1af5-c0fe-438dfc90f847	5897fd94-0082-4b99-926d-438dfceb8b63	2005-11-30 19:23:12	0
6c18f9e3-c7b1-c56b-b449-438dfc212b24	6a7b3d13-233e-1ddb-48ab-438dfc0e3372	4c9833d0-3c0d-cc22-667e-438dfc2cbfe0	2005-11-30 19:23:12	0
cd49dba5-c335-11f5-e92e-438dfc16186f	cbb0200b-2b96-abf3-56ed-438dfc8f37dd	7e29ad13-68e1-2c33-12ac-438dfcaf4ea1	2005-11-30 19:23:12	0
64e4ee8b-8af2-d5ba-e7f3-438dfc69917f	634c6604-767e-2c8b-3d5a-438dfce9ed44	df27c279-dd8b-4906-18d8-438dfc536de4	2005-11-30 19:23:13	0
99193527-0527-d9b8-c14c-438dfc79434b	9776763c-963c-6124-84e6-438dfce79e6b	76d00a10-3ef0-9a5f-1f68-438dfc28d168	2005-11-30 19:23:13	0
36ad0c2a-fab8-6ef7-3ebf-438dfc99a4bc	1d150394-bf48-31c3-b17c-438dfc0efe74	aad102f0-6ca6-3b3a-d374-438dfc18d752	2005-11-30 19:23:14	0
610564be-0750-597e-1030-438dfc9a9266	5f6d65cb-1651-b4f0-29ff-438dfc7c908f	14dd4d0a-360d-88c6-bed5-438dfc462ea2	2005-11-30 19:23:14	0
c12939cb-f2df-f34a-ab97-438dfc5f38c1	bf92b248-3a6a-1f53-8ac4-438dfcd647e2	72627cba-1687-f765-d88c-438dfc2f7978	2005-11-30 19:23:14	0
59a7f16d-95a8-42f6-76f8-438dfc8342b0	57f93287-68b7-29bf-12a8-438dfce4973c	d3431f37-fcc8-2405-eb66-438dfc52eb4c	2005-11-30 19:23:15	0
ba05ad27-5123-a9e2-f1e6-438dfcac72e1	b86c26b1-b0f0-be69-9870-438dfc11f64c	6b1fb4fa-6cb6-8534-d59c-438dfc75d9be	2005-11-30 19:23:15	0
7fb02adf-a115-031f-f4d6-438dfcf0b429	7dffefc1-1ec3-09ec-c4b1-438dfc8047cd	cb4e8fc7-f8f0-e1a2-d80b-438dfc2e57c1	2005-11-30 19:23:16	0
e060e6d9-bb67-d768-c4e7-438dfcaa90e6	decb925e-3a16-aad7-7cc9-438dfc4ecf94	914ccf1c-bf0a-f7ed-58c5-438dfca75a45	2005-11-30 19:23:16	0
a9470ca9-57ff-65fb-62dd-438dfc764c0a	48cdd3c5-88fa-0e76-c48f-438dfc6e44d7	f1baec4e-7c74-c96a-68a3-438dfc8cb99b	2005-11-30 19:23:17	0
d98a202e-c2ff-042c-2624-438dfc834222	d7f19a34-abe7-9df2-5782-438dfc44f832	bab27711-9702-e9e0-da79-438dfcc3aa62	2005-11-30 19:23:17	0
15bb3dc6-fa47-5b54-1bdf-438dfc76044f	14200cfc-bb2d-6aa3-7e64-438dfcf514a8	eae78d25-3a40-ec1c-c24d-438dfc8f5eb2	2005-11-30 19:23:18	0
46549a0d-092b-4d40-e7ed-438dfc5f6552	44b4f69d-ff91-7b16-20ae-438dfc3c8eda	2748039e-54c4-cb87-e152-438dfc2b0d6f	2005-11-30 19:23:18	0
76c5409b-fd04-3c8e-4f44-438dfc3219cf	75322c26-e53c-cdd1-5603-438dfc8be100	57ad5a94-8201-6bc2-5ae4-438dfc415be8	2005-11-30 19:23:18	0
a9c02f36-e778-5c95-ecf7-438dfcd8bb32	a827c287-d6f6-3510-81fe-438dfcde5269	883c8ad1-e540-4dd6-ccb1-438dfc95b2c7	2005-11-30 19:23:18	0
da7c4d47-a5d3-f611-7069-438dfc72b775	d8e32d7e-534b-51e7-68c1-438dfc5e8592	bba46bbd-e936-368b-f563-438dfc060181	2005-11-30 19:23:18	0
166fd2af-f16d-9505-0c87-438dfcad531a	14dc6d49-aeae-ec32-b97a-438dfca91d75	ebe2430a-1961-633a-a68d-438dfc818e50	2005-11-30 19:23:19	0
47c82a79-c919-0eee-bfeb-438dfc492917	462e406a-39be-00fc-c2f0-438dfc8b9432	281a7cd0-fb77-6171-1a50-438dfc3c109a	2005-11-30 19:23:19	0
78caf60e-c2fc-3d32-c528-438dfc6cd325	772e9844-ef8c-f32f-dddd-438dfc7cb325	5926592f-9977-2855-c423-438dfcd03f4c	2005-11-30 19:23:19	0
adbd002e-927d-74b7-fa7e-438dfc199daf	ac1ea948-1a12-7d32-64e2-438dfc4339fb	8a3f3731-8ac9-e132-840e-438dfc018323	2005-11-30 19:23:19	0
e1548d8f-1482-60e7-e9c2-438dfc577b6c	dfb3a910-9a28-e62c-b624-438dfcccb55a	bf2aa340-1a5b-b67c-5244-438dfcb55652	2005-11-30 19:23:19	0
1ddeafa6-f075-31d3-50c7-438dfcf16239	1c132ac9-6b7d-ba96-e8e2-438dfc23dc1f	f2b6de7a-dfb9-1f15-8d7a-438dfcedbe55	2005-11-30 19:23:20	0
4e1b254c-2d6d-8590-0758-438dfc7b894d	4c87afe7-22a3-5622-225e-438dfcba92ba	2f4ab363-a0e3-ee3e-0807-438dfcef783d	2005-11-30 19:23:20	0
7f6ff24e-520d-3925-0258-438dfcfcc70f	7ddbae1a-92b3-fe6c-7f21-438dfca13feb	5f78a5ac-c8e4-d74e-de14-438dfc4ba53c	2005-11-30 19:23:20	0
b55a51ec-6d13-94d7-f7b1-438dfc4f973b	b3b75151-644c-aa5f-c51b-438dfc3dc997	90f58c4a-8556-0ec0-c999-438dfcb4680a	2005-11-30 19:23:20	0
e87890ee-cdfd-d7cb-2d46-438dfcc36b3d	e6e58d6a-65b8-3808-d090-438dfcfd60c2	c6ab6a84-2c1d-6ee1-fb84-438dfc7a9b31	2005-11-30 19:23:20	0
264c7f80-f618-c45c-ceb0-438dfcd204d8	24b3d536-dfb7-5b0b-34d0-438dfc57df38	5db004c3-0bc7-0f1f-0333-438dfc1dd327	2005-11-30 19:23:21	0
5a4613ff-39e4-2a5e-ac03-438dfca9fcaa	58a1414d-6ee9-80c0-8d67-438dfcfb5e30	37ed14c6-a48d-5a88-32de-438dfc344b87	2005-11-30 19:23:21	0
8cc6fe39-15df-ffce-eade-438dfc22d4c3	8b2401d8-8210-0ab4-f5e0-438dfcf9751f	6be54043-f48f-b735-139f-438dfc1c2fc2	2005-11-30 19:23:21	0
bf5ce610-9699-d4fd-ae4b-438dfcf82962	bdbd1de9-b4a8-a8ae-027b-438dfc3ec229	a0bfb889-e57c-c6b1-4a16-438dfc2ce66f	2005-11-30 19:23:21	0
f35eb3af-6dec-43ed-2dad-438dfcc10218	f1c4aa3f-8a33-6fba-3433-438dfcff5284	d09daf64-3366-7d89-d80e-438dfc78fd52	2005-11-30 19:23:22	0
364d7480-aa9d-dd0e-d574-438dfc6e044d	34b06f08-49b7-6445-dac6-438dfc0a4ae7	10c85c97-4838-66f7-ca9c-438dfc62b69d	2005-11-30 19:23:22	0
68b3f851-be53-3708-155f-438dfc29e35b	67024b1f-fda1-5cbd-44ff-438dfcac42c5	47b2de2c-877f-5ea3-3e3c-438dfc69b421	2005-11-30 19:23:22	0
9b886634-9eef-5b44-1f10-438dfc9ad2ba	99edf5ff-721a-8634-bc96-438dfccf264a	7a0f3a9f-919d-93ac-64d4-438dfc575d2d	2005-11-30 19:23:22	0
ce672550-78a1-684c-3e8a-438dfc7829c4	ccbfff82-f15e-0db1-9f58-438dfcc28bfe	ad4d52a7-b4f6-2449-85c1-438dfccbc0eb	2005-11-30 19:23:22	0
cb3f0aed-74f1-6271-8301-438dfc9b61fa	b1a30f37-66ca-8288-06ee-438dfc84dfbe	dfb5d15e-4d90-008a-c4a0-438dfc1e6796	2005-11-30 19:23:23	0
3faff031-dec1-2d8a-a844-438dfcd2a8d0	3e068b71-d658-c867-3c93-438dfc9e4009	1e2e0eaf-a436-2e2f-079a-438dfcc978c2	2005-11-30 19:23:23	0
6fd51174-ab30-e1af-fb71-438dfcedc17d	6e3ea8a2-f6b4-c5c9-632d-438dfc48a344	511417c9-515a-5271-83cd-438dfc3602b3	2005-11-30 19:23:23	0
a2de797d-b604-0386-f262-438dfcc7c8bb	a1437962-e606-fb39-bc2e-438dfc976904	81739667-916f-2f70-f9b6-438dfcef40da	2005-11-30 19:23:23	0
d8d89f63-0960-831a-72b7-438dfc97e71f	d72e3ade-78a0-3d4f-afc5-438dfc0c768d	b458bb25-107a-9c13-28cb-438dfce22eb8	2005-11-30 19:23:23	0
1d8d6293-e0f4-2ad3-368d-438dfc659cb4	1bebba96-76bd-15bd-9c3c-438dfcc95a6f	ea48fde4-32a8-c93f-deb5-438dfce647a7	2005-11-30 19:23:24	0
50da6240-2c31-865d-d025-438dfc5adc04	4f302607-abcd-5352-f2fc-438dfc00e5b3	2f17041d-6ce9-52da-f900-438dfc42caf8	2005-11-30 19:23:24	0
841e2aed-2362-9a99-535a-438dfc2d53cb	825e2292-7252-6410-fb2d-438dfc79d20e	62385afb-c905-f7a8-2a44-438dfca04f24	2005-11-30 19:23:24	0
b9e551cb-468d-3cc1-b944-438dfc73d90b	b51a563d-6691-98c6-52b1-438dfc202f8b	958696f6-dd18-293d-8b6a-438dfc8aed00	2005-11-30 19:23:24	0
ea2a40c1-071a-17a1-e983-438dfcac009d	e888490a-77ca-2e54-e151-438dfca126ff	cb5c47a5-1b26-9d7e-13d6-438dfc4e1bd3	2005-11-30 19:23:24	0
268a4c48-951a-ea07-590e-438dfce5ad63	24dc684b-4aab-d9cd-10a0-438dfceaa494	75e50a23-9265-c54c-8b4e-438dfcd2223b	2005-11-30 19:23:25	0
5fa0ef31-8541-c29a-d1aa-438dfc931034	5dece066-4bc5-24eb-07a9-438dfc8e0853	388be0fd-b842-efd0-f18e-438dfc552b9e	2005-11-30 19:23:25	0
91039ea3-1679-30df-fa91-438dfc67923a	8f52a771-9213-2b3a-3ce1-438dfc5c71ec	7157d805-6abe-331a-5fb9-438dfc620237	2005-11-30 19:23:25	0
c4db4dab-efda-4122-1e55-438dfca14c47	c333815a-ebdd-ee68-ee0a-438dfcfc9006	a5742340-8530-36ea-0b70-438dfc49fba9	2005-11-30 19:23:25	0
5d6e0e53-8029-84c8-76e2-438dfc1162f3	42be0d14-40fa-a041-2247-438dfc08385e	d69a09f2-05b3-787c-3830-438dfcf05a6f	2005-11-30 19:23:26	0
375d602f-e3f6-4d35-422e-438dfc3273ce	35bb881c-7643-9d00-e558-438dfcfbdfb3	179e125d-284a-d3b2-0038-438dfcf93aaa	2005-11-30 19:23:26	0
6cc5d4f9-8948-f3b3-49f8-438dfc0309ce	6b1aa649-4fe1-c9c0-dfa3-438dfc73315c	495768d6-47f1-1b9f-577a-438dfc1aac48	2005-11-30 19:23:26	0
a3f10639-8067-90ee-a26f-438dfc8c0655	a24afe1a-083c-32bb-fb1e-438dfc7459f8	7e3eb19c-1d64-396b-5c09-438dfcb45107	2005-11-30 19:23:26	0
dc5033f4-bd3f-2aae-4276-438dfc23a853	dab64de2-48a9-2281-5cfb-438dfc237bd0	b566c7ed-03b1-4b94-b3c0-438dfc90b079	2005-11-30 19:23:26	0
186046fd-9d96-ce17-5fa8-438dfcb63ad6	16ad13b9-d9f4-4e9d-603c-438dfcae225f	edb6480f-7a94-ab84-d7f7-438dfc6d05e7	2005-11-30 19:23:27	0
525b4fba-f1ad-79e8-17a7-438dfc826a85	50ad177c-14a3-302b-2fe0-438dfc7bd466	2ade2bad-f421-e522-0893-438dfc6f9001	2005-11-30 19:23:27	0
87438148-9cc3-7b42-544d-438dfc91e314	85a4f5f3-8cb4-fd29-8127-438dfcd4db2e	63ac9d63-cef0-cc86-3eb8-438dfc83a95f	2005-11-30 19:23:27	0
bea5fcd7-9161-b297-80f7-438dfceb0dc7	bd106827-7ff4-0c95-591b-438dfc3cff42	9b204880-a0ef-5c4d-4be0-438dfc20677e	2005-11-30 19:23:27	0
eeb737ff-856a-edf8-bd80-438dfcb0cc8c	ed1a0558-ed09-ffae-8b62-438dfcbbd57a	cfe9578f-3e6b-aa60-aa17-438dfc0054b8	2005-11-30 19:23:27	0
2ab2119d-ffc1-d078-a1c4-438dfcc015f9	290bff6c-1ffd-bac9-ebc2-438dfc57fda9	bfe90793-7042-b281-a29b-438dfcd94a83	2005-11-30 19:23:28	0
64963b2d-d292-f76e-45a5-438dfca622cc	62f6d9a6-38db-9adb-8f64-438dfc809550	3c5230ab-6269-a413-a1da-438dfce24849	2005-11-30 19:23:28	0
94cac889-9423-30f8-566a-438dfc864d1a	93298433-87f2-d555-c5eb-438dfc3a8e71	75fbe8a1-0cc5-7f5f-3f5d-438dfcba3444	2005-11-30 19:23:28	0
c77394d2-8c7c-124d-8a40-438dfc02fa44	c5cf4d41-23ac-43e6-f97f-438dfcde00bd	a8be972a-939a-3dca-b61a-438dfc6effc4	2005-11-30 19:23:28	0
dbcd0466-7a8f-b377-e550-438dfc6a5d03	c0680e5a-0cfc-cd0b-ffbc-438dfcbd6185	d8ad2277-df7d-f46f-f387-438dfc9fc67c	2005-11-30 19:23:29	0
43401f58-7ab9-270f-b45f-438dfc4d3b0a	41a526b8-6eef-0ee4-1ad2-438dfcbeff40	1f2068b3-8dfd-886c-701a-438dfc9c060b	2005-11-30 19:23:29	0
78a30976-2bd2-6538-c40b-438dfc31b31d	76f862b6-99a8-f259-5934-438dfc2a1e25	54a0d864-0354-75f6-828b-438dfce8bd19	2005-11-30 19:23:29	0
b64bae80-fe1b-87ee-47da-438dfcf295fd	b4b24cbb-da1b-5cc8-9ff1-438dfc8673bf	94e3b641-f6ba-cc12-a786-438dfcc4dc4a	2005-11-30 19:23:29	0
e72e402b-5259-bbe6-a9ba-438dfc896fb5	e58f9f32-8bb2-9ecf-ace8-438dfc110fd0	c79ec9db-7704-6f87-c385-438dfc36b819	2005-11-30 19:23:29	0
2eacdb99-91b6-07c5-5821-438dfc49f2f4	2cbea3b7-59e5-ae4c-b8e8-438dfcc0ff52	492a0d69-45ec-0626-ad08-438dfc957527	2005-11-30 19:23:30	0
5f1e0745-141f-ec69-9b88-438dfc5e5333	5d81e5cb-c395-5a7b-9e57-438dfc6dd7d4	405a1f89-b637-f966-5355-438dfc8e0091	2005-11-30 19:23:30	0
9507a18f-4bc5-5ea0-bbcd-438dfc227ab2	93658bae-d584-6796-831b-438dfc4cb9cd	7072fe03-b8b5-5554-6d14-438dfc2f5a34	2005-11-30 19:23:30	0
c7ae6e7e-b9fe-aee4-8542-438dfc8b4354	c612e074-74cd-1610-5766-438dfc40bade	a902c86d-af73-bb58-03d8-438dfce6da2a	2005-11-30 19:23:30	0
155b2216-336d-ea6d-67d0-438dfcd50aa1	13c74f9f-ade5-560f-01dc-438dfc1fbd8c	d90e7371-642f-b58a-283a-438dfcf43684	2005-11-30 19:23:31	0
45d754cd-b050-30ff-803a-438dfc0dbc74	44405f8e-84c5-ab43-50bf-438dfcc08a76	26bc2c8a-cf99-5250-f0aa-438dfc686818	2005-11-30 19:23:31	0
75f777f5-212a-f0ea-ee44-438dfc7cca1b	74492f6f-37aa-6da9-ea40-438dfc4d6851	573647e1-999c-69cf-2397-438dfc17623f	2005-11-30 19:23:31	0
b4f8eed9-85f7-9da7-e2aa-438dfc329a47	b360974f-b6b3-4575-c535-438dfce3aaab	877eb60b-134a-f479-802c-438dfc448522	2005-11-30 19:23:31	0
3fd40d4a-a72b-6855-b368-438dfc1229a1	24dc0cf7-26c8-a372-2b84-438dfc3c73c7	c66b15b6-1295-c446-8285-438dfc13ef91	2005-11-30 19:23:32	0
40f351ec-06e3-99e8-8c4f-438dfc041924	3f596d4d-9459-a7be-ebf2-438dfcdd06cf	15876252-21f9-8801-edf5-438dfc514ffd	2005-11-30 19:23:32	0
77c764c8-e0e8-77fe-fc6a-438dfc49485c	762a4dbb-1b6b-8265-b777-438dfc26e6aa	52649e63-6cbc-9626-db97-438dfcc96538	2005-11-30 19:23:32	0
aa921f70-9af6-856b-c3fa-438dfc630548	a903c5be-615c-6482-f54e-438dfca2f9a5	8931952d-ca9b-aaef-d3bf-438dfc559055	2005-11-30 19:23:32	0
e7eb97fd-bf15-e2f7-4e07-438dfc872de9	e650a6d9-55c9-16d5-3e51-438dfc30eddc	bbf35b4f-d530-f5ec-3f2a-438dfc01924c	2005-11-30 19:23:32	0
2405bd85-1996-2126-58f8-438dfc2ac547	226de984-3890-18dc-cbcb-438dfcf33b58	53e902c2-1531-2e88-6849-438dfcf7e277	2005-11-30 19:23:33	0
54437648-ecd0-08c5-11dd-438dfcc47815	52b0c433-2a77-d494-9333-438dfc1f2e7c	3571dd34-b4e1-d163-6193-438dfc2a52df	2005-11-30 19:23:33	0
99624a68-821b-02bd-70d3-438dfc665305	97d37521-e05c-a093-8529-438dfc806258	65b6ae82-e853-4b4a-907a-438dfc41e4ea	2005-11-30 19:23:33	0
cc758322-dda7-2239-7a48-438dfc412ffd	cadcdefd-f87a-9088-c548-438dfca90e1e	ad7eebc8-9008-48aa-8999-438dfc2bd7db	2005-11-30 19:23:33	0
895800ef-024f-171a-f83f-438dfcd36249	6fe50e85-30cc-a7b1-9622-438dfcb84ed5	dddc337f-cd80-2112-6c27-438dfcd65851	2005-11-30 19:23:34	0
391e7fdf-8bd4-4cf3-156f-438dfc7ca9ea	3790812f-f865-9cdd-ec29-438dfc40797a	19ffc069-9d38-b1b6-1dae-438dfcbadb5a	2005-11-30 19:23:34	0
781ba660-571c-c803-66da-438dfcc5fc8d	7681f4c4-95f7-f34a-0dfc-438dfcd8e527	4abce901-f399-395c-cfc1-438dfc680d17	2005-11-30 19:23:34	0
b2786cc8-67a0-aa3c-b575-438dfce720e0	b0eb573e-0b4c-db66-a4f5-438dfcfd7a12	89aa25e0-abb7-8da8-5f7c-438dfcc93527	2005-11-30 19:23:34	0
f1d876e9-916e-f71d-5100-438dfc02c6da	f046ed8f-829d-328a-41f2-438dfc79ae4c	c42d53c8-319a-14cb-031b-438dfc639b30	2005-11-30 19:23:34	0
3eb1b565-2411-8837-96c5-438dfca1b461	3d1b97ed-4be8-3e8f-c338-438dfc420b6f	f8ae0395-a072-805c-afa3-438dfc1b9db1	2005-11-30 19:23:35	0
83c1e9f2-5175-4fb5-8b0b-438dfca4694a	8231219c-88f3-08e0-4d40-438dfcc76b2d	5597c255-2788-329c-788b-438dfc89c0d8	2005-11-30 19:23:35	0
c61ea25c-4791-28e4-07c5-438dfcec98a6	c486945c-dfe8-7558-5dc5-438dfce54b49	9562372a-7c6b-0f03-5180-438dfc684ff2	2005-11-30 19:23:35	0
11de391e-bbc4-b401-de43-438dfc23a7c6	10448b37-767d-49c6-7ff4-438dfc144959	d78273c2-d1a4-c2e1-cb4c-438dfc1d695e	2005-11-30 19:23:36	0
41d40929-bbd3-826c-2c62-438dfc2b0746	4037915b-06c2-049d-fa76-438dfc3f7bd0	2337d344-998b-9825-9a1d-438dfc6dafc6	2005-11-30 19:23:36	0
71fc5cf4-c298-e6ee-ed97-438dfc81df1a	70618cb5-dc78-b088-3e4c-438dfc0ca172	5377769e-2add-65c8-fae0-438dfc5634c3	2005-11-30 19:23:36	0
a4c9e2c8-0c09-171a-9397-438dfcdd3d36	a33a94a2-f80c-9478-2b6b-438dfcf49e4f	83588aa9-47a5-ea7e-f3fe-438dfc246337	2005-11-30 19:23:36	0
dd0f063a-4434-30e0-d0dd-438dfcee5971	db839fdb-d806-b78e-a0a0-438dfcc61dfe	b625d5bb-cd93-43e5-6e8b-438dfc2936c1	2005-11-30 19:23:36	0
21674be4-fcf4-011c-ee4e-438dfc29a01f	1fd795f7-c529-0b77-a351-438dfc8087d4	ee8bad1c-a0dc-5296-19c3-438dfc606916	2005-11-30 19:23:37	0
6807bc87-b3db-897a-4570-438dfc6d7815	66715d79-9b0e-e339-3fbb-438dfc8694f7	32dbd4f6-fc0a-ee15-c211-438dfc5792cf	2005-11-30 19:23:37	0
a541fa05-1673-f14e-6c88-438dfc46e35c	a3b03acd-14fd-6b90-0a3a-438dfcb9b910	7a09f220-a444-3557-babd-438dfc835374	2005-11-30 19:23:37	0
deff8f95-d975-7ddd-4658-438dfcae86ea	dd62dae9-70c2-4a76-dca9-438dfc6d1749	b6fee153-e674-0ce9-1876-438dfcd49190	2005-11-30 19:23:37	0
2d6fdc92-74c4-ba58-e56f-438dfcf623e9	2bdbd56a-9436-05ce-ec8e-438dfc73ae4d	f0c98417-28e4-750f-3158-438dfc753a4a	2005-11-30 19:23:38	0
5ecfccff-b5c7-6fcd-7a27-438dfc8f1bf5	5d2e9371-d63c-13c5-efaa-438dfc6584bf	3f3906cd-9417-2089-b784-438dfcbfcc98	2005-11-30 19:23:38	0
993b8ce5-5c4d-91b7-1d18-438dfc4a481c	9778e1cd-e7db-3aa1-58b4-438dfc618981	70a2eb1b-e3e3-24ea-79db-438dfcfd0cac	2005-11-30 19:23:38	0
d5206a55-6db9-8992-f447-438dfc1e1475	d38db215-b715-00b1-4a3a-438dfc87ff1d	ad779176-e6f2-3a2a-7988-438dfca1fc7f	2005-11-30 19:23:38	0
1115f624-1b2a-e84b-71a0-438dfcf77578	f85f00e0-fe55-e9f1-4356-438dfce2dfe2	e6794b89-cc73-f353-e58d-438dfc4ade8c	2005-11-30 19:23:39	0
4a9a51dc-63dd-e9e6-d5ba-438dfce61717	4908359d-2e71-f7bf-96c3-438dfc1d5bf1	22a32b5c-d5be-2c77-7d86-438dfc775cd6	2005-11-30 19:23:39	0
932e1531-c7e9-6fe1-cf58-438dfcf2312f	9188465f-ed5f-8c10-1fd5-438dfc14b29d	65157916-93a9-67e5-d373-438dfc35ed6b	2005-11-30 19:23:39	0
c63efb91-e644-8b36-bf92-438dfc26957b	c4aaa1fd-4385-0224-f0b7-438dfcb17578	a7b39e5d-493c-5021-3027-438dfcce30dd	2005-11-30 19:23:39	0
b8e6080c-2e1f-2d00-ba77-438dfcee10eb	a01e02fb-5323-3b74-3b6c-438dfca7c6e8	d7a3fd9c-3715-e6f2-2e8b-438dfc374d45	2005-11-30 19:23:40	0
58923af1-4edb-e2a7-bd93-438dfc735b73	56cb61b8-e7dd-b6b6-658b-438dfc7604c4	1cea29e6-0f31-0943-b9ab-438dfc45d065	2005-11-30 19:23:40	0
926c9bd5-e0f4-ccd7-3363-438dfc309664	90d0e5a4-2309-98b0-2202-438dfc2e1419	6a0493ef-90c2-3391-e434-438dfc67e7f3	2005-11-30 19:23:40	0
d8606ebf-1570-17c7-2de2-438dfc558e73	d6b31e1c-b1e4-dc96-721d-438dfc33a4ef	a672e98c-171b-2ec5-7d03-438dfc20800e	2005-11-30 19:23:40	0
1e182c82-2273-dc32-8481-438dfc1f3be8	1c8485e1-5cec-6b42-3293-438dfc135811	e9bbdad1-2981-a54e-4e5b-438dfc08455d	2005-11-30 19:23:41	0
5838ed87-1d2e-58ae-2507-438dfcde53ec	56af216a-d09c-9d31-e211-438dfce4d5c5	2f921331-569e-4ebf-b85f-438dfc2a8506	2005-11-30 19:23:41	0
9285b8aa-8fe8-2bd0-38a9-438dfcf6b350	90f7ef73-4ad9-2c4c-82d0-438dfce765ff	69c01b1b-cc6d-c6ba-7d82-438dfcb29df2	2005-11-30 19:23:41	0
cf6f100a-2393-7b07-fd82-438dfc937a42	cde20296-3de6-fc19-d310-438dfc03c555	a6a6780e-665a-b236-013e-438dfcb9b481	2005-11-30 19:23:41	0
b6910614-95e3-5bcc-9a9c-438dfc1271cb	9d8c0b18-7372-69d1-6be8-438dfcd4558b	e0bf6505-a4cb-5da4-ff16-438dfc3160c7	2005-11-30 19:23:42	0
4fc3435f-1127-3533-3d59-438dfce33e26	4e2b4253-e78a-32ce-c712-438dfc2d314b	1cc1c1ae-8282-a9b8-0990-438dfc21f836	2005-11-30 19:23:42	0
8a18a522-4549-2581-cd5a-438dfcd951fe	887521e0-0e20-da6e-ea58-438dfc72315e	61281b35-9522-a961-b110-438dfc96ffd5	2005-11-30 19:23:42	0
d156d41d-5444-59d3-38b3-438dfc150ae8	cfc38a01-3bd8-a4b7-eba3-438dfc1a85b0	9b8d325f-2245-2777-7458-438dfcf98dff	2005-11-30 19:23:42	0
d3f303b5-b9c5-4dcf-d4da-438dfc342aa9	bade053c-d997-8b4b-cced-438dfcac3d46	e2a26fcb-15b9-e3f4-5278-438dfcd05868	2005-11-30 19:23:43	0
67a0ca04-80be-5b5b-4607-438dfc78a1aa	6608318a-ac2d-35fb-1471-438dfcac1672	1ec4e7bb-052b-c1a8-6d80-438dfc3ef908	2005-11-30 19:23:43	0
a52bf71a-417e-e682-3d5e-438dfccc5fe0	a39bb548-db86-a9dc-d231-438dfcd858fb	78f888c0-fbe2-aa7e-16ba-438dfceac795	2005-11-30 19:23:43	0
d6f285d5-df8f-0a09-e8d9-438dfc3ff252	d55e8c1b-3fc8-c1be-feae-438dfcd8f770	b7b06c1d-d4d2-7a12-0c06-438dfc86b73a	2005-11-30 19:23:43	0
2894cb35-1c1f-853f-de54-438dfcf174ae	26f11194-b4ff-44b8-2680-438dfcd33c32	e85850ac-0a63-0b69-a9b1-438dfca59923	2005-11-30 19:23:44	0
58dffa4a-5575-8ea8-b53d-438dfcc0f1ef	5752ff12-6ad7-7a9e-726f-438dfc824f86	3a070ce3-f7cd-617d-d237-438dfc16a689	2005-11-30 19:23:44	0
896c3a5e-7b13-fa2e-5118-438dfcf7a530	87b485b5-ce63-ebc4-f089-438dfcbc41da	6a7528ab-6435-5063-cfd9-438dfce53729	2005-11-30 19:23:44	0
bc4e0128-6cd8-0975-8bad-438dfc071f47	bab9ce10-9fe7-2fd9-b79d-438dfcae3c18	9af11752-a9fe-aecb-fab7-438dfc778a8b	2005-11-30 19:23:44	0
359306f3-aa49-f567-09e9-438dfc5d963d	1c45010a-590b-2499-51e4-438dfcb8c868	cdaa34ca-831d-c9d6-c0e5-438dfc14756d	2005-11-30 19:23:45	0
3eaed1a7-778b-f800-df32-438dfc4e5560	3d20fec9-848b-db2c-6c49-438dfc9bea04	14b514b2-e83e-11d1-1217-438dfc8c5156	2005-11-30 19:23:45	0
7ac2e2ad-ef5d-c3a1-569e-438dfc06604c	7930a630-ac9f-f2a3-ad7e-438dfc0b3028	50293355-7599-eea7-5a72-438dfcfaa9d6	2005-11-30 19:23:45	0
b90c899c-6add-b23d-375f-438dfcc4053e	b77f56d6-389b-6898-abf5-438dfccf3cf3	8c41aa8f-d82c-2dd1-6752-438dfc68590b	2005-11-30 19:23:45	0
bd8a0660-3c84-0004-fb15-438dfcd40ddc	a3990958-7a12-100a-1f3b-438dfc87c3d0	ca6288e8-018b-a6bb-6c4f-438dfc1d6b02	2005-11-30 19:23:46	0
3c16e0f8-1fe5-96fe-6075-438dfcae3cee	3a8535d2-5cf7-62f9-3fe1-438dfcf39bf2	1d240a24-733d-3ab7-64c1-438dfc3357a2	2005-11-30 19:23:46	0
83b9ed4e-8c67-bc32-c707-438dfc6f60a1	822dce2c-8021-cd70-15b3-438dfcc64438	4d633ea8-f28f-16a7-fbbd-438dfcce24b5	2005-11-30 19:23:46	0
b68b9161-13f5-6719-3059-438dfc7719be	b4febc18-1d48-5836-2509-438dfc90072d	954bd18b-4cad-5731-0c27-438dfc7a98e1	2005-11-30 19:23:46	0
f266fadb-8dd6-0557-5a98-438dfcad96ef	f0cb9cb0-a291-1c1d-564b-438dfc1da78c	c7ee6c19-78aa-9877-288e-438dfc64ad91	2005-11-30 19:23:46	0
2e859708-cd7f-fe99-8c21-438dfc74f5af	2cf622a8-94fb-5109-fc63-438dfc4a82e9	fcc0072c-570b-aa7a-0a10-438dfca14c06	2005-11-30 19:23:47	0
5ecd9073-c9fb-954c-de1d-438dfc67804f	5d3eca3c-cf01-5c8c-1706-438dfc60cfda	4002a8d9-2b45-20ad-7490-438dfcd3c7b9	2005-11-30 19:23:47	0
9b468fc4-db41-a61e-39e1-438dfc42cf6b	99a91e7c-f9c0-532f-0bfb-438dfc4a11fd	704e62a8-3a73-3800-3d63-438dfc87d2ce	2005-11-30 19:23:47	0
da0bf967-879b-fbcc-c184-438dfc95dd0b	d86fae36-81e4-de00-8e3f-438dfc21fc9b	af242932-aa0d-8446-5bea-438dfcc32b6c	2005-11-30 19:23:47	0
1609f3ce-1edd-1523-c1d9-438dfca1245a	147b2489-36dc-2f09-3903-438dfc4734b0	eb81ef28-ed52-2cdd-0492-438dfcb8efaf	2005-11-30 19:23:48	0
77d8e430-584e-44f1-86d8-438dfc3ec87d	7635cae4-3828-1392-4da9-438dfc87d092	278d5dfa-a9bd-1405-8b20-438dfcf24c04	2005-11-30 19:23:48	0
b71c0c16-6f6c-4e60-4e06-438dfcaacf0b	b58e5272-5ea4-9443-f44a-438dfce6fec9	893518ed-1f3c-bf65-29d9-438dfc2bba65	2005-11-30 19:23:48	0
f3c80fcf-0f97-74e7-4b1a-438dfc4ecf3e	f234e275-ffcd-557e-4d81-438dfcd1b393	c8881c14-f62e-59f6-9d97-438dfcd0c92a	2005-11-30 19:23:49	0
2fdbde5f-c9f9-29b4-d433-438dfcd06125	2e474380-4b0d-c596-590d-438dfc79f61d	112a9128-7496-d4c3-c741-438dfc78433a	2005-11-30 19:23:49	0
79b0a189-520f-21f5-a814-438dfc1acf7c	77f91f9b-84a1-6bd8-dec7-438dfc3f9d24	41489b20-3b66-0f87-0ed8-438dfcba09b7	2005-11-30 19:23:49	0
bb4db9c6-7d73-22a2-657e-438dfc3f5f9f	b9ad170e-8067-fe08-9c79-438dfc60419c	8c4df6e9-bf3c-6c7f-d616-438dfcdc2492	2005-11-30 19:23:49	0
63f40917-a8d8-1296-9a2f-438dfcc13ac8	494d0ac1-b017-7460-e98d-438dfc237689	cd076a95-a03a-8166-54fe-438dfcdae315	2005-11-30 19:23:50	0
51deceee-aa9e-c545-7171-438dfc423ed1	502d9b48-9ad9-ce38-0d0e-438dfc5d590f	1820ef8f-c74c-624d-e2d1-438dfc773520	2005-11-30 19:23:50	0
839f56bc-a67a-0200-9613-438dfc94c227	81f6d360-9ab3-1076-e21d-438dfc184ef7	63d3a33d-c0b8-3e5e-6424-438dfca3b887	2005-11-30 19:23:50	0
d13a5eb1-48cc-c2a5-eb8d-438dfc8607a3	cf990eed-1885-4a81-a271-438dfcdf3872	9563448c-792e-d962-288f-438dfc98c60f	2005-11-30 19:23:50	0
1a5e0b80-72a9-b65c-53e6-438dfc884f5a	18cba21e-71a2-ccfd-5744-438dfc146340	e27af1d7-4419-a694-0b12-438dfc6adf35	2005-11-30 19:23:51	0
4a82cd7e-2a77-8f14-c70b-438dfcd9a21b	48eb9490-cd12-78d8-f23a-438dfcd710f7	2bc0a270-26fc-7ae9-9313-438dfcf04250	2005-11-30 19:23:51	0
95e94848-7541-742e-22e6-438dfc53561a	94313baf-8be7-e7d7-ebab-438dfcb269f8	5bf631be-1622-a5e9-1a8d-438dfcff57b6	2005-11-30 19:23:51	0
e3e08ed3-c49c-a4a0-54d1-438dfc041b52	e24cdae9-4e25-7855-aeb2-438dfc5df48e	aa0b180a-0efd-40d1-5435-438dfc48d2de	2005-11-30 19:23:51	0
4907011a-da39-92a8-608c-438dfc268c3c	47626928-0bb3-1ee6-2bd4-438dfc951437	1408024c-90ca-89db-f420-438dfc69555c	2005-11-30 19:23:52	0
878967ba-1425-22dc-6301-438dfcb27489	85f66aac-803c-c86c-329b-438dfc45eea2	5aa4340e-d0ac-4dbe-2eda-438dfc2ffaca	2005-11-30 19:23:52	0
baf445e3-fc1d-d9ad-5ab1-438dfc1d9545	b96307dd-a8e5-0f5d-ef1e-438dfcee6329	996773d8-7459-442b-e781-438dfc17a340	2005-11-30 19:23:52	0
eb3eee56-8002-5867-f156-438dfc103ef9	e993d6a1-f781-3d73-8cb2-438dfc26e43c	cc6b9706-5113-ca5b-cb3b-438dfc78598d	2005-11-30 19:23:52	0
278725d2-2e4b-033d-2071-438dfc4ffb6d	25f2e10e-7b9c-457c-9b9d-438dfcd282c6	88570831-b950-4b7e-6cd1-438dfc241b2e	2005-11-30 19:23:53	0
660eebdb-02d1-d12f-055c-438dfcaa77e9	647a56d9-9fb6-b221-d8e8-438dfc61c201	390ee98e-8b3c-5965-e4fd-438dfc1c6eaa	2005-11-30 19:23:53	0
a7599da9-b63b-4ea9-d68e-438dfc4d3102	a5817fb8-5cff-2045-7166-438dfcae3770	778b80e7-794c-0a12-6f96-438dfc41229c	2005-11-30 19:23:53	0
f4109320-87dd-67d8-eb4a-438dfc6430dc	f28115ac-4f46-90fe-77d1-438dfcde5811	b8db6e77-2347-fbbf-e50e-438dfc33ba76	2005-11-30 19:23:53	0
3eaf9874-78a3-ddbd-4b93-438dfcf554a7	3d1c3b92-4805-a939-f4ff-438dfcc42335	118c01c7-38b6-1470-71ce-438dfc47cedc	2005-11-30 19:23:54	0
7d9c5097-c016-9bcf-ae0c-438dfc6fa68e	7bfda33b-4110-a797-4681-438dfcba3106	501fc4d0-306b-3755-b0e4-438dfc055616	2005-11-30 19:23:54	0
b105065c-4a98-74e9-d456-438dfc8835bf	af688ad9-d34f-83fb-13b0-438dfc4b3a44	8f64ce1e-2846-22cf-52b1-438dfc1e4865	2005-11-30 19:23:54	0
f020a84e-b4fd-d2e3-dad7-438dfc7484ab	ee86b41f-d0e9-f557-2c06-438dfc24766b	d0f6f8f3-3f8d-6ac9-07a2-438dfca4d5a3	2005-11-30 19:23:54	0
3b55e1cb-6484-c75d-37c9-438dfc4aa899	39b7d838-a700-3141-2f1b-438dfcc1f3a2	d844099c-3218-4a53-04fd-438dfcf7fe24	2005-11-30 19:23:55	0
6bbf6a1c-0a73-d23f-ad84-438dfcadc481	6a2ca102-d649-aea5-1962-438dfc04ba5c	4cc59be8-6a2b-045e-fffa-438dfcb7ecd1	2005-11-30 19:23:55	0
9d641a2c-8b39-a2d0-19b6-438dfc4f98a0	9bc93c9f-3a1d-5f63-5938-438dfc8fbaa8	7e36e18a-2a32-95e6-141d-438dfc516b2e	2005-11-30 19:23:55	0
8c4e0ce1-1127-80c6-97f2-438dfcc5fc1e	dd5c2849-0262-cc17-9d4a-438dfc7322e9	b165ae47-2fc0-be05-a089-438dfc950f45	2005-11-30 19:23:56	0
4807a6d6-9d58-8303-9bbf-438dfca859cc	46791858-276c-1e43-9e1e-438dfc4edf40	1a2b5888-e59b-c7cd-18f1-438dfc046cd4	2005-11-30 19:23:56	0
96e05731-e151-a986-2dde-438dfc07c628	9546027a-5974-0876-c34b-438dfc6fd190	598d45b0-cf4d-be31-0b37-438dfcaf36de	2005-11-30 19:23:56	0
129b35fe-8e52-004b-829a-438dfcf56ea7	1107abcb-2592-d30f-30e1-438dfc8a936d	ba2d0e92-2b82-c7a0-aefc-438dfc5bbc75	2005-11-30 19:23:57	0
523d4308-29b7-fce4-ed83-438dfcfb4b91	508c682f-0b6e-e691-1610-438dfc858040	2414a861-856d-d2e2-bf08-438dfc9407bf	2005-11-30 19:23:57	0
91d8e515-9a35-6a21-8b3a-438dfc6454b1	90410cf4-1b15-d65e-5635-438dfc4ec6f6	638ef092-a33f-0e0c-ebc2-438dfc121ac0	2005-11-30 19:23:57	0
c4993d17-c62d-9a67-a574-438dfc0c6a79	c3092488-9f4f-557e-4326-438dfc1f1783	a5efc69d-86e3-c51d-1f94-438dfc385db9	2005-11-30 19:23:57	0
bfc00c14-f2c2-0897-c32f-438dfcdf3a3d	f351e994-0cbf-11d1-afd7-438dfcdd8663	d6020c11-a159-8e9a-a1d7-438dfc1b496a	2005-11-30 19:23:58	0
3128077d-e90d-4f0d-7237-438dfc2e1876	2f935a6e-0e7b-6477-4e09-438dfce0b79d	1237d33b-03c3-419a-73ea-438dfcbee32d	2005-11-30 19:23:58	0
910792f3-0ed0-a10d-9e55-438dfc8bd66d	8f607db9-9258-4c31-cc13-438dfcece24f	428a4aeb-d8e7-e5f8-f4d6-438dfc715771	2005-11-30 19:23:58	0
c3eb0e76-7785-08de-0458-438dfcf7602a	c2471e28-99e0-e2a7-097c-438dfc585d31	a29bdad9-c920-afe4-d906-438dfcf200d1	2005-11-30 19:23:58	0
24c0026d-5333-0e5a-03df-438dfc700924	f2a160ac-5f4d-5c07-e08f-438dfc912f56	d57a05ea-6231-9c57-f684-438dfc0ece79	2005-11-30 19:23:59	0
309b92f2-cb5b-e7fa-3e73-438dfcfb0eed	2f090575-2a92-fe42-f915-438dfc8dba89	11a182e9-8983-9899-e85b-438dfcae42d2	2005-11-30 19:23:59	0
91e27eee-25cc-752b-78ee-438dfc034a11	9051dfd8-fb78-9cda-1f36-438dfc52b13d	421d206d-afa1-4024-ff07-438dfc380941	2005-11-30 19:23:59	0
c4bc6b29-e55e-0f00-3234-438dfc9e460f	c3264cce-5f48-1508-6376-438dfcfeb668	a5ff1c0f-fcab-e1db-053a-438dfc953533	2005-11-30 19:23:59	0
fd0009ca-d890-6a21-bb81-438dfcada722	f385d7bf-e40a-3f1c-ff08-438dfc2acc16	d63223ae-3fcd-0bbd-c6e9-438dfc2b5132	2005-11-30 19:24:00	0
42674a42-dc1a-2b36-61d1-438dfc30a850	40b06e1d-4a37-6af0-0405-438dfcd063a4	1291fd0e-0b21-b243-e90a-438dfcc8a6d4	2005-11-30 19:24:00	0
7275d6db-1665-e983-ff19-438dfce896c3	70e0970f-4265-1413-845d-438dfca8b65e	53b25086-df00-b865-87bf-438dfc2e9e2a	2005-11-30 19:24:00	0
c753f7c8-b04f-98d5-a8c0-438dfc390879	c5bfd61c-cbe7-9559-381b-438dfce18d6d	84a158a8-9b77-8763-f48e-438dfc86a84a	2005-11-30 19:24:00	0
3553ef2c-a76a-be93-fee3-438dfc40b929	33be06d6-efe0-0f8d-0d2f-438dfcab36b9	d8db292d-d903-51c1-7629-438dfc04dae1	2005-11-30 19:24:01	0
65a0e6f6-e0e0-df72-e425-438dfcdf229b	640acae0-6547-32dd-61f1-438dfc8a2d39	46c1629b-ff53-12b7-de33-438dfc79acc0	2005-11-30 19:24:01	0
a9cee500-bebd-e133-0aa0-438dfc8236bf	a833eb1e-5efe-bd84-b225-438dfc67ffad	7720b17b-d7d0-e845-e74d-438dfccdb560	2005-11-30 19:24:01	0
eedbd97b-de86-6ea7-d789-438dfc75841d	eca6e398-a24e-4565-4cf5-438dfc086883	bcdea145-1765-f3d6-1f3f-438dfc89a81b	2005-11-30 19:24:01	0
4283e4f8-fecd-8814-9528-438dfc3d6874	40e9f23d-a97a-f85d-d6f8-438dfcc9049c	f8fd0b41-cad8-e5ba-85c9-438dfc45bf5c	2005-11-30 19:24:02	0
853fe8c3-8697-3480-4c88-438dfc0b0f91	8391100a-6bd7-9d7f-8123-438dfcae847a	5478ecd4-649f-5f03-7ef5-438dfc409603	2005-11-30 19:24:02	0
ecfecd59-1ebd-c741-9808-438dfc5fb229	eb590a8b-6816-1f0a-a6a2-438dfc249b1f	9743fa19-2c3a-af48-3303-438dfc988c03	2005-11-30 19:24:02	0
5e3154c4-14ba-7d2c-94a9-438dfc28ce62	5c91380e-c8fa-d83b-9203-438dfc5feb75	aac40ead-acb0-b31d-1133-438dfc9a4799	2005-11-30 19:24:03	0
8f6b46f5-7e27-5f78-b4fd-438dfc3545aa	8dca62c5-cb1b-c41b-3f33-438dfce842fc	6ffaba8d-eb1f-c28b-8644-438dfcbea0e4	2005-11-30 19:24:03	0
e58b5588-000d-a3bc-ee5a-438dfc657abc	e3edeb09-fb89-e2c2-1322-438dfc7bfad9	a13886ab-0e56-9291-0447-438dfc4546dd	2005-11-30 19:24:03	0
21ab3f07-1fdb-4a57-4a66-438dfc30ab98	20161e89-2100-9258-9af6-438dfcdb1a49	2ca40a4f-c1a5-8085-4cbf-438dfcd9c2a9	2005-11-30 19:24:04	0
7535440f-2b35-b412-5e60-438dfc009109	7394d6e9-539c-5db8-9a7a-438dfcbe0988	33126c17-e9a1-4bd9-a94f-438dfc78c4ee	2005-11-30 19:24:04	0
bad09846-388d-3e1b-4c62-438dfcf62c78	b93dac3a-e290-5d45-110a-438dfc602cdd	86d63404-ca50-c4d2-1038-438dfc0d2ce3	2005-11-30 19:24:04	0
eb08cd61-d183-95db-59f1-438dfcd255fb	e96ce373-5de7-3ff5-e269-438dfc55dd58	cc3411e6-b2f4-24e2-08cd-438dfcde2680	2005-11-30 19:24:04	0
270df2b0-e974-9157-2499-438dfc7a1f95	25710323-2c57-7caa-a4f2-438dfcfce895	85840e37-3aaa-7bc1-b257-438dfc9b70fe	2005-11-30 19:24:05	0
6958deac-45d9-77dd-8793-438dfc248515	67aa3a74-86ba-bffd-2fe2-438dfc3521d1	386ecec0-8eb5-ce3c-0c4d-438dfc08982a	2005-11-30 19:24:05	0
d345d16f-a9e4-fbfe-88b7-438dfc63ece2	ad950b55-a66a-cc8a-93b1-438dfcd921bc	7b1a3ffe-b883-9f36-d29d-438dfc6a9109	2005-11-30 19:24:05	0
f8570e35-15dd-a4ab-5655-438dfc49fb2e	de200f07-ba11-2ae4-faf7-438dfc74839f	e4c2a7f1-29e7-e674-dfda-438dfccc2bc2	2005-11-30 19:24:06	0
3fd7cf51-22c9-b803-ade1-438dfc24aec4	3e3d3d92-3860-f8f4-f280-438dfc2cf2ea	20eb8a51-b7ce-0529-75b1-438dfc371e81	2005-11-30 19:24:06	0
7025086b-d2b2-c1d8-368d-438dfcc12910	6e88151b-682d-7a0a-dd80-438dfc5478d2	514fcdd2-d85d-1a7d-7f1d-438dfc1bfc2b	2005-11-30 19:24:06	0
c8002618-2aec-9526-b896-438dfc7d773b	c6681a81-3939-6a60-4e07-438dfcf0e0a4	818ba130-82a0-510e-243c-438dfcadc657	2005-11-30 19:24:06	0
422e09c5-6951-552e-0a5e-438dfc41ce2f	286e0e17-2430-a3f7-8cc6-438dfc4fa0cf	d967f00f-b4fb-546a-e2cd-438dfc51e139	2005-11-30 19:24:07	0
59d547ed-d806-8098-8e9f-438dfc334050	58208eee-c9c1-125e-3811-438dfc7112b9	159db820-3506-22d0-baae-438dfc9d48c0	2005-11-30 19:24:07	0
8a57f830-a969-ee99-fec9-438dfc595f0e	88c81d27-3d12-9510-ae38-438dfcf82eab	6b413b0a-a8f4-82f5-bdd6-438dfc03fea7	2005-11-30 19:24:07	0
d0729ce4-8efa-f538-8ce6-438dfc3bc4e5	cedfa7cf-ea3f-a340-fcaa-438dfc12e9ce	9c278db4-ede9-c13a-af84-438dfcd5ae49	2005-11-30 19:24:07	0
324ccfee-f0be-df43-f2f6-438dfcb924fb	30b62c36-b386-4290-0e47-438dfc4a2bf5	a410043f-7a9a-f5fe-d34c-438dfc51da32	2005-11-30 19:24:08	0
88698ef8-5c87-255d-2310-438dfcdf6870	86d71b11-0761-0bf5-e5d3-438dfcce0ef4	439df1d9-a1d2-938f-fcbc-438dfcc0b382	2005-11-30 19:24:08	0
1a8a0cd1-a769-de95-e665-438dfc1ea2df	f3000bb9-e3c0-ff62-e375-438dfca40cdf	9a01d899-3cd3-82bc-4879-438dfc4aa427	2005-11-30 19:24:09	0
334db57e-730f-197b-ee28-438dfc9941ea	31b5c226-2e04-a196-3c19-438dfc174d3e	13b9ce8d-5a7f-dc60-5f5d-438dfc417588	2005-11-30 19:24:09	0
a0843298-2bfa-fcbe-4c8c-438dfc1b0a04	9eeb232a-a4f1-ed2c-c143-438dfcceb376	451eba4c-ebbc-e355-a55d-438dfc6dd0bf	2005-11-30 19:24:09	0
d3a3095e-d24c-728a-001d-438dfcbe0573	d209c8fd-6c01-7e91-8c0e-438dfc8a1504	b4f569b4-c6a8-b257-fcb4-438dfcbcb5f0	2005-11-30 19:24:09	0
246aa272-8407-9b36-3c0a-438dfc0de3b4	22c8beda-adff-08ba-dbeb-438dfc13450f	e5ff98ed-075f-7aa5-56fa-438dfc049120	2005-11-30 19:24:10	0
6898db79-f078-5831-e943-438dfcbe5efc	66f126ef-b713-3247-7b77-438dfc658ac7	361fafb3-51ba-58de-391b-438dfc2a0aec	2005-11-30 19:24:10	0
b03614d5-3bda-7418-5e8a-438dfc8c02db	aea4831c-5231-61c4-7802-438dfcaf4014	79e65b4a-b856-c71a-19a1-438dfc5344ec	2005-11-30 19:24:10	0
e0bedc6f-089e-6ccf-f2c7-438dfc5fe32d	df213b23-496d-3620-2bbf-438dfc9f8d9a	c1abebb3-fd9d-f3f4-8bc6-438dfc756f30	2005-11-30 19:24:10	0
5847a3ed-c8b1-cfc5-4ede-438dfce99c93	56838ea9-aa3d-5423-9872-438dfcf63782	f21a7b1f-7757-acc5-7e52-438dfcb88dc0	2005-11-30 19:24:11	0
88409870-7adb-b235-873c-438dfcf16c31	86a907ed-4424-dc00-a4e4-438dfc4e9d9d	698916c3-7e8c-21c5-1f38-438dfc3931c8	2005-11-30 19:24:11	0
bb7f0195-e5ba-5659-01d1-438dfce9d4be	b9e4c8ef-9d50-e6a3-0e62-438dfc2643ad	99edc13c-8d09-83c1-83b2-438dfc899358	2005-11-30 19:24:11	0
1f9f4e26-b95f-da15-0817-438dfc0f753c	1e0469ab-9117-83ae-fed5-438dfccb0bc6	ccda2c25-4079-1062-d2c6-438dfc514858	2005-11-30 19:24:12	0
4fd7d8f7-2b40-1772-3c63-438dfc99f392	4e3f1c21-4148-69b1-ebe1-438dfcb31413	310c5866-e450-bfc4-afcc-438dfc5e80b4	2005-11-30 19:24:12	0
8004bd7e-e762-73fc-4014-438dfc926ae0	7e7287ae-b7d4-2a06-bedc-438dfc4fad59	61688ffe-959a-5488-a5b9-438dfc944381	2005-11-30 19:24:12	0
b344bd6d-c65d-1c73-7551-438dfc5534d3	b1adefbb-4bb8-b05f-048e-438dfccf6e48	916437d4-a690-4aea-354a-438dfca40de6	2005-11-30 19:24:12	0
1819ca3c-a938-67d2-1998-438dfc88fb71	1667cb26-d3b2-6f41-a212-438dfc8a1ecb	c4c60cc4-e0e3-66ee-43ed-438dfc2a8f86	2005-11-30 19:24:13	0
5cfc90af-fee6-6e6f-ba33-438dfc94ca8c	5b62c09b-b0d7-b1f9-e7cb-438dfcf7080b	2968bc75-db89-7fcb-56f8-438dfcf65bda	2005-11-30 19:24:13	0
b94f97fa-864b-829d-ad1e-438dfc0489d6	b7af1167-99a1-a622-1342-438dfc3bb053	6e579ced-dff1-b00e-054c-438dfcb0a2bf	2005-11-30 19:24:13	0
1ecfcb0e-edb9-997d-24b6-438dfc51c48b	1d21b0fb-22f4-2ec6-787a-438dfc998f7a	f3fa2d58-c633-1382-097e-438dfce35be4	2005-11-30 19:24:14	0
4f219422-8498-4145-29c6-438dfc532fb3	4d7872ae-56de-3337-d7aa-438dfc27e99c	30363e25-8393-14c0-d0de-438dfc6cd1fe	2005-11-30 19:24:14	0
abdb009a-d7df-3ab0-3405-438dfca37d1c	a7f84ad6-e17d-6838-af56-438dfc6045b3	60a1fa34-84d7-e72b-2fbd-438dfc23de44	2005-11-30 19:24:14	0
2a4c1fea-c8a3-e312-bd22-438dfcfdfa1c	dbd852b6-5847-51e5-2ca0-438dfca4c0f7	be2f892b-c4e9-bc8c-5209-438dfcf7aa79	2005-11-30 19:24:15	0
5c3cf2be-084e-bf37-b014-438dfcc74824	5a9d221b-2d53-70e0-7203-438dfc397e53	3be4c4aa-56e8-3702-fcfd-438dfc276ebc	2005-11-30 19:24:15	0
a32e9643-3e23-a6a0-be8f-438dfc213fd8	a19663de-1756-1933-f6e3-438dfc58729f	6e20cb65-1e32-a00f-8b24-438dfc59657c	2005-11-30 19:24:15	0
d7434667-33dc-3bad-a0a7-438dfcbbe0e0	d5a97764-c393-eaea-58bc-438dfcacb1dc	b7bf4834-8d96-03b7-3bbe-438dfcae3cd2	2005-11-30 19:24:15	0
3f5085cf-60f5-7598-1d03-438dfc845a8e	3d9feb84-fc2c-1a2c-c9a9-438dfc416697	e95db6e7-ddc6-81a1-45d6-438dfc91048c	2005-11-30 19:24:16	0
b4093b0a-3e3b-00b5-a207-438dfcdbe2a3	b2685512-7246-0e04-8d4e-438dfc56e676	51155650-c6fd-ca1e-6a67-438dfc197159	2005-11-30 19:24:16	0
e4b31584-1808-007c-8ede-438dfcd87477	e31af5c5-7c04-fa01-257d-438dfcf37ba9	c5bfba5d-771e-4caa-ef86-438dfc5b8d25	2005-11-30 19:24:16	0
76f6d86d-fa79-80d0-2bf6-438dfc612c67	5fc05901-06d1-7fb1-128d-438dfc96ed66	20100cbc-1024-71ea-4c44-438dfc40c76b	2005-11-30 19:24:17	0
a753f620-df31-6fd0-3b95-438dfc1841cc	a5c0e5e2-40af-8afe-b64f-438dfc1519b9	884c44e1-66a1-d00a-3fb0-438dfca704ba	2005-11-30 19:24:17	0
2770db98-7000-23ed-c05f-438dfcca8770	101f5693-007c-caa8-b449-438dfce62e4e	bb9a2963-700d-a74e-65e3-438dfccc85f8	2005-11-30 19:24:18	0
57ce77ba-ab9f-bd81-046f-438dfc9e6832	5634ef21-b974-2a6f-bc6a-438dfcc2748b	38fcbc18-f72b-fbe8-81bb-438dfc45196a	2005-11-30 19:24:18	0
881b8331-31e5-319a-93cb-438dfcea186b	8686ff30-7b69-f3f3-c66d-438dfc3416f7	6958a392-e1fd-f1b0-a66a-438dfc52fe10	2005-11-30 19:24:18	0
1f0fb77d-e7f7-0d79-6ee4-438dfc1d824e	1d6dce20-fd1b-58d6-7bfd-438dfc523409	99f44c3f-87e7-9558-992e-438dfc055159	2005-11-30 19:24:19	0
7b703454-fa87-2d30-f60a-438dfc4e75ca	79d84faf-e692-3c6c-f10c-438dfc68485d	30885088-ff80-58e7-e745-438dfcbcf297	2005-11-30 19:24:19	0
af0a8cfe-0775-36c1-b9e4-438dfcef36ce	ad6d90cf-120f-4778-94f9-438dfcbb4b66	8cde5ad7-4cd2-4365-1771-438dfcf53c75	2005-11-30 19:24:19	0
180c854c-b70b-dc15-97de-438dfcafc80e	16715109-d4b1-2eb3-7d82-438dfc9e1b52	c0a21503-5f76-f00e-48d9-438dfc082df1	2005-11-30 19:24:20	0
48aef1b5-1d58-6ac0-1509-438dfc0b0f83	47150fc9-3e20-53fa-ded0-438dfc698e87	299f8caa-246a-2d76-cc17-438dfce96996	2005-11-30 19:24:20	0
c1c5ed73-630c-ff7d-959b-438dfc417fa5	c01b3b25-d91f-2a22-8b48-438dfcdfec2a	5bac5a31-8b26-551c-115a-438dfc10fa26	2005-11-30 19:24:20	0
2af85c05-51e6-c8be-bfea-438dfc1e0b5c	295fabdc-00a3-3a72-73d0-438dfc630da6	d3364601-0197-635a-5243-438dfc4ccd2b	2005-11-30 19:24:21	0
cf6e429d-89f9-df0a-0e0e-438dfc0fcba2	b71edaad-1126-abe4-5b96-438dfc9c8e7b	3c85e9b6-2a9c-6ac1-8654-438dfc6d6a4c	2005-11-30 19:24:21	0
\.


--
-- Data for Name: accounts_opportunities; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY accounts_opportunities (id, opportunity_id, account_id, date_modified, deleted) FROM stdin;
ab5a52f0-f20b-755a-c238-438dfb8ed112	a9130d4f-4b18-75b1-a60e-438dfb3e91ab	a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:24:22	0
aef8d823-4cbe-8d8a-a973-438dfb0d5767	acc0cd10-2955-e023-16a6-438dfb756fac	a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:24:22	0
b3b1ef53-3641-a178-1219-438dfb5211ea	b171c0dc-1868-6f3b-cd40-438dfbd0ffac	a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:24:22	0
b7415fc3-3b79-ce2f-ebd5-438dfbd0bea4	b508b238-98b3-b241-af76-438dfbcfe97a	a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:24:22	0
bad5c379-1e14-a2a2-b498-438dfbdff4fb	b89ca586-f374-76c7-9bbf-438dfb7f5122	a69dae1f-b2ee-1257-3895-438dfb8ea964	2005-11-30 19:24:22	0
ed901e48-9f0e-e2e7-e8ce-438dfb2100fe	eb4c23ba-ba10-3f93-85e2-438dfb636f95	e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:24:22	0
f12e9b9f-b595-423e-f821-438dfb4a3aa6	eeec795e-ba5f-a648-500e-438dfbdc68a0	e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:24:23	0
a0a00bfd-5503-6bbe-25ae-438dfb6dc70f	f28d386f-f2c4-8352-389a-438dfbf326c2	e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:24:23	0
44680430-162f-d4c4-2a5c-438dfb722a26	20000e9a-664d-3ffe-b57c-438dfb9fe46c	e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:24:23	0
7ea50a64-1179-9f6f-4a98-438dfbafe575	5a480466-7328-4a1c-e7c9-438dfbd42012	e908e57d-18d3-5ffa-f6f4-438dfb104441	2005-11-30 19:24:23	0
1dc5958f-6c98-d179-fa8a-438dfbd2b900	1aeeaa62-d3a2-5647-0e6e-438dfb2fbc94	18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:24:23	0
230f9dc7-d516-7de6-a6d1-438dfbddce17	203816d6-65e8-3473-1d32-438dfbef4cdb	18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:24:24	0
27de0ca6-8104-8188-f60f-438dfb7ba748	24721704-517e-7405-f8d2-438dfbdfa046	18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:24:24	0
2c2a99b5-457c-c42e-4860-438dfb6dd29d	29574c57-f4ab-e2e9-3ba5-438dfbef747b	18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:24:24	0
30642a1e-03b2-7158-1883-438dfba2cf2f	2d8c4adf-acdc-919c-0940-438dfb522c7a	18ae2ab5-0bfd-980d-2519-438dfbda705b	2005-11-30 19:24:24	0
46d0c9f6-bfc8-c86e-dde4-438dfbdbf2f6	43d71a67-04d7-d4db-7144-438dfba4f817	419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:24:24	0
4b427cb4-7868-4b4c-7b3b-438dfbe0d82e	486a05a5-d58a-3848-3cea-438dfb72e88c	419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:24:25	0
500dc8ce-7083-b461-3ec1-438dfbfee3d9	4d3be41a-98c1-2ccc-11eb-438dfb33a5d9	419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:24:25	0
544e17c2-cb99-0d34-3025-438dfb834521	516c0dd8-1648-a8f1-07b3-438dfb3c3bdf	419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:24:25	0
58858d3c-6512-e00d-b99f-438dfb326802	55b035af-9ea8-18b3-f2a8-438dfbbf6bca	419aa1b7-1392-c018-5c08-438dfb43dd59	2005-11-30 19:24:25	0
6cefefe1-7658-58fb-e3e9-438dfbf57da9	6a0f932f-6db4-4557-c31b-438dfbeb6a3d	67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:24:25	0
711d6db8-12fa-aaef-c10f-438dfb10930b	6e50a508-7d24-612a-25e8-438dfb2be60c	67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:24:26	0
755123f2-854a-103f-e409-438dfb535dc1	7277a541-4f1d-11b1-8fe8-438dfbc8bc86	67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:24:26	0
798f3011-ed73-47f4-9e78-438dfb7956ee	76bc32c0-5b68-9fda-919b-438dfbb2872f	67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:24:26	0
7dba1cf5-1744-ec34-4c47-438dfb8ba8bc	7ae44450-386c-2247-2db3-438dfbba06c7	67c3c020-4ffe-b315-284a-438dfb4cd6d8	2005-11-30 19:24:26	0
9446f741-b617-5342-410e-438dfbfaab37	9170671e-56a0-38f8-19e1-438dfb206eb4	8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:24:26	0
9892a918-ce62-5676-d690-438dfb37b451	95ac2580-18f0-fc28-3248-438dfbf51dce	8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:24:27	0
9cd1153a-143f-4aa7-fe40-438dfbbd7804	99f50e68-04b8-9df7-9f9a-438dfbb52769	8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:24:27	0
a1bee0fe-3a1b-fbfc-0580-438dfbed7493	9ef1eb6a-311a-5042-aa27-438dfbf49362	8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:24:27	0
a5e3d2c0-8edb-779d-3a67-438dfb102a9c	a31e15c3-17c9-985d-4717-438dfb286df2	8f2b0a70-46e7-f25a-7dcc-438dfbc8112e	2005-11-30 19:24:27	0
ba773325-9709-cf21-86f6-438dfb9f2e47	b7a13091-d708-3182-f773-438dfbf99df7	b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:24:28	0
bf7cb11d-fa64-8e79-5cfd-438dfb277ea8	bca6c204-1065-70b5-8bf3-438dfb2d66ae	b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:24:28	0
c3b37f1b-1303-c06d-97a1-438dfbb736f5	c0e36b29-feff-f1ec-90c4-438dfb968255	b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:24:28	0
c7e95c72-a511-ef2e-110f-438dfb8e8870	c514a192-eec2-7334-322a-438dfb27c098	b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:24:28	0
ccf7ec9e-d5df-1ef7-6d47-438dfb3b1bc9	ca217b49-12e1-bd3f-ec6a-438dfbb24d34	b560e2dc-22bd-6582-bc09-438dfb8ffc59	2005-11-30 19:24:28	0
e1465454-dca8-55ed-9b2d-438dfbdf23a5	de665b39-a857-dd80-84ea-438dfb8dfab5	dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:24:29	0
e593020e-aa5f-ce79-64e7-438dfbf3f8e3	e2b38d24-5d7f-972a-f13d-438dfb03a319	dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:24:29	0
ea9db333-6e40-59a5-1e3f-438dfb5af1ef	e7d0bb7a-663f-c474-b598-438dfba444f3	dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:24:29	0
eed25373-d374-8f33-81b4-438dfbd78e27	ec0467f2-b5ad-6a64-d2ad-438dfb9600c6	dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:24:29	0
f3071751-a105-d5de-626b-438dfb7eae26	f02d1234-0634-7e79-0c48-438dfb2a65a4	dc2a7c81-a009-cace-2d18-438dfbabf3d5	2005-11-30 19:24:29	0
1334bd65-fc75-a111-f428-438dfb05dc1a	105c9214-bb9c-113a-99da-438dfbadd373	e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:24:29	0
1771afc4-0ce6-f910-35ca-438dfb9f5709	1494dd91-42fa-f017-d6c3-438dfb9d1a72	e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:24:30	0
1ba10d0f-c2d5-3f40-c359-438dfb851433	18ceb868-625d-80bc-c7fd-438dfb29d9b5	e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:24:30	0
1fe28ff2-f9bd-9d09-d08e-438dfb701652	1d044d87-32c8-abcc-ace6-438dfb7ca942	e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:24:30	0
2413a37c-88c9-1ed6-d45b-438dfb25c63b	214602ee-b95b-3137-3d8c-438dfb5a82c5	e2060a5d-c072-69b9-fea6-438dfb520511	2005-11-30 19:24:30	0
38b45ad3-cdf8-7cb5-7012-438dfba1cc07	35d00e43-d4de-8d0b-c33b-438dfb6b2d7b	33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:24:30	0
3ea7ffde-32a1-d514-25fd-438dfb6f4ab1	3a1df0ce-983c-0969-a957-438dfb85a6b1	33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:24:31	0
431f7dd4-5d02-a6df-4169-438dfbe7f37f	404edcbc-2e85-0029-90b5-438dfbcdcc16	33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:24:31	0
482d502c-58cd-afc9-ff4c-438dfb68c70f	447dd4e9-2ce3-5968-071c-438dfbe1abfb	33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:24:31	0
4d900b74-854f-db95-87c6-438dfbffcd56	4a9f565e-e437-a1b8-16c0-438dfbf75a4c	33919037-63ff-98f9-4447-438dfb5acbdb	2005-11-30 19:24:31	0
658c46b0-dfb1-52aa-a1a3-438dfba81610	6289d588-12ac-2777-9b86-438dfbc0b8b7	60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:24:31	0
69fa8479-0129-5892-a72e-438dfb06a6cf	66f6f12f-623d-7a23-a595-438dfb0b3521	60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:24:31	0
6e630307-5789-8afb-baae-438dfb634f89	6b67eb06-0c2e-bcb5-a86a-438dfbf0584f	60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:24:31	0
792350ec-6511-f8cd-4b6e-438dfb41003c	70f9fcf3-e464-91c5-b757-438dfb259acb	60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:24:32	0
7d47f6cc-4344-3555-adfe-438dfbd40d39	7a7daba2-cdd6-2a09-efed-438dfb963c1b	60413755-db82-584c-101d-438dfb6380b1	2005-11-30 19:24:32	0
91d343d0-6998-776c-3b97-438dfbd0513c	8ee9bfa5-4147-1ccb-c605-438dfba19d04	8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:24:32	0
9852f8ce-2fe4-c546-ddb1-438dfb75b17e	95735786-8211-9acf-0f8e-438dfbf9b1b9	8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:24:32	0
9cab0774-cb0d-097b-da4c-438dfb534aef	99be676a-236a-a0a1-22c1-438dfb03ae81	8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:24:32	0
a0e09d8a-a323-b52a-a239-438dfb7d68eb	9e089f00-5c04-a45f-c0a5-438dfb834c80	8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:24:33	0
a50699e4-68c5-58c2-9b0e-438dfb708cd3	a2371147-3751-a8db-b434-438dfbd79365	8c9f383e-c1b7-70f8-3208-438dfbc39940	2005-11-30 19:24:33	0
bbda236a-9fb2-d8e6-7b4d-438dfbc9f504	b8fdd212-b271-2d57-785f-438dfb3292c9	b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:24:33	0
c00dc0fa-5201-b2e4-0ecf-438dfb6da952	bd38bcad-f228-fbaa-4d87-438dfbe201a8	b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:24:33	0
c446c427-2d21-b90f-37ce-438dfbf5e698	c171d6ae-5139-b31d-1dfc-438dfb8f5a3b	b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:24:33	0
caf42fdf-13cf-6c08-e322-438dfbf1f98f	c6d9de5c-c0cd-8f81-235b-438dfbf3ce7d	b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:24:33	0
cf3e4081-5038-5c7f-3abc-438dfb89add7	cc533b9a-0df9-c52d-0f8e-438dfbb7af3b	b6bcb002-7146-374e-0f62-438dfb1ecc89	2005-11-30 19:24:34	0
e3a24f3e-93e4-eeed-feed-438dfbb6744f	e0c60e4f-899e-90df-4897-438dfb8f32a1	de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:24:34	0
e7e2fa93-0a64-499b-c20e-438dfb21b174	e50fe650-5a42-e6da-b999-438dfb926894	de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:24:34	0
ec1a9d25-0744-9b53-896b-438dfb1989bd	e941229f-6b4a-7a2a-9c3c-438dfb5808dd	de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:24:34	0
f04db1c5-329d-7cbf-41c3-438dfb11aa5b	ed822ec6-67bd-1d16-df7f-438dfb5fcde0	de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:24:34	0
61d00670-1661-b4bf-6da7-438dfb0b82ea	f1b32bec-31a3-93d8-3b54-438dfb58d782	de8788ae-186e-8976-b01a-438dfb2b8a05	2005-11-30 19:24:34	0
14c3a9e0-ac88-094a-0460-438dfbc8f985	11eca2eb-efc6-a62f-eaf4-438dfb6df46e	fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:24:35	0
192d6acb-eb2c-300b-0b5b-438dfbc162fb	1631dc34-8d53-cf32-0ef5-438dfb36ef00	fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:24:35	0
1d6999ec-32cd-4104-ba3d-438dfb37fe01	1a8fb7f5-9014-08bb-5ce5-438dfbcfa51d	fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:24:35	0
21af5be4-deb3-c0ec-3bb7-438dfbf6a9ef	1ecc6128-d97f-6233-282b-438dfb85d241	fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:24:35	0
25d87a35-0e74-d22d-8da2-438dfb1fdfbd	23098121-e6f6-eb78-833c-438dfb37a85f	fab50378-1552-a629-0700-438dfb1e3c07	2005-11-30 19:24:36	0
3f3449b1-eeaf-29b0-36c9-438dfb809bfe	3a6eac63-b120-c78d-2848-438dfb8d3403	382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:24:36	0
43a172b9-36e4-28d1-db05-438dfb607e64	40c29fa5-6ac6-bf1c-b0ec-438dfbbfdade	382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:24:36	0
47f178d8-2084-a8b0-19d1-438dfb45caa9	44fe4098-6460-bcc6-1217-438dfbe8c8d6	382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:24:36	0
4c2efddb-63d6-f750-6094-438dfb24b24d	496010ce-3b2e-09f9-c291-438dfb920fd7	382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:24:36	0
51d1c0dc-88b1-a3dd-9307-438dfb41ee0c	4efde88b-54fd-197c-5c18-438dfbc2a7d7	382799fa-9f4d-a2a0-f436-438dfb2ab9e1	2005-11-30 19:24:37	0
66320157-cf5a-4fad-dccc-438dfbc7b3d8	635300f6-3ce1-c18f-26e7-438dfb5eb96e	611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:24:37	0
6bf6c863-06f2-d3e8-9ca7-438dfb08807d	6917febf-23a4-e165-3f33-438dfb1f0d7a	611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:24:37	0
7025c1fe-c51b-bdce-31bf-438dfb039a5b	6d551148-2345-c48e-6b48-438dfb66bbda	611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:24:37	0
745a8068-0499-fc60-aff4-438dfb4f9fc0	718ac3d7-3e89-c215-2642-438dfbc52fac	611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:24:37	0
7898a259-0b83-f8b5-e6ab-438dfb345871	75c62ad3-1e26-630b-44fa-438dfbfc20c8	611c2870-5b76-3473-fa0e-438dfb4778a4	2005-11-30 19:24:37	0
8d1cb136-b02e-8df4-10b9-438dfb4cf87a	8a371776-a899-09d3-cece-438dfb7f9c9a	87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:24:38	0
92e9391a-da15-383e-24c4-438dfbed7cc7	900ff1da-ab7e-cae3-b44e-438dfb74b101	87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:24:38	0
97283868-af5d-f9cf-8f90-438dfb6c775f	9446d2e6-884e-bf4e-f30c-438dfb167da3	87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:24:38	0
9b66aa31-d308-97f9-d388-438dfbf9c367	988e857f-0c3c-2092-e6f5-438dfbc16c15	87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:24:38	0
9f9da10a-3ff4-1e7e-fbbc-438dfb296dbe	9cc405d0-b8b7-0443-ddd5-438dfb27966b	87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7	2005-11-30 19:24:39	0
b3ea5df0-9901-df53-0507-438dfb47355f	b10e08c2-794c-f082-7b90-438dfb013dd8	aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:24:39	0
b9c16e2d-f883-c64e-86e9-438dfb905a7f	b6ed0242-cadc-3043-61e1-438dfb739a47	aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:24:39	0
bdf606d2-6441-81d3-c3a5-438dfb53b694	bb21d4c9-fb01-da73-ee1f-438dfb4f7d23	aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:24:39	0
c2357ecd-2d46-080c-145f-438dfb9b518d	bf5252c0-a6e0-1d00-089a-438dfb6f2e8a	aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:24:39	0
c673703e-3f2f-38cb-075a-438dfb92a387	c3a9a7bd-d971-bb93-200e-438dfbf7bfd4	aed2dd85-41f1-3abb-02f3-438dfbd64a1b	2005-11-30 19:24:40	0
dad5fed4-21e2-78d4-9f8d-438dfb8a2d42	d7f5cc35-596b-41a1-77b8-438dfb9ed2b4	d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:24:40	0
e0bf0c03-da48-db81-d65e-438dfbcc14eb	ddeaa47f-d849-a3d2-1d9b-438dfb704fde	d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:24:40	0
e4fdef8b-e2d2-624c-3d93-438dfb322965	e21969b7-27b5-0ffb-bb0f-438dfbc51831	d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:24:40	0
ec8f7fb2-0aba-3aec-08e3-438dfb1816f9	e9bf498f-8786-d8b3-4dd2-438dfb65ad82	d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:24:40	0
f0c16aec-99b9-9173-1f72-438dfbea56a1	edf3eaad-908c-143b-4367-438dfb9b177e	d5b953e2-7668-721f-21cc-438dfbf0b385	2005-11-30 19:24:40	0
111a1330-f752-cf1c-bfd0-438dfbecd2ca	e43d0441-1260-9ae2-8031-438dfbc64692	c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:24:41	0
1704b469-35be-7f94-5f69-438dfbc2a34f	14345cd3-280c-5c16-5828-438dfb103a04	c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:24:41	0
1b42cd07-95d1-e8f6-0f55-438dfb558535	186a5e5b-41b5-3b28-6a5c-438dfbdce751	c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:24:41	0
1f95be0e-ee11-3d20-7352-438dfb0d6eb4	1ca79b01-2912-194e-7c4f-438dfb4028f4	c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:24:41	0
258a30c8-f492-7117-36ad-438dfbc99c5f	22be683d-e9c0-cd3c-1270-438dfb89f66b	c08208ee-c631-2468-f4ef-438dfbb1f92c	2005-11-30 19:24:41	0
3b4fba42-0927-a5b0-28ce-438dfb98683e	387377fb-84d9-38d3-a9af-438dfb253999	3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:24:42	0
41864530-993c-4b73-ccaa-438dfb1ca576	3ea62d61-48cb-40dc-e25b-438dfbd4f8b9	3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:24:42	0
45af31ab-b0e4-7333-e09c-438dfb43cac8	42e12bdf-efbb-d5de-2d8b-438dfba4866f	3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:24:42	0
4a2cda61-7fa1-773a-177e-438dfb8d425e	47357431-a183-45f1-f548-438dfbe9a4b7	3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:24:42	0
5062a13e-ffac-d979-4f5d-438dfb101892	4d6868f7-0a1f-a382-16d2-438dfb782672	3624c5a8-5dcf-8f66-f9a1-438dfb26f2da	2005-11-30 19:24:42	0
64f8efae-76a2-597d-5b5c-438dfb4958db	6223525b-54eb-05ff-793a-438dfb5aee27	5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:24:42	0
693d98ab-d28c-c97b-4170-438dfb3f7ce6	6667fc8e-a7ab-4df6-aaf8-438dfb23692c	5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:24:43	0
6d871527-c016-bade-1516-438dfbac2f5d	6aa4d67f-ac50-1131-8922-438dfb68dd72	5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:24:43	0
71b44375-d542-8995-c89b-438dfb1ea195	6eea83ce-7902-9ba1-8e71-438dfbed9f13	5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:24:43	0
7ef0e601-bc5a-5647-2a16-438dfbe4ab1a	76d1a88c-fbb7-ddda-8f0f-438dfbda8592	5fd3e853-98f8-6dbf-208c-438dfb9d5c69	2005-11-30 19:24:43	0
936bc75a-6fe3-93a2-7013-438dfb71f9af	909302ac-7ff3-2e03-7564-438dfb170850	8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:24:43	0
9b906b3f-82f5-87b7-68e7-438dfb5336af	98aebb7c-d037-424f-1c76-438dfb36b326	8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:24:44	0
9fc1c75d-e87d-19d2-a551-438dfb5e3ad8	9cf1c693-d709-0a02-70b9-438dfb1ad045	8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:24:44	0
a3eec61a-1121-ccef-1691-438dfbffeae1	a11bd3ef-a553-7a9d-f88a-438dfbf9df66	8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:24:44	0
a81f8a93-a41d-777b-6585-438dfb7fd229	a54f868a-82ea-9d07-2ce5-438dfb4973b3	8e54f9ad-8ffe-e5ca-b871-438dfb253fb7	2005-11-30 19:24:44	0
bea0c5ed-6d01-616f-df28-438dfb8e744b	bbc1d9e7-5eae-54ca-759f-438dfbd95c6e	b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:24:44	0
c2d7a2b0-f643-46b3-dc3b-438dfb89d86c	bfffd7ba-b9ed-40d3-1927-438dfba0eb91	b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:24:45	0
c71035cf-0bc4-5f2b-90c6-438dfb2ed84a	c436b267-d756-178a-fd78-438dfb644921	b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:24:45	0
cd5a6f1d-082b-9ca9-c9c9-438dfb2abed7	ca75f6ab-2aa7-3cb2-e71e-438dfbcaecfe	b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:24:45	0
d181c4e2-e4eb-ab6a-889a-438dfb6b497c	ceb480e7-64a6-9afb-149d-438dfb573a37	b97ff471-9ee3-0e12-2dd9-438dfb9b36e0	2005-11-30 19:24:45	0
e671aa96-433f-5745-e4ef-438dfb6dbb62	e39766ac-9a99-a932-4f1e-438dfbbad05d	e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:24:46	0
eaa42c37-fe58-d5d9-63f5-438dfbca3c40	e7d709a6-b809-ca72-1a40-438dfb0d707d	e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:24:46	0
eed1fea5-529b-afc8-009a-438dfb4fc010	ec00f476-445b-3716-6189-438dfb0f4916	e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:24:46	0
f3103922-2500-87f9-3c2f-438dfb0187f8	f0310549-81f9-63c9-f827-438dfb2b3a30	e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:24:46	0
35220e00-4976-ec57-808d-438dfb48db84	578009ee-5941-4ccc-4d1f-438dfbfbc463	e153589f-133b-e390-b669-438dfb24cd9f	2005-11-30 19:24:47	0
17ed6313-b0f1-845c-3748-438dfb0a3c97	150bdc7c-b627-0aba-209e-438dfb16a02f	12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:24:47	0
1c2395ec-6639-be5f-30ad-438dfbb656f1	19512522-71ad-e96c-716b-438dfbfa6eca	12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:24:47	0
2293b79e-9ae7-2185-e428-438dfb02d91b	1fb93fad-bf04-f712-1758-438dfb14531a	12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:24:47	0
26bf4912-4cb9-3b97-124b-438dfbaf486f	23f16019-be65-d793-a7df-438dfb1c27f0	12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:24:47	0
2b25a7ed-0fd3-8ef1-c668-438dfb087869	28331219-bceb-c6c0-dac4-438dfb091445	12ca7ab1-220a-4af9-99ba-438dfbe5571c	2005-11-30 19:24:48	0
41abe2be-9efe-070e-c112-438dfb8d230c	3cd02b37-dbd0-4e4b-a4ae-438dfb5cd497	3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:24:48	0
45dd461f-fec1-68ce-b91b-438dfb8bc8b1	430926fe-e34f-d919-99a7-438dfbeb50a8	3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:24:48	0
4c859461-d7a0-cb9e-9e84-438dfb9de03a	49b23368-6a73-8143-5d20-438dfb0e49f0	3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:24:48	0
50cf9ed6-809d-afd8-ed25-438dfb8d7dac	4de6406b-7219-540c-a7b7-438dfb81098d	3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:24:48	0
54f62394-ad45-b3cf-3941-438dfb7a9cb7	522637d4-7e6d-8c07-0602-438dfb5fa053	3a942d15-be46-e733-9cd3-438dfbb71e24	2005-11-30 19:24:49	0
6ddc9dd0-7ed0-b01a-c1cc-438dfb9ea8f5	6b019c07-68dd-65a8-92c7-438dfbe4cd8e	68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:24:49	0
7459b7cb-9681-5b53-7cef-438dfb79121c	7187f732-0cfa-5216-d2f6-438dfb1a1c1c	68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:24:49	0
789437ff-cb7f-12a9-2c4a-438dfb2e1a9e	75b92b6b-cf5f-558c-25c2-438dfb17d004	68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:24:49	0
7ccc3330-573a-576a-2eaf-438dfbb39a6c	79f84bba-1213-e651-b93a-438dfb8d0b1a	68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:24:49	0
83627649-a4c0-fef4-390e-438dfbb01cbb	80786e32-e15d-8e23-97d2-438dfbca3d1a	68b936e6-d166-104a-f3f3-438dfb9a2b2a	2005-11-30 19:24:50	0
97d2f811-32f2-a941-e33a-438dfb78f487	94f62a43-bea9-3e7b-2c72-438dfbf9b9f9	92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:24:50	0
9c14167a-42b5-fa49-93e0-438dfb0cd503	993a4897-3d39-2797-cb53-438dfb31c2ff	92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:24:50	0
a04f0238-b7c8-4a71-c429-438dfbd4ef31	9d8129f4-36f9-f3b1-8f3e-438dfb3b5188	92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:24:50	0
a6dd8fab-fdfb-e862-cadb-438dfb4d4d54	a4131561-4061-44aa-7f5c-438dfba6ee8c	92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:24:51	0
ab171c74-0688-8078-1a31-438dfb40951f	a83c5fa5-edd8-1abd-f82c-438dfb9956c7	92b622ce-8026-54c4-bb92-438dfbea0f65	2005-11-30 19:24:51	0
bf7e3b44-ff48-b837-9c8e-438dfb903e2f	bca8f4a0-5513-e884-b6e9-438dfb348c6a	ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:24:51	0
c3ba0278-5f06-a8ea-2dcc-438dfba012c9	c0dfeb78-4757-92f7-5bf1-438dfbe800aa	ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:24:51	0
c7e37b5f-3672-88ab-d443-438dfbff0566	c5138527-d6a9-9b85-6928-438dfb060217	ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:24:51	0
cc223e30-ee5c-9f6d-298f-438dfb020ca6	c9499db7-ebe1-420f-7f7a-438dfb514839	ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:24:52	0
d05b12c1-1850-d17b-3af0-438dfbe63cd8	cd85f5ff-72f7-5465-0f8b-438dfbed9aa7	ba692bd5-98cb-195e-3509-438dfb8e7448	2005-11-30 19:24:52	0
e4bcfbd0-1132-1f1c-da5e-438dfb06a2e1	e1e228f5-f769-aab6-a996-438dfbf36815	df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:24:52	0
eb80b0cd-a020-247f-4a31-438dfb694669	e8a5c939-cb36-bfab-000b-438dfbd53367	df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:24:52	0
efb3970c-a406-5e53-cdbe-438dfb193c6c	ecdc0164-7c80-d016-1e82-438dfbdba73c	df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:24:53	0
f3f18184-ce88-8ffa-ba65-438dfb2a3752	f11b4ee2-c699-d20e-dd43-438dfbe1fbbb	df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:24:53	0
67f30efd-afd2-b8b9-7904-438dfbb8ec68	3b1203c0-8bdd-0f12-8b0d-438dfb1c4eea	df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4	2005-11-30 19:24:53	0
1b087263-8412-0099-02d3-438dfb716821	182ac52a-ff91-3ec0-7d36-438dfb6ec404	15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:24:53	0
1f4b2224-570b-e65f-ef4d-438dfbd3ca76	1c713530-f257-3a95-f459-438dfb51943c	15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:24:53	0
239206ca-9228-6309-e5d5-438dfbd89f03	20bb0875-18e7-2641-347c-438dfb799720	15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:24:54	0
27c9929d-22f7-7a74-6f7f-438dfbf20808	24f449d6-66c5-4b38-bc4e-438dfb90c99b	15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:24:54	0
2c1583eb-1658-49e0-3110-438dfba75f97	292e92e2-cb8f-6095-adb5-438dfb564589	15e6d611-0ff0-efa3-2a08-438dfb32d02d	2005-11-30 19:24:54	0
4295cc13-317e-48b1-5047-438dfbdb75f7	3fba3082-4c92-88a8-77af-438dfb8e7712	3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:24:54	0
46ce6559-1c15-bde4-a7d3-438dfbec864b	43fb7e59-3f4a-86c4-c164-438dfb25a126	3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:24:55	0
4b1c0654-06fc-59df-1d6a-438dfb375f71	4832529c-8844-dc73-2c1f-438dfb078eb2	3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:24:55	0
4f4f96aa-b595-7b04-2f45-438dfb4ec46a	4c7e35bb-ce1f-c1ba-b806-438dfb52c3e7	3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:24:55	0
53ac46cd-c0de-8499-4dfd-438dfbca291b	50b82717-9778-3940-e913-438dfb791eef	3b8554f2-e220-4e32-b135-438dfb52f9fe	2005-11-30 19:24:55	0
67fea6c5-d1b9-a03d-ba95-438dfbc145d8	65263bf0-191a-f025-2052-438dfb781899	62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:24:55	0
6eec2891-9c25-4474-7949-438dfb66cbe3	6c1a1f59-c47d-43ce-ca24-438dfbfc730a	62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:24:55	0
731d45ab-dd85-7ce9-0eed-438dfb9fda0f	704b36b0-ea76-4a1d-c125-438dfbef4b51	62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:24:56	0
774e204f-e697-8c1e-ca06-438dfb22e631	74853189-6a7c-b826-97b3-438dfbabde7d	62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:24:56	0
7e58e5e6-e4ea-760c-b9b5-438dfbe70208	7b787317-53cb-15e8-babb-438dfb626046	62e7c87a-db38-c12d-27c1-438dfb76bf23	2005-11-30 19:24:56	0
999bb287-2c69-1aa2-362f-438dfbbe7d8d	96c2720f-354b-8ce3-1a6e-438dfb16ef09	9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:24:56	0
9dd0a2b3-e88c-36f5-a4d0-438dfb53934c	9b0029ca-43b2-cc07-55ae-438dfbc8ea5d	9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:24:57	0
a20b450d-4c33-da07-69ac-438dfbff6bc3	9f335af4-b994-e4d5-8288-438dfb19a4c7	9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:24:57	0
a63e0cf4-b77c-0206-33e7-438dfbb59257	a36d460a-3ed9-997a-567f-438dfb4c979d	9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:24:57	0
aa72f849-6192-4307-de86-438dfb8a0247	a7a00d4e-144c-3381-22d7-438dfbb8cd2d	9483cdff-0afc-bc72-342c-438dfb495915	2005-11-30 19:24:57	0
becb4f5e-d193-b583-8069-438dfb010db8	bbf053a5-1b46-703d-e67d-438dfbabea0f	b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:24:58	0
c5f46750-0a20-c222-4825-438dfbf04aab	c30e3542-7d57-c675-ab0e-438dfbe556b7	b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:24:58	0
ca284d87-838c-d057-eb27-438dfbf87491	c7556e64-0f55-a8dd-f426-438dfbb1cc27	b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:24:58	0
ce5cf576-980c-4e2c-4162-438dfb04c1a3	cb8bf22a-dcfa-a154-e2f1-438dfbfbff74	b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:24:58	0
d28c7738-c39d-e4b6-aba9-438dfb89d351	cfb559bc-38b2-4d6a-aef5-438dfbcc082c	b9b66e60-dbc2-97f8-d5b4-438dfbb7431d	2005-11-30 19:24:58	0
e6fa6b5c-9591-9753-7778-438dfbd9f622	e423ee95-bd33-3f28-6e4b-438dfbbc59c7	e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:24:58	0
eb335cdf-68fb-addd-82f8-438dfbf91274	e857acc4-1b7a-b682-31ee-438dfb10e679	e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:24:59	0
f2588bd3-5580-ab90-1962-438dfb78bbe9	ef7b8188-ae75-7d73-a3bd-438dfbd8c7a7	e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:24:59	0
26d40c6b-a397-d1ee-5bfe-438dfb2d1bd3	f3b4441f-3c57-13c7-6cd6-438dfb325180	e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:24:59	0
73b40f45-aed4-8f4a-3f7c-438dfb73e07f	460506e7-d720-6153-9533-438dfbcd86ab	e1e7c4e5-7e25-6799-eb9a-438dfba51d7f	2005-11-30 19:24:59	0
1ef119f5-1998-c802-bed0-438dfb36ac70	1c0f05b2-89b7-18e2-891a-438dfbc01ee0	19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:25:00	0
232c6579-97cf-57b0-1078-438dfb9b2570	205b2bf4-43dd-a21c-76fc-438dfba0e9a6	19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:25:00	0
27632741-d91c-0fd6-6868-438dfb0400ac	24842fa2-f1d0-fcd7-400f-438dfb4ea646	19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:25:00	0
2bb0caa4-2e89-9ad4-a8fc-438dfba51e73	28cc81f8-ea49-abeb-5ac0-438dfb987703	19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:25:00	0
32ee61a8-92ed-f1d1-1170-438dfb530dab	3016ac3f-2c2c-fff0-8cdd-438dfb22aee2	19c8dab9-5903-3485-5d78-438dfb4125b3	2005-11-30 19:25:01	0
4962d33b-e9a7-0f62-3138-438dfbc915e4	4695456f-d7cd-44c9-9432-438dfb4908a4	44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:25:01	0
4db7a674-135c-9cb1-65b2-438dfb3f59aa	4ad7d4ca-6946-8924-7f8d-438dfbe2ae9d	44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:25:01	0
51e59fc3-ff30-6a78-f512-438dfb826663	4f1a133e-69a8-8870-80ff-438dfb9482ad	44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:25:01	0
564bb0be-bddb-c3f9-69ea-438dfb7c5ca2	5346c858-7a27-e1bd-200c-438dfb83b6c5	44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:25:01	0
5a77108a-2eae-2b1f-adeb-438dfb89498d	57ac3090-3093-c852-ee7e-438dfb446e3c	44496c8b-c971-3912-ef47-438dfb05614b	2005-11-30 19:25:02	0
6efe815b-2313-dea2-458a-438dfbfe1f08	6c21cecc-c7ea-a8ad-c453-438dfbbe0d88	69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:25:02	0
7961483c-4e69-77b0-f0a3-438dfbe20d55	768c10fd-dfe5-d48a-bd05-438dfbe2f963	69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:25:02	0
7da10b74-ef78-840d-d3c1-438dfb4874d1	7ac658d9-f721-df1a-b286-438dfb5cf45a	69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:25:02	0
81d2d089-8f71-2073-516b-438dfb502a4f	7f027dd8-9057-42e1-07f5-438dfbafaeb6	69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:25:03	0
85ffb0a9-ea61-3459-603f-438dfbf9c153	832e6608-f1d6-77b0-177f-438dfb0b9d14	69df481f-8899-8333-3d9c-438dfbae3e94	2005-11-30 19:25:03	0
a17a1332-2839-648a-411a-438dfbd19311	9e802058-7610-9c18-f36d-438dfbde8cc9	9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:25:03	0
a5e31196-3bcb-33a0-0c64-438dfb14ffbd	a2f02b4c-f25f-21d1-1850-438dfba84ba8	9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:25:03	0
ad7edace-c124-cf1d-6b30-438dfb630ca4	aa7b73ec-9391-753b-56ba-438dfba9e5a2	9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:25:04	0
b1e8c601-6da8-a212-5c07-438dfbfef646	aeefd0cf-f728-8378-d872-438dfb02d851	9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:25:04	0
b6443b43-e7ba-eea1-b515-438dfb319359	b350b12d-0725-3f76-d10c-438dfb00ff78	9bf12bea-3d89-2b67-a279-438dfb7f1aa9	2005-11-30 19:25:04	0
cb3b9762-33c7-2809-0b10-438dfb0bbe36	c84815e0-53af-a5cf-0711-438dfba1ef7c	c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:25:04	0
cf94a4b1-6f30-42a2-f037-438dfb17362b	cca48775-d385-0c83-453b-438dfbcb5fe5	c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:25:05	0
d4297f0a-2b77-597f-5f97-438dfb308493	d10a10ae-43ca-10a3-1fb1-438dfb8469cd	c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:25:05	0
d8834e91-b186-b347-65b0-438dfb1500d3	d596fdf4-8370-e6d2-f673-438dfb4330cd	c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:25:05	0
e0292f6f-c03e-a568-11a6-438dfbc0098a	dd34fc8c-b2a9-b42e-d359-438dfb743d70	c5fb833d-150f-99a6-9946-438dfb94f2c5	2005-11-30 19:25:05	0
78120de0-10c4-3cec-855f-438dfbffff85	48cd06cd-67af-f712-26c3-438dfbdcdf28	24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:25:05	0
be590e98-c571-b3c3-d49f-438dfb79b5ee	8ee90950-1f91-1b6f-ed91-438dfbc0481e	24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:25:06	0
10516c05-0e21-bc11-31a3-438dfb496961	d54700b1-0778-7657-3d25-438dfbbc19da	24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:25:06	0
149fb560-bbe0-7f82-77da-438dfb440877	11b6a296-180f-8177-925b-438dfbca6232	24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:25:06	0
1900a188-6212-c62f-da15-438dfbccb4d9	16040bf2-478d-1a6a-a003-438dfb6e9791	24360cfc-2889-5353-2998-438dfbffd419	2005-11-30 19:25:06	0
2ddc46e9-2a9e-dcab-e879-438dfb0eee0a	2afe9670-9d44-d951-77ef-438dfb25056c	28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:25:07	0
357f9da2-5753-dade-3d25-438dfb347568	32a8b9ed-d818-8d35-738c-438dfbb31057	28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:25:07	0
39b44765-605b-fe00-183c-438dfb87d4f0	36df46b8-53b1-f5ce-c029-438dfbd4485d	28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:25:07	0
46ac6e9b-cb6d-e570-b77b-438dfb59db62	43d23e75-16a7-d388-aa6b-438dfb65b16a	28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:25:07	0
4af7b896-c012-5eff-58ab-438dfbea2374	4809b1ab-0fef-57a0-9b8e-438dfbecaf87	28a3374d-7edd-e1ae-8b82-438dfbb1ba4b	2005-11-30 19:25:07	0
5f95f18b-3ed4-f6ca-b107-438dfb0e4f8c	5cbe08c0-cc64-7c47-de07-438dfb2098a1	5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:25:08	0
63cd7c4a-e296-c180-a026-438dfb7b4ca7	60f5f1b0-556b-759a-e107-438dfb8a43b5	5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:25:08	0
680bc41f-1ac9-68a1-3ff2-438dfbe9506d	652c68c0-a5e1-e95e-8369-438dfb04c88e	5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:25:08	0
6c38e7ed-e918-6e9f-61df-438dfb2bd2a9	6967e23e-5fdc-1a44-302a-438dfb156e1c	5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:25:08	0
70692f7f-fb7c-95c7-6351-438dfb06698f	6d93a572-12bd-6732-0350-438dfbbbdbb6	5a6c2cce-c982-432d-802f-438dfbaa1b2d	2005-11-30 19:25:08	0
84cc820a-08e9-8468-b297-438dfbe0b7a1	81fd942a-0587-a0bd-1b49-438dfb8419a8	7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:25:09	0
8918b76a-9d62-b17a-df71-438dfb1bee12	863135ae-777f-6cf2-41c4-438dfbdae2b3	7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:25:09	0
8d4f681d-a787-07f8-e8ce-438dfb2b1e0e	8a7cc37d-e797-253e-77b7-438dfb5c74b7	7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:25:09	0
917a6682-3b8e-1633-70dc-438dfb3ae6ec	8eaed9e4-aab7-d228-e161-438dfb59c42e	7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:25:09	0
95c335f5-30c4-7407-a3a3-438dfbb22371	92d556da-7d2e-07d8-c3c0-438dfb417180	7fb9aa29-6e36-4329-96a0-438dfbe17998	2005-11-30 19:25:10	0
aa317a99-f33a-07cb-d5a6-438dfbc9b91b	a75b3567-6133-ee10-33a3-438dfb94cf35	a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:25:10	0
ae79e1f2-b1d0-6491-f609-438dfb5e93bb	ab9f9824-b007-b4bc-ed87-438dfb168d0c	a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:25:10	0
b2a788a8-a775-01e2-3622-438dfbb03188	afd38d5f-90f2-41d2-a703-438dfbd5c40c	a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:25:10	0
b6d75638-bde6-35dd-68c1-438dfbae0f21	b4047471-9c36-6b26-5eff-438dfbb1b690	a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:25:10	0
bb10381e-231b-caa9-64d4-438dfb5a2d71	b83700dd-c19d-b9f9-95c1-438dfbe35fd8	a5207af5-eba0-4a11-4fec-438dfb66e63f	2005-11-30 19:25:11	0
cf8f4540-4c9a-8574-40ea-438dfb953822	ccbb3507-f6e7-22d7-a4a8-438dfb9ce1b9	ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:25:11	0
d3d4f14a-8726-05e6-3d31-438dfb5ee800	d0f4f687-9ae1-7406-552f-438dfb3f0866	ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:25:11	0
d8083062-3535-185d-bd47-438dfbd8bf70	d5327c0b-b590-b9d1-dc7b-438dfb37afe8	ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:25:11	0
dc38f367-687b-4d00-d98d-438dfbcae950	d96e5648-c22f-51d1-3e35-438dfb886bb7	ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:25:12	0
e7cce2a3-4922-772b-a079-438dfbe8dda3	e4fafdf4-90bb-ac13-2d2e-438dfbf6150a	ca77a3a6-1980-87ca-3936-438dfbc5ed9a	2005-11-30 19:25:12	0
81490b71-e8e0-8ecd-e973-438dfba87293	540109ea-5aa2-aa68-5492-438dfb11f7ca	301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:25:12	0
13c19db5-fe8c-1e48-8aad-438dfb57c4aa	10ea6cd2-8dbf-5b30-7b5c-438dfb6f7525	301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:25:12	0
17f7c883-77aa-afbb-c25e-438dfb63f2f8	152505bc-1ca1-621e-17cb-438dfb462f96	301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:25:13	0
1c343815-6c14-9dfb-df05-438dfbb2af9f	1955d121-ca89-6420-09b9-438dfb0f392c	301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:25:13	0
206d9dda-da10-f3c5-9578-438dfb1219c9	1d90efad-17df-67c0-71e3-438dfbbcb3da	301d0472-13ab-06ea-b8ea-438dfbbf5d2b	2005-11-30 19:25:13	0
351c84fe-72bd-6459-004b-438dfb290ce7	3230625a-2263-5c98-cdf5-438dfb631e2a	2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:25:13	0
395b6e99-7820-7562-aa38-438dfbedb994	368a92fd-5fa6-c590-bcf2-438dfba9100f	2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:25:14	0
3d87daea-839e-e29e-32e1-438dfb663f26	3ab5fe0b-a560-571a-ba49-438dfbd4c3aa	2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:25:14	0
479fd4bd-5797-a6ab-4cb0-438dfbd7f154	44bfeef2-e75e-d0f3-5710-438dfbd1d93f	2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:25:14	0
4bf86e41-62a4-491b-da93-438dfb2eaa53	4909296f-8086-c934-c01b-438dfb554457	2fe59fe0-21e0-b9aa-f06e-438dfbf94248	2005-11-30 19:25:14	0
60e6bed0-6858-aa7c-858c-438dfb5c7005	5e0c699a-bafb-5226-6f8e-438dfb59d973	5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:25:14	0
65241fa2-6382-e4a1-979b-438dfb38c314	62470b3b-9919-b5a7-a28a-438dfbb6c77a	5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:25:14	0
69664889-b89e-ce83-7f2c-438dfbdf5c2c	668e33b0-8ac7-f81a-dce1-438dfb7a2284	5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:25:15	0
6d9a3310-e205-3fff-90c8-438dfbf1d9cb	6acd46b3-e02c-ce50-ddc9-438dfb2eb5d5	5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:25:15	0
71cb9461-e6f3-15b0-e191-438dfb818f5a	6ef1fc8f-ebf4-879b-0677-438dfb58fac6	5bcee21d-2f47-8266-e876-438dfb7e8edd	2005-11-30 19:25:15	0
9ec1ed33-3d26-442f-2033-438dfb30386a	836cd18e-1bdf-596a-0bc7-438dfbd15ae9	812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:25:15	0
a31126d6-5c19-e0f3-7e06-438dfb65e7f1	a02d903b-b8ef-afdc-ec75-438dfb486076	812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:25:16	0
ab35fc0a-e34a-60b3-94ff-438dfbac5123	a8690d59-9766-58e8-a8d9-438dfbc8732e	812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:25:16	0
af7a94ee-7ef3-c465-a9f5-438dfb7176c1	ac9c04fb-ccb8-cf75-22cc-438dfb87532e	812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:25:16	0
b3a4fa89-7746-bb02-6960-438dfbc9ea8b	b0d3f2bb-bccf-df3e-19c2-438dfbc79119	812f72fc-ab3e-476d-9117-438dfb874384	2005-11-30 19:25:16	0
c8240a72-d6a6-38ba-2954-438dfb8e9975	c54b3b2c-603d-5637-0a71-438dfb54df11	c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:25:17	0
cc5b0f45-4574-1003-f3c2-438dfb61ee45	c987fbe8-3f54-bbcc-f41b-438dfb485262	c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:25:17	0
d0929221-e4dd-48f2-5d84-438dfbb88245	cdbcf9f8-1a0f-884f-f635-438dfb4743ab	c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:25:17	0
d4cd2951-4454-15e4-3f1c-438dfb2b5182	d1fc8eec-a2e1-b3d1-37c6-438dfb738d9b	c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:25:17	0
dd391926-8d14-556a-10af-438dfb4fdf59	da2bd072-494d-c303-58b0-438dfb3421a1	c2f7eed0-8116-30ea-954e-438dfb1eabdb	2005-11-30 19:25:17	0
f19db51a-20cc-3460-cedb-438dfb590c91	eec4ecba-2891-4b1a-20a6-438dfbfb69f3	ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:25:18	0
5dae0e81-57cb-bb9a-89dd-438dfba33a13	2ede01e6-98e4-67c9-b6b9-438dfb99735b	ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:25:18	0
d6090e44-a98c-1390-30ab-438dfb909d0d	a8ef008e-2bb6-22d2-b37f-438dfbb01a9d	ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:25:18	0
119d7bd9-1a46-d604-c921-438dfbacd5e3	ecf707cf-1b58-5aec-5b1f-438dfb47042a	ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:25:18	0
15ca5c8a-b0d4-c798-4072-438dfbebd2da	12f853df-aac4-ddc1-4b2a-438dfb9daab5	ec7d9ee2-985e-832d-246a-438dfb43d183	2005-11-30 19:25:19	0
2ba4bd8a-4d60-783c-7958-438dfbafc1e1	286ceec6-7be4-491d-141b-438dfba8a41a	25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:25:19	0
2fe06115-a3cd-8c6f-a1e7-438dfb8ab396	2d05edf0-9dcb-c279-5739-438dfb34ea0e	25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:25:19	0
384e128d-fb2f-4977-c91b-438dfbf55405	35729b8f-4767-5c11-c8b0-438dfb7dcb3a	25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:25:19	0
3c776843-56ba-5985-1037-438dfb744e65	39acdb89-4b96-c8f2-ad99-438dfbd6394c	25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:25:20	0
42ac9586-fd41-5b29-36ae-438dfb24e32d	3dd5e9d7-e2db-1fb2-0b01-438dfb2bdc76	25d33195-1843-27b2-f5df-438dfbbd4332	2005-11-30 19:25:20	0
5fb92b4e-30af-70c6-9106-438dfb0d8d01	5ce2fd89-0a70-28b3-8737-438dfb328466	5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:25:20	0
63ffa09e-42b2-4ab1-404f-438dfb94b91e	611fab71-eddb-732c-6ff4-438dfb588f36	5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:25:20	0
68335e14-cfd5-1e53-9ad0-438dfb910a8a	655d56c6-af3d-f369-916f-438dfbc5dcfc	5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:25:20	0
6c6ba9a5-00c3-833b-a243-438dfb123d46	699b9f13-60c9-0cca-11dc-438dfb4fa505	5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:25:21	0
70a9e694-4d9d-f850-e0c5-438dfb23b9cb	6dd17c14-d02a-6cf0-f931-438dfb14aa50	5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6	2005-11-30 19:25:21	0
8522215e-958b-63f9-7a84-438dfb67114d	823d9076-38d2-f7d1-1724-438dfb1e1ad2	7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:25:21	0
8962f24e-2a74-22b9-ff57-438dfbad8e8d	8689497e-cfb4-70c3-0563-438dfb3fd803	7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:25:21	0
8d952bf7-8b85-4ae2-f86d-438dfb58fcfb	8ac5206f-40e2-d000-8e58-438dfbcd1063	7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:25:22	0
91ca4641-76a6-e55e-f6a7-438dfb9cd808	8ef84370-518c-ff60-7f26-438dfb2c74da	7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:25:22	0
9605efdc-da79-a97e-241b-438dfb8d50ff	932c74ef-56b5-f7ac-3a3f-438dfba9deb4	7ff64e0f-4980-e147-e646-438dfb3c2560	2005-11-30 19:25:22	0
aa8d61d1-06e4-d322-dc84-438dfbc9202f	a7b830fb-d98e-df89-effd-438dfb27c797	a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:25:22	0
aec0edd9-bc2e-f48f-1bea-438dfbee0035	abef6e7e-5c4c-50f6-dba4-438dfb8ae91e	a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:25:23	0
b3028ed4-cf3e-ae00-4796-438dfb674103	b02884a3-4b6a-17b8-3410-438dfb12fc6c	a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:25:23	0
b73272b2-6677-0f3a-f18f-438dfb0bfa31	b4631b05-b8a5-84b8-6aef-438dfbd6f954	a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:25:23	0
bb768861-916c-d691-5e94-438dfbac7cc6	b88dba73-ee88-0b13-c3c8-438dfb69c4f7	a57a0171-598b-52c1-a44f-438dfbac3293	2005-11-30 19:25:23	0
cfe5cff5-3b99-e7c4-bb30-438dfb66a842	cd0f47a1-1706-0f64-be0a-438dfb77c092	cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:25:24	0
d4a829a5-fbc2-1f40-e99e-438dfbcdae85	d1affdd8-3bd0-1592-c9b5-438dfb6b617f	cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:25:24	0
d8da809e-7a11-6b68-fb0e-438dfb9f9bf4	d60018a8-f364-a59e-6b96-438dfbc335a6	cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:25:24	0
dd095bbf-1ecf-3e13-3060-438dfb19cbbb	da3b2fef-92e8-a1d7-652c-438dfb345bc3	cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:25:24	0
e1493961-fefa-d3b3-5651-438dfb463daa	de784407-4fda-479a-c6d5-438dfbacadcb	cad65136-9e79-c945-107b-438dfb8b41de	2005-11-30 19:25:25	0
19070228-8c64-e7d2-14e0-438dfb4fd2c8	f2d76a9c-1c91-8885-8066-438dfb64fc60	f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:25:25	0
5df20fbb-ddc8-1b5b-9832-438dfb843044	308e006e-bc0f-5dbd-506a-438dfb3be5c5	f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:25:25	0
a0b00c20-3880-c0ac-1b32-438dfb20f5f6	74040694-e95f-e762-7a98-438dfbb1b40e	f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:25:25	0
e45106b6-cf32-8bd1-000a-438dfbca41a7	b6e101b8-41b4-572a-552d-438dfbd455e5	f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:25:26	0
12b8621d-fd6f-520f-86de-438dfb3d3276	fe9004b6-26f2-e8e1-35fd-438dfba98219	f09a17fa-2820-2d97-db3c-438dfbf7e7e5	2005-11-30 19:25:26	0
273ba7bc-b4b2-d6aa-9924-438dfbc493b9	24566344-f52b-eb3d-a74f-438dfbdc4b1e	221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:25:26	0
2bc455d1-c0a1-9ae9-7099-438dfb508170	28a44172-6a6a-5b9e-3146-438dfb348bdb	221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:25:26	0
3008dae9-f404-ad0b-915e-438dfb87a78a	2d27bbbb-5037-f8e8-15bd-438dfb20595f	221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:25:27	0
344a74d1-b1e0-cd70-4442-438dfbfe5f69	3174c250-728d-baf3-d023-438dfb9dfc02	221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:25:27	0
388d0b6a-bb0d-d1e7-61a5-438dfb3ffaba	35b2e33b-2ca7-e78f-405b-438dfb8d0f2b	221acfb4-1667-5126-232f-438dfb9ae6c1	2005-11-30 19:25:27	0
4f27f60d-f029-f7ca-7614-438dfb1ef39d	4c4bfa87-21e9-8f86-b6ab-438dfba5f514	49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:25:27	0
53d2ac4f-c171-17fe-e6d1-438dfbf8c617	50fd2315-c8e2-6c94-95bf-438dfbe8bf01	49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:25:28	0
58120c81-a8e0-94f7-a6ef-438dfb78687c	55331a92-cc7d-83ed-9f68-438dfb3742f8	49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:25:28	0
5c44798e-abe5-3d0c-672d-438dfb803874	5971d75d-b9b3-0882-ca0b-438dfb5d7ff3	49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:25:28	0
60749d54-4389-63f9-750b-438dfb89a532	5da7b4cf-3c16-f872-6208-438dfb8822e2	49d9b236-ff3a-4340-f619-438dfb42fdf8	2005-11-30 19:25:28	0
74f4de82-2ce1-3e45-8bc0-438dfb083548	721baef0-63f1-9d05-8cc0-438dfb244f63	6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:25:29	0
79228a39-0a65-4f59-28ef-438dfbe81672	76542fea-a074-5072-6fe6-438dfba09c11	6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:25:29	0
7d651edd-0c54-050f-9071-438dfb672e17	7a81118b-c6b0-231f-4970-438dfbc54cdf	6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:25:29	0
8197991a-4440-3af4-df4a-438dfbc3c401	7ecd7ab9-a2c5-f1cf-a8ef-438dfbac3a71	6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:25:29	0
85bd3361-38ae-8993-bae3-438dfb04a553	82efefb0-bffa-6d45-7863-438dfb521e06	6fc8c6a5-7400-9855-fac4-438dfb37774c	2005-11-30 19:25:29	0
9a5d7f81-1f59-2ce9-854c-438dfb7ea383	978389c7-3745-fd2f-1267-438dfb4169c0	953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:25:29	0
9e90b477-3aab-6722-6ebf-438dfb331a46	9bbbbc4d-9298-9bbc-60ff-438dfbdd0264	953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:25:30	0
a2d85325-fb01-0593-af2b-438dfb787ce1	9ffc7cc0-5d1e-68cd-240c-438dfbca51b5	953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:25:30	0
a70b3559-8c4e-0dd6-5696-438dfbf67538	a43c12bf-5037-a3fb-f853-438dfbf59ca1	953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:25:30	0
ab3b2c0a-759b-a95b-c955-438dfbfe78ea	a86652ef-8911-e502-81f6-438dfb0d3ecf	953f26e5-ef03-73a5-2912-438dfbf3e02e	2005-11-30 19:25:30	0
bfc84253-3b5c-3eb6-bafe-438dfb3921a9	bce17bda-0ae3-6ba1-c12e-438dfbba303f	baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:25:31	0
c40aebf2-8331-3379-fdfd-438dfbd611d0	c132c0a8-3a8e-43ab-3db7-438dfb49d055	baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:25:31	0
c896c305-78f6-eb08-d953-438dfb2296f7	c56a320f-3d0d-0e0d-4344-438dfb969a34	baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:25:31	0
ccfaccde-8b62-ddde-a4f6-438dfb17ddca	c9fe25d0-ea89-15ab-14c2-438dfbc4a413	baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:25:31	0
d293a312-734e-db20-e2c6-438dfb622880	cfa5c5e6-c28e-969e-45a1-438dfb8dac12	baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5	2005-11-30 19:25:32	0
f3c75358-f62d-9292-13b7-438dfbe007e7	f0ef007c-c99f-5b8b-ca82-438dfbd320cc	eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:25:32	0
3e3505a0-17c4-a412-8c1f-438dfb89c76c	10b30605-2253-34d9-ee1e-438dfbe3e652	eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:25:32	0
827103ca-8706-1627-1658-438dfbc6731a	54890ae5-62e2-26e5-f53b-438dfb818ab4	eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:25:32	0
c5e00f8b-b83f-837f-829b-438dfb5bcfd5	989d0111-e980-eac5-3ebc-438dfb76f7cd	eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:25:33	0
1082267e-ab48-a62a-3ab1-438dfb5ee4a8	db7f0563-935e-f101-48bf-438dfb7a81b6	eea76ad0-2d41-1f9b-c178-438dfb4344f9	2005-11-30 19:25:33	0
24f509f5-39da-f4ae-49ee-438dfb3ca70d	221ec606-d8fd-c384-0946-438dfb3f7f35	1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:25:33	0
2a356dcf-785c-791b-af72-438dfbce04ff	2717abf4-3924-c180-ef7a-438dfba04539	1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:25:33	0
2e831d5a-fc03-93a5-342e-438dfbeb2e69	2b9b37eb-ef6a-8a91-9b3c-438dfbb088e9	1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:25:34	0
32b3b797-1f93-f0e3-84d2-438dfb51d692	2fe3808a-bbec-2526-1799-438dfba5b517	1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:25:34	0
3887fd11-67ce-d347-d6dc-438dfbc27ea3	35aceab9-10bb-4625-d3e8-438dfb50cdb3	1fe57f85-843a-c2da-ce4a-438dfbdca0ec	2005-11-30 19:25:34	0
4fe84cdb-9cf9-b537-4299-438dfb2fc430	4d0cb1a4-aa60-4393-3121-438dfb7119ee	4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:25:34	0
542940ad-b2f4-4af7-5cdd-438dfb6a28a8	5158f891-2bc7-6e5f-ad7b-438dfbd7fec1	4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:25:35	0
587190b7-4691-3d27-6584-438dfbe0f9ae	558852db-80d6-0fbf-397e-438dfbd84acb	4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:25:35	0
5c9d543d-90aa-82be-58ce-438dfb37bebf	59cdf978-7082-ff2d-0196-438dfb2138dc	4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:25:35	0
62778b31-4556-ac2c-15c1-438dfb827a6e	5fa49150-edbc-057c-9925-438dfbd60004	4ab5174a-cfe1-ac9d-33d7-438dfb1ba854	2005-11-30 19:25:35	0
76eb0509-4d4a-d89a-1ffb-438dfb7adae9	7414f9d5-20e7-95f9-5740-438dfb23ee79	71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:25:35	0
7b2c60bc-ed46-479c-eac3-438dfb0e059b	784f1c86-b8ee-85c4-3992-438dfb3240d0	71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:25:36	0
7f72c014-01ef-bf31-ad05-438dfb27c7fe	7c8a93af-a835-3443-a0df-438dfbedcb8b	71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:25:36	0
8493d390-5251-1816-60c4-438dfbd589ec	81c00099-6e60-de6b-98ee-438dfbc9c196	71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:25:36	0
88b69797-3c90-07ec-acb7-438dfb5992a8	85ed11ca-066b-f866-7152-438dfb07aa85	71d45061-e051-80ff-387f-438dfbcf7868	2005-11-30 19:25:37	0
9d51c9db-541b-f6f9-82e5-438dfbbb44d6	9a7b4b05-3f1b-b2d4-d053-438dfb209d69	9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:25:37	0
a18a4050-2a80-c81f-fee3-438dfb417ecd	9eaf6fc6-3d0f-bc49-b401-438dfbc623d1	9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:25:37	0
a5c3d57d-d7be-1a62-d794-438dfb92e2b9	a2e9d93c-6439-3c42-ae55-438dfbf3ebb7	9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:25:37	0
a9ea2783-0f43-dce0-0acc-438dfbeb601d	a724f472-da75-4573-edd8-438dfb435191	9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:25:37	0
ae177dce-b2e8-7846-df61-438dfb4729e4	ab4263e9-3db1-55e3-6a1e-438dfb86b1f9	9831fcba-daad-6531-f7d9-438dfb452a61	2005-11-30 19:25:38	0
c287591e-d2a0-aa40-6c55-438dfba143c6	bfb4d7fd-8c3f-d3b9-5320-438dfb52c870	bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:25:38	0
c6d7fa60-84b2-6cd8-7bca-438dfb76d912	c3ee5580-a836-eae5-3b21-438dfb609994	bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:25:38	0
cb0e6bc8-8bf8-9c41-bf86-438dfb053295	c832ffc3-a6a3-ee32-5f28-438dfb50ed65	bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:25:38	0
d03b9d3b-69ea-782e-f869-438dfba79347	cd6aefc7-050a-8b54-b1e8-438dfb8f99f1	bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:25:39	0
d480cdf1-ac76-bf49-b06d-438dfb4815ac	d1a37611-1fe2-986d-de75-438dfb10e559	bd7a6aa6-59fa-3349-782d-438dfb6a361a	2005-11-30 19:25:39	0
e8ee3dd4-1841-5756-9c1d-438dfba23971	e618a84c-2d47-ec23-4f6e-438dfb90dd02	e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:25:39	0
ed2cf4d1-7d70-db62-4a13-438dfbd13d35	ea4d7467-6865-29a5-085a-438dfb38ce8e	e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:25:40	0
f1568f74-bd96-0bd0-9f8f-438dfb81b881	ee866be6-f4f6-bdc0-4d86-438dfbbd5485	e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:25:40	0
28550431-9810-51ed-1eb4-438dfb8b873b	f3d91491-1ce6-240b-a8d2-438dfbb2e1cf	e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:25:40	0
6c050678-7c84-0ada-73f1-438dfbdb811f	3ec301e9-6ab9-ed9e-f50f-438dfbc6c434	e3d36dd6-a3ec-ca32-8f00-438dfbf01d62	2005-11-30 19:25:40	0
1b50fc3c-0318-895a-2f1c-438dfb04047d	1865d1ef-d29c-18b0-0764-438dfb423c56	16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:25:41	0
1f9bdeaf-ee9d-4702-f0a5-438dfb9fdfb1	1cb35cc2-3ac7-b8ca-b12f-438dfb6518dc	16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:25:41	0
250980da-47cb-dc0a-8967-438dfbaa8ad7	222bcfcd-6b48-ed6a-74b0-438dfb19eac7	16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:25:41	0
293fb1d7-5cbb-f5b2-b4d0-438dfb1a444f	26661c15-859c-80ab-df4d-438dfb06044a	16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:25:41	0
2db2e58b-dea6-97e1-9b5f-438dfb131279	2ac4fe6b-b06c-c024-3c0c-438dfb30385e	16270908-902d-5444-bdd2-438dfb677e78	2005-11-30 19:25:42	0
4683493e-be89-efa7-c35b-438dfb251b03	43ac0f8d-c18f-0df1-583e-438dfb295cf8	3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:25:42	0
4ab7e247-a400-fd19-c67f-438dfb3c58f0	47e9ed5b-20dd-6b12-e3ac-438dfbc0d748	3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:25:42	0
4f2461fa-6161-3857-6df3-438dfb88749d	4c1d0a24-e70c-328d-dea1-438dfb5ae983	3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:25:42	0
535a3c04-23be-be1a-1379-438dfbf3055f	50863b92-3cd7-18f7-704a-438dfb278fc5	3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:25:43	0
57842c59-ec18-3049-090e-438dfb359216	54b9324b-5d23-0aed-e591-438dfb300f0c	3f6d17ff-3b92-d8ce-b733-438dfb08d42a	2005-11-30 19:25:43	0
6c4731c3-7c5c-b200-f0e5-438dfb265a4f	69765854-582c-9e9c-c43a-438dfb1876d9	672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:25:43	0
707de05b-6c78-936b-0af5-438dfb1969a0	6da7b907-a37f-5cbb-2983-438dfb1d3b97	672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:25:43	0
74b1a9b9-44f4-050f-42ac-438dfbbce600	71deba86-5644-cd4a-5df8-438dfb22ecf9	672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:25:43	0
7a2e3eec-e094-3b71-fd36-438dfb1b8853	775d2d24-f781-383d-f0be-438dfb393ce7	672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:25:44	0
7e65d032-9724-c4e3-d96a-438dfb50cd12	7b8b7c21-666c-0fb9-39cb-438dfbde18ca	672ce9a6-eabc-8209-5417-438dfbe5cda1	2005-11-30 19:25:44	0
92da1981-d46a-e6c7-d5ba-438dfb25cf08	8ff9eacd-71cb-ef8d-b3ee-438dfb3e5b83	8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:25:44	0
97178dde-2ecc-d11f-e5a6-438dfb37ec87	943c7b9d-b080-5f78-1b23-438dfba9b72b	8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:25:44	0
9b5939cd-9612-4d60-ae72-438dfb2d4175	9887467f-8b7f-10cc-9cca-438dfb5fc025	8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:25:45	0
a0f16321-5b13-6b30-d378-438dfb128f84	9e1ddab2-6f38-4bf4-cd64-438dfbb4432b	8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:25:45	0
a535b10d-2634-788b-6106-438dfb112bf5	a259e295-f213-4dff-af80-438dfb36c76a	8dbf7451-dc4a-3634-8099-438dfb762ae2	2005-11-30 19:25:45	0
b9a5d033-afd2-8c0f-1e10-438dfba4646e	b6d43f88-065a-c224-9ca6-438dfbdfae49	b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:25:45	0
bdee1988-ced1-c2b9-d397-438dfbe77a6d	bb10cd6c-07d4-62b7-627d-438dfb54e82d	b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:25:46	0
c223f2cf-8996-54f9-8123-438dfb89aeeb	bf4eab22-6f46-559c-a8aa-438dfb4963e2	b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:25:46	0
c65348cf-b18b-705f-b75f-438dfb00aff7	c37fc846-4e4e-92db-799d-438dfb2f2bde	b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:25:46	0
ca834bd4-a486-9554-ff01-438dfb669179	c7af2a22-745d-5fd1-fc04-438dfbcc720b	b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3	2005-11-30 19:25:46	0
df255667-923b-b474-b699-438dfb0fab1b	dc428d46-65bf-877a-1f1f-438dfba069dc	da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:25:47	0
e945cffe-88b7-9b90-6e75-438dfb82422b	e6721e98-7299-2ffb-7a12-438dfb76680c	da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:25:47	0
ed8bc5d2-ac94-071f-247e-438dfb0df4ef	eaa528d7-b6ea-11fa-ee8e-438dfb669591	da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:25:47	0
f1c304bb-6307-1a51-93bf-438dfbf1b418	eef32aa2-6357-5b53-7680-438dfb49d618	da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:25:48	0
1c750acc-6549-b286-c29b-438dfb985007	f31e70ab-7913-4c7e-8b6e-438dfb4ae881	da0b3314-1bd1-f760-47f1-438dfba1b415	2005-11-30 19:25:48	0
166b4c13-5c4d-aa3b-0940-438dfbbaa410	13963c61-e2f6-56cc-4bd8-438dfb728735	115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:25:48	0
1aa82084-2af6-928d-11fc-438dfbd6acaa	17cfda23-c31c-e341-cd31-438dfb1a315b	115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:25:49	0
1ef7748f-d100-c2c5-4c67-438dfb1fe925	1c1b107a-5c4f-6480-53dc-438dfb868257	115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:25:49	0
24ac136e-37e1-2fc1-1feb-438dfbb832b9	21dba342-6e0e-9e1c-c7a9-438dfbd1e697	115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:25:49	0
28e9b439-cf06-ebca-9245-438dfb379253	260688cb-3e80-ba14-e4f6-438dfb32d178	115922df-1ff1-d274-144c-438dfb73dc42	2005-11-30 19:25:49	0
3db2e06a-9a3e-d989-5827-438dfbb87f7b	3ad8f646-28e9-9253-d903-438dfbbb6a75	389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:25:50	0
45840411-8920-17b8-7659-438dfb0c9f03	42a8d22b-2aa1-3bb0-8c1d-438dfb52120a	389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:25:50	0
49b3794b-2027-e572-40c2-438dfbb1ca40	46de26a3-3fae-a569-f722-438dfb78a67a	389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:25:50	0
4e0daaad-b5fc-e85f-58d6-438dfbd606c1	4b12703d-9b6c-2c98-ae90-438dfb06c3d2	389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:25:50	0
524bfbcf-5a52-6c27-cf1a-438dfbd3902b	4f7a16da-4d54-f5b8-5de5-438dfbb272bc	389b7a9d-973c-9771-632a-438dfb1fddfc	2005-11-30 19:25:51	0
690cdd70-9f46-1be1-649f-438dfb94bc93	6633afb9-5eb1-ca31-cf1d-438dfbdae578	63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:25:51	0
6d4c1377-b8ca-a7a7-971d-438dfb069728	6a7319c7-5fb8-70e9-27dd-438dfbe09371	63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:25:51	0
7183cc3f-4c74-2036-1c60-438dfbd97510	6ea99a81-d47b-853e-696d-438dfbb40f6d	63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:25:51	0
75b7555d-4fd4-7cea-e523-438dfb2d96b1	72df06a1-b581-ed50-567e-438dfb22078a	63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:25:52	0
79e79145-838e-cc05-5918-438dfb9ec9d3	7716d77f-040e-4169-4ab7-438dfb514331	63f1f0f0-6489-f61f-9a36-438dfb750c25	2005-11-30 19:25:52	0
8e758be6-f41f-dc42-e071-438dfbd85b0e	8b91706f-8a4c-bd2a-0cb1-438dfbd2936d	8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:25:52	0
9625c816-cd61-bc44-42e1-438dfb295f8e	93439b48-5595-0fa0-c522-438dfb89df5b	8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:25:52	0
9a6c7559-4ace-a05c-efcb-438dfbd24830	9784d86c-cde1-827f-433f-438dfb09b4b9	8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:25:53	0
9e9dd67f-69b2-b380-e8d1-438dfb63a2e0	9bcda3fc-1320-38fc-12d1-438dfb63cee7	8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:25:53	0
a2cef876-ae43-c809-6028-438dfb57d931	9ff98603-a842-30a4-67ea-438dfb1dc697	8945a4f8-4927-b6da-7fbc-438dfb9c24e5	2005-11-30 19:25:53	0
b747db78-56bb-f275-e3d5-438dfb1c7de8	b4709fe1-3619-aadb-8ce4-438dfb58417e	b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:25:54	0
bd5a83c1-37d1-d35a-7b34-438dfbe3a417	ba7eb0fc-2b3e-a4ac-63c3-438dfb13d560	b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:25:54	0
c1902a1f-db8d-d8c3-b1d8-438dfb05aaac	bebd9998-c955-4f5a-b8bf-438dfb8c6537	b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:25:54	0
c5c8dfca-4612-18ec-e86d-438dfb9226d0	c2f80553-9c60-0334-5056-438dfb135676	b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:25:54	0
ca00a643-88ff-d68b-2e26-438dfb2df1f7	c72db0c4-c5df-17a2-7f3e-438dfbbfd930	b23360b3-d90f-0bf2-6864-438dfba63bde	2005-11-30 19:25:55	0
dec00c3f-367f-abdc-76e9-438dfb5653ed	dbafda06-f527-9955-9969-438dfb221485	d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:25:55	0
e305a2e0-5643-2da0-3ffc-438dfb680397	e0380df8-8fcb-d745-c22e-438dfba1bfac	d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:25:55	0
e7349e1f-6b0c-4619-5480-438dfba0ee33	e465492a-3cd8-0876-6dbd-438dfbfdb3a7	d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:25:55	0
ed4f63e1-bc77-fa07-02c7-438dfbf4c1ba	ea7762b3-9ff2-b92a-f893-438dfbdb59b1	d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:25:56	0
f18127fa-dbf4-88f4-aed6-438dfb9675b3	eeb0c6bd-6a41-db5a-4bcc-438dfbaded44	d97458bd-138c-6ccd-14c1-438dfb875b17	2005-11-30 19:25:56	0
11f86eb2-3bbf-2dd6-d017-438dfb94cedc	f1980f58-2e7b-adf5-3d7c-438dfbbd3ab5	cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:25:56	0
182713bf-36ac-7175-a5f8-438dfb8727e6	1549a691-552a-cdea-f303-438dfbabdbab	cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:25:56	0
1c71c973-9a83-24b8-2d7d-438dfbb969c0	198763e2-7cdb-79a7-4a65-438dfb0e0e86	cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:25:57	0
20a5e636-97af-59d4-f119-438dfbc05acb	1dcd3d3e-b194-2799-ca85-438dfbd88573	cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:25:57	0
24d9bad4-7ba3-1bfe-24e6-438dfbc02e07	220c1338-b2ce-d6ed-b9e5-438dfbde21d0	cdb7018f-2af9-c5c5-bc5a-438dfbeabc25	2005-11-30 19:25:57	0
39d84beb-7d16-ddd6-31e5-438dfb1473ef	36f65839-26cd-6c11-5d87-438dfb3f16f1	34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:25:58	0
3e112c96-812e-6e5b-d3c9-438dfb3af9e2	3b3824e4-b0bc-fb7b-5111-438dfb14352d	34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:25:58	0
463c8c61-af60-de6f-6391-438dfb9be5c7	43624796-556a-8341-5905-438dfb0d2057	34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:25:58	0
4a75c041-55e0-cbc2-6ff5-438dfb687185	479aefe0-35b1-bb42-40b9-438dfb5de14b	34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:25:58	0
4ec1674b-6b8b-cd34-d3c1-438dfb199765	4bcc2ee0-b174-4bfe-9c40-438dfbfdb84b	34b7fcff-4ff6-4547-cc7f-438dfb271457	2005-11-30 19:25:58	0
6771bb3e-9350-7cd5-0c3a-438dfb687584	648a5b9a-500d-d0f1-a05d-438dfbfe1902	6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:25:59	0
6bb28f31-1ce5-ed57-8673-438dfb80e74f	68d7f029-9899-df09-8671-438dfbe04ab9	6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:25:59	0
6feaf249-9d31-9e30-0e20-438dfbe893ff	6d12fa33-68c1-b707-7d7c-438dfbbaef62	6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:25:59	0
742a47b4-4a7c-384e-cf03-438dfb2f5785	7148a36a-1f0f-3c93-4a7f-438dfb375092	6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:26:00	0
78511437-9982-eaac-6652-438dfb1675c1	75849dbf-60e1-d76e-b467-438dfb1fb08a	6243d450-6220-61bb-adf6-438dfb62abb7	2005-11-30 19:26:00	0
91181b6f-8c03-49a6-8f6c-438dfb8c0ac2	8e44ded2-6b64-dc96-9624-438dfba492df	8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:26:00	0
955f2413-7fd7-8da6-1cbf-438dfb1140ea	927f7011-d601-aeb2-7956-438dfb216ef0	8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:26:00	0
99ab262f-b19f-546c-d1ea-438dfbcbc70c	96c9a3eb-8eeb-168a-b28a-438dfbfb4fdb	8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:26:00	0
a015f352-bf89-7997-c7ad-438dfb1eda4c	9d3804ce-a135-8eab-7a00-438dfb6dc654	8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:26:01	0
a44b65c7-17f3-5ba9-616c-438dfb430400	a1764531-eff9-9d07-5c06-438dfb7d59a6	8bfc78c0-4447-55f8-cdcf-438dfb161815	2005-11-30 19:26:01	0
b8c249df-c120-0bf7-6c28-438dfb1802e9	b5e9149e-ba55-ca06-0264-438dfbceef3d	b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:26:01	0
bf40b5d9-3080-1b3a-87c1-438dfba0ef63	bc632025-35b3-e07d-0ec9-438dfb32792d	b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:26:01	0
c373984f-512a-e049-6ec9-438dfb43c8bd	c0a3af25-ddc5-6a37-1325-438dfb3f6cd4	b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:26:02	0
c9eb6e0c-1227-b571-f22c-438dfbebd1e4	c70ca6a6-9f43-3095-28c4-438dfb08766c	b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:26:02	0
ce1f407a-ef9f-c279-911f-438dfb8ac270	cb48d701-a3f4-e14d-d2eb-438dfb29e6d8	b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87	2005-11-30 19:26:02	0
e2b3a076-fc15-12f8-ed47-438dfbe56934	dfd0e02d-d1bb-0692-16c8-438dfb1ac895	dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:26:02	0
e6ed0028-2bed-0a92-2141-438dfba0825a	e41346f9-accd-9142-b5c7-438dfbdc3c4d	dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:26:03	0
ed7b3510-2a83-54af-2755-438dfbb0ac6d	ea9513bd-12d2-0ecb-7509-438dfb02acdf	dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:26:03	0
f1c335ae-a3aa-95c0-e2db-438dfb8ca16b	eedd8777-5919-1dc9-5023-438dfb40fd56	dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:26:03	0
1cf1020f-1000-e598-f024-438dfb74c97d	f31d9a70-20c2-ec69-9289-438dfbbaec22	dd8ee07f-61bd-30be-d935-438dfb426550	2005-11-30 19:26:04	0
166220a6-38cd-e328-657d-438dfb40ba46	138b67c6-2fcf-6902-c9be-438dfb1557cb	114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:26:04	0
1aa3a9db-328e-ab94-43cb-438dfb30efac	17c6873b-172f-dd2e-7419-438dfb148870	114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:26:04	0
1efd2b20-3914-78cd-4f0b-438dfb760ce4	1c058d66-041f-190e-7ff7-438dfb2e459a	114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:26:04	0
25877ac2-29fa-455f-4ab0-438dfbc1d4a6	22b806a6-826d-a16b-a9db-438dfbe314d4	114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:26:05	0
29c0aa04-eca2-5b36-16e9-438dfb6fee4a	26e5325b-7150-d7b4-ecaa-438dfb8a9f18	114ec48e-57e4-c5c2-6507-438dfb9ef25b	2005-11-30 19:26:05	0
3ea04152-69f1-8140-bf03-438dfb12179c	3bc4d899-6b6c-20ce-65ba-438dfbc9123a	3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:26:06	0
44ccce57-4427-899c-f4de-438dfbeb0cb8	3fff1283-9ada-f40b-ccf4-438dfb6c00ca	3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:26:06	0
4b636d98-e6ce-5ff7-f3b0-438dfb82d287	48946fc8-bea8-4844-2e3a-438dfbcb06da	3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:26:06	0
4faebdf7-eab0-6f96-0a16-438dfb91309f	4cc270c6-b08f-0a37-f2a3-438dfb68f941	3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:26:06	0
53e746c0-81b7-5544-8854-438dfbcdc490	5108938c-a44c-0170-dcc4-438dfb18ef50	3981b1f2-08e7-abb6-7b8e-438dfb4658ac	2005-11-30 19:26:07	0
68a41d3c-0bc4-6890-b41e-438dfb12ba5a	65c59776-6f0e-0023-6526-438dfbcee8bd	63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:26:07	0
71d8007d-a0a1-44fe-d95c-438dfbacb631	6ef57273-9063-a7b1-b1a1-438dfbbdbc76	63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:26:07	0
760ffa23-dc48-e1b2-61f6-438dfb98344d	7338101b-8930-639b-e563-438dfbaf2a77	63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:26:07	0
7a482f0b-0da2-159f-5857-438dfb9e9f38	7776bf7d-ce3f-e731-6727-438dfbe979b0	63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:26:08	0
7e729eef-4374-1dbe-895d-438dfbd69b8c	7ba2e8d3-e6e6-70dd-a8bd-438dfbf2157b	63857cd3-6d3f-f409-fc9e-438dfb3001c1	2005-11-30 19:26:08	0
957b3aec-1bc4-6bd1-dfb7-438dfb84e6e7	92a414f1-6df6-fdd0-6a35-438dfb91e7ad	9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:26:08	0
9c4ee12e-9d23-1035-0164-438dfbf88469	99737554-0226-24ed-10ae-438dfb09a671	9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:26:08	0
a07dd3a0-05a4-4d80-aea3-438dfbec0ba2	9da9b5a9-d23c-8fd9-21e6-438dfb8f403c	9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:26:09	0
a4b88a00-0ce6-bce8-5494-438dfbad0a31	a1dd9efa-b631-55cb-9455-438dfb758ade	9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:26:09	0
a8e47fab-0c6f-afa2-944a-438dfbf3b7e8	a6179811-5864-a8e8-b466-438dfbbe0133	9052e8c4-579b-4c67-d96e-438dfbe34bfd	2005-11-30 19:26:09	0
bd737126-70f3-7152-2a76-438dfbf4083f	ba9269c5-1b41-71a4-42cb-438dfb105587	b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:26:09	0
c1abe493-6ede-3277-6573-438dfb4ab113	bed54272-3cbe-21b2-b8ef-438dfb12e9bf	b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:26:10	0
c5e711dc-1e66-92b4-163a-438dfb03f7f0	c30fb283-ae44-707c-94ec-438dfbe1c874	b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:26:10	0
ccccae38-5f45-3846-1b9f-438dfba026b0	c9f898b3-2c0b-1eec-5b8f-438dfb74ada1	b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:26:10	0
d10250ba-b3b0-62d1-ce4a-438dfb0dad5c	ce27327f-7727-1155-dc29-438dfb6fed15	b852c1cb-196b-7ad1-9184-438dfbc4807b	2005-11-30 19:26:10	0
e603b672-f546-0760-155b-438dfb230025	e321b55f-22b2-a16c-c76f-438dfb49bc79	e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:26:11	0
ea3bfa6b-ca64-7493-a3bd-438dfb34584d	e767f4f6-6895-f5a1-9b9a-438dfbeeb5ea	e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:26:11	0
ee777812-073c-d4b1-b138-438dfb31155d	eb97f66f-ddfe-86be-f1d0-438dfb1d6304	e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:26:11	0
f2a481d3-c68f-e629-66e6-438dfba68ebe	efd260a7-27a7-9518-23d2-438dfb19241d	e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:26:11	0
2aa001b0-b27b-ecb0-3597-438dfb0e4d17	f404c25e-9fb8-c46f-8402-438dfb62e718	e0deb83a-33bc-8a70-50a3-438dfbf1a6a6	2005-11-30 19:26:12	0
1736a9fa-b681-c3a9-c2e4-438dfb3b1637	145e56f8-194d-2e86-9d30-438dfb5e8820	12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:26:12	0
20eec280-f9d3-1be2-28e4-438dfb85b326	1e17e14d-3bf4-855b-6fa6-438dfb31f869	12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:26:12	0
252b9df5-4854-03ca-cde7-438dfbe87ea0	2259d789-eb74-fe8d-59be-438dfb63a27a	12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:26:13	0
2974401c-8cd9-b725-6f34-438dfb77c756	269aba10-cea9-739d-e09a-438dfb4804a4	12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:26:13	0
2dd2cc8c-6aef-67b3-c91d-438dfb4a409c	2acf6702-74a9-e92c-032e-438dfbb3b016	12198b06-7362-bee7-e01a-438dfbd300d2	2005-11-30 19:26:13	0
4453e419-f81c-fddc-d4ce-438dfb0255b6	3f8037fd-6014-2a4c-8d92-438dfb15a0c8	3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:26:13	0
48a24166-1c55-0546-9e9d-438dfb801ea4	45d08410-5100-013c-afd4-438dfbee1789	3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:26:14	0
4cda31b5-4355-9506-e433-438dfbbf4a41	4a02eaf3-b88f-9e86-a205-438dfb9e45df	3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:26:14	0
513e85e9-cbf9-7f44-8841-438dfbddba1f	4e75cec5-6f0b-9037-2f89-438dfbc0d11c	3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:26:14	0
5575bfc0-427f-750a-d7f2-438dfb8fe494	52a99bce-97a5-1650-e6c9-438dfb5652f8	3d3f5fec-1a99-37c2-6014-438dfbb1a5c1	2005-11-30 19:26:14	0
6a0c7391-24ba-1a9a-a641-438dfb73ff82	672ee45a-bcaa-4ae6-5318-438dfb376d8a	64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:26:15	0
6e4f53b6-1edc-622b-45c9-438dfb53db28	6b7a6917-31d9-23a6-9c68-438dfbe35ce3	64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:26:15	0
728c3c9b-e805-8c4c-032f-438dfbb1efb2	6fafb8d9-0a6c-4f4c-fb4f-438dfbbb193f	64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:26:15	0
7f6431e4-ef26-9cfd-b75b-438dfbf0691b	7c8a0229-1eec-ed8f-9d8b-438dfbab6fd6	64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:26:15	0
8394fbd0-fec4-0b4f-f04a-438dfb6f5b3a	80c4e38b-7df3-854d-177b-438dfb870a45	64ec2f2b-40b0-800b-58d6-438dfb65cc42	2005-11-30 19:26:16	0
981de170-6b87-2954-75bd-438dfb8b7917	9537ffce-aa3c-9a37-3873-438dfbfdc640	92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:26:16	0
9c5a1fe8-b439-4983-3f4a-438dfba417b9	997b8264-a127-8889-63b9-438dfba0b2ca	92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:26:16	0
a3827a5c-c23d-ae0a-b003-438dfbbbb70a	a0ab9849-4fd6-59e9-8fc1-438dfb6043e7	92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:26:17	0
a7c3c45c-efa2-5487-9a9d-438dfb2e4d60	a4eac9ea-c622-327d-1d92-438dfb422d8f	92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:26:17	0
abef9434-9f2d-03b7-c49b-438dfb152f6b	a924370d-995f-d287-8c01-438dfb5de9aa	92f1a02c-7979-d266-3394-438dfbc063ae	2005-11-30 19:26:17	0
c38a365f-1ad3-c958-5fbb-438dfb0c9e66	c0b09e04-72ed-437d-75e3-438dfbb6506f	be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:26:18	0
c7c5f934-b47c-5753-9d66-438dfb5ec058	c4e89875-31e6-c362-4822-438dfb0f8aa3	be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:26:18	0
cf09ac3f-7da4-c0d9-0d9d-438dfb74a03e	cc2f18f3-a69a-8bdf-3946-438dfb0571f5	be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:26:18	0
d32f982a-1ad5-2dbb-d6e1-438dfb6af9c1	d065ae81-0201-bf87-5826-438dfbecb4f0	be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:26:19	0
d766a286-35e4-570b-ea48-438dfb90d788	d49a88d9-7337-c06f-d731-438dfbc58749	be69c39d-736a-d99a-4197-438dfb894cfb	2005-11-30 19:26:19	0
ebdbd4d0-f630-6179-b6cf-438dfb5aaf18	e9030076-26ed-8a56-d9a4-438dfbd692ea	e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:26:19	0
f3399798-1a87-bd1f-463d-438dfb9c31ea	f067bd7b-5a1f-592f-879d-438dfb1f6c03	e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:26:19	0
35a304c8-046f-7ae0-5b14-438dfb0c2ec2	747008c1-b6b6-5854-48e5-438dfbe84dab	e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:26:20	0
abf60e10-6804-3f01-7c49-438dfbdf9b49	7e4c096e-9627-5e9b-2bfd-438dfbf3f1f1	e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:26:20	0
eeea0f84-220d-a701-fb51-438dfbe4bf90	c1f90645-bb02-bc53-d656-438dfb9dad85	e6c97f92-50da-b9e5-7b28-438dfb52a851	2005-11-30 19:26:20	0
2371f2d7-26b9-7928-201b-438dfb899c8c	2090aeff-2f15-5984-c619-438dfbe24e3d	1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:26:20	0
27a760a2-d034-fcaf-86f7-438dfbcafbd4	24d83f95-61fe-e899-5e17-438dfb6ac2ba	1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:26:21	0
2f474c31-c65d-9d7c-c4ce-438dfb60c3a8	2c55c9ff-7937-7f67-da4a-438dfbb073a2	1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:26:21	0
3382a95c-16e4-e301-6ba5-438dfba54860	30acb910-af66-5802-4e3e-438dfb7ee64f	1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:26:22	0
37b3d139-552f-991b-ba4b-438dfb0ec481	34ddd3fc-d036-5a63-4cc7-438dfb9d266a	1e493e94-354d-d36a-f996-438dfb1616f5	2005-11-30 19:26:22	0
4e438de0-5253-8cf0-4b55-438dfbda4223	4b5905c0-390a-7b1d-7c24-438dfb3c1d15	491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:26:22	0
528ac011-867b-5576-ea14-438dfbc79fa6	4fad1fa3-bc32-1f2d-b8ed-438dfb8fe483	491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:26:22	0
56cbe304-b442-434e-d6c1-438dfb425458	53fe5561-9501-6f33-e689-438dfb6d680e	491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:26:23	0
5b00fa26-5347-2b5f-ae22-438dfba0b410	58287758-19b5-9329-2af3-438dfb843f8f	491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:26:23	0
65c564ab-cc94-1db2-e2b3-438dfbc3075c	62e9291f-23e4-617f-b651-438dfbe6c867	491c4d19-fbdd-d1dd-89a2-438dfb782d21	2005-11-30 19:26:23	0
7b19d2f0-a004-e66c-d2d4-438dfb6a7e3d	78427c6a-2b21-ea78-6e3e-438dfbf53b9b	75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:26:23	0
7f688552-c372-c7d9-75cd-438dfb6a13d8	7c809971-e891-1a53-66f3-438dfb244d0c	75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:26:24	0
839d219e-b6fa-38e6-3926-438dfb35b30d	80c4ea7f-9484-9a04-0401-438dfb068ed3	75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:26:24	0
87ce15e6-7db9-3579-5a3b-438dfbb299f8	84fd7069-b660-3552-22dc-438dfb7b6397	75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:26:25	0
8c0f4c82-80a6-436c-79f5-438dfb35b741	89315cc5-c6db-a2c5-f193-438dfbf721b8	75f3c5be-eb04-4dcb-14ce-438dfb5a878c	2005-11-30 19:26:25	0
a09adfbf-7f3a-cac2-aef6-438dfb6ea708	9dbbaa9a-54f6-0a4a-fdcf-438dfb009d7e	9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:26:25	0
a4dfe5d7-436c-355c-2c7b-438dfb0f0d62	a2060126-e28c-61f1-cc84-438dfb008f39	9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:26:25	0
aff0c5ea-ddcc-9e59-d4ce-438dfb2af66b	aceeea8f-eb15-ce3b-9bb0-438dfbe0208f	9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:26:26	0
b450afcb-5bab-00fe-a067-438dfb52a038	b15742bf-2599-8843-c5f0-438dfb0effbb	9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:26:26	0
b8db95dc-d820-a57a-c1da-438dfbd99b19	b5bbf9a4-a512-f7da-d7a7-438dfb7b1000	9b726ecd-688f-c61a-a444-438dfb218fd1	2005-11-30 19:26:26	0
cdfe31e8-5bf4-afaf-9d8e-438dfb2ec02d	caff3ffb-d27d-a3c7-c8bd-438dfbf415f1	c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:26:26	0
d5dc7dbd-c275-ca19-76b9-438dfba1fcd3	d2da8520-053a-bd3f-7d35-438dfb9798b0	c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:26:27	0
da419d70-c7a6-342f-ea83-438dfb55d472	d74bd47c-48b9-b13e-78a9-438dfb6f28f3	c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:26:27	0
de9ae30e-4f3b-b7ad-27cd-438dfbd66f16	dbafe273-60b3-af7c-caf1-438dfb7077db	c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:26:27	0
e2f4ac4d-6a06-2998-2573-438dfbc52676	e0031819-e462-c087-0a13-438dfb5ba396	c8bc538e-0714-e8c1-94bb-438dfb137c7a	2005-11-30 19:26:27	0
ade708d4-8a8a-99e5-7116-438dfb92e4fe	7e990dfa-e363-975f-ef25-438dfbc89aac	59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:26:28	0
f3b50dbf-7eee-a893-7518-438dfb2ff259	c4bb047a-f701-d286-c01c-438dfb5d0139	59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:26:28	0
13b36aff-f90f-41e3-dca5-438dfb596e76	10b07eb7-ae4d-c5e3-eda2-438dfb20a1ea	59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:26:28	0
1f2056a2-4b4c-030a-c9e8-438dfb7559f5	1c10ab57-c4af-fe70-9f0d-438dfb3c909a	59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:26:29	0
237e5f1c-d196-c0e6-5aac-438dfb1f3e23	20902312-4c33-be73-da10-438dfb73c88f	59fb0e8f-dc34-a05a-0f81-438dfba3c7a8	2005-11-30 19:26:29	0
38e2e4c6-738f-560f-fe94-438dfbf1c3a1	35d75c87-cad9-2879-d6df-438dfbd4c06e	3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:26:29	0
3d2bb770-427d-dba9-1557-438dfb94ddb7	3a47d83e-066a-2024-17db-438dfb647d4c	3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:26:29	0
41735353-3c93-3247-d246-438dfbe15754	3e8991d6-5c5f-06f9-ad89-438dfbb539ed	3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:26:30	0
47b46dab-6fc0-24a0-9e6c-438dfb51525d	44da1ef3-6ad4-c9f3-21fe-438dfbc505b7	3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:26:30	0
4be232cc-ee81-26b9-3cf4-438dfb438bae	490ed671-1e92-2ef4-774b-438dfb6abfa5	3389b370-a721-0e58-e2b2-438dfbcbdd37	2005-11-30 19:26:30	0
60d75e86-0381-dae9-05aa-438dfbeb9317	5dc787e0-aaf6-a39a-17ce-438dfbcf5eae	5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:26:31	0
6551824e-edea-63da-13ca-438dfb79a41c	624fadd3-ac8d-622c-e5fe-438dfb2bf65f	5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:26:31	0
6d420bdb-c262-5968-7dc6-438dfbb9f1bb	6a658ebf-322b-8ce7-b93b-438dfb425893	5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:26:31	0
71726bae-8dde-d43f-6c93-438dfb9a9613	6ea2612a-16ed-4fc3-14b2-438dfbb10c02	5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:26:32	0
75ab85dd-6bf0-ba06-d106-438dfb431db2	72d12f00-c4bb-a061-b173-438dfb1c8cdd	5b65bb26-ee94-0741-e6d7-438dfb27d784	2005-11-30 19:26:32	0
917e51ec-9099-5d1b-bac1-438dfb27e990	8ea1985a-c2c9-8a1a-d31e-438dfb691d50	8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:26:32	0
95b715f7-6371-1122-a3ab-438dfb4be26f	92e4154d-2dc1-0323-dc42-438dfb8d2e00	8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:26:32	0
9a00911a-1b88-5f40-a7a0-438dfb030b97	971921ce-1dea-594f-033d-438dfbfe6e3a	8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:26:32	0
9e404901-dd67-d97f-8806-438dfbc6406c	9b64e5b2-f074-9153-2bba-438dfbb6c673	8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:26:33	0
a9e986c7-c2f1-7740-507c-438dfb8ec67c	a7093417-d8b0-f099-cbcd-438dfb014e9e	8c5d0a27-943d-83f0-15a5-438dfba33bc3	2005-11-30 19:26:33	0
be769281-98a4-bd1d-9686-438dfbb17281	bb949a9b-5a27-947d-b3cb-438dfb933ae4	b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:26:33	0
c2bc3744-7658-16b0-742b-438dfb10942b	bfdffec6-a125-da5f-37f2-438dfba632d8	b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:26:33	0
c70123ce-df36-2d8a-5411-438dfb0ffe82	c41a555b-82ca-cd1e-2641-438dfb9ccece	b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:26:34	0
cb3ad4e6-232a-7092-f30c-438dfb31623d	c869ce0c-12ce-c2f8-a303-438dfbda262a	b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:26:34	0
cf6a2a6a-57a6-4243-9bc9-438dfb4e8a25	cc96c3a8-eecd-cf4a-ada2-438dfb4108c3	b9492cd8-4a97-892c-c9c3-438dfb201fab	2005-11-30 19:26:34	0
e431dc71-fc15-4a36-76b2-438dfb645a11	e157c879-d6bd-d3a1-da04-438dfb675fb6	df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:26:35	0
e87bc4e0-54ee-e618-04bc-438dfb8edd5e	e5900282-b57d-9478-cceb-438dfb03cd05	df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:26:35	0
f08db021-bb3a-0a37-b443-438dfb72ec40	edb8d87e-ef34-3490-7bc0-438dfbbffe07	df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:26:35	0
97400d79-fcbf-5bff-535c-438dfbaab2ab	f1ec2145-de33-8642-6ad4-438dfb442b7a	df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:26:35	0
4cd50763-1965-05ec-ff9b-438dfb5f31e2	1f420c23-09b9-baa7-362d-438dfbaef3c0	df0f0986-f65e-d456-1351-438dfb44de21	2005-11-30 19:26:36	0
1978f193-8849-3b90-695e-438dfb4ad982	16983a31-f693-4ae8-1aeb-438dfb485805	145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:26:36	0
219f9a49-8f21-5977-2807-438dfb388785	1eca74ba-f424-df5f-32ef-438dfbe0230d	145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:26:36	0
25dc8b01-469d-c75b-62c8-438dfb4e59bb	230cc084-a4c8-b6b6-7da9-438dfb0340a4	145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:26:37	0
2a1aec26-19fd-e0b5-a458-438dfb5da782	27392099-c1b1-23e7-98af-438dfb71a600	145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:26:37	0
2e69d0d6-e12c-e5ac-a366-438dfb4d8ac0	2b746e10-b8ac-f115-1436-438dfbd666ea	145df113-5365-45fa-ebe7-438dfbbd5844	2005-11-30 19:26:37	0
4d036d4f-f32c-f312-1d03-438dfba1ed3d	4a30b038-3fc1-67f7-aa18-438dfb38fe3f	47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:26:37	0
555ea2a2-76bb-ac5f-0838-438dfb78f651	52886ef8-3772-2acf-d8e9-438dfbcf4f4f	47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:26:38	0
5993b31d-687d-fac7-9202-438dfb6b78e6	56c47419-e600-4016-d908-438dfba45565	47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:26:38	0
5dcfb6a6-ced4-a1d4-c8c8-438dfb2ac311	5af7e03e-5d3f-3807-457d-438dfb878813	47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:26:38	0
6609c7ef-e6d2-1a20-897d-438dfb8ec8cb	632a93de-7ff0-983c-9042-438dfb96b2f7	47f16a6f-0237-ee14-c676-438dfb83235d	2005-11-30 19:26:38	0
7a87a253-9778-7fde-cc05-438dfb30067c	77ad54b0-1401-a954-87b8-438dfbac2203	756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:26:39	0
82d2a254-ae4d-61d8-5f82-438dfb493d24	7ffb1fc1-2d41-2af9-a7ab-438dfbba3fc0	756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:26:39	0
870885ba-a468-cef7-6368-438dfb0e3120	84334a64-3b00-1cc9-5076-438dfb7bf830	756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:26:39	0
8f5a095f-9c9b-f3e3-1959-438dfbd756d8	8c808bbe-bdb9-1af2-9a20-438dfb603cb2	756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:26:39	0
938fcafc-ee04-a2be-8f59-438dfb990d69	90ba7c88-844a-8446-e0ba-438dfb8b8c6f	756fbb6a-6aa6-3de0-15da-438dfbe81403	2005-11-30 19:26:40	0
a8280c61-74dd-c8fa-4a7e-438dfbed26b2	a54c0912-64fe-61ba-ae25-438dfba930c6	a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:26:40	0
ac671f19-43f8-3cbb-e1d7-438dfb621c05	a991f6ee-e75a-6ed0-d492-438dfb8ccc14	a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:26:40	0
b0a28b45-3093-f728-9c38-438dfb0012c4	adc73e6a-792b-12aa-4987-438dfbfc2c89	a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:26:40	0
b4d45dab-19cd-4cbb-6a2c-438dfbcacb7d	b200e742-94d2-8846-6a15-438dfb819d10	a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:26:41	0
b9028ba6-ced8-6e97-5761-438dfb2fbc60	b634b6da-d50e-6992-e6fd-438dfb3eb746	a306a41f-d08d-9f88-7e78-438dfbb3dbf4	2005-11-30 19:26:41	0
d5bf8355-cf27-cfcb-1923-438dfb9ed0c1	d2e322ab-dd30-67a3-b887-438dfb4dcfad	d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:26:41	0
d9fc32fd-4b73-399e-13a2-438dfbeae8f0	d725f003-0457-199f-47b0-438dfb4161c4	d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:26:42	0
e27c7f2e-a08a-7a51-fbe0-438dfbc58c26	df8cebd3-81a5-1c35-c92d-438dfbb29e7a	d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:26:42	0
e6b4fa22-e4c8-9f4b-b9df-438dfbc09fd3	e3e2dc8b-b0f2-b477-ef41-438dfb897da3	d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:26:42	0
eadc2f0c-d652-f65d-fabe-438dfb5bf6e6	e80d0d65-993c-e9ec-0b9b-438dfb8b2665	d0aa1c58-ab79-3669-d1e3-438dfb7eb918	2005-11-30 19:26:43	0
b35a04fe-1326-b9a6-ef4b-438dfbcc926f	85b7073f-5d49-94a7-d32e-438dfb990d95	61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:26:43	0
f8b00954-536a-77af-29df-438dfbc40998	c97a03b7-b151-ffde-3d5a-438dfb1f2bc5	61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:26:43	0
13c1ad88-f652-6798-40d0-438dfb99478d	10e94720-af23-ff91-9b0c-438dfb2f9a1c	61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:26:43	0
17ecb62f-1404-51fe-e314-438dfb907759	151ff51a-4382-71ff-8d79-438dfbd3c5ae	61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:26:44	0
1c2a4f14-3657-5033-abaa-438dfb0efa4d	194acc7b-3ef9-73a3-e61d-438dfb07f363	61c904f0-7a9d-bd79-1c3c-438dfb588f82	2005-11-30 19:26:44	0
30d62eab-de21-a3be-f9e8-438dfb5be828	2ddcb1be-aba3-e88f-eb38-438dfbe213e4	2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:26:44	0
351e8c98-a41d-f0b2-2aed-438dfbe1b936	324154a0-ab21-4b3d-4cae-438dfbfdf929	2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:26:45	0
3967f066-45d6-3618-74e4-438dfb7a4340	367e2c9d-47bc-36e0-c68f-438dfb856d07	2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:26:45	0
3da1e3f0-c961-25df-c331-438dfb70334c	3ac8c155-8df1-74d7-bf9d-438dfbfa3b1c	2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:26:45	0
41cb9d61-36f4-0989-6b30-438dfbc1edb1	3efeb5c8-f930-cf6d-da20-438dfb308ced	2b9828bf-e533-2198-b512-438dfb8d5bce	2005-11-30 19:26:46	0
5872c305-77e3-e9d6-cb50-438dfbd4c303	559e49f3-0d7e-17d1-da5e-438dfbe13fe7	5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:26:46	0
658062ac-b0db-27a2-4bad-438dfb677c0a	62920fe7-b9ef-7547-ce35-438dfb26d3a5	5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:26:46	0
69c32353-63d3-97c4-8412-438dfb698c76	66dc304d-c32a-418f-af97-438dfbcf5e42	5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:26:46	0
6dfd6131-210f-5f1b-968a-438dfbc9d448	6b21cd36-548d-7ed3-dede-438dfba83131	5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:26:47	0
76a3e43b-2ec9-d401-88c5-438dfbf22e5d	73cc107d-706c-df86-8f55-438dfbe5eea6	5348b563-0622-42d3-71ba-438dfb807b3f	2005-11-30 19:26:47	0
8b196913-58ca-5aa6-7a61-438dfb1d1752	883fb7f2-6a81-bfd0-6e16-438dfb4e8ec1	860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:26:47	0
8f6cd17d-87c6-da0c-ab79-438dfba60ed1	8c8970a9-19d5-6926-0993-438dfb578e9a	860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:26:48	0
93a2171c-3b25-213e-064b-438dfb6ef3a6	90c7ad40-9a9e-a613-0d27-438dfb7be18f	860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:26:48	0
97cdc2ae-86ab-2c49-54e7-438dfb353298	95005ab9-8c6b-4bfe-5255-438dfbd0ff41	860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:26:48	0
9c04d04e-8aca-0092-122b-438dfbc2de05	9935df64-5fc4-3797-2b25-438dfbed4246	860964ee-8fd8-a620-ec96-438dfbf111c3	2005-11-30 19:26:49	0
b06350f1-aa92-2e32-132a-438dfbe550f8	ad8925b0-7ad8-ebe7-7383-438dfbe22d7b	ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:26:49	0
b4a0d331-8fc0-d633-2ca2-438dfb9bd28d	b1d194c4-9ae1-4116-fa30-438dfb84f252	ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:26:49	0
b8d7d04e-b17c-42a0-93a7-438dfbd6a82d	b603bc4c-b352-c356-933b-438dfb389341	ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:26:50	0
bd1d3cb6-88ed-5102-309f-438dfb61eaa3	ba37ce6b-fd84-60ea-4c3c-438dfb4b43cf	ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:26:50	0
c5e181c4-417e-3b56-afda-438dfbf3a54c	c3043af9-ce12-668f-249c-438dfbe5ce98	ab505e26-a5cc-8535-2e96-438dfb5e4452	2005-11-30 19:26:50	0
da605416-fd76-cce8-37bc-438dfb4af021	d78b7563-3000-a788-0d50-438dfb42241f	d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:26:50	0
de928343-50f5-01e0-e1c9-438dfb24b299	dbc1cb05-b7b1-d2e1-62ea-438dfbc46332	d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:26:51	0
e2cf2f19-9b23-cad2-14ef-438dfbd04bbe	dff4b8c4-5b60-abf3-8476-438dfb76e55f	d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:26:51	0
e706e8fd-9939-4a8a-8fb2-438dfb9c376c	e4320657-60d6-69be-3554-438dfb574e48	d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:26:51	0
eb33fe70-8001-ab64-6d45-438dfb93ed26	e8625c80-d485-0d02-b7a7-438dfb0b6c79	d53a7082-2cca-4184-26df-438dfb8a9e29	2005-11-30 19:26:51	0
b9ff0c90-d093-a5a5-183a-438dfb6cae31	8be10f15-fb8d-ee50-a48f-438dfb8c9d0d	683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:26:52	0
1004d721-4a22-5547-65fc-438dfb1aa132	d0080e19-042b-b0b4-090e-438dfb3db19e	683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:26:52	0
14541445-b064-bcaf-1c1c-438dfb765d13	116dee12-4b7f-aaaa-fc28-438dfb4090f4	683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:26:52	0
18901ea2-44e9-3a57-2016-438dfbba4d71	15b59a2c-9348-139e-64c4-438dfb15d11f	683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:26:53	0
1cd0435c-bd48-4e2d-7822-438dfb22a5e3	19ee9ca5-f922-6d35-a2db-438dfb793ca4	683501c7-529b-869a-5687-438dfb04ab8b	2005-11-30 19:26:53	0
31853c6f-6c2f-c324-8441-438dfb761eb8	2e9f1dda-6638-f005-2f3d-438dfb0337ec	2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:26:53	0
35bff2cf-a3ab-b142-0f06-438dfb1db8f1	32ebc39a-a94d-45e1-2ee3-438dfb3dc141	2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:26:53	0
39f866b9-b3da-85ab-eff5-438dfb7d34e8	3728bc6d-48fd-7a12-d603-438dfbd4c6a0	2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:26:54	0
3e2c40ba-23c7-a0ab-9fbf-438dfb9955ce	3b572c03-ee48-6796-6e83-438dfb000ea7	2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:26:54	0
4914fcb5-e0bb-3f4c-425d-438dfb584a07	463e9425-35be-14a6-6e28-438dfb058094	2c46c77e-e5a7-5cc1-6df7-438dfb2e201c	2005-11-30 19:26:54	0
5dc35291-27ff-83aa-ebb6-438dfb72f86c	5ae5b971-242b-4b4c-4fda-438dfbb7ad9d	589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:26:54	0
61fd5726-2564-5371-cd47-438dfb47d555	5f2ece0f-ad78-cac4-1dc5-438dfb9db884	589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:26:54	0
665bed3b-6587-0b44-d71a-438dfb0b5f8d	635d98c3-5709-7856-e50d-438dfbd0068f	589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:26:55	0
6abb7b2b-4584-4a1a-e6e0-438dfba2c89f	67da3973-3fab-ac76-b4ec-438dfbe8552f	589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:26:55	0
6eec0431-7718-91ad-b399-438dfb02ed63	6c147625-8adb-dc36-dda5-438dfb9681e1	589ab56c-b842-1e39-fa69-438dfb3c55d5	2005-11-30 19:26:55	0
8366859d-95fd-1bc9-6ef9-438dfbaa2199	8094559f-76bd-bdfe-9f6c-438dfb6bc8e8	7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:26:55	0
87a8f8f3-d12d-c13d-4170-438dfbe976ef	84ca7802-8c9f-fbd7-271a-438dfbff07ce	7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:26:56	0
8bd9c3fe-f629-8c78-7a9a-438dfbc54e26	890a1ede-52c0-6075-9da6-438dfb606a61	7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:26:56	0
9025be8b-37d9-39e0-99cc-438dfb873c46	8d4b592f-d576-bce1-63b8-438dfbc24e6a	7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:26:56	0
945d7bc0-09e4-6768-f1e2-438dfb8e6aaa	918a9330-9886-9598-2beb-438dfb470585	7e48a579-8198-83c2-3e93-438dfbb37fa2	2005-11-30 19:26:56	0
a8da3ceb-3376-fd78-57a6-438dfb57c543	a5fc201b-0922-cb89-b69e-438dfb874637	a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:26:57	0
ad1fef74-fc3c-cc98-7771-438dfb2563cb	aa4ef9c8-c8de-d101-a522-438dfb014bcc	a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:26:57	0
b15ed89e-63c9-085f-c23e-438dfb434923	ae8455da-78f7-f7ab-eef8-438dfbcdd836	a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:26:57	0
b5a08956-89a7-f3cd-a5ff-438dfb78a491	b2c0777c-488e-896c-8771-438dfb1f08f9	a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:26:58	0
b9d37dcc-dd90-24a7-2821-438dfbbe1f8e	b7054450-f1aa-8eea-aade-438dfb2a360a	a3ae5ce7-97f3-0767-2c32-438dfb67ba2f	2005-11-30 19:26:58	0
d86ccbf5-82ef-290d-0928-438dfb5333d7	d57d42ee-918d-8c1b-7eed-438dfbefa31a	d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:26:58	0
dc9f6705-7224-ab08-4b7f-438dfb3c33ec	d9ced5f6-4138-2674-0124-438dfbedf127	d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:26:58	0
e0d567af-c8bd-c4c5-9a55-438dfbd1b0f0	ddff3852-09c6-35a5-7d83-438dfb6960d8	d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:26:59	0
ea1b75b0-d78e-b41b-7769-438dfb2206f1	e74a4943-3618-0f9b-d817-438dfb2d033f	d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:26:59	0
ee5b796e-81ae-fbe8-0bbe-438dfb2346df	eb803792-4876-f35e-d0dd-438dfbcd83c7	d3341561-6269-a089-3222-438dfbd74426	2005-11-30 19:26:59	0
ebd40dc5-5f51-3ada-20ae-438dfb43c680	bdae0409-bb9d-e659-ecea-438dfba8e2b3	99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:27:00	0
12fa64de-0d25-fa6d-399a-438dfbe0d080	10212b17-7006-a66f-fba3-438dfbf19b63	99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:27:00	0
17477a0e-f061-6367-aded-438dfb49b7ec	146e9f0d-c2c4-dbbb-2de8-438dfb32052a	99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:27:00	0
2aa79fdd-35ae-2927-afb1-438dfb28f9e4	22c50d2a-473a-a1f4-eab5-438dfbb6cd72	99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:27:01	0
2f00bff7-34b2-d781-7ba1-438dfb4c31e3	2c08c49b-01d4-7474-900d-438dfb9e0610	99540248-a633-5eab-e014-438dfbbb6d0d	2005-11-30 19:27:01	0
45870b73-3f53-80d8-ff11-438dfb3247b5	40c7826f-9cf1-bbea-6f45-438dfb6aebe5	3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:27:01	0
4f2b9acd-35e2-128c-19e4-438dfbcefde7	4c4ac3bd-9c44-7f1f-f846-438dfb8322c9	3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:27:02	0
539d6899-343b-c2eb-3eab-438dfb7d9add	50c13ebf-f548-5b82-d637-438dfb8a313f	3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:27:02	0
57d5a397-2152-0096-d629-438dfb463527	5505f9f1-e73c-3c48-35d5-438dfb0a6443	3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:27:02	0
5c0f5ee6-61d4-2537-6dcd-438dfb5f3f09	59384075-9285-83ca-09ed-438dfbac0596	3e8c7862-6b2a-0824-ec19-438dfb18f048	2005-11-30 19:27:02	0
70947066-b7c1-5817-8cb9-438dfb1c5ef5	6db7a400-d922-ac65-77b6-438dfbbf193b	6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:27:03	0
7a07eaad-4fed-3bf5-0bf4-438dfbc3e526	7732933a-b90a-52d8-bdae-438dfb089a60	6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:27:03	0
7e36abe7-df75-cc97-aae2-438dfb7d58b6	7b650e73-9a2b-8bed-2dba-438dfb5b018c	6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:27:03	0
8273921f-d96c-2eb4-e3b0-438dfbbbbaa5	7f976157-5179-d191-6fc5-438dfbb1a129	6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:27:04	0
8bde9766-d824-c318-070c-438dfb2a4fd9	890a2153-039a-a45c-3dcd-438dfb5d2aed	6b74ee4d-f2e1-c581-dd78-438dfb730c7e	2005-11-30 19:27:04	0
a07f0b06-42a0-7e13-81ea-438dfbebe915	9d95dea6-57a3-0722-6de6-438dfbf6b976	9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:27:05	0
aa09de99-bcb7-e36e-3f6a-438dfbe5e0df	a72ad3af-06c3-e481-bdbd-438dfb4e651a	9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:27:05	0
ae41c425-64b6-3eb9-595b-438dfb644f35	ab670332-6325-3099-b236-438dfb62cdcd	9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:27:05	0
b27be49b-4d60-740d-ec01-438dfbef843a	afa8579d-2cd4-2676-d84a-438dfb3d6ef9	9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:27:06	0
b6a9e1af-1d5f-9a5e-ad2a-438dfb7ccff4	b3d8c5be-8642-2877-a658-438dfbe7b4ae	9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9	2005-11-30 19:27:06	0
d0885d58-e3d1-95bb-2e59-438dfb3a70f9	cdacae53-7c56-cb8b-79b7-438dfb2d99f4	cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:27:06	0
d4c8c6af-0273-3a7d-66ef-438dfb53a509	d1ebb0ca-2a26-8a6e-91f3-438dfb2ffd32	cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:27:07	0
e3b58d17-d7ff-6566-cdeb-438dfbc7a312	e0cf4366-77d7-dabc-2fff-438dfb7f2c7f	cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:27:07	0
e7f2f7aa-1aa0-3032-7a3f-438dfb8a48a7	e5184f86-3eef-062f-7229-438dfb2b8cbf	cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:27:08	0
ec29cbb2-64b0-f55a-b3c0-438dfb02fdf9	e95010b7-8ab1-8322-9d57-438dfbfc8c2b	cb6a9a32-58b5-580b-d07f-438dfb32eafe	2005-11-30 19:27:08	0
174c4da6-db03-d77a-a80b-438dfb5f94ed	146fc035-c3e6-c18a-e922-438dfbf3eb4c	1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:27:08	0
26568db9-6432-bedf-8691-438dfbbb56cb	236ec107-94fc-2db5-bbb1-438dfbbef1db	1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:27:09	0
2a8a958f-ec22-394d-903c-438dfb01d755	27b4f656-4874-8c4f-06f7-438dfb22eb7c	1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:27:09	0
2ef2211c-8841-c39e-494f-438dfb015412	2bfc6252-2142-d403-33df-438dfbeea20b	1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:27:09	0
33367d2c-9de7-c7c5-4487-438dfb9989ce	3064e92a-b006-b4c3-1ffb-438dfb94414e	1221a978-b701-cc79-29b4-438dfb27ec07	2005-11-30 19:27:09	0
49c2ef59-323e-5775-8696-438dfbd4d161	46eb8fb2-6073-9950-c786-438dfbdc0065	42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:27:10	0
4e10664b-f899-2986-f825-438dfb4b9812	4b295f69-6c78-3e94-4819-438dfbb430e0	42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:27:10	0
526d65e5-ce4f-c791-a61b-438dfb71d374	4f71103e-6250-03b4-20ae-438dfb874930	42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:27:10	0
56a9142c-d4ee-5487-3d97-438dfb2a6783	53cbd060-8d04-fec9-5016-438dfbe2aad4	42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:27:11	0
5adb53f5-fb59-db4a-be38-438dfb661335	580aac24-30cf-f60c-fbdf-438dfb87bdfa	42b754c8-dfad-6eaf-cbe5-438dfb050c30	2005-11-30 19:27:11	0
6fc6f4db-9958-35e9-3698-438dfb265890	6ce5a5e6-8dca-4e48-8ba3-438dfb09a754	6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:27:11	0
799546a7-5eb1-07dd-e0eb-438dfbc2681f	76b6a658-c595-b7dd-fdc8-438dfbf06a2b	6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:27:12	0
7dc5b7b8-83b4-ee98-61f4-438dfbacaa8b	7af34577-836e-ed93-1944-438dfb30ff8f	6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:27:12	0
8206baf2-ae30-b364-09f1-438dfb2a34c6	7f267a84-90ac-3941-3b14-438dfbd2b3c0	6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:27:12	0
8647f966-510a-f9fb-dafb-438dfbe11647	836a57e2-7ed8-68aa-69c5-438dfb5c9c23	6aa69a70-12fe-e914-688b-438dfb971562	2005-11-30 19:27:13	0
a61a15a2-3c28-b7df-de24-438dfbd5f945	a3296f34-1542-5e46-d742-438dfb42ba38	a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:27:13	0
aa4dad2c-5b52-f16c-bf6e-438dfb541575	a77bfcc3-e464-dfd9-a75d-438dfb83ceb7	a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:27:13	0
ae938ccc-6327-e591-a5c3-438dfb4cdde5	abb02ce3-b754-f54d-5223-438dfbdbb6be	a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:27:14	0
b2ddba48-0a14-fdc5-a0a5-438dfb39ba40	aff687a8-2189-3ae2-46c7-438dfbc7c960	a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:27:14	0
b709c0d9-9b44-7f9d-6215-438dfbeebaf2	b43ae0e9-390e-17f4-3b8d-438dfb410789	a0e7ad4b-b177-b914-da9c-438dfbda815f	2005-11-30 19:27:14	0
cb889c3e-79b1-4dca-db9b-438dfb3928df	c8a980bc-58cf-6208-cdce-438dfb6175f8	c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:27:15	0
cfc971d9-6989-a1ca-c408-438dfb6d8876	ccf268f6-a910-75bd-baa7-438dfb4ace86	c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:27:16	0
d40196df-b015-5615-6df0-438dfba8f712	d1258da7-c07d-834d-9f79-438dfb37b668	c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:27:16	0
d83c75ff-8b07-57a6-9326-438dfb5b6ec8	d560b932-0602-ec84-fe9f-438dfb4d3ef7	c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:27:16	0
e23b77bc-20ca-73e6-b285-438dfbaabf5a	df43c520-8ff4-88e6-f00c-438dfb26e93d	c6632abb-10b1-66c3-3525-438dfb4119f5	2005-11-30 19:27:17	0
2adb0b45-5f9d-f7f7-0e6f-438dfbb663c8	f3fa8e2e-2969-a6b5-9416-438dfb4eb4db	f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:27:17	0
711a0c83-09b9-5549-d831-438dfbde3e52	4113017f-002e-7070-014a-438dfbd53f12	f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:27:17	0
b4890f00-d1b2-1c4d-5843-438dfb63cf88	86ea007f-20ef-192a-2dbe-438dfbed768d	f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:27:18	0
154e1f1b-a2c2-4120-2a8c-438dfb417dd3	1273738e-ce8e-abdd-e80c-438dfba3c6d1	f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:27:18	0
198c24c1-2eb8-b8c5-14fb-438dfba8034f	16ab62bd-2640-3519-afe0-438dfb493505	f1b68c60-fd88-d531-9e4c-438dfb9d470d	2005-11-30 19:27:18	0
2e3bdd99-a334-4de5-c24d-438dfb7b9ce9	2b34545c-d8b3-fa09-f9a0-438dfbd100a6	28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:27:19	0
32aa4091-ef2e-dd1f-37f9-438dfb02e751	2fbf52e9-d2cc-69bd-dfdf-438dfb1a416b	28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:27:19	0
36da815d-c7cb-89c9-0e6c-438dfba26721	34075651-7dcb-ae6a-c0e7-438dfbafdb15	28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:27:19	0
3b367fcc-1718-c866-f233-438dfb7baf81	384f66bb-aff3-aae2-0657-438dfb56cfdd	28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:27:20	0
3f7578a7-7b8e-5f0f-3522-438dfb212d72	3c96ab27-75af-d000-3a7d-438dfbec15aa	28f75af4-5123-7550-243f-438dfb8ddf01	2005-11-30 19:27:20	0
56279b93-9293-ca83-ad13-438dfbe82d28	534388eb-8479-ab07-5d3b-438dfbd9133a	51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:27:20	0
6044eca0-2e42-8a24-e023-438dfbfc725a	5d71b9e7-ea02-312e-a6e8-438dfbaff1fa	51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:27:20	0
647ed2f6-97a5-b85d-b21e-438dfb49f980	61a8b77f-6e5f-faf9-f84d-438dfb175e1f	51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:27:21	0
68c88f9a-8fff-58fe-882b-438dfb8e91f2	65de9067-0f8b-88c7-a811-438dfbc66761	51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:27:21	0
7312cb99-6844-c428-69ea-438dfb37b711	703a8f8a-9a1c-c0f1-92cf-438dfb3207a8	51066781-1ec3-3fe8-7322-438dfbd99b65	2005-11-30 19:27:22	0
87966127-c0e3-c0b9-4bae-438dfb19b0eb	84bb8c4f-0104-54c6-13d3-438dfb8c5dbd	827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:27:22	0
8bdf6571-9d59-cd81-f984-438dfb0a30f8	89078279-fb89-af45-d613-438dfb0e2ab9	827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:27:22	0
90304e4a-abbd-4463-ef8b-438dfb8edf8e	8d480f58-da10-445e-b312-438dfbe21f66	827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:27:23	0
9a647f13-e638-ea09-0d15-438dfb895d6e	978a9565-bd89-38a1-2760-438dfbea6857	827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:27:23	0
9e982cb7-a846-8a16-fbe0-438dfb2673e5	9bc5f1b5-edf3-3dd2-9dd6-438dfba60fef	827f20ff-6ccb-df5c-4492-438dfb56d80b	2005-11-30 19:27:23	0
b32ae4b4-8e67-dc67-ca18-438dfb4cd6db	b04f32ec-23d5-8bea-e7a6-438dfbdd6bf8	ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:27:24	0
b76633cf-13b9-253c-54e2-438dfb45d4be	b48c8521-5e73-869e-70de-438dfbaa240d	ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:27:24	0
bb959a42-1783-bb83-45f7-438dfb9466dc	b8c208ba-14e8-888e-c906-438dfb711e68	ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:27:24	0
c5e0606a-f810-5421-038f-438dfb63a314	c3053415-2ae2-9a14-1cdb-438dfb97ad1a	ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:27:24	0
ca1a82b0-9e27-ce7e-ff1b-438dfbb8cd79	c74eb9f2-90c9-8e80-ed56-438dfb121375	ae0caf82-6b91-edcd-ac34-438dfbcae84b	2005-11-30 19:27:25	0
de93a136-8237-7ba6-d346-438dfb6b6f96	dbb5721b-b4c6-7135-51bb-438dfbf37156	d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:27:25	0
e8eddaeb-4848-4703-f41e-438dfbe51153	e60cf0a2-27d4-39b0-d4ef-438dfb9e583b	d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:27:25	0
ed1e7ae8-2565-e169-8219-438dfb93fa0a	ea4fd146-af02-fc25-0b02-438dfb1c4721	d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:27:26	0
f15aa629-2fe6-7a3b-e142-438dfb81facc	ee7faa51-a58c-53cf-2f03-438dfb34ab36	d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:27:26	0
15e10520-d08e-ddd9-358f-438dfba2eef4	f2b3db06-1c75-31fb-3713-438dfb062fe2	d97a4b11-78d3-b9d3-7024-438dfbf6028a	2005-11-30 19:27:27	0
1c09b328-208a-8292-e994-438dfbfb5abb	192cbc9c-4401-a10a-c70d-438dfb99f6ca	16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:27:27	0
2051d3ad-c8b3-3fdb-33ae-438dfbb5ce0a	1d6f5ee0-1c71-c665-842e-438dfbbd6e90	16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:27:27	0
247eba0d-2418-89ad-076e-438dfb1ef8d3	21ade252-80cd-12bb-cf0e-438dfb733a0c	16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:27:28	0
28bf5a8b-b4b1-c17d-cdca-438dfb1ec7fb	25e6c53f-9a68-f92a-3d62-438dfbed064e	16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:27:28	0
2cfff4ce-6a64-8acb-8109-438dfb3cde83	2a241ebf-dd71-e803-f672-438dfb9b1863	16eb4b2a-a495-ed33-7f2c-438dfb73ede3	2005-11-30 19:27:28	0
4ff06463-e852-ac95-a9db-438dfb1fb3d3	4d174fa5-28ab-d8eb-cc8a-438dfb3e89b0	4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:27:29	0
54516d15-dec3-56f3-5970-438dfbe9d73c	517ef946-9cef-4863-0f1b-438dfb2f7316	4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:27:29	0
588b6c31-c2c8-339b-1199-438dfb89240b	55b543af-7dc9-9e13-2774-438dfb5db3d3	4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:27:29	0
5cbd3c60-f360-4cc6-fd44-438dfba56757	59e936dc-ebb9-7441-b297-438dfb315ea5	4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:27:30	0
61007aa0-dfbc-4351-98d8-438dfbec671b	5e271456-3389-cfc5-d17e-438dfb8850bf	4ad0c452-7b48-f49a-70a1-438dfb731561	2005-11-30 19:27:30	0
75a65bc0-3852-950c-1e1b-438dfb0a91db	72cd591b-9d91-c8df-0240-438dfb69fe6e	709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:27:30	0
79e99e61-9869-2ee1-5d74-438dfbe327ac	770dca0a-93da-bcba-b8dc-438dfba29446	709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:27:30	0
8474c35e-bdd7-621a-164b-438dfb96ca61	8193ed88-6ab6-2b4b-c970-438dfbce940a	709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:27:31	0
88a5a97c-888b-afa4-41ed-438dfbe45644	85d51640-ee60-f4ac-e7f3-438dfba2d894	709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:27:31	0
8cd5b912-c33a-443b-c252-438dfbd07365	8a042b29-15eb-8c26-a301-438dfb48fe25	709024ac-3d9e-e75a-0885-438dfb820403	2005-11-30 19:27:31	0
a1719b92-98be-7334-070c-438dfbd090c3	9e960041-e526-8f23-d4bd-438dfb8950da	9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:27:32	0
ac0f0717-6a16-d1e0-ab0d-438dfb93a875	a931fc94-6526-7c90-cc65-438dfb82de60	9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:27:32	0
b047a434-0318-12ff-8b4d-438dfb08f759	ad6c8d0c-5628-7cbe-f255-438dfbd9f0b9	9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:27:32	0
b4760163-0386-7877-9862-438dfb1812f9	b1a260ac-782c-0c1f-2f29-438dfbe8ad96	9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:27:32	0
b8a55df2-dad5-72cb-af94-438dfb8f31b0	b5d6233a-7792-81d6-1167-438dfb47ebd7	9c5ee206-33e1-c7be-2e44-438dfbcfc3a3	2005-11-30 19:27:33	0
cd2ce22a-367e-8b48-653b-438dfbae0495	ca478b8c-144a-6a8e-793a-438dfbc12544	c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:27:33	0
de3cef92-bab0-5037-6f78-438dfb14a2c5	db5f248b-3e39-d438-b0b4-438dfb58299b	c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:27:33	0
e272d25b-d968-0493-6030-438dfbce1f6d	df9e65f1-4684-1fa8-0e1b-438dfb25fd35	c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:27:34	0
e6c37a6f-aa09-b237-6aa9-438dfbac07ae	e3e267f1-141e-3a5f-a5dd-438dfbd5d9e5	c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:27:34	0
f15a5cd8-aae4-9afb-6919-438dfb19d170	ee8f1d83-b2f0-8311-bafc-438dfb50da8a	c80dea92-93bd-414c-7d12-438dfbe287a0	2005-11-30 19:27:34	0
11c35eb8-2783-9bd8-f030-438dfbdf4275	eee803c3-2c99-df69-eb89-438dfbc499a3	cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:27:35	0
15f74541-157c-566d-e182-438dfbc5a584	13223e67-27b8-70ea-125c-438dfb02d1c0	cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:27:35	0
1a3e0803-ed21-3fcf-373f-438dfb0be38c	17617ae3-7522-5b97-b517-438dfb28c8e8	cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:27:35	0
1e74f5a7-3c3a-1a75-18dc-438dfb66f149	1b9f3718-7790-2f3a-1383-438dfb179b7b	cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:27:36	0
22abcdc2-7a37-39c6-684f-438dfb38dd96	1fcf13c5-7959-f4df-a9c1-438dfbfc98dd	cadd0934-23c0-fc21-697f-438dfbfc60c0	2005-11-30 19:27:36	0
374d6350-a602-bd7c-4c44-438dfbd37a4e	346fbf56-89f6-4729-e8aa-438dfb8c99b4	322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:27:37	0
3ba1d8fd-4d52-8480-8e9d-438dfb9d3725	38b8f391-5b5c-3bdc-3867-438dfb3984e7	322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:27:37	0
3fd6aacf-5e28-a179-c312-438dfb4ac731	3cfccbb1-7758-ceed-0c56-438dfbd66999	322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:27:37	0
440c15e7-8791-2922-4d97-438dfb402b20	41355cbd-f46c-8487-b7fa-438dfbdf5d76	322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:27:37	0
50d10de4-ba0f-0f20-1639-438dfb4bd819	4df89589-7dd3-6651-27f0-438dfbd8fb7d	322e401c-c694-0233-da27-438dfb2436c5	2005-11-30 19:27:38	0
656ef377-397e-a29e-0ba8-438dfbac45dd	628d2e56-ad54-c60e-3313-438dfb3eeac5	6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:27:38	0
69ad119f-3853-1ba6-bf23-438dfbbc9ed8	66db5351-8df2-b7a9-f0d9-438dfbf2cafc	6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:27:39	0
6de626ad-bee9-eb59-48f2-438dfbfda890	6b076c53-63b2-90d3-db10-438dfb196081	6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:27:39	0
72308d33-8256-094a-0fb2-438dfb8382af	6f56b608-9d80-e897-5ff0-438dfb9321d0	6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:27:39	0
765f0fb9-7f50-8fde-b54e-438dfb312e18	73943c55-420c-6bf6-338b-438dfbca86e1	6052c1a5-b3da-6061-5b1a-438dfbf123ea	2005-11-30 19:27:40	0
8b9f9cfa-ff68-82d5-09cc-438dfb9022d1	88cce231-e672-f824-c168-438dfb98b324	85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:27:40	0
8fe783ef-9013-59b7-ed74-438dfb88e315	8d026449-3c59-6836-b5f1-438dfb644eb3	85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:27:40	0
943b9981-e214-4875-71c8-438dfb6eb685	915370e1-e958-c1eb-6fe1-438dfb855298	85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:27:40	0
9871ab0b-45b2-854b-544f-438dfb85c7eb	95a0dbf8-6e4f-10f8-a7b4-438dfb54c9f9	85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:27:41	0
a3598a5f-1b77-5163-1aba-438dfb46b106	a08435fe-4e57-6aa8-f367-438dfbbd5bab	85ee0e3f-0406-f066-bfe7-438dfb3e0803	2005-11-30 19:27:41	0
b7ddf25a-bd0d-70b2-38a5-438dfbcb09da	b4fa3117-853c-7fca-71e5-438dfbc9c25d	b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:27:41	0
bc0f9b5f-483f-8422-6031-438dfb8d24aa	b93f550e-91ba-1083-6c9a-438dfbde9e52	b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:27:42	0
c052b0c5-5bd6-582f-57cd-438dfb5c469b	bd79bbfc-4ee4-2598-01e4-438dfb916374	b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:27:42	0
c492b3c8-ef65-9ffb-3a1e-438dfb6d3f5f	c1bba82c-7836-4c7a-b91b-438dfb72b369	b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:27:42	0
c8c346b5-dec5-f118-cca8-438dfbebae02	c5ed4400-85f3-69e4-c757-438dfb7540ce	b2bfa84e-a0ac-6463-92be-438dfbaed94a	2005-11-30 19:27:43	0
dd9305fd-44c9-2b16-764a-438dfb2522d6	da9c2e71-89d1-6bc1-b2cf-438dfbda5fd8	d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:27:43	0
efaa1d2c-815e-ff41-6fc8-438dfb8705ea	ecb46404-fb52-68a2-6148-438dfb435999	d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:27:43	0
f3e74820-7f67-3722-2ada-438dfb942244	f108e674-6996-c5fa-a48a-438dfb69affa	d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:27:43	0
4072045b-f64f-3007-8c91-438dfb5fd0e4	122a0ebb-d20c-f684-a603-438dfb04c76b	d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:27:44	0
85f40358-c497-fc07-fc67-438dfbda393f	577f0e5a-8ed1-e3ea-82d6-438dfbfb55fb	d84cc26b-f46c-10fd-4f62-438dfb4edfa7	2005-11-30 19:27:44	0
243cd36b-1a91-b7c4-c2a6-438dfbeb5d55	213d4769-4ae5-6b0c-dd74-438dfb896d23	1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:27:44	0
289750e9-5707-5e92-7921-438dfbdb5244	25ae7137-4075-1787-af84-438dfb92b8e9	1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:27:45	0
2cd3427d-9449-1473-d015-438dfb2c4735	29f4aaa6-b1a0-e4b5-517e-438dfb9d3e73	1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:27:45	0
31228925-8946-975a-dae2-438dfbb153cb	2e37dec5-d6e6-534b-d496-438dfbf93c40	1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:27:45	0
356eae98-0fdd-f097-25b2-438dfb1104d1	3295f9eb-c9f4-070d-6d36-438dfbd6a953	1ef0046a-4960-119d-3483-438dfb613ed1	2005-11-30 19:27:46	0
59f4450e-4f86-b369-5ad8-438dfbd9ac00	571573f5-bb22-be5f-68be-438dfbd317b6	54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:27:46	0
5fadd800-0c2e-7236-9de3-438dfb52b9e4	5cd61a59-8417-d484-5b3e-438dfb25988d	54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:27:46	0
63fb5ce8-21f9-f78e-6e45-438dfb127630	611b173e-ca9b-cd7a-7681-438dfb2f7ae1	54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:27:47	0
684892ad-1412-5f7d-aac0-438dfb9da1e0	6569e6cf-a0d6-6f77-5ffc-438dfb81fbe5	54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:27:47	0
73b668a5-d372-3509-d26a-438dfb146e20	70da632e-7e63-ca8b-df22-438dfb9eab49	54cfcff9-db3f-3b0d-be97-438dfbe302c0	2005-11-30 19:27:47	0
88455f31-6b0c-b6ed-5733-438dfb576dbe	8566bd97-0afd-10d4-137a-438dfb95871e	8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:27:48	0
93a47ef3-f009-f254-a55b-438dfb64b99a	90bd3ef4-fcdd-5d26-8edc-438dfb428c36	8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:27:48	0
97e54d0b-294e-bffc-024f-438dfb1aa6ae	9505024a-a881-82d5-0208-438dfb4f8466	8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:27:48	0
9c1ed8c9-d889-aed1-9802-438dfb773cf4	9949ce7a-0319-fce7-9662-438dfb010c80	8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:27:48	0
a051272e-5734-5cc3-63c2-438dfb336e6d	9d81d5ef-e868-acc4-0043-438dfb69c7ee	8327ec22-ad12-cd30-c238-438dfb0571e1	2005-11-30 19:27:49	0
b4e007f1-be00-ad14-3c57-438dfbf74497	b2048354-d7a0-786d-f01e-438dfb64c787	afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:27:49	0
b91ea239-834e-c2d0-120c-438dfbb7007b	b6445915-5efc-aa47-7c3a-438dfb8d8c9a	afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:27:49	0
bd66a9d1-4760-4927-df8c-438dfbff33fd	ba875b99-6770-be1c-0aa2-438dfb006643	afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:27:50	0
c1990bfa-3f15-2ca0-d73c-438dfbb5eaf8	bec7e542-9d4f-a077-21bf-438dfbbed6c4	afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:27:50	0
c5d82012-748a-26a0-5d56-438dfb676af5	c2fe2096-242f-a076-7a7e-438dfb7f3db6	afc2a69b-8290-5e45-403f-438dfbb1b556	2005-11-30 19:27:51	0
da971383-a58d-8412-087f-438dfb3658e1	d7b33ecc-3de7-d1d4-4eb0-438dfbe61e29	d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:27:51	0
e603ec29-3338-72b6-c2dc-438dfbdd1c2a	e31d5b01-c7a8-1785-8296-438dfbe6e019	d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:27:51	0
ea419d56-fd0f-4e46-7c39-438dfb236ccc	e765ca6d-c930-5939-106d-438dfb2e06da	d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:27:52	0
ee7ba34f-43d7-568d-6de8-438dfb33936b	ebad2471-81d2-b023-4b05-438dfb4ace2e	d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:27:52	0
ceea0d88-c9d4-550e-54bc-438dfbad77b9	a168079e-0368-a0b9-c046-438dfbdb939c	d5753872-c4a2-ab13-81c2-438dfbae0c3a	2005-11-30 19:27:52	0
2185e542-15c1-7919-5280-438dfbdc8a2d	1eb1d0fa-e2d9-2a21-683d-438dfbf8930f	1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:27:53	0
25ccdbf2-1b8e-1b93-6c3c-438dfbb0a068	22ed67d4-8a82-7b3d-c30a-438dfbb83942	1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:27:54	0
2a18a4ab-5445-d5fc-7f6a-438dfba6e214	272eb885-4746-d21f-671c-438dfba58c40	1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:27:54	0
3cf1028d-6dbe-8a76-a89f-438dfbbde7c1	3a18ba6d-41fe-ea45-6205-438dfb202737	1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:27:54	0
4136bf42-a195-a2df-5162-438dfb638163	3e4fc033-e47d-1f51-aba9-438dfb62877e	1c670ba7-7180-c746-7a2e-438dfb331ea2	2005-11-30 19:27:55	0
57ef8ee5-7207-3412-f8ac-438dfbc5f44b	550cc408-4a40-ee64-af1d-438dfba940e8	52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:27:55	0
5c2c47db-3669-3e4c-f23a-438dfbdf7cc1	595b9005-e616-1158-514f-438dfb13981c	52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:27:56	0
607c33e0-eb99-8218-12e8-438dfbb43286	5d88850a-909d-811d-1d3b-438dfbb5c652	52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:27:56	0
64b6d5f2-a1a4-1415-aae9-438dfba248bd	61e498ea-eb48-3a4f-8cfb-438dfb253513	52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:27:57	0
68f0828e-d0e1-247d-3bbf-438dfb488605	661ea93e-fc38-9f45-8b42-438dfbdbf357	52c17774-4f45-6c9b-31b1-438dfb100ff3	2005-11-30 19:27:57	0
7decf1f0-a04c-d0b7-245d-438dfb0426d3	7b0c1d4c-9d5a-635a-27c9-438dfbe0234c	78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:27:57	0
8985c92c-ca96-002b-00cb-438dfbb92bcd	86a66a07-a503-0b86-d6e4-438dfb220930	78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:27:58	0
8dc0f8fa-eb43-4f22-b88f-438dfbb590f2	8af4601a-005f-ad52-95a4-438dfb2a50b3	78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:27:58	0
91fb714e-67d5-e8b6-2487-438dfb883235	8f2239d0-4ac2-618e-e810-438dfbe8faf0	78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:27:59	0
9da56442-7262-fdd4-8646-438dfba9680d	9ac2da09-6d69-cd38-9683-438dfb34ac64	78c4ec52-4f79-ce55-3a17-438dfb858894	2005-11-30 19:27:59	0
b23242f7-abc7-0368-f831-438dfb588d2b	af57ac54-60f9-7084-3ba1-438dfb2e7849	ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:27:59	0
b66eb1c8-4086-4b57-c641-438dfb7d6f8c	b39babda-d601-6436-84a3-438dfb10e1dc	ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:28:00	0
baa3b096-6d90-366f-d48b-438dfb3ca979	b7d0ed2a-bad5-d4aa-eff9-438dfb51f2d2	ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:28:00	0
bee0093f-5069-e074-78cf-438dfb57cc7c	bc0865a7-ba44-6b90-1638-438dfb2c8a38	ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:28:00	0
cabc6b17-0941-f979-3004-438dfbe6925e	c7c58226-0f3e-5b37-d7c6-438dfbf15b92	ad155aa3-a8e4-85f8-3f49-438dfb1b1044	2005-11-30 19:28:01	0
e05f1a83-c9ed-da36-f9dd-438dfb2f715a	dd5e2f7d-02b9-3af4-e430-438dfb3971b8	db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:28:01	0
e4ea5a9d-7a97-b7bd-f41f-438dfbf3be05	e1c6c996-f162-8f10-9534-438dfb312ea3	db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:28:02	0
e943edd4-7bc8-e54d-72a1-438dfba9f8ff	e652e707-a2ea-7efe-e290-438dfbdcac15	db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:28:02	0
eda1dd98-eae4-0521-6f3b-438dfb89813a	eab1b37a-1e82-a5d7-3ccf-438dfbada238	db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:28:02	0
f207856f-facc-5eff-83c5-438dfbb52ac4	ef12ed9c-ed58-7558-c957-438dfbfab0de	db14c64c-910d-69f7-4363-438dfb060df3	2005-11-30 19:28:03	0
1359dbc5-251e-6776-6f40-438dfbdf298e	10637bce-6c07-f91b-b1da-438dfbdc343a	e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:28:03	0
17d2741e-0594-4405-de0b-438dfbe20986	14d16117-5adb-d52a-fac0-438dfb166825	e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:28:03	0
1c475057-2a98-e39f-6e06-438dfbe239d5	19430bd1-e580-ec44-4db7-438dfb249a5c	e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:28:03	0
2feae558-4f24-39b8-ae53-438dfb88482c	2cd67c9d-cbfe-1931-ab55-438dfbf5a4ac	e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:28:04	0
34590ab8-4aad-1cd5-8b1a-438dfbd66e96	3153925b-f2f3-3731-1453-438dfbfe0f79	e0b30a6a-2d97-08a9-b773-438dfb91ae00	2005-11-30 19:28:04	0
4bb114e3-0b59-e7f5-ac70-438dfb38661f	48c4ec5f-f2ff-1b7a-c8ca-438dfbaf49a2	44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:28:04	0
4ff95939-ea49-9733-492b-438dfb1dc1db	4d1650b4-1dc9-1d91-8193-438dfbbb855f	44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:28:05	0
5446393f-8db8-5d0e-d54e-438dfb226f69	515caf48-7b97-6ff7-e01e-438dfb58c978	44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:28:05	0
6044055e-e161-0c2f-45d2-438dfbfeaf6f	5d57572c-0744-c122-94d3-438dfb16113a	44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:28:05	0
64763296-400e-1c78-350d-438dfb49b828	61a80aa3-d0a9-40f5-e34b-438dfb8ff36c	44499ff2-512d-c664-957c-438dfbce7e97	2005-11-30 19:28:06	0
7926c6a7-5492-6a2f-30b9-438dfbe86f60	76484450-6d56-96c9-90af-438dfb71b846	73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:28:06	0
852192e3-5cde-8c3e-6e1d-438dfb665cea	8243b2d6-369e-4b57-f419-438dfb94af1b	73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:28:06	0
896c6a00-2ea3-8c1f-7383-438dfb9627f4	868c90de-e07b-1f90-5a97-438dfb45ee73	73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:28:06	0
8da57b4a-87d3-db73-d421-438dfbb9b4b4	8aceed1c-5c76-59ec-f3f1-438dfbf2dc7d	73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:28:07	0
91d91b60-bc95-8876-5d22-438dfb1a78a1	8efe4ddf-f965-205a-8705-438dfbcdc3a5	73f7b9c1-cae3-d662-c9aa-438dfb346e05	2005-11-30 19:28:07	0
a6729468-b692-2537-2a8e-438dfb77c932	a397c231-b0cf-47c9-0c2d-438dfb5e25a0	a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:28:08	0
aab29392-b1f7-cdb2-f451-438dfbad04fb	a7d87ec7-ba06-e130-534b-438dfb84f806	a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:28:08	0
b6b384ab-b97a-16dc-4445-438dfb389884	b3dd2bcd-e859-aed4-7495-438dfb4fdbf4	a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:28:09	0
bae65ac7-4f72-fc86-2736-438dfb8c3c4f	b812d15b-14e3-3eda-ba5a-438dfb8ab7b6	a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:28:09	0
bf1d5579-ed6d-6824-17c6-438dfbdb3096	bc49fb0c-dcdc-10f4-cefc-438dfbcd49e8	a15828e0-e941-7e5e-6f3f-438dfb062b99	2005-11-30 19:28:09	0
db77bd98-61e7-28e9-10be-438dfb6a3b1e	d88f4492-2540-a615-43ad-438dfb1846af	d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:28:10	0
dfae5ab2-0a07-6143-ee3e-438dfb2a70aa	dcd97378-88e1-2a71-312a-438dfb24d4e5	d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:28:10	0
e3f54d7b-4524-b666-83fc-438dfbbae744	e113136a-967f-bf05-0ab6-438dfb72f78b	d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:28:10	0
e82f8ca7-81a8-7e95-8de0-438dfb053750	e5578bdb-54bf-b68c-d40f-438dfb7becd4	d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:28:11	0
ec5b162b-f1e1-5d87-cf9a-438dfbc80570	e98df231-21c8-60dd-c14e-438dfb36d151	d6531f8e-d33a-e2e4-7955-438dfb4d05f0	2005-11-30 19:28:11	0
cc760cac-e898-1efb-cf7b-438dfbb60eac	9f320ae9-6cbb-cde9-adec-438dfbaf5bd9	7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:28:11	0
10fe4561-5059-4105-a3c6-438dfb01af71	e2b40127-485e-77d4-c940-438dfb8ae303	7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:28:12	0
153f31d4-e9c5-991c-e6e5-438dfb510a96	125dfe58-e0a8-b81b-97d1-438dfb996e12	7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:28:12	0
1998ac4b-bfeb-7ebd-9a9e-438dfbed75bc	16a0f284-e1bc-4270-0983-438dfb6db234	7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:28:13	0
1dce565b-c9b6-584a-2b7d-438dfbbc6a8d	1af83e11-1eb3-9d23-6f26-438dfbd8cfb5	7ade03c1-f61f-b9f9-aa17-438dfb9a7bab	2005-11-30 19:28:13	0
3a86abed-faf3-e89e-2e63-438dfbb218aa	37b0aca8-c215-53e7-ad67-438dfb16fdf0	356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:28:13	0
3ecad0f4-0cc4-9884-5be8-438dfbcfd12f	3be7034f-ee34-3dcb-6b5d-438dfb011f4b	356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:28:13	0
43025df2-b04a-9ddf-3fa8-438dfb51e8f1	40303f9e-dd84-4763-918f-438dfb919c34	356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:28:14	0
491ac4b8-9214-ab8c-380c-438dfbebc881	446aadde-e03e-8b82-365d-438dfba4166c	356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:28:14	0
4d793993-d991-ab42-b838-438dfbc6193d	4aa8d8c0-1cb5-e654-80a9-438dfb781c68	356ecfc0-140f-77b6-2121-438dfbc3c55d	2005-11-30 19:28:15	0
6244c6e1-2bd0-6b2b-c177-438dfbe1855a	5f57f37b-197f-b947-f7e4-438dfbc942bb	5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:28:15	0
667e9bac-5d8b-91a1-4213-438dfb638a45	63a80a86-61bd-504c-cf3e-438dfb09bab9	5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:28:15	0
6ad18620-58f3-4227-80c6-438dfbedd495	67daf1de-ba73-c12d-db71-438dfbeadccc	5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:28:16	0
6f0f3df9-2bde-14a2-d1e2-438dfbe4a316	6c40d279-e6de-8de4-c1bd-438dfb3faa02	5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:28:16	0
733d4eaa-9383-cfde-f213-438dfb1983ba	70715c59-45a9-c8db-f3db-438dfbce08f7	5d13a786-5be5-de7f-dd0c-438dfbf14353	2005-11-30 19:28:16	0
87eea3e7-90b4-2b2b-dbc8-438dfbbf9b34	851abc1d-ce24-f9e1-24c3-438dfb9f3493	82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:28:17	0
945c29a5-0c23-407c-bbe2-438dfb2820c8	916d8e6d-1812-48c4-473b-438dfb12b35a	82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:28:17	0
9897c645-46a3-c95e-e288-438dfbf4a88f	95bd0b3a-00a3-72c2-b2d9-438dfbc0907d	82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:28:17	0
9cd281f4-6d1e-c019-305c-438dfb15a82c	9a05b175-92de-de44-e752-438dfb8c0083	82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:28:18	0
a0fd30fb-8841-43fd-4a92-438dfb59a3d8	9e2d479d-bdbb-bf96-605a-438dfb5377d0	82d95c21-6a10-9582-5b3d-438dfbf0a156	2005-11-30 19:28:18	0
c60b10f3-39be-fdb0-b8de-438dfb08afa6	c3367856-a755-f9b4-9799-438dfbb3a65a	c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:28:19	0
d2798ec8-dd5d-69b7-738c-438dfbd9b1fe	cf97df3e-3866-2533-7859-438dfbae62d4	c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:28:19	0
d6f53719-01f0-dece-8d88-438dfbc8f04f	d41a8b3b-67a4-dca0-5459-438dfb0b289f	c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:28:20	0
db3082a7-f5b6-ba40-89bd-438dfbbd1bf1	d85b5609-57d5-37a4-b04f-438dfbd52e19	c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:28:20	0
e7b257bb-79f2-57e1-b615-438dfb1c2fd7	dc97eee9-dd63-92ec-1ff4-438dfbd1fdf0	c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96	2005-11-30 19:28:21	0
18bf44ec-0d5f-1c1c-71a8-438dfb5d9d3e	15b9c39f-be49-4d50-f94f-438dfb9df55e	137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:28:21	0
1cf676df-3bfa-9b46-bcfc-438dfb6a372f	1a211c97-838a-513a-f9c7-438dfb65c2f5	137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:28:21	0
212f9619-be04-7042-aa5d-438dfbee0470	1e54c3f3-fe2b-5314-1db0-438dfb255e86	137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:28:22	0
361b89a8-5c4b-cd4e-c8e5-438dfbfcb9a8	3338589f-d5bc-1771-06c3-438dfb321b14	137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:28:22	0
42893057-48ef-b692-f8da-438dfbd9f457	3fb6701d-d759-65fa-ab31-438dfbc14aee	137e9f95-f313-8360-f71c-438dfb599270	2005-11-30 19:28:22	0
59c1f6da-00d9-e4e2-8987-438dfb6fbd6e	56e43da4-2a63-8c22-8da4-438dfb1dc8c0	548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:28:22	0
5e01baf7-3d5d-ffb6-bd68-438dfbf0691b	5b2924ee-e1c6-ccce-9f93-438dfba687f5	548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:28:23	0
624543ea-2703-f993-9fbe-438dfb9d2082	5f687294-9a27-c353-e829-438dfbdc1d78	548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:28:23	0
66875c36-2f66-1903-6d22-438dfbe8ff49	63a1b897-e890-7eb4-5b17-438dfb9b07c0	548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:28:23	0
6ab483b0-e912-3ade-9993-438dfbbb9f2b	67e3e2b9-3823-c240-ad44-438dfb865204	548525fc-1d16-2812-5072-438dfbaafd50	2005-11-30 19:28:24	0
7f57f427-f1ba-04c0-6563-438dfb6944dd	7c7b94ca-070b-e28b-7671-438dfbf5c05e	7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:28:24	0
8bf7b195-768a-84af-0251-438dfb8862ff	891fa6b6-8978-58a6-0f2e-438dfbf1be05	7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:28:24	0
902849d0-1a4d-3af4-be40-438dfb872e2b	8d5763ca-4b51-07e5-3283-438dfb7c38b1	7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:28:25	0
94750f40-eb54-9348-fa9b-438dfb1f5e8c	91930181-de5d-8857-1263-438dfb6de21f	7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:28:25	0
98b33997-9645-7921-8976-438dfb4c4725	95de709b-2a03-1f96-10b0-438dfba72e13	7a3171f6-d717-19aa-5933-438dfbda3f5d	2005-11-30 19:28:25	0
ad4b89c0-91fa-2e0f-ac88-438dfb016992	aa64b4b0-1dbd-dc94-d692-438dfb9838a9	a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:28:26	0
b17cf23e-decd-9629-e1ed-438dfb31c1e8	aeaffaf5-96df-ea64-d9ee-438dfb1be5ed	a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:28:27	0
b5b1e5ec-428f-7ce4-cc0d-438dfbed4b8d	b2dabb09-a579-2415-1487-438dfbcc0a28	a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:28:27	0
b9f6af41-b4ee-1e59-ee7d-438dfb739900	b71438a5-e7f0-807c-fbda-438dfbaaab38	a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:28:27	0
be21f6a0-2954-50b5-0d4c-438dfb70d795	bb520762-3a0e-3468-884c-438dfb8cda2a	a818e283-96a4-aa8c-37d5-438dfb366d30	2005-11-30 19:28:27	0
d2a8526e-267f-9bed-3abe-438dfb57f97f	cfc9938c-3e6a-4c53-af48-438dfb2fc0d9	cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:28:28	0
d6debda4-cdc0-81db-597f-438dfb6e330a	d40aaed9-163e-f9ae-70c2-438dfb496ad5	cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:28:28	0
db1c4e76-02b4-d41b-895c-438dfb52a006	d83d79a8-9c0c-5650-b913-438dfb5d246c	cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:28:28	0
df613511-244e-5bc1-4abd-438dfb0b924d	dc85eb5d-78a2-d399-a19f-438dfb3a0d1e	cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:28:29	0
900008ab-eb10-0a7e-c1f1-438dfbf30bb2	f1d8d942-9883-8fba-0719-438dfb5fbce2	cd8af16b-58ec-668e-e936-438dfb0fdf00	2005-11-30 19:28:29	0
1521105e-6bb5-4bb4-a572-438dfbaaea3b	124efa50-e881-8c73-f0e5-438dfb0e0d1d	ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:28:29	0
2a8dda82-717b-0d15-3520-438dfbc75b13	27adc6f9-6865-6819-b437-438dfbdf0b6a	ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:28:30	0
2ebb8e75-c537-2a45-6100-438dfbac2b64	2bee1307-d8db-feed-3caa-438dfb674112	ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:28:30	0
33031c0a-4908-4416-d30c-438dfb1e5d64	301f2c49-781b-74dd-95d5-438dfb7b8a56	ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:28:31	0
3764a3c5-35b1-2a33-ef46-438dfb471c48	3486f768-4d35-fd80-aa91-438dfb8716d0	ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a	2005-11-30 19:28:31	0
4e0f4b80-18b4-8f3d-c09a-438dfbea3bf9	4b24eb84-a448-bda4-53c2-438dfbf725b8	48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:28:31	0
5250241a-71aa-b279-4cbc-438dfb578c0a	4f79f0dc-3e9e-7f1c-b7c3-438dfbf10dc7	48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:28:31	0
56a4f359-59b7-f963-c67b-438dfb80593b	53ce1662-3306-fd39-470d-438dfbef4dc6	48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:28:32	0
5afd1d61-daff-afac-f65a-438dfbf3c890	581eb064-97dd-45eb-1e3b-438dfb79621f	48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:28:32	0
5f2f7cdd-f9bb-763c-5e08-438dfb1a7c31	5c572b88-1f7a-1bb9-929e-438dfb8bc0f1	48da9622-e1a0-fbf9-fd6e-438dfb5e0199	2005-11-30 19:28:32	0
73c6a366-cd8f-d162-2cfc-438dfb158272	70ec9f1f-6438-5240-d0d4-438dfbff60dd	6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:28:33	0
780f747b-f701-4d50-4417-438dfb3494b8	75276228-43aa-069a-8c08-438dfb280221	6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:28:33	0
7c419bfa-beca-86fa-f4bd-438dfb12cdbe	796b1146-d029-ad98-ff0d-438dfb512e24	6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:28:34	0
80b3d343-82dd-4628-d924-438dfb02d850	7ddb296c-f433-56c3-96d1-438dfb64e099	6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:28:34	0
84f5bae3-e52f-0549-6065-438dfbd640b9	82184ae6-0171-31d6-8204-438dfbcc04b0	6ea42746-6034-fd93-ae2b-438dfb7d7116	2005-11-30 19:28:34	0
998e190f-23c8-5596-7a04-438dfbcf212e	96a9022e-a38a-8e30-919a-438dfbe43123	9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:28:35	0
9dcfd2b1-0698-c236-cdde-438dfb776339	9afa05db-655e-7c4d-301d-438dfb90e5c2	9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:28:35	0
a1ff7efc-28b6-bc71-1624-438dfbc79067	9f2bc6e3-5b19-10c9-9cdc-438dfb6d33d3	9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:28:35	0
a6bdd599-28f9-0333-8f57-438dfbf55bf0	a3e33aae-47b5-f2ce-9699-438dfb4ba681	9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:28:35	0
aaf11192-575c-8b69-c02f-438dfba57ea9	a819339d-830e-922d-23e2-438dfb434e97	9460b401-d542-7d9e-8055-438dfbe5fc59	2005-11-30 19:28:36	0
c0242f17-8aa8-eb88-fea4-438dfb3fcaa6	bd477a6b-9683-958f-a3e4-438dfb4ca67a	bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:28:36	0
c45e21ca-8dc3-6964-ea74-438dfbff838b	c18c3476-7ad5-e146-e9ef-438dfbe7b61f	bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:28:37	0
c9009b13-9953-cd77-f50f-438dfb2cb289	c6193032-75a6-edd9-52cc-438dfb6da43e	bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:28:37	0
cd390eab-0eb6-c168-94b8-438dfbec0303	ca6630cb-8783-b0e0-f738-438dfb04b16f	bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:28:37	0
d17d29c2-9e4c-0570-663c-438dfb5f252c	cea9abbf-8690-ff31-6cf0-438dfb42746a	bb03cc1d-1a07-9134-d717-438dfb09a7da	2005-11-30 19:28:38	0
e61bc462-5fc3-7488-f3c8-438dfb3e9300	e34088a8-5f4f-c92b-ea21-438dfbb141f8	e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:28:38	0
ea4d4efa-e7d7-d167-78ef-438dfb5a84ee	e77bea63-9bf4-52e4-2d1f-438dfb5f62dc	e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:28:38	0
ee8d8dba-9180-2b40-795d-438dfb15f74b	ebb07013-8a1b-7def-4eeb-438dfb4ed80b	e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:28:39	0
f3245f91-d15d-f5be-f892-438dfb897506	f04d9504-9f8a-aa3e-dbc5-438dfb35937b	e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:28:39	0
33640209-835f-a7e7-b881-438dfbb008e7	5c800c97-05b0-e598-90e9-438dfb895ce6	e0f0dce7-0249-715a-aa3a-438dfbb404f3	2005-11-30 19:28:39	0
17cb77de-c4b3-6684-e33d-438dfb7c5da6	14f5390e-ce13-d0de-152a-438dfb97bd9f	12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:28:40	0
1c113bad-bf55-2bfe-4301-438dfbf21dd1	192fe6b7-9b48-f34f-28ed-438dfbe9c786	12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:28:40	0
20648e15-dc6d-4fc8-54f2-438dfb38b06d	1d7265af-72d1-94c8-ca8c-438dfb71deb1	12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:28:40	0
251e6112-99ed-a08f-3686-438dfb52239d	223a7858-8497-18ef-dce0-438dfb8151cf	12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:28:41	0
2951ace3-998b-8233-3107-438dfb27d3af	2677e037-83a3-76d3-bb28-438dfb1860a4	12b61455-359d-ef18-61dc-438dfbc36256	2005-11-30 19:28:41	0
3e036676-91bc-0f3b-5281-438dfb71dd3e	3b27f0c5-a06c-8e6f-9da2-438dfbe4cef2	38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:28:41	0
424bb71f-0991-8184-a7dd-438dfb976b37	3f652f08-7228-7a76-1955-438dfbd5dbbd	38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:28:42	0
467cf8d9-4526-a0df-5db8-438dfbddd6d6	43b087a5-3e5f-1659-7819-438dfb55cd01	38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:28:42	0
4cbb4375-5c35-0538-c22d-438dfb72138c	49d7384a-32e4-b26e-2caa-438dfb4a28e1	38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:28:42	0
50f91e04-964a-75d1-cc3d-438dfbb25b3a	4e1da2d5-695a-df90-fb61-438dfb35d19a	38e21953-c4b9-e613-7092-438dfbd0c194	2005-11-30 19:28:42	0
6592d662-713b-cff5-9d57-438dfb93f365	62acbe91-442b-af05-c8b2-438dfb985545	60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:28:43	0
69d70eee-755f-20d0-887b-438dfbef4170	670276d0-20c4-5378-8163-438dfb40dd30	60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:28:43	0
6e0ee764-611a-f2b6-9675-438dfb132d72	6b32a561-c963-203d-207e-438dfbe23695	60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:28:43	0
72480d72-5896-75fd-a3fa-438dfbdeb0b5	6f754bd9-e37c-1c3d-30b4-438dfb5515a2	60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:28:44	0
76aca36f-6b1f-642b-bfaa-438dfb4a58fc	73ad58d7-0868-9fe1-cdbb-438dfb03c894	60684d96-aa4c-400a-3f4a-438dfbba21ee	2005-11-30 19:28:44	0
8ba43531-367f-5d95-ecad-438dfb181330	88bbee43-05fc-0c5d-ec5e-438dfbfca152	86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:28:44	0
90823140-bfc8-0c01-a9da-438dfbf65695	8daa8756-3628-c5c8-dccd-438dfb6e54fd	86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:28:45	0
94bc8658-3bf8-faf8-6b16-438dfb72a867	91e891f2-4e94-1b42-0cc4-438dfb37648c	86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:28:45	0
990f8a6a-1236-6bc3-1918-438dfbc83349	96271a3c-fd00-ca8c-3a9a-438dfb68812e	86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:28:45	0
9df895ef-aea1-5418-3592-438dfbb9e3af	9b2014ce-8c7c-7367-2aca-438dfb9770d1	86803808-fbc6-9eb8-e332-438dfbc84e4d	2005-11-30 19:28:46	0
b2868eb4-54ca-47d6-dd04-438dfb009335	af9ee398-acd7-7e15-ebd5-438dfb61447a	ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:28:46	0
b6d1aa5e-8cb4-c8b0-2ef4-438dfb677cc4	b3f18a92-a0a9-de14-7f9e-438dfbf577a9	ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:28:47	0
bb04e661-1f38-bf67-3238-438dfb549eae	b82dde5a-8c2d-4333-77ba-438dfbb33041	ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:28:47	0
bf41dada-61c1-f0ae-15fc-438dfbcdf4c2	bc624268-3953-115d-a96f-438dfba1ad4b	ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:28:47	0
c3814c4b-1be8-4a51-794a-438dfbf9e61f	c0a1be3c-90f1-fe39-d75a-438dfb7ce84e	ad550398-ed33-33b0-506e-438dfba55edc	2005-11-30 19:28:48	0
d80d0554-411d-2492-1906-438dfbb5975e	d5396cfe-8e35-066e-3c76-438dfb0e88f0	d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:28:48	0
dd141071-8ab3-ad22-ae0c-438dfbae8378	da3faa8d-bcee-1e86-4d34-438dfbe25906	d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:28:49	0
e157d10d-b18c-9a1c-b31a-438dfbf4775a	de74a868-9414-541e-6786-438dfbedccef	d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:28:49	0
e5becdaf-e5cd-a915-9622-438dfb183f73	e2c758a4-d8a2-2848-c7f4-438dfb372029	d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:28:49	0
eb93d6fc-2620-850b-493b-438dfbc26184	e8b3c25d-59bf-385e-7bfc-438dfb9d0881	d2f41bc7-cf41-86c8-a468-438dfbebc670	2005-11-30 19:28:50	0
c0c30e30-28a6-7f00-ba59-438dfb35c358	91e70df3-267b-baed-6ddd-438dfb4c01e6	6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:28:51	0
121e35c9-3205-c6ec-4b9d-438dfbce77b0	f3760c52-a21f-075e-c86b-438dfbb83032	6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:28:51	0
164fb7dc-8e31-6f55-f329-438dfb88bc5b	13825ca3-d7e2-868e-68a8-438dfbb040cb	6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:28:51	0
1a984fa4-702a-e4b4-73d2-438dfb15d4cd	17b306fa-f7ce-7731-87a5-438dfbde77ee	6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:28:52	0
1eddde35-f795-a828-a39c-438dfbb79d04	1bfe3863-d70e-1343-bb1d-438dfb7def6c	6dbd0bad-3095-cceb-6509-438dfbcbadc8	2005-11-30 19:28:52	0
3549729b-b095-bfca-a7cf-438dfb328e55	324f88fa-0d09-0a9d-7b6f-438dfb0d8d40	30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:28:52	0
39808cc9-0a85-a5b7-af73-438dfb81b5d4	36b1e2f1-4490-e0c1-819e-438dfb69329d	30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:28:53	0
3dbda8d4-f8e1-d1ca-e772-438dfb9c8660	3adf2f2f-75fd-0a35-8064-438dfbc72330	30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:28:53	0
41f9a5ce-2a72-43ce-3b25-438dfbdbe81b	3f2898d5-17e5-dbbb-948a-438dfb20e069	30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:28:54	0
4636837e-c10e-3dce-bbb9-438dfb07c257	43695ddd-0e03-1a00-d14d-438dfb7b96a7	30074748-1f3c-ffca-1f92-438dfbcdf41b	2005-11-30 19:28:54	0
5cef6806-5eec-494a-1ecd-438dfbf43852	5a0d1a43-6da5-2adf-4d66-438dfb876a63	57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:28:54	0
622a66b6-f040-2248-e13a-438dfb1ff11d	5f53a3e2-8e16-1932-9279-438dfb040753	57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:28:55	0
66647e1b-20b3-d451-d6ff-438dfb197f33	638a186b-cd9b-6279-ef80-438dfb5a449a	57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:28:55	0
6aab30cc-1709-1be9-1522-438dfb3fcbd8	67da605a-c9c2-dd57-26ce-438dfbe12314	57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:28:55	0
6ee53b6f-201e-282e-555c-438dfb33d9d2	6c0c4a42-4336-a36f-0209-438dfb6afa76	57cab759-6c7e-8167-0136-438dfb48df83	2005-11-30 19:28:56	0
847c56bc-2662-15ac-22d9-438dfbddbeba	81a07c9c-1002-0f4d-4d4c-438dfb5eab68	7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:28:56	0
88b6e656-1f0a-6112-9df2-438dfbc1cb61	85e51e31-6d15-d00d-305a-438dfb0351a2	7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:28:56	0
8d01470b-1b8a-692e-4349-438dfbe57bf0	8a22caf9-7960-c597-6921-438dfb945d78	7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:28:57	0
912d4626-6d12-9935-773f-438dfbb6f3ee	8e5e6437-ec7e-753c-c07c-438dfbe84081	7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:28:57	0
95641509-2a65-8289-1f34-438dfb15ebde	92894f41-dc08-394e-33f9-438dfb476c8a	7f5e48b7-8871-f3e9-716b-438dfb8e9e06	2005-11-30 19:28:57	0
aa060f2e-8bc5-dc6d-c825-438dfb5d0141	a72f6154-09c0-4129-3b85-438dfbc82b7a	a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:28:58	0
af6ab677-c2db-e560-1e15-438dfbc59b2d	ac8f4c2c-3db1-9313-b808-438dfb3abda0	a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:28:58	0
b3a0a336-056b-4f3e-53fa-438dfb0c6c53	b0ca4fbf-fef4-befb-da34-438dfba86bc6	a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:28:58	0
b7d8e4f7-e557-33f7-a453-438dfb9b79d6	b4ff8f59-9210-fa9e-8fc6-438dfbb4b91b	a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:28:59	0
bd3c055e-4b70-79f6-ca78-438dfb4689e3	ba6a224f-3afc-cda8-da86-438dfb15de16	a4f68013-8e21-9e4d-982d-438dfb76cef9	2005-11-30 19:28:59	0
d1ba39f0-bb2a-48e4-be9c-438dfbb45fea	cece7c9b-c644-ef80-7ec9-438dfbc6b38e	cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:28:59	0
d5f8cee1-9ac1-496d-f45e-438dfb617b81	d321d22d-ee21-9219-3a47-438dfbc4e936	cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:29:00	0
da2ef32f-1c29-521c-9b25-438dfb377416	d752764d-352c-bc77-56ed-438dfb21f615	cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:29:00	0
de68ca6f-64a6-1b4a-8d13-438dfbf48185	db97d0c1-7988-e886-7d82-438dfbece6c2	cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:29:00	0
e3d9478d-4a42-0a54-8984-438dfbdd101e	e103fad2-59ad-98d1-f798-438dfbcad8f9	cc8c4b85-7a41-ee9c-5ae8-438dfb628795	2005-11-30 19:29:01	0
45ba07d5-b988-509e-76f4-438dfbd01e94	1740037a-31d7-7048-a09e-438dfb79eecb	f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:29:01	0
89f20659-7e93-8d00-bc18-438dfb309ae9	5be3040e-250b-8bc0-04eb-438dfb83b8b5	f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:29:01	0
cd2e0a48-8c8c-eb60-4800-438dfbf28442	9fe10a4f-870f-a0d7-3fb7-438dfb819db1	f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:29:02	0
110b827d-56da-aa3e-bf1d-438dfb2227b8	e35c0c31-0d54-54a6-1bbf-438dfb7a8cad	f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:29:02	0
154a8ff4-1a73-fe99-e05c-438dfbd175ea	127c2bde-2120-08f4-0858-438dfb54c53c	f3562fb8-e19d-3c2f-fd04-438dfb709397	2005-11-30 19:29:02	0
2c76f6b0-853c-4398-4ae0-438dfb223a61	298ea7f5-b028-8377-5498-438dfb61537a	27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:29:03	0
30b68253-31e2-aa3d-f9db-438dfbc40a74	2dd93c95-61f2-de64-5ce3-438dfbb86fde	27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:29:03	0
3513e26a-5f7d-ee42-aa6c-438dfbfbbb49	321889e7-9e84-c6cf-a0da-438dfb058d16	27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:29:03	0
394e868b-5500-bae0-444e-438dfb5491b7	3672e2bc-6180-a4e6-3526-438dfb068b07	27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:29:04	0
3d8ddec6-bc55-b58f-e9e2-438dfbc536bd	3aa83920-8862-cbe7-aab3-438dfbfd318b	27473bd7-d8cf-18f8-b2a9-438dfb78c444	2005-11-30 19:29:04	0
5436acf5-557e-3c4d-a06a-438dfb9af1b2	51573d91-49a6-37f0-fe81-438dfbae308d	4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:29:04	0
588982d8-5346-9d6c-49d8-438dfba73f60	55b7be0b-100f-52dd-259d-438dfb8a8499	4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:29:05	0
5cc8bee9-3a59-d426-a40f-438dfb09908b	59f29d8f-090e-0c1f-046d-438dfb39d632	4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:29:05	0
610ed34d-3b47-b8be-2778-438dfb8c1644	5e296854-5847-373b-0f40-438dfb35d165	4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:29:06	0
65430522-8d30-a805-9530-438dfb46624f	626b34d6-5b8e-7e9e-71e1-438dfb725610	4f0dc9e4-5602-a885-ae9f-438dfb9fb925	2005-11-30 19:29:06	0
7caebf39-3158-6791-ae24-438dfb23972e	79d59caa-1cb1-b8ed-6cb3-438dfb8be819	778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:29:06	0
80f989cc-c3ff-d563-018e-438dfba4a9ed	7e1ea5ea-5f4d-b883-1a0f-438dfb076f07	778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:29:06	0
85494e40-7468-33a4-7f04-438dfb255b77	825629b1-8d88-b8bc-80bb-438dfbbeec9f	778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:29:07	0
89817642-e947-2b25-e089-438dfb4a04cd	86a865cd-44ce-eb54-6601-438dfb2007fc	778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:29:07	0
8f8ce203-3ff8-cc5d-5e23-438dfb2ed872	8c703740-d872-169a-7ec5-438dfb10cbb7	778c9cdd-ed31-1220-9535-438dfb496070	2005-11-30 19:29:08	0
a50b26cb-0023-7bfd-2ebf-438dfb148fba	a225ae3c-9617-3139-7217-438dfbaf6dd9	9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:29:08	0
a94c9166-f19c-2982-c9a0-438dfb6de016	a6737717-760d-8ada-984e-438dfbb70321	9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:29:08	0
af07cb37-5ed4-2c05-9f62-438dfb04cde0	ac33a8d7-fc48-d2f9-dcd4-438dfbe0f670	9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:29:08	0
b3394ebf-5158-c05d-7320-438dfb2529a9	b0663636-9267-8341-8d28-438dfb6ff736	9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:29:09	0
b768dfa3-e4b6-ca94-a625-438dfbe02576	b496305d-8844-59c4-a3c3-438dfbdf9404	9f58bfc7-c032-ea8c-7741-438dfbe5ff07	2005-11-30 19:29:09	0
cbe489cd-ea37-7a07-43fc-438dfbf1c340	c9088b65-a2c0-18a0-fcd7-438dfbf33649	c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:29:10	0
d028156f-df2e-f014-3384-438dfbe0df4c	cd4c432a-2f4a-22cd-9690-438dfb223171	c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:29:10	0
d4556f86-3d07-5d64-08e7-438dfb499af2	d1865fb2-6a83-196f-a36b-438dfba5c3f7	c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:29:10	0
d89941bb-6ebd-7d33-7249-438dfb6ae7cc	d5bc39d3-1ccb-f0d6-ad11-438dfb1b6095	c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:29:11	0
dcc5aab3-53bf-4073-12f1-438dfb0a88bd	d9f2789b-80c7-5673-a484-438dfb41260c	c6c2c945-7272-8204-87b6-438dfb21706e	2005-11-30 19:29:11	0
f15cc7ac-3ab5-72da-6832-438dfb0505df	ee86923c-faac-2439-b3ec-438dfb3113b9	ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:29:11	0
31d0002e-c569-9e15-5797-438dfb453c61	4c300068-09b7-88f2-1495-438dfb5071ee	ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:29:12	0
75f0025c-45b7-2a6b-2aed-438dfbc221a8	48630f48-32a2-5c3a-afcd-438dfb80f92a	ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:29:12	0
b8e70144-3070-8805-306e-438dfb519cd5	8c3c032b-6e14-5be7-fd5a-438dfb1d3f38	ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:29:13	0
fbc10f1d-7014-8c77-31c2-438dfb814df0	ceab00aa-e40a-de9e-0d6f-438dfbe83560	ec3a8159-35a1-1e25-873d-438dfbd93199	2005-11-30 19:29:13	0
24537afc-0f4d-3d51-7d70-438dfb2c1894	2175749a-707b-4d9b-76e3-438dfb6b4688	1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:29:13	0
2a446a93-7a83-276b-880b-438dfbf4777b	27709e07-48ca-a945-940a-438dfbd2a4f6	1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:29:14	0
2e82406d-a456-67dc-dee4-438dfbf4380c	2bb1ee75-aa7c-82ea-766c-438dfb44ae8f	1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:29:15	0
330465d1-bad7-98bf-9d73-438dfb3ec973	300227eb-b210-182e-9166-438dfb4f739d	1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:29:15	0
376463c3-96b7-9337-99a8-438dfbc6af79	3465262c-b5c3-89f3-5a70-438dfbe785b9	1f2fea14-abc1-3aec-e784-438dfbc6c413	2005-11-30 19:29:15	0
4dccfbc8-2e0c-0244-ab1f-438dfbf73c41	4aece1ff-5188-3150-8084-438dfb1699b8	46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:29:16	0
520dda22-7c48-4350-e8c7-438dfbdd08d6	4f33afaa-0d48-e7ec-4e7f-438dfbf7f3ef	46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:29:16	0
564e1a2d-3eb4-3307-6de0-438dfb6a167f	5369945f-d99f-bc90-d892-438dfb160c6e	46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:29:16	0
5a82ded6-7a88-63a7-cfac-438dfb013c21	57b086b4-5057-e6a1-d002-438dfbc408be	46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:29:17	0
5eca7ea1-ae50-0bcc-e69a-438dfbfb0a0f	5bee4ca6-7dd8-7de3-9842-438dfbf21c50	46b00b5a-2979-a81d-21df-438dfb0ce21a	2005-11-30 19:29:17	0
77043b3a-2606-7fbd-de44-438dfb8fe1e6	741e7fcc-03f1-93b5-e3c8-438dfbb2536c	71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:29:17	0
7b872a78-29e0-b925-2464-438dfbd48449	78798638-1d5c-8549-c381-438dfbab1f4a	71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:29:17	0
7fe8b3e3-1e6b-80d5-db61-438dfbaa1eaa	7cebd1c9-9bbd-6643-2ba2-438dfb88ccc8	71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:29:18	0
8446fe2c-2bae-d76b-7b59-438dfb665ba9	815e999f-770a-4c34-fee3-438dfb6b1a88	71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:29:18	0
889757e7-bd62-9bb3-e358-438dfbb43566	85abf685-aaf0-8553-efe5-438dfbb7fe3f	71de7f65-fbfc-1247-48be-438dfbda2ea9	2005-11-30 19:29:18	0
9d4f52d1-4dad-9d9f-ee73-438dfbbdc5d7	9a7ba283-92a4-ae56-1b68-438dfb42734f	98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:29:19	0
a377b74f-f151-9b88-8ef4-438dfbfd92fa	a0a19d05-80a6-cad5-e6bc-438dfb757376	98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:29:19	0
a7c255fc-092d-9d55-d87a-438dfb781b3e	a4df4d0b-53e8-2964-f359-438dfb40bd5d	98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:29:20	0
abe93379-a8e3-39bc-c65e-438dfb9411b4	a9213571-6a04-62ca-88ab-438dfbbbd1d1	98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:29:20	0
b02889d5-fbe1-5670-7719-438dfba4bf3a	ad46911c-aa5f-ec0f-b5e6-438dfb3be758	98399ae4-48ae-3a6e-a6b8-438dfbfc3d10	2005-11-30 19:29:21	0
c8c38a57-8214-cd07-c109-438dfbe59974	c5e6c66d-c1b7-7adc-ddcc-438dfb06c42f	c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:29:21	0
cd01a914-1756-0d57-f07e-438dfbb78fd7	ca328820-6bfc-9c5f-320d-438dfb5baf28	c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:29:21	0
d136b583-35ad-063d-c4d2-438dfb944429	ce5d4289-9545-26c1-3bd4-438dfb67286a	c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:29:22	0
d56dbb31-71c7-fc0f-f5a9-438dfbc74b92	d294f52b-5d37-dbac-0bc3-438dfbfb3919	c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:29:22	0
d9aeaa06-e18e-c519-800d-438dfbfde44d	d6deb9af-5d80-9295-fb61-438dfbfdb715	c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b	2005-11-30 19:29:23	0
ee4f3add-be5f-4980-df95-438dfb185429	eb752b50-7c45-be90-3d93-438dfba8be62	e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:29:23	0
81000fc0-bb6c-3262-784b-438dfb80ae1e	f1c8f562-3571-ae4e-a3de-438dfb6e9b2b	e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:29:23	0
4c5009e3-6c98-ce79-658b-438dfb09a97c	1e2b0e67-57f1-20e3-6385-438dfb6cbb3e	e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:29:24	0
916c08a3-783b-2679-7e36-438dfbae0f15	629e0a1d-d9b7-4f48-572b-438dfb07b072	e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:29:24	0
d51b0d9a-cf4d-bc12-426c-438dfb01d6c0	a7710e01-1c9c-2517-ee64-438dfb50d218	e92944ca-2169-831d-2241-438dfbe14f3f	2005-11-30 19:29:25	0
21ec8751-83d9-4005-9db4-438dfb4a48ee	1f1b1ad4-a7e8-425f-c968-438dfbb85522	1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:29:25	0
261d986a-cfd9-0f24-2a99-438dfbb054ec	234bfbe5-01c3-7a7a-8cbd-438dfb321019	1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:29:25	0
2a5594df-d340-56cf-c69c-438dfb939360	277f3c0d-3c9d-3b45-d0ed-438dfbdde215	1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:29:26	0
34f59ad5-94db-78a4-74bb-438dfb0fa909	2ff131c2-eee4-2a35-8664-438dfb587601	1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:29:26	0
39543894-ab7d-72fd-67f8-438dfbda24ff	36793b32-ba5e-10de-206e-438dfb3060f2	1cd83a84-d536-65ee-1375-438dfb2acfab	2005-11-30 19:29:26	0
4fea0e95-cad6-b59e-fe5f-438dfb3f77d6	4d05bde6-43ff-5080-fd31-438dfbcdc707	4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:29:27	0
54259c0d-9c30-1bfa-8467-438dfbe11821	51533683-5141-3813-4ab3-438dfb885dda	4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:29:27	0
5883a64c-58ba-4c8b-03b4-438dfb4e9679	55aec868-a9ed-2098-c8d4-438dfbab465b	4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:29:28	0
5cbd3245-7c14-1aff-201d-438dfb73d823	59e6dac5-1728-3896-d536-438dfb3cffb7	4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:29:28	0
60ee3055-ebd8-6fb3-10b2-438dfb51c156	5e1ec970-154b-8973-e9e2-438dfbfb7b9c	4a646280-fdc3-79e8-9a02-438dfbaa84e7	2005-11-30 19:29:29	0
757f0ce7-7aec-23c0-bfb3-438dfbb91df7	72a24721-7cc9-164d-13a0-438dfb1a5aea	705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:29:29	0
79c13fe8-b4ec-244b-1378-438dfb17c342	76debfcc-f80b-f670-fbc8-438dfb4f2562	705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:29:30	0
7e2a80c5-02b4-2b3c-a70c-438dfb15108d	7b1c87de-0b31-d24e-6478-438dfb7e9a8e	705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:29:30	0
82712cb3-0fc3-bdd6-cf2d-438dfbed4a3f	7f929094-7b19-a715-b1f9-438dfb35f59a	705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:29:31	0
8698eb2f-222a-3db4-4fd4-438dfba82f90	83cd880a-ab63-a02f-b9eb-438dfbe29d5d	705ef7a4-43a2-08a0-db33-438dfb3485bf	2005-11-30 19:29:31	0
9b389bed-9dda-bbe7-1923-438dfbddae4c	98626edf-bff6-0fde-b67e-438dfbe3d865	96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:29:31	0
9f7c26c3-2224-b821-5110-438dfb24b45e	9c9ef028-6e51-8f18-aceb-438dfb9c7a8c	96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:29:32	0
a6154ec9-fb08-7304-cdb4-438dfb7d0f36	a33dbab1-738f-15f1-e6ce-438dfbcb771f	96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:29:32	0
aa46b68c-398f-0055-39ba-438dfbb4e59e	a7721d65-4786-e14d-5aef-438dfba72b46	96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:29:33	0
ae745ffd-005f-7735-d8c9-438dfb4def76	aba43724-123f-c738-a24b-438dfb518636	96149ed6-290f-78d3-3cf6-438dfb61ae08	2005-11-30 19:29:33	0
c3099ce2-5aac-af89-7828-438dfba8441b	c02d3fa7-a0bb-0c60-8780-438dfbe74cce	bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:29:33	0
c746841c-e337-7bbe-0da7-438dfbb9bc0b	c4739102-9223-2807-dafe-438dfb40aa99	bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:29:34	0
d057aacb-4bca-0aee-0fac-438dfb0bc43f	cd8ad378-c986-0da9-2008-438dfb4b449a	bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:29:34	0
d49341e2-15f3-224b-234f-438dfb47c89c	d1bd73c5-a067-1014-5138-438dfbcec3f2	bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:29:34	0
d8bfb4d0-06a9-7b9e-6491-438dfb853404	d5f17143-f477-b174-9c16-438dfbfd37dd	bded92e7-965b-d779-89ec-438dfb22fbcf	2005-11-30 19:29:34	0
ed5fb296-b107-7af4-2c25-438dfb099613	ea862498-186c-31b6-74f2-438dfb851ba7	e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:29:35	0
f1999238-ca18-89ad-5a22-438dfb8826d7	eebe47fd-dede-8d18-d73f-438dfb11d2f4	e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:29:35	0
1a190c36-7023-529a-0949-438dfb969e50	f2f674b5-3e4a-1ed2-a807-438dfb470ad3	e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:29:35	0
876807cc-6ddb-3826-c953-438dfb9b8fed	5a010197-bd33-9da2-a7d9-438dfbf1c47f	e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:29:36	0
cadd02e2-6d5e-53d0-8f5a-438dfbd5625d	9e020380-9227-a7fb-e695-438dfba49922	e84468c7-d9e4-070d-54f8-438dfb7ff11f	2005-11-30 19:29:36	0
265f771a-9717-f4ba-a517-438dfb6bdb50	2385e4cc-0239-459c-5122-438dfb254f31	2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:29:37	0
2aa17f50-9435-2366-dcc7-438dfb9da455	27c414dd-98b5-9302-ef20-438dfbc1e34d	2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:29:37	0
2eece8eb-d2af-2314-d15a-438dfb5a1543	2c149a35-f2c2-6294-9a2a-438dfb30cc13	2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:29:37	0
33294bb2-7516-bfd0-9069-438dfb35494a	3050d69f-33e0-0aba-94f4-438dfbfce52c	2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:29:38	0
37667972-a322-3e4d-2d1d-438dfb87bd1a	34879587-e5c4-d90f-8350-438dfb484f93	2148f18f-2408-a1cc-ebc2-438dfb9238fa	2005-11-30 19:29:38	0
4e02a3a6-f74d-3ec1-6210-438dfb29150c	4af14c3b-c835-f39a-ea2f-438dfbce0d6a	46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:29:39	0
54df7419-bafd-910d-cf08-438dfb71a300	520d12a4-87b1-c408-8286-438dfbe800b4	46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:29:39	0
5926322e-6fc7-0c73-dd23-438dfb5e5458	5640e559-6022-9b27-d15a-438dfb9741e0	46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:29:40	0
5d656bb8-3346-a6ce-a1aa-438dfbe04682	5a8a7330-1cb3-b5dc-4151-438dfb66c4f2	46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:29:40	0
619d5dbb-31b0-870f-825e-438dfbf418e5	5ecd1d6b-10c2-9a89-98a0-438dfbb086f1	46efaf6b-79d7-7108-b557-438dfb599391	2005-11-30 19:29:40	0
7623082e-35e4-857d-c88c-438dfb7322c5	7344511b-b554-e89c-6690-438dfb315a98	70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:29:41	0
7a977a5e-1ad2-913b-4944-438dfb1c3094	778ac847-bdf8-b56c-6cb7-438dfb7fc12b	70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:29:41	0
7f14dcb2-6829-463b-c123-438dfb3ef701	7c1a4b55-d637-d43c-4dfa-438dfbc2e9ff	70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:29:42	0
834e3b38-3d48-cbaf-a45c-438dfbf3f871	8076f686-4603-4b1f-fc4d-438dfb96c3e4	70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:29:42	0
8786a6a0-0044-8477-ee27-438dfbd6defc	84a8ab46-e35c-11dc-d93d-438dfbe1be53	70f9bcc1-a6cd-16ca-6188-438dfbfe26e2	2005-11-30 19:29:42	0
9c3b5ab5-79f7-dc4b-96cd-438dfb49e8cb	99592286-7d82-275c-f738-438dfb0df199	970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:29:42	0
a3328ebf-56ae-b10b-1e9b-438dfb695ddd	a0607ead-f878-6b67-a4c6-438dfb14e0df	970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:29:43	0
a7796092-b608-0bf8-4ddd-438dfb12dea5	a496fc5f-b61c-86f5-4a72-438dfb40734a	970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:29:43	0
abb76cfb-183b-b3a6-e55a-438dfbb82a39	a8e5b5a5-662c-c27e-b721-438dfb7a1a6c	970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:29:44	0
aff10caa-4168-a988-60c7-438dfbe0b2ad	ad113ca5-db33-a6fd-6e01-438dfb3ae686	970db1ca-bbc5-1bed-58bc-438dfbc02ed0	2005-11-30 19:29:44	0
c46f8bb3-faa0-0536-817f-438dfbdfddde	c1967462-3874-1dff-6aaa-438dfbab2e54	bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:29:44	0
cb8656ff-c7ae-bff0-0328-438dfb9e786d	c8ab1d15-d7d7-232d-b73d-438dfbaf4565	bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:29:44	0
cfc1b518-3189-9365-e472-438dfbc2fe3f	cce2d113-54d6-e5e3-d2ec-438dfb692425	bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:29:45	0
d3eeba0a-ca4a-38c7-5a73-438dfbf57bd4	d120d8aa-3408-b61f-f3b5-438dfbdc2845	bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:29:45	0
ddd56abc-f35e-0b18-0923-438dfb9de9c2	daf84673-a28e-c42e-1230-438dfb8f0d98	bf504165-a219-0727-b299-438dfbe18890	2005-11-30 19:29:46	0
f29d1810-876e-79ac-5bc9-438dfb2da93b	efc4933a-a92d-d382-4c97-438dfb098b26	ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:29:46	0
2b7a013c-727d-d8e1-2709-438dfb5b811e	f403fba8-3b7b-f882-4b20-438dfb32ccb2	ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:29:47	0
700c01fe-c0db-0d0d-13db-438dfbcc2508	41de08e3-2730-8fb9-8823-438dfb06989a	ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:29:47	0
b438044c-0968-7fa6-0543-438dfb3d7950	875b0a02-ae67-5164-e776-438dfb6e5810	ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:29:47	0
f6ab0184-35af-72fb-2620-438dfb6c025d	ca0601b4-5374-1c3b-1c0e-438dfb36fa25	ed7e2b76-7300-b676-c21c-438dfb5370f0	2005-11-30 19:29:48	0
23f8a465-df6a-a14e-7c94-438dfb2892ad	21231d0c-22ba-4289-4aa1-438dfbb73e9f	1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:29:48	0
2e284279-4188-7d08-0bcc-438dfb356468	2b4e3631-b9f7-b99c-617b-438dfb5df7bf	1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:29:49	0
3261c1d4-d4e1-44b5-1e7f-438dfb49e34f	2f88c188-508b-54c7-231e-438dfb7f7c9c	1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:29:49	0
36cc7b15-6ddc-ea06-2fc2-438dfbd0e4e7	33d62342-8116-db5c-febf-438dfb7f39d6	1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:29:49	0
3df6b39d-5650-390f-cd0f-438dfb92249c	3b2ba3ee-e792-9874-b53a-438dfbe9b4e1	1ee0a704-d3ac-255b-e28a-438dfb6778bf	2005-11-30 19:29:50	0
547efdc5-3090-e572-2387-438dfbdad1f3	51a0a43f-774f-21db-cd02-438dfb650f83	4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:29:50	0
58d4461b-9ac9-4ebb-fe2e-438dfb3340fd	55fcbad0-e7ee-8514-a2e5-438dfb83b8b9	4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:29:50	0
5d066496-facc-b5cb-4123-438dfb676061	5a2de2fe-05ea-cb13-c48f-438dfb58ec50	4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:29:51	0
6136a55c-768b-a054-d978-438dfb08455c	5e671fe5-ebd1-cc68-fc71-438dfbbdbd87	4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:29:51	0
65670072-63fa-3343-e953-438dfb21db47	6294037e-30d4-e2c5-55fe-438dfb06cfab	4f5a2e60-a328-2863-508c-438dfbf96b08	2005-11-30 19:29:52	0
7a0abc6d-afde-2a48-7108-438dfb3a3515	772e286d-2960-5afb-73ce-438dfbe2efb7	74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:29:52	0
7e775f1b-9d9c-1369-b359-438dfb868eb7	7b6dd476-772f-f044-76b9-438dfb512776	74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:29:52	0
82ba03d0-afaa-2ce2-44bb-438dfbc1e9a6	7fdbff25-07af-915a-6032-438dfb7242cb	74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:29:53	0
86f0693a-df9b-7ffe-d3fb-438dfb484382	8418ad34-d9b5-d672-2048-438dfb1f466d	74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:29:53	0
8e3aa7d4-c132-83a3-0077-438dfb33759e	8b6898cc-3109-946f-88e3-438dfbddea15	74ea30bd-bfd6-50c7-f602-438dfbb9b15b	2005-11-30 19:29:54	0
a2d23175-86ad-c475-8680-438dfbfc6f2e	9fffe509-5451-8010-b603-438dfbd57896	9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:29:54	0
a7113369-dc52-abd3-13ef-438dfb80fe34	a4397218-9a69-0160-533f-438dfb842aff	9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:29:54	0
ab4432f2-e9bf-e33d-5ca4-438dfb836426	a86d4029-491e-31f5-ca7d-438dfb99e55e	9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:29:55	0
af6d96dc-e9f9-8fcf-ee9c-438dfb761c9c	aca09f9e-fb06-1c6d-d2e3-438dfb942a95	9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:29:55	0
b3a83f5a-1e1e-2ef2-58ce-438dfb4dc8ce	b0ce1c07-f10f-bd56-75b7-438dfb06d6fd	9db6a39c-455b-fadf-14fc-438dfbc0db37	2005-11-30 19:29:56	0
c8183b8c-f42b-957e-c38f-438dfbd249d6	c540716c-81e4-bdc0-eeda-438dfbbc7a3f	c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:29:56	0
cf95189a-0996-e513-3a7a-438dfbe290c8	ccbe9ade-cc2a-1700-6eb6-438dfb5f1b7d	c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:29:56	0
d3e7f728-3810-dd0a-e96d-438dfba62025	d0f17825-c86f-bac0-4c4a-438dfb65bd72	c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:29:57	0
d848a565-9db7-d2d4-f869-438dfb0f4e3b	d56b1e80-9a06-b0a0-14c0-438dfbeb1134	c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:29:57	0
dc739346-c445-4610-45c8-438dfbb061ec	d9a30761-59c1-2151-b962-438dfbe35910	c3079592-c5b0-337e-fb81-438dfb1f4d67	2005-11-30 19:29:57	0
f1a67c6f-1c26-23c9-c2f3-438dfb394466	eeafa586-b14d-fa34-f56c-438dfb8c7890	ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:29:58	0
1db50613-a5b1-ccef-0143-438dfb8c0000	f313aecf-0bae-c26b-a562-438dfba2ce67	ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:29:58	0
64da0802-2242-c768-c515-438dfb2949de	34fe0d60-3650-5e38-d264-438dfb9e0b05	ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:29:58	0
ab020520-12f1-6c85-b2b5-438dfbadba4b	7bcf0b50-8fd4-cacf-8725-438dfb96817c	ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:29:59	0
f157062a-e9d8-c7fe-cabe-438dfb1dae3b	c1820054-7b32-3a56-e4c0-438dfb605c21	ec2865f0-7fd3-5787-0dd7-438dfb089a43	2005-11-30 19:29:59	0
2450a125-d6ed-d81e-24cc-438dfbe3bcc7	21595710-4ffe-3c17-7aa4-438dfb592b5d	1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:30:00	0
28c356c2-58dd-6a0c-44a9-438dfb5e6a4a	25c8bffd-47d3-b684-35f2-438dfb977955	1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:30:00	0
2d1dfe86-c58b-0cb7-9097-438dfbd7771f	2a29c288-3ad8-e30e-2f46-438dfb162589	1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:30:00	0
3189c9eb-1c20-6ea1-6500-438dfbcedcaa	2e84d495-1dce-aa75-2116-438dfb9393dc	1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:30:01	0
3603287c-9a4a-f64a-1d47-438dfb42e87d	32ee9e88-dd67-b1d7-6ce5-438dfbec92f2	1f0b26f0-8865-637a-d591-438dfb700fb6	2005-11-30 19:30:01	0
53fae5b6-dfec-a5d0-45a7-438dfb1f8740	5100b0b7-a67c-2e78-2dd9-438dfb0c8551	4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:30:01	0
5be90b9e-79d4-f1ed-7384-438dfb092dfe	58f55756-7374-82a3-4d4d-438dfb015892	4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:30:02	0
6048ec95-b271-73a7-10b4-438dfb8456da	5d563602-9996-5f44-dcf8-438dfbc3c6d6	4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:30:02	0
64a0eb13-8fa7-4293-f372-438dfb5d938c	61b334c9-c62f-7500-6845-438dfbbe7285	4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:30:02	0
6c80a927-e749-fb8b-f8ce-438dfb747332	6989aa96-f7b2-02a8-5806-438dfb2c4725	4e6a1409-2212-5aed-c99a-438dfbc0fb95	2005-11-30 19:30:03	0
815e26cf-db5a-5567-7cd1-438dfbc6a3e0	7e8301c5-2103-4454-a9f2-438dfbcaf74e	7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:30:03	0
859a88f1-4ef2-6de4-b5e9-438dfb722125	82ca9c6f-686f-a5f6-d09a-438dfb413d58	7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:30:04	0
89d2e165-3ff5-3398-8d6f-438dfbda758a	86fc3565-93f5-988c-2008-438dfbea3e7d	7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:30:04	0
8e05bf44-f287-6bfc-8c39-438dfb350887	8b35ad7a-0f13-9ece-a773-438dfb818405	7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:30:05	0
9240dc96-d59e-5d6a-3eb0-438dfb0ce9e5	8f726de7-4468-c6be-9dda-438dfb24f6e1	7c317fbb-51fd-244f-8ff5-438dfbda1e29	2005-11-30 19:30:05	0
a6dda781-cdc9-72ee-cbad-438dfbb35d81	a3fdda78-b6a1-ce29-675f-438dfb927604	a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:30:05	0
ab1b391f-8032-8713-55aa-438dfb891306	a8415bf1-f75b-9a74-2c1a-438dfb84a689	a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:30:05	0
af4e3b2c-7bec-b0d5-4cc0-438dfbd77640	ac7ebbab-66d8-7e2c-5236-438dfb053689	a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:30:06	0
b38bfab2-8007-3a8c-be9f-438dfbf7b1aa	b0b79a73-de32-4acd-6285-438dfb7b6dd1	a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:30:06	0
b7b5ebc5-559c-858c-095e-438dfbdef79c	b4e7442b-3959-482b-d82e-438dfba8ae60	a1c6dd10-a511-f5a4-587a-438dfbdf1f11	2005-11-30 19:30:07	0
cc386f2e-e91f-5f14-bfcd-438dfbe81981	c960c7ef-2ba4-07b3-1635-438dfbc173c5	c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:30:07	0
d074085f-afd0-34ca-b5f5-438dfb920dd6	cda09d33-b99b-0350-2a9c-438dfba4f925	c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:30:07	0
d85b774a-e2a5-40c4-5071-438dfb20c4e6	d57e04e5-1583-8fc3-7d60-438dfb8a4cfd	c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:30:07	0
dc8b860c-c03e-e607-b51d-438dfb2a92f6	d9bc3305-fad7-45cf-f646-438dfb98bfe0	c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:30:08	0
e0b7c184-3ae5-a7ef-08c0-438dfba3d810	ddea49b4-9372-8f82-0cca-438dfbbbcfb7	c71a05f0-4fb4-6db9-4c75-438dfbe2017c	2005-11-30 19:30:08	0
13a40fec-e81e-6d72-6cd2-438dfbeb1006	f284f535-30d3-e60a-1d96-438dfbe3fabd	f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:30:08	0
576d0ecc-9e10-ca05-ffc9-438dfbc84da9	29c50b4d-2e07-a436-c33e-438dfbc5cb89	f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:30:09	0
9ba8042d-d2ab-5e7a-d55f-438dfb53cf42	6e1304c3-7c1b-81ee-9685-438dfbd1fdb9	f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:30:09	0
11c28bb2-ae9c-06fe-edc8-438dfbb9f32d	ed4d0a4f-ef46-1685-4777-438dfbf0293e	f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:30:09	0
15fa6df4-6ec7-f034-5acd-438dfbd0d21b	131f7ea8-dacb-c127-1feb-438dfbd6b0b3	f042e492-e8d1-80fc-4ec4-438dfbd0ae07	2005-11-30 19:30:10	0
2a7bb4ec-8d6c-62a5-033b-438dfbf53a94	27a03e44-38be-7b7f-b6a6-438dfb964d54	2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:30:10	0
2ebc1107-6ed1-2414-46f5-438dfbd80430	2bdd8a71-3fe9-2cab-e59b-438dfb14a449	2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:30:10	0
33029510-f3c7-c13b-036a-438dfba434d2	302b2b1b-ed50-fc6d-1582-438dfb90dfc1	2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:30:11	0
3763e091-d6b2-4a77-ae3e-438dfb693b41	346ce095-2fcf-dfc7-1885-438dfb39c466	2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:30:11	0
3f7115f3-d0fe-a5af-14b2-438dfb770bff	3c9195c6-1094-da3c-82e4-438dfbe47cf7	2563e2bf-1a07-5db9-d427-438dfbc75f46	2005-11-30 19:30:11	0
5612561b-09f8-6c9d-1e9b-438dfbe63683	5337e245-e711-2972-3263-438dfbb31c1e	50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:30:12	0
5a65e09f-4970-a836-6ab4-438dfb9d19c4	5795dacc-c797-6ffe-97fc-438dfb1863a3	50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:30:12	0
5ea1a2f1-3413-82d3-264f-438dfb4abfba	5bc89a90-7bef-fbf1-d47b-438dfb8cbfc1	50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:30:13	0
62d9630f-f6cd-57ee-024b-438dfbe55f82	600160b6-952d-b8aa-b84d-438dfb7b4ef2	50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:30:13	0
6704814f-34ba-2720-986a-438dfb3df3cd	643a9e39-46f8-92ef-1334-438dfb8e3c2e	50f7b948-3a23-e5b5-1e66-438dfb163203	2005-11-30 19:30:14	0
7d7610f7-5eb4-bfbd-02f4-438dfb9245fd	79c14961-0535-d3c9-6fc5-438dfbd38d96	76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:30:14	0
82f47ae9-2817-9243-5048-438dfb7f8c59	7f44adca-9381-3c02-5399-438dfb1123d7	76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:30:15	0
885d8acc-fb49-7a87-654c-438dfb53efe8	84b518fb-569b-8c15-5bdd-438dfb9988d4	76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:30:15	0
8dc09020-9c3e-b872-0645-438dfb54af2f	8a2bbc68-d40b-5f7c-a933-438dfbcf0631	76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:30:15	0
9321c274-a6d9-79d2-8118-438dfb098b11	8f885f8a-c710-30e3-c509-438dfb07e6d3	76982213-4d75-c8e7-b5ca-438dfb2db90c	2005-11-30 19:30:16	0
adbd83ef-deda-b7e5-b82c-438dfbc3bd49	aa23527f-34c5-165d-900d-438dfbe83a87	a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:30:16	0
b32e66e3-a58f-9e98-a3bd-438dfb634144	af845121-0f0f-f313-e3fb-438dfb2c13a2	a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:30:17	0
b8a774b3-f312-e453-a6da-438dfbdaa2af	b500ee92-3edc-e00d-39dc-438dfbc97c53	a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:30:17	0
be1a396e-1fae-743f-6f6a-438dfb542c06	ba7249de-5db9-b366-83ae-438dfbbe7890	a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:30:17	0
ce020b0b-51b6-9e20-9979-438dfb83336b	ca583770-70cc-6bce-f7e0-438dfb46ccaf	a7309360-0640-95cc-2e64-438dfb01fb7d	2005-11-30 19:30:18	0
e87b8883-8d83-f3ef-184f-438dfb399f34	e4d9f5cb-11ca-471b-e04b-438dfb48b319	e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:30:18	0
edf1c988-29c9-d839-821f-438dfb67e60a	ea4310b5-f17c-9707-31c8-438dfb9084b0	e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:30:19	0
f3566bbe-98b5-28d8-086f-438dfb409522	efad3b8c-52fd-5940-7428-438dfb46dc14	e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:30:19	0
49e90f28-5ec8-8507-915f-438dfbb0fbf0	f650064e-a474-b526-c96c-438dfb81a081	e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:30:20	0
a0dd072a-6169-f380-fd54-438dfbb03e7a	66cb0db8-ddc9-b15f-6d09-438dfb3e89e5	e1df2c79-f019-b562-ec1f-438dfb43bacd	2005-11-30 19:30:20	0
24748100-9a20-cdc7-bc6f-438dfb0432af	20c936b2-2920-ebbd-fcef-438dfb43c5ba	1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:30:21	0
29dbd1e0-bc2d-6e79-7293-438dfb8a2224	26475b61-dee1-160d-bb6e-438dfb662068	1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:30:21	0
2f5fe78f-59f6-e84a-7702-438dfbc7a8a9	2baafa22-56ad-f9f2-c790-438dfbaa6cc4	1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:30:22	0
34d933e9-3046-a671-cc98-438dfbe847d4	3124cb26-2ef2-79cd-0b38-438dfba17d95	1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:30:22	0
3a65081c-2c20-02c7-a6f1-438dfbadaf78	36962b91-ae7b-1e0b-7533-438dfb0f7740	1dd34cd8-e05b-bba4-9f20-438dfb753fea	2005-11-30 19:30:23	0
57713c5e-cb72-014d-da27-438dfb54e3ff	53c6ade4-2a9a-0f37-d34f-438dfbb4f3e9	50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:30:23	0
67f253a5-fbff-05f0-445a-438dfb6facfa	6447c320-0fdc-dc1a-3172-438dfbe9a093	50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:30:23	0
6d630a4a-35e9-2755-0155-438dfbf4e6ef	69b10cd9-bdc5-3137-b30a-438dfbc652bd	50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:30:24	0
72d67de0-1725-2016-967c-438dfb97be26	6f3c4abc-94e6-6374-241b-438dfb7f4207	50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:30:24	0
783e22b4-a050-16bb-14cb-438dfbcebd17	74a3cf33-4da1-04a4-1b65-438dfbb4bee3	50d94809-19f5-1791-2a4f-438dfb6fe4b3	2005-11-30 19:30:25	0
930572eb-39ff-e11c-8fb6-438dfb87ac31	8f52695a-4f55-e595-d0c1-438dfbee952a	8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:30:25	0
9e22f60b-d616-28cf-7f3f-438dfbf3a031	9a6ddacc-d5d9-c0b8-befc-438dfba06324	8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:30:25	0
a37e15a8-0faf-64f6-2a7a-438dfbaa06f4	9fe3338b-a98b-c37d-4430-438dfbd1e16e	8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:30:26	0
a8e5a735-2a03-76b4-4e20-438dfbc4c275	a5478d8b-085a-bc70-14e4-438dfb5322ba	8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:30:26	0
b99cb73f-8061-f1f8-2f6f-438dfbb9533b	b5f449e6-e42c-2cc4-a1a6-438dfb043bf6	8c588605-d9c6-92bf-0f2a-438dfbca1c6e	2005-11-30 19:30:27	0
d404ee79-019f-c07b-4e6b-438dfb1f476e	d04fb0fd-2ca6-657b-674c-438dfb88259c	cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:30:27	0
d9789689-90c2-91a3-b334-438dfb6d6586	d5d34392-7d59-83a4-28db-438dfb558a44	cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:30:28	0
deddd736-1b30-d451-1987-438dfb54cdbb	db3dde72-2a50-7f34-7f97-438dfbbe66f1	cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:30:28	0
e45bca1f-61fa-d399-6a43-438dfb017727	e0a61071-e12a-c0fb-abce-438dfbef7b54	cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:30:29	0
10cd0873-3057-c1b4-b4f1-438dfb0283e0	f197e8d0-9528-f12d-402a-438dfbdb28d8	cd68ff34-a6d3-4cea-0c89-438dfb0002b9	2005-11-30 19:30:29	0
1ba077bb-598f-74cd-7150-438dfb29f41c	17f4204d-3e44-be3f-31ad-438dfbd90823	14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:30:29	0
21104dcb-a11d-0d77-c432-438dfb5bc60b	1d688f4d-2e02-6518-3a70-438dfb6c8cce	14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:30:30	0
2683d4c7-0733-00c2-ec1f-438dfb902004	22e0d9e1-7ba2-fb5c-b8fb-438dfb5d02cb	14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:30:31	0
2be655c9-de85-12d5-dfa6-438dfb653daf	2844fa1a-31fc-51b5-0b17-438dfbebe16f	14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:30:31	0
314b9ca4-1ec1-6a19-a044-438dfbc51e79	2dae0186-2953-320b-9e98-438dfb3f74f2	14fd4f32-ae52-11da-ea20-438dfb1a3b6f	2005-11-30 19:30:32	0
4e32c6e4-b5ed-4ed5-d391-438dfba23bc0	485b9f87-ca22-79fb-0d2e-438dfb348f33	45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:30:32	0
5437af66-68fd-ed9e-e0d2-438dfbf9d0e1	508f0ec3-18e6-7b68-12a2-438dfba33ddc	45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:30:32	0
59b273e5-2d33-28ea-dfa8-438dfb9a45e5	55f9dc89-6874-e064-b637-438dfb3b55b5	45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:30:33	0
5f3ec0f0-e5cb-64f3-ed60-438dfb63316c	5b941b7b-0ce6-6ebb-ce5f-438dfb61614c	45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:30:33	0
649e11c0-0795-ea6b-a23f-438dfbb722ab	6102c001-4265-d545-bfd2-438dfbe4d720	45680339-ff5e-a956-fa01-438dfb131b0c	2005-11-30 19:30:33	0
7f5a889b-4169-95b8-067d-438dfb22eb65	7b8746c5-8dab-2967-c161-438dfb2a1435	789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:30:34	0
85273c9f-2483-85ec-eab4-438dfb8014e3	816332b6-76ba-f1de-59ae-438dfbb9d303	789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:30:34	0
8aa74002-34b1-1394-7b2d-438dfb822e18	86ee15a0-f962-7335-407c-438dfb3810a4	789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:30:35	0
90210bd5-e1e8-7675-6352-438dfbea46b9	8c74ebde-9aa5-b3ef-ee37-438dfb653bfb	789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:30:35	0
95782598-811c-12f3-4b90-438dfb37ca2c	91dffcb1-ac1d-d40d-7967-438dfbe6388a	789c02cf-28d5-d394-dac6-438dfb023cce	2005-11-30 19:30:36	0
afe1c7be-c35f-51ad-41a1-438dfbeee98d	ac42c7ae-7f19-a5b3-5377-438dfb20d527	a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:30:36	0
b5573e32-a841-356f-ee81-438dfb10f3ce	b1abe1dc-5e78-f6de-c1f5-438dfbc4c2f2	a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:30:37	0
bab9e9c0-a912-8bae-c4d1-438dfb8c530e	b72002d1-76c1-2cb2-3dfb-438dfbad2076	a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:30:37	0
c01c8a09-6db5-8a19-0ca6-438dfb79a37d	bc811392-f84a-f84f-3c58-438dfb998bb3	a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:30:37	0
c5790e55-0cff-39ec-aff9-438dfbb18b66	c1dd7806-a659-b5d0-ec97-438dfb7dce13	a95b68c7-137b-66ca-1967-438dfbbf8f6a	2005-11-30 19:30:38	0
dfd73d16-c11c-bcb3-7315-438dfb64f51a	dc3c0604-6353-92c3-0fca-438dfbcdc521	d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:30:38	0
f1df9033-bb77-7208-a43c-438dfbe7ae5b	ee267ac4-f0e2-ee0f-bcb4-438dfb1b1c68	d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:30:39	0
31c30a97-9490-1c85-63fd-438dfb1ed242	f3a17078-f040-1179-c29d-438dfb579f98	d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:30:39	0
88d60fb5-e4c9-85e4-6500-438dfbbc16f2	4e3f03dd-42a7-8fec-297d-438dfb7e44d6	d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:30:39	0
14239e6a-05d0-7ff4-a65a-438dfb671b91	108061bc-179c-c75f-390f-438dfbaef918	d9601cf0-443a-526d-c1af-438dfb6e61f2	2005-11-30 19:30:40	0
2ec58903-50c1-7f43-b5a1-438dfbc0ac1d	2b12d43b-2bc4-9a6f-70a6-438dfb94e4ca	282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:30:40	0
34437397-9ee9-163c-f027-438dfb4a7ba5	3091ef5e-386c-6648-8230-438dfb74e30f	282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:30:40	0
39d158d4-5b4b-7708-eea1-438dfb4aae7b	360acb13-e319-0bbe-3159-438dfbd6812d	282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:30:41	0
3f4b379e-489b-49bd-b0d1-438dfb174f6e	3b9df285-9d28-87fa-b353-438dfb5ffa56	282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:30:41	0
44b320b7-e297-b989-1967-438dfb31a282	410588bd-26f0-09d2-c9c8-438dfb2731ae	282c22f3-be7c-9755-4791-438dfbf88660	2005-11-30 19:30:42	0
61dbb4af-9bf3-18d1-86de-438dfbeb42ba	5e27caff-63b8-50ab-c4d1-438dfb9d903b	5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:30:42	0
6dbd2849-9e6b-4cc6-4676-438dfb646e4f	6a120f97-baf6-ed50-bb29-438dfb0f551d	5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:30:43	0
731d239a-9a8d-02a1-45a2-438dfb61f370	6f7b365a-bd97-1b19-0e42-438dfb6b80d1	5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:30:43	0
78829a06-e14e-c8ba-674b-438dfbfe8ecd	74e5a4d5-fe66-dca6-67e6-438dfbcd0b05	5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:30:43	0
7dda9bbb-bab9-165c-208e-438dfbe3518b	7a44a9a0-632d-e027-84f6-438dfb181317	5b21281d-97c7-e2c9-e9bc-438dfb5d341e	2005-11-30 19:30:44	0
98690f77-2a2f-1099-63d5-438dfbcc39ea	94c4cc43-023c-0445-78b8-438dfb4c9130	91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:30:44	0
9debbd5f-9467-c040-69ca-438dfb2814e3	9a3c9bfe-8a3a-b5fd-0e62-438dfb944787	91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:30:44	0
a343d1f7-d852-803f-b216-438dfb036059	9fa8da5c-2bba-a2c2-6682-438dfbc8eeef	91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:30:45	0
a8b63b6e-94ec-92c9-d58a-438dfb407475	a5052eea-0671-a519-1240-438dfb9521ea	91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:30:45	0
ae19eecf-fd44-3985-f6df-438dfb54fc48	aa7344eb-872f-4b53-9632-438dfb7090a1	91dfc12a-3ad7-1830-ec75-438dfbd5a084	2005-11-30 19:30:46	0
c86576fe-4d4a-6538-22ad-438dfbbf9be1	c4bee1b8-c7b6-973c-8273-438dfb3348b5	c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:30:46	0
cdda66b3-f0aa-0141-2311-438dfbc629dd	ca39803e-2379-3b0c-f2f7-438dfb81ca90	c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:30:46	0
d345562a-81d7-430a-1e0e-438dfb3f5bef	cf9baaf7-9213-7062-16d1-438dfbadbc57	c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:30:47	0
d8aa6827-ca9e-8191-ed44-438dfb68a8d4	d507b193-0673-68f9-fb34-438dfb53db43	c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:30:47	0
de0146c8-94f6-29c0-b213-438dfb9a28f2	da6d73f4-bc9d-49f7-7ab8-438dfb78bb7c	c1d693f0-0e67-c6e7-1b94-438dfb1fb102	2005-11-30 19:30:48	0
44f20972-6862-aab5-696e-438dfb4ca4ee	ae4000c4-4f48-1b74-590c-438dfbe81dd0	f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:30:48	0
16f22fba-af13-1835-872b-438dfbc9eefe	133ef73d-0121-48c0-d740-438dfb30aa11	f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:30:48	0
1c632986-3019-b971-e399-438dfbbbfca1	18bcb251-0914-48aa-7755-438dfb59e29b	f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:30:49	0
21df0139-2f22-d188-1c08-438dfb024930	1e33a80e-d953-62b9-6ee2-438dfbfb1e50	f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:30:49	0
275158a3-3b84-015f-1836-438dfb7e3cc7	23aaf7bd-35ac-e52f-2331-438dfb8cb5c8	f1d85360-594a-7da8-d4d5-438dfb1d0846	2005-11-30 19:30:50	0
41d330cf-8176-e489-47de-438dfbde19a9	3e325445-88a6-45da-70a7-438dfbe67adb	3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:30:50	0
475542a7-2ac3-af5f-dd7a-438dfb8da31b	43a17ede-27c4-7985-5ec8-438dfbf6555e	3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:30:51	0
4f3fbab5-b771-82e7-3f83-438dfbb31c4a	4913c05c-48d1-95e8-8122-438dfbe3fe82	3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:30:51	0
54b0b67a-180e-bd57-1074-438dfba174bf	51117404-a560-326a-e29c-438dfba070c1	3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:30:51	0
5a15fcd3-1a5f-6588-e933-438dfbd6abe3	566dba07-e651-7795-123f-438dfb88ec4a	3b4f6477-a81d-c6ed-1cac-438dfb238ccf	2005-11-30 19:30:52	0
74c98fc0-817e-7cbe-2cd9-438dfb778679	711cb07d-151b-b6f4-37fc-438dfbc80604	6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:30:52	0
7a4b8e51-db8f-323a-12fd-438dfb0c61d3	76a28253-b192-d2e7-a525-438dfb8d1adc	6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:30:53	0
7faaa670-5b15-6b92-ab55-438dfb695635	7c0ea966-9062-3154-8907-438dfbe65ba6	6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:30:53	0
8c1b757b-3189-e569-eaaf-438dfb7f80c2	883a6767-d671-4d7b-f2c2-438dfbda2460	6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:30:53	0
91949e5c-b9aa-1a1f-96f9-438dfb5a7740	8de4568f-b5db-224e-b9cb-438dfb935403	6e233c2a-56ac-7b5b-7651-438dfb8fcb9e	2005-11-30 19:30:53	0
b30c6947-06e4-8f3b-cd1c-438dfb324b52	af6459e2-7564-2e12-dd97-438dfb4d1fef	ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:30:54	0
b8791e45-7b3b-56d1-5f2d-438dfbf4d5e8	b4d246c6-1d8f-a7b4-cf33-438dfb4bebdf	ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:30:54	0
c4c4b74d-fa11-5a0d-db2e-438dfbe001dd	c1207c6d-0997-aece-ae1a-438dfbc05454	ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:30:54	0
ca3b80c5-578f-be89-f0d1-438dfbdf0779	c68f7428-442e-6266-6f7a-438dfb7748de	ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:30:55	0
cfafd8da-3d36-4454-f0a3-438dfba8d510	cc059b20-17c6-7030-170b-438dfbd5e259	ac75ac3d-99ba-4688-6ab1-438dfbcae3c6	2005-11-30 19:30:55	0
3da60db6-d7ca-d35d-f827-438dfb864985	3770055c-f56a-64d9-45e2-438dfbf23ee3	f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:30:55	0
97170c8d-4052-6262-53e9-438dfbd85210	5afe016b-8b54-b907-3cc2-438dfb14f249	f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:30:56	0
15e41ada-31f8-38fc-e1f9-438dfb32f4cb	12380b1d-9832-74a3-6e38-438dfb13f149	f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:30:56	0
1b5820fe-2f20-68f1-ff71-438dfb77ef2a	17b1c1f8-8885-71f1-5f25-438dfb7be93a	f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:30:57	0
20c51ad6-43af-17ce-66c2-438dfb50030c	1d176caf-cef4-2ada-ffec-438dfb4122ad	f154f522-1cdd-fdd4-ef3d-438dfb9d46f1	2005-11-30 19:30:57	0
424ee342-e296-2de8-62b4-438dfb910896	3ea6ca27-3ab1-f34b-9204-438dfbf43927	3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:30:57	0
47bb1873-9b45-5b60-097a-438dfb622bc3	440e84ee-2dd3-6b31-4c36-438dfbd2960d	3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:30:58	0
4fa3214f-92b9-7705-6957-438dfb67d638	497e3526-9e0b-b6af-e95d-438dfb5192f5	3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:30:58	0
55719aef-0d8b-5303-1c10-438dfbbeae57	51c7061e-af3d-ee7f-2d88-438dfbb5c160	3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:30:59	0
5ad30f8f-5069-c4fd-a5f3-438dfb7387bf	572c2be2-52f6-cf6b-3e89-438dfbaec7a4	3bc87d3b-43cb-efdf-efd1-438dfbcb8a22	2005-11-30 19:30:59	0
757c1069-a132-8853-c4ad-438dfb8def9b	71d6875c-61fc-f8db-0b38-438dfbee6c91	6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:30:59	0
7af1ff24-11e3-4413-2c43-438dfbee09e1	77433902-c5d8-acf4-1582-438dfb29135c	6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:31:00	0
804def62-92b3-2f8b-1fff-438dfb43c285	7cb0d67d-b3c4-de16-8b52-438dfb8ef153	6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:31:00	0
85bab2e3-63f7-abec-e595-438dfbac1401	821eed7d-9a1f-3915-c88b-438dfbe97f80	6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:31:00	0
925d377d-338f-b42f-4efc-438dfb4f0c48	8ea6a56e-c2ed-32f6-09bd-438dfb230f88	6ee7d92a-216a-95bc-3cbb-438dfb280b1c	2005-11-30 19:31:01	0
acbfcbb0-3198-e89c-68c4-438dfb9c7621	a9226504-5f6b-dfce-3e3f-438dfbb0c23d	a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:31:01	0
b9620e3c-2982-86de-19a6-438dfb07ebb1	b5cc4a3e-c714-3459-351d-438dfb6816ef	a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:31:02	0
bed79aa8-2b26-8ec8-d54a-438dfb3c1d96	bb2ed77d-d473-62d6-6073-438dfbe4b365	a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:31:02	0
c43cbf5b-abc4-9892-8af9-438dfb937c3b	c098a9cd-0199-6085-7f3c-438dfb6d0020	a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:31:03	0
c99c649a-0b2a-94b1-79fa-438dfb0d4175	c5fa71c6-2486-380e-396e-438dfb7b58b3	a63a0010-23ef-efac-92d7-438dfb61e338	2005-11-30 19:31:03	0
e3e992db-ae97-3aca-866c-438dfbf0e445	e041cb03-bb91-1bdf-0d76-438dfb3b04a5	dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:31:03	0
e974457d-c3ab-cec6-2074-438dfb4cf442	e5b3ceae-0316-a6b4-6214-438dfb6e4aa4	dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:31:04	0
210a0c5d-a822-061a-ed21-438dfb5698b4	f29b52fd-3b16-49af-5afe-438dfbd66362	dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:31:04	0
774e0079-9d93-0aba-0a01-438dfb66f6c8	3de50308-a256-0866-70f6-438dfb758a55	dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:31:05	0
cf1f02c0-fd8d-d754-a762-438dfbdd1aa2	95170066-4475-11fb-eec6-438dfb74f640	dd602b0b-cf10-4d7b-a6dc-438dfb4b4355	2005-11-30 19:31:05	0
288c7ebd-bef0-c8e3-ac86-438dfb5f6e1c	24e579a0-dc45-97f5-4968-438dfb07f8ad	2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:31:05	0
2df4af73-820e-6de5-0d9c-438dfb20dcb8	2a4feef9-e46c-8cd9-1414-438dfba5a4b7	2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:31:06	0
3360c5be-33d0-94de-d680-438dfb3d930f	2fc364e8-3024-74cb-a001-438dfb4226e9	2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:31:06	0
39173bfc-1095-0923-c6bc-438dfba9d0ac	3529565e-e82e-60a2-98d0-438dfb153824	2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:31:07	0
3e7c6043-85df-d207-fd65-438dfbe27b7c	3ad523bd-d4c3-b4d9-6df6-438dfbb4ab79	2129c10e-0acb-645f-11b5-438dfb42e470	2005-11-30 19:31:07	0
5b7b4126-c4d6-9e8a-4336-438dfbb10975	57d7d204-5813-46cb-ebd0-438dfbfa1588	54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:31:07	0
61032dcc-f0b7-2a42-5da2-438dfbf4d0ef	5d47833e-1eba-7635-0402-438dfb9182bb	54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:31:08	0
666aaf2f-b672-e16c-b8b9-438dfb29265f	62ca9db4-4571-b349-766b-438dfb7f8bb3	54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:31:08	0
734cb88f-03e6-4934-cdf4-438dfb8d34ac	6fa5e0e6-579c-0ccb-295a-438dfbd806a5	54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:31:09	0
78b5375e-f747-451e-3e76-438dfb3ff580	750d25b9-0ef5-4ec6-964e-438dfb793825	54f75fe1-4a08-d273-3e6c-438dfbebf9b1	2005-11-30 19:31:09	0
9331ed1f-6987-37ef-3784-438dfbbe24a8	8f7966c0-7ddf-3c8f-2196-438dfb1a4fc4	8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:31:10	0
98a60f93-8e84-1117-ab96-438dfb83f077	94ff3004-9ca6-5d62-8d82-438dfb9d9631	8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:31:10	0
9e17983b-4c39-fc58-06c9-438dfbf009f6	9a69477b-4791-29fe-7005-438dfbfd2c99	8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:31:11	0
ab029de4-a8c2-d75c-b7e7-438dfbc20bf9	a75d48cc-607d-2d6f-e681-438dfba6e634	8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:31:11	0
b0692138-68f4-6ca6-db29-438dfb15977a	acc97207-b5de-0ec7-f3d8-438dfb36bceb	8c9213bf-2128-c0bb-fd39-438dfb6b788b	2005-11-30 19:31:12	0
caa19d67-54ec-1af0-98c7-438dfb061b8c	c7008c9b-97d8-4347-9405-438dfb6f2056	c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:31:12	0
d015f88d-6425-8c88-e983-438dfb9cabb8	cc750b4e-089a-6385-5b3a-438dfbcb2390	c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:31:12	0
d582aaeb-98cd-c7c8-56b3-438dfbf302df	d1db00b7-19e3-4315-609a-438dfbf8800f	c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:31:13	0
daf442b4-dab9-132a-331c-438dfbf22eff	d749f2a1-2bc6-d285-8ec9-438dfb0c97da	c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:31:13	0
ef9c80e6-673a-fc57-bd6b-438dfb78fec8	ebfb0c72-6208-bde1-a715-438dfb537535	c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c	2005-11-30 19:31:14	0
15e9db75-693b-47cb-df4a-438dfbf62655	12461b23-eed6-c499-8136-438dfb70f9ec	f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:31:14	0
231dbfac-8249-94ae-4d3c-438dfbb9ccc3	1f7c507f-3893-61bd-af25-438dfb38e3a2	f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:31:15	0
2897475f-88da-db1e-ab5c-438dfb899ab4	24e64e03-0498-2045-cc2d-438dfbad7479	f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:31:15	0
2df2e680-750d-e000-6261-438dfba67645	2a59fcd5-4678-fa79-9fae-438dfbbfec94	f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:31:16	0
336a370c-0472-1a95-907c-438dfb2d4129	2fc43d01-b844-37fe-b905-438dfb5fd491	f6870d09-d6c5-0cde-9d5c-438dfb898ff7	2005-11-30 19:31:16	0
58647d59-33a9-b9bd-7ce6-438dfbbb6ae6	54bb8ecf-8400-9af1-67f6-438dfb6ba962	51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:31:16	0
5dce09b5-b70b-2380-7afb-438dfbb7c702	5a2e8352-2d27-4c42-74c6-438dfbca3861	51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:31:17	0
6b215e83-91f2-7ac1-ccd3-438dfb96c282	67871b98-37b4-cc07-1b2b-438dfbd3e358	51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:31:17	0
7084dd20-ef1b-3a79-5b59-438dfbd4a85c	6ce83ef3-a968-b1da-dee3-438dfb63ac93	51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:31:17	0
761c5740-464b-c0d6-0a11-438dfb725919	727a7103-5c43-a06e-ed1a-438dfb078c39	51850727-7a19-5744-1bc2-438dfbc55957	2005-11-30 19:31:18	0
90d6ecf7-6645-3527-6e2f-438dfb00490b	8d1ae854-ba56-39a4-fcab-438dfb08d096	89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:31:18	0
96805806-20a3-f5a4-a1ef-438dfbdb2e26	92a49074-1013-7eaa-4a17-438dfbb348f3	89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:31:19	0
9c3f41ca-36dd-fc09-a4c0-438dfb48bb6d	984f6f5c-9957-be3f-706f-438dfbd3a490	89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:31:19	0
a9a3b7b8-405a-08d1-08d4-438dfb930450	a607da22-33f0-0194-4534-438dfb46fd16	89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:31:20	0
af0513c8-7823-1d03-7d03-438dfb904a44	ab5dc22b-e401-90cb-76f3-438dfbb80cf5	89f05f1d-00d1-f9ad-ed10-438dfbfa7346	2005-11-30 19:31:20	0
c9571fdf-33e7-0e88-bd1c-438dfbdd4d43	c5b1d427-eba8-8802-a425-438dfb3fd734	c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:31:20	0
ceba0eb7-f951-51d6-09f8-438dfb139a88	cb1d671a-276c-ff10-1f94-438dfb26c075	c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:31:21	0
d4417d2c-3cc4-2367-cc9d-438dfb1bc6b1	d08c542c-9152-3d73-5bf7-438dfb71681d	c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:31:21	0
d9a4ad65-b5ad-3b46-ef00-438dfbcfa197	d608cb5e-f1cf-e010-01be-438dfba3d66b	c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:31:22	0
df1277b5-4039-7b0b-5d0a-438dfb84e269	db693806-6d00-162e-b5d2-438dfbfbb5d9	c2ca1db8-72b2-aab3-1671-438dfb5b7b18	2005-11-30 19:31:22	0
541006d2-f834-c0b7-983e-438dfb7ce419	1a430840-e0f5-bbf6-0028-438dfbf4398d	f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:31:22	0
13378021-8fca-2cd9-f060-438dfb973a56	f1cc0405-1fa2-6d19-ac5d-438dfbfc461d	f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:31:23	0
18b9245d-0ac3-6bdf-ceec-438dfb37a1dc	14ffb377-b8eb-7d76-9d33-438dfbd78a6b	f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:31:23	0
1e282985-9da9-205f-eec7-438dfb967bc3	1a8d2ec4-765a-f2db-96f6-438dfb8a861b	f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:31:24	0
2394c8b4-4845-3cf4-d379-438dfb4d6172	1feae35e-7b87-9caf-c117-438dfbdf77b4	f2d60744-2eaf-0fad-53fc-438dfb112702	2005-11-30 19:31:24	0
3e199d23-dbaa-b665-b357-438dfb4206ff	3a6f6f88-9a89-35a4-5768-438dfb52a087	376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:31:25	0
4bc80688-a483-f14e-cc1b-438dfba662b6	4803cd29-9f07-1301-a601-438dfbe7e51d	376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:31:25	0
53ccd674-51cf-76a2-b7ac-438dfb6f451e	502c3e78-0185-0d3f-6bed-438dfb07c18e	376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:31:25	0
59421d7c-7519-9633-4e49-438dfb5dfbeb	558ffb6f-20b5-cca6-cac2-438dfba63902	376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:31:26	0
66ee0af8-c400-d228-5e5b-438dfb54133e	6359785c-7437-ee0b-bc67-438dfbbb33f9	376bf639-52df-9ade-ba53-438dfba662ea	2005-11-30 19:31:26	0
81686dab-0733-180b-094b-438dfb26c440	7dccdfc6-248c-aa2a-092b-438dfb22da34	7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:31:27	0
86c336b3-2b1e-d4be-2d67-438dfba63c44	832ce862-0684-1a54-ecd3-438dfbbbcb05	7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:31:27	0
8c3d3454-c3c1-5de1-f14f-438dfb581400	88910229-c312-99df-758b-438dfb251973	7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:31:28	0
91bf2c49-8bd9-a181-37d8-438dfbe041cf	8e06a677-91cd-d250-841d-438dfbf9dd29	7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:31:28	0
97309a19-d08f-8e8a-356a-438dfb67f661	93809479-2b41-b73e-0b56-438dfbd4f4d1	7ad7b724-722c-afde-9e26-438dfb765b79	2005-11-30 19:31:29	0
b1e5859e-0ea3-8ca8-2045-438dfb2f7a77	ae2fd334-a00c-181d-1cd2-438dfba3c899	ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:31:29	0
b74bd88e-6ee0-bcb8-b095-438dfb99e61b	b3ac3ab9-9f1e-2d11-22c6-438dfb28eeca	ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:31:30	0
bcc5954a-eac8-af7a-f1c4-438dfb23dcf2	b922d079-4dd9-81bd-d598-438dfbf532ae	ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:31:30	0
c22ef6b7-461d-a889-14ea-438dfb7842e9	be953a21-4e9f-974e-a542-438dfbf878e8	ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:31:30	0
c7a400e4-9455-9500-8142-438dfb2aa9fa	c3f32c00-9ca6-6e3d-dc8c-438dfb16c6f5	ab3f11d0-c24f-2a9c-84d1-438dfb1185e4	2005-11-30 19:31:31	0
e200df4e-853f-5ac9-a789-438dfb6856b0	de5b09d9-f085-c86a-95bd-438dfb68c0ac	db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:31:31	0
e76a38f1-2cb0-0394-c64a-438dfb38019a	e3c95ceb-10fe-7bc3-8453-438dfbe643c6	db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:31:32	0
12a20be1-66e9-7831-2e57-438dfbca618a	f1b0b43c-c4d1-fe22-ee00-438dfbe31b85	db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:31:32	0
6983053b-963f-0a00-9e93-438dfb75520e	2f170270-4c94-030e-79be-438dfbee47e3	db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:31:32	0
bf660404-2e00-9c3b-8d28-438dfbe5bbf5	855807eb-cf77-5894-8470-438dfb71de0e	db69fc79-b660-0433-6cd8-438dfb76b979	2005-11-30 19:31:33	0
267dd45e-7245-bd9f-d9be-438dfb426b0d	22c49343-3409-b964-b9a5-438dfb939094	1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:31:33	0
2bec1966-5abf-83a3-18e6-438dfbc362cc	2845943e-797a-439e-9a77-438dfbb3d671	1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:31:33	0
315ca6e3-5c49-00d2-ebe6-438dfb2cad29	2db09181-f3c1-d502-663e-438dfb022af5	1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:31:34	0
3f8553d8-d08e-5653-9c96-438dfb69a49d	3bce7a65-7551-9aa8-3960-438dfb13bac4	1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:31:34	0
44df34ae-dad6-fcf6-774c-438dfbef1084	41499524-94ef-f376-d582-438dfb5ab938	1fde64a0-ec9f-2527-1ea6-438dfb8a5d08	2005-11-30 19:31:35	0
73165259-ee30-22da-6b47-438dfbb73b2b	6f6b7c7f-e097-66c2-efd0-438dfbabcf89	6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:31:35	0
7889169f-13ec-401c-c69d-438dfb1a8a82	74e2983c-0b15-0b85-4cad-438dfbd77a1a	6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:31:36	0
7e0afd19-a947-943e-189e-438dfbe1702b	7a4fac88-c0a2-9fc2-55f6-438dfb17a3d1	6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:31:36	0
8374d293-a14c-949a-e110-438dfb4c3e12	7fcc0c6f-abf7-f60f-461a-438dfb28e5ce	6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:31:37	0
88d68b19-eff0-06c4-74e3-438dfba112a4	852c651f-14a3-9a20-bd0d-438dfb1db1d7	6c7b6081-0197-c017-49df-438dfb374396	2005-11-30 19:31:37	0
a43df0bc-61ad-71c5-c4de-438dfbc99fe5	a0715ec5-0fe7-e341-906a-438dfbc3c3aa	9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:31:37	0
aa0c18d6-8143-a502-8047-438dfbf0faa5	a627fc61-d50e-63a7-73f8-438dfb700f58	9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:31:38	0
afa0e62a-a513-dd7b-62dd-438dfbb65c3d	abdccf6f-cbae-71e4-67b8-438dfb1b1448	9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:31:38	0
bed30ee0-b2a3-8a6f-c036-438dfbb21bb8	badccd3a-795b-e531-dc5e-438dfb321313	9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:31:39	0
c4cd4c9a-6934-18c3-b53b-438dfbfa08b3	c126f022-faab-d781-3adf-438dfb531c47	9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f	2005-11-30 19:31:39	0
e16e02aa-c230-8182-38dd-438dfbadc4e4	ddcd5e1f-9a4f-d112-59a1-438dfbb6016c	dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:31:40	0
ef9b9716-bb0a-e80a-5369-438dfb694fe6	ebfe6ad0-403d-9cf1-86cf-438dfb6f56e5	dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:31:40	0
e9700cf0-a703-b68b-bd9c-438dfbea7ba3	f167f607-77de-f6b4-54fb-438dfbbea789	dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:31:41	0
6599019f-75ee-2ef0-5668-438dfb3c10ed	2bb20318-b883-b18f-9fab-438dfb246da9	dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:31:41	0
ba490165-9be1-48fb-8367-438dfbbe060b	813b0eac-0e60-f770-0a60-438dfb4613b2	dadf62da-b669-bdae-9db7-438dfbf0a9cf	2005-11-30 19:31:42	0
260af8f8-e4b5-6ef5-4563-438dfb081a1b	226c9e0c-8d05-0347-2f84-438dfbb3b25a	1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:31:42	0
2b98d4a4-fa38-8daa-9fca-438dfbf4e358	27e38aa1-58b6-fcba-0dbb-438dfb26d380	1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:31:43	0
30fdd3fc-4e4b-edb5-7834-438dfbfbf2f1	2d53c818-8403-a04f-ed93-438dfbbe7028	1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:31:43	0
3670a432-d544-8226-35c4-438dfb17c689	32c3b731-b2e8-9574-6894-438dfb7ae0d8	1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:31:44	0
3bf66647-bcfa-9265-eecb-438dfbffdd1d	38373f33-e838-155c-9488-438dfb651a4d	1f8456e5-21d4-6023-8d8b-438dfb7d19c8	2005-11-30 19:31:44	0
58f4a95a-1748-b8e9-0c67-438dfb81bca9	5548eb61-403c-454c-29f0-438dfbcb0bc5	525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:31:44	0
67a0ddf6-eed0-0da6-90b1-438dfb9e8cdd	63ce33fb-6008-6865-ab52-438dfb541c2b	525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:31:45	0
6d4912a5-bcef-5a0a-4271-438dfb8e93c7	698d9736-db0f-aa97-bf1e-438dfb9d462e	525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:31:45	0
72e78b27-54b5-cf58-5eae-438dfbaa74c2	6f157d2f-e341-795a-9b46-438dfbd14c07	525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:31:46	0
78684e00-fc75-26a7-9346-438dfb2d0eec	74ab09d4-feb2-e561-a73c-438dfb08264b	525a01b5-ce2d-6203-5892-438dfb7d2dcd	2005-11-30 19:31:46	0
93cb9391-541d-29fc-39db-438dfb0b9faa	9005bdee-cb01-90d8-81cf-438dfb8d1ebf	8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:31:46	0
99864146-fca3-56af-906e-438dfbee5b3d	95aaecc4-aa1f-3087-9b4f-438dfb735acb	8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:31:47	0
9f33a865-ec70-aafe-f17c-438dfb6999ab	9b5ef2b9-1579-10cd-6150-438dfb11cfae	8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:31:47	0
a4b37e05-aed1-fb43-0b46-438dfb0c0b42	a106fb13-75de-10a7-9d4d-438dfb00dedc	8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:31:48	0
aa375ba0-35b0-b697-f210-438dfbcc74db	a67a96b6-10e9-90f8-78b8-438dfb30c08b	8d1a8e12-42ae-5f8b-99ed-438dfbfefb98	2005-11-30 19:31:48	0
c52d6894-93ef-9e70-3c66-438dfbaaa513	c178dcd0-9ea8-5a23-0712-438dfb40287b	be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:31:48	0
cac1649a-de91-04d3-a226-438dfb33b8c5	c70b222b-2ff1-2f7d-05a3-438dfbecae7f	be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:31:49	0
d050a4d2-a295-9443-ab31-438dfbf697ff	cc8df24d-b48b-a050-dfff-438dfb2b4816	be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:31:49	0
d5ee58eb-a6ce-55bc-7478-438dfbe87808	d22f7353-8be9-05a9-90d3-438dfbee37b3	be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:31:49	0
db784de9-0f1a-8432-eafb-438dfb0c6c79	d7c08aec-5600-f0a4-acac-438dfbb7be2b	be84eeb2-3179-bc9f-19bb-438dfba25b6b	2005-11-30 19:31:50	0
24b60a4f-6bec-e086-634a-438dfb1eda83	f2af3978-5e89-5169-3507-438dfbff8f23	efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:31:50	0
1a726d5c-a4d1-b187-5545-438dfb822937	169dc02b-ac56-9b15-3714-438dfb049880	efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:31:50	0
200598e7-1f7f-a134-aab8-438dfb409ce5	1c3b65dc-5523-aa2a-2a15-438dfbc07e8e	efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:31:51	0
25896d11-82df-3d3a-67d7-438dfbd67228	21d502bc-372a-efd8-e0f1-438dfb40ec76	efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:31:51	0
346c3a7f-be92-7c5b-1ed2-438dfbabd5da	309b9c51-7c24-18c1-ffe6-438dfb6cbe99	efbc0b52-f58c-a29d-5701-438dfb69e717	2005-11-30 19:31:52	0
51ee5762-0cf2-49fd-685e-438dfb8b163b	4c0775af-d505-04c0-43bc-438dfb6da385	491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:31:52	0
57db4335-bd8d-704a-1729-438dfbff1189	5425a173-47b9-26e7-1447-438dfbae2dc7	491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:31:52	0
5d725aa1-83ac-4476-2340-438dfb50da2f	59acc06a-df0d-c655-a9c3-438dfb5d96f6	491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:31:53	0
62f805d6-fe4d-3da6-f751-438dfbfbd1f6	5f4a5671-49c9-79ce-15a2-438dfb7483ba	491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:31:53	0
84a6082a-c47c-54b7-70b4-438dfb10f3fa	80db391b-01ee-e832-7cbe-438dfbb94e1a	491bb8cb-9fa3-e979-3d0e-438dfb23148f	2005-11-30 19:31:54	0
9fa82bba-93b9-1de4-08fd-438dfbabf601	9bdacd9c-e01d-fa24-027f-438dfb0baa67	98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:31:54	0
a53644e0-325f-c522-1c1f-438dfbe642c4	a180194a-aa6b-e5d4-2c55-438dfb6683af	98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:31:54	0
aaf48f6e-1a49-3c11-e3a6-438dfbe59c58	a710af3e-a59e-fea7-aeb7-438dfb6636f8	98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:31:55	0
b07a1773-588c-8c46-244d-438dfb44329c	acc82ac9-1d48-6ba7-01c0-438dfbc38a3d	98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:31:55	0
b5fd5252-ca13-653b-eb71-438dfb871e8d	b24ef674-bc4e-e5c2-f840-438dfb6ba387	98e876e2-cf6d-9fcc-6d59-438dfb12781a	2005-11-30 19:31:56	0
d09bc20b-8b53-0fbc-7e15-438dfbf9ef50	cd005cbf-fb8c-0485-8f9b-438dfb5f15b8	c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:31:56	0
d5f387ce-d558-bcaf-2a04-438dfbf60959	d25e2b92-3b02-a04d-b321-438dfbe50538	c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:31:57	0
db5e727a-f466-0367-d7ac-438dfb55ccc5	d7c19f1b-d62e-b878-6e27-438dfb7f146a	c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:31:57	0
e0c592bc-6ce8-c199-4e22-438dfbefa6cb	dd35bf67-8359-3ab1-440f-438dfbcd61bc	c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:31:57	0
e622a9bb-6540-2e38-2471-438dfbfee041	e27edd09-7e72-15c0-01e7-438dfb5f2bc8	c9f9a26d-7f8a-ada3-5257-438dfbcd245e	2005-11-30 19:31:58	0
c6e2063a-0de8-b6f6-38a8-438dfbf94496	8cec02c9-6fcf-7a11-bfef-438dfb59834e	5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:31:58	0
1b72a794-2155-0163-a9bc-438dfbf94215	17ce08d2-8541-a0bc-db96-438dfb2e813e	5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:31:59	0
20ef75f7-0c16-6818-6084-438dfb51b4c6	1d3aa9a9-6625-2075-e434-438dfbbee9e8	5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:31:59	0
26586d0e-7763-cd87-c89e-438dfb2bdfb3	22b8e6d3-cffe-dbe9-a998-438dfbbcaffa	5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:32:00	0
355faf90-8b6b-a202-c57f-438dfb23fb0a	31c60f50-8dfc-183f-b5c6-438dfb9c1c86	5e3b05ab-1491-e073-63e8-438dfb5de624	2005-11-30 19:32:00	0
5294fb32-da8c-891b-1bb6-438dfb12a119	4c61d758-03ec-c3d6-ffc2-438dfbbf63d6	4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:32:00	0
57fe17d5-eeca-2860-3a56-438dfb2af9aa	546366ce-98ee-d28a-46d4-438dfb1c2acf	4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:32:01	0
5d603f96-76b5-c7f2-cae4-438dfb916b28	59bec305-021c-96b7-993b-438dfbfc5fb3	4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:32:01	0
62e6bb87-6422-13a0-a837-438dfb921425	5f213251-4ee6-f099-ae3b-438dfb5d41c4	4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:32:02	0
720ac3a9-eb99-15a1-c420-438dfb5fd23b	6e6decdc-5969-f649-3303-438dfbc97413	4969f1d8-0c9d-788f-62f6-438dfb89a07c	2005-11-30 19:32:02	0
8c7a0e45-d19c-ae2c-356d-438dfb6f2a4c	88bd7134-bdb0-6514-43c9-438dfbcc8f47	85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:32:03	0
9bc77d94-da9b-503e-36e9-438dfb2eaa50	981914dd-8bd6-b8b2-4860-438dfb0dec84	85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:32:03	0
a1ab2eed-101a-c050-3044-438dfb58b062	9de59822-6fd1-bd19-f61e-438dfbba4d8f	85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:32:04	0
a71edb70-14ec-e14d-e891-438dfb687093	a3760c17-bde1-a91f-5347-438dfb27e3c3	85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:32:04	0
ac78d7f1-31bc-f738-00b7-438dfbd5c604	a8e32e75-ce95-ec8b-2c2d-438dfb0dcfe4	85d65ddd-8632-09d9-f47f-438dfb6f4e9c	2005-11-30 19:32:04	0
c6c175ea-1862-da1c-df73-438dfbd18553	c313607d-4826-3260-7a43-438dfbfc1039	c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:32:05	0
d61bcdab-16cf-10bd-25d3-438dfbdaa941	d277de83-e4fe-1ff6-5714-438dfb68409d	c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:32:05	0
db8f55fa-3cc7-7b22-2520-438dfb69f97e	d7e93733-0f18-ff80-a866-438dfbadad91	c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:32:06	0
e0ed435c-693a-66e3-7480-438dfb43d0b4	dd5ba7e6-f1e0-62b0-9f8b-438dfbd63b03	c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:32:06	0
e650f617-687e-d208-7b37-438dfb709c57	e2aff9ac-0b6c-aec7-88ae-438dfb643088	c031e40c-7c5d-6e0b-1185-438dfb943437	2005-11-30 19:32:07	0
168217fd-469b-b255-a5d9-438dfb6d341b	12c77bd7-2edf-41f8-19dc-438dfbd9e746	fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:32:07	0
2755d9ac-cbd0-47c9-2606-438dfb832a2f	224d232d-1b91-8cf0-af35-438dfb863753	fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:32:08	0
2cc91101-c201-bd59-fcd9-438dfb14cc83	2916d0f6-0233-0e68-edd4-438dfb67b7bb	fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:32:08	0
3233392f-1525-8b86-9a50-438dfbbca0bb	2e90193f-9ea7-ed91-d45c-438dfb0f7560	fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:32:09	0
41b6b9c7-0d1d-b23d-87f5-438dfb62b7ad	3e0a9f88-0914-de2d-4d6f-438dfb21536a	fd9f0714-4cc5-16de-882f-438dfbb90a2d	2005-11-30 19:32:09	0
5ed9a956-f0b2-b3f4-7e11-438dfbb76ef5	5b2adbcc-6895-64da-1579-438dfbe4f12f	58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:32:10	0
646b2485-1d04-b846-279f-438dfb9681cc	60b0b2a0-1411-8549-dab2-438dfb6326c1	58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:32:10	0
69d7d61a-5cbe-6c2f-a239-438dfbd38903	663676bc-3465-2886-8788-438dfb11d08e	58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:32:10	0
6f3a7457-4ebd-13a8-8f8f-438dfb25f30d	6b97d2a6-e947-ec75-a401-438dfb620f0d	58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:32:11	0
74a2a5f0-43f2-1544-3dd7-438dfb54cc7c	70f9b11e-bde6-b3ed-ec18-438dfb69e525	58469e50-1f41-538f-1887-438dfbf47114	2005-11-30 19:32:11	0
8f49c229-b970-2225-c5af-438dfb4791d6	8b95f73c-aea5-0574-78c7-438dfb57729a	88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:32:12	0
94b2c124-1d3c-bf68-9bec-438dfba55fec	91105b71-8e76-41d7-d16d-438dfbe5ca32	88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:32:12	0
9a16c7c3-c96c-a5b3-3713-438dfb80c25d	9675665b-b3e7-6ffb-2ffb-438dfb9f784e	88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:32:13	0
9f84b4e6-2df7-7204-cd75-438dfb40d0d7	9be4f1b2-aa89-5062-dedd-438dfb5165b1	88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:32:13	0
b97677df-9ad9-66bc-fd5f-438dfb9d89b6	b5c7a873-4e9f-7e66-088d-438dfb9c6dbe	88a915af-39ff-75b6-8493-438dfb8c230c	2005-11-30 19:32:14	0
d40abccb-90fa-2094-3a84-438dfb653624	d048d3fa-0b6a-9bf3-66eb-438dfbb5f392	cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:32:14	0
d9995391-fb55-281f-2346-438dfb55d75d	d5dd70ca-b4b0-3e2a-c085-438dfb0ed6a7	cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:32:14	0
e931b802-d5d5-be73-06b3-438dfb4304cd	e59613e8-fd9f-4f9e-7d56-438dfbf4a87c	cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:32:15	0
ee9973b9-22a9-4734-3486-438dfb728e46	eaf2a1e3-3abd-cea5-f265-438dfbb56056	cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:32:15	0
f4115b8a-e2bd-45bb-93ad-438dfbf4d4b6	f06400f9-b5a6-8b6e-e51b-438dfb3bf43e	cd6049bd-74fc-b5d1-5eb3-438dfbd81e96	2005-11-30 19:32:15	0
24c62843-4cf1-c82d-c9da-438dfbaac070	21219d76-2870-1a9f-2ba5-438dfbcbd948	1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:32:16	0
2a236662-f10c-d6bb-9ac4-438dfbd70683	268bfc0d-5573-39fe-56b4-438dfb0d56bf	1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:32:16	0
2fa3bced-85f1-9d45-1332-438dfb7dbebb	2be6cad9-f282-95ae-a7eb-438dfb23cf6d	1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:32:17	0
351ae972-f099-7e17-84a4-438dfbca253a	3174449b-3ec8-2dd9-e079-438dfb660570	1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:32:17	0
3a82fb14-0bc1-ddef-5433-438dfba09064	36dfe4a5-2049-21dd-0ac1-438dfbf708c1	1e347806-aeec-67b7-cab2-438dfb351dff	2005-11-30 19:32:18	0
57a199d3-7664-c0db-c017-438dfb6b2d33	5403f00a-4532-cc2e-1242-438dfb3e2ad0	4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:32:18	0
678f4689-c2d9-a980-e806-438dfb589bd0	63dc3588-ddda-7838-05bb-438dfb65caa2	4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:32:18	0
6d00388c-b890-3c8d-1f56-438dfbde3330	694de210-0e01-26b5-4314-438dfb994589	4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:32:19	0
7259b6e7-8252-ead0-c8e0-438dfb3a4c52	6ec2c2cd-3267-d9da-a2bb-438dfb780901	4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:32:19	0
82424f62-93a1-143f-9247-438dfb5ee597	7e94c085-3062-4315-8b51-438dfbcda6be	4e66e474-6dde-7f87-b0d7-438dfb216074	2005-11-30 19:32:20	0
9cc89131-333c-4ab5-8ae5-438dfbd8c215	990ea6b4-2d1b-87e7-9c0e-438dfb545fcd	9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:32:20	0
a23f32db-f3e2-e7ba-27b2-438dfb8713bc	9e8f39ce-d89a-75ba-cf11-438dfb2de849	9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:32:20	0
a7ba0357-f864-c091-cc55-438dfb7f7836	a3fb7f88-bd34-0033-9a30-438dfbbbb95a	9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:32:21	0
ad1fa50a-38a6-c911-30cd-438dfbbf1f46	a985d137-f439-d800-e27f-438dfb0dee41	9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:32:21	0
b27b4f4b-b884-a8f6-b63c-438dfb0395fb	aee1b730-ca95-7c03-3130-438dfb7cb5f2	9626413b-867f-30ae-432f-438dfbf756c4	2005-11-30 19:32:22	0
cce13343-d023-769e-ef57-438dfb66ffc4	c932b640-ea08-d9de-96ae-438dfbd89f9e	c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:32:22	0
d253e890-021c-81fd-8e64-438dfb5dc99b	ceba3b84-41a7-ffd9-bec2-438dfbe68b7b	c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:32:23	0
d7af62d2-17c7-8787-bc60-438dfb5a6cc7	d4154a5c-fd2a-3ccd-3700-438dfbe50056	c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:32:23	0
dd2693a5-a1b0-81ba-e4af-438dfb0335db	d981800d-9735-c3e1-f914-438dfbab5e08	c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:32:24	0
e28f1fe3-be5a-3071-7825-438dfbee9f74	deebdf99-7539-4695-1171-438dfbd10295	c64c35eb-a23d-9f87-b108-438dfb9c6d90	2005-11-30 19:32:24	0
8e5a0225-4117-81dd-74f6-438dfb569f3a	531b01bb-7ba1-fffb-863e-438dfbe6f042	246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:32:25	0
e55d04f4-5221-59aa-2e74-438dfba9acf4	ab0c0ffb-cf06-2f0e-babf-438dfb5bdd48	246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:32:25	0
13b49937-661d-bd11-227a-438dfb88cd43	101904fb-11ca-4da0-c8b6-438dfb7ab976	246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:32:25	0
2f1ef45c-1a41-52f4-12f0-438dfb2033f8	2b6b3672-d781-8e5b-3ce8-438dfb730749	246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:32:26	0
34905b36-460f-87a4-b9c0-438dfbfa4979	30f393c4-f161-6869-ce57-438dfb24609c	246c06f3-95cd-ae33-9d0c-438dfb0edc32	2005-11-30 19:32:26	0
721462be-1b0b-fb9e-6554-438dfb5a8458	6e3d8d7e-9eea-cf79-3100-438dfb5d1b5c	60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:32:27	0
77870c25-9a10-3945-4095-438dfbcc3edc	73da3010-2987-0175-40f7-438dfbf57ee9	60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:32:27	0
7cf89654-f819-66e8-ec95-438dfbbd21d4	7959b58f-9e4e-9e9a-cef3-438dfb73af29	60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:32:27	0
8d447e3f-820a-b4db-8d53-438dfb2f1dac	89a1b837-8296-cf09-f666-438dfb5f987d	60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:32:27	0
92ae1e09-deae-908f-693e-438dfb649cda	8f05c1d5-fc57-f3cf-dcfa-438dfbce6377	60a548ab-9be6-abaf-60b7-438dfb019948	2005-11-30 19:32:28	0
ad21996d-0560-81e9-8a30-438dfb1f34b1	a973b3f6-f313-43b6-6b90-438dfbdc96a3	a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:32:28	0
b28e72cd-dff9-a3fb-f54e-438dfb8d0c67	aef3aaeb-112a-8234-7324-438dfbb7db4c	a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:32:29	0
b7f53e86-5b2e-802e-679b-438dfbf8dbbc	b452965f-d179-5254-621e-438dfbf6968b	a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:32:29	0
bd4be484-6ffa-c5af-d574-438dfbdcb4a7	b9b92b5a-5631-9d4c-40f1-438dfb8fb018	a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:32:30	0
cdac4234-193f-34a0-c926-438dfb7dc323	ca0f6bbb-3943-96d6-3abe-438dfb8332b0	a68c98c0-4ad9-f9d5-763e-438dfb7b0059	2005-11-30 19:32:30	0
e82cea85-aca0-76b8-8cf2-438dfbb5c7e4	e485bb9f-f049-26b8-0f17-438dfb87c60a	e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:32:30	0
ed9fe976-fea9-9d7a-e342-438dfb740315	ea037cca-1f19-c703-15b7-438dfbfb46f2	e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:32:31	0
f3195e90-cb29-7f98-f374-438dfb90ec33	ef6b1a16-7ae0-72fc-83ca-438dfb4ee5cd	e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:32:31	0
45c106d7-a1bf-d208-31b0-438dfb683024	c4100679-e5f0-7016-0be8-438dfb4a3eee	e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:32:32	0
9b030217-999e-e4e5-f7dd-438dfbe17b77	61740702-da1d-6210-ecbc-438dfb24e38f	e1980070-bbae-c220-1f68-438dfb8a1752	2005-11-30 19:32:32	0
2f261fb9-fbe0-000e-87d5-438dfbb74fdc	2b7ec24c-e125-a1e0-2a32-438dfbad7fc7	2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:32:33	0
349bf2b2-1438-fa05-b2d7-438dfb006873	30fe414a-73f2-b5f3-4586-438dfb844954	2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:32:33	0
3a4c8e53-64da-70a8-4e5c-438dfbad71b7	3666096c-f7b8-525f-9e57-438dfb0dbfea	2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:32:34	0
3fdf3be0-2dfd-8529-c591-438dfbf452d6	3c31cf4b-9570-6bbd-4979-438dfb4245da	2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:32:34	0
52f031f2-ff2c-f6ed-8e06-438dfb27bb20	4cb32f99-e851-3240-4dc8-438dfbc5340d	2895b03d-cb51-0cd3-9430-438dfb1b06da	2005-11-30 19:32:35	0
6d61d2c1-a8ca-71ea-7bbf-438dfb6462f2	69b0d387-ee38-9e23-94ee-438dfb077dfd	66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:32:35	0
72f2dcf2-6f2d-1f95-1c9d-438dfbef6abe	6f52c2da-4509-afb7-b26d-438dfb05f76e	66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:32:36	0
788cb2ec-6608-0d84-6abb-438dfbe51c4c	74c05468-b76d-228a-a828-438dfbfaca31	66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:32:36	0
7df3f06a-a18c-db0c-7a7b-438dfb09c044	7a5dc10b-0fdf-3180-ef95-438dfb7eb319	66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:32:37	0
8e9eeb15-ea77-0142-ad73-438dfbd07176	8b00b446-304c-7ce1-26f0-438dfb55fe94	66d00a03-e597-5517-a003-438dfb44736f	2005-11-30 19:32:37	0
a9640fec-eb74-bd17-0ddf-438dfbfbd9ba	a5a2d230-6f90-342a-ea75-438dfb2ef268	a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:32:38	0
aed3dfa1-4510-7d13-f1dd-438dfbb407b9	ab39d220-2695-5f92-3bfb-438dfbb0730e	a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:32:38	0
b43582e8-84db-2a68-6b0c-438dfb35054a	b09e3443-b5d9-638d-3f4d-438dfba206d6	a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:32:38	0
b9a183df-4789-9700-d5bc-438dfbe3f419	b601141c-0b96-ff09-c528-438dfb25fe6d	a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:32:39	0
d57ed772-9520-7798-0090-438dfba783d7	d1d78daa-d806-4350-7924-438dfba23c8c	a2776c86-3e80-10f5-2de4-438dfb23244f	2005-11-30 19:32:39	0
efdb7886-9fe8-077f-2508-438dfb4444a0	ec3f82c5-6d22-d479-eef1-438dfbaec13f	e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:32:39	0
12710cdc-7f47-fee2-2664-438dfb10e73c	f1aa16ca-08b5-a418-ac0a-438dfb0d84e8	e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:32:40	0
1d3c78ba-019f-bc55-bd2c-438dfba57127	198ad7c7-ff8c-e0c9-270a-438dfbcbc346	e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:32:40	0
22985d60-37bb-143b-2b73-438dfbda230a	1eff1da5-120e-2e69-2544-438dfbcd021b	e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:32:41	0
27ebb5b8-8826-bdc7-fa4e-438dfb2daec7	2457deaf-1fa1-62c5-d8b9-438dfb0e3d83	e9530c09-f5de-20b4-af8d-438dfb19709c	2005-11-30 19:32:41	0
428f8b27-e6f4-a119-b3da-438dfb2ba5ae	3ef2a9c8-a258-1085-84f1-438dfbf6af39	3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:32:42	0
47f60846-8ded-50cc-8070-438dfb45a09e	445b144f-60ca-2f86-610a-438dfb2b9478	3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:32:42	0
4d69b965-4468-75fb-9a8a-438dfb0cfe0c	49cc3658-e1c2-5acb-96cc-438dfbfeb698	3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:32:42	0
60cd7a63-e836-da6c-a441-438dfb8a33c7	5d22c40e-4ea0-f90a-a8d1-438dfb3e380e	3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:32:43	0
663a932c-c645-1ca2-c649-438dfbc5c8e7	62a19a51-fb61-2317-36e5-438dfb6b1208	3be5af30-4e43-3bb3-ea0e-438dfb1db842	2005-11-30 19:32:43	0
80cad438-3d5b-0fa0-7ef1-438dfb2cac97	7d2bf791-8867-fa0e-8497-438dfbbafc53	7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:32:44	0
863986d9-fc56-3506-f28b-438dfb0ab22a	82908d09-3f04-3f0b-5191-438dfbc53c42	7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:32:44	0
8b9fb8db-028b-8df6-1023-438dfb35e07d	87feed6d-4d6a-7962-9cfe-438dfb50dd79	7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:32:45	0
91089cd6-606f-47e1-534b-438dfb7ceff3	8d6e1a9f-12da-2ee0-5a26-438dfb7aae7c	7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:32:45	0
adfb7052-c232-f57d-6f80-438dfb3e9c4e	aa2cea6e-48f4-d0a5-1bf1-438dfb026ddf	7a40535d-16bc-7148-7e8e-438dfbd13045	2005-11-30 19:32:46	0
c87c244b-5969-6a14-b695-438dfbb3229b	c4d1c2fd-cbbc-aa2c-894f-438dfbc726bb	c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:32:46	0
cdda3d6b-4f34-847c-eb6b-438dfb1b861b	ca3fbe76-6075-5f3f-e672-438dfbfa1be9	c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:32:47	0
d33b3fa5-5be4-ee1e-b53f-438dfb9f59cd	cfa0c944-8e93-d025-99e1-438dfb5431ee	c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:32:47	0
d8b338d1-fe0e-d8c4-13eb-438dfb14f7d0	d50b8e80-f9dc-2517-a46e-438dfbd8e229	c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:32:48	0
de1a5cee-bddb-021f-540d-438dfb047db5	da7eb321-f866-eb32-c776-438dfbe4b631	c1dfef1c-954e-f743-4420-438dfbf77140	2005-11-30 19:32:48	0
46280ec8-33f7-c8f6-458b-438dfb9c2eb2	c6f00022-dbf9-a4d8-c085-438dfb22da9a	f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:32:49	0
9dad0a25-e699-92b4-33ab-438dfb43764d	638d0c7b-14dd-a879-65b4-438dfbd0bf6b	f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:32:49	0
f48c0efc-f15e-087e-2183-438dfb8fb2fe	b9d6054d-4ab2-145c-3c9a-438dfb09975f	f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:32:50	0
207b6633-2e54-377d-bc18-438dfbbb70c4	1cc5800d-494f-876f-4e12-438dfb710bd7	f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:32:50	0
25e0b465-293c-e353-372e-438dfb44e082	223a8f62-242a-7431-e6b4-438dfb8bfcef	f204b148-7344-8404-effe-438dfbd36480	2005-11-30 19:32:51	0
406b5aa4-79c1-06aa-58c4-438dfb62e5af	3ca0284a-2658-9423-6319-438dfb8d0c01	39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:32:51	0
5ffd4883-ae45-a82e-23cf-438dfbb2b971	5c50de0e-ea75-fafb-f4af-438dfb239734	39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:32:51	0
65563215-ffaf-652e-4bcb-438dfbdf2f2f	61be35c3-5443-bfbc-67a9-438dfb901e5d	39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:32:52	0
6ad02c04-99f4-b1d0-82e3-438dfb98a223	6728b251-f47e-30b7-9e46-438dfb32f4c9	39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:32:52	0
70411faf-e549-5cd9-b661-438dfb60bc6c	6c891529-44d6-820f-4061-438dfb7384a0	39b65b2c-1c46-a998-60d5-438dfbbf9075	2005-11-30 19:32:53	0
8b111130-333a-5c21-cdee-438dfbda56eb	875eed7f-d05b-3723-ae91-438dfbadc918	8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:32:53	0
909b9ed1-baa4-b918-a818-438dfb0280da	8ce3a403-3825-5782-3db5-438dfb54e2da	8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:32:53	0
961df630-561f-6ff4-32a5-438dfbef2871	9268c4db-c11d-11b7-015d-438dfb305f7e	8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:32:54	0
a76da0b9-da62-eee4-9db9-438dfbc4950d	a3c16b97-0975-52dc-f25f-438dfb36ab85	8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:32:54	0
acd82df4-779e-ea39-cc5f-438dfb68b68b	a9379de0-4fbb-ba47-b1d3-438dfbd908dd	8464a7b2-7bd4-225d-f11c-438dfb5e239a	2005-11-30 19:32:54	0
c74f78d5-8c7e-d80f-0fb8-438dfbe4fe22	c3b3328e-087b-4e1e-926c-438dfb83a0eb	c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:32:55	0
ccd48f02-cc84-3353-2a2f-438dfb15a196	c928e2a4-5cf8-9d38-4397-438dfb4b7d14	c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:32:56	0
d2324a7f-66ba-bbce-c318-438dfbc4323a	ce95465c-def0-a24c-a0e6-438dfb28fd16	c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:32:56	0
d7aedfda-52a6-fdd4-4879-438dfb320888	d3fa4887-ec2e-7d2d-2aaf-438dfbc1e6a3	c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:32:57	0
dd2d2a7f-aefe-61eb-a2e2-438dfb3a9d6e	d98a5620-3833-7a20-a012-438dfbb6d2ec	c0c97998-e5de-2fc8-e002-438dfb6708a1	2005-11-30 19:32:57	0
3564037c-dc21-ed2a-7909-438dfbbdbdc7	f3d0fe25-8d7c-cb82-9dc3-438dfbf1d388	f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:32:58	0
8c530dd4-1a6d-0eb3-7dc1-438dfb475f02	51e40541-0c10-1f7e-7c9f-438dfb07c526	f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:32:58	0
1a527cab-ca29-303a-cc57-438dfb315bdd	16a8b9f9-3a35-3ae6-ea14-438dfb5eb094	f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:32:59	0
1fce8291-64cb-45f0-0fd5-438dfb6deacd	1c2316a4-25f4-d6aa-1b89-438dfbe7f95a	f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:32:59	0
25262130-6511-805c-1782-438dfbe8e71c	218c02df-b3ae-9181-bb13-438dfbf46cb0	f0d414d6-6382-fbfc-3b0b-438dfbb822cd	2005-11-30 19:32:59	0
3fb370ac-b211-ffe6-96b8-438dfbec151c	3c016069-e292-e408-b4e8-438dfb4ee819	391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:33:00	0
53b57448-6271-1cbe-69fa-438dfb3b8b66	4d9f6928-7236-3542-c91e-438dfb765afd	391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:33:01	0
5975aa69-ef99-aaf3-9283-438dfbc597d6	55de0ab3-510b-774b-fbc1-438dfb9e3457	391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:33:01	0
7757900b-7e28-d64c-641e-438dfb8afa55	73a2eac1-0667-da5b-8413-438dfb7cf749	391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:33:01	0
7cbd77d1-c66a-15f8-79bc-438dfb5bb289	791f155d-7ff7-84f9-5d8b-438dfbc2e780	391d6e11-d566-07fe-aeda-438dfb5a9a5a	2005-11-30 19:33:02	0
97bcfd1a-6c79-b146-15b7-438dfb273174	94131d65-cce0-e132-43a6-438dfbc1bb02	912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:33:02	0
afb34735-a82d-d0a7-9657-438dfbd1d8dd	ac082612-a2c1-5e73-f4de-438dfb44b283	912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:33:02	0
b5595424-9801-018f-e20a-438dfb90cd4e	b1b5263e-4855-d36e-fe43-438dfb3c5a6d	912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:33:03	0
babdf1f5-533e-4af9-029a-438dfb7338d0	b724e237-dffe-b1c3-68de-438dfbe90596	912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:33:03	0
c95a3fb8-4c1c-2012-409d-438dfb6023b9	c5b75ac0-de3d-bb58-e703-438dfb176944	912be22c-c54f-1a32-4057-438dfb5574c0	2005-11-30 19:33:04	0
e3b84288-2f40-6811-3901-438dfb5d78ec	e0162b3a-cefd-cb50-befd-438dfb094e2a	dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:33:04	0
e928e0da-1e86-3f18-4447-438dfb38b6d1	e5823c1a-5a2d-0eda-015a-438dfbda95bd	dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:33:05	0
ee8bb0a1-a555-7ac2-b95c-438dfb28ca21	eae5be9c-f8ab-a4eb-6196-438dfb26b510	dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:33:05	0
f3f76ae3-2619-f0fa-9ea1-438dfbd8e593	f05b6022-0b86-f80e-3510-438dfbf39208	dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:33:06	0
52e20ee1-cc4f-2255-efb7-438dfbdb8e42	197f0319-d2bf-259f-d35f-438dfbf1e098	dd28e11e-db7f-ffe0-d6e7-438dfb1adce2	2005-11-30 19:33:06	0
1fa0cf2b-f5be-106a-25b9-438dfbcc94f2	1c0083a2-26c8-35d3-4638-438dfbb8589e	191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:33:06	0
2514651e-df42-041b-adfe-438dfbda96f3	21693980-7f46-5470-c8b1-438dfb29ce29	191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:33:07	0
36b7966e-b608-5889-5202-438dfb343e4f	33170baa-f734-cd60-08c3-438dfb7936c7	191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:33:07	0
3c304414-174e-3106-daf1-438dfb832d7e	3886fa6e-104f-4a37-ed21-438dfb1d763e	191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:33:08	0
41a50174-23f0-3b65-b4ed-438dfb47750e	3e1508fd-9a11-f6af-8fea-438dfb4cc2e0	191db721-4fb7-9a81-3a97-438dfbabdcca	2005-11-30 19:33:08	0
5f3a991f-5f41-6586-ecd2-438dfb3d5ff9	5b8d2147-4340-9ab4-57b1-438dfbd5248b	58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:33:08	0
64bb7d27-d9bf-8c7c-d5d5-438dfb4cc48b	61185cbf-384c-54e3-41c4-438dfb5d10ff	58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:33:09	0
6a1d1095-04bc-9d3a-21ab-438dfb0a3194	667cd5d4-5897-19c5-b6b7-438dfb10063e	58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:33:09	0
6f8393ad-0bf9-23ae-b455-438dfb77954e	6be931c7-5795-32b1-0453-438dfbb5f437	58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:33:10	0
75241e38-a35c-db80-606d-438dfba3db54	71776936-98c2-c9c5-bcfd-438dfb8ebe76	58a9b8fd-972b-dd40-72fe-438dfbdd00cf	2005-11-30 19:33:10	0
8f7ce2e9-f5ed-7fec-c2d9-438dfbb1e56c	8bcf4a59-d50d-e179-d826-438dfb358849	88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:33:11	0
adc8c06a-3b06-bed3-39c7-438dfb6b4ed2	aa1f240e-c63c-1e2f-8cbe-438dfb604a17	88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:33:11	0
b3375edc-9d53-fb94-2f53-438dfba9f96c	af91267b-a746-bcfe-af08-438dfba5aa0a	88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:33:12	0
b899d80a-6c90-41c0-3e43-438dfbed7100	b4f5fb07-2637-14f7-4f44-438dfb575f61	88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:33:12	0
bde7a21d-5c56-c80a-940e-438dfbe2f89a	ba564d9b-43ab-0a64-516a-438dfb8bff57	88e66abc-394e-4d0d-77c4-438dfb3b182d	2005-11-30 19:33:13	0
d8348323-4f3f-1c70-47c1-438dfb1932f3	d4959bae-ec25-9cf2-f61d-438dfb715973	d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:33:13	0
27fd0f71-c7e9-af96-161a-438dfbbc2ffd	f2fccaa0-89be-6c1f-5b67-438dfb1c2f5b	d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:33:13	0
7e1f07ce-ac2c-9398-d457-438dfb4653ec	442f0d1d-1f40-a36d-476f-438dfb2a6ef4	d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:33:14	0
d7540c65-28c6-64f1-a77f-438dfb81d3c1	9aac026a-3ba6-4da7-c912-438dfb8f1f92	d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:33:14	0
12cf7da2-4863-595c-e0b9-438dfb43ca95	f3690636-918c-d780-cb53-438dfbfe28db	d1bbf5c1-4c4e-b625-4cfc-438dfb623284	2005-11-30 19:33:15	0
47b8b2b9-f81d-3b84-5d5b-438dfba08e16	440c8310-639f-fade-9f23-438dfb859ab8	412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:33:15	0
4d391fcf-dc6c-a5da-f75a-438dfb94b80d	498dc040-c29f-45e1-0fcd-438dfb74d8db	412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:33:15	0
552cdc29-1813-c583-ea9d-438dfbf66d77	4ef6f61f-f6d4-218d-fe31-438dfbdae278	412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:33:16	0
5a88458c-eed3-bf13-00f9-438dfbcc4703	56f0cdb6-4793-c305-8168-438dfb44ad15	412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:33:16	0
794ff88a-181f-a869-2d4a-438dfb9de408	75a574da-1f32-ad6c-2bad-438dfbaf7319	412850a2-6620-056b-3a1c-438dfbaddca9	2005-11-30 19:33:17	0
93def599-0866-01f5-b040-438dfb9c59e4	901ca95f-a0b4-60e6-fdfd-438dfb59d9a6	8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:33:17	0
994abb16-23d2-6b96-81ef-438dfb6310d3	95ad2f63-2488-c475-1d3a-438dfbdc6f94	8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:33:17	0
ab7e03f6-8433-6d1f-ba5b-438dfbcbb3b4	a7c50744-2e9f-95bf-5196-438dfb472243	8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:33:18	0
b0f62848-cd6a-8d73-26a4-438dfb1d638b	ad482feb-9c4d-f870-b2f5-438dfba9ac2d	8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:33:18	0
b65793f2-c837-5b2c-e564-438dfb867314	b2b65a5c-0d5c-058b-8082-438dfb290773	8d39787d-9fe3-5566-b19b-438dfb80bd18	2005-11-30 19:33:19	0
d0be69d7-63d8-2330-6273-438dfb0b1b98	cd1abcac-0d7c-85ad-7fd9-438dfb1ddb96	ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:33:19	0
d61a9955-a7c2-9fde-e9ce-438dfb3703fb	d281bd2c-63ed-f716-c260-438dfb8cd76b	ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:33:19	0
db959ee6-7619-0fa5-c975-438dfbf994f0	d7e591d8-5901-3fe6-2b2f-438dfb3713a6	ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:33:20	0
e1024d4f-3346-f281-99f1-438dfb37c439	dd638fed-7e2e-19d8-fe29-438dfb881c08	ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:33:20	0
e6616d95-a675-9bad-ec16-438dfb00831d	e2cb8921-b6d7-166c-a830-438dfb30537e	ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c	2005-11-30 19:33:21	0
cb9c0d84-caf1-5047-eb88-438dfb7ae190	90b60f21-2c31-1726-6215-438dfb4413ac	62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:33:21	0
12261748-5a9b-d43d-f5ea-438dfb0d6b8e	e81c027c-37e5-bcc6-1285-438dfb3b1132	62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:33:22	0
178b9d91-3c2c-f47e-34fe-438dfb52cf8f	13eea549-5dde-8964-02c2-438dfb660651	62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:33:22	0
1cf0d025-90ac-423f-b793-438dfb6093da	1953149e-ddb1-9ff2-5f54-438dfbac7349	62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:33:22	0
2f5492ad-5d2b-7e37-6f4a-438dfbd7f5cd	2bac4b06-adc3-dc99-b8ee-438dfb44c5c9	62a10f63-f686-2144-15ac-438dfbead4e8	2005-11-30 19:33:23	0
4a1d6349-f43d-3ab2-d3d8-438dfbf84d8a	466ce8df-894d-f970-6d7a-438dfba80082	43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:33:23	0
4f7e94ee-fb65-2dd8-5af0-438dfba342d6	4be4fe39-2531-018d-04a3-438dfb4cd002	43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:33:23	0
5770169f-fe7a-cda9-bd18-438dfbfd7c73	513a4506-0a6a-0ed8-ef54-438dfb409435	43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:33:24	0
69d85594-4a47-319d-a134-438dfbe24bb2	663dc249-8e95-c322-148e-438dfb6cb564	43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:33:24	0
6f3f07b3-53ae-1a88-2ae8-438dfb2665c2	6b9797ca-33c5-aa44-446a-438dfbb0b9a3	43859232-da58-37c0-179b-438dfbdfa7d4	2005-11-30 19:33:25	0
97eba844-7917-4a9d-a543-438dfb6b8886	93c2d6e1-3df9-4b90-8b4c-438dfbc2a2b0	90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:33:25	0
9da00c92-30b7-f277-7cad-438dfb77f5b1	99cb395e-8b4e-8320-6d53-438dfb3499d6	90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:33:26	0
b0366fd4-3d0d-08c6-9cad-438dfbc29462	ac7cac8b-d597-f366-7216-438dfb60dd9c	90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:33:26	0
b60d9004-81ef-94f8-91dc-438dfbae118e	b24d979d-4357-939b-acdb-438dfb6c39fd	90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:33:27	0
bb95281a-967c-6599-8ce9-438dfb5abc37	b7d205bd-3410-7fbd-5649-438dfb783560	90c164b4-f97d-611f-6846-438dfbe89579	2005-11-30 19:33:27	0
d6b5fac8-995b-136e-f5c3-438dfba88c94	d2d83d31-82f4-f3bb-ff84-438dfb907999	cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:33:28	0
e9689ec0-9566-8e7f-4149-438dfb6ebf67	e5a5f62f-65b3-2dee-5605-438dfba7f9f8	cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:33:28	0
eee0e083-28e8-07d3-d14c-438dfb5573e6	eb2de631-bbe7-2957-3399-438dfb489850	cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:33:28	0
3d9009de-9975-7ad8-d4c2-438dfbbf9a83	f0b62c78-c9f4-e1c4-8aa4-438dfbca5154	cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:33:29	0
5b9002e5-d859-b40f-0c29-438dfbd64d41	20a40c0e-c3e0-7ed9-9f08-438dfb8e4b71	cfdf028a-db96-990d-3366-438dfb009b2b	2005-11-30 19:33:29	0
212fa544-d062-8836-301b-438dfbb58a87	1d12eb6e-972c-9bbf-a5dd-438dfb7ad4e3	1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:33:30	0
26c910e4-9865-ab9f-c2bd-438dfbc655d6	22ffbd37-26f8-4c0e-ca05-438dfba64d77	1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:33:31	0
397cb4b0-1fd5-5856-d527-438dfba59fae	35cb1b65-717e-bfae-51be-438dfbd12a18	1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:33:31	0
3f3149af-8c91-9c52-a5e8-438dfb4e998f	3b4f2884-5766-5656-2a3b-438dfbae21c4	1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:33:31	0
44ad6213-0ef8-bf82-9854-438dfb88b287	40fe6739-7396-7c9c-ecbc-438dfbd5a145	1a26322a-9d2e-13b9-edbd-438dfbdfd6c3	2005-11-30 19:33:32	0
62577704-0d15-3349-9937-438dfba248d6	5e8ad6e8-475e-3c36-0839-438dfb600d84	5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:33:32	0
67e4b151-2ab0-e283-4032-438dfbe7ca66	642f76ef-990b-7cd9-a0d3-438dfb39d1c9	5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:33:33	0
6d7f0bf8-e4a9-706e-8975-438dfb6f372e	69b13e69-871b-0fe0-3ca7-438dfb91d84c	5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:33:33	0
730c6081-46e9-9709-10df-438dfb02e55a	6f4de1b0-4c7d-c76b-cb26-438dfb7c4af8	5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:33:33	0
938b7099-df5c-ef70-cd91-438dfb3757a0	8fba24ea-17c5-807a-4702-438dfb23fbad	5b9936b0-c7c4-0429-bab3-438dfbf4127a	2005-11-30 19:33:34	0
aec40f37-9326-b1ac-8b9d-438dfbf69984	aae614a5-7c97-e3d0-b414-438dfb2f8582	a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:33:34	0
c1c53744-49fe-325e-334a-438dfbb6a43f	be06cb90-c0e5-972f-d8c3-438dfb1d8c90	a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:33:35	0
c75032d8-9c1b-b70d-e357-438dfba83a49	c39add06-f62e-43c6-71be-438dfbc0d2c2	a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:33:35	0
ccde9339-3d9b-46ba-6b13-438dfbb72fab	c91cf2fa-c11e-2c59-08a2-438dfba15f4f	a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:33:36	0
d26ec186-d744-c40a-c336-438dfb847061	cea07f70-1c48-7ce1-72df-438dfb329373	a7df6541-fb86-851e-c556-438dfbffa507	2005-11-30 19:33:36	0
ecfc1bdc-de38-65a1-e8c3-438dfb17f044	e95a124d-30b5-8c73-acf9-438dfb3ead4f	e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:33:37	0
f269b58c-330f-1766-a130-438dfba3a248	eec77567-955e-3e5e-760c-438dfb0408f7	e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:33:37	0
3d860935-42c1-8970-7680-438dfb9ce3b0	207000d6-7506-14c8-40da-438dfb12dcf4	e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:33:38	0
9301005d-dcd7-8d78-82fe-438dfb171ea8	59c90341-43fe-5299-7a34-438dfb3cebd6	e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:33:38	0
e92a0231-cbaf-4f7d-83c3-438dfb313802	aecd0c03-735a-307d-6148-438dfb42f745	e65b04ee-2054-ba82-f056-438dfb5fe583	2005-11-30 19:33:39	0
4438080c-72dd-811a-31a3-438dfb29ceb3	40890696-dd2f-f51b-13bc-438dfbc1504b	3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:33:39	0
49ab084a-16f5-752d-be4e-438dfb5a5c25	45fcf1f1-3025-07a7-0276-438dfb93a9aa	3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:33:40	0
4f0e5164-e58a-908e-4dc5-438dfbe31e75	4b704f2f-ada7-9bfa-2eb0-438dfb8b4d2f	3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:33:40	0
57195667-f5ad-2e8b-6d5e-438dfbd8b447	50da8e59-0db4-291d-9c19-438dfbe18d2f	3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:33:41	0
5c7616d8-1ec5-d3ad-0db2-438dfb9478df	58d610da-a59e-d807-a04a-438dfba2fb61	3d82526a-12c1-e7eb-ff5a-438dfb9a0629	2005-11-30 19:33:41	0
76ea4927-6c5d-2e3e-382a-438dfbbb1cf5	734eec38-eb1b-8dcd-90e8-438dfb24028a	705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:33:42	0
7c6ca094-c050-28d1-cb09-438dfb03ad9f	78bbc3d4-cf2d-8e8a-0e16-438dfb2b8d90	705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:33:42	0
81e27e91-2a08-4e3b-b126-438dfb91c10f	7e334e32-2ca2-3903-5bc7-438dfbb6edae	705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:33:43	0
87463e01-a69f-8b06-0ec0-438dfbcb04ca	83a54edc-1b8f-0e7c-b433-438dfbcfa4c6	705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:33:43	0
9bc60372-e8d2-bdc7-6ad2-438dfb63a235	971d6e47-0980-26ea-968e-438dfb8e8a97	705a8f06-80bf-e78d-8582-438dfb58ec6a	2005-11-30 19:33:44	0
b623d23c-a865-7667-e69d-438dfb155bbd	b28a6649-b987-08f7-dc98-438dfb0d7808	af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:33:44	0
bb8aa473-0764-a346-dd3b-438dfb3c15f8	b7f1782a-9284-2963-e3b9-438dfb44d630	af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:33:45	0
c0fa19b7-24bc-fd77-f094-438dfb3cbcb3	bd48b1ae-5d6c-f3c2-5bf9-438dfb644c7d	af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:33:45	0
c6669a70-80e1-aea2-04ec-438dfb404329	c2bde581-ef5e-1872-cddf-438dfb601d8d	af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:33:45	0
cbba1bfa-0fff-bebd-77fc-438dfb3c3a64	c821447a-28e4-8d89-d5c4-438dfb06ef31	af9c9eae-cfca-0408-c4f2-438dfb55cd6b	2005-11-30 19:33:46	0
e60fe07c-413f-e16f-99ea-438dfb2e7647	e2708d23-25a9-7e78-f3e9-438dfb4f0bdf	df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:33:47	0
eb85254d-e1fa-3367-b55c-438dfb8942d3	e7d71b0c-3ad8-69a9-0834-438dfb80d856	df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:33:47	0
186b474d-8895-e74a-c819-438dfbf46aad	14c71631-6e4c-8e78-c0bc-438dfb6f0574	df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:33:47	0
1de2903e-8c4f-10a2-a7c0-438dfb6f66c2	1a3ef112-cec7-6425-6690-438dfb3723a7	df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:33:48	0
2336fe11-4029-ba0b-af6d-438dfbcb1ff0	1fa39add-d687-384c-bf57-438dfb65f45d	df919b50-360a-55f5-6f51-438dfb61a3ac	2005-11-30 19:33:49	0
3da54648-8062-bcbe-73ca-438dfb428300	39f28ec1-63ec-8247-1e9c-438dfb3c86ad	37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:33:49	0
432c8119-7040-10c4-020c-438dfbcc5fe5	3f901325-e1e4-2dc3-f031-438dfbfbced9	37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:33:49	0
488dd488-612a-8f26-2e0a-438dfbaa37d1	44f562b9-cb3c-b381-e372-438dfbece7ca	37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:33:50	0
4deda7e7-6737-c209-7a6e-438dfb91d3d1	4a5a2462-c9e8-a2ba-83d1-438dfb78d2d7	37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:33:50	0
557334fd-f30e-0e9e-ea92-438dfbd9fe24	4fb034e3-bce2-2eb2-49ab-438dfb961dc5	37091701-70fe-f2c1-dc2c-438dfb343ec7	2005-11-30 19:33:51	0
70483453-86fa-96c2-6b6a-438dfbfce225	6c9186b4-742e-107f-abea-438dfbf77c2f	69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:33:52	0
75b010bb-ba03-64c0-aefb-438dfb5b2334	72173f66-cfd2-82a6-cf05-438dfb6af4b0	69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:33:52	0
7b25a3c3-f9cc-f151-2ba9-438dfb463a09	777b9f25-67f0-90d2-de28-438dfb71af82	69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:33:53	0
80afd31c-3bab-69c5-5d3d-438dfb58488b	7cfbfed5-29bd-822f-0522-438dfbb92c84	69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:33:53	0
861b9baa-95f9-cf78-d463-438dfb57c1a9	82761acc-fa0e-b905-e6fc-438dfb07d7e6	69aeff99-9dc1-cf5e-5779-438dfb158510	2005-11-30 19:33:54	0
bcb82128-af18-a6ed-436e-438dfb983d5d	b91196a2-1d52-a08c-6b09-438dfb32262e	b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:33:54	0
c279a3b8-d15e-292d-bb04-438dfb79fe0e	beaa5d06-0ba6-90f9-c960-438dfbfeb4ac	b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:33:55	0
c7e8ef93-5479-57d4-cb3f-438dfb61df42	c44ebda9-1086-8a76-a88f-438dfba85bf9	b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:33:55	0
cd4be123-eb00-1df0-4f0f-438dfbf4b477	c9aab20d-e4ae-cc3a-922f-438dfbf2a076	b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:33:56	0
e0e294f7-9c36-dc67-86f9-438dfb5b5a3b	dd348db7-2e1f-1815-f6d6-438dfb1a68c6	b6263370-2b26-8342-4c87-438dfbf377b4	2005-11-30 19:33:56	0
72070d6a-ea83-1843-0329-438dfb9c6846	37880b99-bdf9-a2af-16e7-438dfb50c3df	8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:33:57	0
c8630c51-3ee9-2910-05af-438dfbb883ce	8ee8098c-9b7a-f0c7-60e6-438dfbea5ea0	8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:33:57	0
11eaa482-deda-4ac0-54ff-438dfb600ae0	e41d076c-1343-bda9-a8cf-438dfb807527	8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:33:58	0
1756c5bb-9d5d-f14c-1521-438dfbe84625	13b475b8-5c99-91d0-ac3f-438dfb5386cb	8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:33:58	0
1cd57cbf-1bba-69be-7433-438dfb5a8de9	193495ca-10af-a462-6073-438dfb280208	8740019a-9ecc-2677-dbde-438dfb926b5d	2005-11-30 19:33:59	0
37256d9b-66da-0689-4044-438dfb93b1b2	33884963-9ff7-e04e-6063-438dfbc824ee	307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:33:59	0
3c8cd442-2f47-94cb-1457-438dfb3e3db0	38f4d028-33c2-4e74-e4e6-438dfb0ae9ed	307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:34:00	0
4246cd42-102b-84fc-fbb9-438dfbf64bd4	3e8d68df-4648-42af-e045-438dfb2f964e	307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:34:00	0
47a5007e-e334-eb4f-7a95-438dfb5ee10f	44103129-5c8a-453e-8403-438dfb1f9a07	307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:34:00	0
4d12b2cd-1ebd-f4c6-9729-438dfb3c7899	49706d47-1e1d-5fb8-ef7c-438dfb9a878f	307f2672-8234-c472-39de-438dfb0be0c0	2005-11-30 19:34:00	0
69f80f54-5d26-f648-ac8a-438dfb0ba332	66576f1a-5f37-89aa-1dff-438dfb11de7a	636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:34:01	0
6f709181-2610-2280-caf0-438dfb61b0da	6bc5730e-98f6-bffc-bea2-438dfb37870e	636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:34:02	0
74dcfc7f-2eb4-dd29-42f3-438dfb722e4b	7147daab-c6c7-7683-eb13-438dfb125e6b	636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:34:02	0
7a37338d-bf74-ef24-0b0a-438dfb72b81c	769e637c-4dc5-b814-c6ab-438dfbf0aa01	636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:34:02	0
7fa18e17-69a3-3f1a-49f1-438dfb29ae97	7bf87f77-d2e8-3716-63ab-438dfbe6302e	636d2d7c-fcec-c46a-5aaa-438dfb56c263	2005-11-30 19:34:03	0
9a3e477d-ce05-42b0-84c6-438dfb44cf17	969895e2-699c-b858-b25c-438dfb82bd6f	939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:34:03	0
9fb3f0f2-9123-522d-b94d-438dfbbffb24	9c0e86ea-188e-b38b-3f7a-438dfbe2bcb8	939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:34:04	0
a510a9e1-2a20-27a2-580b-438dfb364e5a	a17b48ff-c9a5-c4fa-24b2-438dfb20b096	939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:34:04	0
b90bc172-2e89-6146-0f0c-438dfba8c4cd	b55ce6eb-eca5-1057-e1c6-438dfb38d17a	939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:34:05	0
be8b5fdd-a4ff-3f9c-7aa9-438dfb0a128d	baf7f789-af42-af50-ea4a-438dfb8967c0	939e5fc5-2c88-2dc4-65fa-438dfbaaebd7	2005-11-30 19:34:05	0
d8f6856c-1c49-1fc5-5df7-438dfb3864ee	d558b168-8c87-0f66-476c-438dfbcc547c	d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:34:06	0
de5d8cf0-cc14-f5a7-e58e-438dfbfda828	dabd0b3e-1048-318b-a246-438dfb72eb86	d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:34:06	0
e3c6d397-00d7-0842-0659-438dfb7bc4e7	e02e53c5-beca-1e7f-4688-438dfbdd59ea	d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:34:07	0
3cbf0919-0c50-bb30-fbdf-438dfbb84961	94000ee0-9587-2d0e-4f9d-438dfbcb1556	d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:34:07	0
927b0cf9-4742-a312-ce80-438dfb6cb95f	590f00e7-9444-7400-1b95-438dfb1cd86b	d2700f13-40f4-fa17-c102-438dfb8eb5fb	2005-11-30 19:34:08	0
239a4ae0-bdc7-1159-7dc6-438dfbcf1450	1ffcfbf7-6e47-8993-5cf2-438dfb95e445	1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:34:08	0
29063b6b-1ac9-68c8-bc09-438dfbd6ba70	25652638-25d7-ac6a-235b-438dfbcc2e08	1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:34:09	0
2e6320b4-cdf1-bd61-cf0a-438dfb6ff8fc	2acd4547-5ad3-4f13-7dca-438dfb7358b5	1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:34:09	0
33e03331-5a32-5193-1eab-438dfb7f88f2	303c960c-e9a9-2a6f-96e2-438dfbda81f5	1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:34:10	0
39495c17-09d8-4b50-7ba3-438dfbcc2cf7	35a3f1cf-a31d-cd14-db0c-438dfb9c1f28	1d176643-bb13-0844-e661-438dfbdeeee9	2005-11-30 19:34:10	0
5663df8f-737e-4777-6b0d-438dfbcc9aae	502e45e3-4dce-77ee-8b2f-438dfb93e38c	4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:34:11	0
795c4813-1fd1-5a8b-1768-438dfbd43447	75bce689-2344-f07d-d39e-438dfbff67b7	4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:34:11	0
7ed1013a-364f-8394-f188-438dfbf4b596	7b3012a3-80b0-7763-c1bf-438dfbdb33f2	4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:34:12	0
843f1f39-006d-e653-e024-438dfb690b72	8096425d-ac0d-a718-5f09-438dfb99d2c7	4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:34:12	0
a77ba55c-9ba9-76c3-ddc1-438dfb96abc9	a3b26060-7919-e393-9eb3-438dfb0b05ba	4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7	2005-11-30 19:34:13	0
c82e4394-6667-acc8-3d0c-438dfb2e14e7	c47108a8-0e1c-00a4-499a-438dfb3b85d5	c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:34:13	0
cdad507e-1cf4-f4c2-ba07-438dfb9b2cd4	ca08253b-85b4-4f3c-6ace-438dfb08621c	c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:34:14	0
d32159ae-4e46-866a-0ec8-438dfbc362ef	cf763c2f-7cf7-6ee6-3062-438dfb395744	c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:34:15	0
d87178a8-faab-4327-8927-438dfbb6a595	d4ddef5e-e4b7-a467-6827-438dfb28ab92	c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:34:15	0
ddead9eb-3b9e-f8fe-4e76-438dfb284029	da3bae7c-9006-95c2-e478-438dfbbe63ef	c157e248-0269-e45d-ce5a-438dfbb14bbf	2005-11-30 19:34:16	0
41360199-8f2a-9054-d590-438dfb92127d	4870070a-b2b3-bcff-151d-438dfbc18c4a	f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:34:16	0
18750505-9456-a441-37ab-438dfb94dceb	14d80cec-a2cf-7117-8583-438dfb2cb4d1	f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:34:17	0
1df27043-e330-9e0b-70e3-438dfb168401	1a4390bc-a0a2-5d4d-a97d-438dfb4e80f6	f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:34:17	0
32664d0e-3761-6838-c302-438dfb49d574	2ea3e886-63b2-35ed-261a-438dfb417e85	f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:34:17	0
389ab578-1cb9-7f87-f7d0-438dfbb2d52f	35035285-d729-dd3f-17e7-438dfbfd7f45	f19298b8-0362-dd24-7cd1-438dfb8403b7	2005-11-30 19:34:18	0
532f9c3c-3efb-a05a-218b-438dfb23a196	4f779fbb-8353-bd4b-0608-438dfb69075d	4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:34:18	0
5b4259ff-3135-5654-4718-438dfbbbf646	579a9714-8d3f-2a0d-9871-438dfb550607	4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:34:19	0
60a0457a-1b0c-5b1e-98cc-438dfbd18c6f	5d00913e-6c49-c1d0-a791-438dfb2bc494	4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:34:20	0
750fb3de-3ef0-680a-c2f6-438dfbb28f1d	7178d94b-af6d-2d50-4d2c-438dfb318051	4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:34:20	0
89a3865d-56c8-0f3e-4850-438dfb79e982	8604f9c2-9c07-eae0-4fbe-438dfbe7f517	4c92556d-a6b7-3fc2-8318-438dfbed4088	2005-11-30 19:34:21	0
a4196ab7-b10e-89b0-f85c-438dfbecc13a	a0699db4-ab42-f49e-1d8a-438dfb1d7029	9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:34:21	0
a9749568-b235-0782-097f-438dfbacc5a8	a5e21f97-6531-4524-b85d-438dfb2d903e	9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:34:22	0
aeed9e21-16ea-923e-7148-438dfb4c390c	ab330d3a-9d27-a865-42ae-438dfbfb7924	9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:34:22	0
b444f8f6-3bae-e526-f511-438dfb076344	b0ad5b06-fc59-a9e9-4731-438dfb0edddf	9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:34:23	0
c8d73917-d768-1c35-3e6d-438dfbf4331f	c52c1dc6-9dcb-cb5e-a16d-438dfb3298e7	9d8a587a-f26d-a658-2757-438dfb8d237a	2005-11-30 19:34:23	0
e37c801c-ff72-eadf-fc13-438dfb97b7c5	dfdfbda5-a20c-43ab-75cf-438dfbea9465	dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:34:23	0
41230994-549c-1365-81aa-438dfb4715d1	37f002bb-ad27-9220-0c13-438dfb77ddd4	dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:34:24	0
975f0fbb-e2e5-91df-f53e-438dfb5e04e9	5d2b092b-1272-8568-db99-438dfb189eb3	dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:34:25	0
edd3018f-5b1d-c2e6-9555-438dfb723407	b3c70bfb-8222-3822-73f7-438dfb5286e6	dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:34:25	0
1444012f-133e-4803-efc4-438dfb6e88d6	10a652f7-0224-c336-7de0-438dfbfbd0cb	dced35ed-f75f-5e3e-dedb-438dfbe4f662	2005-11-30 19:34:26	0
2ea3a555-26ff-de62-79ce-438dfb838882	2aff0238-1a27-18a1-b65f-438dfb8b266f	280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:34:26	0
34178ce3-dacb-f6ca-3626-438dfb1ab72d	30704488-e75e-bc40-1d0f-438dfb93ccd0	280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:34:26	0
39901053-c1c8-72b9-a4c5-438dfbe446f6	35f1dc3e-feab-689a-2e8a-438dfb8409b3	280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:34:27	0
4e6ac718-4d19-6268-7ad0-438dfb66052a	4ab271a6-5a9f-dc1b-f893-438dfbc18781	280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:34:28	0
53cd05e0-833b-f1cf-4dd6-438dfb75385e	502ae003-dea5-c17d-e55f-438dfbcea114	280cf96b-2ef7-a0e2-9ab9-438dfb06bd21	2005-11-30 19:34:28	0
71398295-1563-6d34-26a2-438dfb7a56d0	6d986491-54aa-6d50-5692-438dfbd49b46	6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:34:29	0
76a0c907-4996-2a7e-1f6b-438dfb8845de	730c00d1-88af-048b-0996-438dfb205cd5	6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:34:29	0
7c11ace4-85ac-ddc5-ad17-438dfb0f0fbd	785e520f-660e-04d4-e60a-438dfbbdd26e	6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:34:30	0
90ff4b72-aa0d-d31d-5ecf-438dfb0b2c4f	8d5db934-2fc6-0c42-438c-438dfbdd5365	6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:34:30	0
967960a5-ae8a-1b77-125e-438dfb31eb55	92c42d58-e1bb-ee31-f262-438dfbe53849	6aa8e39e-3814-a431-1d7a-438dfb051697	2005-11-30 19:34:31	0
b0f17d1f-7b2d-1218-0de9-438dfb8634d9	ad50b055-9585-8ec2-d07c-438dfbcc0b7b	aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:34:31	0
b6684418-86f5-bfda-946b-438dfb2c5ac5	b2c36864-77fc-625f-cac3-438dfba1bade	aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:34:31	0
bbedd9b2-77b2-419a-aa22-438dfb3b8b85	b825a9a7-9989-a281-b57b-438dfb71bf44	aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:34:32	0
c6961577-9422-dd4c-76f4-438dfb5e2737	c2fd1936-5b6e-3166-800c-438dfb2abe2e	aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:34:32	0
db7d5726-aa32-d1c9-3230-438dfb537ca3	d7ca194e-da9a-e6f7-8903-438dfbc0e56c	aa65a929-1b0f-5205-f01d-438dfbabde1f	2005-11-30 19:34:33	0
1cad0397-4ff0-a50c-f3cd-438dfb2152d5	f225bab6-6aae-5c2f-ea6a-438dfb55e658	ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:34:33	0
16c1439d-f7b3-5ee9-b8fe-438dfbe44dcb	130a3332-9c79-9088-4226-438dfb411b32	ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:34:34	0
1c3acd38-c985-a17d-bc0c-438dfb21a98f	188e5631-a777-5ffa-c2bd-438dfb19a905	ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:34:34	0
21afddbd-3d72-23b2-b941-438dfb7becda	1e0d0190-8cd9-02d1-796e-438dfb0ad5cd	ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:34:34	0
36a9e533-dbcb-142b-2f1a-438dfbe04a8e	330a1419-136f-feb7-0593-438dfbea0316	ef3e5cbd-082e-12a9-b6b3-438dfb549e04	2005-11-30 19:34:35	0
5132c95c-ade1-d5c6-35a0-438dfbafb782	4d963105-ce3f-ba0b-ce93-438dfbdf3595	4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:34:35	0
596193b3-3017-8fc2-2493-438dfbb37ac8	52fea899-abb1-e899-5a8f-438dfbbb0c26	4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:34:36	0
5ecc363e-802a-5920-cba0-438dfbf903b9	5b1f5e75-7b30-91e6-4dcc-438dfb4e04e1	4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:34:36	0
64396e6f-ed0c-9d33-b15b-438dfbe761fe	608d14df-36c5-3390-56ca-438dfb418141	4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:34:37	0
698d1ee0-b486-b689-0ae4-438dfbeed61c	65f9b913-e297-df14-506f-438dfb2e2bba	4aa6de52-213e-66a8-a9ef-438dfbe96c48	2005-11-30 19:34:37	0
83df64e9-98d6-48bc-2de1-438dfb78d4a6	803cbd76-5d9d-733c-d7ce-438dfb037cdf	7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:34:38	0
99542a0e-e766-08b4-5fd7-438dfbd0c82a	95a2aa44-aef9-f13b-9435-438dfbe3d81f	7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:34:38	0
9eb75a16-54b2-1b80-ba0e-438dfb47b1e8	9b116ebc-698b-db3e-eba0-438dfbcea34e	7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:34:39	0
a4218554-64d2-0973-105f-438dfb434fda	a0866d44-c4f9-3793-374f-438dfbff9fa0	7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:34:39	0
a9861080-c058-0200-5933-438dfbd2e9dd	a5ecf9bb-856f-4bd5-a1ed-438dfbae6326	7d4ff985-e769-bde9-54a0-438dfbe394fc	2005-11-30 19:34:40	0
c443ee91-207e-4b85-cdcb-438dfb752d3b	c090c685-361f-bec5-a764-438dfb5b8cfa	bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:34:40	0
c9afdc84-d2a0-0d99-0e43-438dfb5547e8	c614b05c-a7ea-4e20-3705-438dfb48845b	bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:34:41	0
deff1a19-d9dd-6df1-2669-438dfbcac0c8	db602bee-5811-1687-5a28-438dfb297b2a	bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:34:41	0
e470fba0-9e88-9ac9-c174-438dfbd3c3d9	e0c964b1-266c-c545-cd8a-438dfbe61d4a	bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:34:42	0
e9c3e049-0c84-6f56-5e98-438dfb19e9ca	e63079db-6a27-a64d-b533-438dfb870a51	bdb03d9e-227d-740c-2453-438dfb39ede5	2005-11-30 19:34:42	0
fec50466-2eff-c2fd-b6f1-438dfb478520	c4fc046a-99a6-162e-9e73-438dfb934028	95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:34:43	0
154e83d6-e3e7-a386-36d3-438dfb5479d6	11b94861-accb-59c9-c580-438dfb5835a6	95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:34:43	0
1ace4f0a-a2ee-df8a-8fd2-438dfb0c80be	170d6eba-3cf5-932d-0518-438dfb8f5eeb	95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:34:43	0
30447ec9-4ba5-f2ee-4890-438dfb730a49	2c852c52-95bc-136e-b935-438dfb3f66ff	95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:34:44	0
35b3442a-d3c1-37e9-2876-438dfb1ba17d	32087cb0-cc25-fe7f-697c-438dfb34b792	95da0641-a17b-2468-6737-438dfb77838f	2005-11-30 19:34:44	0
506b46a7-26aa-bda3-7d33-438dfbe5fd76	4cc1b598-b894-6aa8-39e3-438dfb24457a	49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:34:45	0
5800be28-95a8-50a3-aaf4-438dfbc07323	522f0729-650c-029d-1f1d-438dfb507c3f	49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:34:45	0
5dc2064f-dd00-2835-b913-438dfbeb0e08	5a2aabfd-4ccf-57fb-d720-438dfb7670a7	49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:34:46	0
631771c6-84fa-a341-f56f-438dfb61f23f	5f8470e7-becb-dddc-8cd1-438dfb3c52ab	49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:34:46	0
788ce162-6674-9342-f091-438dfbf497c4	74f08150-1bc1-5959-cc5f-438dfb936956	49cd8ee8-2e63-ccc6-dd57-438dfb23cf46	2005-11-30 19:34:47	0
931cabdc-22f8-815d-05e1-438dfba63b32	8f688915-dbd1-8cef-8a42-438dfb81406a	8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:34:47	0
98a81f1f-768d-cac8-4c88-438dfb5909ab	94fbcf96-29b2-cbb0-4639-438dfb7c0684	8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:34:48	0
ae48c4e8-e7f9-3120-3560-438dfb013f87	aa9863a9-9d46-e628-28f3-438dfb58642e	8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:34:48	0
b3b18fc8-dc01-27ec-6884-438dfb3ddea8	b017622a-90d5-9b71-a20c-438dfb961265	8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:34:49	0
b900a02c-96dc-8fc1-b4c1-438dfb61ccc2	b572d5ab-384c-39f4-a616-438dfb0f904d	8c800256-b9ab-a248-e02d-438dfbd84b4d	2005-11-30 19:34:49	0
eab30569-5728-b9b7-d2ad-438dfb796f06	e70aa912-958c-d08d-60cb-438dfb8d6032	e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:34:50	0
f01543b8-be9a-16eb-b98b-438dfb70bbd6	ec7b257a-f870-cad4-c122-438dfbb31698	e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:34:50	0
15ee0b69-337a-2575-ca97-438dfb72e486	f1eb2833-50e5-73fc-b1ca-438dfb5fae58	e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:34:51	0
6cb6083a-888f-b7b5-f9dd-438dfb07c3a5	333b0027-f36f-639a-d626-438dfb0322a5	e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:34:51	0
c3ac0164-795a-d294-8e90-438dfbd94c92	88ed037a-d7fc-29d4-1cee-438dfb18d89a	e4282cb7-d56c-84e1-9a0a-438dfb324698	2005-11-30 19:34:52	0
36ee4555-1ae3-4472-3584-438dfba8c811	3344df8a-1475-0840-d586-438dfb6bfb66	30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:34:52	0
3c563058-7552-b5dd-8fc3-438dfb9d2a55	38beeabe-9508-16aa-c48c-438dfb761e8e	30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:34:53	0
41e26f94-cc0b-6707-83b5-438dfb11841e	3e161ade-a3e4-c37d-c880-438dfb36c4b8	30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:34:53	0
474c2453-75f4-4f90-95d3-438dfb245694	43ad0ed1-f9f4-1e15-5283-438dfb2967da	30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:34:54	0
4cae8821-b4a8-8515-372a-438dfb262310	49130b6d-3227-6baa-395d-438dfbdf6448	30530ae1-f3c5-51c9-6bb5-438dfbf62530	2005-11-30 19:34:54	0
69b3d9d1-1055-cce5-6ce9-438dfb171a7b	6609c3bf-4150-36d9-39e6-438dfb1f3e5d	630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:34:54	0
6f0bd802-7936-a207-71c6-438dfb1a148b	6b7931bb-0315-18c5-3f17-438dfbd04954	630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:34:55	0
746f9f09-283e-e712-6af4-438dfbe99e85	70db1322-69aa-8ce4-02e2-438dfb0a39df	630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:34:56	0
79d0ef08-a483-a9f5-8d72-438dfb925d4d	763d8229-faec-e64f-8e24-438dfb3704ac	630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:34:56	0
8fa5fcce-8ff2-713e-224c-438dfb501a6d	8c148275-55e3-09d8-3b0b-438dfbf32a0a	630977b0-f0a1-66db-a51c-438dfb6d313e	2005-11-30 19:34:56	0
aa1c6b5f-684f-e2e4-41be-438dfb4be82b	a67b9857-f3b0-bfa8-51b7-438dfb40dddf	a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:34:57	0
afab84b1-081f-1cff-c568-438dfb46996f	abfab155-0f27-2e82-4210-438dfb3034cd	a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:34:58	0
b50a8624-2f19-f847-1f16-438dfb0488b8	b173bad6-c29e-3ae5-ab65-438dfb21f05b	a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:34:58	0
caf3701d-ebeb-771a-dce8-438dfbabea36	c75352a3-8b57-f164-2e70-438dfb72fb3f	a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:34:59	0
d05d5da1-fd42-f57d-2140-438dfb543928	ccab7b75-ec04-0c80-4150-438dfbbcd98b	a39a808f-5cb3-4fa1-2d14-438dfb97989f	2005-11-30 19:34:59	0
eb4af7bd-de57-280f-de41-438dfbf89295	e7a41e1d-b074-c38f-6979-438dfb0bfb04	e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:35:00	0
f0af3982-89fd-5c5b-d844-438dfbb408db	ed123284-2feb-4721-e90b-438dfb607d86	e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:35:01	0
1eb70322-c1b8-8725-9503-438dfb7e2836	f26d6ac6-098c-c7ad-f79b-438dfbebae7f	e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:35:01	0
75d80cb4-fb47-70a8-a5ab-438dfb0989e2	3bcd0e26-bfb2-79b5-aba9-438dfba09c63	e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:35:02	0
cc580518-48c5-fddd-3edd-438dfb0675ef	91f50acb-e3e6-dd54-bdf9-438dfb482b3e	e4bb31e7-68c8-772c-5580-438dfbf622ca	2005-11-30 19:35:02	0
273ed31e-9314-7909-a939-438dfbfab2af	2391a511-9163-855e-616b-438dfbcc5d48	20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:35:03	0
2c9e1ab4-32f0-33c0-1f37-438dfb235c39	2903dc75-62c8-c2fe-b01e-438dfbd5f527	20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:35:03	0
4311f65c-843e-d0a5-0dab-438dfb4de837	3f3d3309-b70a-e438-38fc-438dfbf8e35e	20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:35:04	0
486d66fe-8a1f-bec0-d574-438dfb37ebdb	44d22bd3-cede-1c3e-14ab-438dfb57030c	20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:35:04	0
4ddb3c7e-51aa-9a4d-1374-438dfbce1138	4a3af748-7811-6952-806b-438dfbc5f154	20ad4cbc-4aac-69b7-27ae-438dfbaeadaa	2005-11-30 19:35:05	0
6ac9e103-396d-982c-be2f-438dfb045f4f	67316bc5-d056-ce25-66ef-438dfbd5f28e	64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:35:05	0
7025b48a-6ea8-7738-4e03-438dfba1a89a	6c8f9eda-0445-481f-4563-438dfb22c284	64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:35:06	0
75925569-f86d-5169-63b9-438dfbe46d4f	71f0270a-f3ab-ca9d-c5d0-438dfbbbe925	64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:35:06	0
7af75704-f016-f65a-bec9-438dfbb127f8	7765848c-2a91-2d33-576a-438dfb03ecdb	64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:35:07	0
806471bf-c46d-573d-85f0-438dfb85d66e	7cb5a406-8ee9-db96-a8d2-438dfb761f10	64502d84-68d6-ce4d-623a-438dfbb101e9	2005-11-30 19:35:07	0
9af88ea5-b92b-68a9-fa70-438dfb7bb15f	9750be83-a147-9999-7efc-438dfb300c83	94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:35:08	0
a06348f8-468b-bdf5-e28a-438dfb4d9992	9cc07320-4262-b9b5-7ea6-438dfbef26d2	94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:35:09	0
a5e06af2-83f8-8c3f-dbb4-438dfbdd2aaf	a23b3545-6db2-b726-be9f-438dfb8963b9	94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:35:09	0
ab368c05-5986-3392-4176-438dfb1e94e6	a7a36a07-4487-a192-4b21-438dfb1d90ab	94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:35:10	0
b0bd11ce-b637-3dd5-3ee4-438dfb81ce04	acf9acb8-0abf-e225-cd25-438dfbf8f7f6	94506f88-0bce-f500-e91b-438dfbe09d5f	2005-11-30 19:35:10	0
cb122fa4-0ec5-6590-51ca-438dfbac528f	c768d6fc-c4dd-712f-a180-438dfb575608	c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:35:10	0
d074a33d-2358-74d2-3276-438dfbe375f9	ccd3cfcf-73f5-7200-ca07-438dfb8e7e35	c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:35:11	0
d5e02109-91e4-df70-d5d0-438dfbc31efd	d230bad4-f6f7-5575-496b-438dfba81cfd	c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:35:12	0
19ec46ab-1999-3db5-e2af-438dfbf09aa7	163b46af-19fe-22e6-8fd8-438dfbbdc08c	c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:35:12	0
1f581535-36f3-0694-ed32-438dfb2b82cc	1bb79286-2203-6733-ead8-438dfbbed294	c475e259-7fe9-ced2-f61e-438dfbd84283	2005-11-30 19:35:13	0
39c7e132-1c63-e691-a485-438dfbb2ed02	36273bfb-9325-20d3-e3d4-438dfb976e9b	3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:35:13	0
3f200a23-876d-7bdd-3b81-438dfb19842e	3b8952bc-877a-3e7b-19ea-438dfbe3d033	3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:35:14	0
44c0a7c0-2121-d868-eaba-438dfbbdefa6	40fa1cdf-8c54-8c5b-57ef-438dfbdf7e67	3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:35:14	0
4a17b220-114b-3eee-43ae-438dfb51adce	4681f74a-6cbb-1020-16b9-438dfbdd9b64	3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:35:15	0
4f7de1be-4f94-90b9-cf43-438dfb3f0906	4bd30296-a710-621b-a8a3-438dfb778fa3	3315c5b9-9f44-b13d-4d3b-438dfbe40400	2005-11-30 19:35:15	0
6c70196c-e086-7993-ced7-438dfb1c91dc	68bf76bb-e6bc-cf1d-ca22-438dfb97dbfe	65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:35:16	0
82f3128e-927e-af90-026b-438dfb2fc5ee	7f47f7fd-239c-476a-586f-438dfb0e32c0	65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:35:16	0
88455282-cc63-6639-6256-438dfb0052f7	84b38e95-1918-036e-2cec-438dfbebd189	65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:35:17	0
8dc9174d-063c-45ce-6bcb-438dfb886859	8a1446bb-2682-cadc-8be4-438dfb6d99d6	65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:35:17	0
9329d012-d675-3989-25d8-438dfb87a9ee	8f876077-8abc-0801-6805-438dfbde1e69	65d977a9-17fe-c0fa-cc57-438dfb92ee04	2005-11-30 19:35:18	0
d0f3caa3-e662-b0e5-39bd-438dfbe0031e	ccae1183-411b-c135-7d02-438dfb3245cc	c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:35:18	0
d69ff485-eeb9-25c5-cdf1-438dfb37ec6a	d2d7a449-3d6b-4a96-224f-438dfb18da20	c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:35:19	0
dc2f9a3f-bb37-2d7b-6703-438dfbd5f0d5	d86f5d42-fff7-f5a7-6e26-438dfb69aeb7	c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:35:19	0
e1d401b2-b1c7-2360-34c7-438dfb473242	de0af38b-c08c-6ba2-890b-438dfb5845f1	c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:35:20	0
48290144-1ba0-cb6b-7d30-438dfb2f4df8	c91009b3-8f15-d773-b24b-438dfbd19089	c9c19848-f085-7289-cff0-438dfb5659f1	2005-11-30 19:35:20	0
1faf4c47-eb8e-e49a-8aa1-438dfb2441fa	1becb38d-cb6a-cf05-7a23-438dfb4d4500	18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:35:21	0
253d4899-999d-6be4-5279-438dfb258e7b	218a1d46-735f-6d03-0213-438dfbf40c33	18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:35:21	0
2ac4b3c8-2c2b-7c80-d822-438dfb314d3f	270760bc-b099-f513-93af-438dfbb4aeb6	18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:35:22	0
419fee30-3dde-185c-8e97-438dfb6e4b71	3dd20bed-3295-1d52-66ca-438dfbca4e96	18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:35:22	0
474deee5-9e43-1c5f-0aef-438dfb76b62b	439583fd-2ce6-cd7c-8e73-438dfb4f4602	18de4a65-6937-d606-bf3e-438dfbdc97bf	2005-11-30 19:35:23	0
64d63c10-3b8e-617c-77fc-438dfbfc6c01	610cee41-e9a8-bbed-700e-438dfbe95377	5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:35:23	0
6a70fa8e-2772-3dae-60d3-438dfb1d0af2	66b66fdc-28f9-d39a-bae4-438dfb673ac3	5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:35:24	0
6ff3ea8b-2069-1967-413e-438dfbec5715	6c3b53a4-e2aa-761d-fbb6-438dfbe47f71	5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:35:24	0
86da555c-8d7d-1271-36cf-438dfbb735dc	831e6319-d54d-91d7-28a1-438dfb7920aa	5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:35:25	0
8c705955-af11-d2f0-2e6c-438dfbe96b37	88a477f4-4423-803f-6605-438dfbbc8a6f	5e1adbb5-73de-84e8-26d6-438dfbbe13ac	2005-11-30 19:35:25	0
a760c138-4ea6-af45-17bf-438dfbdaa6eb	a3a5df77-7d8f-e658-4ed4-438dfb2eded0	a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:35:26	0
ad0126eb-b6b0-58a6-4d58-438dfb69c9b7	a93b17e4-da67-d116-f916-438dfbda002a	a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:35:26	0
b28e648b-937a-0aab-29ab-438dfba3a1f2	aed364b7-f149-e6c6-69bf-438dfb189209	a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:35:27	0
b8040d8c-b51b-6006-a911-438dfbb316c4	b45a5122-5bc0-b18f-839f-438dfb6daef7	a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:35:28	0
bd9085bf-f14d-4c2f-5118-438dfb986b17	b9d52d44-12f8-e5ad-c7fe-438dfb1560db	a0b1e6ca-bb6b-5303-162b-438dfb6373d7	2005-11-30 19:35:28	0
d86f5040-fd8e-ba88-42d6-438dfbef3dbc	d4af469b-3bcb-42c6-1f90-438dfb12aa1d	d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:35:29	0
ef8b9d6f-034f-33db-8108-438dfbdc5d64	ebc5e5a0-60ec-33d8-9c78-438dfbaa88dd	d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:35:29	0
ec80090a-9273-9a9c-faf5-438dfb88a508	f15faf12-1465-1510-d00d-438dfb2af449	d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:35:30	0
69890ee5-85cc-d8db-6221-438dfb0d24ba	2d4b0daa-e385-be7f-d4de-438dfbb622fd	d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:35:30	0
1da80e6c-95e4-de02-f4d2-438dfb4f209f	19de881f-33e6-3704-b9c2-438dfba30320	d1c8692a-5f60-1701-28b1-438dfb4a89c1	2005-11-30 19:35:31	0
387ee09e-2466-d405-f930-438dfb352312	34c3555a-cc15-cdd8-40a9-438dfb1f6c7b	31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:35:31	0
3df82d48-c2a1-7e5b-8b71-438dfb1bb01f	3a4fc9d6-72e4-cce6-4419-438dfbbcb21f	31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:35:32	0
43cb7d00-57fd-3a94-033b-438dfb938e97	3fb98483-73c0-865e-c255-438dfbb82c69	31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:35:32	0
491f8c36-86a3-c479-6a56-438dfb6cba1a	458dd31d-4ff4-5a16-47e6-438dfbaaf7cf	31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:35:33	0
4e990557-f199-f1f0-5458-438dfbdb06d7	4af2477e-be7b-b633-eaf9-438dfb1e3ca7	31d5cda5-dbe3-02ac-0040-438dfb087ca2	2005-11-30 19:35:33	0
6b9fd59d-16f1-847d-659f-438dfb04b2b0	67fa537b-3b13-3f9d-b085-438dfb055224	64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:35:34	0
71074699-09c4-eb06-6b37-438dfb2f5a41	6d73d859-b90b-f47f-a80a-438dfb7211ea	64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:35:34	0
76692b3c-a6fe-563a-be3c-438dfb5f0b6e	72d0e32f-a1ea-946a-4fac-438dfb2b6e03	64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:35:35	0
7bd0f115-6e41-f2d2-b030-438dfb90d336	783f447a-1e16-ca1b-2ee4-438dfb25fd59	64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:35:35	0
81390122-3186-24ab-5c5d-438dfbdebb03	7d8ac77b-c8fc-84e1-33c5-438dfb4b9d13	64f5db21-f2f2-bf69-83b7-438dfb107f3a	2005-11-30 19:35:36	0
9be26c79-ea71-6ed0-65e5-438dfbc1f85b	982982f1-3b92-ad60-a82f-438dfb6b88e6	9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:35:36	0
c513433b-3eb3-2963-f063-438dfbd67879	c147a11b-2cc0-6306-424d-438dfbba5030	9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:35:37	0
ca8b78cf-3f67-246c-2a4c-438dfbe29550	c6dd0675-ca84-3964-c021-438dfb8008b5	9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:35:37	0
cff074e3-857a-fed9-0806-438dfb70b3af	cc4b3ea2-e8ed-d4d1-f347-438dfb456cf3	9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:35:38	0
d56007fb-4103-6d1e-acd2-438dfbd54956	d1b82ae4-e7b6-c965-b485-438dfbbffddf	9536b4e9-efc3-f6dc-4b08-438dfb49736d	2005-11-30 19:35:38	0
3177dfb8-8a4c-2ae9-4b1a-438dfb2ce378	2dcfbc0a-365f-1c30-4dab-438dfbbca9bf	2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:35:39	0
37092b6b-2be6-d5a1-99e6-438dfb6ff9d8	335b0c87-2585-8de2-cc26-438dfb591f62	2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:35:39	0
3c7525c3-181f-303c-b126-438dfb20a39f	38cf70ad-8971-4ffc-b514-438dfbb136a7	2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:35:40	0
41e4c708-288d-0d2e-9125-438dfb79805b	3e37219d-2222-b819-7a5d-438dfb1fc77a	2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:35:40	0
476161ec-621c-f2d8-bd83-438dfb1020c2	43c8c276-7e8f-e71d-9222-438dfb212ee6	2ae53d7c-3815-fef1-3da2-438dfbbcfc11	2005-11-30 19:35:40	0
894e4bc1-a9e6-35ae-2d00-438dfbb94061	85b4ed8c-4baa-4de4-fa91-438dfb5d5163	82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:35:41	0
8eb9364e-78f0-bee2-3199-438dfb7979da	8b24a0d2-f316-dc4c-77f2-438dfbaa40c9	82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:35:41	0
9442f72f-e596-710b-e1dd-438dfb2fd378	90a18be7-7f89-e4a3-3bf8-438dfbb80ef2	82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:35:42	0
abab6206-e1f4-c340-3bb4-438dfb90cbf2	a812d4f7-01d0-31a8-e4d0-438dfb28c391	82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:35:42	0
b112593d-865b-a64e-0d8d-438dfb81ef00	ad6cd3f3-a0f5-621a-71c4-438dfb9f6d02	82b6361d-819d-b3df-d2f3-438dfb0fa311	2005-11-30 19:35:42	0
cb724887-36a8-a77c-ec07-438dfb96d414	c7cd2eef-f130-417d-d34c-438dfb1feda7	c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:35:43	0
d0dd3998-39fb-8da0-f85f-438dfb1da504	cd3ad2f7-f852-3f32-d24b-438dfbb615df	c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:35:43	0
d656a5cd-a528-cf42-0182-438dfbe052f6	d2a83366-ed9a-20e0-2c23-438dfbe82893	c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:35:44	0
dbb6603e-70dd-ac97-4966-438dfb84f0a3	d81eb109-0444-78d0-82d0-438dfbd6a487	c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:35:44	0
e1330002-a559-265f-4b91-438dfbad17f5	dd87c6ba-068c-2265-21e4-438dfbdaff99	c4d987ed-850f-a5ef-ee3a-438dfb9f0548	2005-11-30 19:35:45	0
85c208b5-7a40-64eb-6e24-438dfb47d8b4	4b480885-6914-e10a-4af0-438dfbe5d93f	1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:35:45	0
dbf8068b-335d-28e6-0855-438dfb08de1c	a29001fc-6d9e-21fa-bdcd-438dfb4b7210	1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:35:46	0
13264b5f-c37f-301a-c5fa-438dfb130314	f8030d7e-9a61-0d4c-d9a1-438dfb3cc564	1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:35:46	0
189cc680-0286-191a-3a72-438dfb0737e3	14e5bdce-0500-4555-337a-438dfbbed20a	1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:35:47	0
1e1f56d5-5e19-929b-5562-438dfb786fcb	1a75b2f7-f546-21f2-c5e3-438dfbf6bb4d	1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71	2005-11-30 19:35:47	0
386f49c4-6d21-797a-aaa8-438dfbdfac9c	34bd298d-2628-c968-c919-438dfb175578	31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:35:48	0
3dc41c99-ec2b-595a-5a41-438dfb89b50a	3a2ead17-8c17-db63-53d2-438dfbaab2f0	31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:35:48	0
6a9fa30b-15b6-70ff-4972-438dfbc60581	66f4ba15-4fa8-0240-b307-438dfb14c59e	31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:35:49	0
700db219-2f4f-39f9-129b-438dfbccf379	6c753474-a346-9ff6-44f8-438dfb2fc7e7	31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:35:49	0
757991a4-0456-9252-7838-438dfb224aeb	71ca3a53-567c-5b77-4745-438dfbf9611b	31d3ed19-3822-88c6-3ac7-438dfbffa1a3	2005-11-30 19:35:50	0
b4a490ba-56d5-4144-18f2-438dfb80cc36	b0fc2a3f-d30e-fda6-6fe6-438dfb940daf	ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:35:50	0
ba06b339-1473-1cff-a585-438dfb49a20c	b66ab82c-8fb7-3aee-505d-438dfbf64ea6	ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:35:51	0
bf7fe9ed-838f-a77a-f9ad-438dfbbbbc20	bbd1cbf4-64bd-36dd-e319-438dfb856679	ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:35:51	0
c4d6fb89-2c5f-b441-9944-438dfbb8bb30	c1444a2f-4a56-9ccc-e661-438dfb51f23c	ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:35:52	0
ca5bd815-2fe4-a57e-c1bb-438dfb6c7706	c69bf4f4-e14c-26f0-8c64-438dfbad762d	ae14f6ad-94c0-eab8-56ce-438dfb978df8	2005-11-30 19:35:52	0
e4b3fdbd-0379-b7bd-185a-438dfb6a0f01	e10a6919-5600-3567-3919-438dfbe63023	de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:35:53	0
ea20c85b-f66a-335b-3b3c-438dfb9c0a77	e68137f4-a587-5f97-ff31-438dfb6acab9	de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:35:53	0
ef8ed96e-bc4a-4eb8-8b58-438dfbc1ea2c	ebe39ee5-ba6c-2c66-ae61-438dfb51dbdd	de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:35:54	0
13420a98-310a-6eac-dd55-438dfbe86100	f95504a4-7d76-401b-96ac-438dfbc3835c	de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:35:54	0
18a0f3be-486a-4b5f-6b93-438dfbae07fb	150748cc-3f89-24be-46dc-438dfb345571	de18c543-c83a-7128-8ede-438dfb90ca7d	2005-11-30 19:35:55	0
3300194a-1cee-b81a-1d07-438dfbe099bc	2f58f569-cd8b-9c44-9594-438dfb99a473	2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:35:55	0
4afd447f-b577-6a98-e976-438dfb787df9	47651b28-84b2-6957-8b27-438dfb6c41d4	2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:35:55	0
506dfe29-e883-a389-5826-438dfb1fbc2a	4ccd8d51-0d24-b219-480d-438dfb064155	2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:35:56	0
55d1f18a-6c5f-d236-8a74-438dfb64edd4	5236e96d-a265-c1bd-17ba-438dfb2e821c	2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:35:56	0
702a4d6c-0714-6693-ae2e-438dfb46656c	6c8ad315-4a3c-2229-bc68-438dfb55a733	2c6dc705-ce38-9d87-f23e-438dfbcebbbd	2005-11-30 19:35:56	0
8b0fd0fc-31b1-26b3-aca0-438dfbae9737	87663f74-160f-6a05-430f-438dfb6d1b28	848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:35:57	0
a33fadf1-e878-92f9-91de-438dfbd9d3b6	9f9ff688-6efa-295f-b594-438dfb52bc5b	848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:35:57	0
a8af3659-d175-9d41-ff7b-438dfb10f648	a5071291-066e-f689-bfe8-438dfbe2c5bb	848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:35:58	0
ae11bbc2-1001-a3da-a798-438dfbe4aafd	aa79dbc4-37c6-e0dc-173a-438dfb043393	848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:35:59	0
b38119ec-7794-248c-2d02-438dfb769277	afd52cf4-3c7c-3bef-bcfb-438dfb08eadf	848b2f3c-fbf2-8431-09c3-438dfb544d45	2005-11-30 19:35:59	0
cdf4aa9e-7e6d-fe6a-85cc-438dfbc9fb4d	ca4faca4-e926-3abd-c113-438dfbbe7918	c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:36:00	0
d36c8879-eb09-b3ef-e6e5-438dfb0056fe	cfcaf284-7177-3203-8c93-438dfb30b7b5	c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:36:00	0
a1a50511-07d2-f45c-8457-438dfb47b9ad	66d00db1-f219-af0d-ac90-438dfbdfdb62	c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:36:01	0
f7220ab4-783e-6b93-3c56-438dfbb7ef1f	bdcc0db4-18e2-180a-6484-438dfb3f422d	c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:36:01	0
14d88862-4ed6-bdb5-33fd-438dfba0f281	113bc9f3-00df-f57a-27f1-438dfb192b63	c760e512-ab2c-a35d-da62-438dfbac82ea	2005-11-30 19:36:02	0
54e340ed-fae0-bacf-e1b7-438dfb3b6a6e	5139fa34-38ca-c8b6-27c4-438dfbdd90ab	4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:36:02	0
5d007745-cfd6-16ec-49ff-438dfb21d245	56aa8656-82dc-9726-7914-438dfb9ac2f8	4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:36:02	0
626405dc-e539-ac5e-f019-438dfb4695d7	5ec549a1-46d1-97f8-50f4-438dfbee73e7	4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:36:03	0
67d04bf6-e109-8190-70b8-438dfb290039	6427daa3-04cb-a518-8d57-438dfbf50563	4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:36:04	0
92b070b9-d565-f0ae-9d60-438dfb23c80a	8f129c13-a2ad-991f-ebf5-438dfbf2ede0	4e4bde3d-2e6a-1c54-2813-438dfb4f48f4	2005-11-30 19:36:04	0
ad3128dc-735a-25ed-231d-438dfb953faf	a9951d1c-4496-f9b9-dce8-438dfbb134f6	a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:36:04	0
c578ad58-8031-5c93-d57c-438dfb112f64	c1dbae19-2570-d603-99e7-438dfb4fc532	a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:36:05	0
cb0bd8c4-2b28-849c-59aa-438dfb34d8c2	c7496a6b-5655-07df-f904-438dfb6756ed	a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:36:06	0
d06d0dba-f5dd-2394-7950-438dfbd3c652	cccfcd99-7a2b-f703-0666-438dfb7c2732	a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:36:06	0
d5dd3458-b01d-6b46-fe5b-438dfbf679df	d2310726-2717-e1cd-a6d0-438dfbf94241	a6a62cfb-3bac-4a41-fae6-438dfb577838	2005-11-30 19:36:07	0
f0a419bd-952c-faa1-2be1-438dfb132fe8	ecf982bd-b743-2bb9-a266-438dfbb7e177	e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:36:07	0
15023a4e-50cb-9d0d-d658-438dfb3c7d8e	11483307-ac46-b00e-7f38-438dfbc4f77a	e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:36:08	0
1a825045-ffa5-1787-5a36-438dfbd0c1a0	16d992a1-2af9-60a0-9b35-438dfbda5e6a	e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:36:08	0
2012a16a-9b59-a8c2-0b8e-438dfbd71227	1c58a7fd-1594-a1fd-5611-438dfb1b3feb	e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:36:09	0
257a948c-8ff0-6897-530d-438dfb928a05	21d87d4f-cf65-c507-bf9d-438dfb149dec	e9da28ed-3d11-c2aa-fa97-438dfbeea08e	2005-11-30 19:36:09	0
53655457-5418-5897-c79a-438dfb1cfb48	4fc473cc-a80b-3b26-cfc7-438dfba3d728	4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:36:10	0
5b6c735d-5cfb-5a13-09ff-438dfbbbb19f	5533e743-e362-0d1a-a613-438dfb901779	4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:36:10	0
60dffbbc-8632-1981-9270-438dfb6ebd48	5d404023-7994-dc3e-d1df-438dfb811d46	4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:36:11	0
796aba5b-5e1b-c11b-2ff3-438dfb340b4d	75ce3e6f-8909-3c3d-7122-438dfbece638	4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:36:12	0
7ec842bf-792e-083f-6682-438dfbe14581	7b2b59d5-3dea-8cac-eb1d-438dfb15f6b6	4cc8b395-11af-cd01-257d-438dfbf89cc3	2005-11-30 19:36:12	0
996b4beb-8b70-605d-ba3e-438dfbeea1ca	95c0db82-2078-3e7c-9353-438dfb27a5ce	92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:36:13	0
9ed63387-a89e-18ec-7480-438dfbcb3e64	9b382caa-99eb-bccf-78c6-438dfb8400ef	92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:36:13	0
a442f84d-6fa4-64c1-ed83-438dfbc0ce11	a0a14718-7e6b-d110-7e43-438dfb1e2243	92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:36:14	0
bcd94eba-72da-4326-9f1d-438dfb7b0155	b9370570-a71b-2cfd-0597-438dfbe8f1ea	92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:36:14	0
c2372988-9cb9-aae8-493d-438dfbd8ba6d	be97ae08-405e-225f-e7b4-438dfb8c4a6a	92a2d19a-54ee-f1fa-987c-438dfb0290ca	2005-11-30 19:36:15	0
dc8a7015-7d25-a27c-ae2a-438dfbf62149	d8ed2ac2-5af4-f2cf-283d-438dfbc710ec	d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:36:15	0
e1f41cd3-6668-709d-cd43-438dfbf4e415	de4e38b7-e544-16b4-af35-438dfb97bd68	d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:36:16	0
67ec0d4f-6e53-1ee3-39e3-438dfbe1d291	2c920b4c-dabc-e65f-9e6c-438dfba1b534	d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:36:16	0
be6008cc-667c-375a-50c8-438dfb2c2be5	85180d73-5bb8-f624-b4de-438dfb9f1fea	d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:36:17	0
11600911-42d9-9b9d-7708-438dfb7854a1	dc9907c5-c2a2-0022-fa76-438dfb597eaf	d6108839-dd16-d342-237b-438dfbe20b60	2005-11-30 19:36:17	0
528a209b-3e36-6f8c-a87a-438dfbdc2e48	4ed0e470-2e8c-0cd5-925b-438dfbfe32e2	4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:36:18	0
57e5532d-ce1e-c1c9-c1ee-438dfbe828b2	544ce334-0cc6-f55e-8347-438dfb94658f	4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:36:18	0
5fd8cacc-649a-d52e-e7a6-438dfbef3d01	5c3f92d2-cfee-20bd-91af-438dfb286a0e	4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:36:19	0
654a5584-b91b-6572-510f-438dfbdea1ce	61a4c016-3f30-117d-be32-438dfb946196	4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:36:20	0
6aac403f-1d0b-1da3-258d-438dfbf14eed	6701facf-d6c7-9e6b-57e1-438dfb069237	4bdffe67-f195-8ae3-ec7b-438dfb881f4c	2005-11-30 19:36:20	0
abd86b6f-92ff-1187-e4f0-438dfb47ca16	a831a82b-082b-3843-b6ad-438dfba8ca5e	a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:36:20	0
b14515a4-b5be-5a12-879f-438dfbbe8b56	ad9f5b56-7a23-ce4f-7469-438dfb9c662f	a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:36:21	0
b6b2a8c0-aaa6-577f-0f46-438dfbdf79b3	b307596f-de4c-6e0d-4573-438dfb59ccb0	a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:36:21	0
cfbef517-9cdb-518d-81cc-438dfb4288f0	cbfb897b-c7eb-a33d-4a5f-438dfb931552	a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:36:22	0
d5528291-68f1-6934-6892-438dfb660c5f	d19d3019-668f-178f-0db8-438dfb2cc8a5	a54321d1-cbd4-e430-5d40-438dfb8d8fbe	2005-11-30 19:36:22	0
f023d39d-363f-b8f7-bafd-438dfb4855e5	ec5ab51b-04bb-f191-6512-438dfbf7fc6e	e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:36:23	0
19410305-60c7-daa5-188d-438dfb2ac266	f1f3fbbd-bee8-4dc8-94a7-438dfbfcb068	e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:36:23	0
6fd508cb-cb27-4e06-5c1c-438dfb6366b2	35980610-06bc-b989-e32f-438dfbc3455e	e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:36:24	0
c6660ee0-f32e-c2f2-93da-438dfb7b9d9a	8cb7014f-b712-5929-507b-438dfbab1b8c	e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:36:24	0
11c7306b-b65a-2fdb-7994-438dfbc61134	e2620fa7-c74a-be8d-cc28-438dfb54675c	e93ec2cb-fca3-0b23-7ca7-438dfb73696d	2005-11-30 19:36:25	0
2c165f2a-a774-d07d-7ed3-438dfb39c581	286d3e9e-5f54-3ab2-3f94-438dfb07a03f	2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:36:25	0
317a5f61-2d69-ebfc-5e9b-438dfb1f0fbf	2ddc5e55-2757-094c-1059-438dfb80c626	2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:36:26	0
36f34c73-1675-23a0-79e3-438dfb98e98e	333dce14-183f-790e-6a5e-438dfb01d345	2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:36:26	0
3c71efcc-f95e-0d04-0f4f-438dfbfa62ca	38bc7d85-7a85-57c0-e3c3-438dfbec7e6c	2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:36:26	0
41cb6ece-31ac-4e81-1d5f-438dfb461529	3e302898-94c1-becc-3e70-438dfb939994	2584d7e2-acb7-6248-5eae-438dfb125d89	2005-11-30 19:36:27	0
5f01b43b-e385-a4c6-94bc-438dfb965f48	58bdf0ee-4e20-c4c8-b856-438dfb34aa84	55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:36:27	0
782ed806-1f2b-a145-5f6d-438dfb50f99a	7483fb5f-d7d4-eb08-cbac-438dfbe5b90a	55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:36:28	0
7da35a1d-5f60-58e6-faae-438dfbad962c	79f50639-e36a-d96e-aaa7-438dfbda834e	55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:36:29	0
96dd8bff-d777-d71d-c7fe-438dfb76e78f	93141e5e-8083-3807-19c4-438dfbcf1676	55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:36:29	0
9c58b635-6e91-0786-eced-438dfbadb9fc	989cfb8b-99c7-c2ee-f6e3-438dfb2fca19	55d98ba6-62a7-fd7f-d743-438dfb8a5931	2005-11-30 19:36:30	0
b6b9db69-5fe7-b4e9-8495-438dfb333570	b306369b-042d-58e3-9b20-438dfb218b66	b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:36:30	0
bc1f14a3-24a3-c84a-b8d8-438dfbb7faac	b87f942b-242a-702e-73dc-438dfb9d5ca2	b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:36:30	0
c184b1a1-daa9-4cdc-9412-438dfbf78d85	bdeb1fc2-3b6c-8991-e0c7-438dfbd9520d	b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:36:31	0
daccbce0-b3d4-496a-7dc2-438dfb050b8b	d71d689e-f846-b594-cabd-438dfb7a2265	b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:36:32	0
e03bcee0-e120-b893-8bf4-438dfb56a3a5	dc9670b6-a56e-16e1-d403-438dfb467f20	b019d8c4-37b1-28cc-e7ab-438dfb2fef9e	2005-11-30 19:36:32	0
6a07082d-1415-93e3-0109-438dfbc1b2ea	2f0909c4-c531-7609-13bd-438dfbc879d5	ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:36:33	0
c07f0425-d42e-5c0a-d061-438dfbff6241	86a909de-b23e-ebb8-e3cd-438dfb9eed22	ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:36:33	0
115a06dd-349f-4593-ef4d-438dfb450ed2	dc5f035d-1434-73e4-5e7d-438dfb5a13e7	ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:36:34	0
16c65ea7-0c12-18e9-8063-438dfbbd5c0c	132675d1-f274-3dc2-412c-438dfb9ab8af	ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:36:34	0
300bbda0-7173-fd09-f53d-438dfbad9ee4	2c67a48b-84c3-0baf-3c25-438dfbfb760a	ec000cbb-56ab-f5c9-f878-438dfb94f5b0	2005-11-30 19:36:35	0
4a9fb3a6-2397-fc84-4fdf-438dfb0cb3a7	47035a77-ca6e-d83d-ec07-438dfb993072	43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:36:35	0
500c37d9-800e-db50-bc3f-438dfb0994ea	4c68f478-ee8d-cc4c-8871-438dfb67b938	43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:36:35	0
55762487-5cda-200c-94c2-438dfb7950e1	51ce8cfd-85e8-1d0c-b588-438dfb0dd6d0	43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:36:36	0
71640c34-50f4-54fd-1a7b-438dfbc3b462	6dcb5520-59fa-2dee-286d-438dfb7bc285	43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:36:36	0
76cc7509-5fb6-8aee-79da-438dfb0738b0	73239b20-a04d-d10d-fbde-438dfb82fb95	43f6b34a-7012-acf9-e2e2-438dfb8bbb40	2005-11-30 19:36:37	0
91010005-5b21-3eee-87c9-438dfb2bfa17	8d69a2cc-614c-74a3-4645-438dfb990850	8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:36:37	0
beb161ba-7827-e732-5212-438dfbb4d7c3	bb003c72-fd03-3f6a-ccf7-438dfb5ff9fe	8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:36:38	0
c4130a22-1ab4-8a1d-50bc-438dfbdea7fc	c0783c7e-a4c4-196d-f9d1-438dfbba4d7c	8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:36:38	0
c97c07af-a768-9b31-7f88-438dfb173040	c5e159f2-839d-a928-3416-438dfb6933bb	8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:36:39	0
e2f116da-8cf5-bbbb-0b91-438dfb0a4b9a	df3bfcb0-2d2b-038d-0f3a-438dfb037f6a	8a83320a-d876-f677-8963-438dfb6c10c8	2005-11-30 19:36:39	0
93ab0f98-a181-d099-f5e6-438dfb0a6aac	58500fd6-2184-21fc-5e9a-438dfb2969b2	284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:36:40	0
eb0d02fa-2f99-e0be-ea47-438dfb4219a3	b15d02aa-39ef-2995-2ff7-438dfb374999	284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:36:40	0
141a58a7-44f6-8229-c942-438dfba480e3	10700e3c-8e47-dd1d-c245-438dfb2b6957	284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:36:41	0
19e1b2c7-a978-979c-2510-438dfbb4734d	15dce8cd-fe1b-d2b5-7df3-438dfb72f321	284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:36:41	0
1f63fdfd-8d61-2b0c-c9ce-438dfbfbecdb	1bb999b8-d698-6f68-0af3-438dfbb381a3	284809c7-3b5b-e686-f4e7-438dfbfa5eed	2005-11-30 19:36:42	0
64dd0053-4ca9-d28e-bc75-438dfb9a1ba1	613c32e9-426a-c52a-0824-438dfbc7c632	5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:36:42	0
7e674897-9994-c6ca-a93f-438dfb6d1d3f	7acb789d-55b2-cb78-7caf-438dfbc8f736	5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:36:43	0
83dceacb-7def-353f-a702-438dfbcbc7a6	8032dfb2-b3ff-00c5-9ac8-438dfbc56fc8	5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:36:43	0
8942e896-953d-2393-ce48-438dfb45c322	85a4a247-20dc-e8ea-fb94-438dfb0bc836	5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:36:43	0
b754a5da-0be0-86c1-1401-438dfb16f5b0	b3a36e81-1017-5d59-9dfe-438dfbc64040	5de035e3-561e-2abc-3a8a-438dfb857c6a	2005-11-30 19:36:44	0
d1b7e38c-6250-db81-c75c-438dfbd1a83b	ce14116c-26cd-ab19-78a7-438dfbbe4c2a	cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:36:45	0
d73171dd-6c35-65b1-5621-438dfb96d6d7	d382b5e8-0852-62ba-c006-438dfbf13a82	cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:36:45	0
dc8e1e66-ffdc-9136-046f-438dfbaf2a01	d8fa2f49-6e11-1fc3-5983-438dfb7f6d9a	cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:36:45	0
e1fb6c7b-7ca3-e454-7262-438dfb8d63aa	de54eb3c-f0b9-63fc-2269-438dfbadda8d	cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:36:46	0
e770f986-2c86-b31c-54ef-438dfba013c3	e3da4103-8b40-2e40-cae5-438dfbd4cd7a	cb2da29e-414f-84e2-3742-438dfb1177a4	2005-11-30 19:36:47	0
dcc50dc9-8bad-7e6b-8f8e-438dfbb5e011	a269051b-3be0-53c4-42bb-438dfb55b7e6	73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:36:47	0
136534bb-f7f5-97bf-1717-438dfbbcee38	fa0f0077-a08e-68df-6b29-438dfb6948c0	73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:36:47	0
2d357201-5c5a-46d5-783e-438dfb2359fa	297d2451-b74e-c2e2-c06d-438dfb778dfe	73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:36:48	0
32a9747d-9b94-8153-abb1-438dfb5a640c	2f0cf28c-95df-6abd-3e12-438dfb6a74d0	73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:36:48	0
381de452-5765-65e6-1f63-438dfbad022f	34768ad5-b375-988d-e689-438dfb5c55d2	73890092-16e9-601a-454c-438dfbd6bb8d	2005-11-30 19:36:49	0
7e4f7a12-04b8-23bf-f118-438dfb42a94e	7aae7f6e-63d0-e7d3-571c-438dfbd93ec0	77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:36:49	0
83cd4de4-4cb2-c051-16ff-438dfba74a96	802606cf-5b2c-379c-9522-438dfb11db94	77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:36:50	0
8939d892-f5c5-e9ea-b812-438dfbd65157	858b3ae5-e860-d74b-94cf-438dfbdfc36f	77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:36:50	0
8e99c2e7-d7b7-c0e8-4f6e-438dfb474966	8af6e80c-8019-eac3-56c4-438dfbbc24d4	77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:36:51	0
93fa85eb-e42b-1b99-15b9-438dfbe3efd1	9056adc9-b90b-249c-2de9-438dfbda1941	77c31c1a-fc84-7181-bb1a-438dfb1947e8	2005-11-30 19:36:51	0
ae8862ca-852f-f544-0af3-438dfb3a1d06	aae82dba-0eb9-1f6c-1df7-438dfb035082	a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:36:52	0
b3f13556-cd44-f3da-c411-438dfbce9b13	b04ecfe3-f86e-2294-c184-438dfb6910f6	a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:36:52	0
b96222ca-e1bc-1d0d-7924-438dfbf8dc2b	b5cecdff-a77f-c0d5-fba9-438dfb167133	a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:36:52	0
bec37b06-2f74-2261-ee6a-438dfbd817b0	bb250cc3-76bd-2698-f36c-438dfbde19b1	a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:36:53	0
ed6f2353-7553-e0bd-64b8-438dfbaf7643	e9b7a0a8-b081-0e15-e31e-438dfb47c5cb	a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9	2005-11-30 19:36:53	0
13d26739-530f-81ee-1765-438dfb764570	10361acd-5652-3f18-425f-438dfb17294a	d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:36:54	0
196f356a-f52c-dbfa-26bd-438dfb7317ca	15a96ce5-d9b6-4307-8dd5-438dfb51522d	d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:36:54	0
1ef246f5-3fe2-a83e-fa81-438dfb2bab4c	1b38adc1-7cfc-8780-c02f-438dfb5d1a70	d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:36:55	0
2461448b-bb87-2ac8-bfbc-438dfbd35425	20bf41b8-4d82-74d2-e046-438dfb26a78d	d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:36:55	0
29bd76cb-3024-150d-d8be-438dfbb63e4f	26273c38-d3dc-f093-b4f6-438dfb4ce103	d5990adb-7e13-c998-591a-438dfb469076	2005-11-30 19:36:56	0
44118abd-d0a5-1c36-4427-438dfbfd4b10	40796bc7-700d-d264-f808-438dfbe5d347	3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:36:56	0
499686f2-8664-f295-64b6-438dfbf1c338	45dfb888-4097-a516-84d4-438dfb5aec68	3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:36:57	0
4ef5117c-4e2f-c270-7692-438dfb2d3c89	4b56bd63-a48f-a591-48dd-438dfb2feabd	3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:36:58	0
546e6f63-daac-edab-5f42-438dfb6680e5	50c47e7d-5fd2-e8ce-1502-438dfbf5bd16	3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:36:58	0
59bfbc3e-5c42-5790-6e18-438dfb2e6b3b	562b29c4-3cee-7181-5e72-438dfbbf2625	3d8a4e68-3a64-5257-f4e8-438dfb6e96f3	2005-11-30 19:36:58	0
77018526-14e4-470a-a0f6-438dfb30c0c1	7339f70f-e38f-a05d-a763-438dfba8cf7c	7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:36:59	0
915df2d5-2cf7-ef13-1949-438dfb0f928a	8dac0374-01dc-bb4b-0c99-438dfbfcb01c	7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:36:59	0
96f6c60f-1ff0-74d7-e8fa-438dfb2470a7	93358cad-7e63-270b-b797-438dfb50ad84	7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:37:00	0
9c976150-2b10-e272-9772-438dfb465f6b	98ca0707-77ed-022d-0a96-438dfb81225e	7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:37:01	0
a2aae7f9-237a-fb69-8ed6-438dfbe51479	9eb7491e-8a04-0c6c-b5b6-438dfb112c12	7020cebe-a450-fe7d-c86f-438dfb1e6ee0	2005-11-30 19:37:01	0
bd8bd046-ddf5-b957-783b-438dfb35399a	b9cc0de5-e4a7-28f7-3218-438dfbecee04	b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:37:02	0
ecd5f829-1e30-7388-c90e-438dfb377878	e90e8234-d821-d788-740d-438dfb97a7e0	b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:37:02	0
f262bf02-0e62-4410-f293-438dfb6c06d8	eeadb439-3480-e5de-8542-438dfbd279d5	b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:37:03	0
3f7006ae-6f08-fd7f-3647-438dfb9cbb86	13700a01-f1ad-fc69-7bfa-438dfbde388d	b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:37:03	0
98830a00-38b7-7602-451d-438dfbb9b48f	5cd00f07-cde6-82e3-ee5d-438dfb600050	b6e5a19f-c8e7-6e3b-ae0e-438dfb226928	2005-11-30 19:37:03	0
692f77f0-b435-7ca1-b843-438dfb532436	6567c3b0-5789-b666-8f08-438dfb6e5421	6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:37:04	0
6edef037-2496-125e-945c-438dfb50c36c	6b15405c-a6a3-72d4-ec42-438dfb487b7a	6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:37:05	0
74642242-c87a-bae1-d2b7-438dfbcb7584	70a524fc-9534-5e35-5d08-438dfb7b31db	6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:37:05	0
8f8849b8-ffac-d205-9284-438dfb78c55a	8bc5a95c-476c-bcbe-6343-438dfba05239	6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:37:06	0
952b161f-21bf-76c5-9d9c-438dfb4407e9	9159b7d9-80b3-6701-bc1b-438dfbaa8451	6278c3f9-a220-9270-5af6-438dfb72491b	2005-11-30 19:37:06	0
dffd2330-275d-8be4-9f81-438dfba6b0a7	dc304ee5-e702-09cd-4094-438dfb4fc93f	d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:37:07	0
e5a8f49b-034a-6463-4a4d-438dfb26be78	e1ed4d11-22c3-0d8d-6785-438dfbb0f200	d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:37:07	0
e79c0958-2709-1b76-840e-438dfb4d1185	aada0d6e-2372-2020-0801-438dfb441021	d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:37:08	0
140d1a2e-4729-4114-41be-438dfb2eb650	10509bd6-b24b-f28d-1824-438dfb9e5b7d	d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:37:08	0
198b1216-dac7-ad2d-85fe-438dfb8cfd25	15cf4076-ad8b-0f19-093d-438dfb0c2f9f	d9482781-428b-2a2d-fcf8-438dfb95822e	2005-11-30 19:37:09	0
618b506f-b2bc-a643-4d1a-438dfbc37f66	5b185c6c-2163-eb0f-09c2-438dfb2bd66b	58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:37:09	0
671e68a6-37fc-bc46-2022-438dfb4c5346	635d681a-0a85-d4d8-e099-438dfbcb8015	58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:37:10	0
6ccbee9e-f409-57db-8aa4-438dfb7ddcf4	68fd97f2-3bf3-de0a-1484-438dfb7ec0f3	58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:37:10	0
72454aca-b171-d24b-dfa3-438dfbc43268	6e93e4c6-21ab-46f1-5641-438dfb60b108	58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:37:11	0
77d1d41f-52a5-7516-b1b5-438dfbff4aee	741fe7ad-6bc7-4498-36ae-438dfb9f13af	58317a7d-2ddc-3c98-219b-438dfb5f9207	2005-11-30 19:37:12	0
92f81895-8c6b-617d-badf-438dfb154b10	8f342f46-0b2f-0946-624d-438dfbeebd7f	8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:37:12	0
c37db696-24c5-74e3-0c4c-438dfbaf31e1	bfbaf9f8-26b0-afb5-0130-438dfbf4542f	8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:37:13	0
c8f9866b-f2be-9cae-195e-438dfbc41356	c548d85d-0e80-9be5-ba8f-438dfb480fc4	8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:37:13	0
ceaca83f-5d31-7132-2b7c-438dfba1f65c	caeb32f5-f255-60d5-1664-438dfba39bd5	8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:37:14	0
e975bd82-6924-7138-5919-438dfb3ba4f3	e5b280cb-69ea-8896-9d6f-438dfb711d32	8c34dea4-f951-5167-dbd9-438dfbe8ee7a	2005-11-30 19:37:14	0
104b0ba0-f88c-2d57-88f9-438dfb91a13a	c8720a71-42c4-130e-111b-438dfbe2bd40	9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:37:15	0
1609e0cd-6041-b314-12a3-438dfb27a0a7	12153937-e7f6-82f3-cb93-438dfb041bdb	9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:37:16	0
1c8b6e18-4ddb-863e-5c5a-438dfb799b4d	18c1a693-468d-e35b-4b13-438dfbc51494	9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:37:16	0
22300f91-ce80-c310-7a92-438dfb8808d2	1e5a1ea5-ddb9-c6c3-4229-438dfbd70f38	9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:37:16	0
6ad506e7-7d29-60d2-058d-438dfba35393	6701c380-0b9e-e45a-7361-438dfbd5a786	9a350d13-6edf-b916-ec0b-438dfb2a07af	2005-11-30 19:37:17	0
8d8d19f1-7a7d-8b4c-2b02-438dfb02a8f7	89d402a7-f728-b588-efc5-438dfba1ddb5	86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:37:18	0
b5c30d1f-2fbd-ec46-841e-438dfb1cc7eb	b1f7c94a-347d-3f56-c11f-438dfb29d97d	86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:37:18	0
bb4ae70e-4b3b-2cfa-7fc3-438dfb7c83de	b79126bd-5af7-45ea-8e3a-438dfb1ff031	86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:37:19	0
c0de7685-1c93-6c85-1e6b-438dfb24d39b	bd1595d1-bbb9-074c-64d1-438dfb8f37b8	86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:37:19	0
c66017b3-6df9-f49a-2b26-438dfb38a343	c2a9de6b-ef0e-b577-7e42-438dfbf806cb	86de1521-2c63-1031-db6e-438dfb2ead4e	2005-11-30 19:37:20	0
e28b076f-bbb7-2ef9-f293-438dfbc4dd3b	decfea1e-bc23-5e3a-8b14-438dfb258796	dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:37:20	0
99690f43-8eb3-b11c-0897-438dfbb5c2cf	5c830f98-f92c-b222-b653-438dfb0b46d1	dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:37:21	0
f1010205-ef92-ef17-8cc9-438dfbfc0fec	b694066f-9c55-fa69-c71f-438dfb5827b8	dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:37:22	0
1490288c-9446-04a8-f6ab-438dfb713bdb	10d873d9-0ede-3467-01ed-438dfb65a1ce	dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:37:22	0
45415921-f62a-5b18-e4e7-438dfbb81780	4183bd41-4040-820b-b490-438dfb316290	dbdbd11a-09c0-9969-15bd-438dfbe7c1c9	2005-11-30 19:37:23	0
630110de-f08d-a406-4d05-438dfb16b40d	5f5058b6-8f9f-6cd4-37c7-438dfb4dc710	59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:37:23	0
7e1b0cd9-efba-a026-a3c5-438dfb0c335f	7a6f3eba-dd62-603c-3207-438dfb1e1666	59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:37:24	0
83864b54-4cf2-4202-a367-438dfbda1ab4	7fda0b1a-8352-3afd-0b4c-438dfbe6af85	59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:37:24	0
88fe1249-8e44-5508-13bf-438dfb439012	8547f4d6-69a5-7755-8446-438dfb517e64	59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:37:25	0
8e53ea7a-711b-0d96-70be-438dfbfe872b	8ac1bee9-3bea-4641-242b-438dfbc93845	59934fb2-8e1b-67b2-22ba-438dfb7f0116	2005-11-30 19:37:25	0
beb5529c-21c7-a90d-dd2f-438dfbaaf53c	bb0aa455-18d9-759a-a0c8-438dfb4ebfcd	b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:37:26	0
c42784b8-8058-9c7a-fdc9-438dfb22ecab	c0861aaa-6d17-1c3c-83d6-438dfb05fe0b	b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:37:26	0
c9884334-f45b-dc33-a399-438dfb963adb	c5e74cb9-e7d8-51f2-b263-438dfb6eb584	b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:37:27	0
cef44734-53c7-34db-d9d0-438dfb0f832d	cb4d48e2-20cc-c147-594f-438dfb791db4	b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:37:28	0
d446c5ee-f446-a026-097f-438dfb3c8dce	d0b00a5b-0ddb-445a-c2ff-438dfb0068c8	b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4	2005-11-30 19:37:28	0
eea11a4b-bcbc-62cb-5f4f-438dfb301d54	eafefd48-ae53-b4dd-5bab-438dfb873308	e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:37:29	0
15bf4db8-2257-ea30-379d-438dfb7b9163	12120867-77e2-2d4b-cc6b-438dfb5d7d7f	e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:37:29	0
1b33239d-3de1-88ee-4206-438dfbf67e6e	1782804b-5d91-7a39-fc97-438dfbf1f14d	e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:37:30	0
209c3855-1c37-d279-1ce4-438dfb3d0630	1d044f2d-36f4-5167-2804-438dfb977468	e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:37:30	0
260ba70e-c91d-2f03-22b2-438dfb0b9127	22694a74-462e-57b0-06bb-438dfb6bb0da	e8246f0b-bbcf-612a-b608-438dfb437293	2005-11-30 19:37:31	0
409c9128-809e-194f-d0f2-438dfbda955c	3cfa1c03-b31d-a020-f755-438dfbc99d1a	39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:37:32	0
461fc77a-29bb-ebe6-6497-438dfb28a8ce	42682219-0806-7cc7-d293-438dfbf7d02a	39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:37:32	0
4bb80268-592e-646a-848e-438dfbaad613	47f97532-b34f-463d-c710-438dfb6ff01b	39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:37:33	0
511880b3-43dc-2b6d-5a66-438dfbac3915	4d7cb39e-3bdc-6b9d-35ba-438dfbcc348b	39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:37:33	0
567dd641-0ec1-1cb9-4eda-438dfb6a803c	52def52d-2152-b6eb-12ef-438dfb95f67c	39eccd8b-876e-5ed7-ac0e-438dfbc35d74	2005-11-30 19:37:34	0
737d3c68-9db9-087c-363e-438dfb7d07cf	6fd7c53d-04b6-f8dd-58ba-438dfb458a1a	6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:37:34	0
8edf4b7c-a9c9-d976-117b-438dfb43891e	8b44f2bc-7b59-1c35-2287-438dfb1e8ab8	6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:37:35	0
9455298e-9eaf-0a71-1dde-438dfb692979	90b90bdd-85f0-2fae-4fff-438dfbb0dfbb	6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:37:35	0
99c7e6c2-6fb9-d152-b44a-438dfbac8604	96261b2c-8239-1860-d1e1-438dfb4fdbb8	6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:37:36	0
9f368d3a-366f-b9c6-54a8-438dfbe5a720	9b84c5c7-8925-474e-bf50-438dfbf32dc6	6ce495ca-809d-4c8c-9bec-438dfb099655	2005-11-30 19:37:36	0
b9befc80-9fe1-847c-ad23-438dfb9f6b5e	b613c86e-29ef-4b54-05aa-438dfb0417b5	b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:37:37	0
bf39bd3c-9930-6762-7732-438dfb4b46ea	bb84be41-cebc-6180-a466-438dfbe7c0d1	b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:37:37	0
c4a615e8-983f-7eb7-26ec-438dfb042b98	c10ce721-c7f6-d9e4-5206-438dfb44b552	b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:37:37	0
ca04014e-141a-3412-e3c6-438dfb4e6a09	c667bac7-84c2-5713-5221-438dfbf9bcb7	b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:37:38	0
cf853bb0-65de-8937-e699-438dfbaf0bfa	cbce3d2a-7d01-633c-657c-438dfbb003f2	b329a1fc-7bcf-8d63-4257-438dfbf15f68	2005-11-30 19:37:39	0
e9db2783-99fc-ee46-cf82-438dfb5be877	e627dc0e-cc0e-8401-f7fa-438dfb0eb700	e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:37:39	0
ef4077dd-8ff4-d9b6-29a1-438dfbb65215	eba4e3e9-aa39-64c8-f2dd-438dfbf3d36d	e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:37:40	0
811006a5-d0cf-bfe8-db01-438dfbbef117	f10619e3-0ef0-d6bd-d967-438dfb14645d	e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:37:40	0
5e1e05ab-b38f-38f1-4f47-438dfbd74f92	24460680-7951-7a7a-3ce6-438dfbb28741	e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:37:41	0
b4a80251-961e-a50d-5e2a-438dfbe77efb	7a9c0ad6-cfaf-c601-7840-438dfbf56098	e339f5c5-b133-c664-9d25-438dfb5a24c6	2005-11-30 19:37:41	0
2696c76f-3390-729f-6e7a-438dfbb321cf	22eb738b-6f3a-1dec-3dac-438dfb39d0bb	1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:37:42	0
2bf949de-8e0b-c4a5-9f00-438dfb79d14f	285d013c-3ca8-d76e-dcf1-438dfb9ee3a4	1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:37:42	0
316a1088-2e7f-9665-4bbf-438dfbfebd25	2db936bf-8ccd-77e9-e106-438dfb4540b5	1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:37:43	0
36dbdab4-61f5-5e93-c550-438dfb0b4e54	333a2142-4e8b-dab1-88f1-438dfb2e945b	1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:37:43	0
6b768a14-1bb6-115f-4bd4-438dfb753db4	67c2047a-fa11-380d-e056-438dfb0feef3	1fed618e-f94a-e3c4-374d-438dfb59d0df	2005-11-30 19:37:43	0
85deb7db-4a24-4cd7-f74e-438dfb99870a	823484ae-b59d-a71d-f718-438dfb8718d4	7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:37:44	0
a1ac2da9-ea33-d385-0e58-438dfbac4acd	9dfdcf26-2f3e-ae5b-a2ad-438dfb2425b7	7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:37:45	0
a727de86-e5a8-1ced-eecc-438dfb53f6fa	a381c154-326a-e1df-ccea-438dfb895eeb	7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:37:45	0
ac913c36-1b2e-a8a5-f7d1-438dfbc65365	a8f9d064-e22b-bd12-47d4-438dfb415306	7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:37:46	0
b1f2be5b-6adc-8e6c-e17c-438dfbc156b7	ae51237e-25f2-93df-a471-438dfb05501c	7f50d6b5-430d-df28-c8a6-438dfb84bffa	2005-11-30 19:37:46	0
cc406017-3d7b-3fe8-fe0c-438dfb0b7845	c89e46ef-a17e-25a2-7e0b-438dfbd0f2fe	c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:37:47	0
d1d00d33-6bfa-a4a8-9d25-438dfb702a14	ce2fbaa7-7704-a80d-2949-438dfbfe37b2	c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:37:48	0
d735a872-34ff-88fc-b63a-438dfbb5420b	d39a65f7-f15a-184b-5891-438dfb71057e	c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:37:48	0
dc9324a4-2bd4-d2b3-1f28-438dfb582796	d8f46b8a-d8a3-55be-606d-438dfb42587a	c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:37:49	0
e1e1b110-de5a-1594-1c0c-438dfb9952e0	de5399fa-30f7-44d3-6174-438dfbdc22f7	c5bdbb77-f107-f5c8-e8b9-438dfb7acc06	2005-11-30 19:37:49	0
82c803a0-604a-f018-7bd5-438dfbfe2843	47b00b80-8fe9-f5b0-e3d0-438dfb34803b	19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:37:50	0
da650b15-436c-42d4-e3e2-438dfb4fc2a8	9f5c08da-1709-4576-bc36-438dfb8c1288	19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:37:50	0
12fbfe7a-7680-0720-3668-438dfbe92e1b	f6800dfc-f9b4-6286-98a2-438dfb318d6f	19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:37:51	0
188ab6f0-1f89-557f-f56c-438dfbe33672	14cc97ef-480c-1fa4-dcb3-438dfb4cbed1	19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:37:52	0
1dfb98ed-1b3e-b580-92d5-438dfb0683b8	1a567cc3-4912-cc24-def2-438dfb6509a3	19000da7-6ebc-31b9-14ae-438dfb8689ca	2005-11-30 19:37:52	0
3874e695-c6a5-2504-9ca4-438dfb4c8313	34cf3267-3594-f4a2-022e-438dfbcf731c	31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:37:52	0
3dfe8757-87bf-3986-cb96-438dfb16be6a	3a43bc26-eb2a-f75b-d84d-438dfb1377d5	31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:37:53	0
436b28d8-2285-0f67-7108-438dfb4f19fc	3fcfe97c-0e61-14cc-963f-438dfb0efd08	31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:37:54	0
490cd8b9-f977-5b97-b39a-438dfb411550	452e8a44-279f-50c5-565a-438dfb55dd9c	31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:37:54	0
4e945125-d77d-0e5d-0b35-438dfba52d7f	4af6f9e9-0960-38bb-c852-438dfbf10a56	31f324b0-84e2-e496-0b6d-438dfb467fdd	2005-11-30 19:37:55	0
6ba15a35-1938-7929-5dfb-438dfb05fcc1	67ea50b1-9e88-03d1-45ba-438dfb55ffa2	6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:37:55	0
7116bd4c-bb52-7d77-8e9e-438dfb5aeb41	6d72f805-4580-7d61-a962-438dfb23cf88	6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:37:56	0
767c21f8-c0a2-f6ed-6f1c-438dfb482764	72e116f5-12f2-87ab-6c6e-438dfb9089f7	6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:37:56	0
7bde7ecc-abd9-0b8c-27a0-438dfbe37fc8	7848ed21-801e-18b7-1c52-438dfbf79b4e	6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:37:57	0
813b922a-7b03-dd5c-be0e-438dfb228302	7da598bb-c289-227b-d14e-438dfbeafee5	6509922d-d234-5fb0-6ac8-438dfb659f47	2005-11-30 19:37:57	0
9bb63561-0fd7-7e08-71bb-438dfbae66bb	9804a971-2528-84ef-5a96-438dfbdc83f6	95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:37:58	0
a12bffce-9fed-243a-9494-438dfb464760	9d8d9155-b4ae-fd36-3707-438dfb19caf4	95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:37:58	0
a69fc045-233c-19e9-2158-438dfb8ef51e	a2eb376c-a0b8-c4aa-69d9-438dfb0dd608	95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:37:59	0
c2c0d489-7f4f-f348-98c5-438dfb7d156b	bf2495da-4b94-bf88-0c71-438dfb8bb39e	95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:38:00	0
c827689c-1731-5d25-2d40-438dfb989f63	c48f9e2e-65ee-d305-e434-438dfb292018	95054470-16de-54b4-32e6-438dfbac2b9e	2005-11-30 19:38:00	0
e29b1489-7dfd-ed9a-7b00-438dfb1d1f6f	deffb420-020a-ee8c-190a-438dfb6e3696	dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:38:00	0
e823f493-f0b4-ad7a-e057-438dfb42092d	e47503ac-61a5-5f69-1805-438dfbb8c805	dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:38:01	0
ed8d383c-8af1-23a8-457e-438dfb4440cd	e9e85339-2fbd-5d50-1073-438dfb4f752e	dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:38:01	0
f2ed5e43-f6ac-ba93-356b-438dfbafc40a	ef58edbd-409e-07b5-ec4e-438dfbd032c3	dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:38:02	0
42b9052e-f109-58d1-fadc-438dfb6afebc	85300995-e93a-29ce-7aaa-438dfb293880	dc18087d-3c5a-3a97-250b-438dfbe74cbd	2005-11-30 19:38:03	0
1e86e986-089c-dfc2-5404-438dfb9dc18f	1adf1ef6-923c-95fe-5c56-438dfb15e924	17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:38:03	0
240380bf-6252-81bc-b5bd-438dfb650b3c	204e67eb-5d10-c900-7946-438dfb38f735	17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:38:04	0
2970ff3b-0194-180e-8463-438dfbd3810c	25d16353-60de-61f5-6e95-438dfbfc8c5c	17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:38:04	0
2f010bbf-d6cc-57c9-2340-438dfb8a5786	2b643067-324e-45c7-96fd-438dfba0a7b8	17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:38:05	0
347b0ce5-4788-4246-a84e-438dfbefbbf9	30c081f8-8810-d20b-dc96-438dfbb522ea	17f0e87c-b18d-de19-c127-438dfb484b0e	2005-11-30 19:38:05	0
4f17f12a-660b-f9b6-0eef-438dfbc4148e	4b7319b2-5c21-3811-7e5b-438dfb9a22e1	4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:38:06	0
54846f44-0437-9524-3431-438dfb47ded9	50e302fe-afa5-c9b9-1f6e-438dfbbc2f66	4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:38:06	0
59f611d0-4311-62bf-93c0-438dfb17a4ce	5648f0c9-d26c-af13-912a-438dfb82a24f	4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:38:07	0
61eb60ac-6bcc-c0fb-4c19-438dfbb907a2	5bb94405-3ba3-0d85-eb29-438dfb37bb6d	4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:38:07	0
6750c0c8-c214-e53c-bc28-438dfb474c1d	63b582b6-4ba4-b050-44e2-438dfb311641	4866d31a-888a-51cf-a799-438dfb30643e	2005-11-30 19:38:08	0
81b770c9-2a89-767c-fed3-438dfb59af30	7e1c3b65-3bf9-5bdc-3c64-438dfbc6edd5	7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:38:08	0
8786df8f-eccb-80a4-ca7b-438dfb3fd7a5	83e3e29b-d91b-cdf7-b604-438dfb547e9f	7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:38:09	0
8cf467a4-8853-0277-5633-438dfb992b7a	894f56d0-3886-427b-b74f-438dfbf3c71f	7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:38:09	0
924dbda8-52a2-19d2-e5c7-438dfbe26700	8ebb7901-7f64-c247-72dd-438dfbfb329d	7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:38:10	0
982d42e3-fa9d-a5bf-2bfe-438dfb09e1d1	948abf1f-660d-891d-1356-438dfb431d0e	7b321c4c-7815-b632-cf04-438dfb64fe0b	2005-11-30 19:38:10	0
b2c3cf34-005a-9972-eedc-438dfb27d25c	af1f1b56-a155-5422-5dcc-438dfb27385c	ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:38:11	0
b83c1aea-e8a6-2290-c3a8-438dfb47222d	b48b5bf9-c227-e654-fefc-438dfb95d446	ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:38:12	0
bda76934-a9e0-1b49-4940-438dfb958a2e	b9fcbd01-869c-8d78-c556-438dfbea5b1d	ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:38:12	0
c37a6b3c-3c11-5e2d-dfe0-438dfb7f21c5	bfe33a75-9f01-7005-4900-438dfba5bebc	ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:38:13	0
c8e93d0e-62fc-eb3b-b071-438dfb1043df	c54bcc30-7560-a7fe-077e-438dfbb3e507	ac3d7e95-9f69-ad88-3bc8-438dfbb70424	2005-11-30 19:38:13	0
e48458b3-c237-7419-015e-438dfbdd213f	e0cfdc0e-22bb-190b-1b1d-438dfbaa3638	ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:38:14	0
ea0efb28-6af5-1812-07b5-438dfb10b71a	e65760be-032f-58cd-9258-438dfbd15f42	ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:38:14	0
ef66221a-4d70-7f6f-a437-438dfb8f01d1	ebd0d5a8-309e-be4f-de02-438dfbcb5c83	ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:38:15	0
c0d006cb-ff38-3549-7dc9-438dfb2f2803	f132f44b-3ebe-0e8b-97a4-438dfb380c08	ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:38:15	0
6b07033e-d891-cacd-d39d-438dfb39e30d	318d0424-41cf-24a5-e718-438dfb6fa17b	ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8	2005-11-30 19:38:16	0
2141630a-3318-48ab-d495-438dfbaafd2e	1d8c2b98-7a84-5a23-8966-438dfb0df830	1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:38:16	0
27877ca6-2092-2d21-4fc1-438dfb3b349d	23e05a6f-4a8f-5e73-e22c-438dfbce136d	1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:38:17	0
2ced7c88-72e5-9337-4d97-438dfbaab22f	2949e2d6-0390-1857-c7f9-438dfb5b2049	1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:38:18	0
3249a31f-0930-5f8b-50d0-438dfb105060	2eaca474-24a2-1938-3fe8-438dfbd83628	1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:38:18	0
37bab476-db3c-14cd-e8c8-438dfbbe45cb	34126279-c05a-6e6b-a5d2-438dfb551db3	1aab927c-fd16-de4f-4b33-438dfb6f7451	2005-11-30 19:38:19	0
52a42b42-0e58-8239-08a2-438dfb503f75	4eebb963-e46a-e211-3010-438dfb35fe7e	4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:38:19	0
58152690-22ab-0a4b-e2d1-438dfb502e59	54729de4-568e-fb85-daf2-438dfb48f621	4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:38:20	0
5d7cc1d1-8e88-ddb7-3e0c-438dfb5ac19a	59e40c9b-7a4d-2b14-26b5-438dfb9197af	4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:38:20	0
657fb729-c2b4-dabd-5370-438dfbed9524	61ddb4b3-1318-40d3-ed23-438dfb93d29a	4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:38:21	0
6adf87e6-9d94-82a2-4d82-438dfb55c1cd	673e85a7-bc0b-e1ad-672b-438dfb44eef6	4c0b8c40-4533-109f-aeda-438dfb6379ec	2005-11-30 19:38:21	0
85261b84-ae85-d654-58f9-438dfb9d9494	81866f3e-0745-63a9-1a05-438dfb46b908	7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:38:22	0
8a9e7a8f-19b8-1202-495f-438dfb10a334	86ec0f0f-998d-c65d-2b49-438dfb4e3412	7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:38:22	0
8ff92209-f621-272b-1902-438dfb08f014	8c5dc2c1-4a64-33fb-482b-438dfb729da9	7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:38:23	0
957629b7-7afc-f3ca-b4f1-438dfb4f2497	91ccc35f-cfa8-9049-da16-438dfb854a98	7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:38:23	0
9ba1eb44-49ad-f85c-b5e9-438dfbf2446b	9809a5d1-a698-ef70-f2e0-438dfb3c289a	7e9f6827-6e0c-f188-75c5-438dfb8b79a9	2005-11-30 19:38:24	0
b624c295-6ab7-99b2-f08b-438dfb8d79e4	b275fa94-f1bc-8902-f257-438dfbdd5f1e	af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:38:24	0
bb92023e-1a51-fe87-ca8c-438dfbe833df	b7e62a3a-4953-16dc-fdb2-438dfb061ae8	af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:38:25	0
c0ec7c23-80e6-cf4f-2353-438dfb235271	bd4f5633-adb7-d6b3-de29-438dfb2d8db4	af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:38:26	0
c64760ed-dcd3-615b-e1f2-438dfb55b51f	c2afa4c0-88e6-3870-3d2b-438dfbc1a949	af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:38:26	0
cba8d909-4805-5684-fcdd-438dfb427977	c808cef5-034a-9c41-e98d-438dfbeff94f	af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae	2005-11-30 19:38:27	0
e7ca348a-f4eb-bbbf-fa13-438dfbddabe4	e420dfad-7d08-313c-fd56-438dfbff49c5	e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:38:28	0
ed4cf086-cfa7-d54f-3c8a-438dfbd5ee7a	e9a9a3b1-7af6-4489-dfa2-438dfb3655da	e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:38:28	0
f2a1440a-2bc4-4be3-adad-438dfbc8a483	ef0da275-26fa-eb88-2ecf-438dfbe40212	e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:38:28	0
3f8407d7-a130-b78a-61d2-438dfb38b868	49300d93-f2c3-22dd-e72f-438dfbf09d83	e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:38:29	0
963802cc-7b27-d287-3af2-438dfbd3e4e4	5b680515-7739-b65b-a7d2-438dfb4de1f3	e1416852-2539-0461-eb2f-438dfb5f540b	2005-11-30 19:38:29	0
23e89d9c-1cf7-cb70-c554-438dfbbdc671	2029d463-0ab2-4196-9a89-438dfbad6406	1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:38:30	0
2960ad32-ad66-0e69-9230-438dfb98726d	25aecfc2-58d1-f82e-0e41-438dfb6c20e0	1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:38:30	0
2eb606d0-70e0-ddc7-2960-438dfb8f70de	2b203015-949a-ec46-76b9-438dfbca7928	1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:38:31	0
3547c25a-23db-d1c8-2ef8-438dfb0433bf	318fe1d9-df0c-2945-9104-438dfb54eee5	1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:38:32	0
3aa7c910-1637-268f-e50a-438dfba8a3f2	3706fc47-0897-c52d-15a5-438dfb215377	1d41932b-182f-9f4d-af30-438dfb9faa94	2005-11-30 19:38:32	0
552b410e-42c6-2746-b50a-438dfba94411	517f6273-70de-3fd6-f1b0-438dfbdc6db0	4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:38:32	0
5aa7d1b7-0574-06a9-23c6-438dfb3f8a8c	56ff8e0d-89ef-fbe2-5c6f-438dfbc37f07	4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:38:33	0
62a71f87-7f2d-4207-f10d-438dfb9bd0ef	5c69d361-f958-a74e-b840-438dfb571c46	4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:38:34	0
692d4a6e-ac57-ff42-69a6-438dfb9ad243	659d2543-ecaa-da86-1539-438dfb964de6	4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:38:34	0
6e93322d-79ee-c90d-faba-438dfbb1812d	6aed85db-efa0-ff84-a4b1-438dfbe911be	4e9f154d-16b4-238c-5348-438dfb689c29	2005-11-30 19:38:35	0
88fe341d-45bd-a56e-7a82-438dfb61c92d	85516e4f-1050-113d-23b8-438dfbc6f27d	8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:38:35	0
8e6cacf2-4f3a-4276-df7c-438dfb1328aa	8ac6d175-ddbf-bf97-46eb-438dfbd3b32d	8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:38:35	0
93d7a3a0-48fa-f643-15e8-438dfb2627b1	9035c821-2501-dfe0-d6a0-438dfb88a4ab	8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:38:36	0
9a7ed157-8cae-ec63-b511-438dfb4e0954	96e5c77f-92c3-57f2-47da-438dfb219fbf	8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:38:37	0
9ff68535-9520-b4b8-bc0b-438dfb0b6bdb	9c5a843b-fa9c-a764-833e-438dfb4f7871	8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1	2005-11-30 19:38:37	0
bcf80d53-542c-0e06-ccef-438dfb9f7ed0	b94d58d6-8437-67bc-87a2-438dfb4d350c	b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:38:38	0
c25d04d7-ea37-7b09-c1e1-438dfbe3342b	bec4dd4b-f957-ed9d-28ba-438dfb63674a	b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:38:39	0
c7ba6223-3d42-6dfd-6a6d-438dfb24af54	c4174fc1-786a-23f0-9a6a-438dfb4d914d	b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:38:39	0
ce79ebb2-4152-c6c9-7adb-438dfb5984c9	cad814b5-e92e-c084-f877-438dfb836c62	b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:38:40	0
d3e7a0ad-37c9-7047-4261-438dfb19415b	d03fdcb7-65b0-c33e-4bb8-438dfba4a48f	b65cd00d-729a-34b7-35ed-438dfb9a9bc9	2005-11-30 19:38:40	0
ee47a155-acc7-685a-e4a4-438dfbed774c	eaabc3e4-3a3f-3d2e-db26-438dfb733205	e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:38:40	0
f3a8f33f-f94e-6cfe-1444-438dfb61b1c7	f00bc55b-e303-d1e7-b491-438dfb1b5748	e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:38:41	0
66cc0a56-eb31-750d-5af9-438dfbc71673	2c9d0481-694f-f754-12f0-438dfbce1bfa	e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:38:41	0
be7909a7-4dea-906f-8420-438dfbd0047b	841505e9-de6f-053f-6cf1-438dfb7e56ef	e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:38:42	0
11503083-a2dd-546a-ba3b-438dfb40b42e	da0d017b-1969-1188-3e5a-438dfb138b10	e7af64ad-bd00-43de-eae6-438dfba53d59	2005-11-30 19:38:42	0
2c5206fb-10db-752b-f38f-438dfbb2f301	28728ff7-5c26-04e4-d907-438dfbf50af7	25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:38:43	0
31b70cd0-fa75-a111-de4e-438dfb295437	2e1bcee7-9f6d-a7ed-ce00-438dfba44dd1	25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:38:43	0
3731b007-e76d-a5f6-263d-438dfb955ef6	339340de-f7e9-269d-c241-438dfbab2354	25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:38:44	0
3c9bb090-b76c-7f1b-c1a8-438dfb780099	38f58c9a-68f4-1beb-506e-438dfbaed227	25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:38:44	0
41fe9c19-5e96-06b2-3b5d-438dfb144c79	3e578cfe-0c42-b027-3a89-438dfb05b4bc	25741180-9b0a-6d59-d2a5-438dfb18643c	2005-11-30 19:38:45	0
5c938f24-dcb6-a1cb-1cc6-438dfb4884c6	58f72bed-b3e4-6a46-5cf0-438dfb834a90	56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:38:45	0
64c6e4cf-eb44-d314-43cf-438dfbbb8c0f	60bf291c-0622-1661-3217-438dfb7e3c1f	56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:38:46	0
6a258b10-8648-a9f3-9372-438dfb8e39a0	668f1551-6507-e0ff-b54f-438dfb37cd36	56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:38:47	0
7149d766-cc9c-ee12-29dc-438dfb17fd61	6d92e8ee-cce2-d518-f789-438dfb75e1fa	56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:38:47	0
76a103d7-4bfb-a961-e00d-438dfbdffcf3	7313f552-4516-f8f3-d921-438dfbc20ce3	56062170-fdae-2ecd-1d09-438dfb6bc554	2005-11-30 19:38:48	0
910106b8-d825-93dd-2c9e-438dfbdf383b	8d6ba11a-d4b5-4c1d-2b57-438dfb7c7704	8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:38:48	0
967928d4-12b4-dc54-5eab-438dfb02d2e0	92ce4c0e-4e77-d5ff-7fb1-438dfb3e365a	8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:38:49	0
9bec6ea4-d027-82a0-ccf1-438dfbc8ddc6	983bf203-c247-3f0d-47cb-438dfbf6c2ae	8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:38:49	0
a314fdb4-08ac-8ca6-9b56-438dfbc8adb4	9db5ce77-50c4-9063-1c79-438dfbe9e863	8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:38:50	0
a89908d4-aae0-6286-af1f-438dfb7a80b1	a4e0268c-dcaf-2179-fb55-438dfb2be9cc	8a826d91-bce7-285c-8ab8-438dfb3f96e0	2005-11-30 19:38:50	0
c2f56c2c-9e70-566c-d9e6-438dfbbf5eca	bf448f45-7a42-6862-c22e-438dfbc964a9	bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:38:50	0
ca25d212-1042-35cb-598b-438dfbf0d124	c68a2448-4fbe-be0f-2dea-438dfb6f39e5	bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:38:51	0
cfa333e5-bed8-a4ae-d989-438dfb7fed4b	cbeaee1e-18d9-87cd-ea49-438dfb46e38d	bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:38:51	0
d5824709-1939-9103-1f86-438dfbc9a16e	d16a5cea-ee4e-7878-a4fd-438dfbb31bce	bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:38:52	0
dadcf471-6fff-9c60-36d6-438dfb62204d	d7410d8c-1529-3fdc-2fa7-438dfb4ddf06	bc63a675-5703-c072-d39c-438dfb5cbdbb	2005-11-30 19:38:53	0
117702dd-4fd7-e03b-4bee-438dfbcc45cb	f1a11eb8-f859-e74f-646b-438dfb5c6395	eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:38:53	0
69a40a13-92ba-a8d7-8e91-438dfbaafba3	2f8b0c03-af07-b288-85bb-438dfb8a0805	eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:38:54	0
bfdd0c43-eaf4-b83f-f42f-438dfb5931db	86750c32-c880-08f9-d69d-438dfbb78a52	eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:38:54	0
11711a4a-42b1-6d4d-858e-438dfb543a66	dbec0e59-d084-ea6f-48fc-438dfbcf5ed9	eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:38:55	0
1aa31eb4-4f31-18bb-8a72-438dfb9bfae4	16fef216-ab8f-1b67-908b-438dfb062553	eec2024f-aca5-cc51-a9f0-438dfb18062e	2005-11-30 19:38:56	0
35503e62-784b-5a87-3bf4-438dfbceca80	31a9c015-a559-4324-569f-438dfb4027fd	2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:38:56	0
3ab4fa37-106f-a23f-3695-438dfbba8ea1	3713df17-bca3-eeb3-a895-438dfbe2805e	2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:38:57	0
402093aa-5917-c144-46c0-438dfb17a93c	3c77d657-9b5c-2979-b1f9-438dfb9b055a	2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:38:57	0
457e01b3-f064-f00e-50a3-438dfb751859	41ec6516-7d24-e7fa-6a68-438dfbb9818b	2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:38:58	0
4ada2496-a945-c6f2-bb64-438dfbfbb758	473d3fcd-b253-bcda-f47f-438dfb562fbe	2eba6615-e135-9bb5-71b8-438dfb829629	2005-11-30 19:38:58	0
680a18ca-324c-cfb8-fff9-438dfb3705f3	6468ece6-b5ed-5763-56de-438dfb928544	616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:38:59	0
6f84d8e3-1ac4-1c6b-d5b4-438dfbf6dab9	6bf1c2d4-f9c6-ac2a-a1e7-438dfb09957a	616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:38:59	0
75002d26-6400-37d0-1c59-438dfb50683f	716076db-c8f9-7b1b-1f44-438dfb6e6551	616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:39:00	0
7a5da571-4e46-cb36-4a8c-438dfb88adb1	76c1a073-b0ac-091d-dc41-438dfb3a876d	616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:39:01	0
81d841be-d81c-940e-58fd-438dfbef2a4e	7e2a8a21-8774-0b5d-f94a-438dfba0fd29	616b518a-544d-0883-cdd8-438dfbe9c092	2005-11-30 19:39:01	0
9c351086-2c62-5beb-79db-438dfb6067d7	98919c57-aea6-d204-86aa-438dfb812d25	95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:39:02	0
a3d29e80-8cba-31fd-3d10-438dfb4952bc	a01e59cc-da8d-b849-eb16-438dfba9e2cf	95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:39:02	0
a960f869-8c8e-c6c1-62b5-438dfb66253a	a59125d9-f91e-a6cc-9535-438dfbbb9823	95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:39:03	0
aeaec741-7f90-2f0b-a316-438dfbba392e	ab204151-1d86-287c-0f1b-438dfb8bd793	95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:39:03	0
b41d41c9-e1cc-3f79-1ea2-438dfb7926ff	b0825680-1811-efa6-d57b-438dfb9c676c	95ab83f6-5009-5c0f-41d7-438dfb8a0468	2005-11-30 19:39:04	0
ce7b0a62-54a4-a282-268f-438dfbda5ac2	cae661a3-05b4-f667-ca54-438dfb5600d7	c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:39:04	0
d3f5c046-72c8-4572-7bac-438dfbc3675d	d04d9df6-9ea3-2219-0657-438dfba9ccbe	c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:39:04	0
d965d83f-388b-26a3-657b-438dfb74f986	d5c4ae8d-042b-d864-9034-438dfbd92165	c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:39:05	0
debce10f-c11e-d79b-dec9-438dfb37476a	db2a3986-b8bd-1992-f02a-438dfb0d4821	c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:39:06	0
e418207c-797b-2da8-7d39-438dfb6b16da	e0860326-7573-8105-35b1-438dfb21b981	c7fcc12b-5997-5960-ccc8-438dfbacf96f	2005-11-30 19:39:06	0
a6cd06b6-7550-ab5e-8273-438dfbdaa3ae	6ba0059b-de92-7819-cd55-438dfb9a7a57	3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:39:07	0
123a2392-27a0-2f56-5cad-438dfb9b05ca	e8d60704-57a5-6480-415e-438dfb1eaf16	3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:39:08	0
17a4155a-dbfd-f257-7d48-438dfb3b150c	1405cc2c-964d-5196-b0b9-438dfbdb1657	3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:39:08	0
1d147bd6-ce2c-c9bd-0ad0-438dfb6474f4	196d85a8-c7d8-d8d9-0ecf-438dfb73a3fe	3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:39:09	0
227dba90-951f-0005-fdd3-438dfb7a9e49	1ee45a02-8bd7-17d4-ebc1-438dfbf0c010	3c910d7e-5182-9ac0-8ee3-438dfb494aa7	2005-11-30 19:39:10	0
41a8e557-580f-cd16-9b39-438dfb97dbb3	3df0de87-0695-04cb-f25e-438dfb1996b4	3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:39:10	0
471db775-aabc-1109-cc50-438dfb143e56	4384983c-8236-33e9-357c-438dfb0e25db	3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:39:10	0
4ca22448-0abb-cf1f-c2d9-438dfb80b556	48d9dd4b-1117-171f-b937-438dfb3990b8	3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:39:11	0
52024924-af18-d2e3-9476-438dfb85c8ec	4e6dd4c0-82e1-63fc-0e44-438dfb3c2d96	3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:39:11	0
5770b235-abfc-6b3d-e9dc-438dfb240cbd	53dc06ae-fe9b-70ad-084e-438dfb3311df	3b0dc215-af7c-b404-0e73-438dfba6265a	2005-11-30 19:39:12	0
748692a3-f244-11fe-3949-438dfb58bf4d	70d3c38b-200e-c8c3-3681-438dfb731bae	6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:39:13	0
7eeb9a72-5589-d0cf-c051-438dfb33b10a	7b3eebf7-fb86-6750-a299-438dfbe64f19	6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:39:13	0
844c941c-8244-bb77-ca51-438dfb73fe25	80ad61eb-6096-2c20-0fc2-438dfbfc69b0	6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:39:13	0
8edbd84e-eaaf-60b6-59ff-438dfb5ed258	8614c89a-e95f-1273-3bb0-438dfbdfdb9c	6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:39:14	0
96baf1da-d013-7d98-b7f2-438dfbd19d79	931c11c4-93ba-a400-699b-438dfbedf69a	6dd767e8-13fc-8646-d64e-438dfba52ba4	2005-11-30 19:39:15	0
b131c688-35ec-87c3-81e1-438dfbe18e76	ad8bcb4f-03cc-52a9-fcae-438dfb7dbfab	aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:39:15	0
b93d07eb-bf69-4d2e-a24e-438dfbfcc80b	b5a16b32-d26c-2ba7-fbc9-438dfb2a0f26	aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:39:16	0
beb432a6-41fa-be27-0c7e-438dfbebd3f3	bb148c13-a076-2d26-8881-438dfb920a77	aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:39:16	0
c41601d8-8cef-ae0f-986f-438dfba88ea2	c07e4ef1-91b9-9758-0013-438dfb3a083f	aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:39:17	0
c9752af7-bd7e-ee40-189d-438dfb6a66f8	c5d18e89-f6b6-dd55-7b37-438dfb4408ed	aaade8ed-539e-25a3-a313-438dfbe29b87	2005-11-30 19:39:17	0
e3e0e290-8276-ff6d-1fd7-438dfbdc2fe3	e0396d3f-b8c9-ff57-775c-438dfbc38a06	dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:39:18	0
e96d5c94-1633-392e-5bed-438dfb5afd3e	e5b4a8fe-2f55-fc7b-9f92-438dfb2a1fc0	dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:39:18	0
eef5ead9-07a7-85cd-6bea-438dfb5ab029	eb3e56d8-210c-e700-20e8-438dfb155596	dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:39:19	0
2d9b00d9-8051-4623-594b-438dfb424123	f3671876-9c8d-9122-d094-438dfbce7cd2	dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:39:19	0
84cc03c6-3622-81bd-d988-438dfb77fc7f	49de073a-213e-897b-8ff1-438dfbe2c3bf	dd4dfabf-5d83-b24d-63ea-438dfb8bcb28	2005-11-30 19:39:20	0
22a9b886-441a-5e04-2ae5-438dfb9cabc1	1f0326da-4f40-c4ba-cf22-438dfbb0c4fc	1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:39:20	0
2812e61a-7289-47c6-bc6c-438dfbbd2416	246be3b2-54e9-932b-b2e7-438dfb7350e5	1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:39:21	0
2d8aa648-3e03-c9af-704e-438dfbf7a740	29d8f59b-b2fc-9c35-9249-438dfb9bf5bc	1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:39:21	0
32f59246-dd0e-e46f-da48-438dfb49a5fe	2f592475-cab4-8738-e9a1-438dfbf52647	1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:39:22	0
3861ef49-4473-4bdd-cf87-438dfb6ea600	34b43f7d-c9c0-cef4-c938-438dfb482a22	1c212a84-fd58-399f-3cbb-438dfb20ae5f	2005-11-30 19:39:22	0
53214435-2d08-099a-2586-438dfbcb22ae	4f884afd-219e-c08f-a9c1-438dfb1c78b1	4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:39:23	0
58905dd2-0915-fd51-70f8-438dfb2807fa	54ed8946-64fb-254c-e0cf-438dfbcdb178	4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:39:23	0
662a83ee-6110-7144-db23-438dfb50fa32	628c5e3d-2ab1-a9d9-2c4d-438dfb5ed857	4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:39:24	0
6b8ae3d2-f0fb-e9c7-319a-438dfb46f7eb	67fb477d-b806-f043-68d5-438dfbd0d5ac	4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:39:25	0
70f023f3-66a0-e0bc-397a-438dfb2917ea	6d4f150f-e191-433d-44a1-438dfbfd01eb	4c8fc584-f156-c149-1e8e-438dfbbb63e7	2005-11-30 19:39:25	0
912aaa6e-ffd9-af6a-ddcc-438dfb88ee0d	8d7b4139-884c-228b-1d33-438dfb5048e8	8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:39:26	0
96984e15-d038-96bd-aecc-438dfb47fa9a	92f43bf7-585f-45b1-4242-438dfb072c5c	8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:39:26	0
9c084223-a1af-b3e1-c0ad-438dfb5429b2	9870c96a-2c4a-d6d0-3e4c-438dfb5c604d	8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:39:26	0
a46934d0-eb94-bc9c-7260-438dfb805f7d	a0b8cbb3-cdaa-b46b-2d9a-438dfbcbc788	8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:39:27	0
a9f35420-b9cb-f47b-3703-438dfb3c2e93	a627f499-0966-33a0-e77c-438dfb6a0256	8a931919-f2df-13cb-44c5-438dfbd0a58a	2005-11-30 19:39:28	0
c45a2863-a6b5-c155-d988-438dfb76d8e1	c0a62ba4-d964-12a6-b0db-438dfb27d88e	bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:39:29	0
c9cc46f7-1ae4-8ca8-a39a-438dfb3bf43f	c6216053-14b8-42b5-8126-438dfb4bd162	bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:39:29	0
cf2c65e7-f9a1-bc58-231c-438dfbb62063	cb88fa26-881a-a1a4-3bd0-438dfbc17e97	bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:39:30	0
d4cdcf80-b2f1-ad4e-b94a-438dfb2b9c49	d0f51eb7-1b91-6fd6-86b6-438dfbc7a48a	bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:39:30	0
da249677-a149-0969-7155-438dfb9f0d68	d68d27c5-4379-6fc5-1d4f-438dfb4c215c	bdc79323-8fd7-f491-7b9b-438dfb8c1b5f	2005-11-30 19:39:30	0
74200123-3123-dc56-6347-438dfbfb4533	f0d5eac1-2b9a-76c7-b7ae-438dfb08190a	edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:39:31	0
64150374-dcd8-6a50-bfc9-438dfbed99b0	24b10624-c2c2-7c3e-24a4-438dfb948309	edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:39:32	0
bc4a0daa-282c-ce03-698e-438dfb3bb41e	80c60690-7654-c749-f42c-438dfba816b1	edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:39:32	0
179913ae-df11-ade0-84f3-438dfbc93e01	13cff5d5-ea75-5fc1-33e6-438dfb9cd92b	edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:39:33	0
1d904bfe-b010-ef3e-6118-438dfb30e187	19d2a4a8-c793-a7c5-d8d9-438dfbef4659	edf9127b-11b7-2911-1c06-438dfb43ff50	2005-11-30 19:39:33	0
38ed1f1e-d664-80f2-0c16-438dfb8c6e1d	3533c1ba-0522-9e29-780b-438dfb5d05e2	323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:39:33	0
3e6ee014-4c7d-deaf-89b6-438dfb00f418	3ab8082a-f3b4-08d3-53a7-438dfbb8a47c	323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:39:34	0
473abb4f-0193-b2ac-5f0a-438dfb440d0b	437c35c0-8a2e-dc8a-9c03-438dfb458245	323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:39:34	0
4ceecec7-7401-5eee-f704-438dfba90d13	491015aa-a450-5e9a-50bc-438dfb40f437	323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:39:35	0
5276d1e9-47a2-3dcd-3839-438dfbed519f	4ebe4ade-9a6b-c785-5253-438dfb75dda9	323ee655-3eae-bfe1-9233-438dfbe035b6	2005-11-30 19:39:35	0
6ff55636-3235-9ef1-5b6e-438dfbe08b52	6c2bbbf0-2222-e3e5-49bb-438dfb127e86	6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:39:36	0
7c2ea555-d602-b98d-19a1-438dfb880d98	786beb1d-6fd2-530d-1d07-438dfb70aba2	6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:39:37	0
81c36814-1705-338a-1443-438dfb1523ce	7e10cada-5ad8-ad91-705b-438dfbd4ad77	6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:39:37	0
87571b4c-1c29-7d56-0b88-438dfbd11607	838d299c-64c4-4c1c-6e47-438dfb61ef45	6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:39:38	0
8cce8e36-b746-7fd8-167b-438dfb2b1170	891bf913-e7f7-7c39-d918-438dfb205a43	6932c080-9997-6e24-8e32-438dfbf0bc6c	2005-11-30 19:39:38	0
a7d9829b-bbf3-1892-a675-438dfb10c2d5	a416b3ad-b6cb-ffe7-c8ea-438dfb871cfc	a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:39:39	0
b0d04158-4008-7073-96c4-438dfb359c76	ad1aaa3d-f371-d79e-a65e-438dfb369e04	a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:39:39	0
b6671d16-67a8-42cf-396a-438dfb49fc6e	b29b1610-5800-415e-bd10-438dfb310b86	a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:39:40	0
bbffb6e0-7ad9-82c8-62e8-438dfb5afbb6	b83e5b01-b8a4-cfa7-3809-438dfb493e34	a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:39:40	0
c17ddf16-5c7f-f5ef-a31f-438dfbf914a3	bdc4c764-75f3-b5fd-d4e8-438dfbef2c8b	a11333b2-e34a-7cee-19ff-438dfb1bb3f0	2005-11-30 19:39:41	0
dffe5d26-ba5a-d22c-bf6d-438dfbf91693	dc3ddca6-cc13-c42e-5dfe-438dfb936a3c	d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:39:42	0
e584fe90-4ede-7b3c-c902-438dfb4a15a0	e1d05b4f-88e8-7402-9982-438dfb254024	d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:39:42	0
ee9e9a08-ae8b-b92f-43a8-438dfb14ee7c	eae44d42-1792-c629-aca2-438dfb490f68	d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:39:43	0
f422aed3-4bb0-531e-8c2a-438dfba5e7e1	f06a235b-9683-eb5b-9509-438dfb4bdc87	d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:39:43	0
57fa0004-9c61-c519-5e7a-438dfbb24a48	1d0f0463-3a95-f2cd-b9b5-438dfb670267	d94554c7-4b9d-50c9-98e2-438dfbe8a5f8	2005-11-30 19:39:44	0
20a80d38-48ec-ff1c-7656-438dfbde7e98	1cd3480f-404c-80ac-5718-438dfb258616	19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:39:44	0
2623a9ed-912e-786b-139b-438dfbed9f7d	22746001-5baa-1712-c27f-438dfbd06e55	19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:39:45	0
2bd13412-9da6-557c-4173-438dfb686202	27ef531a-c412-c74c-2308-438dfbbb48ac	19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:39:45	0
319d9de5-fc02-26f0-572e-438dfb6264c0	2dde6c30-182d-5974-f689-438dfbb23f9b	19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:39:46	0
371baa59-6b47-68fc-0338-438dfb077391	336e48a3-d66b-6fa6-ede5-438dfb6f921d	19d5e398-425e-558e-6d74-438dfbf0fe26	2005-11-30 19:39:46	0
51aa76ca-a4ae-c5a6-ccb0-438dfbf68a68	4dfebb07-b1a5-e1c3-d6d1-438dfb770afe	4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:39:47	0
5e7419e9-ca62-e25e-1df8-438dfbeb571f	5ac776a9-7101-3a8c-5ea6-438dfbed5296	4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:39:48	0
666241d1-f3a3-6af2-d4d4-438dfbee8b3f	62c147fd-ac24-81b0-bddd-438dfbd98235	4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:39:48	0
6bc597b7-2928-f9fa-50ed-438dfb8429f7	682a1b8e-eedb-be2c-1725-438dfb12ba94	4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:39:49	0
74dfc3b3-742b-4e74-3c56-438dfba7c9fc	7143a15b-0a10-656a-0f98-438dfbb0ca94	4af89ff2-afdd-3782-61e3-438dfbb82b14	2005-11-30 19:39:49	0
8f5ead43-ad43-d5ac-6684-438dfb4fc410	8b98936d-0ca5-6be8-c77a-438dfb0a724e	88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:39:49	0
989ac258-7c00-bf2a-3b8c-438dfbcf7ce2	94f0ff3b-2aaa-28b3-cc6a-438dfbebe00e	88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:39:50	0
9e0354b4-0761-92ef-1905-438dfba3c4f6	9a587926-92de-0e22-2b91-438dfb5e78dd	88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:39:51	0
a7280f13-4c81-83bc-f44c-438dfb32758c	a38cf156-b657-30f0-be38-438dfb3c86eb	88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:39:51	0
acc56382-3590-2bc1-68ac-438dfb133a6d	a8fa88ce-7ce0-6797-b247-438dfb7c1565	88ac74b1-6800-3777-713b-438dfbe7d7a8	2005-11-30 19:39:52	0
c7338137-0d89-7522-da20-438dfb228c50	c38dcdf8-b44a-dc82-8211-438dfb09085e	c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:39:52	0
cc92ab9e-7310-4a30-3f91-438dfb48cde3	c8fada79-2ec2-318a-0314-438dfb207ab9	c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:39:53	0
d208b91f-489c-1b1f-7f5b-438dfb78f604	ce5522d4-e39c-4a68-2c70-438dfb89205a	c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:39:53	0
d77f4ef3-ca2e-7a20-8399-438dfb788818	d3ef460e-b9d9-feba-fccb-438dfba81c43	c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:39:54	0
dce719d8-72f7-d41a-86da-438dfbc5ac66	d93a4716-6957-a8ae-8794-438dfb37466a	c09a5ab8-54e1-6916-f816-438dfb8d3205	2005-11-30 19:39:54	0
33070481-80e9-7f4a-4743-438dfbc5dac3	f3b73795-8dee-74c6-42c6-438dfb19be81	f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:39:55	0
ca9c0653-28a6-a885-d610-438dfb187f28	90350b16-71bb-c68a-cca6-438dfb8a7a2c	f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:39:55	0
1211018a-dddf-1593-ccda-438dfb3b7e54	e71d0e9b-73f9-8acd-61b1-438dfb273a9e	f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:39:56	0
17710f4c-9e34-c584-5151-438dfb926cf5	13d207e6-04f0-c7fd-8fd8-438dfbd8bb40	f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:39:56	0
1cd2b252-d5e1-78d4-6d54-438dfbd2420b	1931a25a-a79d-da59-1a67-438dfbccce39	f0c43a56-a365-6fd7-e4c6-438dfbc330f8	2005-11-30 19:39:57	0
3b518fc8-a636-845c-a0b7-438dfbfd92f8	37b7358b-8e4f-6c51-76ad-438dfb979c49	34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:39:57	0
40d2097c-9da4-78bf-6236-438dfbfc956a	3d313e8d-7041-c363-ab4d-438dfb086010	34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:39:58	0
4a4f0ecf-3c0d-c5fd-1bbd-438dfb53e615	46a12a50-59e1-02b6-ac03-438dfb85d723	34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:39:58	0
4fd2d570-9c6a-eeae-da73-438dfb5d08a0	4c1e2f2c-50cb-e7fd-a6ea-438dfb50c80b	34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:39:59	0
553e18e3-321a-3928-2a24-438dfb3f9777	519dbd26-d98a-18b8-ab28-438dfb46902c	34cd4a83-471e-2d8e-17c2-438dfb89a26b	2005-11-30 19:40:00	0
723249a0-b684-ec53-688e-438dfb9cd695	6e8a9318-7110-1a2d-01ba-438dfba2703e	6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:40:00	0
7ba9ab07-eb75-db4a-3fb2-438dfbf38344	7802e8d2-6097-18e4-726f-438dfb84c44a	6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:40:01	0
80fcca66-8ff7-a1b8-8d7e-438dfb2f6d3b	7d652bf9-5a1a-b8fb-67f4-438dfb1fb35b	6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:40:02	0
867a263b-6b23-836e-59cf-438dfba62142	82cb862a-59ab-7b0b-178f-438dfbfa4ffc	6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:40:02	0
8bcbaaf4-0ef9-0ee6-eb9d-438dfb98d427	883807bd-50fc-60d5-25cd-438dfbe60b1f	6b96215c-a64e-cccb-ca71-438dfbec8fc2	2005-11-30 19:40:03	0
a62e4029-b317-d2b3-e431-438dfb9ef0cf	a28cfcdd-787e-a634-ac3e-438dfb60e7ec	9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:40:03	0
abc4b8aa-b189-011c-7d5c-438dfbcb02e4	a7f73907-3967-869a-dd96-438dfb83c988	9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:40:04	0
b12d74a9-5cd7-6337-404a-438dfbecc247	ad917aac-a891-7adc-20d2-438dfb2be658	9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:40:04	0
b6a7302e-2185-1eb7-e112-438dfb57ff3e	b303627a-a993-d355-5997-438dfbe92dad	9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:40:05	0
bc0a17f8-2a6e-2c56-4d59-438dfb4945d1	b86a0705-635c-1eb4-6988-438dfb115e1b	9fa1f669-d722-eea7-c612-438dfbbc06c9	2005-11-30 19:40:05	0
d6a0d59e-8725-cb53-3cca-438dfbcbd079	d2f6f61c-300a-4fe1-8bc9-438dfbff6793	d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:40:06	0
dc1aa113-f6be-cc7c-1db1-438dfbc7e035	d86d22dd-b6b3-bfc8-3a41-438dfbf7c273	d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:40:06	0
e172d223-2e16-359d-7238-438dfbfc0aa3	ddde40bb-00fd-9e1a-628a-438dfbc1a903	d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:40:07	0
e6d555bf-4041-1d13-398c-438dfbc99f2f	e338dd29-107f-e336-b6f0-438dfbb9d179	d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:40:08	0
ec4b2f9c-6800-0526-7b3b-438dfb5ea3a1	e8ab5336-e867-c884-5227-438dfbf59c5b	d000e617-e866-9135-c35f-438dfbda2b06	2005-11-30 19:40:08	0
128e2f76-8b17-be5d-c1c3-438dfb85de90	eeb10ff6-cc29-1ec6-818b-438dfb5b566c	bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:40:09	0
17fe01c6-994f-4390-47d7-438dfbf1b457	14513b35-8e19-45ac-3902-438dfbb9e9f6	bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:40:09	0
1d67402d-ccbf-d9e5-b2c5-438dfb25e273	19c15806-3246-12c5-e1cc-438dfbbab67a	bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:40:10	0
22cb8bb8-409a-6231-bbc6-438dfbc7c874	1f35f94a-8991-c7ab-9bbd-438dfbbbf581	bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:40:10	0
28376d1c-2203-e8f0-2ab9-438dfbd24e82	24a4a273-98c1-9a0a-c838-438dfb3ed7e9	bf7005c7-6394-b116-8ea2-438dfb69e18a	2005-11-30 19:40:11	0
42d19c2c-0f0f-fcfd-9c21-438dfb7d7c37	3f2f3a48-d99a-7829-a959-438dfb582e42	3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:40:12	0
4ccf7d2c-72d0-9c36-3376-438dfba23ea8	490cc23d-f4be-4dbf-a410-438dfbe2841e	3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:40:12	0
524ec29b-754f-a747-d18f-438dfb50514f	4eb7794b-3be1-d005-58e3-438dfb2a079b	3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:40:13	0
57b99fde-eb7a-c898-60c6-438dfb5b1eb2	54186867-7303-ee09-ef77-438dfb6ac418	3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:40:13	0
5d171d69-7dce-a2d7-10af-438dfb86e288	597ca833-c232-cc1d-5dfe-438dfb0a7cdb	3c4f1718-d156-88b2-4920-438dfb205760	2005-11-30 19:40:14	0
79f19886-e093-63ce-fa86-438dfbf19ca5	76521515-1df7-c99c-c726-438dfb3ec991	73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:40:14	0
7f732241-f57f-a073-bda3-438dfb138c1e	7bc2433f-ca1b-0c3e-3477-438dfbeee984	73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:40:15	0
84d09327-305e-d199-d047-438dfbbad018	81348b4d-2d38-7c34-8bf3-438dfba5085a	73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:40:15	0
8a2d7865-f605-7afd-fd9a-438dfb90c2a6	86921a00-f77f-cec9-845d-438dfbae2821	73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:40:15	0
8f8cf9d8-9cd9-05d4-01eb-438dfb7ec022	8bfaeec6-d0d7-5cd3-2d03-438dfba07ea6	73770f6d-157a-09f1-0350-438dfbdb2bd9	2005-11-30 19:40:16	0
a9d096ea-287b-c7bb-5a92-438dfb08a48a	a62dccf5-4349-9b59-3025-438dfb8d98a0	a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:40:16	0
af6ac853-d468-fee9-88ee-438dfb2acf6b	aba0104e-6dad-688f-81ab-438dfbbac8ce	a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:40:17	0
b97d7966-3007-8a2d-cc06-438dfb94a0df	b5cbbc29-16ed-d0b3-ac02-438dfb4d7766	a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:40:17	0
bedb35ac-b147-c5d7-4f59-438dfb0b06ee	bb3d8561-6ba2-1278-d45f-438dfb0c251d	a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:40:18	0
c4259b76-301d-b419-dc34-438dfbc6aad3	c098fec7-58be-38b4-b41d-438dfbf1ca70	a34bb829-3373-27a1-0852-438dfb57c8d1	2005-11-30 19:40:19	0
de7c72c8-7e55-9b89-d7d6-438dfb57509b	dadc9c92-5df3-8016-35d7-438dfb99caed	d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:40:19	0
ed603f1f-bfbf-8f46-3ff5-438dfb845822	e9a0e2c2-372a-2ff7-95c9-438dfb662842	d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:40:20	0
f2c15ff5-3083-710b-659e-438dfb558cf8	ef24bfee-523a-68c6-dd16-438dfb4b16c5	d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:40:20	0
40940701-ff07-41a9-302a-438dfb63d74f	60600635-54b8-cbbc-89b0-438dfb3ee454	d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:40:21	0
17ae7f3f-fb83-9976-d560-438dfb8c7c66	f61708dd-2d76-3f1d-ba48-438dfb403988	d7fbdc0c-ec20-226e-1b68-438dfb1700d6	2005-11-30 19:40:22	0
321d76a2-e3eb-c7a1-a4b6-438dfb21a226	2e75dd24-c91b-c119-ad1d-438dfbe0d023	2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:40:23	0
3c71b9df-3a76-5bf6-36c1-438dfb8c4d9a	38d3a29c-a7ca-edd0-4ef6-438dfb654c4a	2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:40:23	0
41e519c8-ff77-0bce-ab83-438dfbb32260	3e3b0176-de9b-1946-1fc1-438dfbf186fb	2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:40:24	0
47388f4a-a1ba-1f3b-e092-438dfbe0afe6	43a361c4-16e1-0177-a91c-438dfbb98d54	2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:40:25	0
4cf4e02c-f4d7-1f2b-6c34-438dfb83bb95	48fb0531-303c-3b04-9084-438dfb6c79b9	2b9482ec-3479-9c0a-6fb0-438dfb0980cf	2005-11-30 19:40:25	0
6a1758ca-d8ed-78dc-3021-438dfb63e9f7	6672f6ae-5c2c-5d86-4dee-438dfb90522c	60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:40:26	0
6f7d3ff5-2c40-cf7e-68f9-438dfbfa4905	6bdcca00-b705-3da2-a2ab-438dfb2117ea	60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:40:26	0
74e735e1-4e3f-c6ee-0251-438dfb19721d	714afc3c-ec3e-e0b4-f981-438dfbdefd8f	60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:40:27	0
7a5453d4-3d5e-6b49-90e7-438dfbe3af5c	76b08dbe-f3f9-060d-28dd-438dfb8be7f0	60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:40:27	0
849e5f57-0819-90fe-0462-438dfbf7404a	8108184b-810b-377b-84a7-438dfb7bece7	60f8c2a9-16bb-3bac-e879-438dfbc87f71	2005-11-30 19:40:28	0
9f17f8f5-2933-91e2-252d-438dfbde45d7	9b6ece67-6d74-1a40-0130-438dfbd06fdb	98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:40:28	0
a9838b0c-af82-fe1d-2217-438dfb51af7f	a5e744a0-e624-3b99-a88b-438dfb370a7f	98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:40:29	0
af2908c4-ce3f-05ba-e3bb-438dfb91eacb	ab6f986a-4297-c870-ee54-438dfba55cb1	98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:40:29	0
b489f185-8274-7faf-f5a7-438dfb5ead4c	b0ecc2cc-8ee3-c384-b43d-438dfb5648df	98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:40:30	0
bef0e3e2-e408-2c48-8f59-438dfba64350	bb4cb0fb-6c8e-5c6d-8886-438dfba4ff15	98802778-d9c9-d247-7742-438dfb5a8bc0	2005-11-30 19:40:30	0
d948023b-fca7-8018-8a1e-438dfbfb9767	d5a5e811-d4d9-1697-4de7-438dfb21a436	d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:40:31	0
e3e68903-cbef-b164-68b2-438dfb530972	e03c422d-4407-10cd-d124-438dfb21f9be	d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:40:31	0
e950c66a-a362-9784-def9-438dfb4b7220	e5a411c2-9bf5-5e8c-bb29-438dfb1115bf	d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:40:32	0
eeb79496-9fa3-6eab-eb49-438dfb04c277	eb1fc2cb-27a2-2bd1-132c-438dfbd8d955	d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:40:32	0
f4119760-8c8a-f5ce-9c9b-438dfb6a84b2	f0737c22-c386-9648-cb03-438dfb26bbed	d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f	2005-11-30 19:40:33	0
1fb74ae8-84f9-f92d-e430-438dfb35a712	1c0a7dbf-1c4d-bc45-d499-438dfb7a3fa6	1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:40:33	0
2f87e4f4-19ca-65d5-bf4a-438dfb817b25	2bdf1a1b-044d-6cff-e480-438dfb7ab9ef	1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:40:34	0
34eb6ef3-8204-3358-3d45-438dfb3b8402	31473bf4-94fa-0efc-3acf-438dfb05ebb9	1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:40:35	0
3a605cbb-4da0-ee07-9af6-438dfbd32f4a	36c2007f-ce60-1096-9573-438dfbd4bdf7	1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:40:35	0
3fd1b3d0-47b3-a26d-504b-438dfb892213	3c26c9f7-6205-2067-c24f-438dfbd976ee	1921d5d5-eb23-46e8-25cc-438dfbe3305f	2005-11-30 19:40:36	0
679bc775-560a-6ad0-9556-438dfbc5bba0	612625f8-9483-bb68-4770-438dfbca551f	5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:40:36	0
6d00b42f-78c0-d101-c865-438dfb25125c	696056f6-ce0e-1b23-2090-438dfb8fda29	5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:40:36	0
72751200-1411-f8b7-a526-438dfb0464cc	6eca0729-f49f-61b6-8953-438dfb70aa48	5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:40:37	0
77ca9479-0d41-0385-2f6b-438dfbfb1345	7438ae67-2d4c-6715-1cc8-438dfbe586e3	5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:40:38	0
7d273f36-40eb-e4ab-d2dd-438dfb056992	7984b757-bb96-2154-c429-438dfb94bbe0	5e4affc3-fc43-dcb3-8da1-438dfb03c50e	2005-11-30 19:40:38	0
9768151f-dadc-d36e-6a2f-438dfbfb2bfd	93c4144d-fc79-ca33-41ab-438dfb013dc4	90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:40:38	0
9cee6fa9-bf91-c18a-0e02-438dfb251114	993472de-1f2f-a5fb-1527-438dfbf0c0cd	90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:40:39	0
a25be693-352a-6be4-4802-438dfb76e9c6	9eb4fca8-4462-7415-1aa5-438dfb3ca6e0	90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:40:39	0
a7bac553-0de2-7930-47f6-438dfbd0803e	a4305260-a3c4-205b-a8f6-438dfb89d496	90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:40:40	0
ad282d70-ca17-e8d8-030e-438dfb1a7240	a978cd56-f051-1495-783c-438dfb952c42	90e70ca7-9327-00ec-c1b3-438dfbfecb31	2005-11-30 19:40:41	0
c78bd49d-6129-9611-620d-438dfb8407a1	c3dd5641-a7a3-677e-d4e8-438dfbc638c0	c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:40:41	0
d27730b4-6156-f6fc-997f-438dfb269a0a	cebd7ef5-bfcc-b1b2-df3f-438dfbbd02b1	c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:40:42	0
d7d8f10c-4028-34ee-1ff6-438dfbf0b3cc	d439592a-b3c6-47cd-9419-438dfb01db86	c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:40:43	0
dd3917e4-198b-d8c9-2e3b-438dfb04abbc	d99ec27c-00e8-5dc2-c992-438dfb77b3e1	c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:40:43	0
e2970e01-6ca7-d603-74f9-438dfb6863cb	df08a099-1291-903d-fc39-438dfbf20672	c0f2ee49-be18-e1a1-9b12-438dfb9b29aa	2005-11-30 19:40:44	0
8ce20a93-d686-bf92-f473-438dfb3e1497	53490ef2-df6d-119a-33ef-438dfb537766	23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:40:44	0
e4000078-52fb-035e-2e46-438dfbfd4a8f	a9870e1a-cfa1-413c-0a52-438dfbddc08b	23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:40:44	0
19618a3b-0a34-cf9f-732e-438dfbe7b673	1592ebaf-a637-0608-c274-438dfbe0fd90	23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:40:45	0
1ec9b7ef-532a-d762-487e-438dfbe6e9c1	1b28bc20-5ff5-2f10-bcaa-438dfb6b7230	23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:40:45	0
2419d7b8-9c6a-11e9-343a-438dfb56d575	20885892-af45-fe5f-47b6-438dfb63f5e2	23710ff1-e84e-783e-5daa-438dfbc1324c	2005-11-30 19:40:46	0
4a794433-34ed-d745-4c68-438dfbe0e4d1	46e0b44c-ae9e-479d-ab62-438dfb6a7d25	44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:40:46	0
500b7937-0b03-1eba-7013-438dfb503c6a	4c468564-3cd3-4872-618f-438dfbaac4e4	44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:40:47	0
60a451eb-3216-bc6d-484b-438dfb7058a4	5d066da3-3210-0495-3695-438dfbc79805	44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:40:48	0
68987d06-d348-7fd4-14d0-438dfbcedae7	64fbedce-fdd4-f6bb-e651-438dfba5fb3d	44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:40:49	0
6df33706-3da3-0b5b-3330-438dfb7f133e	6a5ac3b5-dd87-fc14-8941-438dfb6f25bc	44024f5a-5c41-6d76-f423-438dfb832b76	2005-11-30 19:40:49	0
887e85c1-c467-0f7b-3f80-438dfb92abad	84da0af4-1e4d-1610-5610-438dfb776af6	81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:40:50	0
8de99460-9d43-ad4c-01ee-438dfb547249	8a50368e-0ecc-7098-94cb-438dfbe6c2be	81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:40:50	0
93437a3f-e0f3-36e8-cd16-438dfb4a77a8	8fa48ba1-7cd7-23dc-54d4-438dfb8b9066	81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:40:51	0
9e667912-fe26-b8bd-f5a1-438dfbb4f1f0	9aca0ba7-b975-7f86-8ea0-438dfb2ae397	81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:40:51	0
a3c50eee-cf60-3655-4fe2-438dfb24d9c1	a0264052-23b4-59f7-4c0e-438dfb2b8b0e	81f45e11-9a91-753e-cb49-438dfbfd7fd5	2005-11-30 19:40:52	0
be7574fd-b8db-131e-41c1-438dfb99b983	bad3bfc4-4275-dc06-3aea-438dfba98c9d	b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:40:53	0
c9b0a036-a98d-62ca-7d7a-438dfbd2a00d	c601cb7b-f3e2-7359-b459-438dfb7e8dfd	b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:40:53	0
cf15688e-bc03-c9d6-0951-438dfb1a19fa	cb7c86d6-9427-7e0d-c5cf-438dfb37adbd	b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:40:54	0
d48f4fd8-ad42-7f0a-2c6a-438dfb81446c	d0e7a906-07c5-a461-6388-438dfb426b78	b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:40:54	0
d9ed7bb1-b847-2bf0-63f6-438dfb948cec	d6504e3b-97fd-09b6-45a3-438dfb78d921	b7dec629-ebe9-301f-a9fe-438dfbd70e2a	2005-11-30 19:40:55	0
128503b3-64f0-584c-0885-438dfb21bc98	f1b2389a-739a-ca2a-33c1-438dfb9fe01c	eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:40:55	0
696103d1-995c-aaa6-298a-438dfbea6887	2eee0853-e1d9-a93f-0f5f-438dfbccc411	eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:40:56	0
bf7a0249-d143-4b1a-061c-438dfb12f2a9	860d0a28-64bc-fdf3-5637-438dfb8d8bbe	eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:40:57	0
116d04e4-10fe-477d-64f5-438dfb1b8480	dd27089f-ed45-c5e0-a27c-438dfbe189ad	eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:40:57	0
16c67002-2dcc-e6b2-cae8-438dfb6c0b0c	13325e10-ba03-2667-dfaf-438dfbd8807c	eed243f1-48d1-3ecd-3487-438dfbc741f0	2005-11-30 19:40:58	0
3116fe4c-8d79-8de8-241f-438dfb8a8a61	2d725871-b59b-4bf0-2a01-438dfb6f83ba	2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:40:59	0
369faaa6-e5a2-b5f8-0618-438dfbf6b8ba	32e17834-f2f9-525e-af8d-438dfbdaf749	2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:41:00	0
3bfe34cc-89ab-70b1-2902-438dfbfb2c29	385c8e25-5669-9519-f61f-438dfb231990	2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:41:00	0
47623778-338a-06ef-5051-438dfbe7cb2b	43cb09b0-bd92-92e0-6b22-438dfbd182fe	2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:41:01	0
4cf2a991-e524-4e39-9866-438dfb8108d8	4928b942-cf89-7598-79fe-438dfbf4324f	2a91d192-9acb-1d12-fd0a-438dfb1cb462	2005-11-30 19:41:01	0
6a1b3868-4f78-8b56-26c2-438dfbaee37b	6673c657-78ec-5f3c-9a38-438dfb13699f	60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:41:02	0
6f757c6b-e952-bbc2-9295-438dfbb86027	6be080d7-53ea-1c50-ce28-438dfb8c4c7c	60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:41:02	0
74def81f-26dc-703d-40a3-438dfb8bcfcf	71377e9a-2d35-063e-303e-438dfbcfe630	60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:41:03	0
80730466-f62c-ef2a-c86a-438dfb302b7b	7cba39cc-e0bf-2a3a-9685-438dfb04e739	60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:41:04	0
85c84f7d-e179-dae7-1fd2-438dfb6541e9	82316bda-dac8-1394-5bc9-438dfb749bbd	60e4ebb5-c76b-436e-9306-438dfbbc3373	2005-11-30 19:41:04	0
a02c4bab-59ed-2ae2-8a13-438dfb3322ec	9c80640c-6e67-185e-f1ee-438dfbc964de	9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:41:05	0
a59b727e-4e00-3d3e-da4f-438dfb9f5a0e	a1f33131-2347-50c6-3bda-438dfb788e92	9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:41:05	0
b14b7e6b-32f0-b227-9f4d-438dfb8875be	ad83d5b3-da28-d03b-ba7f-438dfbde2e60	9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:41:06	0
b6a7ff3f-f566-05e1-dd9d-438dfb5b3691	b30f2fac-527e-88c9-bd70-438dfbee360a	9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:41:06	0
bbff62f3-9d84-2f22-cc57-438dfbb2478e	b86fca78-b6e8-5fe0-635f-438dfb454370	9999812c-f78f-cb3a-bdfc-438dfb6a834c	2005-11-30 19:41:07	0
d65cc261-12a3-e05a-446b-438dfbe04958	d2ad4110-bfe7-a84f-d48d-438dfbafb616	cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:41:08	0
dbd1ee2c-0393-bb0b-bbeb-438dfb1ad32d	d82ff139-02ae-40bb-5882-438dfb43a8d5	cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:41:08	0
e13f4d10-48fc-afac-4e1a-438dfb2b3987	dd91336c-bc7f-1952-fffe-438dfbb59fd5	cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:41:09	0
e6ad08cb-31e7-9d9c-1aba-438dfb717e00	e30fa70c-8b35-06b3-c611-438dfbd589b2	cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:41:09	0
ec1cd03b-1f04-7ce9-9dbf-438dfb404223	e8704fe5-3047-9279-5c06-438dfb5fc0ad	cfca9f5e-a1b3-1d21-df6a-438dfb36eadf	2005-11-30 19:41:10	0
1f10268a-1ee2-17a3-326a-438dfba92b73	1b5c1d08-80c5-5cb6-9ea5-438dfb1a881d	1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:41:10	0
24696283-a334-79fa-1d03-438dfb34c209	20d53811-5083-5a95-111c-438dfb7e8384	1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:41:11	0
29bc03f6-e0a4-5bee-b012-438dfb10883f	2626908b-3fc0-243f-6739-438dfb548e0e	1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:41:11	0
2f30ba6f-fd6e-375d-ad36-438dfb20a0ab	2b94e4a6-3832-4976-9420-438dfbfb2203	1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:41:12	0
3496040d-c7d5-4c10-6b27-438dfb09a201	30f14c70-926a-afd4-92c5-438dfb81de0c	1864a1cc-60b1-c48b-8f71-438dfba9ba59	2005-11-30 19:41:13	0
4f3ea85a-8a5e-05d2-be74-438dfb976fa4	4b65004f-aeae-ed7b-2f92-438dfb84defa	4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:41:13	0
54a5c8b6-7a21-8cd4-96e2-438dfb9b3ef0	510a6204-f009-151f-98bb-438dfb2126e3	4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:41:14	0
5a0c7c05-0837-04d5-abb3-438dfb0f145a	567520fc-62ab-e8b1-085e-438dfbac9cad	4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:41:15	0
5f6fcd58-b9b9-7a9c-6432-438dfb2636f1	5be14f74-8090-85ad-4676-438dfb29017b	4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:41:15	0
677ca485-1d77-2d74-1ee8-438dfb93f822	61374b99-3754-27f3-2b3c-438dfb2886ac	4884f8c8-1b4a-ca44-502d-438dfb71f043	2005-11-30 19:41:16	0
820e3d53-efb1-fa61-3481-438dfb44e7e9	7e651665-8246-e854-73d4-438dfb51eb29	7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:41:17	0
87842047-7d34-c938-f02c-438dfb13d9d2	83dc109e-7d0d-2325-0ad0-438dfbe13075	7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:41:17	0
8cf050a1-944d-90df-da2a-438dfb484f17	89478158-dbf9-172d-9527-438dfb73898d	7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:41:18	0
925ab5dc-322f-1ff3-0de3-438dfb441f9d	8eb7082b-3441-ca64-f1d0-438dfbdd353a	7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:41:18	0
9e5579ce-bf2b-391f-c045-438dfb285099	9abf1df3-a0c5-0843-ea9f-438dfb8daa84	7b494b9c-bfe6-5125-3139-438dfb7f4b61	2005-11-30 19:41:19	0
b9046c3f-4d10-e4c4-ee4e-438dfb666b63	b56069f6-12fb-030e-bb28-438dfb8e50e5	b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:41:20	0
be719574-45a1-f631-3462-438dfb15306e	bac93074-0425-ad14-03ed-438dfb38b88b	b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:41:20	0
ca83a917-47d8-d258-3c7f-438dfbd48efe	c6c68a51-3ab8-2541-2a95-438dfb2cf40b	b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:41:21	0
cfe086ad-7742-1f22-dea3-438dfb38c521	cc4f785c-1c88-4c24-a7f5-438dfbad11f4	b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:41:21	0
d5fda652-d7f1-69d7-9b5f-438dfb536bf6	d1b09a79-0b07-6742-bb79-438dfb3b66ea	b26eaa78-b909-c1d6-f477-438dfb12c935	2005-11-30 19:41:22	0
996e0ef8-a58c-0ba2-52d8-438dfb5034ed	5ed00be2-2112-db98-da3a-438dfbe82091	304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:41:23	0
f0a30a97-597f-db07-fad5-438dfb4e90c0	b6270e59-96c9-bf43-f536-438dfb7a10ae	304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:41:23	0
1486cb46-cb59-7785-429f-438dfba1ebd0	10d323fc-ce01-a973-c6ca-438dfb198c24	304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:41:23	0
1a067f3a-ddf0-bb62-7aac-438dfb4f0009	1647aaad-922b-323e-5c06-438dfbdaa8f8	304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:41:24	0
1f755978-8100-c5f2-b593-438dfb83ea2c	1bc68cda-3580-30c0-eb51-438dfbc6b01d	304e07d6-fd21-1d2a-d905-438dfb7015ac	2005-11-30 19:41:25	0
39f9fedc-a9ae-2f03-383d-438dfb3c5ea9	3652fec6-c457-0325-07d5-438dfb4e9078	3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:41:25	0
4d7286cc-d719-1136-c9fb-438dfbf13286	498f13e2-368f-eddc-cedf-438dfb639608	3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:41:26	0
52f96944-d950-6534-208a-438dfb9a71a3	4f37e142-bbfa-1e71-727a-438dfb07b8e1	3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:41:27	0
5855a483-e2e0-41af-de36-438dfb024405	54c668f3-e802-e63e-cc9c-438dfb999ff9	3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:41:27	0
5dbcf474-83fb-b7fe-f79b-438dfb618ec1	5a1b0e89-d349-e806-44c2-438dfbfa905a	3364987a-77b9-8587-0419-438dfb4161c6	2005-11-30 19:41:28	0
7bd3433f-f083-9052-e517-438dfb1ea5af	781b10a1-c478-4bc1-38c8-438dfb5aade7	751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:41:29	0
81c0e6b8-3b0b-911f-7804-438dfb78d7d3	7dc334b3-6f49-499c-d32d-438dfbb8ec20	751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:41:29	0
871df04c-bd7e-3705-fe1f-438dfb6c245e	838679ca-e095-9dca-f756-438dfb52a0da	751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:41:30	0
8cb7a725-7043-c560-2a26-438dfbfade7e	890db2e3-c01f-9759-19be-438dfbc2f22e	751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:41:30	0
9282573d-4110-903e-3279-438dfbb12fea	8e74b965-8dcd-731d-8d57-438dfbb373df	751f74c6-e766-4a2d-c618-438dfb884964	2005-11-30 19:41:31	0
afe2a6be-4d26-bf66-709a-438dfb326cea	ac33d7fe-cb39-31c7-e3d2-438dfb741fb8	a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:41:31	0
bc65258e-b8bd-fc93-7e4d-438dfb75e696	b8bc3968-543b-9c3b-02da-438dfb59c00d	a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:41:32	0
c1cf5612-8b53-c9fc-7598-438dfbfd21fd	be3b9ad3-a3a5-2048-7413-438dfb1df1ba	a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:41:33	0
c73c4d11-2027-9130-179c-438dfb6ccafa	c3a07c98-92ce-d422-62f4-438dfbfc2b03	a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:41:33	0
cca4a144-9fd1-d7ef-30ec-438dfb5a5069	c903f0b7-5e0b-264c-d0fd-438dfbc9ba21	a93e924a-538b-1601-ae87-438dfb8fc4a2	2005-11-30 19:41:34	0
e7241d0c-8b16-1d8f-5d07-438dfbdefbff	e369585d-9d9c-752b-73cd-438dfbaf3a69	e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:41:34	0
ec885fbd-171d-ee28-dfef-438dfbfca14e	e8ef0dfb-fc5c-b82c-cb9a-438dfb91f9ba	e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:41:35	0
f1ee789f-fc7e-cf67-cdb5-438dfb822ad4	ee4c4ede-6a2e-386d-663c-438dfb77b6a4	e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:41:36	0
a35d0f79-7b8a-d3aa-961a-438dfb33d900	69f50c64-0311-ef21-fa1d-438dfba51d53	e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:41:36	0
fa3c0d08-f360-c56b-dbc9-438dfb88bc93	bffd08d4-272d-bd92-0fd8-438dfbbfcc44	e0737887-c5f3-a1a5-e608-438dfbd3315c	2005-11-30 19:41:37	0
2a000821-2014-e7f2-1231-438dfb2566c3	26628087-7b20-c1d2-177e-438dfbc97a8a	2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:41:37	0
2f70a9c7-1cd2-bb4d-89b4-438dfb4b92a7	2bd72387-3fcd-67f9-9855-438dfb3c63de	2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:41:38	0
43144128-e400-6d98-90a1-438dfbb7776d	3f728405-3568-9352-18a7-438dfbe4fb30	2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:41:39	0
48a52384-166d-2ad9-26c2-438dfb620dfa	44f320a0-08f4-7fe4-73b5-438dfb8b4a2c	2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:41:39	0
4e2884d7-f4ec-d60e-7135-438dfb714d37	4a602603-eba7-1cc3-c907-438dfb824719	2374b87b-5ad6-737a-8950-438dfbdc4ec4	2005-11-30 19:41:40	0
6b6e4b59-732d-25e1-5db3-438dfb49654a	67b639a9-093a-e82a-9a08-438dfbfd7276	622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:41:40	0
70d3297c-198e-e678-dfd7-438dfb6962b8	6d38d878-cc23-5aab-4842-438dfbf7694c	622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:41:41	0
7642cbf9-bf8a-1529-8fb1-438dfb128f1d	72a0b110-3ec1-a513-c43d-438dfb81b8cf	622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:41:41	0
82f0b3bd-546e-6b71-58f1-438dfb5da8dd	7f40fcc5-205c-c857-9654-438dfb7be478	622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:41:42	0
885a44da-ea09-3c43-f946-438dfbd755f4	84bd9d95-5c11-9e45-023c-438dfbcfbf73	622a9551-b8cc-1eb3-5ebb-438dfb0eab51	2005-11-30 19:41:43	0
a2bb5ba1-1054-b5f7-4110-438dfb45b25b	9f0a2f85-ef11-7a06-d3fd-438dfbf492eb	9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:41:43	0
a83e74c3-6302-ec6d-85d4-438dfbb79a61	a497dc28-5017-4cb9-74a5-438dfbbf4a3b	9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:41:44	0
ad9a016f-e1b8-06d3-2e84-438dfb4cabe6	a9fe58a0-b5ce-3616-111c-438dfb2885a7	9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:41:45	0
b32d633e-8e84-5e79-ded3-438dfbeede72	af647d90-a999-ef43-e6dc-438dfb3ca0ce	9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:41:45	0
b893bf77-a00a-7ccd-aaf0-438dfb44bdc2	b4fe0c73-566f-e7a0-e048-438dfb22ef21	9c2c6aa1-824f-f9af-7ecb-438dfb6c1188	2005-11-30 19:41:46	0
d2f3d512-f24f-bdb4-32b0-438dfb78883f	cf5b9410-daa2-5b7b-7af9-438dfb650027	cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:41:47	0
d85fab6c-c1d4-0b73-6d1f-438dfbc0a520	d4be4805-e0fd-c244-6ce2-438dfb0a28cd	cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:41:47	0
e54b278c-df55-d078-2979-438dfb4545d0	e19a0e69-4262-db80-3ae9-438dfbcdf75d	cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:41:48	0
eac740cb-4320-4eef-e2a1-438dfb5897ab	e71b0ec4-d2b6-163a-5613-438dfb5b803e	cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:41:48	0
f042ca67-6eb1-08cd-7616-438dfbe6cd77	ec873af7-bc03-2b3a-c0ca-438dfb0ff508	cc69d83e-11f0-f3e0-d42d-438dfb68d005	2005-11-30 19:41:49	0
16a1829b-4fd5-dd84-5d2e-438dfb30eb1a	12fc8aff-eafa-db7d-3cb3-438dfb92ab6e	fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:41:50	0
239a20f2-954e-11d3-c81d-438dfb6f36ec	1ffdc45d-f05c-4524-a9ec-438dfbea006c	fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:41:50	0
28f77fbf-1067-20d5-9e75-438dfb1bf74f	255b8267-8c0f-77f4-bfba-438dfb11ca27	fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:41:51	0
2e6717bf-0096-6a40-2891-438dfb8038fb	2abd600b-fd8c-9e2e-ad4f-438dfb9cc7ed	fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:41:51	0
3b5891ce-ad11-daa2-127a-438dfb9217c6	37b10c7d-8239-22e9-8f4b-438dfbc4f8cf	fff9081b-2d2c-ae3f-faaa-438dfb9df93d	2005-11-30 19:41:52	0
56993576-e3fc-ce5b-bd45-438dfb3d7ce7	5300c56d-8a4a-137c-2dab-438dfb109998	4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:41:53	0
5bffc693-3235-0bca-f50c-438dfbee8216	5869f34c-1589-e7a3-27ec-438dfbc977c4	4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:41:53	0
6b89b0f1-5f33-d092-604f-438dfbb3d7b7	67e10d3d-faac-dd27-84cd-438dfb3a0afe	4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:41:54	0
70efc780-a4b6-61fd-240f-438dfb6c6283	6d561284-86b1-f13e-6483-438dfbd8211c	4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:41:55	0
7663ccd6-e3d8-ba5e-d8ab-438dfba8dfa3	72b797f5-5651-fea3-229e-438dfba1f323	4fbfef86-ea7d-b3c8-2a7a-438dfb305253	2005-11-30 19:41:55	0
90d86edc-628e-c0d4-9d3e-438dfbc550d7	8d234111-8b6d-b0d0-8c3e-438dfb6d0d03	8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:41:56	0
9649c918-8d8e-0190-4fc0-438dfb2a0d0c	92b1656f-274a-48bf-4c32-438dfb0fc02c	8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:41:56	0
9bc750fd-cb9d-4360-f441-438dfbb02e5f	981803dd-0ae7-b3b1-d82f-438dfb723b9e	8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:41:57	0
a1302fbf-1358-b8bd-f227-438dfbdaaa60	9d8ee7dd-b503-f142-c8c6-438dfb8ab474	8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:41:57	0
a6b6f62e-858a-2a6b-6325-438dfb9441c5	a2f7da06-58b4-778e-a0ff-438dfba535c8	8a43b583-3f48-a059-3087-438dfbd5f54f	2005-11-30 19:41:58	0
c13e5f34-9621-fc1d-7a6f-438dfb8930d8	bd8ee877-3489-9c0a-b05a-438dfb53d4bd	baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:41:58	0
ce6a03e3-c7f1-aa88-ead5-438dfb23c1f8	cad53586-2b28-feae-cfbd-438dfb2eb30d	baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:41:59	0
d3ee16d4-e90e-e945-fe1a-438dfb467581	d034713d-2b2b-1d67-7a98-438dfb1a2838	baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:41:59	0
d95d4f45-1277-191f-7eb8-438dfb9626e2	d5b98421-fed8-6c11-ec81-438dfb3b9b9a	baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:42:00	0
deb211d4-1f30-0405-0bf8-438dfbf98e14	db180153-d774-c29e-a0cb-438dfb3ed87f	baaaecde-dd04-9723-7b93-438dfba458e3	2005-11-30 19:42:00	0
59f40f3f-2bdd-a700-0bee-438dfb23fdb6	1db50c45-fdbc-475a-3b7f-438dfb5276b2	f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:42:01	0
bb5306db-188d-1fef-26c3-438dfb1bc5a4	775f0d93-f4a5-f53d-fc28-438dfb3bfe18	f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:42:02	0
210a2529-8007-f29a-3c3a-438dfb3c9be3	1d347bee-362d-a74f-36b2-438dfbf6ab40	f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:42:02	0
26a074d8-c13d-d9ed-601c-438dfb3c8ae8	22e55b0b-cb45-140b-a706-438dfbfb1acb	f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:42:03	0
2c3abef2-428d-2ba8-195c-438dfba2b641	287701ac-5c0f-d5db-a7b3-438dfb8ebbc7	f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059	2005-11-30 19:42:03	0
57623662-4a71-37ec-2aac-438dfbe56334	53ad9811-d505-d09b-6a1b-438dfb6d24ae	504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:42:04	0
5ceef7e6-e33e-0927-4aac-438dfbb6b596	5933b89a-24c4-03fd-b546-438dfbee279a	504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:42:05	0
6279a702-d7ad-378a-89ee-438dfb091f3c	5ec02c9b-046c-14f3-c764-438dfbd6ef29	504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:42:05	0
6aa9b89d-f3fa-8a3d-ef12-438dfbd50042	665d1131-c3a4-1519-c411-438dfbd40e3f	504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:42:06	0
703e4d3a-6c6a-67df-0a09-438dfb721798	6c7bb318-a1df-1e46-f68f-438dfbbb5ece	504421d1-6b83-2d46-28f1-438dfb176619	2005-11-30 19:42:06	0
8b505cba-e5d7-960f-8190-438dfbebdb54	8793d5e5-5969-1af0-ab76-438dfb49f273	849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:42:07	0
90f5b974-fd65-65d3-1ea6-438dfb0dedab	8d2b4676-d6bf-3e86-9f91-438dfb35f4ca	849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:42:07	0
968b7b55-8f8f-05ca-1b04-438dfb6c5c81	92c649a9-347b-744c-90d7-438dfb7fd645	849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:42:08	0
9c283f69-7c55-e38e-fce0-438dfb54be2a	986c061a-f849-6fac-fe1a-438dfbfbd54c	849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:42:09	0
b1c1c972-b361-0260-18e1-438dfb3a4bd7	ae04daf5-6ecb-1363-0daf-438dfb8b54cf	849ff02a-a41e-a831-1c4a-438dfb9ac9c5	2005-11-30 19:42:09	0
ccf4b784-aa7e-be94-b147-438dfbb09647	c939bc06-510a-83eb-68a8-438dfbabaf05	c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:42:10	0
d29e55f1-d3c4-d094-f520-438dfb9a944e	ced3b2fa-8a47-872f-f24c-438dfb30efec	c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:42:10	0
d83a0d61-651e-5ef3-82b5-438dfbff27dd	d47c9815-d981-8b04-c9aa-438dfb7a0d3e	c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:42:11	0
ddc2a0f4-ced9-1aea-84c2-438dfbe5d9c4	da1180cf-2971-fa7f-80a3-438dfb391c15	c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:42:11	0
e34af185-3419-0c8a-d278-438dfbf2be5c	df8dfb99-d6cc-c2f4-ca32-438dfbf19316	c6407d2b-037b-c156-ea7a-438dfba2d249	2005-11-30 19:42:12	0
a27e017e-fb0c-45ba-5b56-438dfb76e4b0	668304cd-9222-76ac-b060-438dfb789660	36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:42:13	0
fc240fe0-f7d3-0f22-1ac6-438dfb51d880	bf4f0690-2a3a-204b-88e4-438dfb89ccf5	36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:42:13	0
265b38b3-3094-8f0a-388a-438dfb51b5be	22953eac-12c2-e926-89b4-438dfb357a40	36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:42:14	0
2bf1d553-88a1-08c2-e2ba-438dfb813cf6	28315961-1c0b-8af5-b9b2-438dfb727a2e	36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:42:15	0
31bf4e4d-3142-42c5-5b29-438dfb944df0	2dca1956-a58b-c02b-5424-438dfb846a31	36a40b1b-cb67-ceb4-0533-438dfb7d0963	2005-11-30 19:42:15	0
4c4d504f-c466-5994-db6c-438dfbe6177d	48a42d2d-17bf-3a40-c4ce-438dfbb6cb86	45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:42:16	0
51d64ae3-61d1-75e1-5139-438dfba8e7a5	4e112ea1-e512-999c-1a1e-438dfbdfdb77	45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:42:16	0
573644cf-749f-2232-1856-438dfbd57c88	53a0b957-2c37-80fd-8d1b-438dfbff40a3	45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:42:17	0
5c9ec79c-b789-930d-9554-438dfbb61917	5909e089-1c6d-e28d-7c2d-438dfba56253	45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:42:17	0
6cd34d76-9015-feca-5e5b-438dfb555539	692c782a-d9fe-1454-cd59-438dfbcb19d4	45a5a513-0d9b-aadb-5c29-438dfb1fdc19	2005-11-30 19:42:17	0
8731b147-d798-a600-3f01-438dfb45a124	838a3d12-5bab-f960-b7c2-438dfb83dad4	80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:42:18	0
8cac00d7-4dac-b0cd-e1f5-438dfb5bad07	890a8313-5ce4-9593-29d2-438dfbc01ce3	80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:42:19	0
921a2ccd-8907-9f61-2d41-438dfb8c9b64	8e71f333-cd20-6642-5cd3-438dfb275792	80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:42:19	0
9fe8c984-4f94-dbe6-56f5-438dfb23a218	9c3fda74-a69d-eb87-8fad-438dfbcfa6d1	80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:42:20	0
a55ae468-94b8-eadc-541c-438dfbd9bd59	a1b41bc6-585e-982c-ca76-438dfb0c8f1f	80a8a566-3f2a-194b-646c-438dfbc93925	2005-11-30 19:42:21	0
d0d7929d-1306-3c0f-cb4e-438dfbbb6629	cd2e391f-870b-689f-861e-438dfb60bd29	ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:42:21	0
d649d7a1-6ee6-186a-5dc2-438dfb7f6694	d2a13a8b-4ffc-a2e6-8429-438dfb22c136	ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:42:22	0
dbbf0a5a-0e0c-4dff-9ad1-438dfbb95325	d81790c4-0bcf-30ef-457c-438dfbf2487d	ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:42:23	0
e9aa6473-fc39-a2ed-2f17-438dfbc025a2	e6064aa2-6d59-4d08-711b-438dfbf31964	ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:42:23	0
ef2a7156-c0b4-d71e-09e0-438dfb4adb7d	eb821663-8c61-f42e-1544-438dfb54814a	ca42a368-c80b-7cca-5596-438dfb51d67e	2005-11-30 19:42:24	0
156ac207-1b1d-d3cb-a609-438dfb6cfcce	11a35d39-c115-54ca-9de3-438dfb3d0e5b	ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:42:24	0
1aec0154-38ab-c8ea-08c2-438dfb46b6ac	1747251f-a8bf-d4ee-35a8-438dfb60d8dc	ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:42:25	0
20553c6f-adc2-8afd-01c1-438dfb069116	1cb83a8a-e6d1-c9c8-9234-438dfbd9ab59	ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:42:25	0
25b51413-e815-5dba-804c-438dfbd5e1e9	221674b3-7d8b-1ff3-750c-438dfbd321bf	ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:42:26	0
2b089fbd-0eee-5d76-2470-438dfbd43441	276fb0b4-7e4d-21b5-b271-438dfb61458b	ebf1026b-33e5-900d-f7b2-438dfb8a68cd	2005-11-30 19:42:27	0
45955da8-dc2c-90b6-b6ab-438dfb5273c5	41f1e3a6-4eb5-1cb3-fa37-438dfb626c2c	3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:42:27	0
5435c1a1-42c7-6aa0-e4b3-438dfb4a0c1c	505b31df-9b7e-6dd3-b9f0-438dfba17836	3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:42:28	0
59924f11-7ffe-8541-8950-438dfb55085c	55f7a596-3508-ad66-7525-438dfb883084	3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:42:29	0
5efe0f87-f813-2945-284f-438dfbb8b3e1	5b600add-1c40-f290-e21a-438dfb806c31	3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:42:29	0
6fa4b906-3a53-0dd7-0313-438dfbc84e07	6bf61619-b40d-6099-314f-438dfb4f3ffa	3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3	2005-11-30 19:42:30	0
8a1685a5-6aa3-1dce-6057-438dfb2a574e	866fb5b4-c71d-44e2-b865-438dfbd7c8d9	838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:42:31	0
8f8448c7-1b75-7180-1a7e-438dfbe681ae	8bddc019-92eb-f851-b3cf-438dfbf260be	838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:42:31	0
94ecab3b-fb45-419a-df64-438dfb819d64	9151e82e-52f3-cc92-403a-438dfb454177	838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:42:32	0
abf10245-8394-cc83-baba-438dfbd2ee12	a83b6856-d938-d814-f5e9-438dfb832aa4	838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:42:32	0
b14c353a-e6a9-0a17-bc65-438dfb3b3b46	adb77329-5a39-1e50-cd4a-438dfb846a0a	838163c6-4c13-957a-1afb-438dfb2ca106	2005-11-30 19:42:33	0
cbbd7f0c-2ccb-56c6-ed3e-438dfb934543	c81fdbad-f6e4-d6f7-ae8b-438dfb50b5bc	c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:42:33	0
d13cb5fe-fd7c-2339-f958-438dfb3de6f9	cd87c3dc-988e-b495-72cc-438dfbd51129	c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:42:34	0
d6bc7f2b-09e6-0de8-c571-438dfbad05e3	d3096f44-7dde-1ee9-be28-438dfbd5b0d2	c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:42:34	0
e4ff1061-5476-6f57-dc11-438dfb4ea75e	e15e8964-7676-30dc-61b5-438dfb15fc16	c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:42:35	0
ea5c0787-b023-9ac6-eee3-438dfbfc66c1	e6c8614b-d732-2eab-42cd-438dfbe23e13	c5459906-c7f9-27ca-7cde-438dfb77de9a	2005-11-30 19:42:36	0
10b4e60c-2e86-e346-b8dd-438dfb8385f8	cf9202c1-7c01-86e4-e85e-438dfb7c0d0b	a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:42:36	0
2808b128-58cb-1702-dd53-438dfbfa4e7b	245d2817-72e9-818d-2ee0-438dfb682387	a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:42:37	0
2d7aac7a-be0a-f289-5c75-438dfb58fa8c	29cfa704-4580-7ee6-b496-438dfb2a6af4	a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:42:37	0
32e11d69-7556-b96d-43a3-438dfb69f05c	2f47897b-4d33-935e-b20e-438dfbde836c	a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:42:38	0
38516f7b-e779-d0a9-283a-438dfb7c97d9	34b63683-612a-dd6d-95f7-438dfb1d4814	a0b7065e-075b-3b0f-c2bc-438dfb008e30	2005-11-30 19:42:38	0
679101cb-b308-c040-e04c-438dfbf2a920	616832be-f2a1-0b86-b1b4-438dfb3e108a	5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:42:39	0
6d028188-89dc-738c-3a42-438dfbc4af26	696a49e8-bf3f-6b1a-602c-438dfb443b80	5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:42:39	0
7279aced-086e-5cb8-6f66-438dfbf0170a	6ec00f83-ac07-fd3c-61b3-438dfbac7fab	5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:42:40	0
80e7b762-d0d6-238b-a202-438dfbb903cc	7d45191a-c53d-eecb-6c2e-438dfb1c4d7e	5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:42:41	0
863a9d58-7d46-58a9-9dc3-438dfbe10369	82a86afe-6af1-b159-826b-438dfbc9cbff	5e74135e-b955-5ffd-8f0c-438dfbe44b00	2005-11-30 19:42:41	0
a09c3cd2-d977-f8b9-5855-438dfbf4add6	9cf6b307-aa94-af64-4182-438dfb800865	9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:42:42	0
a60d5f91-a191-e6e0-e919-438dfb42b760	a2652985-08ce-b7c9-e4d0-438dfbc911eb	9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:42:42	0
ab81f5e1-528e-b574-9624-438dfba00646	a7e766bb-8702-8b79-c3ec-438dfbc06ada	9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:42:43	0
c3479540-ee82-1f7b-cb8a-438dfbc6bf98	bfb1dc5a-9b78-62d0-588d-438dfb1d1699	9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:42:43	0
c8b26276-1c3e-3642-972b-438dfb4d73d1	c51672b6-ba2f-9e06-55ed-438dfb036fc9	9a12f641-08dd-f9b2-2def-438dfb694df6	2005-11-30 19:42:44	0
e311ee13-d552-a21c-847d-438dfbb577a8	df754949-cb4f-842f-3524-438dfbd0ebaf	dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:42:44	0
e87402de-58e6-1f14-e0b8-438dfbbdac92	e4dec571-0bf6-6d3b-1862-438dfb7fc601	dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:42:45	0
edd2bfcb-4fb0-ab36-70e0-438dfb18c340	ea3ea6dc-e41e-22df-463e-438dfba7cc6b	dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:42:45	0
83f50ee0-57fc-ffa6-aba8-438dfbdc9812	4a310c7f-a855-3016-4069-438dfb96f278	dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:42:46	0
da7f0baf-b4b4-304c-5659-438dfb2ffb29	a04109f5-8aa0-5351-c9c8-438dfb303350	dc83dcc0-d01b-8c04-b643-438dfb9f335e	2005-11-30 19:42:46	0
3aa112d9-ce47-dde6-b758-438dfbf49e5d	37034503-e46c-5c9e-3576-438dfb19d203	340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:42:47	0
40174f97-cf5c-a089-2d50-438dfb7905d8	3c762d0c-9c81-1a65-e751-438dfbd1067a	340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:42:47	0
4ece4830-875c-5259-b248-438dfb47399a	4b309a64-df51-d6e7-2971-438dfb2b4af5	340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:42:48	0
5468f854-d370-2bf2-84cd-438dfb65796b	50a1c14a-9c92-f800-9dfc-438dfb8f977d	340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:42:48	0
5a3f05eb-2125-36f1-aad0-438dfb53dbcf	5650e176-9f18-1938-a7a4-438dfb50ef8d	340cc499-cd7d-5941-40ff-438dfb26c7a9	2005-11-30 19:42:49	0
775d2589-eea6-1f46-b276-438dfba36c0b	73ae3639-0c85-8410-cd18-438dfbc3ff67	70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:42:49	0
7cc87990-f1b6-8e81-0678-438dfb07ae1b	792ad9a0-5acd-9a5f-ee26-438dfb2494b5	70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:42:50	0
822f97fc-0f32-b378-1f13-438dfb7ffc3b	7e9a0570-8a03-5b2b-ec0c-438dfb498845	70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:42:51	0
878d5b43-108f-3db5-9950-438dfb85a00a	83fe497c-ce5c-ca79-9f33-438dfb09f42d	70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:42:51	0
8cea89be-c7f9-8135-1b86-438dfb3d47a8	8951fd23-252e-96f2-4afa-438dfb5396fc	70cfedfa-30fa-5e8d-9c2e-438dfb7dccac	2005-11-30 19:42:52	0
a7a29055-d34d-4a18-c6fb-438dfb64e4e4	a3c0cc47-f742-51ca-00a6-438dfb3c3bec	a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:42:53	0
ad19f5d1-4ffe-3ea8-84f0-438dfb3efcb0	a9712609-b0ce-32f4-72b0-438dfbae5949	a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:42:54	0
b279fe00-3038-dcc2-38ab-438dfbc657ec	aedd4e85-edef-2ba7-0f46-438dfb0c85f0	a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:42:54	0
b7f0046a-df18-224d-1400-438dfbc1e1ce	b45df655-e8ef-1435-31c8-438dfb8caa9c	a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:42:55	0
bd6421be-fd0c-85a7-84d4-438dfb110d9f	b9cad8ed-6961-8cfc-b71e-438dfb3a85af	a0cea6f1-a86f-cfcd-4a58-438dfbb32474	2005-11-30 19:42:55	0
eac9e5a9-85fa-a5ac-58e4-438dfba473b8	e717dacc-2ee1-fb7c-3a63-438dfb730f0f	e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:42:56	0
f03cece9-1787-1f01-4881-438dfbc5d248	ec9f51ad-1a4e-32dd-444f-438dfb1257ac	e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:42:56	0
18400e4d-d4a1-e9a5-bcba-438dfb4a4919	f203a411-d9f2-193e-0a71-438dfb8a7e61	e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:42:57	0
6ea00f03-7d0f-2327-4e67-438dfbaeb3b9	34b80d74-5d65-6122-8264-438dfbd78d32	e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:42:58	0
c3fe0dc1-ea27-b3f4-2107-438dfbc04caf	8ab40434-55d4-c587-02de-438dfb89028e	e42c1718-a0c6-c10a-160f-438dfbe77501	2005-11-30 19:42:58	0
26c0d789-198a-538b-aa7b-438dfb64d8a9	2314bd6c-3fd4-812b-b9dc-438dfb369c57	20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:42:59	0
35d559af-7a74-45dc-6347-438dfb10afae	3226bcd8-a749-e57a-ef24-438dfb04282c	20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:42:59	0
3b3321a4-6021-ab58-eb1a-438dfbb3ff90	37955218-0de7-8557-28d9-438dfbae8b0b	20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:43:00	0
40a64093-c8dd-694b-c572-438dfb2ac867	3cfc9ec0-ac29-0a46-0cb9-438dfbae8480	20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:43:01	0
59a0c949-e7e2-0d12-96e9-438dfb78b484	4c1b6bf2-c094-7d4b-b670-438dfb571251	20292e58-c2b9-29de-299f-438dfb4dc874	2005-11-30 19:43:01	0
76aa0582-0fd8-a8b7-a94b-438dfbe80d63	731015f4-6ee1-eaca-ea52-438dfb8b357e	70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:43:02	0
7c15b5f3-1cbe-4a36-5842-438dfbaaf4e2	78709391-38ac-a0d1-67ea-438dfb16c42e	70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:43:02	0
8b495045-108d-e2b4-0f7e-438dfb5a963e	87894df0-442a-5cff-3d53-438dfb10db85	70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:43:03	0
90ac9dfd-3eaa-d538-8236-438dfb4e78d3	8d0e5b56-526e-3cc6-3cc6-438dfbb9693f	70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:43:04	0
961edaaf-da7f-2061-1ad6-438dfb5c4b8c	926bc55d-fb32-2ad9-db5e-438dfb90c7ec	70266a53-82a3-acff-f7db-438dfb24a59f	2005-11-30 19:43:04	0
b0e95ee7-9c46-b95d-15e7-438dfbfcbbcb	acec6d4d-f5a9-78e4-762d-438dfb02882e	a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:43:05	0
c034979a-668a-4c6f-eafa-438dfb43cd7d	bc9a7bbf-13f6-94dd-d31f-438dfb2bd777	a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:43:06	0
c5a7a640-3dc6-cb12-084a-438dfb41ee4d	c1f7c805-737b-cd22-d6d7-438dfbded56d	a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:43:06	0
cb197803-46cf-a37c-8c9b-438dfbc29fe3	c77944b3-50f5-3285-5026-438dfbabb614	a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:43:07	0
d071b7b9-96f4-de2b-0e6c-438dfb591289	ccd6eb91-308a-531e-bde0-438dfbaa9bb2	a9f8b729-dd46-fa62-6e96-438dfb37f4cb	2005-11-30 19:43:07	0
eaf3ea4c-64b2-9de7-6f98-438dfbd06a44	e7538a91-01a6-db44-e633-438dfb47d144	e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:43:08	0
f051839e-6245-d5fd-6a9a-438dfb04a438	ecbada9b-4090-dbef-127e-438dfb027c4e	e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:43:08	0
19140610-576d-4376-3c00-438dfb41ff0c	f219bb4f-6252-8d2b-21e2-438dfb97eef6	e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:43:09	0
10ec016d-d4a4-93e1-04fc-438dfb3900ce	d4770321-39e0-9981-479b-438dfb3cf7bd	e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:43:09	0
164da357-e5d2-7813-a5e8-438dfb15d666	12acb9eb-18bd-69c9-addb-438dfb205074	e4773e57-f838-8bf1-f04a-438dfbc86a47	2005-11-30 19:43:10	0
30ce227c-3d1b-6c58-db54-438dfb87483e	2d1e1100-c486-9d65-0193-438dfb384c93	2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:43:11	0
3652d59d-29b7-328d-46e0-438dfb7acc63	3294d731-24d9-2f52-918c-438dfbbb9254	2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:43:12	0
3baf5b2b-6dbc-d412-5080-438dfbc9d86d	3812c2f1-74a5-a88f-2f97-438dfb639c6a	2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:43:12	0
55e957cf-82ad-c4ae-e68f-438dfb788099	47798c4d-cb22-3939-2047-438dfb98a81b	2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:43:13	0
5b4a9ed3-a594-add4-44e4-438dfb66afea	57a67e35-018c-17b2-123d-438dfb26cde0	2a41280f-1e6d-838e-c46f-438dfbb2e0d6	2005-11-30 19:43:13	0
789fad71-4c7b-7b18-ba3a-438dfbe1ed3a	74fb12dc-d230-ca1b-8d47-438dfb37e346	71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:43:14	0
92279eb7-5ac4-af57-b229-438dfb7f7882	8e85cbb3-77b2-7999-08bb-438dfba9c6d8	71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:43:15	0
97955c27-884e-bc3a-c94b-438dfbce30d2	93eb2a61-92d0-36b2-c43c-438dfb058141	71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:43:16	0
9d0c0ead-0989-f793-1eb0-438dfbeab956	99624cb9-b58e-c021-8737-438dfb3d1cbb	71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:43:17	0
a25b68fd-c3e7-29a9-d125-438dfb2d9293	9ec7cdc8-7648-b326-6998-438dfb1d1b31	71fc22f1-cb94-037b-8b25-438dfba9f9e3	2005-11-30 19:43:17	0
c711e717-e626-5e15-e42a-438dfb86056c	c3776b9f-7c6e-6944-c13a-438dfbb125d1	c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:43:18	0
cc83b479-9666-0826-6b19-438dfbf343a2	c8da06fb-7dcf-d39d-be87-438dfb705328	c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:43:18	0
e661d0c7-47ff-0a56-78fa-438dfb4892cf	e2a0c9af-2d15-45c5-38e4-438dfba1b1bf	c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:43:19	0
ebb98b64-5478-942e-227f-438dfb0ae5d1	e8243a6c-02ca-e656-160d-438dfba0162c	c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:43:19	0
f117582e-3ecc-acfe-fa48-438dfb80aa1f	ed776add-c143-60f2-9494-438dfbe10471	c082f0d9-9511-ddc3-a24f-438dfbe61104	2005-11-30 19:43:20	0
175b7cfc-38be-e175-4eee-438dfbebba7a	13b49baf-1d70-74d7-2648-438dfbf8fbb6	10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:43:21	0
271d4e55-08d7-dca4-9c49-438dfb6c10b2	236a9d12-1a58-8c14-c7ba-438dfbc30256	10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:43:21	0
2c95c711-0d08-760c-f021-438dfbd5194f	28d9c74d-c976-9a0b-5005-438dfbd70c6d	10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:43:22	0
3201fb83-1610-4c36-cc93-438dfbfbc551	2e698343-56ed-c1dc-2ea1-438dfb35f9ce	10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:43:22	0
3763f01a-2dbe-034b-0185-438dfbd52a8f	33c23b4d-32ce-bfa5-883f-438dfb7bc3fa	10c132e5-9074-b5c9-335c-438dfbfba202	2005-11-30 19:43:23	0
691903a0-9d7c-a1e4-1d89-438dfbf9c524	62eeb8af-1951-8e0f-77f4-438dfb9d9170	6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:43:24	0
6e8f0746-26fc-04b5-ae47-438dfbaf3ca9	6aec5bb9-e9e6-e122-812f-438dfb925530	6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:43:24	0
73e8d781-cdbf-e889-e10e-438dfbf70663	7051ca93-474f-6d62-4412-438dfb438bdf	6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:43:25	0
83b4cda3-8bf0-4a68-735b-438dfbeea28a	80048166-ceeb-9c7a-b0f9-438dfbd3de90	6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:43:25	0
89408a01-b86d-00bf-24f5-438dfbe9acc5	857b4f85-c63b-7e61-5674-438dfb9e91be	6006ab36-84f7-f994-0326-438dfbce1f60	2005-11-30 19:43:26	0
a3bb77f4-ff07-69b7-f686-438dfb7e56ca	a00fc063-60b7-435e-55a8-438dfb79b31c	9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:43:26	0
b3a292a5-3c42-3da1-0bf3-438dfb3858ac	aff7b0b6-cbde-25eb-8bd1-438dfb3a4f11	9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:43:27	0
b91f03b2-384b-6e54-266d-438dfb73a466	b5684963-0c98-076d-03a9-438dfbdc64f6	9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:43:27	0
c8f5f542-824d-0a98-37d1-438dfba104b4	c55cc44f-a479-7272-6cd3-438dfb666039	9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:43:28	0
ce528f56-8a2e-b9dd-6b37-438dfb872a6f	cabd0a9f-b7af-867e-a219-438dfbd2ccdb	9d1f300c-ec5a-6b7f-640f-438dfbca0fd9	2005-11-30 19:43:28	0
e8efcf5b-6f7f-2bda-e3f3-438dfbc55830	e5441e58-5c45-98ac-b546-438dfb4277b3	e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:43:29	0
ee86edf8-7696-00dd-a643-438dfbe754dd	eabde32c-3ba9-bc45-3274-438dfbcc10a1	e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:43:30	0
f3fae105-3c05-cdbb-9464-438dfbb05a0d	f057ee5f-d282-5abc-571d-438dfb0ebb6e	e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:43:31	0
53920811-0576-492c-6798-438dfb19aadf	1a020532-2531-e3d4-e732-438dfbcdfc05	e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:43:31	0
a9af00e8-d7ab-ae67-29f9-438dfb32e2cb	6f3d061d-3115-ca21-012c-438dfbd8eaa5	e25563d8-e9ae-59c1-b16d-438dfb5bac3d	2005-11-30 19:43:32	0
24fce87b-8e3f-35f6-bca8-438dfba356dc	215a8fcf-36ef-64b3-50b0-438dfb64dddb	1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:43:33	0
2a74f11e-e92a-b201-35cd-438dfb8dbe06	26d0de3b-9f4b-42d8-d3da-438dfbfaa28a	1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:43:33	0
2fe2f525-e389-74fe-d41a-438dfb2abe6a	2c3fc630-a159-50bb-e8b1-438dfb7801af	1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:43:34	0
354dbb60-2d54-efb6-b75c-438dfbc6460d	31aac418-61a3-0078-ed35-438dfb9faecf	1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:43:34	0
45605c21-9b4c-c2c2-6c79-438dfbdfe491	41ae0edc-7ac8-49a3-548e-438dfb648288	1e5d7290-9444-62ce-93c4-438dfbebbee8	2005-11-30 19:43:35	0
600710a0-432d-4545-f151-438dfb72208b	5c464834-d92c-501f-043f-438dfbdf70a8	59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:43:36	0
6565563f-c562-9f95-3d90-438dfb444036	61cbd811-f4ce-f2d5-9211-438dfb9215bd	59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:43:37	0
6d790905-d373-f081-7ee5-438dfb80a0f7	697ff154-c55b-dd07-2dfb-438dfb29456a	59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:43:37	0
7da122d0-1532-8677-f80e-438dfbc121b6	7a057201-061b-18bb-ffa0-438dfbe24b0f	59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:43:38	0
83064a70-0a15-361e-24f4-438dfbadd23a	7f667b62-3d28-9e06-0987-438dfbf9989c	59596161-ecce-4e01-e4c0-438dfb4ff125	2005-11-30 19:43:38	0
9d7d725f-e2a0-6052-fede-438dfbf99e3e	99c8a475-c368-13e9-5dca-438dfbbbaf52	96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:43:39	0
a2d99704-4462-5ad3-8f33-438dfbf906ad	9f446574-ef7f-eb78-2a27-438dfb0ba230	96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:43:40	0
a83feffa-945d-d648-3225-438dfb96f87b	a4a20bd5-cbce-40ed-4e33-438dfb6cb08c	96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:43:40	0
adafac0d-3a0e-5359-e18c-438dfb9f75c7	aa0986b4-c8a4-76f2-3599-438dfbbd9f7f	96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:43:41	0
c8c82189-86f2-7e92-4994-438dfbd272a7	c5311de8-db5e-a950-480a-438dfb65fec5	96e57544-3ad1-9a36-ef96-438dfbec0b11	2005-11-30 19:43:41	0
e3c87074-adf7-d62d-5ab8-438dfb9dac1a	e01f61a9-5b04-b01d-98d3-438dfbc010a9	dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:43:42	0
ade10db0-1930-1951-1814-438dfbdd8619	7324060b-3a43-cd42-5281-438dfb08539a	dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:43:42	0
1034c93d-97a7-8f9d-b0db-438dfba60102	c9a00a09-a858-2382-f7f0-438dfbe35c6c	dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:43:43	0
1595fedb-1df8-d663-7ccc-438dfbd3c289	11f86d68-2d4a-ef6f-e481-438dfb10f03d	dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:43:44	0
1af9320c-da0f-6c61-d580-438dfbb71609	17614050-0388-9e6a-96ae-438dfb594150	dd3d85cb-9c27-8d9d-8db5-438dfb85537a	2005-11-30 19:43:44	0
357c794d-0a14-8973-fcc3-438dfbbb70f8	31ddbc39-bab0-d7c8-b6c3-438dfb5d37cb	2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:43:45	0
3ae76479-96f8-73e7-4f1b-438dfba72e5c	3742956e-1e59-195f-6aa6-438dfbeed52c	2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:43:46	0
4042aec6-e28c-5919-236b-438dfb8dc317	3cab122f-81ac-35fe-4aef-438dfbf93695	2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:43:46	0
45b446ca-fafc-7287-00da-438dfb522f70	420d9c7c-8421-4c62-5376-438dfb017858	2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:43:47	0
4b0d0e26-2769-6acd-3252-438dfbfa56c6	477eb582-6f7b-e6dd-6783-438dfb120ff1	2eeaa483-0194-67e8-5bdd-438dfbb60ccb	2005-11-30 19:43:47	0
65fddeb9-3bf8-a58d-d2bf-438dfbbf5190	623aca96-bd62-0751-8065-438dfb2a797d	5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:43:48	0
6e3cfd5c-47d9-afe2-d6ae-438dfbcb2302	6a5a849f-4365-a786-bd09-438dfb002661	5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:43:49	0
73ac0a90-be3e-34cb-dd8a-438dfba39fdc	7007bcd6-baeb-a2f4-9c24-438dfbb71a51	5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:43:49	0
8455f091-2a45-dcdb-ffe8-438dfbf2875a	809aa587-ee9c-0bfa-33f0-438dfbc7b528	5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:43:50	0
89c98aef-5872-9c4d-0ca8-438dfb2afcf2	8620e6fa-cd5f-a69e-7faa-438dfbe16d5b	5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb	2005-11-30 19:43:51	0
a418a7da-b23a-b4d8-3e5b-438dfb7d6dcf	a0716fdf-cd16-fb83-02db-438dfbd1a3bf	9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:43:51	0
a9e8499a-a123-61aa-9c43-438dfb8ef2bb	a5e563fa-9053-1e37-9a8c-438dfb7555ab	9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:43:52	0
af4efdf3-9f81-eccb-c668-438dfb09abf1	abaa28f3-5419-3a30-8182-438dfb5d1486	9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:43:53	0
b4be3b71-37b4-2a3f-255f-438dfb431357	b1193517-186d-2f7e-316d-438dfb4c5545	9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:43:53	0
ba46bcc9-615f-9eb2-0eb0-438dfb82e321	b68582c7-f6da-1591-d632-438dfba5f20f	9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4	2005-11-30 19:43:54	0
eb0ef70e-bcbf-c6ad-fecb-438dfbc21d9d	e77670fa-e536-8537-9e19-438dfb78c234	e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:43:54	0
f085f614-7e33-5258-dd07-438dfbee9bdc	ecd993a8-e571-aa74-3ebb-438dfb650053	e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:43:55	0
1c940f79-0d05-218b-bc2b-438dfb1cffbb	f2499f99-45f6-2914-9ac2-438dfb1e21e6	e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:43:55	0
733a0250-1f9c-e964-7a35-438dfb0bf52a	395203c5-6f79-a5c9-ef7d-438dfb0d9e54	e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:43:56	0
ca32085a-47e4-740e-7438-438dfb47f191	90bb0533-169a-b6ce-c2d5-438dfbc91643	e488e549-954c-86df-9e80-438dfb10a6fa	2005-11-30 19:43:57	0
2749a051-8ea3-640f-33a0-438dfb88dbf9	23a39e95-5bec-9871-3129-438dfbe4c2a0	20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:43:57	0
2cb0be8c-f595-15dd-b9b7-438dfbd01226	29186429-8ebb-3076-9bce-438dfb7c201f	20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:43:57	0
322ca152-ea9d-06d5-3a7e-438dfbae23c1	2e813d20-2c06-84ab-5e72-438dfb46a9c5	20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:43:58	0
378b2703-80f8-6653-00ae-438dfb99b221	33f2290f-5ceb-7c7e-b673-438dfbcd0ecc	20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:43:58	0
4851330c-be1e-8cb2-d661-438dfb1b5a11	44a65c2b-5d24-af1a-c51c-438dfb561e57	20b432f7-cf4d-dd8d-0341-438dfbd532ba	2005-11-30 19:43:59	0
62cfbed8-fbe0-d5c5-d038-438dfbf808e2	5f2fb603-a5e9-7a87-0178-438dfb1395e3	5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:44:00	0
6ad287cf-9b13-9cd4-b90e-438dfb055b92	649def4d-16c9-6ef3-5063-438dfb6c05b9	5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:44:00	0
708ef955-178d-88dc-fb63-438dfb198366	6cb03107-2cdf-700b-414a-438dfb31ff9b	5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:44:01	0
75eb0c52-810a-cbf0-a329-438dfbfe5a1b	7254721b-1081-a6b7-2e04-438dfb0a2e72	5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:44:01	0
86d13dff-5f0f-9ddb-9eb9-438dfbc0fadc	83367873-e708-41ab-98e3-438dfbab40b2	5c4866c0-bccc-d7c9-6ac5-438dfbc9d570	2005-11-30 19:44:02	0
a13763f1-221a-41b4-7ecc-438dfbe2653b	9d9d5f12-0ad3-62d1-22ea-438dfba35a14	9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:44:02	0
a6a1f3d0-a31f-e175-deef-438dfb3ebeba	a2fe3e32-3d2d-eaa2-7b53-438dfbafc05e	9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:44:03	0
ac09cd63-8aa3-a852-c5c1-438dfb6dfd95	a86e58e6-1910-33ff-b2b6-438dfbab30b1	9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:44:04	0
b1682de5-2f29-0109-faf2-438dfb081f77	add3df71-189d-545d-2443-438dfbd3b4bf	9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:44:04	0
b6de89a1-0754-451d-fed8-438dfbed70db	b336f56d-4aee-d395-8d13-438dfb7b7de9	9aadf826-537d-c6b7-e7fe-438dfba9881c	2005-11-30 19:44:05	0
d12df223-5175-4b31-6c66-438dfb0ac600	cd8a6285-a2d2-2f46-f7b5-438dfb46ad1b	caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:44:06	0
e22a0485-ac8e-8218-f69a-438dfbcce0a8	de91ec88-b5a4-5180-566b-438dfbaa4f60	caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:44:06	0
e797b225-c348-8751-866c-438dfb06184a	e3ef3f6f-bb70-f10d-2a1b-438dfbd5191e	caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:44:07	0
ece7a497-5cb8-8649-21fe-438dfb48e073	e9593d41-ce4c-7c67-7d8a-438dfbe71ecc	caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:44:08	0
f24e711a-75c7-6f9b-8151-438dfbad4e3a	eeb18b59-433b-b63a-253b-438dfbfca574	caa4c6ab-ab71-ffb2-ac83-438dfb3457da	2005-11-30 19:44:08	0
2437f59d-131b-4cdb-8141-438dfb814903	2079b053-73dd-7a01-2460-438dfb162c3f	1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:44:09	0
40fd53e0-2ccb-fe59-05ea-438dfb7186b4	3d58e2fb-9e3e-01f3-a4c8-438dfb412e37	1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:44:09	0
466bb65d-5591-d69a-1b18-438dfb9f9994	42ba8189-bc7d-426c-3ffd-438dfb49e234	1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:44:10	0
4bcf6ebb-7c76-e5b1-8feb-438dfb9c519c	48377909-af63-21c4-c02a-438dfbf0cb33	1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:44:11	0
5cffd1c2-a7fa-edc6-1c1f-438dfbc3b98e	596dddcf-515d-3eee-c410-438dfb69ee01	1d98d9e0-4058-aede-3d44-438dfb44af49	2005-11-30 19:44:12	0
7a049691-be16-5735-1634-438dfb2c6140	765665cb-0fa3-1666-3a43-438dfbfe31d8	736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:44:12	0
7f5f10a5-81a7-ba5e-1259-438dfb4196e5	7bc94484-52c2-ef9a-9ab0-438dfb763e49	736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:44:13	0
84bb0062-2b28-8f72-1a76-438dfb715edc	811e432a-e3fe-2eb7-356d-438dfbdf05e9	736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:44:14	0
8a20bc47-8005-48b4-66b8-438dfb58f2e7	86894c76-fc60-8e6d-3f71-438dfba9afa7	736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:44:15	0
8f95116e-0fb9-a798-565f-438dfb12ad91	8be017cf-16a8-63f7-24fa-438dfb641447	736eaf1d-739b-8fbe-46dc-438dfba914ad	2005-11-30 19:44:15	0
aa420601-c0e6-dec8-ca96-438dfb7491b9	a68dce29-191a-ad4f-2293-438dfb6413d3	a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:44:16	0
afb085b8-d664-75bf-df29-438dfbb41056	ac10ee1e-2b75-3941-c40f-438dfb390f3a	a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:44:17	0
b5295bfa-177a-7416-88bd-438dfbcc9518	b182cb0f-bde6-bda2-6c4c-438dfb442506	a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:44:17	0
ba9e80fb-32dc-011e-dfb6-438dfb0affe8	b6eb49ff-eca9-2249-ddea-438dfb6cdd9c	a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:44:18	0
cbd769f3-0650-ff91-3ecc-438dfb502f26	c8435e79-f444-2872-2585-438dfbc3abdf	a3a0858e-b3f3-2557-b597-438dfbf596b3	2005-11-30 19:44:19	0
e665ee6d-b734-9439-e3c4-438dfb442b79	e2add86f-f5cb-1048-6335-438dfb32f6be	dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:44:19	0
fbed0451-81b3-c2ff-0273-438dfb2f0070	bf940d06-a5ba-b1b8-8508-438dfb30fdb7	dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:44:19	0
1543c47f-9b42-d8cb-6fa1-438dfb223a9c	118ca3f0-b6bc-5659-d3c8-438dfb19d06c	dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:44:20	0
1ae9b438-4175-5ec6-8cdc-438dfb7ee2af	172c7d9e-9f33-6afd-db06-438dfb8e47bf	dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:44:21	0
20857e0d-6e59-83b7-b6be-438dfbc5f70f	1cb6f00a-6d9a-120c-fef6-438dfbc4a0ae	dfcc7856-219e-f4ee-968c-438dfb5374f7	2005-11-30 19:44:21	0
540aee85-85d8-f758-bd98-438dfb6ea1b2	503f825c-c5d3-4dd0-01b2-438dfbcbcf7a	4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:44:22	0
59b04a28-f136-a7db-9643-438dfb957ffc	55fad89e-f531-0a85-66d9-438dfbf412df	4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:44:23	0
5f3b2b5b-5ef5-23ee-5c1d-438dfbfded70	5b7f1a8a-77cc-91aa-c8a2-438dfb66b9ad	4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:44:23	0
64c2d316-8788-ffb6-ce54-438dfb0a17d8	610dad12-b64a-2dfd-41e8-438dfbe1d990	4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:44:24	0
6cd5c21d-d058-b155-05ca-438dfb1dbaf8	668c9960-8b1b-1e66-3836-438dfbfd85ef	4d4fb109-a147-164a-7078-438dfb21dc20	2005-11-30 19:44:24	0
89511b15-8d2a-a0ec-fb27-438dfbea6b02	85939b60-7c4e-2aa9-359b-438dfbf4c60c	82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:44:25	0
8edcb6b9-d46c-6e36-cfdf-438dfb444852	8b27fc62-dc39-52f8-22df-438dfb4035d5	82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:44:26	0
9470d97b-af5a-f693-fe3a-438dfbe3331e	90b5c5c7-a27f-d358-be8d-438dfb98602f	82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:44:26	0
a619c293-85e3-7d8d-9e99-438dfbd4d64c	a260ace3-b043-ea69-57e9-438dfb6f14f0	82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:44:27	0
abab5e73-94e2-994d-02ad-438dfb8053a2	a7f51f72-1938-8340-6f11-438dfb4378d8	82991196-40ca-6cef-1cac-438dfb08f497	2005-11-30 19:44:28	0
c6c63361-70f9-06e3-ed48-438dfb8321fa	c3067aac-177c-578c-c55b-438dfb93d492	bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:44:28	0
cc4cf5b9-8b57-e2ba-7935-438dfbd67943	c897d1b1-079b-de1f-3673-438dfbb06dec	bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:44:29	0
d1e689f5-cf00-7d20-a543-438dfb871294	ce2b53da-275f-0d24-9235-438dfb18e8c4	bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:44:30	0
d77658bf-72da-2a82-1265-438dfbc16d27	d3b88440-ac40-dcde-8644-438dfbf12233	bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:44:30	0
e959dc39-a299-1294-39ba-438dfb7a1dfd	e587ffde-ba8d-6832-bf23-438dfb28a6b9	bffce1e9-399b-b344-74da-438dfb464f30	2005-11-30 19:44:30	0
103a3f75-24f6-4c43-820a-438dfbcde452	c8140dfa-4916-aa71-bda1-438dfb5a937e	98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:44:31	0
15ddd93b-6f43-5057-2a46-438dfb543214	12100d4d-0fe2-76a5-094c-438dfb2f4437	98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:44:32	0
1b6fe3a7-aad2-9e33-b084-438dfb5dd6a8	17a48423-22bd-f4cc-5373-438dfbe18f79	98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:44:33	0
20ff8e69-2877-31d2-4c3b-438dfbc916f0	1d3d0e84-3376-b7bd-c026-438dfb7c51b2	98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:44:33	0
268b36ba-6f57-8d0c-df1e-438dfb46fc66	22d9cf79-ab37-1324-784e-438dfb498060	98860e21-aa2a-ef96-d003-438dfb2d8436	2005-11-30 19:44:34	0
41f8e785-d424-2bac-9c76-438dfbec83b0	3e1aaabf-0d27-6147-f9c6-438dfbe7ffdf	3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:44:35	0
54126716-c99b-96b9-e934-438dfb90bd9b	5031aeec-2fcf-0d0b-19bf-438dfbc09be9	3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:44:35	0
59a2ce9d-6d13-2cae-fd53-438dfb556407	55faae00-730f-bd06-f60d-438dfb684eba	3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:44:36	0
5f26cb94-7ca8-0f46-0450-438dfb1e4ece	5b6a5e2d-5715-be08-5375-438dfb38b0ae	3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:44:36	0
64a5c5f6-c59a-04f6-f16c-438dfb28730d	60e6178a-c5fe-433a-a57a-438dfbca8275	3b36216f-a3db-a148-b194-438dfbe17840	2005-11-30 19:44:37	0
81b4e1c2-a35d-3127-7327-438dfbdfafe7	7e059fa3-1b87-3e01-73e4-438dfb3a0c84	7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:44:38	0
871a6fc2-87ee-ed2f-3a0b-438dfb61cf7b	83840714-72a2-0c6b-f61c-438dfb31f0a8	7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:44:38	0
8c6e8b1a-ccfb-56a3-c8af-438dfb9361a3	88da961b-6eea-edd7-8c61-438dfb1fb7c7	7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:44:39	0
91deb9d3-5c3f-3a55-537b-438dfb6f7e4d	8e3a37b5-7a2d-97d6-5fb9-438dfbe6ad66	7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:44:40	0
975dd3be-0d9e-0848-6ea3-438dfb8bd3d6	93b0c46f-cbcc-6ba0-bb57-438dfb62e162	7b28da71-732a-623c-77fa-438dfbe91aa6	2005-11-30 19:44:40	0
b1cd41bf-70d7-58ba-e5b5-438dfb55b621	ae332408-5326-ab29-333a-438dfb726584	ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:44:41	0
b73a5815-326b-42ab-566b-438dfb62e0a4	b393e99d-66da-71d7-0e62-438dfb8aabd6	ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:44:41	0
bcb6a277-d7a8-56d6-110c-438dfb59a14c	b8fa58a2-84fe-741c-361e-438dfb3997fb	ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:44:42	0
c210ee69-348e-452e-72cc-438dfb05a1fe	be7770f8-a502-f351-6bae-438dfba9d1cb	ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:44:42	0
c7812d16-7962-a000-5a32-438dfb0bf234	c3dafe63-8a4c-9bec-138b-438dfbd942ba	ab43ac14-4019-51f9-3490-438dfb6e12de	2005-11-30 19:44:43	0
e1d2d9ad-3aa4-cd4c-edf6-438dfb960450	de307590-3d1d-8d46-426b-438dfb75b64b	db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:44:44	0
f411405f-fe4f-c7ce-bfd6-438dfb4cb2c8	f06bcecb-0bfa-2034-ddc9-438dfbea1744	db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:44:44	0
542d0e72-3164-994c-4ee9-438dfbb40746	1ac90940-c765-4820-2d91-438dfbd236e3	db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:44:45	0
ab130e54-f3c9-c9a2-ab8d-438dfbf1dc6f	70ba04b0-2e7f-d4c5-5af9-438dfbbfa007	db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:44:45	0
100773b1-1344-6e75-b75c-438dfb27faff	c6d80f2f-b9f8-27a9-d8b2-438dfbdc690a	db489ef6-f6ae-6e3b-3b6e-438dfb73fda3	2005-11-30 19:44:46	0
377a3ac4-f178-5e51-7e3f-438dfb24b603	33ba5bd6-4b12-3004-d065-438dfb96fcb0	30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:44:46	0
3cda12d1-0bb1-00d5-739e-438dfb23370b	393ece7b-6406-f777-d758-438dfba6c566	30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:44:47	0
4f06b5a4-2c81-5a86-75e1-438dfb3d39dc	4b69ec7e-07e9-187a-e92b-438dfb841531	30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:44:48	0
5494e65e-d2c1-67ac-6257-438dfba9fbd4	50d5d6cc-be0d-ff98-a0c6-438dfbbd3e8b	30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:44:48	0
5a051e81-ca4e-ac78-e474-438dfb6d7a18	567235f6-3998-f1a2-3729-438dfb510ef9	30921930-dd76-d74b-03d3-438dfbf185c3	2005-11-30 19:44:49	0
77b5a563-fd2b-a42d-6b90-438dfb59c03b	73e75b61-941b-91ab-74cc-438dfb405315	70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:44:50	0
7d1c7253-e4f3-cd87-9826-438dfb35c22a	797da1ba-6d29-8556-0659-438dfb7217c9	70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:44:50	0
8280051a-0d04-7a12-ec7a-438dfb5eb2e2	7ed88ed8-96dc-14fa-7eb1-438dfb6c5e06	70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:44:51	0
87f38e8d-82f0-817f-c1a0-438dfb1526e3	844b5da5-db6d-31c9-02c5-438dfb122bab	70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:44:51	0
8d488e30-2068-4cff-2d48-438dfbef9b94	89bb4474-fe22-bb37-7ae9-438dfbef88d7	70b79b91-4836-3308-36aa-438dfbae2531	2005-11-30 19:44:52	0
a7b5dbb4-fd1a-03e1-7793-438dfb8aa493	a418a66d-143c-a955-767e-438dfb629752	a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:44:53	0
ad3c312e-96d0-9e8e-3983-438dfb7f5bc4	a99b47dc-aa3c-4fb8-4b6c-438dfb8d022f	a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:44:53	0
b2ba2691-7195-3f16-61c3-438dfbd2a30a	af0a2684-4e9b-d9f4-e8fc-438dfbc6855e	a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:44:54	0
b82734f6-f41c-c4da-c834-438dfbeac90b	b47ed421-d047-5f36-291f-438dfb0a142b	a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:44:54	0
bd9f62d8-a683-2fef-db24-438dfb59b704	b9e7c93a-3721-0144-1764-438dfb26b2a5	a1390532-2bad-f7be-a025-438dfbc3db6b	2005-11-30 19:44:55	0
d836df25-52c3-ba45-53b0-438dfb495b55	d487044e-dc8b-5df6-bbf1-438dfb300403	d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:44:55	0
ddb2177e-5d59-90ee-4bcf-438dfb825b9c	da146754-bbfe-8987-7ecb-438dfb4d5bf1	d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:44:56	0
f04a048c-be6e-ac6e-efdc-438dfb2bd0e2	eca4007f-9fd5-cd96-dcc2-438dfb8f14e7	d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:44:57	0
18b80cd1-c456-45d4-3d6c-438dfb6a14f9	f212b19d-0425-c3f2-8c84-438dfbb53ac9	d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:44:57	0
6e0f05e6-cefd-36ec-410d-438dfb146de1	34f00bea-89cb-aaf1-f6d2-438dfb1d6d35	d18b839f-0374-3a4d-c8ae-438dfbcca296	2005-11-30 19:44:58	0
215ef333-6db6-c865-9d5e-438dfbf71f1d	1dbe0954-2b49-e7df-e968-438dfbe2fc5c	1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:44:59	0
26c580cb-9207-927d-5d67-438dfbcd8522	232fd330-36c8-2509-323c-438dfb5d7f42	1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:44:59	0
397f3315-7ce1-0f3b-86d4-438dfb8a4216	35d2568e-2902-cfdf-8e99-438dfb70f9d8	1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:45:00	0
3eed1284-b141-85ea-1565-438dfb6a62bd	3b55d115-fed3-534e-68e6-438dfb934ef7	1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:45:01	0
4446c81d-7dc0-22ad-53f5-438dfb78ddb0	40aeab9f-d034-dd8a-1a83-438dfb66a0af	1acbfe30-7ed3-8742-d41e-438dfb7fffd7	2005-11-30 19:45:01	0
7c26deda-d88e-6ebe-fa8d-438dfb916098	787b8fe9-b64e-3b92-9a98-438dfbcd437d	7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:45:02	0
818f9932-e4b2-56ee-be08-438dfba8ae7b	7dee0fda-eaf5-71b5-1396-438dfba03851	7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:45:02	0
86fbc929-c584-62e8-755f-438dfb733a3b	835731fe-a938-bc5b-703a-438dfb8d2d05	7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:45:03	0
8c58612c-bb4b-fb3d-c644-438dfb3a56c5	88b8e554-31da-f963-8169-438dfbdf20fc	7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:45:04	0
91bf2a17-8ca1-6988-8ad7-438dfb4d6d9b	8e165136-1580-9b72-a69c-438dfb7da0e5	7536903c-aee1-3994-51db-438dfbe974a6	2005-11-30 19:45:04	0
ac28c458-c013-72c8-6837-438dfb059618	a8745bd0-e060-9c3b-762c-438dfb4642fc	a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:45:05	0
b18a0a12-d30c-b656-8807-438dfb8aadcf	adf6b5dd-1ebf-4c54-cfd5-438dfb97d80f	a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:45:06	0
b6f4842f-ed5e-61e0-dd8f-438dfb3ee91b	b348ff5b-6e03-116e-644a-438dfb47c6b4	a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:45:06	0
bc57eca0-5355-c5c8-f4b4-438dfb77bef0	b8b949a6-72a9-4092-da23-438dfb3be107	a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:45:07	0
c1fd168c-7a2c-31b7-f022-438dfb159350	be229585-51eb-70c4-af9e-438dfb66b9a2	a586a963-8c8d-444d-ef96-438dfbb7ec6f	2005-11-30 19:45:08	0
dc63211f-2fd1-e7f3-1c05-438dfb2859d8	d8b61300-024b-bfef-6e8d-438dfbad30fe	d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:45:08	0
e1ca4c2d-3be0-6f4d-df83-438dfb6409ab	de2983b5-13d6-1798-f781-438dfbafdd7f	d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:45:09	0
de80065a-59c5-11bb-c9b6-438dfb9dc6cc	a2fb0eab-2601-f9e8-33cf-438dfb76607a	d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:45:09	0
1349c189-d236-6543-e05a-438dfb366e38	fb810c9f-398a-2f9a-8eda-438dfb300566	d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:45:10	0
18b952c4-ca74-f8c6-c5de-438dfbd88e5d	15180337-b6e4-f183-93f2-438dfb7c3940	d5cef91d-7579-2bf5-e1da-438dfb9c1f01	2005-11-30 19:45:11	0
40c00a33-d4b4-f9dc-7d27-438dfb771696	3d195455-e534-4510-f754-438dfb0a7976	3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:45:12	0
461c4c9d-97ac-f0d2-b8df-438dfbb3d935	42875626-4c32-b06f-ee18-438dfbabba8c	3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:45:12	0
4ba88a3f-010b-d4f7-0573-438dfbc23d6f	47ee1b4c-1805-eec2-683d-438dfb8481c4	3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:45:13	0
50ffb007-0584-42ff-f3d5-438dfb36e12d	4d6f8dda-21c9-831a-db47-438dfb1b941f	3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:45:14	0
568eac33-d3a2-e62c-1557-438dfb6a1e23	52bec775-6191-bd30-29e6-438dfbb6c4e5	3a1d8224-f228-2a6f-0875-438dfbcf8793	2005-11-30 19:45:14	0
73cfd7c2-233e-bd32-c914-438dfb9eb85a	70227b87-d155-eec6-8b6f-438dfb6a7e6e	6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:45:15	0
86f91b76-a405-c0bc-df43-438dfb1de3a4	83371d82-9775-a2ba-3083-438dfbcbecc2	6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:45:15	0
8c56b9b3-f5fa-8be1-788d-438dfbbd8c24	88b994f4-f63a-0db9-10bb-438dfb7d6fd0	6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:45:16	0
91c7ac76-6d5e-9551-d30c-438dfbbfdacd	8e1b7944-33dd-f752-3900-438dfb37bc49	6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:45:17	0
b25f3e44-60fe-3ea6-6811-438dfb6112f8	aec41d0a-c3b1-b6ce-19ca-438dfbcb8221	6d303905-f4e0-640c-af5a-438dfb307c0f	2005-11-30 19:45:18	0
e812e958-2a14-aa4a-772d-438dfbbf4618	e468f7e6-c3c0-6fff-4b95-438dfbae79dd	e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:45:18	0
ed76c5ec-d4ec-2660-b281-438dfbd7ca11	e9dcb7bd-a440-c9cb-0102-438dfbb1b3c5	e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:45:19	0
f2fb7d31-d418-0013-d19a-438dfb251352	ef3957b4-4bb7-3d15-6c4c-438dfbf37110	e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:45:20	0
448c079e-33cb-09b3-3103-438dfb26e902	a5c003c7-44b8-b0d2-3c86-438dfb6373a0	e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:45:20	0
99d60569-5186-0aef-7db1-438dfba60f8f	60ab0cc6-c265-1abd-395f-438dfb2cad90	e17a0d13-3963-7868-ca52-438dfbd6d960	2005-11-30 19:45:21	0
2451e3ff-5ecf-198b-6f80-438dfb57637a	20a22699-ea87-fe79-2ead-438dfb1c0998	1daf85c8-6874-a17b-17cb-438dfb55a65f	2005-11-30 19:45:21	0
37875b01-4594-de35-e349-438dfb294a88	33e0ffc0-d844-bed3-8933-438dfb5f129d	1daf85c8-6874-