/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.type.Type;

public abstract class AbstractCalc
implements Calc {
    protected final Type type;
    protected final Exp exp;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$calc$impl$AbstractCalc;

    protected AbstractCalc(Exp exp) {
        if (!$assertionsDisabled && exp == null) {
            throw new AssertionError();
        }
        this.exp = exp;
        this.type = exp.getType();
    }

    public Type getType() {
        return this.type;
    }

    public void accept(CalcWriter calcWriter) {
        PrintWriter pw = calcWriter.getWriter();
        String name = this.getName();
        pw.print(name);
        Calc[] calcs = this.getCalcs();
        List argumentList = this.getArguments();
        if (calcs.length > 0 || !argumentList.isEmpty()) {
            int i;
            pw.print("(");
            int k = 0;
            for (i = 0; i < calcs.length; ++i) {
                Calc calc = calcs[i];
                if (k++ > 0) {
                    pw.print(", ");
                }
                calc.accept(calcWriter);
            }
            for (i = 0; i < argumentList.size(); ++i) {
                Object o = argumentList.get(i);
                if (k++ > 0) {
                    pw.print(", ");
                }
                pw.print(o);
            }
            pw.print(")");
        }
    }

    protected String getName() {
        String name;
        if (this.exp instanceof ResolvedFunCall) {
            ResolvedFunCall funCall = (ResolvedFunCall)this.exp;
            name = funCall.getFunDef().getName();
        } else {
            int dollar;
            name = this.getClass().getName();
            int dot = name.lastIndexOf(46);
            int dotDollar = Math.max(dot, dollar = name.lastIndexOf(36));
            if (dotDollar >= 0) {
                name = name.substring(dotDollar + 1);
            }
        }
        return name;
    }

    public abstract Calc[] getCalcs();

    public boolean dependsOn(Dimension dimension) {
        return AbstractCalc.anyDepends(this.getCalcs(), dimension);
    }

    public static boolean anyDepends(Calc[] calcs, Dimension dimension) {
        for (int i = 0; i < calcs.length; ++i) {
            Calc calc = calcs[i];
            if (calc == null || !calc.dependsOn(dimension)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyDependsButFirst(Calc[] calcs, Dimension dimension) {
        if (calcs.length == 0) {
            return false;
        }
        if (calcs[0].dependsOn(dimension)) {
            return true;
        }
        if (calcs[0].getType().usesDimension(dimension, true)) {
            return false;
        }
        for (int i = 1; i < calcs.length; ++i) {
            Calc calc = calcs[i];
            if (calc == null || !calc.dependsOn(dimension)) continue;
            return true;
        }
        return false;
    }

    public static boolean butDepends(Calc[] calcs, Dimension dimension) {
        boolean result = true;
        for (int i = 0; i < calcs.length; ++i) {
            Calc calc = calcs[i];
            if (calc == null) continue;
            if (calc.dependsOn(dimension)) {
                return true;
            }
            if (!calc.getType().usesDimension(dimension, true)) continue;
            result = false;
        }
        return result;
    }

    public List getArguments() {
        return Collections.EMPTY_LIST;
    }

    public static Evaluator simplifyEvaluator(Calc calc, Evaluator evaluator) {
        if (evaluator.isNonEmpty()) {
            return evaluator;
        }
        int changeCount = 0;
        Evaluator ev = evaluator;
        Dimension[] dimensions = evaluator.getCube().getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            Member unconstrainedMember;
            Dimension dimension = dimensions[i];
            Member member = ev.getContext(dimension);
            if (member.isAll() || calc.dependsOn(dimension) || member == (unconstrainedMember = member.getHierarchy().getDefaultMember())) continue;
            if (changeCount++ == 0) {
                ev = evaluator.push(unconstrainedMember);
                continue;
            }
            ev.setContext(unconstrainedMember);
        }
        return ev;
    }

    public ExpCompiler.ResultStyle getResultStyle() {
        return ExpCompiler.ResultStyle.VALUE;
    }

    static {
        $assertionsDisabled = !(class$mondrian$calc$impl$AbstractCalc == null ? (class$mondrian$calc$impl$AbstractCalc = AbstractCalc.class$("mondrian.calc.impl.AbstractCalc")) : class$mondrian$calc$impl$AbstractCalc).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

