/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.HashMap;
import java.util.Map;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.TupleValueCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Parameter;
import mondrian.olap.Validator;
import mondrian.olap.fun.DimensionCurrentMemberFunDef;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.HierarchyDimensionFunDef;
import mondrian.olap.fun.LevelHierarchyFunDef;
import mondrian.olap.fun.MemberHierarchyFunDef;
import mondrian.olap.fun.MemberLevelFunDef;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public class AbstractExpCompiler
implements ExpCompiler {
    private final Evaluator evaluator;
    private final Validator validator;
    private final Map parameterSlots = new HashMap();
    private ExpCompiler.ResultStyle[] resultStyles = new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.ANY};
    private static final ExpCompiler.ResultStyle[] MUTABLE_LIST_ONLY;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$calc$impl$AbstractExpCompiler;

    public AbstractExpCompiler(Evaluator evaluator, Validator validator) {
        this.evaluator = evaluator;
        this.validator = validator;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public Calc compile(Exp exp) {
        return exp.accept(this);
    }

    public Calc compile(Exp exp, ExpCompiler.ResultStyle[] preferredResultTypes) {
        if (!$assertionsDisabled && preferredResultTypes == null) {
            throw new AssertionError();
        }
        ExpCompiler.ResultStyle[] save = this.resultStyles;
        this.resultStyles = preferredResultTypes;
        Calc calc = exp.accept(this);
        this.resultStyles = save;
        return calc;
    }

    public MemberCalc compileMember(Exp exp) {
        Type type = exp.getType();
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            return new DimensionCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), dimensionCalc);
        }
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), hierarchyCalc);
        }
        if (!$assertionsDisabled && !(type instanceof MemberType)) {
            throw new AssertionError();
        }
        return (MemberCalc)this.compile(exp);
    }

    public LevelCalc compileLevel(Exp exp) {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberLevelFunDef.CalcImpl((Exp)new DummyExp(LevelType.forType(type)), memberCalc);
        }
        if (!$assertionsDisabled && !(type instanceof LevelType)) {
            throw new AssertionError();
        }
        return (LevelCalc)this.compile(exp);
    }

    public DimensionCalc compileDimension(Exp exp) {
        Type type = exp.getType();
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyDimensionFunDef.CalcImpl(exp, hierarchyCalc);
        }
        if (!$assertionsDisabled && !(type instanceof DimensionType)) {
            throw new AssertionError(type);
        }
        return (DimensionCalc)this.compile(exp);
    }

    public HierarchyCalc compileHierarchy(Exp exp) {
        Type type = exp.getType();
        if (type instanceof DimensionType || type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), memberCalc);
        }
        if (type instanceof LevelType) {
            LevelCalc levelCalc = this.compileLevel(exp);
            return new LevelHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), levelCalc);
        }
        if (!$assertionsDisabled && !(type instanceof HierarchyType)) {
            throw new AssertionError();
        }
        return (HierarchyCalc)this.compile(exp);
    }

    public IntegerCalc compileInteger(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof IntegerCalc) {
            return (IntegerCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{doubleCalc}){

                public int evaluateInteger(Evaluator evaluator) {
                    return (int)doubleCalc.evaluateDouble(evaluator);
                }
            };
        }
        return (IntegerCalc)calc;
    }

    public StringCalc compileString(Exp exp) {
        return (StringCalc)this.compile(exp);
    }

    public ListCalc compileList(Exp exp) {
        return this.compileList(exp, false);
    }

    public ListCalc compileList(Exp exp, boolean mutable) {
        ListCalc listCalc;
        if (mutable) {
            ExpCompiler.ResultStyle[] save = this.resultStyles;
            this.resultStyles = MUTABLE_LIST_ONLY;
            listCalc = (ListCalc)this.compile(exp);
            this.resultStyles = save;
        } else {
            listCalc = (ListCalc)this.compile(exp);
        }
        return listCalc;
    }

    public BooleanCalc compileBoolean(Exp exp) {
        return (BooleanCalc)this.compileScalar(exp, false);
    }

    public DoubleCalc compileDouble(Exp exp) {
        return (DoubleCalc)this.compileScalar(exp, false);
    }

    public TupleCalc compileTuple(Exp exp) {
        return (TupleCalc)this.compile(exp);
    }

    public Calc compileScalar(Exp exp, boolean convert) {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberType memberType = (MemberType)type;
            MemberCalc calc = this.compileMember(exp);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{calc});
        }
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            MemberType memberType = MemberType.forType(type);
            DimensionCurrentMemberFunDef.CalcImpl dimensionCurrentMemberCalc = new DimensionCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(memberType), dimensionCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{dimensionCurrentMemberCalc});
        }
        if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            MemberType memberType = MemberType.forHierarchy(hierarchyType.getHierarchy());
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            HierarchyCurrentMemberFunDef.CalcImpl hierarchyCurrentMemberCalc = new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(memberType), hierarchyCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{hierarchyCurrentMemberCalc});
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            TupleCalc tupleCalc = this.compileTuple(exp);
            TupleValueCalc scalarCalc = new TupleValueCalc(new DummyExp(tupleType.getValueType()), tupleCalc);
            return scalarCalc.optimize();
        }
        if (type instanceof ScalarType) {
            if (convert) {
                if (type instanceof BooleanType) {
                    return this.compileBoolean(exp);
                }
                if (type instanceof NumericType) {
                    return this.compileDouble(exp);
                }
                if (type instanceof StringType) {
                    return this.compileString(exp);
                }
                return this.compile(exp);
            }
            return this.compile(exp);
        }
        return this.compile(exp);
    }

    public ParameterSlot registerParameter(Parameter parameter) {
        ParameterSlot slot = (ParameterSlot)this.parameterSlots.get(parameter);
        if (slot != null) {
            return slot;
        }
        int index = this.parameterSlots.size();
        ParameterSlotImpl slot2 = new ParameterSlotImpl(parameter, index);
        this.parameterSlots.put(parameter, slot2);
        ParameterSlotImpl.access$002(slot2, parameter.getValue());
        Calc calc = parameter.getDefaultExp().accept(this);
        ParameterSlotImpl.access$100(slot2, calc);
        return slot2;
    }

    public ExpCompiler.ResultStyle[] getAcceptableResultStyles() {
        return this.resultStyles;
    }

    static {
        $assertionsDisabled = !(class$mondrian$calc$impl$AbstractExpCompiler == null ? (class$mondrian$calc$impl$AbstractExpCompiler = AbstractExpCompiler.class$("mondrian.calc.impl.AbstractExpCompiler")) : class$mondrian$calc$impl$AbstractExpCompiler).desiredAssertionStatus();
        MUTABLE_LIST_ONLY = new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.MUTABLE_LIST};
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class ParameterSlotImpl
    implements ParameterSlot {
        private final Parameter parameter;
        private final int index;
        private Calc defaultValueCalc;
        private Object value;
        private Object cachedDefaultValue;

        public ParameterSlotImpl(Parameter parameter, int index) {
            this.parameter = parameter;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Calc getDefaultValueCalc() {
            return this.defaultValueCalc;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        private void setDefaultValueCalc(Calc calc) {
            this.defaultValueCalc = calc;
        }

        public void setParameterValue(Object value) {
            this.value = value;
        }

        public Object getParameterValue() {
            return this.value;
        }

        public void setCachedDefaultValue(Object value) {
            this.cachedDefaultValue = value;
        }

        public Object getCachedDefaultValue() {
            return this.cachedDefaultValue;
        }

        static Object access$002(ParameterSlotImpl x0, Object x1) {
            x0.value = x1;
            return x0.value;
        }

        static void access$100(ParameterSlotImpl x0, Calc x1) {
            x0.setDefaultValueCalc(x1);
        }
    }
}

