/*
 * Decompiled with CFR 0.152.
 */
package mondrian.i18n;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Collections;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.DynamicSchemaProcessor;
import org.apache.log4j.Logger;

public class LocalizingDynamicSchemaProcessor
implements DynamicSchemaProcessor {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$i18n$LocalizingDynamicSchemaProcessor == null ? (class$mondrian$i18n$LocalizingDynamicSchemaProcessor = LocalizingDynamicSchemaProcessor.class$("mondrian.i18n.LocalizingDynamicSchemaProcessor")) : class$mondrian$i18n$LocalizingDynamicSchemaProcessor));
    private PropertyResourceBundle i8n;
    private static final Pattern pattern = Pattern.compile("(%\\{.*?\\})");
    private static final int INVALID_LOCALE = 1;
    private static final int FULL_LOCALE = 3;
    private static final int LANG_LOCALE = 2;
    private static final Set countries = Collections.unmodifiableSet(new HashSet(Arrays.asList((Object[])Locale.getISOCountries())));
    private static final Set languages = Collections.unmodifiableSet(new HashSet(Arrays.asList((Object[])Locale.getISOLanguages())));
    private int localeType = 1;
    private String locale;
    private static final /* synthetic */ Class class$mondrian$i18n$LocalizingDynamicSchemaProcessor;

    void populate(String propFile) {
        String localizedPropFileBase = "";
        String[] tokens = propFile.split("\\.");
        for (int i = 0; i < tokens.length - 1; ++i) {
            localizedPropFileBase = localizedPropFileBase + (localizedPropFileBase.length() == 0 ? "" : ".") + tokens[i];
        }
        String[] localePropFilename = new String[this.localeType];
        String[] localeTokens = this.locale.split("\\_");
        int index = this.localeType;
        for (int i = 0; i < this.localeType; ++i) {
            String catName = "";
            for (int j = 0; j <= i - 1; ++j) {
                catName = catName + "_" + localeTokens[j];
            }
            localePropFilename[--index] = localizedPropFileBase + catName + "." + tokens[tokens.length - 1];
        }
        boolean fileExists = false;
        File file = null;
        for (int i = 0; i < this.localeType && !fileExists; ++i) {
            file = new File(localePropFilename[i]);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("populate: file=" + file.getAbsolutePath() + " exists=" + file.exists()));
            }
            if (!file.exists()) {
                LOGGER.warn((Object)("Mondrian: Warning: file '" + file.getAbsolutePath() + "' not found - trying next default locale"));
            }
            fileExists = file.exists();
        }
        if (fileExists) {
            try {
                URL url = Util.toURL(file);
                this.i8n = new PropertyResourceBundle(url.openStream());
                LOGGER.info((Object)("Mondrian: locale file '" + file.getAbsolutePath() + "' loaded"));
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Mondrian: locale file '" + file.getAbsolutePath() + "' could not be loaded (" + e + ")"));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Mondrian: locale file '" + file.getAbsolutePath() + "' could not be loaded (" + e + ")"));
            }
        } else {
            LOGGER.warn((Object)("Mondrian: Warning: no suitable locale file found for locale '" + this.locale + "'"));
        }
    }

    private void loadProperties() {
        String propFile = MondrianProperties.instance().LocalePropFile.get();
        if (propFile != null) {
            this.populate(propFile);
        }
    }

    public String processSchema(URL schemaUrl, Util.PropertyList connectInfo) throws Exception {
        String inputLine;
        this.setLocale(connectInfo.get("Locale"));
        this.loadProperties();
        StringBuffer buf = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(schemaUrl.openStream()));
        while ((inputLine = in.readLine()) != null) {
            buf.append(inputLine);
        }
        in.close();
        String schema = buf.toString();
        if (this.i8n != null) {
            schema = this.doRegExReplacements(schema);
        }
        LOGGER.debug((Object)schema);
        return schema;
    }

    private String doRegExReplacements(String schema) {
        StringBuffer intlSchema = new StringBuffer();
        Matcher match = pattern.matcher(schema);
        while (match.find()) {
            String key = this.extractKey(match.group());
            int start = match.start();
            int end = match.end();
            try {
                String intlProperty = this.i8n.getString(key);
                if (intlProperty == null) continue;
                match.appendReplacement(intlSchema, intlProperty);
            }
            catch (MissingResourceException e) {
                LOGGER.error((Object)("Missing resource for key [" + key + "]"), (Throwable)e);
            }
            catch (NullPointerException e) {
                LOGGER.error((Object)("missing resource key at substring(" + start + "," + end + ")"), (Throwable)e);
            }
        }
        match.appendTail(intlSchema);
        return intlSchema.toString();
    }

    private String extractKey(String group) {
        String key = group.substring(2, group.length() - 1);
        return key;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this.localeType = 1;
        if (locale.indexOf("_") != -1 && locale.length() == 5) {
            if (languages.contains(locale.substring(0, 2)) && countries.contains(locale.substring(3, 5))) {
                this.localeType = 3;
            }
        } else if (locale != null && locale.length() == 2 && languages.contains(locale.substring(0, 2))) {
            this.localeType = 2;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

