/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import mondrian.jolap.Converter;
import mondrian.jolap.CursorSupport;
import mondrian.jolap.MondrianCubeView;
import mondrian.jolap.MondrianEdgeCursor;
import mondrian.jolap.MondrianEdgeView;
import mondrian.jolap.OrderedRelationshipList;
import mondrian.jolap.Relationship;
import mondrian.jolap.RelationshipList;
import mondrian.olap.Axis;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;

class MondrianCubeCursor
extends CursorSupport
implements CubeCursor {
    private RelationshipList pageEdge = new RelationshipList(Meta.pageEdge);
    private OrderedRelationshipList ordinateEdge = new OrderedRelationshipList(Meta.pageEdge);
    private MondrianCubeView cubeView;

    MondrianCubeCursor(MondrianCubeView cubeView) throws OLAPException {
        super(null, null);
        this.cubeView = cubeView;
        Query query = new Converter().createQuery(cubeView);
        Result result = query.getConnection().execute(query);
        Axis slicerAxis = result.getSlicerAxis();
        Util.assertTrue(cubeView.getPageEdge().size() == 1);
        Iterator pageEdges = cubeView.getPageEdge().iterator();
        while (pageEdges.hasNext()) {
            MondrianEdgeView edgeView = (MondrianEdgeView)pageEdges.next();
            this.pageEdge.add(new MondrianEdgeCursor(this, true, edgeView, slicerAxis));
        }
        Axis[] axes = result.getAxes();
        int axisOffset = 0;
        Util.assertTrue(cubeView.getOrdinateEdge().size() == axes.length);
        Iterator ordinateEdges = cubeView.getOrdinateEdge().iterator();
        while (ordinateEdges.hasNext()) {
            MondrianEdgeView edgeView = (MondrianEdgeView)ordinateEdges.next();
            this.ordinateEdge.add(new MondrianEdgeCursor(this, false, edgeView, axes[axisOffset++]));
        }
    }

    public List getOrdinateEdge() throws OLAPException {
        return this.ordinateEdge;
    }

    public Collection getPageEdge() throws OLAPException {
        return this.pageEdge;
    }

    public void synchronizePages() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    static abstract class Meta {
        static final Relationship pageEdge = new Relationship(class$mondrian$jolap$MondrianCubeCursor == null ? (class$mondrian$jolap$MondrianCubeCursor = Meta.class$("mondrian.jolap.MondrianCubeCursor")) : class$mondrian$jolap$MondrianCubeCursor, "pageEdge", class$mondrian$jolap$MondrianEdgeCursor == null ? (class$mondrian$jolap$MondrianEdgeCursor = Meta.class$("mondrian.jolap.MondrianEdgeCursor")) : class$mondrian$jolap$MondrianEdgeCursor, "pageOwner");
        static final Relationship ordinateEdge = new Relationship(class$mondrian$jolap$MondrianCubeCursor == null ? (class$mondrian$jolap$MondrianCubeCursor = Meta.class$("mondrian.jolap.MondrianCubeCursor")) : class$mondrian$jolap$MondrianCubeCursor, "ordinateEdge", class$mondrian$jolap$MondrianEdgeCursor == null ? (class$mondrian$jolap$MondrianEdgeCursor = Meta.class$("mondrian.jolap.MondrianEdgeCursor")) : class$mondrian$jolap$MondrianEdgeCursor, "ordinateOwner");
        private static final /* synthetic */ Class class$mondrian$jolap$MondrianCubeCursor;
        private static final /* synthetic */ Class class$mondrian$jolap$MondrianEdgeCursor;

        Meta() {
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

