/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import java.util.Collection;
import javax.olap.OLAPException;
import javax.olap.metadata.Hierarchy;
import javax.olap.metadata.Schema;
import mondrian.jolap.AttributeSupport;
import mondrian.jolap.ClassifierSupport;
import mondrian.jolap.MondrianJolapHierarchy;
import mondrian.jolap.MondrianJolapLevel;
import mondrian.jolap.Relationship;
import mondrian.jolap.RelationshipList;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Level;
import mondrian.olap.Property;

class MondrianJolapDimension
extends ClassifierSupport
implements javax.olap.metadata.Dimension {
    Dimension dimension;
    private RelationshipList hierarchy = new RelationshipList(Meta.hierarchy);
    private RelationshipList memberSelection = new RelationshipList(Meta.memberSelection);
    private RelationshipList cubeDimensionAssociation = new RelationshipList(Meta.cubeDimensionAssociation);
    private Hierarchy displayDefault;
    private Schema schema;

    MondrianJolapDimension(Schema schema, Dimension dimension) {
        this.dimension = dimension;
        mondrian.olap.Hierarchy[] hierarchies = dimension.getHierarchies();
        for (int i = 0; i < hierarchies.length; ++i) {
            mondrian.olap.Hierarchy hierarchy = dimension.getHierarchies()[i];
            this.hierarchy.add(new MondrianJolapHierarchy(hierarchy));
            Level[] levels = hierarchy.getLevels();
            for (int j = 0; j < levels.length; ++j) {
                final Level level = levels[j];
                this.memberSelection.add(new MondrianJolapLevel(level, this));
                this.feature.add(new AttributeSupport(){

                    public String getName() {
                        return level.getName();
                    }
                });
                Property[] properties = level.getProperties();
                for (int k = 0; k < properties.length; ++k) {
                    final Property property = properties[k];
                    this.feature.add(new AttributeSupport(){

                        public String getName() {
                            return property.getName();
                        }
                    });
                }
            }
        }
    }

    public void setTime(boolean input) throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public boolean isTime() {
        return this.dimension.getDimensionType() == DimensionType.TimeDimension;
    }

    public void setMeasure(boolean input) throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public boolean isMeasure() {
        return this.dimension.isMeasures();
    }

    public String getName() {
        return this.dimension.getName();
    }

    public Collection getHierarchy() {
        return this.hierarchy;
    }

    public Collection getMemberSelection() {
        return this.memberSelection;
    }

    public Collection getCubeDimensionAssociation() throws OLAPException {
        return this.cubeDimensionAssociation;
    }

    public void setDisplayDefault(Hierarchy input) throws OLAPException {
        this.displayDefault = input;
    }

    public Hierarchy getDisplayDefault() throws OLAPException {
        return this.displayDefault;
    }

    public Schema getSchema() throws OLAPException {
        return this.schema;
    }

    public void setSchema(Schema value) throws OLAPException {
        this.schema = value;
    }

    static class Meta {
        static final Relationship hierarchy = new Relationship(class$mondrian$jolap$MondrianJolapDimension == null ? (class$mondrian$jolap$MondrianJolapDimension = Meta.class$("mondrian.jolap.MondrianJolapDimension")) : class$mondrian$jolap$MondrianJolapDimension, "hierarchy", class$mondrian$jolap$MondrianJolapHierarchy == null ? (class$mondrian$jolap$MondrianJolapHierarchy = Meta.class$("mondrian.jolap.MondrianJolapHierarchy")) : class$mondrian$jolap$MondrianJolapHierarchy, "dimension");
        static final Relationship memberSelection = new Relationship(class$mondrian$jolap$MondrianJolapDimension == null ? (class$mondrian$jolap$MondrianJolapDimension = Meta.class$("mondrian.jolap.MondrianJolapDimension")) : class$mondrian$jolap$MondrianJolapDimension, "memberSelection", class$javax$olap$metadata$MemberSelection == null ? (class$javax$olap$metadata$MemberSelection = Meta.class$("javax.olap.metadata.MemberSelection")) : class$javax$olap$metadata$MemberSelection, "dimension");
        static final Relationship cubeDimensionAssociation = new Relationship(class$mondrian$jolap$MondrianJolapDimension == null ? (class$mondrian$jolap$MondrianJolapDimension = Meta.class$("mondrian.jolap.MondrianJolapDimension")) : class$mondrian$jolap$MondrianJolapDimension, "cubeDimensionAssociation", class$javax$olap$metadata$CubeDimensionAssociation == null ? (class$javax$olap$metadata$CubeDimensionAssociation = Meta.class$("javax.olap.metadata.CubeDimensionAssociation")) : class$javax$olap$metadata$CubeDimensionAssociation);
        private static final /* synthetic */ Class class$mondrian$jolap$MondrianJolapHierarchy;
        private static final /* synthetic */ Class class$mondrian$jolap$MondrianJolapDimension;
        private static final /* synthetic */ Class class$javax$olap$metadata$MemberSelection;
        private static final /* synthetic */ Class class$javax$olap$metadata$CubeDimensionAssociation;

        Meta() {
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

