/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.NamedSet;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

public class NamedSetExpr
extends ExpBase
implements Exp {
    private final NamedSet namedSet;

    public NamedSetExpr(NamedSet namedSet) {
        Util.assertPrecondition(namedSet != null, "namedSet != null");
        this.namedSet = namedSet;
    }

    public NamedSet getNamedSet() {
        return this.namedSet;
    }

    public String toString() {
        return this.namedSet.getUniqueName();
    }

    public Object clone() {
        return new NamedSetExpr(this.namedSet);
    }

    public int getCategory() {
        return 8;
    }

    public Exp accept(Validator validator) {
        NamedSet namedSet2 = this.namedSet.validate(validator);
        if (namedSet2 == this.namedSet) {
            return this;
        }
        return new NamedSetExpr(namedSet2);
    }

    public Calc accept(ExpCompiler compiler) {
        return new AbstractListCalc(this, new Calc[0], false){

            public List evaluateList(Evaluator evaluator) {
                return (List)evaluator.evaluateNamedSet(NamedSetExpr.access$000(NamedSetExpr.this).getName(), NamedSetExpr.access$000(NamedSetExpr.this).getExp());
            }

            public boolean dependsOn(Dimension dimension) {
                return true;
            }
        };
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    public Type getType() {
        return this.namedSet.getType();
    }

    static NamedSet access$000(NamedSetExpr x0) {
        return x0.namedSet;
    }
}

