/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Collections;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Literal;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

public class Id
extends ExpBase
implements Cloneable {
    private final List segments;

    public Id(Segment segment) {
        this.segments = Collections.singletonList((Object)segment);
    }

    private Id(List segments) {
        this.segments = segments;
    }

    public Object clone() {
        return this;
    }

    public int getCategory() {
        return 0;
    }

    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return Util.quoteMdxIdentifier(this.toStringArray());
    }

    public String[] toStringArray() {
        String[] names = new String[this.segments.size()];
        for (int i = 0; i < this.segments.size(); ++i) {
            names[i] = ((Segment)this.segments.get((int)i)).name;
        }
        return names;
    }

    public String getElement(int i) {
        return ((Segment)this.segments.get((int)i)).name;
    }

    public Id append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new Id(newSegments);
    }

    public Exp accept(Validator validator) {
        if (this.segments.size() == 1) {
            Segment s = (Segment)this.segments.get(0);
            if (s.quoting == Quoting.UNQUOTED && validator.getFunTable().isReserved(s.name)) {
                return Literal.createSymbol(s.name.toUpperCase());
            }
        }
        String[] names = this.toStringArray();
        Exp element = Util.lookup(validator.getQuery(), names, true);
        if (element == null) {
            return null;
        }
        return element.accept(validator);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    public void unparse(PrintWriter pw) {
        block5: for (int i = 0; i < this.segments.size(); ++i) {
            Segment s = (Segment)this.segments.get(i);
            if (i > 0) {
                pw.print(".");
            }
            switch (s.quoting.ordinal) {
                case 0: {
                    pw.print(s.name);
                    continue block5;
                }
                case 2: {
                    pw.print("&[" + Util.mdxEncodeString(s.name) + "]");
                    continue block5;
                }
                case 1: {
                    pw.print("[" + Util.mdxEncodeString(s.name) + "]");
                }
            }
        }
    }

    public static class Quoting
    extends EnumeratedValues.BasicValue {
        public static final int UNQUOTED_ORDINAL = 0;
        public static final Quoting UNQUOTED = new Quoting("UNQUOTED", 0);
        public static final int QUOTED_ORDINAL = 1;
        public static final Quoting QUOTED = new Quoting("QUOTED", 1);
        public static final int KEY_ORDINAL = 2;
        public static final Quoting KEY = new Quoting("KEY", 2);

        private Quoting(String name, int ordinal) {
            super(name, ordinal, null);
        }
    }

    public static class Segment {
        public final String name;
        public final Quoting quoting;

        public Segment(String name, Quoting quoting) {
            this.name = name;
            this.quoting = quoting;
        }
    }
}

