/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;

class AddCalculatedMembersFunDef
extends FunDefBase {
    static final AddCalculatedMembersFunDef instance = new AddCalculatedMembersFunDef();

    private AddCalculatedMembersFunDef() {
        super("AddCalculatedMembers", "AddCalculatedMembers(<Set>)", "Adds calculated members to a set.", "fxx");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public List evaluateList(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                return AddCalculatedMembersFunDef.access$000(AddCalculatedMembersFunDef.this, list, evaluator);
            }
        };
    }

    private List addCalculatedMembers(List memberList, Evaluator evaluator) {
        HashMap levelMap = new HashMap();
        Dimension dim = null;
        Iterator<Object> it = memberList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Member)) {
                throw AddCalculatedMembersFunDef.newEvalException(this, "Only single dimension members allowed in set for AddCalculatedMembers");
            }
            Member member = (Member)obj;
            if (dim == null) {
                dim = member.getDimension();
            } else if (dim != member.getDimension()) {
                throw AddCalculatedMembersFunDef.newEvalException(this, "Only members from the same dimension are allowed in the AddCalculatedMembers set: " + dim.toString() + " vs " + member.getDimension().toString());
            }
            if (levelMap.containsKey(member.getLevel())) continue;
            levelMap.put(member.getLevel(), null);
        }
        ArrayList workingList = new ArrayList(memberList);
        SchemaReader schemaReader = evaluator.getQuery().getSchemaReader(true);
        it = levelMap.keySet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            List calcMemberList = schemaReader.getCalculatedMembers(level);
            workingList.addAll(calcMemberList);
        }
        memberList = workingList;
        return memberList;
    }

    static List access$000(AddCalculatedMembersFunDef x0, List x1, Evaluator x2) {
        return x0.addCalculatedMembers(x1, x2);
    }
}

