/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;

class CaseMatchFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl(null);

    private CaseMatchFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        final Calc valueCalc = compiler.compileScalar(args[0], true);
        calcList.add(valueCalc);
        int matchCount = (args.length - 1) / 2;
        final Calc[] matchCalcs = new Calc[matchCount];
        final Calc[] exprCalcs = new Calc[matchCount];
        int j = 1;
        for (int i = 0; i < exprCalcs.length; ++i) {
            matchCalcs[i] = compiler.compileScalar(args[j++], true);
            calcList.add(matchCalcs[i]);
            exprCalcs[i] = compiler.compileScalar(args[j++], true);
            calcList.add(exprCalcs[i]);
        }
        final ConstantCalc defaultCalc = args.length % 2 == 0 ? compiler.compileScalar(args[args.length - 1], true) : ConstantCalc.constantNull(call.getType());
        calcList.add(defaultCalc);
        final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        return new AbstractCalc(call){

            public Object evaluate(Evaluator evaluator) {
                Object value = valueCalc.evaluate(evaluator);
                for (int i = 0; i < matchCalcs.length; ++i) {
                    Object match = matchCalcs[i].evaluate(evaluator);
                    if (!match.equals(value)) continue;
                    return exprCalcs[i].evaluate(evaluator);
                }
                return defaultCalc.evaluate(evaluator);
            }

            public Calc[] getCalcs() {
                return calcs;
            }
        };
    }

    CaseMatchFunDef(FunDef x0, 1 x1) {
        this(x0);
    }

    private static class ResolverImpl
    extends ResolverBase {
        private ResolverImpl() {
            super("_CaseMatch", "Case <Expression> When <Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various expressions, and returns the corresponding expression for the first which matches a particular value.", Syntax.Case);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length < 3) {
                return null;
            }
            int valueType = args[0].getCategory();
            int returnType = args[2].getCategory();
            int j = 0;
            int clauseCount = (args.length - 1) / 2;
            int mismatchingArgs = 0;
            if (!validator.canConvert(args[j++], valueType, conversionCount)) {
                ++mismatchingArgs;
            }
            for (int i = 0; i < clauseCount; ++i) {
                if (!validator.canConvert(args[j++], valueType, conversionCount)) {
                    ++mismatchingArgs;
                }
                if (validator.canConvert(args[j++], returnType, conversionCount)) continue;
                ++mismatchingArgs;
            }
            if (j < args.length && !validator.canConvert(args[j++], returnType, conversionCount)) {
                ++mismatchingArgs;
            }
            Util.assertTrue(j == args.length);
            if (mismatchingArgs != 0) {
                return null;
            }
            FunDef dummy = ResolverImpl.createDummyFunDef(this, returnType, args);
            return new CaseMatchFunDef(dummy, null);
        }

        public boolean requiresExpression(int k) {
            return true;
        }

        ResolverImpl(1 x0) {
            this();
        }
    }
}

