/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import com.rc.retroweaver.runtime.Arrays;
import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.NumericType;

class DescendantsFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$olap$fun$DescendantsFunDef;

    public DescendantsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        int flag = 1;
        if (call.getArgCount() == 1) {
            flag = 7;
        }
        boolean depthSpecified = call.getArgCount() >= 2 ? call.getArg(1).getType() instanceof NumericType : false;
        if (call.getArgCount() >= 3) {
            flag = FunUtil.getLiteralArg(call, 2, 1, Flags.instance);
        }
        final boolean self = FunUtil.checkFlag(flag, 1, true);
        final boolean before = FunUtil.checkFlag(flag, 4, true);
        final boolean after = FunUtil.checkFlag(flag, 2, true);
        final boolean leaves = FunUtil.checkFlag(flag, 8, true);
        if (depthSpecified && leaves) {
            final IntegerCalc depthCalc = call.getArgCount() > 1 ? compiler.compileInteger(call.getArg(1)) : null;
            return new AbstractListCalc(call, new Calc[]{memberCalc, depthCalc}){

                public List evaluateList(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    ArrayList result = new ArrayList();
                    int depth = depthCalc.evaluateInteger(evaluator);
                    if (depth < 0) {
                        depth = -1;
                    }
                    SchemaReader schemaReader = evaluator.getSchemaReader();
                    DescendantsFunDef.access$000(member, result, schemaReader, depth);
                    FunUtil.hierarchize(result, false);
                    return result;
                }
            };
        }
        if (depthSpecified) {
            final IntegerCalc depthCalc = call.getArgCount() > 1 ? compiler.compileInteger(call.getArg(1)) : null;
            return new AbstractListCalc(call, new Calc[]{memberCalc, depthCalc}){

                public List evaluateList(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    ArrayList result = new ArrayList();
                    int depth = depthCalc.evaluateInteger(evaluator);
                    SchemaReader schemaReader = evaluator.getSchemaReader();
                    DescendantsFunDef.access$100(member, result, schemaReader, depth, before, self, after, evaluator);
                    FunUtil.hierarchize(result, false);
                    return result;
                }
            };
        }
        final LevelCalc levelCalc = call.getArgCount() > 1 ? compiler.compileLevel(call.getArg(1)) : null;
        return new AbstractListCalc(call, new Calc[]{memberCalc, levelCalc}){

            public List evaluateList(Evaluator evaluator) {
                Evaluator context = evaluator.isNonEmpty() ? evaluator : null;
                Member member = memberCalc.evaluateMember(evaluator);
                ArrayList result = new ArrayList();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                Level level = levelCalc != null ? levelCalc.evaluateLevel(evaluator) : member.getLevel();
                DescendantsFunDef.descendantsByLevel(schemaReader, member, level, result, before, self, after, leaves, context);
                FunUtil.hierarchize(result, false);
                return result;
            }
        };
    }

    private static void descendantsByDepth(Member member, List result, SchemaReader schemaReader, int depthLimitFinal, boolean before, boolean self, boolean after, Evaluator context) {
        Object[] children = new Member[]{member};
        int depth = 0;
        while (true) {
            if (depth == depthLimitFinal) {
                if (self) {
                    DescendantsFunDef.addAll((List)result, (Object[])children);
                }
                if (!after) {
                    break;
                }
            } else if (depth < depthLimitFinal) {
                if (before) {
                    DescendantsFunDef.addAll((List)result, (Object[])children);
                }
            } else {
                if (!after) break;
                DescendantsFunDef.addAll((List)result, (Object[])children);
            }
            if ((children = schemaReader.getMemberChildren((Member[])children, context)).length == 0) break;
            ++depth;
        }
    }

    private static void descendantsLeavesByDepth(Member member, List result, SchemaReader schemaReader, int depthLimit) {
        if (!schemaReader.isDrillable(member)) {
            if (depthLimit >= 0) {
                result.add(member);
            }
            return;
        }
        Member[] children = new Member[]{member};
        for (int depth = 0; depthLimit == -1 || depth <= depthLimit; ++depth) {
            if ((children = schemaReader.getMemberChildren(children)).length == 0) {
                throw Util.newInternal("drillable member must have children");
            }
            ArrayList<Member> nextChildren = new ArrayList<Member>();
            for (int i = 0; i < children.length; ++i) {
                Member child = children[i];
                if (schemaReader.isDrillable(child)) {
                    nextChildren.add(child);
                    continue;
                }
                result.add(child);
            }
            if (nextChildren.isEmpty()) {
                return;
            }
            children = nextChildren.toArray(new Member[nextChildren.size()]);
        }
    }

    static void descendantsByLevel(SchemaReader schemaReader, Member ancestor, Level level, List result, boolean before, boolean self, boolean after, boolean leaves, Evaluator context) {
        int levelDepth = level.getDepth();
        Member[] members = new Member[]{ancestor};
        if (leaves) {
            ArrayList nextMembers;
            if (!$assertionsDisabled && (before || self || after)) {
                throw new AssertionError();
            }
            do {
                nextMembers = new ArrayList();
                for (int i = 0; i < members.length; ++i) {
                    Member member = members[i];
                    int currentDepth = member.getLevel().getDepth();
                    Object[] childMembers = schemaReader.getMemberChildren(member, context);
                    if (childMembers.length == 0) {
                        if (currentDepth != levelDepth) continue;
                        result.add(member);
                        continue;
                    }
                    if (currentDepth > levelDepth) continue;
                    nextMembers.addAll(Arrays.asList((Object[])childMembers));
                }
            } while ((members = nextMembers.toArray(new Member[nextMembers.size()])).length > 0);
        } else {
            ArrayList<Member> fertileMembers = new ArrayList<Member>();
            do {
                fertileMembers.clear();
                for (int i = 0; i < members.length; ++i) {
                    Member member = members[i];
                    int currentDepth = member.getLevel().getDepth();
                    if (currentDepth == levelDepth) {
                        if (self) {
                            result.add(member);
                        }
                        if (!after) continue;
                        fertileMembers.add(member);
                        continue;
                    }
                    if (currentDepth < levelDepth) {
                        if (before) {
                            result.add(member);
                        }
                        fertileMembers.add(member);
                        continue;
                    }
                    if (!after) continue;
                    result.add(member);
                    fertileMembers.add(member);
                }
                members = new Member[fertileMembers.size()];
                members = fertileMembers.toArray(members);
            } while ((members = schemaReader.getMemberChildren(members, context)).length > 0);
        }
    }

    static void access$000(Member x0, List x1, SchemaReader x2, int x3) {
        DescendantsFunDef.descendantsLeavesByDepth(x0, x1, x2, x3);
    }

    static void access$100(Member x0, List x1, SchemaReader x2, int x3, boolean x4, boolean x5, boolean x6, Evaluator x7) {
        DescendantsFunDef.descendantsByDepth(x0, x1, x2, x3, x4, x5, x6, x7);
    }

    static {
        $assertionsDisabled = !(class$mondrian$olap$fun$DescendantsFunDef == null ? (class$mondrian$olap$fun$DescendantsFunDef = DescendantsFunDef.class$("mondrian.olap.fun.DescendantsFunDef")) : class$mondrian$olap$fun$DescendantsFunDef).desiredAssertionStatus();
        Resolver = new ReflectiveMultiResolver("Descendants", "Descendants(<Member>[, <Level>[, <Desc_flag>]])", "Returns the set of descendants of a member at a specified level, optionally including or excluding descendants in other levels.", new String[]{"fxm", "fxml", "fxmly", "fxmn", "fxmny"}, class$mondrian$olap$fun$DescendantsFunDef == null ? (class$mondrian$olap$fun$DescendantsFunDef = DescendantsFunDef.class$("mondrian.olap.fun.DescendantsFunDef")) : class$mondrian$olap$fun$DescendantsFunDef, Flags.instance.getNames());
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int SELF = 1;
        public static final int AFTER = 2;
        public static final int BEFORE = 4;
        public static final int BEFORE_AND_AFTER = 6;
        public static final int SELF_AND_AFTER = 3;
        public static final int SELF_AND_BEFORE = 5;
        public static final int SELF_BEFORE_AFTER = 7;
        public static final int LEAVES = 8;

        private Flags() {
            super(new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, new int[]{1, 2, 4, 6, 3, 5, 7, 8});
        }
    }
}

