/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class DrilldownLevelFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("DrilldownLevel", "DrilldownLevel(<Set>[, <Level>]) or DrilldownLevel(<Set>, , <Index>)", "Drills down the members of a set, at a specified level, to one level below. Alternatively, drills down on a specified dimension in the set.", new String[]{"fxx", "fxxl"}, class$mondrian$olap$fun$DrilldownLevelFunDef == null ? (class$mondrian$olap$fun$DrilldownLevelFunDef = DrilldownLevelFunDef.class$("mondrian.olap.fun.DrilldownLevelFunDef")) : class$mondrian$olap$fun$DrilldownLevelFunDef);
    private static final /* synthetic */ Class class$mondrian$olap$fun$DrilldownLevelFunDef;

    public DrilldownLevelFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final LevelCalc levelCalc = call.getArgCount() > 1 ? compiler.compileLevel(call.getArg(1)) : null;
        return new AbstractListCalc(call, new Calc[]{listCalc, levelCalc}){

            public List evaluateList(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                if (list.size() == 0) {
                    return list;
                }
                int searchDepth = -1;
                if (levelCalc != null) {
                    Level level = levelCalc.evaluateLevel(evaluator);
                    searchDepth = level.getDepth();
                }
                return DrilldownLevelFunDef.this.drill(searchDepth, list, evaluator);
            }
        };
    }

    List drill(int searchDepth, List list, Evaluator evaluator) {
        if (searchDepth == -1) {
            searchDepth = ((Member)list.get(0)).getLevel().getDepth();
            int m = list.size();
            for (int i = 1; i < m; ++i) {
                Member member = (Member)list.get(i);
                int memberDepth = member.getLevel().getDepth();
                if (memberDepth <= searchDepth) continue;
                searchDepth = memberDepth;
            }
        }
        ArrayList<Member> drilledSet = new ArrayList<Member>();
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            Member nextMember;
            Member member = (Member)list.get(i);
            drilledSet.add(member);
            Member member2 = nextMember = i == m - 1 ? null : (Member)list.get(i + 1);
            if (member.getLevel().getDepth() != searchDepth || FunUtil.isAncestorOf(member, nextMember, true)) continue;
            Member[] childMembers = evaluator.getSchemaReader().getMemberChildren(member);
            for (int j = 0; j < childMembers.length; ++j) {
                drilledSet.add(childMembers[j]);
            }
        }
        return drilledSet;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

