/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;

class FilterFunDef
extends FunDefBase {
    static final FilterFunDef instance = new FilterFunDef();

    private FilterFunDef() {
        super("Filter", "Filter(<Set>, <Search Condition>)", "Returns the set resulting from filtering a set based on a search condition.", "fxxb");
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final BooleanCalc calc = compiler.compileBoolean(call.getArg(1));
        if (((SetType)listCalc.getType()).getElementType() instanceof MemberType) {
            return new AbstractListCalc(call, new Calc[]{listCalc, calc}){

                public List evaluateList(Evaluator evaluator) {
                    SchemaReader schemaReader = evaluator.getSchemaReader();
                    NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                    if (nativeEvaluator != null) {
                        return (List)nativeEvaluator.execute();
                    }
                    List members = listCalc.evaluateList(evaluator);
                    ArrayList<Member> result = new ArrayList<Member>();
                    Evaluator evaluator2 = evaluator.push();
                    int count = members.size();
                    for (int i = 0; i < count; ++i) {
                        Member member = (Member)members.get(i);
                        evaluator2.setContext(member);
                        if (!calc.evaluateBoolean(evaluator2)) continue;
                        result.add(member);
                    }
                    return result;
                }

                public boolean dependsOn(Dimension dimension) {
                    return 1.anyDependsButFirst(this.getCalcs(), dimension);
                }
            };
        }
        return new AbstractListCalc(call, new Calc[]{listCalc, calc}){

            public List evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (List)nativeEvaluator.execute();
                }
                List tupleList = listCalc.evaluateList(evaluator);
                ArrayList<Member[]> result = new ArrayList<Member[]>();
                Evaluator evaluator2 = evaluator.push();
                int count = tupleList.size();
                for (int i = 0; i < count; ++i) {
                    Member[] members = (Member[])tupleList.get(i);
                    evaluator2.setContext(members);
                    if (!calc.evaluateBoolean(evaluator2)) continue;
                    result.add(members);
                }
                return result;
            }

            public boolean dependsOn(Dimension dimension) {
                return 2.anyDependsButFirst(this.getCalcs(), dimension);
            }
        };
    }
}

