/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;

class RangeFunDef
extends FunDefBase {
    static final RangeFunDef instance = new RangeFunDef();

    private RangeFunDef() {
        super(":", "<Member> : <Member>", "Infix colon operator returns the set of members between a given pair of members.", "ixmm");
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc0 = compiler.compileMember(call.getArg(0));
        final MemberCalc memberCalc1 = compiler.compileMember(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{memberCalc0, memberCalc1}){

            public List evaluateList(Evaluator evaluator) {
                Member member0 = memberCalc0.evaluateMember(evaluator);
                Member member1 = memberCalc1.evaluateMember(evaluator);
                if (member0.isNull() || member1.isNull()) {
                    return Collections.EMPTY_LIST;
                }
                if (member0.getLevel() != member1.getLevel()) {
                    throw evaluator.newEvalException(call.getFunDef(), "Members must belong to the same level");
                }
                return FunUtil.memberRange(evaluator, member0, member1);
            }
        };
    }
}

