/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;

class SetToStrFunDef
extends FunDefBase {
    public static final FunDefBase instance = new SetToStrFunDef();

    private SetToStrFunDef() {
        super("SetToStr", "SetToStr(<Set>)", "Constructs a string from a set.", "fSx");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        return new AbstractStringCalc(call, new Calc[]{listCalc}){

            public String evaluateString(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                return SetToStrFunDef.strToSet(list);
            }
        };
    }

    static String strToSet(List list) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            Object o = list.get(i);
            SetToStrFunDef.appendMemberOrTuple(buf, o);
        }
        buf.append("}");
        return buf.toString();
    }

    static void appendMemberOrTuple(StringBuffer buf, Object memberOrTuple) {
        if (memberOrTuple instanceof Member) {
            Member member = (Member)memberOrTuple;
            buf.append(member.getUniqueName());
        } else {
            Member[] members = (Member[])memberOrTuple;
            SetToStrFunDef.appendTuple(buf, members);
        }
    }
}

