/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.resource.MondrianResource;

class ToggleDrillStateFunDef
extends FunDefBase {
    static final String[] ReservedWords = new String[]{"RECURSIVE"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("ToggleDrillState", "ToggleDrillState(<Set1>, <Set2>[, RECURSIVE])", "Toggles the drill state of members. This function is a combination of DrillupMember and DrilldownMember.", new String[]{"fxxx", "fxxxy"}, class$mondrian$olap$fun$ToggleDrillStateFunDef == null ? (class$mondrian$olap$fun$ToggleDrillStateFunDef = ToggleDrillStateFunDef.class$("mondrian.olap.fun.ToggleDrillStateFunDef")) : class$mondrian$olap$fun$ToggleDrillStateFunDef, ReservedWords);
    private static final /* synthetic */ Class class$mondrian$olap$fun$ToggleDrillStateFunDef;

    public ToggleDrillStateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        if (call.getArgCount() > 2) {
            throw MondrianResource.instance().ToggleDrillStateRecursiveNotSupported.ex();
        }
        final ListCalc listCalc0 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc1 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

            public List evaluateList(Evaluator evaluator) {
                List list0 = listCalc0.evaluateList(evaluator);
                List list1 = listCalc1.evaluateList(evaluator);
                return ToggleDrillStateFunDef.this.toggleDrillState(evaluator, list0, list1);
            }
        };
    }

    List toggleDrillState(Evaluator evaluator, List v0, List list1) {
        if (list1.isEmpty()) {
            return v0;
        }
        if (v0.isEmpty()) {
            return v0;
        }
        HashSet set = new HashSet();
        set.addAll(list1);
        HashSet set1 = set;
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        int n = v0.size();
        while (i < n) {
            boolean strict;
            Member nextMember;
            Object o = v0.get(i++);
            result.add(o);
            Member m = null;
            int k = -1;
            if (o instanceof Member) {
                if (!set1.contains(o)) continue;
                m = (Member)o;
                k = -1;
            } else {
                Util.assertTrue(o instanceof Member[]);
                Member[] members = (Member[])o;
                for (int j = 0; j < members.length; ++j) {
                    Member member = members[j];
                    if (!set1.contains(member)) continue;
                    k = j;
                    m = member;
                    break;
                }
                if (k == -1) continue;
            }
            boolean isDrilledDown = false;
            if (i < n) {
                Object next = v0.get(i);
                nextMember = k < 0 ? (Member)next : ((Member[])next)[k];
                if (FunUtil.isAncestorOf(m, nextMember, strict = true)) {
                    isDrilledDown = true;
                }
            }
            if (isDrilledDown) {
                Object next;
                do {
                    next = v0.get(i);
                } while (FunUtil.isAncestorOf(m, nextMember = k < 0 ? (Member)next : ((Member[])next)[k], strict = true) && ++i < n);
                continue;
            }
            Member[] children = evaluator.getSchemaReader().getMemberChildren(m);
            for (int j = 0; j < children.length; ++j) {
                if (k < 0) {
                    result.add(children[j]);
                    continue;
                }
                Member[] members = (Member[])((Member[])o).clone();
                members[k] = children[j];
                result.add(members);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

