/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.TypeUtil;
import mondrian.rolap.RolapCube;

public class ValidMeasureFunDef
extends FunDefBase {
    static final ValidMeasureFunDef instance = new ValidMeasureFunDef();

    private ValidMeasureFunDef() {
        super("ValidMeasure", "ValidMeasure(<Tuple>)", "Returns a valid measure in a virtual cube by forcing inapplicable dimensions to their top level.", "fnt");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp arg = call.getArg(0);
        Calc calc = TypeUtil.couldBeMember(arg.getType()) ? compiler.compileMember(arg) : compiler.compileTuple(arg);
        return new CalcImpl(call, calc);
    }

    private static class CalcImpl
    extends AbstractCalc {
        private final Calc calc;

        public CalcImpl(ResolvedFunCall call, Calc calc) {
            super(call);
            this.calc = calc;
        }

        public Object evaluate(Evaluator evaluator) {
            int i;
            Member[] members = this.calc instanceof MemberCalc ? new Member[]{((MemberCalc)this.calc).evaluateMember(evaluator)} : ((TupleCalc)this.calc).evaluateTuple(evaluator);
            RolapCube baseCube = null;
            RolapCube virtualCube = (RolapCube)evaluator.getCube();
            int measurePosition = -1;
            for (int i2 = 0; i2 < members.length; ++i2) {
                if (!members[i2].getDimension().isMeasures()) continue;
                measurePosition = i2;
                break;
            }
            baseCube = this.getBaseCubeofMeasure(evaluator, members[measurePosition], baseCube);
            List vMinusBDimensions = this.getDimensionsToForceToAllLevel(virtualCube, baseCube, members);
            Member[] validMeasureMembers = new Member[vMinusBDimensions.size() + members.length];
            for (i = 0; i < members.length; ++i) {
                validMeasureMembers[i] = members[i];
            }
            for (i = 0; i < vMinusBDimensions.size(); ++i) {
                validMeasureMembers[members.length + i] = ((Dimension)vMinusBDimensions.get(i)).getHierarchy().getDefaultMember();
            }
            if (validMeasureMembers == null) {
                return "";
            }
            evaluator.setContext(validMeasureMembers);
            Object value = evaluator.evaluateCurrent();
            return value;
        }

        public Calc[] getCalcs() {
            return new Calc[]{this.calc};
        }

        private RolapCube getBaseCubeofMeasure(Evaluator evaluator, Member member, RolapCube baseCube) {
            Cube[] cubes = evaluator.getSchemaReader().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                RolapCube cube = (RolapCube)cubes[i];
                if (!cube.isVirtual()) {
                    for (int j = 0; j < cube.getMeasuresMembers().length; ++j) {
                        if (!cube.getMeasuresMembers()[j].getName().equals(member.getName())) continue;
                        baseCube = cube;
                    }
                }
                if (baseCube != null) break;
            }
            return baseCube;
        }

        private List getDimensionsToForceToAllLevel(RolapCube virtualCube, RolapCube baseCube, Member[] memberArray) {
            ArrayList<Dimension> vMinusBDimensions = new ArrayList<Dimension>();
            for (int i = 0; i < virtualCube.getDimensions().length; ++i) {
                boolean foundDim = false;
                for (int j = 0; j < baseCube.getDimensions().length; ++j) {
                    if (!virtualCube.getDimensions()[i].getName().equals(baseCube.getDimensions()[j].getName())) continue;
                    foundDim = true;
                    break;
                }
                if (foundDim || this.isDimInMembersArray(memberArray, virtualCube.getDimensions()[i])) continue;
                vMinusBDimensions.add(virtualCube.getDimensions()[i]);
            }
            return vMinusBDimensions;
        }

        private boolean isDimInMembersArray(Member[] memberArray, Dimension theDimensionToLookFor) {
            for (int i = 0; i < memberArray.length; ++i) {
                if (!memberArray[i].getName().equalsIgnoreCase(theDimensionToLookFor.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean dependsOn(Dimension dimension) {
            return CalcImpl.butDepends(this.getCalcs(), dimension);
        }
    }
}

