/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.type.Type;

public class DimensionType
implements Type {
    private final Dimension dimension;
    private final String digest;
    public static final DimensionType Unknown = new DimensionType(null);

    public DimensionType(Dimension dimension) {
        this.dimension = dimension;
        StringBuffer buf = new StringBuffer("DimensionType<");
        if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public static DimensionType forDimension(Dimension dimension) {
        return new DimensionType(dimension);
    }

    public static DimensionType forType(Type type) {
        return new DimensionType(type.getDimension());
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        return this.dimension == dimension || maybe && this.dimension == null;
    }

    public Hierarchy getHierarchy() {
        return this.dimension == null ? null : (this.dimension.getHierarchies().length > 1 ? null : this.dimension.getHierarchies()[0]);
    }

    public Level getLevel() {
        return null;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String toString() {
        return this.digest;
    }
}

