/*
 * Decompiled with CFR 0.152.
 */
package mondrian.recorder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.recorder.AbstractRecorder;
import org.apache.log4j.Logger;

public class ListRecorder
extends AbstractRecorder {
    private final List errorList = new ArrayList();
    private final List warnList = new ArrayList();
    private final List infoList = new ArrayList();

    public void clear() {
        super.clear();
        this.errorList.clear();
        this.warnList.clear();
        this.infoList.clear();
    }

    public Iterator getErrorEntries() {
        return this.errorList.iterator();
    }

    public Iterator getWarnEntries() {
        return this.warnList.iterator();
    }

    public Iterator getInfoEntries() {
        return this.infoList.iterator();
    }

    protected void recordMessage(String msg, Object info, int msgType) {
        String context = this.getContext();
        Entry e = new Entry(context, msg, msgType, info, null);
        switch (msgType) {
            case 1: {
                this.infoList.add(e);
                break;
            }
            case 2: {
                this.warnList.add(e);
                break;
            }
            case 3: {
                this.errorList.add(e);
                break;
            }
            default: {
                e = new Entry(context, "Unknown message type enum \"" + msgType + "\" for message: " + msg, 2, info, null);
                this.warnList.add(e);
            }
        }
    }

    public void logInfoMessage(Logger logger) {
        if (this.hasInformation()) {
            ListRecorder.logMessage(this.getInfoEntries(), logger);
        }
    }

    public void logWarningMessage(Logger logger) {
        if (this.hasWarnings()) {
            ListRecorder.logMessage(this.getWarnEntries(), logger);
        }
    }

    public void logErrorMessage(Logger logger) {
        if (this.hasErrors()) {
            ListRecorder.logMessage(this.getErrorEntries(), logger);
        }
    }

    static void logMessage(Iterator it, Logger logger) {
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            ListRecorder.logMessage(e, logger);
        }
    }

    static void logMessage(Entry e, Logger logger) {
        ListRecorder.logMessage(e.getContext(), e.getMessage(), e.getMsgType(), logger);
    }

    static class 1 {
    }

    public static class Entry {
        private final String context;
        private final String msg;
        private final int msgType;
        private final Object info;

        private Entry(String context, String msg, int msgType, Object info) {
            this.context = context;
            this.msg = msg;
            this.msgType = msgType;
            this.info = info;
        }

        public String getContext() {
            return this.context;
        }

        public String getMessage() {
            return this.msg;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public Object getInfo() {
            return this.info;
        }

        Entry(String x0, String x1, int x2, Object x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

