/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.aggmatcher.AggGen;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

public class FastBatchingCellReader
implements CellReader {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$FastBatchingCellReader == null ? (class$mondrian$rolap$FastBatchingCellReader = FastBatchingCellReader.class$("mondrian.rolap.FastBatchingCellReader")) : class$mondrian$rolap$FastBatchingCellReader));
    private static boolean generateAggregateSql = MondrianProperties.instance().GenerateAggregateSql.get();
    private final RolapCube cube;
    private final Set pinnedSegments;
    private final Map batches;
    private int requestCount;
    RolapAggregationManager aggMgr = AggregationManager.instance();
    private boolean dirty;
    private static final Logger BATCH_LOGGER;
    private static final /* synthetic */ Class class$mondrian$rolap$FastBatchingCellReader;
    private static final /* synthetic */ Class class$mondrian$rolap$FastBatchingCellReader$Batch;

    public FastBatchingCellReader(RolapCube cube) {
        this.cube = cube;
        this.pinnedSegments = new HashSet();
        this.batches = new HashMap();
    }

    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        Member[] currentMembers = rolapEvaluator.getCurrentMembers();
        CellRequest request = RolapAggregationManager.makeRequest(currentMembers, false, false);
        if (request == null || request.isUnsatisfiable()) {
            return Util.nullValue;
        }
        Object o = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
        if (o == Boolean.TRUE) {
            return RolapUtil.valueNotReadyException;
        }
        if (o != null) {
            return o;
        }
        this.recordCellRequest(request);
        return RolapUtil.valueNotReadyException;
    }

    public int getMissCount() {
        return this.requestCount;
    }

    void recordCellRequest(CellRequest request) {
        if (request.isUnsatisfiable()) {
            return;
        }
        ++this.requestCount;
        BitKey bitkey = request.getConstrainedColumnsBitKey();
        class BatchKey {
            BitKey key;
            RolapStar star;

            BatchKey(BitKey key, RolapStar star) {
                this.key = key;
                this.star = star;
            }

            public int hashCode() {
                return this.key.hashCode() ^ this.star.hashCode();
            }

            public boolean equals(Object other) {
                if (other instanceof BatchKey) {
                    BatchKey bkey = (BatchKey)other;
                    return this.key.equals(bkey.key) && this.star.equals(bkey.star);
                }
                return false;
            }

            public String toString() {
                return this.star.getFactTable().getTableName() + " " + this.key.toString();
            }
        }
        BatchKey key = new BatchKey(bitkey, request.getMeasure().getStar());
        Batch batch = (Batch)this.batches.get(key);
        if (batch == null) {
            batch = new Batch(request);
            this.batches.put(key, batch);
            if (LOGGER.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(100);
                buf.append("FastBatchingCellReader: bitkey=");
                buf.append(request.getConstrainedColumnsBitKey());
                buf.append(Util.nl);
                RolapStar.Column[] columns = request.getConstrainedColumns();
                for (int i = 0; i < columns.length; ++i) {
                    buf.append("  ");
                    buf.append(columns[i]);
                    buf.append(Util.nl);
                }
                LOGGER.debug((Object)buf.toString());
            }
        }
        batch.add(request);
    }

    boolean isDirty() {
        return this.dirty || !this.batches.isEmpty();
    }

    boolean loadAggregations() {
        return this.loadAggregations(null);
    }

    boolean loadAggregations(Query query) {
        long t1 = System.currentTimeMillis();
        this.requestCount = 0;
        if (this.batches.isEmpty() && !this.dirty) {
            return false;
        }
        Iterator it = this.batches.values().iterator();
        while (it.hasNext()) {
            if (query != null) {
                query.checkCancelOrTimeout();
            }
            ((Batch)it.next()).loadAggregation();
        }
        this.batches.clear();
        if (LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("loadAggregation (millis): " + (t2 - t1)));
        }
        this.dirty = false;
        return true;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    static boolean access$002(boolean x0) {
        generateAggregateSql = x0;
        return generateAggregateSql;
    }

    static boolean access$000() {
        return generateAggregateSql;
    }

    static RolapCube access$100(FastBatchingCellReader x0) {
        return x0.cube;
    }

    static Logger access$200() {
        return BATCH_LOGGER;
    }

    static Set access$300(FastBatchingCellReader x0) {
        return x0.pinnedSegments;
    }

    static {
        MondrianProperties.instance().GenerateAggregateSql.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                FastBatchingCellReader.access$002(property.booleanValue());
            }
        });
        BATCH_LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$FastBatchingCellReader$Batch == null ? (class$mondrian$rolap$FastBatchingCellReader$Batch = FastBatchingCellReader.class$("mondrian.rolap.FastBatchingCellReader$Batch")) : class$mondrian$rolap$FastBatchingCellReader$Batch));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    class Batch {
        final RolapStar.Column[] columns;
        final BitKey constrainedColumnsBitKey;
        final List measuresList = new ArrayList();
        final Set[] valueSets;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$FastBatchingCellReader;

        public Batch(CellRequest request) {
            this.columns = request.getConstrainedColumns();
            this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
            this.valueSets = new HashSet[this.columns.length];
            for (int i = 0; i < this.valueSets.length; ++i) {
                this.valueSets[i] = new HashSet();
            }
        }

        public void add(CellRequest request) {
            List values = request.getValueList();
            for (int j = 0; j < this.columns.length; ++j) {
                this.valueSets[j].add(values.get(j));
            }
            RolapStar.Measure measure = request.getMeasure();
            if (!this.measuresList.contains(measure)) {
                if (!$assertionsDisabled && this.measuresList.size() != 0 && measure.getStar() != ((RolapStar.Measure)this.measuresList.get(0)).getStar()) {
                    throw new AssertionError((Object)"Measure must belong to same star as other measures");
                }
                this.measuresList.add(measure);
            }
        }

        private RolapStar getStar() {
            RolapStar.Measure measure = (RolapStar.Measure)this.measuresList.get(0);
            RolapStar star = measure.getStar();
            return star;
        }

        void loadAggregation() {
            int measureCount;
            if (FastBatchingCellReader.access$000()) {
                RolapCube cube = FastBatchingCellReader.access$100(FastBatchingCellReader.this);
                if (cube == null || cube.isVirtual()) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("AggGen: Sorry, can not create SQL for virtual Cube \"");
                    buf.append(FastBatchingCellReader.access$100(FastBatchingCellReader.this).getName());
                    buf.append("\", operation not currently supported");
                    FastBatchingCellReader.access$200().error((Object)buf.toString());
                } else {
                    AggGen aggGen = new AggGen(FastBatchingCellReader.access$100(FastBatchingCellReader.this).getStar(), this.columns);
                    if (aggGen.isReady()) {
                        System.out.println("createLost:" + Util.nl + aggGen.createLost());
                        System.out.println("insertIntoLost:" + Util.nl + aggGen.insertIntoLost());
                        System.out.println("createCollapsed:" + Util.nl + aggGen.createCollapsed());
                        System.out.println("insertIntoCollapsed:" + Util.nl + aggGen.insertIntoCollapsed());
                    } else {
                        FastBatchingCellReader.access$200().error((Object)"AggGen failed");
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            AggregationManager aggmgr = AggregationManager.instance();
            ColumnConstraint[][] constraintses = new ColumnConstraint[this.columns.length][];
            for (int j = 0; j < this.columns.length; ++j) {
                Object[] constraints;
                Set valueSet = this.valueSets[j];
                if (valueSet == null) {
                    constraints = null;
                } else {
                    constraints = new ColumnConstraint[valueSet.size()];
                    valueSet.toArray(constraints);
                    Arrays.sort((Object[])constraints);
                }
                constraintses[j] = constraints;
            }
            if (!this.getStar().getSqlQueryDialect().allowsCountDistinct()) {
                RolapStar.Measure distinctMeasure;
                while ((distinctMeasure = this.getFirstDistinctMeasure(this.measuresList)) != null) {
                    String expr = distinctMeasure.getExpression().getGenericExpression();
                    ArrayList<RolapStar.Measure> distinctMeasuresList = new ArrayList<RolapStar.Measure>();
                    int i = 0;
                    while (i < this.measuresList.size()) {
                        RolapStar.Measure measure = (RolapStar.Measure)this.measuresList.get(i);
                        if (measure.getAggregator().isDistinct() && measure.getExpression().getGenericExpression().equals(expr)) {
                            this.measuresList.remove(i);
                            distinctMeasuresList.add(distinctMeasure);
                            continue;
                        }
                        ++i;
                    }
                    RolapStar.Measure[] measures = distinctMeasuresList.toArray(new RolapStar.Measure[distinctMeasuresList.size()]);
                    aggmgr.loadAggregation(measures, this.columns, this.constrainedColumnsBitKey, constraintses, FastBatchingCellReader.access$300(FastBatchingCellReader.this));
                }
            }
            if ((measureCount = this.measuresList.size()) > 0) {
                RolapStar.Measure[] measures = this.measuresList.toArray(new RolapStar.Measure[measureCount]);
                aggmgr.loadAggregation(measures, this.columns, this.constrainedColumnsBitKey, constraintses, FastBatchingCellReader.access$300(FastBatchingCellReader.this));
            }
            if (FastBatchingCellReader.access$200().isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                FastBatchingCellReader.access$200().debug((Object)("Batch.loadAggregation (millis) " + (t2 - t1)));
            }
        }

        RolapStar.Measure getFirstDistinctMeasure(List measuresList) {
            for (int i = 0; i < measuresList.size(); ++i) {
                RolapStar.Measure measure = (RolapStar.Measure)measuresList.get(i);
                if (!measure.getAggregator().isDistinct()) continue;
                return measure;
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$FastBatchingCellReader == null ? (class$mondrian$rolap$FastBatchingCellReader = Batch.class$("mondrian.rolap.FastBatchingCellReader")) : class$mondrian$rolap$FastBatchingCellReader).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

