/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Map;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.agg.CellRequest;

public abstract class RolapAggregationManager
implements CellReader {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapAggregationManager;

    static CellRequest makeRequest(Member[] members, boolean extendedContext, boolean drillThrough) {
        RolapLevel level;
        RolapMember member;
        RolapStar.Measure starMeasure;
        RolapStoredMeasure measure;
        if (members[0] instanceof RolapStoredMeasure) {
            measure = (RolapStoredMeasure)members[0];
            starMeasure = (RolapStar.Measure)measure.getStarMeasure();
            if (!$assertionsDisabled && starMeasure == null) {
                throw new AssertionError();
            }
        } else {
            return null;
        }
        RolapStar star = starMeasure.getStar();
        CellRequest request = new CellRequest(starMeasure, extendedContext, drillThrough);
        Map mapLevelToColumn = star.getMapLevelToColumn(measure.getCube());
        if (request.extendedContext) {
            for (int i = 1; i < members.length; ++i) {
                member = (RolapMember)members[i];
                RolapAggregationManager.addNonConstrainingColumns(member, mapLevelToColumn, request);
                level = (RolapLevel)member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, mapLevelToColumn, request);
                if (!needToReturnNull) continue;
                return null;
            }
        } else {
            for (int i = 1; i < members.length; ++i) {
                member = (RolapMember)members[i];
                level = (RolapLevel)member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, mapLevelToColumn, request);
                if (!needToReturnNull) continue;
                return null;
            }
        }
        return request;
    }

    private static void addNonConstrainingColumns(RolapMember member, Map mapLevelToColumn, CellRequest request) {
        Hierarchy hierarchy = member.getHierarchy();
        Level[] levels = hierarchy.getLevels();
        int depth = member.getLevel().getDepth();
        for (int j = levels.length - 1; j > depth; --j) {
            RolapLevel level = (RolapLevel)levels[j];
            RolapStar.Column column = (RolapStar.Column)mapLevelToColumn.get(level);
            if (column == null) continue;
            request.addConstrainedColumn(column, null);
            if (!request.extendedContext || level.getNameExp() == null) continue;
            RolapStar.Column nameColumn = column.getNameColumn();
            Util.assertTrue(nameColumn != null);
            request.addConstrainedColumn(nameColumn, null);
        }
    }

    protected RolapAggregationManager() {
    }

    public Object getCellFromCache(Member[] members) {
        CellRequest request = RolapAggregationManager.makeRequest(members, false, false);
        return request == null ? Util.nullValue : this.getCellFromCache(request);
    }

    public abstract Object getCellFromCache(CellRequest var1);

    public abstract Object getCellFromCache(CellRequest var1, Set var2);

    public Object getCell(Member[] members) {
        CellRequest request = RolapAggregationManager.makeRequest(members, false, false);
        RolapStoredMeasure measure = (RolapStoredMeasure)members[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        Util.assertTrue(starMeasure != null);
        RolapStar star = starMeasure.getStar();
        return star.getCell(request);
    }

    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        return this.getCell(rolapEvaluator.getCurrentMembers());
    }

    public abstract String getDrillThroughSql(CellRequest var1, boolean var2);

    public int getMissCount() {
        return 0;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapAggregationManager == null ? (class$mondrian$rolap$RolapAggregationManager = RolapAggregationManager.class$("mondrian.rolap.RolapAggregationManager")) : class$mondrian$rolap$RolapAggregationManager).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

