/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Collections;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.DelegatingExpCompiler;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapResult;

public class RolapDependencyTestingEvaluator
extends RolapEvaluator {
    RolapDependencyTestingEvaluator(RolapResult result, int expDeps) {
        super(new DteRoot(result, expDeps));
    }

    private RolapDependencyTestingEvaluator(RolapEvaluator.RolapEvaluatorRoot root, RolapDependencyTestingEvaluator evaluator, CellReader cellReader, Member[] cloneCurrentMembers) {
        super(root, evaluator, cellReader, cloneCurrentMembers);
    }

    public Object evaluate(Calc calc, Dimension[] independentDimensions, String mdxString) {
        DteRoot dteRoot = (DteRoot)this.root;
        if (dteRoot.faking) {
            ++dteRoot.fakeCallCount;
        } else {
            ++dteRoot.callCount;
        }
        Object result = calc.evaluate(this);
        if (dteRoot.result.isDirty()) {
            return result;
        }
        if (dteRoot.disabled || dteRoot.faking || this.isNonEmpty() || (double)dteRoot.fakeCallCount > (double)dteRoot.callCount * dteRoot.random.nextDouble() * 2.0 * (double)dteRoot.expDeps) {
            return result;
        }
        if (independentDimensions.length == 0) {
            return result;
        }
        dteRoot.faking = true;
        ++dteRoot.fakeCount;
        ++dteRoot.fakeCallCount;
        int i = dteRoot.random.nextInt(independentDimensions.length);
        Member saveMember = this.getContext(independentDimensions[i]);
        Member otherMember = DteRoot.access$000(dteRoot, saveMember, this.getQuery().getSchemaReader(false));
        this.setContext(otherMember);
        Object otherResult = calc.evaluate(this);
        if (!this.equals(otherResult, result)) {
            Member[] members = this.getCurrentMembers();
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < members.length; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(members[j].getUniqueName());
            }
            throw Util.newInternal("Expression '" + mdxString + "' claims to be independent of dimension " + saveMember.getDimension() + " but is not; context is {" + buf.toString() + "}; First result: " + this.toString(result) + ", Second result: " + this.toString(otherResult));
        }
        this.setContext(saveMember);
        dteRoot.faking = false;
        return result;
    }

    public RolapEvaluator _push() {
        Member[] cloneCurrentMembers = (Member[])this.getCurrentMembers().clone();
        return new RolapDependencyTestingEvaluator(this.root, this, this.cellReader, cloneCurrentMembers);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Object[]) {
            Object[] a2;
            Object[] a1;
            if (o2 instanceof Object[] && (a1 = (Object[])o1).length == (a2 = (Object[])o2).length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (this.equals(a1[i], a2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o1 instanceof List) {
            if (o2 instanceof List) {
                return this.equals(((List)o1).toArray(), ((List)o2).toArray());
            }
            return false;
        }
        return o1.equals(o2);
    }

    private String toString(Object o) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toString(o, pw);
        return sw.toString();
    }

    private void toString(Object o, PrintWriter pw) {
        if (o instanceof Object[]) {
            Object[] a = (Object[])o;
            pw.print("{");
            for (int i = 0; i < a.length; ++i) {
                Object o1 = a[i];
                if (i > 0) {
                    pw.print(", ");
                }
                this.toString(o1, pw);
            }
            pw.print("}");
        } else if (o instanceof List) {
            List list = (List)o;
            this.toString(list.toArray(), pw);
        } else if (o instanceof Member) {
            Member member = (Member)o;
            pw.print(member.getUniqueName());
        } else {
            pw.print(o);
        }
    }

    static class DteCompiler
    extends DelegatingExpCompiler {
        DteCompiler(ExpCompiler compiler) {
            super(compiler);
        }

        protected Calc afterCompile(Exp exp, Calc calc, boolean mutable) {
            Dimension[] dimensions = this.getIndependentDimensions(calc);
            calc = super.afterCompile(exp, calc, mutable);
            return new DteCalcImpl(calc, dimensions, mutable, Util.unparse(exp));
        }

        private Dimension[] getIndependentDimensions(Calc calc) {
            ArrayList<Dimension> indDimList = new ArrayList<Dimension>();
            Dimension[] dims = this.getValidator().getQuery().getCube().getDimensions();
            for (int i = 0; i < dims.length; ++i) {
                Dimension dim = dims[i];
                if (calc.dependsOn(dim)) continue;
                indDimList.add(dim);
            }
            return indDimList.toArray(new Dimension[indDimList.size()]);
        }
    }

    private static class DteCalcImpl
    extends GenericCalc {
        private final Calc calc;
        private final Dimension[] independentDimensions;
        private final boolean mutableList;
        private final String mdxString;

        DteCalcImpl(Calc calc, Dimension[] independentDimensions, boolean mutableList, String mdxString) {
            super(new DummyExp(calc.getType()));
            this.calc = calc;
            this.independentDimensions = independentDimensions;
            this.mutableList = mutableList;
            this.mdxString = mdxString;
        }

        public Calc[] getCalcs() {
            return new Calc[]{this.calc};
        }

        public Object evaluate(Evaluator evaluator) {
            RolapDependencyTestingEvaluator dtEval = (RolapDependencyTestingEvaluator)evaluator;
            return dtEval.evaluate(this.calc, this.independentDimensions, this.mdxString);
        }

        public List evaluateList(Evaluator evaluator) {
            List list = super.evaluateList(evaluator);
            if (!this.mutableList) {
                list = Collections.unmodifiableList((List)list);
            }
            return list;
        }

        public ExpCompiler.ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }
    }

    static class DteRoot
    extends RolapResult.RolapResultEvaluatorRoot {
        final int expDeps;
        final RolapResult result;
        int callCount;
        int fakeCallCount;
        int fakeCount;
        boolean faking;
        boolean disabled;
        final Random random;

        DteRoot(RolapResult result, int expDeps) {
            super(result);
            this.random = Util.createRandom(MondrianProperties.instance().TestSeed.get());
            this.expDeps = expDeps;
            this.result = result;
        }

        private Member chooseOtherMember(Member save, SchemaReader schemaReader) {
            Member member;
            Hierarchy hierarchy = save.getHierarchy();
            int attempt = 0;
            do {
                Member[] members;
                Level[] levels = hierarchy.getLevels();
                int levelDepth = this.random.nextInt(levels.length) + 1;
                member = null;
                for (int i = 0; i < levelDepth && (members = i == 0 ? schemaReader.getLevelMembers(levels[i], false) : schemaReader.getMemberChildren(member)).length != 0; ++i) {
                    member = members[this.random.nextInt(members.length)];
                }
            } while (member == save && ++attempt <= 100);
            return member;
        }

        static Member access$000(DteRoot x0, Member x1, SchemaReader x2) {
            return x0.chooseOtherMember(x1, x2);
        }
    }
}

